# coding: utf-8

import pprint
import re

import six





class CreateMediaProcessReq:


    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    sensitive_list = []

    openapi_types = {
        'input': 'ObsObjInfo',
        'output': 'ObsObjInfo',
        'template_id': 'str'
    }

    attribute_map = {
        'input': 'input',
        'output': 'output',
        'template_id': 'template_id'
    }

    def __init__(self, input=None, output=None, template_id=None):
        """CreateMediaProcessReq - a model defined in huaweicloud sdk"""
        
        

        self._input = None
        self._output = None
        self._template_id = None
        self.discriminator = None

        if input is not None:
            self.input = input
        if output is not None:
            self.output = output
        if template_id is not None:
            self.template_id = template_id

    @property
    def input(self):
        """Gets the input of this CreateMediaProcessReq.


        :return: The input of this CreateMediaProcessReq.
        :rtype: ObsObjInfo
        """
        return self._input

    @input.setter
    def input(self, input):
        """Sets the input of this CreateMediaProcessReq.


        :param input: The input of this CreateMediaProcessReq.
        :type: ObsObjInfo
        """
        self._input = input

    @property
    def output(self):
        """Gets the output of this CreateMediaProcessReq.


        :return: The output of this CreateMediaProcessReq.
        :rtype: ObsObjInfo
        """
        return self._output

    @output.setter
    def output(self, output):
        """Sets the output of this CreateMediaProcessReq.


        :param output: The output of this CreateMediaProcessReq.
        :type: ObsObjInfo
        """
        self._output = output

    @property
    def template_id(self):
        """Gets the template_id of this CreateMediaProcessReq.

        模板ID 

        :return: The template_id of this CreateMediaProcessReq.
        :rtype: str
        """
        return self._template_id

    @template_id.setter
    def template_id(self, template_id):
        """Sets the template_id of this CreateMediaProcessReq.

        模板ID 

        :param template_id: The template_id of this CreateMediaProcessReq.
        :type: str
        """
        self._template_id = template_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                if attr in self.sensitive_list:
                    result[attr] = "****"
                else:
                    result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateMediaProcessReq):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
