# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'ProjectApplications',
    'ProjectApplicationsOidcApplication',
    'ProjectApplicationsSamlApplication',
    'ProjectApplicationsSamlApplicationAttributeMapping',
    'ProjectApplicationsSamlApplicationDynamicConfiguration',
    'ProjectApplicationsSamlApplicationManualConfiguration',
    'ProjectAttributes',
    'ProjectAttributesTenant',
    'ProjectAttributesTenantAuthorization',
    'ProjectAttributesUser',
    'ProjectAttributesUserWidgetAuthorization',
    'ProjectAuthentication',
    'ProjectAuthenticationEmbeddedLink',
    'ProjectAuthenticationEnchantedLink',
    'ProjectAuthenticationEnchantedLinkEmailService',
    'ProjectAuthenticationEnchantedLinkEmailServiceTemplate',
    'ProjectAuthenticationMagicLink',
    'ProjectAuthenticationMagicLinkEmailService',
    'ProjectAuthenticationMagicLinkEmailServiceTemplate',
    'ProjectAuthenticationMagicLinkTextService',
    'ProjectAuthenticationMagicLinkTextServiceTemplate',
    'ProjectAuthenticationOauth',
    'ProjectAuthenticationOauthCustom',
    'ProjectAuthenticationOauthCustomProviderTokenManagement',
    'ProjectAuthenticationOauthSystem',
    'ProjectAuthenticationOauthSystemApple',
    'ProjectAuthenticationOauthSystemAppleProviderTokenManagement',
    'ProjectAuthenticationOauthSystemDiscord',
    'ProjectAuthenticationOauthSystemDiscordProviderTokenManagement',
    'ProjectAuthenticationOauthSystemFacebook',
    'ProjectAuthenticationOauthSystemFacebookProviderTokenManagement',
    'ProjectAuthenticationOauthSystemGithub',
    'ProjectAuthenticationOauthSystemGithubProviderTokenManagement',
    'ProjectAuthenticationOauthSystemGitlab',
    'ProjectAuthenticationOauthSystemGitlabProviderTokenManagement',
    'ProjectAuthenticationOauthSystemGoogle',
    'ProjectAuthenticationOauthSystemGoogleProviderTokenManagement',
    'ProjectAuthenticationOauthSystemLinkedin',
    'ProjectAuthenticationOauthSystemLinkedinProviderTokenManagement',
    'ProjectAuthenticationOauthSystemMicrosoft',
    'ProjectAuthenticationOauthSystemMicrosoftProviderTokenManagement',
    'ProjectAuthenticationOauthSystemSlack',
    'ProjectAuthenticationOauthSystemSlackProviderTokenManagement',
    'ProjectAuthenticationOtp',
    'ProjectAuthenticationOtpEmailService',
    'ProjectAuthenticationOtpEmailServiceTemplate',
    'ProjectAuthenticationOtpTextService',
    'ProjectAuthenticationOtpTextServiceTemplate',
    'ProjectAuthenticationOtpVoiceService',
    'ProjectAuthenticationOtpVoiceServiceTemplate',
    'ProjectAuthenticationPasskeys',
    'ProjectAuthenticationPassword',
    'ProjectAuthenticationPasswordEmailService',
    'ProjectAuthenticationPasswordEmailServiceTemplate',
    'ProjectAuthenticationSso',
    'ProjectAuthenticationTotp',
    'ProjectAuthorization',
    'ProjectAuthorizationPermission',
    'ProjectAuthorizationRole',
    'ProjectConnectors',
    'ProjectConnectorsAbuseipdb',
    'ProjectConnectorsAmplitude',
    'ProjectConnectorsAuditWebhook',
    'ProjectConnectorsAuditWebhookAuditFilter',
    'ProjectConnectorsAuditWebhookAuthentication',
    'ProjectConnectorsAuditWebhookAuthenticationApiKey',
    'ProjectConnectorsAuditWebhookAuthenticationBasic',
    'ProjectConnectorsAwsS3',
    'ProjectConnectorsAwsS3AuditFilter',
    'ProjectConnectorsAwsTranslate',
    'ProjectConnectorsClear',
    'ProjectConnectorsDatadog',
    'ProjectConnectorsDatadogAuditFilter',
    'ProjectConnectorsDevrevGrow',
    'ProjectConnectorsDocebo',
    'ProjectConnectorsFingerprint',
    'ProjectConnectorsFingerprintDescope',
    'ProjectConnectorsForter',
    'ProjectConnectorsGenericSmsGateway',
    'ProjectConnectorsGenericSmsGatewayAuthentication',
    'ProjectConnectorsGenericSmsGatewayAuthenticationApiKey',
    'ProjectConnectorsGenericSmsGatewayAuthenticationBasic',
    'ProjectConnectorsGoogleCloudTranslation',
    'ProjectConnectorsHibp',
    'ProjectConnectorsHttp',
    'ProjectConnectorsHttpAuthentication',
    'ProjectConnectorsHttpAuthenticationApiKey',
    'ProjectConnectorsHttpAuthenticationBasic',
    'ProjectConnectorsHubspot',
    'ProjectConnectorsIncode',
    'ProjectConnectorsIntercom',
    'ProjectConnectorsLokalise',
    'ProjectConnectorsMparticle',
    'ProjectConnectorsNewrelic',
    'ProjectConnectorsNewrelicAuditFilter',
    'ProjectConnectorsRecaptcha',
    'ProjectConnectorsRecaptchaEnterprise',
    'ProjectConnectorsRekognition',
    'ProjectConnectorsSalesforce',
    'ProjectConnectorsSalesforceMarketingCloud',
    'ProjectConnectorsSe',
    'ProjectConnectorsSeSender',
    'ProjectConnectorsSegment',
    'ProjectConnectorsSendgrid',
    'ProjectConnectorsSendgridAuthentication',
    'ProjectConnectorsSendgridSender',
    'ProjectConnectorsSlack',
    'ProjectConnectorsSmartling',
    'ProjectConnectorsSmtp',
    'ProjectConnectorsSmtpAuthentication',
    'ProjectConnectorsSmtpSender',
    'ProjectConnectorsSmtpServer',
    'ProjectConnectorsSn',
    'ProjectConnectorsSumologic',
    'ProjectConnectorsSumologicAuditFilter',
    'ProjectConnectorsTelesign',
    'ProjectConnectorsTraceable',
    'ProjectConnectorsTwilioCore',
    'ProjectConnectorsTwilioCoreAuthentication',
    'ProjectConnectorsTwilioCoreSenders',
    'ProjectConnectorsTwilioCoreSendersSms',
    'ProjectConnectorsTwilioCoreSendersVoice',
    'ProjectConnectorsTwilioVerify',
    'ProjectConnectorsTwilioVerifyAuthentication',
    'ProjectFlows',
    'ProjectInviteSettings',
    'ProjectJwtTemplates',
    'ProjectJwtTemplatesAccessKeyTemplate',
    'ProjectJwtTemplatesUserTemplate',
    'ProjectProjectSettings',
    'ProjectStyles',
]

@pulumi.output_type
class ProjectApplications(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oidcApplications":
            suggest = "oidc_applications"
        elif key == "samlApplications":
            suggest = "saml_applications"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectApplications. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectApplications.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectApplications.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oidc_applications: Optional[Sequence['outputs.ProjectApplicationsOidcApplication']] = None,
                 saml_applications: Optional[Sequence['outputs.ProjectApplicationsSamlApplication']] = None):
        """
        :param Sequence['ProjectApplicationsOidcApplicationArgs'] oidc_applications: Applications using OpenID Connect (OIDC) for authentication.
        :param Sequence['ProjectApplicationsSamlApplicationArgs'] saml_applications: Applications using SAML for authentication.
        """
        if oidc_applications is not None:
            pulumi.set(__self__, "oidc_applications", oidc_applications)
        if saml_applications is not None:
            pulumi.set(__self__, "saml_applications", saml_applications)

    @property
    @pulumi.getter(name="oidcApplications")
    def oidc_applications(self) -> Optional[Sequence['outputs.ProjectApplicationsOidcApplication']]:
        """
        Applications using OpenID Connect (OIDC) for authentication.
        """
        return pulumi.get(self, "oidc_applications")

    @property
    @pulumi.getter(name="samlApplications")
    def saml_applications(self) -> Optional[Sequence['outputs.ProjectApplicationsSamlApplication']]:
        """
        Applications using SAML for authentication.
        """
        return pulumi.get(self, "saml_applications")


@pulumi.output_type
class ProjectApplicationsOidcApplication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forceAuthentication":
            suggest = "force_authentication"
        elif key == "loginPageUrl":
            suggest = "login_page_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectApplicationsOidcApplication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectApplicationsOidcApplication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectApplicationsOidcApplication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 claims: Optional[Sequence[str]] = None,
                 description: Optional[str] = None,
                 disabled: Optional[bool] = None,
                 force_authentication: Optional[bool] = None,
                 id: Optional[str] = None,
                 login_page_url: Optional[str] = None,
                 logo: Optional[str] = None):
        """
        :param str name: A name for the OIDC application.
        :param Sequence[str] claims: A list of supported claims. e.g. `sub`, `email`, `exp`.
        :param str description: A description for the OIDC application.
        :param bool disabled: Whether the application should be enabled or disabled.
        :param bool force_authentication: This configuration overrides the default behavior of the SSO application and forces the user to authenticate via the Descope flow, regardless of the SP's request.
        :param str id: An optional identifier for the OIDC application.
        :param str login_page_url: The Flow Hosting URL. Read more about using this parameter with custom domain [here](https://docs.descope.com/sso-integrations/applications/saml-apps).
        :param str logo: A logo for the OIDC application. Should be a hosted image URL.
        """
        pulumi.set(__self__, "name", name)
        if claims is not None:
            pulumi.set(__self__, "claims", claims)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if force_authentication is not None:
            pulumi.set(__self__, "force_authentication", force_authentication)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if login_page_url is not None:
            pulumi.set(__self__, "login_page_url", login_page_url)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A name for the OIDC application.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def claims(self) -> Optional[Sequence[str]]:
        """
        A list of supported claims. e.g. `sub`, `email`, `exp`.
        """
        return pulumi.get(self, "claims")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description for the OIDC application.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Whether the application should be enabled or disabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="forceAuthentication")
    def force_authentication(self) -> Optional[bool]:
        """
        This configuration overrides the default behavior of the SSO application and forces the user to authenticate via the Descope flow, regardless of the SP's request.
        """
        return pulumi.get(self, "force_authentication")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        An optional identifier for the OIDC application.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loginPageUrl")
    def login_page_url(self) -> Optional[str]:
        """
        The Flow Hosting URL. Read more about using this parameter with custom domain [here](https://docs.descope.com/sso-integrations/applications/saml-apps).
        """
        return pulumi.get(self, "login_page_url")

    @property
    @pulumi.getter
    def logo(self) -> Optional[str]:
        """
        A logo for the OIDC application. Should be a hosted image URL.
        """
        return pulumi.get(self, "logo")


@pulumi.output_type
class ProjectApplicationsSamlApplication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acsAllowedCallbackUrls":
            suggest = "acs_allowed_callback_urls"
        elif key == "attributeMappings":
            suggest = "attribute_mappings"
        elif key == "defaultRelayState":
            suggest = "default_relay_state"
        elif key == "dynamicConfiguration":
            suggest = "dynamic_configuration"
        elif key == "forceAuthentication":
            suggest = "force_authentication"
        elif key == "loginPageUrl":
            suggest = "login_page_url"
        elif key == "manualConfiguration":
            suggest = "manual_configuration"
        elif key == "subjectNameIdFormat":
            suggest = "subject_name_id_format"
        elif key == "subjectNameIdType":
            suggest = "subject_name_id_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectApplicationsSamlApplication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectApplicationsSamlApplication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectApplicationsSamlApplication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 acs_allowed_callback_urls: Optional[Sequence[str]] = None,
                 attribute_mappings: Optional[Sequence['outputs.ProjectApplicationsSamlApplicationAttributeMapping']] = None,
                 default_relay_state: Optional[str] = None,
                 description: Optional[str] = None,
                 disabled: Optional[bool] = None,
                 dynamic_configuration: Optional['outputs.ProjectApplicationsSamlApplicationDynamicConfiguration'] = None,
                 force_authentication: Optional[bool] = None,
                 id: Optional[str] = None,
                 login_page_url: Optional[str] = None,
                 logo: Optional[str] = None,
                 manual_configuration: Optional['outputs.ProjectApplicationsSamlApplicationManualConfiguration'] = None,
                 subject_name_id_format: Optional[str] = None,
                 subject_name_id_type: Optional[str] = None):
        """
        :param str name: A name for the SAML application.
        :param Sequence[str] acs_allowed_callback_urls: A list of allowed ACS callback URLS. This configuration is used when the default ACS URL value is unreachable. Supports wildcards.
        :param Sequence['ProjectApplicationsSamlApplicationAttributeMappingArgs'] attribute_mappings: The `AttributeMapping` object. Read the description below.
        :param str default_relay_state: The default relay state. When using IdP-initiated authentication, this value may be used as a URL to a resource in the Service Provider.
        :param str description: A description for the SAML application.
        :param bool disabled: Whether the application should be enabled or disabled.
        :param 'ProjectApplicationsSamlApplicationDynamicConfigurationArgs' dynamic_configuration: The `DynamicConfiguration` object. Read the description below.
        :param bool force_authentication: This configuration overrides the default behavior of the SSO application and forces the user to authenticate via the Descope flow, regardless of the SP's request.
        :param str id: An optional identifier for the SAML application.
        :param str login_page_url: The Flow Hosting URL. Read more about using this parameter with custom domain [here](https://docs.descope.com/sso-integrations/applications/saml-apps).
        :param str logo: A logo for the SAML application. Should be a hosted image URL.
        :param 'ProjectApplicationsSamlApplicationManualConfigurationArgs' manual_configuration: The `ManualConfiguration` object. Read the description below.
        :param str subject_name_id_format: The subject name id format. Choose one of "", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", "urn:oasis:names:tc:SAML:2.0:nameid-format:transient". Read more about this configuration [here](https://docs.descope.com/sso-integrations/applications/saml-apps).
        :param str subject_name_id_type: The subject name id type. Choose one of "", "email", "phone". Read more about this configuration [here](https://docs.descope.com/sso-integrations/applications/saml-apps).
        """
        pulumi.set(__self__, "name", name)
        if acs_allowed_callback_urls is not None:
            pulumi.set(__self__, "acs_allowed_callback_urls", acs_allowed_callback_urls)
        if attribute_mappings is not None:
            pulumi.set(__self__, "attribute_mappings", attribute_mappings)
        if default_relay_state is not None:
            pulumi.set(__self__, "default_relay_state", default_relay_state)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if dynamic_configuration is not None:
            pulumi.set(__self__, "dynamic_configuration", dynamic_configuration)
        if force_authentication is not None:
            pulumi.set(__self__, "force_authentication", force_authentication)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if login_page_url is not None:
            pulumi.set(__self__, "login_page_url", login_page_url)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if manual_configuration is not None:
            pulumi.set(__self__, "manual_configuration", manual_configuration)
        if subject_name_id_format is not None:
            pulumi.set(__self__, "subject_name_id_format", subject_name_id_format)
        if subject_name_id_type is not None:
            pulumi.set(__self__, "subject_name_id_type", subject_name_id_type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A name for the SAML application.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="acsAllowedCallbackUrls")
    def acs_allowed_callback_urls(self) -> Optional[Sequence[str]]:
        """
        A list of allowed ACS callback URLS. This configuration is used when the default ACS URL value is unreachable. Supports wildcards.
        """
        return pulumi.get(self, "acs_allowed_callback_urls")

    @property
    @pulumi.getter(name="attributeMappings")
    def attribute_mappings(self) -> Optional[Sequence['outputs.ProjectApplicationsSamlApplicationAttributeMapping']]:
        """
        The `AttributeMapping` object. Read the description below.
        """
        return pulumi.get(self, "attribute_mappings")

    @property
    @pulumi.getter(name="defaultRelayState")
    def default_relay_state(self) -> Optional[str]:
        """
        The default relay state. When using IdP-initiated authentication, this value may be used as a URL to a resource in the Service Provider.
        """
        return pulumi.get(self, "default_relay_state")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description for the SAML application.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Whether the application should be enabled or disabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="dynamicConfiguration")
    def dynamic_configuration(self) -> Optional['outputs.ProjectApplicationsSamlApplicationDynamicConfiguration']:
        """
        The `DynamicConfiguration` object. Read the description below.
        """
        return pulumi.get(self, "dynamic_configuration")

    @property
    @pulumi.getter(name="forceAuthentication")
    def force_authentication(self) -> Optional[bool]:
        """
        This configuration overrides the default behavior of the SSO application and forces the user to authenticate via the Descope flow, regardless of the SP's request.
        """
        return pulumi.get(self, "force_authentication")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        An optional identifier for the SAML application.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loginPageUrl")
    def login_page_url(self) -> Optional[str]:
        """
        The Flow Hosting URL. Read more about using this parameter with custom domain [here](https://docs.descope.com/sso-integrations/applications/saml-apps).
        """
        return pulumi.get(self, "login_page_url")

    @property
    @pulumi.getter
    def logo(self) -> Optional[str]:
        """
        A logo for the SAML application. Should be a hosted image URL.
        """
        return pulumi.get(self, "logo")

    @property
    @pulumi.getter(name="manualConfiguration")
    def manual_configuration(self) -> Optional['outputs.ProjectApplicationsSamlApplicationManualConfiguration']:
        """
        The `ManualConfiguration` object. Read the description below.
        """
        return pulumi.get(self, "manual_configuration")

    @property
    @pulumi.getter(name="subjectNameIdFormat")
    def subject_name_id_format(self) -> Optional[str]:
        """
        The subject name id format. Choose one of "", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", "urn:oasis:names:tc:SAML:2.0:nameid-format:transient". Read more about this configuration [here](https://docs.descope.com/sso-integrations/applications/saml-apps).
        """
        return pulumi.get(self, "subject_name_id_format")

    @property
    @pulumi.getter(name="subjectNameIdType")
    def subject_name_id_type(self) -> Optional[str]:
        """
        The subject name id type. Choose one of "", "email", "phone". Read more about this configuration [here](https://docs.descope.com/sso-integrations/applications/saml-apps).
        """
        return pulumi.get(self, "subject_name_id_type")


@pulumi.output_type
class ProjectApplicationsSamlApplicationAttributeMapping(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The name of the attribute.
        :param str value: The value of the attribute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the attribute.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ProjectApplicationsSamlApplicationDynamicConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metadataUrl":
            suggest = "metadata_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectApplicationsSamlApplicationDynamicConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectApplicationsSamlApplicationDynamicConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectApplicationsSamlApplicationDynamicConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metadata_url: str):
        """
        :param str metadata_url: The metadata URL when retrieving the connection details dynamically.
        """
        pulumi.set(__self__, "metadata_url", metadata_url)

    @property
    @pulumi.getter(name="metadataUrl")
    def metadata_url(self) -> str:
        """
        The metadata URL when retrieving the connection details dynamically.
        """
        return pulumi.get(self, "metadata_url")


@pulumi.output_type
class ProjectApplicationsSamlApplicationManualConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acsUrl":
            suggest = "acs_url"
        elif key == "entityId":
            suggest = "entity_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectApplicationsSamlApplicationManualConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectApplicationsSamlApplicationManualConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectApplicationsSamlApplicationManualConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acs_url: str,
                 certificate: str,
                 entity_id: str):
        """
        :param str acs_url: Enter the `ACS URL` from the SP.
        :param str certificate: Enter the `Certificate` from the SP.
        :param str entity_id: Enter the `Entity Id` from the SP.
        """
        pulumi.set(__self__, "acs_url", acs_url)
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "entity_id", entity_id)

    @property
    @pulumi.getter(name="acsUrl")
    def acs_url(self) -> str:
        """
        Enter the `ACS URL` from the SP.
        """
        return pulumi.get(self, "acs_url")

    @property
    @pulumi.getter
    def certificate(self) -> str:
        """
        Enter the `Certificate` from the SP.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> str:
        """
        Enter the `Entity Id` from the SP.
        """
        return pulumi.get(self, "entity_id")


@pulumi.output_type
class ProjectAttributes(dict):
    def __init__(__self__, *,
                 tenants: Optional[Sequence['outputs.ProjectAttributesTenant']] = None,
                 users: Optional[Sequence['outputs.ProjectAttributesUser']] = None):
        """
        :param Sequence['ProjectAttributesTenantArgs'] tenants: A list of `TenantAttribute`. Read the description below.
        :param Sequence['ProjectAttributesUserArgs'] users: A list of `UserAttribute`. Read the description below.
        """
        if tenants is not None:
            pulumi.set(__self__, "tenants", tenants)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def tenants(self) -> Optional[Sequence['outputs.ProjectAttributesTenant']]:
        """
        A list of `TenantAttribute`. Read the description below.
        """
        return pulumi.get(self, "tenants")

    @property
    @pulumi.getter
    def users(self) -> Optional[Sequence['outputs.ProjectAttributesUser']]:
        """
        A list of `UserAttribute`. Read the description below.
        """
        return pulumi.get(self, "users")


@pulumi.output_type
class ProjectAttributesTenant(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "selectOptions":
            suggest = "select_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAttributesTenant. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAttributesTenant.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAttributesTenant.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: str,
                 authorization: Optional['outputs.ProjectAttributesTenantAuthorization'] = None,
                 select_options: Optional[Sequence[str]] = None):
        """
        :param str name: The name of the attribute.
        :param str type: The type of the attribute. Choose one of "string", "number", "boolean", "singleselect", "multiselect", "date".
        :param Sequence[str] select_options: When the attribute type is "multiselect". A list of options to chose from.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if select_options is not None:
            pulumi.set(__self__, "select_options", select_options)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the attribute. Choose one of "string", "number", "boolean", "singleselect", "multiselect", "date".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def authorization(self) -> Optional['outputs.ProjectAttributesTenantAuthorization']:
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="selectOptions")
    def select_options(self) -> Optional[Sequence[str]]:
        """
        When the attribute type is "multiselect". A list of options to chose from.
        """
        return pulumi.get(self, "select_options")


@pulumi.output_type
class ProjectAttributesTenantAuthorization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "viewPermissions":
            suggest = "view_permissions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAttributesTenantAuthorization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAttributesTenantAuthorization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAttributesTenantAuthorization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 view_permissions: Optional[Sequence[str]] = None):
        if view_permissions is not None:
            pulumi.set(__self__, "view_permissions", view_permissions)

    @property
    @pulumi.getter(name="viewPermissions")
    def view_permissions(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "view_permissions")


@pulumi.output_type
class ProjectAttributesUser(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "selectOptions":
            suggest = "select_options"
        elif key == "widgetAuthorization":
            suggest = "widget_authorization"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAttributesUser. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAttributesUser.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAttributesUser.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: str,
                 select_options: Optional[Sequence[str]] = None,
                 widget_authorization: Optional['outputs.ProjectAttributesUserWidgetAuthorization'] = None):
        """
        :param str name: The name of the attribute.
        :param str type: The type of the attribute. Choose one of "string", "number", "boolean", "singleselect", "multiselect", "date".
        :param Sequence[str] select_options: When the attribute type is "multiselect". A list of options to chose from.
        :param 'ProjectAttributesUserWidgetAuthorizationArgs' widget_authorization: The `UserAttributeWidgetAuthorization` object. Read the description below.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if select_options is not None:
            pulumi.set(__self__, "select_options", select_options)
        if widget_authorization is not None:
            pulumi.set(__self__, "widget_authorization", widget_authorization)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the attribute. Choose one of "string", "number", "boolean", "singleselect", "multiselect", "date".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="selectOptions")
    def select_options(self) -> Optional[Sequence[str]]:
        """
        When the attribute type is "multiselect". A list of options to chose from.
        """
        return pulumi.get(self, "select_options")

    @property
    @pulumi.getter(name="widgetAuthorization")
    def widget_authorization(self) -> Optional['outputs.ProjectAttributesUserWidgetAuthorization']:
        """
        The `UserAttributeWidgetAuthorization` object. Read the description below.
        """
        return pulumi.get(self, "widget_authorization")


@pulumi.output_type
class ProjectAttributesUserWidgetAuthorization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "editPermissions":
            suggest = "edit_permissions"
        elif key == "viewPermissions":
            suggest = "view_permissions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAttributesUserWidgetAuthorization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAttributesUserWidgetAuthorization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAttributesUserWidgetAuthorization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 edit_permissions: Optional[Sequence[str]] = None,
                 view_permissions: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] edit_permissions: A list of permissions by name to set editing permissions to the attribute in widgets. e.g "SSO Admin".
        :param Sequence[str] view_permissions: A list of permissions by name to set viewing permissions to the attribute in widgets. e.g "SSO Admin".
        """
        if edit_permissions is not None:
            pulumi.set(__self__, "edit_permissions", edit_permissions)
        if view_permissions is not None:
            pulumi.set(__self__, "view_permissions", view_permissions)

    @property
    @pulumi.getter(name="editPermissions")
    def edit_permissions(self) -> Optional[Sequence[str]]:
        """
        A list of permissions by name to set editing permissions to the attribute in widgets. e.g "SSO Admin".
        """
        return pulumi.get(self, "edit_permissions")

    @property
    @pulumi.getter(name="viewPermissions")
    def view_permissions(self) -> Optional[Sequence[str]]:
        """
        A list of permissions by name to set viewing permissions to the attribute in widgets. e.g "SSO Admin".
        """
        return pulumi.get(self, "view_permissions")


@pulumi.output_type
class ProjectAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "embeddedLink":
            suggest = "embedded_link"
        elif key == "enchantedLink":
            suggest = "enchanted_link"
        elif key == "magicLink":
            suggest = "magic_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 embedded_link: Optional['outputs.ProjectAuthenticationEmbeddedLink'] = None,
                 enchanted_link: Optional['outputs.ProjectAuthenticationEnchantedLink'] = None,
                 magic_link: Optional['outputs.ProjectAuthenticationMagicLink'] = None,
                 oauth: Optional['outputs.ProjectAuthenticationOauth'] = None,
                 otp: Optional['outputs.ProjectAuthenticationOtp'] = None,
                 passkeys: Optional['outputs.ProjectAuthenticationPasskeys'] = None,
                 password: Optional['outputs.ProjectAuthenticationPassword'] = None,
                 sso: Optional['outputs.ProjectAuthenticationSso'] = None,
                 totp: Optional['outputs.ProjectAuthenticationTotp'] = None):
        """
        :param 'ProjectAuthenticationEmbeddedLinkArgs' embedded_link: Make the authentication experience smoother for the user by generating their initial token in a way that does not require the end user to initiate the process, requiring only verification.
        :param 'ProjectAuthenticationEnchantedLinkArgs' enchanted_link: An enhanced and more secure version of Magic Link, enabling users to start the authentication process on one device and execute the verification on another.
        :param 'ProjectAuthenticationMagicLinkArgs' magic_link: An authentication method where a user receives a unique link via email to log in.
        :param 'ProjectAuthenticationOauthArgs' oauth: Authentication using Open Authorization, which allows users to authenticate with various external services.
        :param 'ProjectAuthenticationOtpArgs' otp: A dynamically generated set of numbers, granting the user one-time access.
        :param 'ProjectAuthenticationPasskeysArgs' passkeys: Device-based passwordless authentication, using fingerprint, face scan, and more.
        :param 'ProjectAuthenticationPasswordArgs' password: The classic username and password combination used for authentication.
        :param 'ProjectAuthenticationSsoArgs' sso: Single Sign-On (SSO) authentication method that enables users to access multiple applications with a single set of credentials.
        :param 'ProjectAuthenticationTotpArgs' totp: A one-time code generated for the user using a shared secret and time.
        """
        if embedded_link is not None:
            pulumi.set(__self__, "embedded_link", embedded_link)
        if enchanted_link is not None:
            pulumi.set(__self__, "enchanted_link", enchanted_link)
        if magic_link is not None:
            pulumi.set(__self__, "magic_link", magic_link)
        if oauth is not None:
            pulumi.set(__self__, "oauth", oauth)
        if otp is not None:
            pulumi.set(__self__, "otp", otp)
        if passkeys is not None:
            pulumi.set(__self__, "passkeys", passkeys)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if sso is not None:
            pulumi.set(__self__, "sso", sso)
        if totp is not None:
            pulumi.set(__self__, "totp", totp)

    @property
    @pulumi.getter(name="embeddedLink")
    def embedded_link(self) -> Optional['outputs.ProjectAuthenticationEmbeddedLink']:
        """
        Make the authentication experience smoother for the user by generating their initial token in a way that does not require the end user to initiate the process, requiring only verification.
        """
        return pulumi.get(self, "embedded_link")

    @property
    @pulumi.getter(name="enchantedLink")
    def enchanted_link(self) -> Optional['outputs.ProjectAuthenticationEnchantedLink']:
        """
        An enhanced and more secure version of Magic Link, enabling users to start the authentication process on one device and execute the verification on another.
        """
        return pulumi.get(self, "enchanted_link")

    @property
    @pulumi.getter(name="magicLink")
    def magic_link(self) -> Optional['outputs.ProjectAuthenticationMagicLink']:
        """
        An authentication method where a user receives a unique link via email to log in.
        """
        return pulumi.get(self, "magic_link")

    @property
    @pulumi.getter
    def oauth(self) -> Optional['outputs.ProjectAuthenticationOauth']:
        """
        Authentication using Open Authorization, which allows users to authenticate with various external services.
        """
        return pulumi.get(self, "oauth")

    @property
    @pulumi.getter
    def otp(self) -> Optional['outputs.ProjectAuthenticationOtp']:
        """
        A dynamically generated set of numbers, granting the user one-time access.
        """
        return pulumi.get(self, "otp")

    @property
    @pulumi.getter
    def passkeys(self) -> Optional['outputs.ProjectAuthenticationPasskeys']:
        """
        Device-based passwordless authentication, using fingerprint, face scan, and more.
        """
        return pulumi.get(self, "passkeys")

    @property
    @pulumi.getter
    def password(self) -> Optional['outputs.ProjectAuthenticationPassword']:
        """
        The classic username and password combination used for authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def sso(self) -> Optional['outputs.ProjectAuthenticationSso']:
        """
        Single Sign-On (SSO) authentication method that enables users to access multiple applications with a single set of credentials.
        """
        return pulumi.get(self, "sso")

    @property
    @pulumi.getter
    def totp(self) -> Optional['outputs.ProjectAuthenticationTotp']:
        """
        A one-time code generated for the user using a shared secret and time.
        """
        return pulumi.get(self, "totp")


@pulumi.output_type
class ProjectAuthenticationEmbeddedLink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationTime":
            suggest = "expiration_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationEmbeddedLink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationEmbeddedLink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationEmbeddedLink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled: Optional[bool] = None,
                 expiration_time: Optional[str] = None):
        """
        :param bool disabled: Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        :param str expiration_time: The amount of time that the embedded link will be valid for.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[str]:
        """
        The amount of time that the embedded link will be valid for.
        """
        return pulumi.get(self, "expiration_time")


@pulumi.output_type
class ProjectAuthenticationEnchantedLink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailService":
            suggest = "email_service"
        elif key == "expirationTime":
            suggest = "expiration_time"
        elif key == "redirectUrl":
            suggest = "redirect_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationEnchantedLink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationEnchantedLink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationEnchantedLink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled: Optional[bool] = None,
                 email_service: Optional['outputs.ProjectAuthenticationEnchantedLinkEmailService'] = None,
                 expiration_time: Optional[str] = None,
                 redirect_url: Optional[str] = None):
        """
        :param bool disabled: Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        :param 'ProjectAuthenticationEnchantedLinkEmailServiceArgs' email_service: Settings related to sending emails as part of the enchanted link authentication.
        :param str redirect_url: The URL to redirect users to after they log in using the enchanted link.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if email_service is not None:
            pulumi.set(__self__, "email_service", email_service)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="emailService")
    def email_service(self) -> Optional['outputs.ProjectAuthenticationEnchantedLinkEmailService']:
        """
        Settings related to sending emails as part of the enchanted link authentication.
        """
        return pulumi.get(self, "email_service")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[str]:
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[str]:
        """
        The URL to redirect users to after they log in using the enchanted link.
        """
        return pulumi.get(self, "redirect_url")


@pulumi.output_type
class ProjectAuthenticationEnchantedLinkEmailService(dict):
    def __init__(__self__, *,
                 connector: str,
                 templates: Optional[Sequence['outputs.ProjectAuthenticationEnchantedLinkEmailServiceTemplate']] = None):
        pulumi.set(__self__, "connector", connector)
        if templates is not None:
            pulumi.set(__self__, "templates", templates)

    @property
    @pulumi.getter
    def connector(self) -> str:
        return pulumi.get(self, "connector")

    @property
    @pulumi.getter
    def templates(self) -> Optional[Sequence['outputs.ProjectAuthenticationEnchantedLinkEmailServiceTemplate']]:
        return pulumi.get(self, "templates")


@pulumi.output_type
class ProjectAuthenticationEnchantedLinkEmailServiceTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "htmlBody":
            suggest = "html_body"
        elif key == "plainTextBody":
            suggest = "plain_text_body"
        elif key == "usePlainTextBody":
            suggest = "use_plain_text_body"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationEnchantedLinkEmailServiceTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationEnchantedLinkEmailServiceTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationEnchantedLinkEmailServiceTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 subject: str,
                 active: Optional[bool] = None,
                 html_body: Optional[str] = None,
                 id: Optional[str] = None,
                 plain_text_body: Optional[str] = None,
                 use_plain_text_body: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "subject", subject)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if html_body is not None:
            pulumi.set(__self__, "html_body", html_body)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if plain_text_body is not None:
            pulumi.set(__self__, "plain_text_body", plain_text_body)
        if use_plain_text_body is not None:
            pulumi.set(__self__, "use_plain_text_body", use_plain_text_body)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def subject(self) -> str:
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def active(self) -> Optional[bool]:
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="htmlBody")
    def html_body(self) -> Optional[str]:
        return pulumi.get(self, "html_body")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="plainTextBody")
    def plain_text_body(self) -> Optional[str]:
        return pulumi.get(self, "plain_text_body")

    @property
    @pulumi.getter(name="usePlainTextBody")
    def use_plain_text_body(self) -> Optional[bool]:
        return pulumi.get(self, "use_plain_text_body")


@pulumi.output_type
class ProjectAuthenticationMagicLink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailService":
            suggest = "email_service"
        elif key == "expirationTime":
            suggest = "expiration_time"
        elif key == "redirectUrl":
            suggest = "redirect_url"
        elif key == "textService":
            suggest = "text_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationMagicLink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationMagicLink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationMagicLink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled: Optional[bool] = None,
                 email_service: Optional['outputs.ProjectAuthenticationMagicLinkEmailService'] = None,
                 expiration_time: Optional[str] = None,
                 redirect_url: Optional[str] = None,
                 text_service: Optional['outputs.ProjectAuthenticationMagicLinkTextService'] = None):
        """
        :param bool disabled: Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        :param 'ProjectAuthenticationMagicLinkEmailServiceArgs' email_service: Settings related to sending emails as part of the magic link authentication.
        :param str redirect_url: The URL to redirect users to after they log in using the magic link.
        :param 'ProjectAuthenticationMagicLinkTextServiceArgs' text_service: Settings related to sending SMS messages as part of the magic link authentication.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if email_service is not None:
            pulumi.set(__self__, "email_service", email_service)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if text_service is not None:
            pulumi.set(__self__, "text_service", text_service)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="emailService")
    def email_service(self) -> Optional['outputs.ProjectAuthenticationMagicLinkEmailService']:
        """
        Settings related to sending emails as part of the magic link authentication.
        """
        return pulumi.get(self, "email_service")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[str]:
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[str]:
        """
        The URL to redirect users to after they log in using the magic link.
        """
        return pulumi.get(self, "redirect_url")

    @property
    @pulumi.getter(name="textService")
    def text_service(self) -> Optional['outputs.ProjectAuthenticationMagicLinkTextService']:
        """
        Settings related to sending SMS messages as part of the magic link authentication.
        """
        return pulumi.get(self, "text_service")


@pulumi.output_type
class ProjectAuthenticationMagicLinkEmailService(dict):
    def __init__(__self__, *,
                 connector: str,
                 templates: Optional[Sequence['outputs.ProjectAuthenticationMagicLinkEmailServiceTemplate']] = None):
        pulumi.set(__self__, "connector", connector)
        if templates is not None:
            pulumi.set(__self__, "templates", templates)

    @property
    @pulumi.getter
    def connector(self) -> str:
        return pulumi.get(self, "connector")

    @property
    @pulumi.getter
    def templates(self) -> Optional[Sequence['outputs.ProjectAuthenticationMagicLinkEmailServiceTemplate']]:
        return pulumi.get(self, "templates")


@pulumi.output_type
class ProjectAuthenticationMagicLinkEmailServiceTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "htmlBody":
            suggest = "html_body"
        elif key == "plainTextBody":
            suggest = "plain_text_body"
        elif key == "usePlainTextBody":
            suggest = "use_plain_text_body"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationMagicLinkEmailServiceTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationMagicLinkEmailServiceTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationMagicLinkEmailServiceTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 subject: str,
                 active: Optional[bool] = None,
                 html_body: Optional[str] = None,
                 id: Optional[str] = None,
                 plain_text_body: Optional[str] = None,
                 use_plain_text_body: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "subject", subject)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if html_body is not None:
            pulumi.set(__self__, "html_body", html_body)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if plain_text_body is not None:
            pulumi.set(__self__, "plain_text_body", plain_text_body)
        if use_plain_text_body is not None:
            pulumi.set(__self__, "use_plain_text_body", use_plain_text_body)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def subject(self) -> str:
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def active(self) -> Optional[bool]:
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="htmlBody")
    def html_body(self) -> Optional[str]:
        return pulumi.get(self, "html_body")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="plainTextBody")
    def plain_text_body(self) -> Optional[str]:
        return pulumi.get(self, "plain_text_body")

    @property
    @pulumi.getter(name="usePlainTextBody")
    def use_plain_text_body(self) -> Optional[bool]:
        return pulumi.get(self, "use_plain_text_body")


@pulumi.output_type
class ProjectAuthenticationMagicLinkTextService(dict):
    def __init__(__self__, *,
                 connector: str,
                 templates: Optional[Sequence['outputs.ProjectAuthenticationMagicLinkTextServiceTemplate']] = None):
        pulumi.set(__self__, "connector", connector)
        if templates is not None:
            pulumi.set(__self__, "templates", templates)

    @property
    @pulumi.getter
    def connector(self) -> str:
        return pulumi.get(self, "connector")

    @property
    @pulumi.getter
    def templates(self) -> Optional[Sequence['outputs.ProjectAuthenticationMagicLinkTextServiceTemplate']]:
        return pulumi.get(self, "templates")


@pulumi.output_type
class ProjectAuthenticationMagicLinkTextServiceTemplate(dict):
    def __init__(__self__, *,
                 body: str,
                 name: str,
                 active: Optional[bool] = None,
                 id: Optional[str] = None):
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "name", name)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def body(self) -> str:
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def active(self) -> Optional[bool]:
        return pulumi.get(self, "active")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectAuthenticationOauth(dict):
    def __init__(__self__, *,
                 custom: Optional[Mapping[str, 'outputs.ProjectAuthenticationOauthCustom']] = None,
                 disabled: Optional[bool] = None,
                 system: Optional['outputs.ProjectAuthenticationOauthSystem'] = None):
        """
        :param Mapping[str, 'ProjectAuthenticationOauthCustomArgs'] custom: Custom OAuth providers configured for this project.
        :param bool disabled: Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        :param 'ProjectAuthenticationOauthSystemArgs' system: Custom configurations for builtin OAuth providers such as Apple, Google, GitHub, Facebook, etc.
        """
        if custom is not None:
            pulumi.set(__self__, "custom", custom)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if system is not None:
            pulumi.set(__self__, "system", system)

    @property
    @pulumi.getter
    def custom(self) -> Optional[Mapping[str, 'outputs.ProjectAuthenticationOauthCustom']]:
        """
        Custom OAuth providers configured for this project.
        """
        return pulumi.get(self, "custom")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def system(self) -> Optional['outputs.ProjectAuthenticationOauthSystem']:
        """
        Custom configurations for builtin OAuth providers such as Apple, Google, GitHub, Facebook, etc.
        """
        return pulumi.get(self, "system")


@pulumi.output_type
class ProjectAuthenticationOauthCustom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedGrantTypes":
            suggest = "allowed_grant_types"
        elif key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "claimMapping":
            suggest = "claim_mapping"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "jwksEndpoint":
            suggest = "jwks_endpoint"
        elif key == "mergeUserAccounts":
            suggest = "merge_user_accounts"
        elif key == "providerTokenManagement":
            suggest = "provider_token_management"
        elif key == "tokenEndpoint":
            suggest = "token_endpoint"
        elif key == "userInfoEndpoint":
            suggest = "user_info_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOauthCustom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOauthCustom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOauthCustom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_grant_types: Optional[Sequence[str]] = None,
                 authorization_endpoint: Optional[str] = None,
                 claim_mapping: Optional[Mapping[str, str]] = None,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 description: Optional[str] = None,
                 disabled: Optional[bool] = None,
                 issuer: Optional[str] = None,
                 jwks_endpoint: Optional[str] = None,
                 logo: Optional[str] = None,
                 merge_user_accounts: Optional[bool] = None,
                 prompts: Optional[Sequence[str]] = None,
                 provider_token_management: Optional['outputs.ProjectAuthenticationOauthCustomProviderTokenManagement'] = None,
                 scopes: Optional[Sequence[str]] = None,
                 token_endpoint: Optional[str] = None,
                 user_info_endpoint: Optional[str] = None):
        """
        :param Sequence[str] allowed_grant_types: The type of grants (`authorization_code` or `implicit`) to allow when requesting access tokens from the OAuth provider.
        :param str authorization_endpoint: The URL that users are redirected to for authorization with the OAuth provider.
        :param str client_id: The client ID for the OAuth provider, used to identify the application to the provider.
        :param str client_secret: The client secret for the OAuth provider, used to authenticate the application with the provider.
        :param str description: A brief description of the OAuth provider.
        :param bool disabled: Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        :param str jwks_endpoint: The URL where the application can retrieve JSON Web Key Sets (JWKS) for the OAuth provider.
        :param str logo: The URL of the logo associated with the OAuth provider.
        :param bool merge_user_accounts: Whether to merge existing user accounts with new ones created through OAuth authentication.
        :param Sequence[str] prompts: Custom prompts or consent screens that users may see during OAuth authentication.
        :param 'ProjectAuthenticationOauthCustomProviderTokenManagementArgs' provider_token_management: Settings related to token management for the OAuth provider.
        :param Sequence[str] scopes: Scopes of access that the application requests from the user's account on the OAuth provider.
        :param str token_endpoint: The URL where the application requests an access token from the OAuth provider.
        :param str user_info_endpoint: The URL where the application retrieves user information from the OAuth provider.
        """
        if allowed_grant_types is not None:
            pulumi.set(__self__, "allowed_grant_types", allowed_grant_types)
        if authorization_endpoint is not None:
            pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        if claim_mapping is not None:
            pulumi.set(__self__, "claim_mapping", claim_mapping)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if jwks_endpoint is not None:
            pulumi.set(__self__, "jwks_endpoint", jwks_endpoint)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if merge_user_accounts is not None:
            pulumi.set(__self__, "merge_user_accounts", merge_user_accounts)
        if prompts is not None:
            pulumi.set(__self__, "prompts", prompts)
        if provider_token_management is not None:
            pulumi.set(__self__, "provider_token_management", provider_token_management)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)
        if user_info_endpoint is not None:
            pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)

    @property
    @pulumi.getter(name="allowedGrantTypes")
    def allowed_grant_types(self) -> Optional[Sequence[str]]:
        """
        The type of grants (`authorization_code` or `implicit`) to allow when requesting access tokens from the OAuth provider.
        """
        return pulumi.get(self, "allowed_grant_types")

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> Optional[str]:
        """
        The URL that users are redirected to for authorization with the OAuth provider.
        """
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="claimMapping")
    def claim_mapping(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "claim_mapping")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The client ID for the OAuth provider, used to identify the application to the provider.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        The client secret for the OAuth provider, used to authenticate the application with the provider.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A brief description of the OAuth provider.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[str]:
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="jwksEndpoint")
    def jwks_endpoint(self) -> Optional[str]:
        """
        The URL where the application can retrieve JSON Web Key Sets (JWKS) for the OAuth provider.
        """
        return pulumi.get(self, "jwks_endpoint")

    @property
    @pulumi.getter
    def logo(self) -> Optional[str]:
        """
        The URL of the logo associated with the OAuth provider.
        """
        return pulumi.get(self, "logo")

    @property
    @pulumi.getter(name="mergeUserAccounts")
    def merge_user_accounts(self) -> Optional[bool]:
        """
        Whether to merge existing user accounts with new ones created through OAuth authentication.
        """
        return pulumi.get(self, "merge_user_accounts")

    @property
    @pulumi.getter
    def prompts(self) -> Optional[Sequence[str]]:
        """
        Custom prompts or consent screens that users may see during OAuth authentication.
        """
        return pulumi.get(self, "prompts")

    @property
    @pulumi.getter(name="providerTokenManagement")
    def provider_token_management(self) -> Optional['outputs.ProjectAuthenticationOauthCustomProviderTokenManagement']:
        """
        Settings related to token management for the OAuth provider.
        """
        return pulumi.get(self, "provider_token_management")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        Scopes of access that the application requests from the user's account on the OAuth provider.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[str]:
        """
        The URL where the application requests an access token from the OAuth provider.
        """
        return pulumi.get(self, "token_endpoint")

    @property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> Optional[str]:
        """
        The URL where the application retrieves user information from the OAuth provider.
        """
        return pulumi.get(self, "user_info_endpoint")


@pulumi.output_type
class ProjectAuthenticationOauthCustomProviderTokenManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callbackDomain":
            suggest = "callback_domain"
        elif key == "redirectUrl":
            suggest = "redirect_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOauthCustomProviderTokenManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOauthCustomProviderTokenManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOauthCustomProviderTokenManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 callback_domain: Optional[str] = None,
                 redirect_url: Optional[str] = None):
        if callback_domain is not None:
            pulumi.set(__self__, "callback_domain", callback_domain)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)

    @property
    @pulumi.getter(name="callbackDomain")
    def callback_domain(self) -> Optional[str]:
        return pulumi.get(self, "callback_domain")

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[str]:
        return pulumi.get(self, "redirect_url")


@pulumi.output_type
class ProjectAuthenticationOauthSystem(dict):
    def __init__(__self__, *,
                 apple: Optional['outputs.ProjectAuthenticationOauthSystemApple'] = None,
                 discord: Optional['outputs.ProjectAuthenticationOauthSystemDiscord'] = None,
                 facebook: Optional['outputs.ProjectAuthenticationOauthSystemFacebook'] = None,
                 github: Optional['outputs.ProjectAuthenticationOauthSystemGithub'] = None,
                 gitlab: Optional['outputs.ProjectAuthenticationOauthSystemGitlab'] = None,
                 google: Optional['outputs.ProjectAuthenticationOauthSystemGoogle'] = None,
                 linkedin: Optional['outputs.ProjectAuthenticationOauthSystemLinkedin'] = None,
                 microsoft: Optional['outputs.ProjectAuthenticationOauthSystemMicrosoft'] = None,
                 slack: Optional['outputs.ProjectAuthenticationOauthSystemSlack'] = None):
        """
        :param 'ProjectAuthenticationOauthSystemAppleArgs' apple: Apple's OAuth provider, allowing users to authenticate with their Apple Account.
        :param 'ProjectAuthenticationOauthSystemDiscordArgs' discord: Discord's OAuth provider, allowing users to authenticate with their Discord account.
        :param 'ProjectAuthenticationOauthSystemFacebookArgs' facebook: Facebook's OAuth provider, allowing users to authenticate with their Facebook account.
        :param 'ProjectAuthenticationOauthSystemGithubArgs' github: GitHub's OAuth provider, allowing users to authenticate with their GitHub account.
        :param 'ProjectAuthenticationOauthSystemGitlabArgs' gitlab: GitLab's OAuth provider, allowing users to authenticate with their GitLab account.
        :param 'ProjectAuthenticationOauthSystemGoogleArgs' google: Google's OAuth provider, allowing users to authenticate with their Google account.
        :param 'ProjectAuthenticationOauthSystemLinkedinArgs' linkedin: LinkedIn's OAuth provider, allowing users to authenticate with their LinkedIn account.
        :param 'ProjectAuthenticationOauthSystemMicrosoftArgs' microsoft: Microsoft's OAuth provider, allowing users to authenticate with their Microsoft account.
        :param 'ProjectAuthenticationOauthSystemSlackArgs' slack: Slack's OAuth provider, allowing users to authenticate with their Slack account.
        """
        if apple is not None:
            pulumi.set(__self__, "apple", apple)
        if discord is not None:
            pulumi.set(__self__, "discord", discord)
        if facebook is not None:
            pulumi.set(__self__, "facebook", facebook)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if google is not None:
            pulumi.set(__self__, "google", google)
        if linkedin is not None:
            pulumi.set(__self__, "linkedin", linkedin)
        if microsoft is not None:
            pulumi.set(__self__, "microsoft", microsoft)
        if slack is not None:
            pulumi.set(__self__, "slack", slack)

    @property
    @pulumi.getter
    def apple(self) -> Optional['outputs.ProjectAuthenticationOauthSystemApple']:
        """
        Apple's OAuth provider, allowing users to authenticate with their Apple Account.
        """
        return pulumi.get(self, "apple")

    @property
    @pulumi.getter
    def discord(self) -> Optional['outputs.ProjectAuthenticationOauthSystemDiscord']:
        """
        Discord's OAuth provider, allowing users to authenticate with their Discord account.
        """
        return pulumi.get(self, "discord")

    @property
    @pulumi.getter
    def facebook(self) -> Optional['outputs.ProjectAuthenticationOauthSystemFacebook']:
        """
        Facebook's OAuth provider, allowing users to authenticate with their Facebook account.
        """
        return pulumi.get(self, "facebook")

    @property
    @pulumi.getter
    def github(self) -> Optional['outputs.ProjectAuthenticationOauthSystemGithub']:
        """
        GitHub's OAuth provider, allowing users to authenticate with their GitHub account.
        """
        return pulumi.get(self, "github")

    @property
    @pulumi.getter
    def gitlab(self) -> Optional['outputs.ProjectAuthenticationOauthSystemGitlab']:
        """
        GitLab's OAuth provider, allowing users to authenticate with their GitLab account.
        """
        return pulumi.get(self, "gitlab")

    @property
    @pulumi.getter
    def google(self) -> Optional['outputs.ProjectAuthenticationOauthSystemGoogle']:
        """
        Google's OAuth provider, allowing users to authenticate with their Google account.
        """
        return pulumi.get(self, "google")

    @property
    @pulumi.getter
    def linkedin(self) -> Optional['outputs.ProjectAuthenticationOauthSystemLinkedin']:
        """
        LinkedIn's OAuth provider, allowing users to authenticate with their LinkedIn account.
        """
        return pulumi.get(self, "linkedin")

    @property
    @pulumi.getter
    def microsoft(self) -> Optional['outputs.ProjectAuthenticationOauthSystemMicrosoft']:
        """
        Microsoft's OAuth provider, allowing users to authenticate with their Microsoft account.
        """
        return pulumi.get(self, "microsoft")

    @property
    @pulumi.getter
    def slack(self) -> Optional['outputs.ProjectAuthenticationOauthSystemSlack']:
        """
        Slack's OAuth provider, allowing users to authenticate with their Slack account.
        """
        return pulumi.get(self, "slack")


@pulumi.output_type
class ProjectAuthenticationOauthSystemApple(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedGrantTypes":
            suggest = "allowed_grant_types"
        elif key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "claimMapping":
            suggest = "claim_mapping"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "jwksEndpoint":
            suggest = "jwks_endpoint"
        elif key == "mergeUserAccounts":
            suggest = "merge_user_accounts"
        elif key == "providerTokenManagement":
            suggest = "provider_token_management"
        elif key == "tokenEndpoint":
            suggest = "token_endpoint"
        elif key == "userInfoEndpoint":
            suggest = "user_info_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOauthSystemApple. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOauthSystemApple.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOauthSystemApple.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_grant_types: Optional[Sequence[str]] = None,
                 authorization_endpoint: Optional[str] = None,
                 claim_mapping: Optional[Mapping[str, str]] = None,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 description: Optional[str] = None,
                 disabled: Optional[bool] = None,
                 issuer: Optional[str] = None,
                 jwks_endpoint: Optional[str] = None,
                 logo: Optional[str] = None,
                 merge_user_accounts: Optional[bool] = None,
                 prompts: Optional[Sequence[str]] = None,
                 provider_token_management: Optional['outputs.ProjectAuthenticationOauthSystemAppleProviderTokenManagement'] = None,
                 scopes: Optional[Sequence[str]] = None,
                 token_endpoint: Optional[str] = None,
                 user_info_endpoint: Optional[str] = None):
        """
        :param Sequence[str] allowed_grant_types: The type of grants (`authorization_code` or `implicit`) to allow when requesting access tokens from the OAuth provider.
        :param str authorization_endpoint: The URL that users are redirected to for authorization with the OAuth provider.
        :param str client_id: The client ID for the OAuth provider, used to identify the application to the provider.
        :param str client_secret: The client secret for the OAuth provider, used to authenticate the application with the provider.
        :param str description: A brief description of the OAuth provider.
        :param bool disabled: Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        :param str jwks_endpoint: The URL where the application can retrieve JSON Web Key Sets (JWKS) for the OAuth provider.
        :param str logo: The URL of the logo associated with the OAuth provider.
        :param bool merge_user_accounts: Whether to merge existing user accounts with new ones created through OAuth authentication.
        :param Sequence[str] prompts: Custom prompts or consent screens that users may see during OAuth authentication.
        :param 'ProjectAuthenticationOauthSystemAppleProviderTokenManagementArgs' provider_token_management: Settings related to token management for the OAuth provider.
        :param Sequence[str] scopes: Scopes of access that the application requests from the user's account on the OAuth provider.
        :param str token_endpoint: The URL where the application requests an access token from the OAuth provider.
        :param str user_info_endpoint: The URL where the application retrieves user information from the OAuth provider.
        """
        if allowed_grant_types is not None:
            pulumi.set(__self__, "allowed_grant_types", allowed_grant_types)
        if authorization_endpoint is not None:
            pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        if claim_mapping is not None:
            pulumi.set(__self__, "claim_mapping", claim_mapping)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if jwks_endpoint is not None:
            pulumi.set(__self__, "jwks_endpoint", jwks_endpoint)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if merge_user_accounts is not None:
            pulumi.set(__self__, "merge_user_accounts", merge_user_accounts)
        if prompts is not None:
            pulumi.set(__self__, "prompts", prompts)
        if provider_token_management is not None:
            pulumi.set(__self__, "provider_token_management", provider_token_management)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)
        if user_info_endpoint is not None:
            pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)

    @property
    @pulumi.getter(name="allowedGrantTypes")
    def allowed_grant_types(self) -> Optional[Sequence[str]]:
        """
        The type of grants (`authorization_code` or `implicit`) to allow when requesting access tokens from the OAuth provider.
        """
        return pulumi.get(self, "allowed_grant_types")

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> Optional[str]:
        """
        The URL that users are redirected to for authorization with the OAuth provider.
        """
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="claimMapping")
    def claim_mapping(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "claim_mapping")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The client ID for the OAuth provider, used to identify the application to the provider.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        The client secret for the OAuth provider, used to authenticate the application with the provider.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A brief description of the OAuth provider.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[str]:
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="jwksEndpoint")
    def jwks_endpoint(self) -> Optional[str]:
        """
        The URL where the application can retrieve JSON Web Key Sets (JWKS) for the OAuth provider.
        """
        return pulumi.get(self, "jwks_endpoint")

    @property
    @pulumi.getter
    def logo(self) -> Optional[str]:
        """
        The URL of the logo associated with the OAuth provider.
        """
        return pulumi.get(self, "logo")

    @property
    @pulumi.getter(name="mergeUserAccounts")
    def merge_user_accounts(self) -> Optional[bool]:
        """
        Whether to merge existing user accounts with new ones created through OAuth authentication.
        """
        return pulumi.get(self, "merge_user_accounts")

    @property
    @pulumi.getter
    def prompts(self) -> Optional[Sequence[str]]:
        """
        Custom prompts or consent screens that users may see during OAuth authentication.
        """
        return pulumi.get(self, "prompts")

    @property
    @pulumi.getter(name="providerTokenManagement")
    def provider_token_management(self) -> Optional['outputs.ProjectAuthenticationOauthSystemAppleProviderTokenManagement']:
        """
        Settings related to token management for the OAuth provider.
        """
        return pulumi.get(self, "provider_token_management")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        Scopes of access that the application requests from the user's account on the OAuth provider.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[str]:
        """
        The URL where the application requests an access token from the OAuth provider.
        """
        return pulumi.get(self, "token_endpoint")

    @property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> Optional[str]:
        """
        The URL where the application retrieves user information from the OAuth provider.
        """
        return pulumi.get(self, "user_info_endpoint")


@pulumi.output_type
class ProjectAuthenticationOauthSystemAppleProviderTokenManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callbackDomain":
            suggest = "callback_domain"
        elif key == "redirectUrl":
            suggest = "redirect_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOauthSystemAppleProviderTokenManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOauthSystemAppleProviderTokenManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOauthSystemAppleProviderTokenManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 callback_domain: Optional[str] = None,
                 redirect_url: Optional[str] = None):
        if callback_domain is not None:
            pulumi.set(__self__, "callback_domain", callback_domain)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)

    @property
    @pulumi.getter(name="callbackDomain")
    def callback_domain(self) -> Optional[str]:
        return pulumi.get(self, "callback_domain")

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[str]:
        return pulumi.get(self, "redirect_url")


@pulumi.output_type
class ProjectAuthenticationOauthSystemDiscord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedGrantTypes":
            suggest = "allowed_grant_types"
        elif key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "claimMapping":
            suggest = "claim_mapping"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "jwksEndpoint":
            suggest = "jwks_endpoint"
        elif key == "mergeUserAccounts":
            suggest = "merge_user_accounts"
        elif key == "providerTokenManagement":
            suggest = "provider_token_management"
        elif key == "tokenEndpoint":
            suggest = "token_endpoint"
        elif key == "userInfoEndpoint":
            suggest = "user_info_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOauthSystemDiscord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOauthSystemDiscord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOauthSystemDiscord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_grant_types: Optional[Sequence[str]] = None,
                 authorization_endpoint: Optional[str] = None,
                 claim_mapping: Optional[Mapping[str, str]] = None,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 description: Optional[str] = None,
                 disabled: Optional[bool] = None,
                 issuer: Optional[str] = None,
                 jwks_endpoint: Optional[str] = None,
                 logo: Optional[str] = None,
                 merge_user_accounts: Optional[bool] = None,
                 prompts: Optional[Sequence[str]] = None,
                 provider_token_management: Optional['outputs.ProjectAuthenticationOauthSystemDiscordProviderTokenManagement'] = None,
                 scopes: Optional[Sequence[str]] = None,
                 token_endpoint: Optional[str] = None,
                 user_info_endpoint: Optional[str] = None):
        """
        :param Sequence[str] allowed_grant_types: The type of grants (`authorization_code` or `implicit`) to allow when requesting access tokens from the OAuth provider.
        :param str authorization_endpoint: The URL that users are redirected to for authorization with the OAuth provider.
        :param str client_id: The client ID for the OAuth provider, used to identify the application to the provider.
        :param str client_secret: The client secret for the OAuth provider, used to authenticate the application with the provider.
        :param str description: A brief description of the OAuth provider.
        :param bool disabled: Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        :param str jwks_endpoint: The URL where the application can retrieve JSON Web Key Sets (JWKS) for the OAuth provider.
        :param str logo: The URL of the logo associated with the OAuth provider.
        :param bool merge_user_accounts: Whether to merge existing user accounts with new ones created through OAuth authentication.
        :param Sequence[str] prompts: Custom prompts or consent screens that users may see during OAuth authentication.
        :param 'ProjectAuthenticationOauthSystemDiscordProviderTokenManagementArgs' provider_token_management: Settings related to token management for the OAuth provider.
        :param Sequence[str] scopes: Scopes of access that the application requests from the user's account on the OAuth provider.
        :param str token_endpoint: The URL where the application requests an access token from the OAuth provider.
        :param str user_info_endpoint: The URL where the application retrieves user information from the OAuth provider.
        """
        if allowed_grant_types is not None:
            pulumi.set(__self__, "allowed_grant_types", allowed_grant_types)
        if authorization_endpoint is not None:
            pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        if claim_mapping is not None:
            pulumi.set(__self__, "claim_mapping", claim_mapping)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if jwks_endpoint is not None:
            pulumi.set(__self__, "jwks_endpoint", jwks_endpoint)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if merge_user_accounts is not None:
            pulumi.set(__self__, "merge_user_accounts", merge_user_accounts)
        if prompts is not None:
            pulumi.set(__self__, "prompts", prompts)
        if provider_token_management is not None:
            pulumi.set(__self__, "provider_token_management", provider_token_management)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)
        if user_info_endpoint is not None:
            pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)

    @property
    @pulumi.getter(name="allowedGrantTypes")
    def allowed_grant_types(self) -> Optional[Sequence[str]]:
        """
        The type of grants (`authorization_code` or `implicit`) to allow when requesting access tokens from the OAuth provider.
        """
        return pulumi.get(self, "allowed_grant_types")

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> Optional[str]:
        """
        The URL that users are redirected to for authorization with the OAuth provider.
        """
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="claimMapping")
    def claim_mapping(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "claim_mapping")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The client ID for the OAuth provider, used to identify the application to the provider.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        The client secret for the OAuth provider, used to authenticate the application with the provider.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A brief description of the OAuth provider.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[str]:
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="jwksEndpoint")
    def jwks_endpoint(self) -> Optional[str]:
        """
        The URL where the application can retrieve JSON Web Key Sets (JWKS) for the OAuth provider.
        """
        return pulumi.get(self, "jwks_endpoint")

    @property
    @pulumi.getter
    def logo(self) -> Optional[str]:
        """
        The URL of the logo associated with the OAuth provider.
        """
        return pulumi.get(self, "logo")

    @property
    @pulumi.getter(name="mergeUserAccounts")
    def merge_user_accounts(self) -> Optional[bool]:
        """
        Whether to merge existing user accounts with new ones created through OAuth authentication.
        """
        return pulumi.get(self, "merge_user_accounts")

    @property
    @pulumi.getter
    def prompts(self) -> Optional[Sequence[str]]:
        """
        Custom prompts or consent screens that users may see during OAuth authentication.
        """
        return pulumi.get(self, "prompts")

    @property
    @pulumi.getter(name="providerTokenManagement")
    def provider_token_management(self) -> Optional['outputs.ProjectAuthenticationOauthSystemDiscordProviderTokenManagement']:
        """
        Settings related to token management for the OAuth provider.
        """
        return pulumi.get(self, "provider_token_management")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        Scopes of access that the application requests from the user's account on the OAuth provider.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[str]:
        """
        The URL where the application requests an access token from the OAuth provider.
        """
        return pulumi.get(self, "token_endpoint")

    @property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> Optional[str]:
        """
        The URL where the application retrieves user information from the OAuth provider.
        """
        return pulumi.get(self, "user_info_endpoint")


@pulumi.output_type
class ProjectAuthenticationOauthSystemDiscordProviderTokenManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callbackDomain":
            suggest = "callback_domain"
        elif key == "redirectUrl":
            suggest = "redirect_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOauthSystemDiscordProviderTokenManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOauthSystemDiscordProviderTokenManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOauthSystemDiscordProviderTokenManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 callback_domain: Optional[str] = None,
                 redirect_url: Optional[str] = None):
        if callback_domain is not None:
            pulumi.set(__self__, "callback_domain", callback_domain)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)

    @property
    @pulumi.getter(name="callbackDomain")
    def callback_domain(self) -> Optional[str]:
        return pulumi.get(self, "callback_domain")

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[str]:
        return pulumi.get(self, "redirect_url")


@pulumi.output_type
class ProjectAuthenticationOauthSystemFacebook(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedGrantTypes":
            suggest = "allowed_grant_types"
        elif key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "claimMapping":
            suggest = "claim_mapping"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "jwksEndpoint":
            suggest = "jwks_endpoint"
        elif key == "mergeUserAccounts":
            suggest = "merge_user_accounts"
        elif key == "providerTokenManagement":
            suggest = "provider_token_management"
        elif key == "tokenEndpoint":
            suggest = "token_endpoint"
        elif key == "userInfoEndpoint":
            suggest = "user_info_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOauthSystemFacebook. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOauthSystemFacebook.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOauthSystemFacebook.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_grant_types: Optional[Sequence[str]] = None,
                 authorization_endpoint: Optional[str] = None,
                 claim_mapping: Optional[Mapping[str, str]] = None,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 description: Optional[str] = None,
                 disabled: Optional[bool] = None,
                 issuer: Optional[str] = None,
                 jwks_endpoint: Optional[str] = None,
                 logo: Optional[str] = None,
                 merge_user_accounts: Optional[bool] = None,
                 prompts: Optional[Sequence[str]] = None,
                 provider_token_management: Optional['outputs.ProjectAuthenticationOauthSystemFacebookProviderTokenManagement'] = None,
                 scopes: Optional[Sequence[str]] = None,
                 token_endpoint: Optional[str] = None,
                 user_info_endpoint: Optional[str] = None):
        """
        :param Sequence[str] allowed_grant_types: The type of grants (`authorization_code` or `implicit`) to allow when requesting access tokens from the OAuth provider.
        :param str authorization_endpoint: The URL that users are redirected to for authorization with the OAuth provider.
        :param str client_id: The client ID for the OAuth provider, used to identify the application to the provider.
        :param str client_secret: The client secret for the OAuth provider, used to authenticate the application with the provider.
        :param str description: A brief description of the OAuth provider.
        :param bool disabled: Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        :param str jwks_endpoint: The URL where the application can retrieve JSON Web Key Sets (JWKS) for the OAuth provider.
        :param str logo: The URL of the logo associated with the OAuth provider.
        :param bool merge_user_accounts: Whether to merge existing user accounts with new ones created through OAuth authentication.
        :param Sequence[str] prompts: Custom prompts or consent screens that users may see during OAuth authentication.
        :param 'ProjectAuthenticationOauthSystemFacebookProviderTokenManagementArgs' provider_token_management: Settings related to token management for the OAuth provider.
        :param Sequence[str] scopes: Scopes of access that the application requests from the user's account on the OAuth provider.
        :param str token_endpoint: The URL where the application requests an access token from the OAuth provider.
        :param str user_info_endpoint: The URL where the application retrieves user information from the OAuth provider.
        """
        if allowed_grant_types is not None:
            pulumi.set(__self__, "allowed_grant_types", allowed_grant_types)
        if authorization_endpoint is not None:
            pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        if claim_mapping is not None:
            pulumi.set(__self__, "claim_mapping", claim_mapping)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if jwks_endpoint is not None:
            pulumi.set(__self__, "jwks_endpoint", jwks_endpoint)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if merge_user_accounts is not None:
            pulumi.set(__self__, "merge_user_accounts", merge_user_accounts)
        if prompts is not None:
            pulumi.set(__self__, "prompts", prompts)
        if provider_token_management is not None:
            pulumi.set(__self__, "provider_token_management", provider_token_management)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)
        if user_info_endpoint is not None:
            pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)

    @property
    @pulumi.getter(name="allowedGrantTypes")
    def allowed_grant_types(self) -> Optional[Sequence[str]]:
        """
        The type of grants (`authorization_code` or `implicit`) to allow when requesting access tokens from the OAuth provider.
        """
        return pulumi.get(self, "allowed_grant_types")

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> Optional[str]:
        """
        The URL that users are redirected to for authorization with the OAuth provider.
        """
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="claimMapping")
    def claim_mapping(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "claim_mapping")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The client ID for the OAuth provider, used to identify the application to the provider.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        The client secret for the OAuth provider, used to authenticate the application with the provider.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A brief description of the OAuth provider.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[str]:
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="jwksEndpoint")
    def jwks_endpoint(self) -> Optional[str]:
        """
        The URL where the application can retrieve JSON Web Key Sets (JWKS) for the OAuth provider.
        """
        return pulumi.get(self, "jwks_endpoint")

    @property
    @pulumi.getter
    def logo(self) -> Optional[str]:
        """
        The URL of the logo associated with the OAuth provider.
        """
        return pulumi.get(self, "logo")

    @property
    @pulumi.getter(name="mergeUserAccounts")
    def merge_user_accounts(self) -> Optional[bool]:
        """
        Whether to merge existing user accounts with new ones created through OAuth authentication.
        """
        return pulumi.get(self, "merge_user_accounts")

    @property
    @pulumi.getter
    def prompts(self) -> Optional[Sequence[str]]:
        """
        Custom prompts or consent screens that users may see during OAuth authentication.
        """
        return pulumi.get(self, "prompts")

    @property
    @pulumi.getter(name="providerTokenManagement")
    def provider_token_management(self) -> Optional['outputs.ProjectAuthenticationOauthSystemFacebookProviderTokenManagement']:
        """
        Settings related to token management for the OAuth provider.
        """
        return pulumi.get(self, "provider_token_management")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        Scopes of access that the application requests from the user's account on the OAuth provider.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[str]:
        """
        The URL where the application requests an access token from the OAuth provider.
        """
        return pulumi.get(self, "token_endpoint")

    @property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> Optional[str]:
        """
        The URL where the application retrieves user information from the OAuth provider.
        """
        return pulumi.get(self, "user_info_endpoint")


@pulumi.output_type
class ProjectAuthenticationOauthSystemFacebookProviderTokenManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callbackDomain":
            suggest = "callback_domain"
        elif key == "redirectUrl":
            suggest = "redirect_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOauthSystemFacebookProviderTokenManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOauthSystemFacebookProviderTokenManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOauthSystemFacebookProviderTokenManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 callback_domain: Optional[str] = None,
                 redirect_url: Optional[str] = None):
        if callback_domain is not None:
            pulumi.set(__self__, "callback_domain", callback_domain)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)

    @property
    @pulumi.getter(name="callbackDomain")
    def callback_domain(self) -> Optional[str]:
        return pulumi.get(self, "callback_domain")

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[str]:
        return pulumi.get(self, "redirect_url")


@pulumi.output_type
class ProjectAuthenticationOauthSystemGithub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedGrantTypes":
            suggest = "allowed_grant_types"
        elif key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "claimMapping":
            suggest = "claim_mapping"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "jwksEndpoint":
            suggest = "jwks_endpoint"
        elif key == "mergeUserAccounts":
            suggest = "merge_user_accounts"
        elif key == "providerTokenManagement":
            suggest = "provider_token_management"
        elif key == "tokenEndpoint":
            suggest = "token_endpoint"
        elif key == "userInfoEndpoint":
            suggest = "user_info_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOauthSystemGithub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOauthSystemGithub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOauthSystemGithub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_grant_types: Optional[Sequence[str]] = None,
                 authorization_endpoint: Optional[str] = None,
                 claim_mapping: Optional[Mapping[str, str]] = None,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 description: Optional[str] = None,
                 disabled: Optional[bool] = None,
                 issuer: Optional[str] = None,
                 jwks_endpoint: Optional[str] = None,
                 logo: Optional[str] = None,
                 merge_user_accounts: Optional[bool] = None,
                 prompts: Optional[Sequence[str]] = None,
                 provider_token_management: Optional['outputs.ProjectAuthenticationOauthSystemGithubProviderTokenManagement'] = None,
                 scopes: Optional[Sequence[str]] = None,
                 token_endpoint: Optional[str] = None,
                 user_info_endpoint: Optional[str] = None):
        """
        :param Sequence[str] allowed_grant_types: The type of grants (`authorization_code` or `implicit`) to allow when requesting access tokens from the OAuth provider.
        :param str authorization_endpoint: The URL that users are redirected to for authorization with the OAuth provider.
        :param str client_id: The client ID for the OAuth provider, used to identify the application to the provider.
        :param str client_secret: The client secret for the OAuth provider, used to authenticate the application with the provider.
        :param str description: A brief description of the OAuth provider.
        :param bool disabled: Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        :param str jwks_endpoint: The URL where the application can retrieve JSON Web Key Sets (JWKS) for the OAuth provider.
        :param str logo: The URL of the logo associated with the OAuth provider.
        :param bool merge_user_accounts: Whether to merge existing user accounts with new ones created through OAuth authentication.
        :param Sequence[str] prompts: Custom prompts or consent screens that users may see during OAuth authentication.
        :param 'ProjectAuthenticationOauthSystemGithubProviderTokenManagementArgs' provider_token_management: Settings related to token management for the OAuth provider.
        :param Sequence[str] scopes: Scopes of access that the application requests from the user's account on the OAuth provider.
        :param str token_endpoint: The URL where the application requests an access token from the OAuth provider.
        :param str user_info_endpoint: The URL where the application retrieves user information from the OAuth provider.
        """
        if allowed_grant_types is not None:
            pulumi.set(__self__, "allowed_grant_types", allowed_grant_types)
        if authorization_endpoint is not None:
            pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        if claim_mapping is not None:
            pulumi.set(__self__, "claim_mapping", claim_mapping)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if jwks_endpoint is not None:
            pulumi.set(__self__, "jwks_endpoint", jwks_endpoint)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if merge_user_accounts is not None:
            pulumi.set(__self__, "merge_user_accounts", merge_user_accounts)
        if prompts is not None:
            pulumi.set(__self__, "prompts", prompts)
        if provider_token_management is not None:
            pulumi.set(__self__, "provider_token_management", provider_token_management)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)
        if user_info_endpoint is not None:
            pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)

    @property
    @pulumi.getter(name="allowedGrantTypes")
    def allowed_grant_types(self) -> Optional[Sequence[str]]:
        """
        The type of grants (`authorization_code` or `implicit`) to allow when requesting access tokens from the OAuth provider.
        """
        return pulumi.get(self, "allowed_grant_types")

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> Optional[str]:
        """
        The URL that users are redirected to for authorization with the OAuth provider.
        """
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="claimMapping")
    def claim_mapping(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "claim_mapping")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The client ID for the OAuth provider, used to identify the application to the provider.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        The client secret for the OAuth provider, used to authenticate the application with the provider.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A brief description of the OAuth provider.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[str]:
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="jwksEndpoint")
    def jwks_endpoint(self) -> Optional[str]:
        """
        The URL where the application can retrieve JSON Web Key Sets (JWKS) for the OAuth provider.
        """
        return pulumi.get(self, "jwks_endpoint")

    @property
    @pulumi.getter
    def logo(self) -> Optional[str]:
        """
        The URL of the logo associated with the OAuth provider.
        """
        return pulumi.get(self, "logo")

    @property
    @pulumi.getter(name="mergeUserAccounts")
    def merge_user_accounts(self) -> Optional[bool]:
        """
        Whether to merge existing user accounts with new ones created through OAuth authentication.
        """
        return pulumi.get(self, "merge_user_accounts")

    @property
    @pulumi.getter
    def prompts(self) -> Optional[Sequence[str]]:
        """
        Custom prompts or consent screens that users may see during OAuth authentication.
        """
        return pulumi.get(self, "prompts")

    @property
    @pulumi.getter(name="providerTokenManagement")
    def provider_token_management(self) -> Optional['outputs.ProjectAuthenticationOauthSystemGithubProviderTokenManagement']:
        """
        Settings related to token management for the OAuth provider.
        """
        return pulumi.get(self, "provider_token_management")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        Scopes of access that the application requests from the user's account on the OAuth provider.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[str]:
        """
        The URL where the application requests an access token from the OAuth provider.
        """
        return pulumi.get(self, "token_endpoint")

    @property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> Optional[str]:
        """
        The URL where the application retrieves user information from the OAuth provider.
        """
        return pulumi.get(self, "user_info_endpoint")


@pulumi.output_type
class ProjectAuthenticationOauthSystemGithubProviderTokenManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callbackDomain":
            suggest = "callback_domain"
        elif key == "redirectUrl":
            suggest = "redirect_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOauthSystemGithubProviderTokenManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOauthSystemGithubProviderTokenManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOauthSystemGithubProviderTokenManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 callback_domain: Optional[str] = None,
                 redirect_url: Optional[str] = None):
        if callback_domain is not None:
            pulumi.set(__self__, "callback_domain", callback_domain)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)

    @property
    @pulumi.getter(name="callbackDomain")
    def callback_domain(self) -> Optional[str]:
        return pulumi.get(self, "callback_domain")

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[str]:
        return pulumi.get(self, "redirect_url")


@pulumi.output_type
class ProjectAuthenticationOauthSystemGitlab(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedGrantTypes":
            suggest = "allowed_grant_types"
        elif key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "claimMapping":
            suggest = "claim_mapping"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "jwksEndpoint":
            suggest = "jwks_endpoint"
        elif key == "mergeUserAccounts":
            suggest = "merge_user_accounts"
        elif key == "providerTokenManagement":
            suggest = "provider_token_management"
        elif key == "tokenEndpoint":
            suggest = "token_endpoint"
        elif key == "userInfoEndpoint":
            suggest = "user_info_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOauthSystemGitlab. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOauthSystemGitlab.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOauthSystemGitlab.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_grant_types: Optional[Sequence[str]] = None,
                 authorization_endpoint: Optional[str] = None,
                 claim_mapping: Optional[Mapping[str, str]] = None,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 description: Optional[str] = None,
                 disabled: Optional[bool] = None,
                 issuer: Optional[str] = None,
                 jwks_endpoint: Optional[str] = None,
                 logo: Optional[str] = None,
                 merge_user_accounts: Optional[bool] = None,
                 prompts: Optional[Sequence[str]] = None,
                 provider_token_management: Optional['outputs.ProjectAuthenticationOauthSystemGitlabProviderTokenManagement'] = None,
                 scopes: Optional[Sequence[str]] = None,
                 token_endpoint: Optional[str] = None,
                 user_info_endpoint: Optional[str] = None):
        """
        :param Sequence[str] allowed_grant_types: The type of grants (`authorization_code` or `implicit`) to allow when requesting access tokens from the OAuth provider.
        :param str authorization_endpoint: The URL that users are redirected to for authorization with the OAuth provider.
        :param str client_id: The client ID for the OAuth provider, used to identify the application to the provider.
        :param str client_secret: The client secret for the OAuth provider, used to authenticate the application with the provider.
        :param str description: A brief description of the OAuth provider.
        :param bool disabled: Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        :param str jwks_endpoint: The URL where the application can retrieve JSON Web Key Sets (JWKS) for the OAuth provider.
        :param str logo: The URL of the logo associated with the OAuth provider.
        :param bool merge_user_accounts: Whether to merge existing user accounts with new ones created through OAuth authentication.
        :param Sequence[str] prompts: Custom prompts or consent screens that users may see during OAuth authentication.
        :param 'ProjectAuthenticationOauthSystemGitlabProviderTokenManagementArgs' provider_token_management: Settings related to token management for the OAuth provider.
        :param Sequence[str] scopes: Scopes of access that the application requests from the user's account on the OAuth provider.
        :param str token_endpoint: The URL where the application requests an access token from the OAuth provider.
        :param str user_info_endpoint: The URL where the application retrieves user information from the OAuth provider.
        """
        if allowed_grant_types is not None:
            pulumi.set(__self__, "allowed_grant_types", allowed_grant_types)
        if authorization_endpoint is not None:
            pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        if claim_mapping is not None:
            pulumi.set(__self__, "claim_mapping", claim_mapping)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if jwks_endpoint is not None:
            pulumi.set(__self__, "jwks_endpoint", jwks_endpoint)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if merge_user_accounts is not None:
            pulumi.set(__self__, "merge_user_accounts", merge_user_accounts)
        if prompts is not None:
            pulumi.set(__self__, "prompts", prompts)
        if provider_token_management is not None:
            pulumi.set(__self__, "provider_token_management", provider_token_management)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)
        if user_info_endpoint is not None:
            pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)

    @property
    @pulumi.getter(name="allowedGrantTypes")
    def allowed_grant_types(self) -> Optional[Sequence[str]]:
        """
        The type of grants (`authorization_code` or `implicit`) to allow when requesting access tokens from the OAuth provider.
        """
        return pulumi.get(self, "allowed_grant_types")

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> Optional[str]:
        """
        The URL that users are redirected to for authorization with the OAuth provider.
        """
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="claimMapping")
    def claim_mapping(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "claim_mapping")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The client ID for the OAuth provider, used to identify the application to the provider.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        The client secret for the OAuth provider, used to authenticate the application with the provider.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A brief description of the OAuth provider.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[str]:
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="jwksEndpoint")
    def jwks_endpoint(self) -> Optional[str]:
        """
        The URL where the application can retrieve JSON Web Key Sets (JWKS) for the OAuth provider.
        """
        return pulumi.get(self, "jwks_endpoint")

    @property
    @pulumi.getter
    def logo(self) -> Optional[str]:
        """
        The URL of the logo associated with the OAuth provider.
        """
        return pulumi.get(self, "logo")

    @property
    @pulumi.getter(name="mergeUserAccounts")
    def merge_user_accounts(self) -> Optional[bool]:
        """
        Whether to merge existing user accounts with new ones created through OAuth authentication.
        """
        return pulumi.get(self, "merge_user_accounts")

    @property
    @pulumi.getter
    def prompts(self) -> Optional[Sequence[str]]:
        """
        Custom prompts or consent screens that users may see during OAuth authentication.
        """
        return pulumi.get(self, "prompts")

    @property
    @pulumi.getter(name="providerTokenManagement")
    def provider_token_management(self) -> Optional['outputs.ProjectAuthenticationOauthSystemGitlabProviderTokenManagement']:
        """
        Settings related to token management for the OAuth provider.
        """
        return pulumi.get(self, "provider_token_management")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        Scopes of access that the application requests from the user's account on the OAuth provider.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[str]:
        """
        The URL where the application requests an access token from the OAuth provider.
        """
        return pulumi.get(self, "token_endpoint")

    @property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> Optional[str]:
        """
        The URL where the application retrieves user information from the OAuth provider.
        """
        return pulumi.get(self, "user_info_endpoint")


@pulumi.output_type
class ProjectAuthenticationOauthSystemGitlabProviderTokenManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callbackDomain":
            suggest = "callback_domain"
        elif key == "redirectUrl":
            suggest = "redirect_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOauthSystemGitlabProviderTokenManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOauthSystemGitlabProviderTokenManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOauthSystemGitlabProviderTokenManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 callback_domain: Optional[str] = None,
                 redirect_url: Optional[str] = None):
        if callback_domain is not None:
            pulumi.set(__self__, "callback_domain", callback_domain)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)

    @property
    @pulumi.getter(name="callbackDomain")
    def callback_domain(self) -> Optional[str]:
        return pulumi.get(self, "callback_domain")

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[str]:
        return pulumi.get(self, "redirect_url")


@pulumi.output_type
class ProjectAuthenticationOauthSystemGoogle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedGrantTypes":
            suggest = "allowed_grant_types"
        elif key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "claimMapping":
            suggest = "claim_mapping"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "jwksEndpoint":
            suggest = "jwks_endpoint"
        elif key == "mergeUserAccounts":
            suggest = "merge_user_accounts"
        elif key == "providerTokenManagement":
            suggest = "provider_token_management"
        elif key == "tokenEndpoint":
            suggest = "token_endpoint"
        elif key == "userInfoEndpoint":
            suggest = "user_info_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOauthSystemGoogle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOauthSystemGoogle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOauthSystemGoogle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_grant_types: Optional[Sequence[str]] = None,
                 authorization_endpoint: Optional[str] = None,
                 claim_mapping: Optional[Mapping[str, str]] = None,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 description: Optional[str] = None,
                 disabled: Optional[bool] = None,
                 issuer: Optional[str] = None,
                 jwks_endpoint: Optional[str] = None,
                 logo: Optional[str] = None,
                 merge_user_accounts: Optional[bool] = None,
                 prompts: Optional[Sequence[str]] = None,
                 provider_token_management: Optional['outputs.ProjectAuthenticationOauthSystemGoogleProviderTokenManagement'] = None,
                 scopes: Optional[Sequence[str]] = None,
                 token_endpoint: Optional[str] = None,
                 user_info_endpoint: Optional[str] = None):
        """
        :param Sequence[str] allowed_grant_types: The type of grants (`authorization_code` or `implicit`) to allow when requesting access tokens from the OAuth provider.
        :param str authorization_endpoint: The URL that users are redirected to for authorization with the OAuth provider.
        :param str client_id: The client ID for the OAuth provider, used to identify the application to the provider.
        :param str client_secret: The client secret for the OAuth provider, used to authenticate the application with the provider.
        :param str description: A brief description of the OAuth provider.
        :param bool disabled: Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        :param str jwks_endpoint: The URL where the application can retrieve JSON Web Key Sets (JWKS) for the OAuth provider.
        :param str logo: The URL of the logo associated with the OAuth provider.
        :param bool merge_user_accounts: Whether to merge existing user accounts with new ones created through OAuth authentication.
        :param Sequence[str] prompts: Custom prompts or consent screens that users may see during OAuth authentication.
        :param 'ProjectAuthenticationOauthSystemGoogleProviderTokenManagementArgs' provider_token_management: Settings related to token management for the OAuth provider.
        :param Sequence[str] scopes: Scopes of access that the application requests from the user's account on the OAuth provider.
        :param str token_endpoint: The URL where the application requests an access token from the OAuth provider.
        :param str user_info_endpoint: The URL where the application retrieves user information from the OAuth provider.
        """
        if allowed_grant_types is not None:
            pulumi.set(__self__, "allowed_grant_types", allowed_grant_types)
        if authorization_endpoint is not None:
            pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        if claim_mapping is not None:
            pulumi.set(__self__, "claim_mapping", claim_mapping)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if jwks_endpoint is not None:
            pulumi.set(__self__, "jwks_endpoint", jwks_endpoint)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if merge_user_accounts is not None:
            pulumi.set(__self__, "merge_user_accounts", merge_user_accounts)
        if prompts is not None:
            pulumi.set(__self__, "prompts", prompts)
        if provider_token_management is not None:
            pulumi.set(__self__, "provider_token_management", provider_token_management)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)
        if user_info_endpoint is not None:
            pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)

    @property
    @pulumi.getter(name="allowedGrantTypes")
    def allowed_grant_types(self) -> Optional[Sequence[str]]:
        """
        The type of grants (`authorization_code` or `implicit`) to allow when requesting access tokens from the OAuth provider.
        """
        return pulumi.get(self, "allowed_grant_types")

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> Optional[str]:
        """
        The URL that users are redirected to for authorization with the OAuth provider.
        """
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="claimMapping")
    def claim_mapping(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "claim_mapping")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The client ID for the OAuth provider, used to identify the application to the provider.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        The client secret for the OAuth provider, used to authenticate the application with the provider.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A brief description of the OAuth provider.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[str]:
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="jwksEndpoint")
    def jwks_endpoint(self) -> Optional[str]:
        """
        The URL where the application can retrieve JSON Web Key Sets (JWKS) for the OAuth provider.
        """
        return pulumi.get(self, "jwks_endpoint")

    @property
    @pulumi.getter
    def logo(self) -> Optional[str]:
        """
        The URL of the logo associated with the OAuth provider.
        """
        return pulumi.get(self, "logo")

    @property
    @pulumi.getter(name="mergeUserAccounts")
    def merge_user_accounts(self) -> Optional[bool]:
        """
        Whether to merge existing user accounts with new ones created through OAuth authentication.
        """
        return pulumi.get(self, "merge_user_accounts")

    @property
    @pulumi.getter
    def prompts(self) -> Optional[Sequence[str]]:
        """
        Custom prompts or consent screens that users may see during OAuth authentication.
        """
        return pulumi.get(self, "prompts")

    @property
    @pulumi.getter(name="providerTokenManagement")
    def provider_token_management(self) -> Optional['outputs.ProjectAuthenticationOauthSystemGoogleProviderTokenManagement']:
        """
        Settings related to token management for the OAuth provider.
        """
        return pulumi.get(self, "provider_token_management")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        Scopes of access that the application requests from the user's account on the OAuth provider.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[str]:
        """
        The URL where the application requests an access token from the OAuth provider.
        """
        return pulumi.get(self, "token_endpoint")

    @property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> Optional[str]:
        """
        The URL where the application retrieves user information from the OAuth provider.
        """
        return pulumi.get(self, "user_info_endpoint")


@pulumi.output_type
class ProjectAuthenticationOauthSystemGoogleProviderTokenManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callbackDomain":
            suggest = "callback_domain"
        elif key == "redirectUrl":
            suggest = "redirect_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOauthSystemGoogleProviderTokenManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOauthSystemGoogleProviderTokenManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOauthSystemGoogleProviderTokenManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 callback_domain: Optional[str] = None,
                 redirect_url: Optional[str] = None):
        if callback_domain is not None:
            pulumi.set(__self__, "callback_domain", callback_domain)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)

    @property
    @pulumi.getter(name="callbackDomain")
    def callback_domain(self) -> Optional[str]:
        return pulumi.get(self, "callback_domain")

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[str]:
        return pulumi.get(self, "redirect_url")


@pulumi.output_type
class ProjectAuthenticationOauthSystemLinkedin(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedGrantTypes":
            suggest = "allowed_grant_types"
        elif key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "claimMapping":
            suggest = "claim_mapping"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "jwksEndpoint":
            suggest = "jwks_endpoint"
        elif key == "mergeUserAccounts":
            suggest = "merge_user_accounts"
        elif key == "providerTokenManagement":
            suggest = "provider_token_management"
        elif key == "tokenEndpoint":
            suggest = "token_endpoint"
        elif key == "userInfoEndpoint":
            suggest = "user_info_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOauthSystemLinkedin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOauthSystemLinkedin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOauthSystemLinkedin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_grant_types: Optional[Sequence[str]] = None,
                 authorization_endpoint: Optional[str] = None,
                 claim_mapping: Optional[Mapping[str, str]] = None,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 description: Optional[str] = None,
                 disabled: Optional[bool] = None,
                 issuer: Optional[str] = None,
                 jwks_endpoint: Optional[str] = None,
                 logo: Optional[str] = None,
                 merge_user_accounts: Optional[bool] = None,
                 prompts: Optional[Sequence[str]] = None,
                 provider_token_management: Optional['outputs.ProjectAuthenticationOauthSystemLinkedinProviderTokenManagement'] = None,
                 scopes: Optional[Sequence[str]] = None,
                 token_endpoint: Optional[str] = None,
                 user_info_endpoint: Optional[str] = None):
        """
        :param Sequence[str] allowed_grant_types: The type of grants (`authorization_code` or `implicit`) to allow when requesting access tokens from the OAuth provider.
        :param str authorization_endpoint: The URL that users are redirected to for authorization with the OAuth provider.
        :param str client_id: The client ID for the OAuth provider, used to identify the application to the provider.
        :param str client_secret: The client secret for the OAuth provider, used to authenticate the application with the provider.
        :param str description: A brief description of the OAuth provider.
        :param bool disabled: Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        :param str jwks_endpoint: The URL where the application can retrieve JSON Web Key Sets (JWKS) for the OAuth provider.
        :param str logo: The URL of the logo associated with the OAuth provider.
        :param bool merge_user_accounts: Whether to merge existing user accounts with new ones created through OAuth authentication.
        :param Sequence[str] prompts: Custom prompts or consent screens that users may see during OAuth authentication.
        :param 'ProjectAuthenticationOauthSystemLinkedinProviderTokenManagementArgs' provider_token_management: Settings related to token management for the OAuth provider.
        :param Sequence[str] scopes: Scopes of access that the application requests from the user's account on the OAuth provider.
        :param str token_endpoint: The URL where the application requests an access token from the OAuth provider.
        :param str user_info_endpoint: The URL where the application retrieves user information from the OAuth provider.
        """
        if allowed_grant_types is not None:
            pulumi.set(__self__, "allowed_grant_types", allowed_grant_types)
        if authorization_endpoint is not None:
            pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        if claim_mapping is not None:
            pulumi.set(__self__, "claim_mapping", claim_mapping)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if jwks_endpoint is not None:
            pulumi.set(__self__, "jwks_endpoint", jwks_endpoint)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if merge_user_accounts is not None:
            pulumi.set(__self__, "merge_user_accounts", merge_user_accounts)
        if prompts is not None:
            pulumi.set(__self__, "prompts", prompts)
        if provider_token_management is not None:
            pulumi.set(__self__, "provider_token_management", provider_token_management)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)
        if user_info_endpoint is not None:
            pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)

    @property
    @pulumi.getter(name="allowedGrantTypes")
    def allowed_grant_types(self) -> Optional[Sequence[str]]:
        """
        The type of grants (`authorization_code` or `implicit`) to allow when requesting access tokens from the OAuth provider.
        """
        return pulumi.get(self, "allowed_grant_types")

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> Optional[str]:
        """
        The URL that users are redirected to for authorization with the OAuth provider.
        """
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="claimMapping")
    def claim_mapping(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "claim_mapping")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The client ID for the OAuth provider, used to identify the application to the provider.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        The client secret for the OAuth provider, used to authenticate the application with the provider.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A brief description of the OAuth provider.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[str]:
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="jwksEndpoint")
    def jwks_endpoint(self) -> Optional[str]:
        """
        The URL where the application can retrieve JSON Web Key Sets (JWKS) for the OAuth provider.
        """
        return pulumi.get(self, "jwks_endpoint")

    @property
    @pulumi.getter
    def logo(self) -> Optional[str]:
        """
        The URL of the logo associated with the OAuth provider.
        """
        return pulumi.get(self, "logo")

    @property
    @pulumi.getter(name="mergeUserAccounts")
    def merge_user_accounts(self) -> Optional[bool]:
        """
        Whether to merge existing user accounts with new ones created through OAuth authentication.
        """
        return pulumi.get(self, "merge_user_accounts")

    @property
    @pulumi.getter
    def prompts(self) -> Optional[Sequence[str]]:
        """
        Custom prompts or consent screens that users may see during OAuth authentication.
        """
        return pulumi.get(self, "prompts")

    @property
    @pulumi.getter(name="providerTokenManagement")
    def provider_token_management(self) -> Optional['outputs.ProjectAuthenticationOauthSystemLinkedinProviderTokenManagement']:
        """
        Settings related to token management for the OAuth provider.
        """
        return pulumi.get(self, "provider_token_management")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        Scopes of access that the application requests from the user's account on the OAuth provider.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[str]:
        """
        The URL where the application requests an access token from the OAuth provider.
        """
        return pulumi.get(self, "token_endpoint")

    @property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> Optional[str]:
        """
        The URL where the application retrieves user information from the OAuth provider.
        """
        return pulumi.get(self, "user_info_endpoint")


@pulumi.output_type
class ProjectAuthenticationOauthSystemLinkedinProviderTokenManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callbackDomain":
            suggest = "callback_domain"
        elif key == "redirectUrl":
            suggest = "redirect_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOauthSystemLinkedinProviderTokenManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOauthSystemLinkedinProviderTokenManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOauthSystemLinkedinProviderTokenManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 callback_domain: Optional[str] = None,
                 redirect_url: Optional[str] = None):
        if callback_domain is not None:
            pulumi.set(__self__, "callback_domain", callback_domain)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)

    @property
    @pulumi.getter(name="callbackDomain")
    def callback_domain(self) -> Optional[str]:
        return pulumi.get(self, "callback_domain")

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[str]:
        return pulumi.get(self, "redirect_url")


@pulumi.output_type
class ProjectAuthenticationOauthSystemMicrosoft(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedGrantTypes":
            suggest = "allowed_grant_types"
        elif key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "claimMapping":
            suggest = "claim_mapping"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "jwksEndpoint":
            suggest = "jwks_endpoint"
        elif key == "mergeUserAccounts":
            suggest = "merge_user_accounts"
        elif key == "providerTokenManagement":
            suggest = "provider_token_management"
        elif key == "tokenEndpoint":
            suggest = "token_endpoint"
        elif key == "userInfoEndpoint":
            suggest = "user_info_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOauthSystemMicrosoft. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOauthSystemMicrosoft.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOauthSystemMicrosoft.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_grant_types: Optional[Sequence[str]] = None,
                 authorization_endpoint: Optional[str] = None,
                 claim_mapping: Optional[Mapping[str, str]] = None,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 description: Optional[str] = None,
                 disabled: Optional[bool] = None,
                 issuer: Optional[str] = None,
                 jwks_endpoint: Optional[str] = None,
                 logo: Optional[str] = None,
                 merge_user_accounts: Optional[bool] = None,
                 prompts: Optional[Sequence[str]] = None,
                 provider_token_management: Optional['outputs.ProjectAuthenticationOauthSystemMicrosoftProviderTokenManagement'] = None,
                 scopes: Optional[Sequence[str]] = None,
                 token_endpoint: Optional[str] = None,
                 user_info_endpoint: Optional[str] = None):
        """
        :param Sequence[str] allowed_grant_types: The type of grants (`authorization_code` or `implicit`) to allow when requesting access tokens from the OAuth provider.
        :param str authorization_endpoint: The URL that users are redirected to for authorization with the OAuth provider.
        :param str client_id: The client ID for the OAuth provider, used to identify the application to the provider.
        :param str client_secret: The client secret for the OAuth provider, used to authenticate the application with the provider.
        :param str description: A brief description of the OAuth provider.
        :param bool disabled: Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        :param str jwks_endpoint: The URL where the application can retrieve JSON Web Key Sets (JWKS) for the OAuth provider.
        :param str logo: The URL of the logo associated with the OAuth provider.
        :param bool merge_user_accounts: Whether to merge existing user accounts with new ones created through OAuth authentication.
        :param Sequence[str] prompts: Custom prompts or consent screens that users may see during OAuth authentication.
        :param 'ProjectAuthenticationOauthSystemMicrosoftProviderTokenManagementArgs' provider_token_management: Settings related to token management for the OAuth provider.
        :param Sequence[str] scopes: Scopes of access that the application requests from the user's account on the OAuth provider.
        :param str token_endpoint: The URL where the application requests an access token from the OAuth provider.
        :param str user_info_endpoint: The URL where the application retrieves user information from the OAuth provider.
        """
        if allowed_grant_types is not None:
            pulumi.set(__self__, "allowed_grant_types", allowed_grant_types)
        if authorization_endpoint is not None:
            pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        if claim_mapping is not None:
            pulumi.set(__self__, "claim_mapping", claim_mapping)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if jwks_endpoint is not None:
            pulumi.set(__self__, "jwks_endpoint", jwks_endpoint)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if merge_user_accounts is not None:
            pulumi.set(__self__, "merge_user_accounts", merge_user_accounts)
        if prompts is not None:
            pulumi.set(__self__, "prompts", prompts)
        if provider_token_management is not None:
            pulumi.set(__self__, "provider_token_management", provider_token_management)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)
        if user_info_endpoint is not None:
            pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)

    @property
    @pulumi.getter(name="allowedGrantTypes")
    def allowed_grant_types(self) -> Optional[Sequence[str]]:
        """
        The type of grants (`authorization_code` or `implicit`) to allow when requesting access tokens from the OAuth provider.
        """
        return pulumi.get(self, "allowed_grant_types")

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> Optional[str]:
        """
        The URL that users are redirected to for authorization with the OAuth provider.
        """
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="claimMapping")
    def claim_mapping(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "claim_mapping")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The client ID for the OAuth provider, used to identify the application to the provider.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        The client secret for the OAuth provider, used to authenticate the application with the provider.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A brief description of the OAuth provider.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[str]:
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="jwksEndpoint")
    def jwks_endpoint(self) -> Optional[str]:
        """
        The URL where the application can retrieve JSON Web Key Sets (JWKS) for the OAuth provider.
        """
        return pulumi.get(self, "jwks_endpoint")

    @property
    @pulumi.getter
    def logo(self) -> Optional[str]:
        """
        The URL of the logo associated with the OAuth provider.
        """
        return pulumi.get(self, "logo")

    @property
    @pulumi.getter(name="mergeUserAccounts")
    def merge_user_accounts(self) -> Optional[bool]:
        """
        Whether to merge existing user accounts with new ones created through OAuth authentication.
        """
        return pulumi.get(self, "merge_user_accounts")

    @property
    @pulumi.getter
    def prompts(self) -> Optional[Sequence[str]]:
        """
        Custom prompts or consent screens that users may see during OAuth authentication.
        """
        return pulumi.get(self, "prompts")

    @property
    @pulumi.getter(name="providerTokenManagement")
    def provider_token_management(self) -> Optional['outputs.ProjectAuthenticationOauthSystemMicrosoftProviderTokenManagement']:
        """
        Settings related to token management for the OAuth provider.
        """
        return pulumi.get(self, "provider_token_management")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        Scopes of access that the application requests from the user's account on the OAuth provider.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[str]:
        """
        The URL where the application requests an access token from the OAuth provider.
        """
        return pulumi.get(self, "token_endpoint")

    @property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> Optional[str]:
        """
        The URL where the application retrieves user information from the OAuth provider.
        """
        return pulumi.get(self, "user_info_endpoint")


@pulumi.output_type
class ProjectAuthenticationOauthSystemMicrosoftProviderTokenManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callbackDomain":
            suggest = "callback_domain"
        elif key == "redirectUrl":
            suggest = "redirect_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOauthSystemMicrosoftProviderTokenManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOauthSystemMicrosoftProviderTokenManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOauthSystemMicrosoftProviderTokenManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 callback_domain: Optional[str] = None,
                 redirect_url: Optional[str] = None):
        if callback_domain is not None:
            pulumi.set(__self__, "callback_domain", callback_domain)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)

    @property
    @pulumi.getter(name="callbackDomain")
    def callback_domain(self) -> Optional[str]:
        return pulumi.get(self, "callback_domain")

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[str]:
        return pulumi.get(self, "redirect_url")


@pulumi.output_type
class ProjectAuthenticationOauthSystemSlack(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedGrantTypes":
            suggest = "allowed_grant_types"
        elif key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "claimMapping":
            suggest = "claim_mapping"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "jwksEndpoint":
            suggest = "jwks_endpoint"
        elif key == "mergeUserAccounts":
            suggest = "merge_user_accounts"
        elif key == "providerTokenManagement":
            suggest = "provider_token_management"
        elif key == "tokenEndpoint":
            suggest = "token_endpoint"
        elif key == "userInfoEndpoint":
            suggest = "user_info_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOauthSystemSlack. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOauthSystemSlack.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOauthSystemSlack.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_grant_types: Optional[Sequence[str]] = None,
                 authorization_endpoint: Optional[str] = None,
                 claim_mapping: Optional[Mapping[str, str]] = None,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 description: Optional[str] = None,
                 disabled: Optional[bool] = None,
                 issuer: Optional[str] = None,
                 jwks_endpoint: Optional[str] = None,
                 logo: Optional[str] = None,
                 merge_user_accounts: Optional[bool] = None,
                 prompts: Optional[Sequence[str]] = None,
                 provider_token_management: Optional['outputs.ProjectAuthenticationOauthSystemSlackProviderTokenManagement'] = None,
                 scopes: Optional[Sequence[str]] = None,
                 token_endpoint: Optional[str] = None,
                 user_info_endpoint: Optional[str] = None):
        """
        :param Sequence[str] allowed_grant_types: The type of grants (`authorization_code` or `implicit`) to allow when requesting access tokens from the OAuth provider.
        :param str authorization_endpoint: The URL that users are redirected to for authorization with the OAuth provider.
        :param str client_id: The client ID for the OAuth provider, used to identify the application to the provider.
        :param str client_secret: The client secret for the OAuth provider, used to authenticate the application with the provider.
        :param str description: A brief description of the OAuth provider.
        :param bool disabled: Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        :param str jwks_endpoint: The URL where the application can retrieve JSON Web Key Sets (JWKS) for the OAuth provider.
        :param str logo: The URL of the logo associated with the OAuth provider.
        :param bool merge_user_accounts: Whether to merge existing user accounts with new ones created through OAuth authentication.
        :param Sequence[str] prompts: Custom prompts or consent screens that users may see during OAuth authentication.
        :param 'ProjectAuthenticationOauthSystemSlackProviderTokenManagementArgs' provider_token_management: Settings related to token management for the OAuth provider.
        :param Sequence[str] scopes: Scopes of access that the application requests from the user's account on the OAuth provider.
        :param str token_endpoint: The URL where the application requests an access token from the OAuth provider.
        :param str user_info_endpoint: The URL where the application retrieves user information from the OAuth provider.
        """
        if allowed_grant_types is not None:
            pulumi.set(__self__, "allowed_grant_types", allowed_grant_types)
        if authorization_endpoint is not None:
            pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        if claim_mapping is not None:
            pulumi.set(__self__, "claim_mapping", claim_mapping)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if jwks_endpoint is not None:
            pulumi.set(__self__, "jwks_endpoint", jwks_endpoint)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if merge_user_accounts is not None:
            pulumi.set(__self__, "merge_user_accounts", merge_user_accounts)
        if prompts is not None:
            pulumi.set(__self__, "prompts", prompts)
        if provider_token_management is not None:
            pulumi.set(__self__, "provider_token_management", provider_token_management)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)
        if user_info_endpoint is not None:
            pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)

    @property
    @pulumi.getter(name="allowedGrantTypes")
    def allowed_grant_types(self) -> Optional[Sequence[str]]:
        """
        The type of grants (`authorization_code` or `implicit`) to allow when requesting access tokens from the OAuth provider.
        """
        return pulumi.get(self, "allowed_grant_types")

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> Optional[str]:
        """
        The URL that users are redirected to for authorization with the OAuth provider.
        """
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="claimMapping")
    def claim_mapping(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "claim_mapping")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The client ID for the OAuth provider, used to identify the application to the provider.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        The client secret for the OAuth provider, used to authenticate the application with the provider.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A brief description of the OAuth provider.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[str]:
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="jwksEndpoint")
    def jwks_endpoint(self) -> Optional[str]:
        """
        The URL where the application can retrieve JSON Web Key Sets (JWKS) for the OAuth provider.
        """
        return pulumi.get(self, "jwks_endpoint")

    @property
    @pulumi.getter
    def logo(self) -> Optional[str]:
        """
        The URL of the logo associated with the OAuth provider.
        """
        return pulumi.get(self, "logo")

    @property
    @pulumi.getter(name="mergeUserAccounts")
    def merge_user_accounts(self) -> Optional[bool]:
        """
        Whether to merge existing user accounts with new ones created through OAuth authentication.
        """
        return pulumi.get(self, "merge_user_accounts")

    @property
    @pulumi.getter
    def prompts(self) -> Optional[Sequence[str]]:
        """
        Custom prompts or consent screens that users may see during OAuth authentication.
        """
        return pulumi.get(self, "prompts")

    @property
    @pulumi.getter(name="providerTokenManagement")
    def provider_token_management(self) -> Optional['outputs.ProjectAuthenticationOauthSystemSlackProviderTokenManagement']:
        """
        Settings related to token management for the OAuth provider.
        """
        return pulumi.get(self, "provider_token_management")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        Scopes of access that the application requests from the user's account on the OAuth provider.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[str]:
        """
        The URL where the application requests an access token from the OAuth provider.
        """
        return pulumi.get(self, "token_endpoint")

    @property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> Optional[str]:
        """
        The URL where the application retrieves user information from the OAuth provider.
        """
        return pulumi.get(self, "user_info_endpoint")


@pulumi.output_type
class ProjectAuthenticationOauthSystemSlackProviderTokenManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callbackDomain":
            suggest = "callback_domain"
        elif key == "redirectUrl":
            suggest = "redirect_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOauthSystemSlackProviderTokenManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOauthSystemSlackProviderTokenManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOauthSystemSlackProviderTokenManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 callback_domain: Optional[str] = None,
                 redirect_url: Optional[str] = None):
        if callback_domain is not None:
            pulumi.set(__self__, "callback_domain", callback_domain)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)

    @property
    @pulumi.getter(name="callbackDomain")
    def callback_domain(self) -> Optional[str]:
        return pulumi.get(self, "callback_domain")

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[str]:
        return pulumi.get(self, "redirect_url")


@pulumi.output_type
class ProjectAuthenticationOtp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailService":
            suggest = "email_service"
        elif key == "expirationTime":
            suggest = "expiration_time"
        elif key == "textService":
            suggest = "text_service"
        elif key == "voiceService":
            suggest = "voice_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOtp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOtp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOtp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled: Optional[bool] = None,
                 domain: Optional[str] = None,
                 email_service: Optional['outputs.ProjectAuthenticationOtpEmailService'] = None,
                 expiration_time: Optional[str] = None,
                 text_service: Optional['outputs.ProjectAuthenticationOtpTextService'] = None,
                 voice_service: Optional['outputs.ProjectAuthenticationOtpVoiceService'] = None):
        """
        :param bool disabled: Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        :param str domain: The domain to embed in OTP messages.
        :param 'ProjectAuthenticationOtpEmailServiceArgs' email_service: Settings related to sending emails with OTP codes.
        :param str expiration_time: The amount of time that an OTP code will be valid for.
        :param 'ProjectAuthenticationOtpTextServiceArgs' text_service: Settings related to sending SMS messages with OTP codes.
        :param 'ProjectAuthenticationOtpVoiceServiceArgs' voice_service: Settings related to voice calls with OTP codes.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if email_service is not None:
            pulumi.set(__self__, "email_service", email_service)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if text_service is not None:
            pulumi.set(__self__, "text_service", text_service)
        if voice_service is not None:
            pulumi.set(__self__, "voice_service", voice_service)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        The domain to embed in OTP messages.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="emailService")
    def email_service(self) -> Optional['outputs.ProjectAuthenticationOtpEmailService']:
        """
        Settings related to sending emails with OTP codes.
        """
        return pulumi.get(self, "email_service")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[str]:
        """
        The amount of time that an OTP code will be valid for.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="textService")
    def text_service(self) -> Optional['outputs.ProjectAuthenticationOtpTextService']:
        """
        Settings related to sending SMS messages with OTP codes.
        """
        return pulumi.get(self, "text_service")

    @property
    @pulumi.getter(name="voiceService")
    def voice_service(self) -> Optional['outputs.ProjectAuthenticationOtpVoiceService']:
        """
        Settings related to voice calls with OTP codes.
        """
        return pulumi.get(self, "voice_service")


@pulumi.output_type
class ProjectAuthenticationOtpEmailService(dict):
    def __init__(__self__, *,
                 connector: str,
                 templates: Optional[Sequence['outputs.ProjectAuthenticationOtpEmailServiceTemplate']] = None):
        pulumi.set(__self__, "connector", connector)
        if templates is not None:
            pulumi.set(__self__, "templates", templates)

    @property
    @pulumi.getter
    def connector(self) -> str:
        return pulumi.get(self, "connector")

    @property
    @pulumi.getter
    def templates(self) -> Optional[Sequence['outputs.ProjectAuthenticationOtpEmailServiceTemplate']]:
        return pulumi.get(self, "templates")


@pulumi.output_type
class ProjectAuthenticationOtpEmailServiceTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "htmlBody":
            suggest = "html_body"
        elif key == "plainTextBody":
            suggest = "plain_text_body"
        elif key == "usePlainTextBody":
            suggest = "use_plain_text_body"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationOtpEmailServiceTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationOtpEmailServiceTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationOtpEmailServiceTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 subject: str,
                 active: Optional[bool] = None,
                 html_body: Optional[str] = None,
                 id: Optional[str] = None,
                 plain_text_body: Optional[str] = None,
                 use_plain_text_body: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "subject", subject)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if html_body is not None:
            pulumi.set(__self__, "html_body", html_body)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if plain_text_body is not None:
            pulumi.set(__self__, "plain_text_body", plain_text_body)
        if use_plain_text_body is not None:
            pulumi.set(__self__, "use_plain_text_body", use_plain_text_body)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def subject(self) -> str:
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def active(self) -> Optional[bool]:
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="htmlBody")
    def html_body(self) -> Optional[str]:
        return pulumi.get(self, "html_body")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="plainTextBody")
    def plain_text_body(self) -> Optional[str]:
        return pulumi.get(self, "plain_text_body")

    @property
    @pulumi.getter(name="usePlainTextBody")
    def use_plain_text_body(self) -> Optional[bool]:
        return pulumi.get(self, "use_plain_text_body")


@pulumi.output_type
class ProjectAuthenticationOtpTextService(dict):
    def __init__(__self__, *,
                 connector: str,
                 templates: Optional[Sequence['outputs.ProjectAuthenticationOtpTextServiceTemplate']] = None):
        pulumi.set(__self__, "connector", connector)
        if templates is not None:
            pulumi.set(__self__, "templates", templates)

    @property
    @pulumi.getter
    def connector(self) -> str:
        return pulumi.get(self, "connector")

    @property
    @pulumi.getter
    def templates(self) -> Optional[Sequence['outputs.ProjectAuthenticationOtpTextServiceTemplate']]:
        return pulumi.get(self, "templates")


@pulumi.output_type
class ProjectAuthenticationOtpTextServiceTemplate(dict):
    def __init__(__self__, *,
                 body: str,
                 name: str,
                 active: Optional[bool] = None,
                 id: Optional[str] = None):
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "name", name)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def body(self) -> str:
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def active(self) -> Optional[bool]:
        return pulumi.get(self, "active")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectAuthenticationOtpVoiceService(dict):
    def __init__(__self__, *,
                 connector: str,
                 templates: Optional[Sequence['outputs.ProjectAuthenticationOtpVoiceServiceTemplate']] = None):
        pulumi.set(__self__, "connector", connector)
        if templates is not None:
            pulumi.set(__self__, "templates", templates)

    @property
    @pulumi.getter
    def connector(self) -> str:
        return pulumi.get(self, "connector")

    @property
    @pulumi.getter
    def templates(self) -> Optional[Sequence['outputs.ProjectAuthenticationOtpVoiceServiceTemplate']]:
        return pulumi.get(self, "templates")


@pulumi.output_type
class ProjectAuthenticationOtpVoiceServiceTemplate(dict):
    def __init__(__self__, *,
                 body: str,
                 name: str,
                 active: Optional[bool] = None,
                 id: Optional[str] = None):
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "name", name)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def body(self) -> str:
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def active(self) -> Optional[bool]:
        return pulumi.get(self, "active")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectAuthenticationPasskeys(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topLevelDomain":
            suggest = "top_level_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationPasskeys. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationPasskeys.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationPasskeys.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled: Optional[bool] = None,
                 top_level_domain: Optional[str] = None):
        """
        :param bool disabled: Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        :param str top_level_domain: Passkeys will be usable in the following domain and all its subdomains.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if top_level_domain is not None:
            pulumi.set(__self__, "top_level_domain", top_level_domain)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="topLevelDomain")
    def top_level_domain(self) -> Optional[str]:
        """
        Passkeys will be usable in the following domain and all its subdomains.
        """
        return pulumi.get(self, "top_level_domain")


@pulumi.output_type
class ProjectAuthenticationPassword(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailService":
            suggest = "email_service"
        elif key == "expirationWeeks":
            suggest = "expiration_weeks"
        elif key == "lockAttempts":
            suggest = "lock_attempts"
        elif key == "minLength":
            suggest = "min_length"
        elif key == "nonAlphanumeric":
            suggest = "non_alphanumeric"
        elif key == "reuseAmount":
            suggest = "reuse_amount"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationPassword. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationPassword.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationPassword.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled: Optional[bool] = None,
                 email_service: Optional['outputs.ProjectAuthenticationPasswordEmailService'] = None,
                 expiration: Optional[bool] = None,
                 expiration_weeks: Optional[int] = None,
                 lock: Optional[bool] = None,
                 lock_attempts: Optional[int] = None,
                 lowercase: Optional[bool] = None,
                 min_length: Optional[int] = None,
                 non_alphanumeric: Optional[bool] = None,
                 number: Optional[bool] = None,
                 reuse: Optional[bool] = None,
                 reuse_amount: Optional[int] = None,
                 uppercase: Optional[bool] = None):
        """
        :param bool disabled: Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        :param 'ProjectAuthenticationPasswordEmailServiceArgs' email_service: Settings related to sending password reset emails as part of the password feature.
        :param bool expiration: Whether users are required to change their password periodically.
        :param int expiration_weeks: The number of weeks after which a user's password expires and they need to replace it.
        :param bool lock: Whether the user account should be locked after a specified number of failed login attempts.
        :param int lock_attempts: The number of failed login attempts allowed before an account is locked.
        :param bool lowercase: Whether passwords must contain at least one lowercase letter.
        :param int min_length: The minimum length of the password that users are required to use. The maximum length is always `64`.
        :param bool non_alphanumeric: Whether passwords must contain at least one non-alphanumeric character (e.g. `!`, `@`, `#`).
        :param bool number: Whether passwords must contain at least one number.
        :param bool reuse: Whether to forbid password reuse when users change their password.
        :param bool uppercase: Whether passwords must contain at least one uppercase letter.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if email_service is not None:
            pulumi.set(__self__, "email_service", email_service)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if expiration_weeks is not None:
            pulumi.set(__self__, "expiration_weeks", expiration_weeks)
        if lock is not None:
            pulumi.set(__self__, "lock", lock)
        if lock_attempts is not None:
            pulumi.set(__self__, "lock_attempts", lock_attempts)
        if lowercase is not None:
            pulumi.set(__self__, "lowercase", lowercase)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)
        if non_alphanumeric is not None:
            pulumi.set(__self__, "non_alphanumeric", non_alphanumeric)
        if number is not None:
            pulumi.set(__self__, "number", number)
        if reuse is not None:
            pulumi.set(__self__, "reuse", reuse)
        if reuse_amount is not None:
            pulumi.set(__self__, "reuse_amount", reuse_amount)
        if uppercase is not None:
            pulumi.set(__self__, "uppercase", uppercase)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="emailService")
    def email_service(self) -> Optional['outputs.ProjectAuthenticationPasswordEmailService']:
        """
        Settings related to sending password reset emails as part of the password feature.
        """
        return pulumi.get(self, "email_service")

    @property
    @pulumi.getter
    def expiration(self) -> Optional[bool]:
        """
        Whether users are required to change their password periodically.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter(name="expirationWeeks")
    def expiration_weeks(self) -> Optional[int]:
        """
        The number of weeks after which a user's password expires and they need to replace it.
        """
        return pulumi.get(self, "expiration_weeks")

    @property
    @pulumi.getter
    def lock(self) -> Optional[bool]:
        """
        Whether the user account should be locked after a specified number of failed login attempts.
        """
        return pulumi.get(self, "lock")

    @property
    @pulumi.getter(name="lockAttempts")
    def lock_attempts(self) -> Optional[int]:
        """
        The number of failed login attempts allowed before an account is locked.
        """
        return pulumi.get(self, "lock_attempts")

    @property
    @pulumi.getter
    def lowercase(self) -> Optional[bool]:
        """
        Whether passwords must contain at least one lowercase letter.
        """
        return pulumi.get(self, "lowercase")

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[int]:
        """
        The minimum length of the password that users are required to use. The maximum length is always `64`.
        """
        return pulumi.get(self, "min_length")

    @property
    @pulumi.getter(name="nonAlphanumeric")
    def non_alphanumeric(self) -> Optional[bool]:
        """
        Whether passwords must contain at least one non-alphanumeric character (e.g. `!`, `@`, `#`).
        """
        return pulumi.get(self, "non_alphanumeric")

    @property
    @pulumi.getter
    def number(self) -> Optional[bool]:
        """
        Whether passwords must contain at least one number.
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter
    def reuse(self) -> Optional[bool]:
        """
        Whether to forbid password reuse when users change their password.
        """
        return pulumi.get(self, "reuse")

    @property
    @pulumi.getter(name="reuseAmount")
    def reuse_amount(self) -> Optional[int]:
        return pulumi.get(self, "reuse_amount")

    @property
    @pulumi.getter
    def uppercase(self) -> Optional[bool]:
        """
        Whether passwords must contain at least one uppercase letter.
        """
        return pulumi.get(self, "uppercase")


@pulumi.output_type
class ProjectAuthenticationPasswordEmailService(dict):
    def __init__(__self__, *,
                 connector: str,
                 templates: Optional[Sequence['outputs.ProjectAuthenticationPasswordEmailServiceTemplate']] = None):
        pulumi.set(__self__, "connector", connector)
        if templates is not None:
            pulumi.set(__self__, "templates", templates)

    @property
    @pulumi.getter
    def connector(self) -> str:
        return pulumi.get(self, "connector")

    @property
    @pulumi.getter
    def templates(self) -> Optional[Sequence['outputs.ProjectAuthenticationPasswordEmailServiceTemplate']]:
        return pulumi.get(self, "templates")


@pulumi.output_type
class ProjectAuthenticationPasswordEmailServiceTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "htmlBody":
            suggest = "html_body"
        elif key == "plainTextBody":
            suggest = "plain_text_body"
        elif key == "usePlainTextBody":
            suggest = "use_plain_text_body"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationPasswordEmailServiceTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationPasswordEmailServiceTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationPasswordEmailServiceTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 subject: str,
                 active: Optional[bool] = None,
                 html_body: Optional[str] = None,
                 id: Optional[str] = None,
                 plain_text_body: Optional[str] = None,
                 use_plain_text_body: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "subject", subject)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if html_body is not None:
            pulumi.set(__self__, "html_body", html_body)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if plain_text_body is not None:
            pulumi.set(__self__, "plain_text_body", plain_text_body)
        if use_plain_text_body is not None:
            pulumi.set(__self__, "use_plain_text_body", use_plain_text_body)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def subject(self) -> str:
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def active(self) -> Optional[bool]:
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="htmlBody")
    def html_body(self) -> Optional[str]:
        return pulumi.get(self, "html_body")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="plainTextBody")
    def plain_text_body(self) -> Optional[str]:
        return pulumi.get(self, "plain_text_body")

    @property
    @pulumi.getter(name="usePlainTextBody")
    def use_plain_text_body(self) -> Optional[bool]:
        return pulumi.get(self, "use_plain_text_body")


@pulumi.output_type
class ProjectAuthenticationSso(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mergeUsers":
            suggest = "merge_users"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAuthenticationSso. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAuthenticationSso.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAuthenticationSso.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled: Optional[bool] = None,
                 merge_users: Optional[bool] = None):
        """
        :param bool disabled: Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        :param bool merge_users: Whether to merge existing user accounts with new ones created through SSO authentication.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if merge_users is not None:
            pulumi.set(__self__, "merge_users", merge_users)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="mergeUsers")
    def merge_users(self) -> Optional[bool]:
        """
        Whether to merge existing user accounts with new ones created through SSO authentication.
        """
        return pulumi.get(self, "merge_users")


@pulumi.output_type
class ProjectAuthenticationTotp(dict):
    def __init__(__self__, *,
                 disabled: Optional[bool] = None):
        """
        :param bool disabled: Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Setting this to `true` will disallow using this authentication method directly via API and SDK calls. Note that this does not affect authentication flows that are configured to use this authentication method.
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class ProjectAuthorization(dict):
    def __init__(__self__, *,
                 permissions: Optional[Sequence['outputs.ProjectAuthorizationPermission']] = None,
                 roles: Optional[Sequence['outputs.ProjectAuthorizationRole']] = None):
        """
        :param Sequence['ProjectAuthorizationPermissionArgs'] permissions: A list of `Permission` objects.
        :param Sequence['ProjectAuthorizationRoleArgs'] roles: A list of `Role` objects.
        """
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[Sequence['outputs.ProjectAuthorizationPermission']]:
        """
        A list of `Permission` objects.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def roles(self) -> Optional[Sequence['outputs.ProjectAuthorizationRole']]:
        """
        A list of `Role` objects.
        """
        return pulumi.get(self, "roles")


@pulumi.output_type
class ProjectAuthorizationPermission(dict):
    def __init__(__self__, *,
                 name: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str name: A name for the permission.
        :param str description: A description for the permission.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A name for the permission.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description for the permission.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectAuthorizationRole(dict):
    def __init__(__self__, *,
                 name: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None,
                 permissions: Optional[Sequence[str]] = None):
        """
        :param str name: A name for the role.
        :param str description: A description for the role.
        :param Sequence[str] permissions: A list of permissions by name to be included in the role.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A name for the role.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description for the role.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def permissions(self) -> Optional[Sequence[str]]:
        """
        A list of permissions by name to be included in the role.
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class ProjectConnectors(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditWebhooks":
            suggest = "audit_webhooks"
        elif key == "awsS3s":
            suggest = "aws_s3s"
        elif key == "awsTranslates":
            suggest = "aws_translates"
        elif key == "devrevGrows":
            suggest = "devrev_grows"
        elif key == "fingerprintDescopes":
            suggest = "fingerprint_descopes"
        elif key == "genericSmsGateways":
            suggest = "generic_sms_gateways"
        elif key == "googleCloudTranslations":
            suggest = "google_cloud_translations"
        elif key == "recaptchaEnterprises":
            suggest = "recaptcha_enterprises"
        elif key == "salesforceMarketingClouds":
            suggest = "salesforce_marketing_clouds"
        elif key == "twilioCores":
            suggest = "twilio_cores"
        elif key == "twilioVerifies":
            suggest = "twilio_verifies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 abuseipdbs: Optional[Sequence['outputs.ProjectConnectorsAbuseipdb']] = None,
                 amplitudes: Optional[Sequence['outputs.ProjectConnectorsAmplitude']] = None,
                 audit_webhooks: Optional[Sequence['outputs.ProjectConnectorsAuditWebhook']] = None,
                 aws_s3s: Optional[Sequence['outputs.ProjectConnectorsAwsS3']] = None,
                 aws_translates: Optional[Sequence['outputs.ProjectConnectorsAwsTranslate']] = None,
                 clears: Optional[Sequence['outputs.ProjectConnectorsClear']] = None,
                 datadogs: Optional[Sequence['outputs.ProjectConnectorsDatadog']] = None,
                 devrev_grows: Optional[Sequence['outputs.ProjectConnectorsDevrevGrow']] = None,
                 docebos: Optional[Sequence['outputs.ProjectConnectorsDocebo']] = None,
                 fingerprint_descopes: Optional[Sequence['outputs.ProjectConnectorsFingerprintDescope']] = None,
                 fingerprints: Optional[Sequence['outputs.ProjectConnectorsFingerprint']] = None,
                 forters: Optional[Sequence['outputs.ProjectConnectorsForter']] = None,
                 generic_sms_gateways: Optional[Sequence['outputs.ProjectConnectorsGenericSmsGateway']] = None,
                 google_cloud_translations: Optional[Sequence['outputs.ProjectConnectorsGoogleCloudTranslation']] = None,
                 hibps: Optional[Sequence['outputs.ProjectConnectorsHibp']] = None,
                 https: Optional[Sequence['outputs.ProjectConnectorsHttp']] = None,
                 hubspots: Optional[Sequence['outputs.ProjectConnectorsHubspot']] = None,
                 incodes: Optional[Sequence['outputs.ProjectConnectorsIncode']] = None,
                 intercoms: Optional[Sequence['outputs.ProjectConnectorsIntercom']] = None,
                 lokalises: Optional[Sequence['outputs.ProjectConnectorsLokalise']] = None,
                 mparticles: Optional[Sequence['outputs.ProjectConnectorsMparticle']] = None,
                 newrelics: Optional[Sequence['outputs.ProjectConnectorsNewrelic']] = None,
                 recaptcha_enterprises: Optional[Sequence['outputs.ProjectConnectorsRecaptchaEnterprise']] = None,
                 recaptchas: Optional[Sequence['outputs.ProjectConnectorsRecaptcha']] = None,
                 rekognitions: Optional[Sequence['outputs.ProjectConnectorsRekognition']] = None,
                 salesforce_marketing_clouds: Optional[Sequence['outputs.ProjectConnectorsSalesforceMarketingCloud']] = None,
                 salesforces: Optional[Sequence['outputs.ProjectConnectorsSalesforce']] = None,
                 segments: Optional[Sequence['outputs.ProjectConnectorsSegment']] = None,
                 sendgrids: Optional[Sequence['outputs.ProjectConnectorsSendgrid']] = None,
                 ses: Optional[Sequence['outputs.ProjectConnectorsSe']] = None,
                 slacks: Optional[Sequence['outputs.ProjectConnectorsSlack']] = None,
                 smartlings: Optional[Sequence['outputs.ProjectConnectorsSmartling']] = None,
                 smtps: Optional[Sequence['outputs.ProjectConnectorsSmtp']] = None,
                 sns: Optional[Sequence['outputs.ProjectConnectorsSn']] = None,
                 sumologics: Optional[Sequence['outputs.ProjectConnectorsSumologic']] = None,
                 telesigns: Optional[Sequence['outputs.ProjectConnectorsTelesign']] = None,
                 traceables: Optional[Sequence['outputs.ProjectConnectorsTraceable']] = None,
                 twilio_cores: Optional[Sequence['outputs.ProjectConnectorsTwilioCore']] = None,
                 twilio_verifies: Optional[Sequence['outputs.ProjectConnectorsTwilioVerify']] = None):
        """
        :param Sequence['ProjectConnectorsAbuseipdbArgs'] abuseipdbs: AbuseIPDB provides an API to identify if an IP address has been associated with malicious activities online.
        :param Sequence['ProjectConnectorsAmplitudeArgs'] amplitudes: Amplitude, an analytics product that allows you to collects events from web and mobile apps, unify those and use those to better understand your customers needs.
        :param Sequence['ProjectConnectorsClearArgs'] clears: An identity verification platform that allow customers to digitally verify their identity from anywhere.
        :param Sequence['ProjectConnectorsDatadogArgs'] datadogs: Datadog, an observability service for cloud-scale applications, providing monitoring of servers, databases, tools, and services, through a SaaS-based data analytics platform.
        :param Sequence['ProjectConnectorsDoceboArgs'] docebos: Docebo is a cloud-based Learning Management System (LMS) designed to increase performance and learning engagement.
        :param Sequence['ProjectConnectorsFingerprintArgs'] fingerprints: Use the Fingerprint (formerly FingerprintJS) connector to add device intelligence and prevent fraud.
        :param Sequence['ProjectConnectorsForterArgs'] forters: Use the Forter connector for account fraud prevention.
        :param Sequence['ProjectConnectorsHibpArgs'] hibps: API to check if password appeared previously exposed in data breaches.
        :param Sequence['ProjectConnectorsHttpArgs'] https: A general purpose HTTP client
        :param Sequence['ProjectConnectorsHubspotArgs'] hubspots: HubSpot is a CRM platform with software, integrations, and resources needed to connect marketing, sales, content management, and customer service.
        :param Sequence['ProjectConnectorsIncodeArgs'] incodes: Use the Incode connection to run identity verification processes like document checks or facial recognition.
        :param Sequence['ProjectConnectorsIntercomArgs'] intercoms: Intercom is a Conversational Relationship Platform (CRP).
        :param Sequence['ProjectConnectorsLokaliseArgs'] lokalises: Localize the language of your login and user journey screens with the Lokalise connector.
        :param Sequence['ProjectConnectorsMparticleArgs'] mparticles: Track and send user event data (e.g. page views, purchases, etc.) across connected tools using the mParticle connector.
        :param Sequence['ProjectConnectorsNewrelicArgs'] newrelics: Use this connector to send audit events and troubleshooting logs to New Relic.
        :param Sequence['ProjectConnectorsRecaptchaArgs'] recaptchas: reCAPTCHA is a free google service that protects your site from spam and abuse. It uses advanced risk analysis techniques to tell humans and bots apart.
        :param Sequence['ProjectConnectorsRekognitionArgs'] rekognitions: AWS Rekognition, cloud-based AI service that offers computer vision capabilities for analyzing and processing images. Useful for registration and verification processes, and can be used to detect fraud and prevent identity theft.
        :param Sequence['ProjectConnectorsSalesforceArgs'] salesforces: Salesforce is a leading cloud-based Customer Relationship Management (CRM) platform that helps businesses streamline their sales, service, and marketing operations.
        :param Sequence['ProjectConnectorsSegmentArgs'] segments: Segment, an analytics product that allows you to collects events from web and mobile apps, unify those and use those to better understand your customers needs.
        :param Sequence['ProjectConnectorsSlackArgs'] slacks: Send updates to your team on Slack.
        :param Sequence['ProjectConnectorsSmartlingArgs'] smartlings: Localize the language of your login and user journey screens with the Smartling connector.
        :param Sequence['ProjectConnectorsSumologicArgs'] sumologics: Sumo Logic, fast troubleshooting and investigation with AI/ML-powered log analytics
        :param Sequence['ProjectConnectorsTelesignArgs'] telesigns: Telesign Phone number intelligence API provides risk score for phone numbers.
        :param Sequence['ProjectConnectorsTraceableArgs'] traceables: API security for a cloud-first, API-driven world.
        """
        if abuseipdbs is not None:
            pulumi.set(__self__, "abuseipdbs", abuseipdbs)
        if amplitudes is not None:
            pulumi.set(__self__, "amplitudes", amplitudes)
        if audit_webhooks is not None:
            pulumi.set(__self__, "audit_webhooks", audit_webhooks)
        if aws_s3s is not None:
            pulumi.set(__self__, "aws_s3s", aws_s3s)
        if aws_translates is not None:
            pulumi.set(__self__, "aws_translates", aws_translates)
        if clears is not None:
            pulumi.set(__self__, "clears", clears)
        if datadogs is not None:
            pulumi.set(__self__, "datadogs", datadogs)
        if devrev_grows is not None:
            pulumi.set(__self__, "devrev_grows", devrev_grows)
        if docebos is not None:
            pulumi.set(__self__, "docebos", docebos)
        if fingerprint_descopes is not None:
            pulumi.set(__self__, "fingerprint_descopes", fingerprint_descopes)
        if fingerprints is not None:
            pulumi.set(__self__, "fingerprints", fingerprints)
        if forters is not None:
            pulumi.set(__self__, "forters", forters)
        if generic_sms_gateways is not None:
            pulumi.set(__self__, "generic_sms_gateways", generic_sms_gateways)
        if google_cloud_translations is not None:
            pulumi.set(__self__, "google_cloud_translations", google_cloud_translations)
        if hibps is not None:
            pulumi.set(__self__, "hibps", hibps)
        if https is not None:
            pulumi.set(__self__, "https", https)
        if hubspots is not None:
            pulumi.set(__self__, "hubspots", hubspots)
        if incodes is not None:
            pulumi.set(__self__, "incodes", incodes)
        if intercoms is not None:
            pulumi.set(__self__, "intercoms", intercoms)
        if lokalises is not None:
            pulumi.set(__self__, "lokalises", lokalises)
        if mparticles is not None:
            pulumi.set(__self__, "mparticles", mparticles)
        if newrelics is not None:
            pulumi.set(__self__, "newrelics", newrelics)
        if recaptcha_enterprises is not None:
            pulumi.set(__self__, "recaptcha_enterprises", recaptcha_enterprises)
        if recaptchas is not None:
            pulumi.set(__self__, "recaptchas", recaptchas)
        if rekognitions is not None:
            pulumi.set(__self__, "rekognitions", rekognitions)
        if salesforce_marketing_clouds is not None:
            pulumi.set(__self__, "salesforce_marketing_clouds", salesforce_marketing_clouds)
        if salesforces is not None:
            pulumi.set(__self__, "salesforces", salesforces)
        if segments is not None:
            pulumi.set(__self__, "segments", segments)
        if sendgrids is not None:
            pulumi.set(__self__, "sendgrids", sendgrids)
        if ses is not None:
            pulumi.set(__self__, "ses", ses)
        if slacks is not None:
            pulumi.set(__self__, "slacks", slacks)
        if smartlings is not None:
            pulumi.set(__self__, "smartlings", smartlings)
        if smtps is not None:
            pulumi.set(__self__, "smtps", smtps)
        if sns is not None:
            pulumi.set(__self__, "sns", sns)
        if sumologics is not None:
            pulumi.set(__self__, "sumologics", sumologics)
        if telesigns is not None:
            pulumi.set(__self__, "telesigns", telesigns)
        if traceables is not None:
            pulumi.set(__self__, "traceables", traceables)
        if twilio_cores is not None:
            pulumi.set(__self__, "twilio_cores", twilio_cores)
        if twilio_verifies is not None:
            pulumi.set(__self__, "twilio_verifies", twilio_verifies)

    @property
    @pulumi.getter
    def abuseipdbs(self) -> Optional[Sequence['outputs.ProjectConnectorsAbuseipdb']]:
        """
        AbuseIPDB provides an API to identify if an IP address has been associated with malicious activities online.
        """
        return pulumi.get(self, "abuseipdbs")

    @property
    @pulumi.getter
    def amplitudes(self) -> Optional[Sequence['outputs.ProjectConnectorsAmplitude']]:
        """
        Amplitude, an analytics product that allows you to collects events from web and mobile apps, unify those and use those to better understand your customers needs.
        """
        return pulumi.get(self, "amplitudes")

    @property
    @pulumi.getter(name="auditWebhooks")
    def audit_webhooks(self) -> Optional[Sequence['outputs.ProjectConnectorsAuditWebhook']]:
        return pulumi.get(self, "audit_webhooks")

    @property
    @pulumi.getter(name="awsS3s")
    def aws_s3s(self) -> Optional[Sequence['outputs.ProjectConnectorsAwsS3']]:
        return pulumi.get(self, "aws_s3s")

    @property
    @pulumi.getter(name="awsTranslates")
    def aws_translates(self) -> Optional[Sequence['outputs.ProjectConnectorsAwsTranslate']]:
        return pulumi.get(self, "aws_translates")

    @property
    @pulumi.getter
    def clears(self) -> Optional[Sequence['outputs.ProjectConnectorsClear']]:
        """
        An identity verification platform that allow customers to digitally verify their identity from anywhere.
        """
        return pulumi.get(self, "clears")

    @property
    @pulumi.getter
    def datadogs(self) -> Optional[Sequence['outputs.ProjectConnectorsDatadog']]:
        """
        Datadog, an observability service for cloud-scale applications, providing monitoring of servers, databases, tools, and services, through a SaaS-based data analytics platform.
        """
        return pulumi.get(self, "datadogs")

    @property
    @pulumi.getter(name="devrevGrows")
    def devrev_grows(self) -> Optional[Sequence['outputs.ProjectConnectorsDevrevGrow']]:
        return pulumi.get(self, "devrev_grows")

    @property
    @pulumi.getter
    def docebos(self) -> Optional[Sequence['outputs.ProjectConnectorsDocebo']]:
        """
        Docebo is a cloud-based Learning Management System (LMS) designed to increase performance and learning engagement.
        """
        return pulumi.get(self, "docebos")

    @property
    @pulumi.getter(name="fingerprintDescopes")
    def fingerprint_descopes(self) -> Optional[Sequence['outputs.ProjectConnectorsFingerprintDescope']]:
        return pulumi.get(self, "fingerprint_descopes")

    @property
    @pulumi.getter
    def fingerprints(self) -> Optional[Sequence['outputs.ProjectConnectorsFingerprint']]:
        """
        Use the Fingerprint (formerly FingerprintJS) connector to add device intelligence and prevent fraud.
        """
        return pulumi.get(self, "fingerprints")

    @property
    @pulumi.getter
    def forters(self) -> Optional[Sequence['outputs.ProjectConnectorsForter']]:
        """
        Use the Forter connector for account fraud prevention.
        """
        return pulumi.get(self, "forters")

    @property
    @pulumi.getter(name="genericSmsGateways")
    def generic_sms_gateways(self) -> Optional[Sequence['outputs.ProjectConnectorsGenericSmsGateway']]:
        return pulumi.get(self, "generic_sms_gateways")

    @property
    @pulumi.getter(name="googleCloudTranslations")
    def google_cloud_translations(self) -> Optional[Sequence['outputs.ProjectConnectorsGoogleCloudTranslation']]:
        return pulumi.get(self, "google_cloud_translations")

    @property
    @pulumi.getter
    def hibps(self) -> Optional[Sequence['outputs.ProjectConnectorsHibp']]:
        """
        API to check if password appeared previously exposed in data breaches.
        """
        return pulumi.get(self, "hibps")

    @property
    @pulumi.getter
    def https(self) -> Optional[Sequence['outputs.ProjectConnectorsHttp']]:
        """
        A general purpose HTTP client
        """
        return pulumi.get(self, "https")

    @property
    @pulumi.getter
    def hubspots(self) -> Optional[Sequence['outputs.ProjectConnectorsHubspot']]:
        """
        HubSpot is a CRM platform with software, integrations, and resources needed to connect marketing, sales, content management, and customer service.
        """
        return pulumi.get(self, "hubspots")

    @property
    @pulumi.getter
    def incodes(self) -> Optional[Sequence['outputs.ProjectConnectorsIncode']]:
        """
        Use the Incode connection to run identity verification processes like document checks or facial recognition.
        """
        return pulumi.get(self, "incodes")

    @property
    @pulumi.getter
    def intercoms(self) -> Optional[Sequence['outputs.ProjectConnectorsIntercom']]:
        """
        Intercom is a Conversational Relationship Platform (CRP).
        """
        return pulumi.get(self, "intercoms")

    @property
    @pulumi.getter
    def lokalises(self) -> Optional[Sequence['outputs.ProjectConnectorsLokalise']]:
        """
        Localize the language of your login and user journey screens with the Lokalise connector.
        """
        return pulumi.get(self, "lokalises")

    @property
    @pulumi.getter
    def mparticles(self) -> Optional[Sequence['outputs.ProjectConnectorsMparticle']]:
        """
        Track and send user event data (e.g. page views, purchases, etc.) across connected tools using the mParticle connector.
        """
        return pulumi.get(self, "mparticles")

    @property
    @pulumi.getter
    def newrelics(self) -> Optional[Sequence['outputs.ProjectConnectorsNewrelic']]:
        """
        Use this connector to send audit events and troubleshooting logs to New Relic.
        """
        return pulumi.get(self, "newrelics")

    @property
    @pulumi.getter(name="recaptchaEnterprises")
    def recaptcha_enterprises(self) -> Optional[Sequence['outputs.ProjectConnectorsRecaptchaEnterprise']]:
        return pulumi.get(self, "recaptcha_enterprises")

    @property
    @pulumi.getter
    def recaptchas(self) -> Optional[Sequence['outputs.ProjectConnectorsRecaptcha']]:
        """
        reCAPTCHA is a free google service that protects your site from spam and abuse. It uses advanced risk analysis techniques to tell humans and bots apart.
        """
        return pulumi.get(self, "recaptchas")

    @property
    @pulumi.getter
    def rekognitions(self) -> Optional[Sequence['outputs.ProjectConnectorsRekognition']]:
        """
        AWS Rekognition, cloud-based AI service that offers computer vision capabilities for analyzing and processing images. Useful for registration and verification processes, and can be used to detect fraud and prevent identity theft.
        """
        return pulumi.get(self, "rekognitions")

    @property
    @pulumi.getter(name="salesforceMarketingClouds")
    def salesforce_marketing_clouds(self) -> Optional[Sequence['outputs.ProjectConnectorsSalesforceMarketingCloud']]:
        return pulumi.get(self, "salesforce_marketing_clouds")

    @property
    @pulumi.getter
    def salesforces(self) -> Optional[Sequence['outputs.ProjectConnectorsSalesforce']]:
        """
        Salesforce is a leading cloud-based Customer Relationship Management (CRM) platform that helps businesses streamline their sales, service, and marketing operations.
        """
        return pulumi.get(self, "salesforces")

    @property
    @pulumi.getter
    def segments(self) -> Optional[Sequence['outputs.ProjectConnectorsSegment']]:
        """
        Segment, an analytics product that allows you to collects events from web and mobile apps, unify those and use those to better understand your customers needs.
        """
        return pulumi.get(self, "segments")

    @property
    @pulumi.getter
    def sendgrids(self) -> Optional[Sequence['outputs.ProjectConnectorsSendgrid']]:
        return pulumi.get(self, "sendgrids")

    @property
    @pulumi.getter
    def ses(self) -> Optional[Sequence['outputs.ProjectConnectorsSe']]:
        return pulumi.get(self, "ses")

    @property
    @pulumi.getter
    def slacks(self) -> Optional[Sequence['outputs.ProjectConnectorsSlack']]:
        """
        Send updates to your team on Slack.
        """
        return pulumi.get(self, "slacks")

    @property
    @pulumi.getter
    def smartlings(self) -> Optional[Sequence['outputs.ProjectConnectorsSmartling']]:
        """
        Localize the language of your login and user journey screens with the Smartling connector.
        """
        return pulumi.get(self, "smartlings")

    @property
    @pulumi.getter
    def smtps(self) -> Optional[Sequence['outputs.ProjectConnectorsSmtp']]:
        return pulumi.get(self, "smtps")

    @property
    @pulumi.getter
    def sns(self) -> Optional[Sequence['outputs.ProjectConnectorsSn']]:
        return pulumi.get(self, "sns")

    @property
    @pulumi.getter
    def sumologics(self) -> Optional[Sequence['outputs.ProjectConnectorsSumologic']]:
        """
        Sumo Logic, fast troubleshooting and investigation with AI/ML-powered log analytics
        """
        return pulumi.get(self, "sumologics")

    @property
    @pulumi.getter
    def telesigns(self) -> Optional[Sequence['outputs.ProjectConnectorsTelesign']]:
        """
        Telesign Phone number intelligence API provides risk score for phone numbers.
        """
        return pulumi.get(self, "telesigns")

    @property
    @pulumi.getter
    def traceables(self) -> Optional[Sequence['outputs.ProjectConnectorsTraceable']]:
        """
        API security for a cloud-first, API-driven world.
        """
        return pulumi.get(self, "traceables")

    @property
    @pulumi.getter(name="twilioCores")
    def twilio_cores(self) -> Optional[Sequence['outputs.ProjectConnectorsTwilioCore']]:
        return pulumi.get(self, "twilio_cores")

    @property
    @pulumi.getter(name="twilioVerifies")
    def twilio_verifies(self) -> Optional[Sequence['outputs.ProjectConnectorsTwilioVerify']]:
        return pulumi.get(self, "twilio_verifies")


@pulumi.output_type
class ProjectConnectorsAbuseipdb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsAbuseipdb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsAbuseipdb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsAbuseipdb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str,
                 name: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str api_key: The unique AbuseIPDB API key.
        :param str name: A custom name for your connector.
        :param str description: A description of what your connector is used for.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        The unique AbuseIPDB API key.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectConnectorsAmplitude(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "serverUrl":
            suggest = "server_url"
        elif key == "serverZone":
            suggest = "server_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsAmplitude. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsAmplitude.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsAmplitude.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str,
                 name: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None,
                 server_url: Optional[str] = None,
                 server_zone: Optional[str] = None):
        """
        :param str api_key: The Amplitude API Key generated for the Descope service.
        :param str name: A custom name for your connector.
        :param str description: A description of what your connector is used for.
        :param str server_url: The server URL of the Amplitude API, when using different api or a custom domain in Amplitude.
        :param str server_zone: `EU` or `US`. Sets the Amplitude server zone. Set this to `EU` for Amplitude projects created in `EU` data center. Default is `US`.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if server_url is not None:
            pulumi.set(__self__, "server_url", server_url)
        if server_zone is not None:
            pulumi.set(__self__, "server_zone", server_zone)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        The Amplitude API Key generated for the Descope service.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> Optional[str]:
        """
        The server URL of the Amplitude API, when using different api or a custom domain in Amplitude.
        """
        return pulumi.get(self, "server_url")

    @property
    @pulumi.getter(name="serverZone")
    def server_zone(self) -> Optional[str]:
        """
        `EU` or `US`. Sets the Amplitude server zone. Set this to `EU` for Amplitude projects created in `EU` data center. Default is `US`.
        """
        return pulumi.get(self, "server_zone")


@pulumi.output_type
class ProjectConnectorsAuditWebhook(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseUrl":
            suggest = "base_url"
        elif key == "auditFilters":
            suggest = "audit_filters"
        elif key == "hmacSecret":
            suggest = "hmac_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsAuditWebhook. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsAuditWebhook.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsAuditWebhook.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_url: str,
                 name: str,
                 audit_filters: Optional[Sequence['outputs.ProjectConnectorsAuditWebhookAuditFilter']] = None,
                 authentication: Optional['outputs.ProjectConnectorsAuditWebhookAuthentication'] = None,
                 description: Optional[str] = None,
                 headers: Optional[Mapping[str, str]] = None,
                 hmac_secret: Optional[str] = None,
                 id: Optional[str] = None,
                 insecure: Optional[bool] = None):
        """
        :param str base_url: The base URL to fetch
        :param str name: A custom name for your connector.
        :param Sequence['ProjectConnectorsAuditWebhookAuditFilterArgs'] audit_filters: Specify which events will be sent to the external audit service (including tenant selection).
        :param 'ProjectConnectorsAuditWebhookAuthenticationArgs' authentication: Authentication Information
        :param str description: A description of what your connector is used for.
        :param Mapping[str, str] headers: The headers to send with the request
        :param str hmac_secret: HMAC is a method for message signing with a symmetrical key. This secret will be used to sign the payload, and the resulting signature will be sent in the `x-descope-webhook-s256` header. The receiving service should use this secret to verify the integrity and authenticity of the payload by checking the provided signature
        :param bool insecure: Will ignore certificate errors raised by the client
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "name", name)
        if audit_filters is not None:
            pulumi.set(__self__, "audit_filters", audit_filters)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if hmac_secret is not None:
            pulumi.set(__self__, "hmac_secret", hmac_secret)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> str:
        """
        The base URL to fetch
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="auditFilters")
    def audit_filters(self) -> Optional[Sequence['outputs.ProjectConnectorsAuditWebhookAuditFilter']]:
        """
        Specify which events will be sent to the external audit service (including tenant selection).
        """
        return pulumi.get(self, "audit_filters")

    @property
    @pulumi.getter
    def authentication(self) -> Optional['outputs.ProjectConnectorsAuditWebhookAuthentication']:
        """
        Authentication Information
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Mapping[str, str]]:
        """
        The headers to send with the request
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="hmacSecret")
    def hmac_secret(self) -> Optional[str]:
        """
        HMAC is a method for message signing with a symmetrical key. This secret will be used to sign the payload, and the resulting signature will be sent in the `x-descope-webhook-s256` header. The receiving service should use this secret to verify the integrity and authenticity of the payload by checking the provided signature
        """
        return pulumi.get(self, "hmac_secret")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Will ignore certificate errors raised by the client
        """
        return pulumi.get(self, "insecure")


@pulumi.output_type
class ProjectConnectorsAuditWebhookAuditFilter(dict):
    def __init__(__self__, *,
                 key: str,
                 operator: str,
                 values: Sequence[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def operator(self) -> str:
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class ProjectConnectorsAuditWebhookAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "bearerToken":
            suggest = "bearer_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsAuditWebhookAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsAuditWebhookAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsAuditWebhookAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional['outputs.ProjectConnectorsAuditWebhookAuthenticationApiKey'] = None,
                 basic: Optional['outputs.ProjectConnectorsAuditWebhookAuthenticationBasic'] = None,
                 bearer_token: Optional[str] = None):
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if basic is not None:
            pulumi.set(__self__, "basic", basic)
        if bearer_token is not None:
            pulumi.set(__self__, "bearer_token", bearer_token)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional['outputs.ProjectConnectorsAuditWebhookAuthenticationApiKey']:
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def basic(self) -> Optional['outputs.ProjectConnectorsAuditWebhookAuthenticationBasic']:
        return pulumi.get(self, "basic")

    @property
    @pulumi.getter(name="bearerToken")
    def bearer_token(self) -> Optional[str]:
        return pulumi.get(self, "bearer_token")


@pulumi.output_type
class ProjectConnectorsAuditWebhookAuthenticationApiKey(dict):
    def __init__(__self__, *,
                 key: str,
                 token: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def token(self) -> str:
        return pulumi.get(self, "token")


@pulumi.output_type
class ProjectConnectorsAuditWebhookAuthenticationBasic(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")


@pulumi.output_type
class ProjectConnectorsAwsS3(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyId":
            suggest = "access_key_id"
        elif key == "secretAccessKey":
            suggest = "secret_access_key"
        elif key == "auditEnabled":
            suggest = "audit_enabled"
        elif key == "auditFilters":
            suggest = "audit_filters"
        elif key == "troubleshootLogEnabled":
            suggest = "troubleshoot_log_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsAwsS3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsAwsS3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsAwsS3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key_id: str,
                 bucket: str,
                 name: str,
                 region: str,
                 secret_access_key: str,
                 audit_enabled: Optional[bool] = None,
                 audit_filters: Optional[Sequence['outputs.ProjectConnectorsAwsS3AuditFilter']] = None,
                 description: Optional[str] = None,
                 id: Optional[str] = None,
                 troubleshoot_log_enabled: Optional[bool] = None):
        """
        :param str access_key_id: The unique AWS access key ID.
        :param str bucket: The AWS S3 bucket. This bucket should already exist for the connector to work.
        :param str name: A custom name for your connector.
        :param str region: The AWS S3 region, e.g. `us-east-1`.
        :param str secret_access_key: The secret AWS access key.
        :param str description: A description of what your connector is used for.
        """
        pulumi.set(__self__, "access_key_id", access_key_id)
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "secret_access_key", secret_access_key)
        if audit_enabled is not None:
            pulumi.set(__self__, "audit_enabled", audit_enabled)
        if audit_filters is not None:
            pulumi.set(__self__, "audit_filters", audit_filters)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if troubleshoot_log_enabled is not None:
            pulumi.set(__self__, "troubleshoot_log_enabled", troubleshoot_log_enabled)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> str:
        """
        The unique AWS access key ID.
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The AWS S3 bucket. This bucket should already exist for the connector to work.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The AWS S3 region, e.g. `us-east-1`.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> str:
        """
        The secret AWS access key.
        """
        return pulumi.get(self, "secret_access_key")

    @property
    @pulumi.getter(name="auditEnabled")
    def audit_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "audit_enabled")

    @property
    @pulumi.getter(name="auditFilters")
    def audit_filters(self) -> Optional[Sequence['outputs.ProjectConnectorsAwsS3AuditFilter']]:
        return pulumi.get(self, "audit_filters")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="troubleshootLogEnabled")
    def troubleshoot_log_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "troubleshoot_log_enabled")


@pulumi.output_type
class ProjectConnectorsAwsS3AuditFilter(dict):
    def __init__(__self__, *,
                 key: str,
                 operator: str,
                 values: Sequence[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def operator(self) -> str:
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class ProjectConnectorsAwsTranslate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyId":
            suggest = "access_key_id"
        elif key == "secretAccessKey":
            suggest = "secret_access_key"
        elif key == "sessionToken":
            suggest = "session_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsAwsTranslate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsAwsTranslate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsAwsTranslate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key_id: str,
                 name: str,
                 region: str,
                 secret_access_key: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None,
                 session_token: Optional[str] = None):
        """
        :param str access_key_id: AWS access key ID.
        :param str name: A custom name for your connector.
        :param str region: The AWS region to which this client will send requests. (e.g. us-east-1.)
        :param str secret_access_key: AWS secret access key.
        :param str description: A description of what your connector is used for.
        :param str session_token: (Optional) A security or session token to use with these credentials. Usually present for temporary credentials.
        """
        pulumi.set(__self__, "access_key_id", access_key_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "secret_access_key", secret_access_key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if session_token is not None:
            pulumi.set(__self__, "session_token", session_token)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> str:
        """
        AWS access key ID.
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The AWS region to which this client will send requests. (e.g. us-east-1.)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> str:
        """
        AWS secret access key.
        """
        return pulumi.get(self, "secret_access_key")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="sessionToken")
    def session_token(self) -> Optional[str]:
        """
        (Optional) A security or session token to use with these credentials. Usually present for temporary credentials.
        """
        return pulumi.get(self, "session_token")


@pulumi.output_type
class ProjectConnectorsClear(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsClear. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsClear.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsClear.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str,
                 name: str,
                 project_id: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str api_key: Your CLEAR API key.
        :param str name: A custom name for your connector.
        :param str project_id: Your CLEAR project ID.
        :param str description: A description of what your connector is used for.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        Your CLEAR API key.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        Your CLEAR project ID.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectConnectorsDatadog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "auditEnabled":
            suggest = "audit_enabled"
        elif key == "auditFilters":
            suggest = "audit_filters"
        elif key == "troubleshootLogEnabled":
            suggest = "troubleshoot_log_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsDatadog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsDatadog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsDatadog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str,
                 name: str,
                 audit_enabled: Optional[bool] = None,
                 audit_filters: Optional[Sequence['outputs.ProjectConnectorsDatadogAuditFilter']] = None,
                 description: Optional[str] = None,
                 id: Optional[str] = None,
                 site: Optional[str] = None,
                 troubleshoot_log_enabled: Optional[bool] = None):
        """
        :param str api_key: The unique Datadog organization key.
        :param str name: A custom name for your connector.
        :param str description: A description of what your connector is used for.
        :param str site: The Datadog site to send logs to. Default is `datadoghq.com`. European, free tier and other customers should set their site accordingly.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "name", name)
        if audit_enabled is not None:
            pulumi.set(__self__, "audit_enabled", audit_enabled)
        if audit_filters is not None:
            pulumi.set(__self__, "audit_filters", audit_filters)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if site is not None:
            pulumi.set(__self__, "site", site)
        if troubleshoot_log_enabled is not None:
            pulumi.set(__self__, "troubleshoot_log_enabled", troubleshoot_log_enabled)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        The unique Datadog organization key.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="auditEnabled")
    def audit_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "audit_enabled")

    @property
    @pulumi.getter(name="auditFilters")
    def audit_filters(self) -> Optional[Sequence['outputs.ProjectConnectorsDatadogAuditFilter']]:
        return pulumi.get(self, "audit_filters")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def site(self) -> Optional[str]:
        """
        The Datadog site to send logs to. Default is `datadoghq.com`. European, free tier and other customers should set their site accordingly.
        """
        return pulumi.get(self, "site")

    @property
    @pulumi.getter(name="troubleshootLogEnabled")
    def troubleshoot_log_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "troubleshoot_log_enabled")


@pulumi.output_type
class ProjectConnectorsDatadogAuditFilter(dict):
    def __init__(__self__, *,
                 key: str,
                 operator: str,
                 values: Sequence[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def operator(self) -> str:
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class ProjectConnectorsDevrevGrow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsDevrevGrow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsDevrevGrow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsDevrevGrow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str,
                 name: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str api_key: Authentication to DevRev APIs requires a personal access token (PAT).
        :param str name: A custom name for your connector.
        :param str description: A description of what your connector is used for.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        Authentication to DevRev APIs requires a personal access token (PAT).
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectConnectorsDocebo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseUrl":
            suggest = "base_url"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsDocebo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsDocebo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsDocebo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_url: str,
                 client_id: str,
                 client_secret: str,
                 name: str,
                 password: str,
                 username: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str base_url: The Docebo api base url.
        :param str client_id: The Docebo OAuth 2.0 app client ID.
        :param str client_secret: The Docebo OAuth 2.0 app client secret.
        :param str name: A custom name for your connector.
        :param str password: The Docebo user's password.
        :param str username: The Docebo username.
        :param str description: A description of what your connector is used for.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> str:
        """
        The Docebo api base url.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The Docebo OAuth 2.0 app client ID.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> str:
        """
        The Docebo OAuth 2.0 app client secret.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The Docebo user's password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The Docebo username.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectConnectorsFingerprint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicApiKey":
            suggest = "public_api_key"
        elif key == "secretApiKey":
            suggest = "secret_api_key"
        elif key == "cloudflareEndpointUrl":
            suggest = "cloudflare_endpoint_url"
        elif key == "cloudflareScriptUrl":
            suggest = "cloudflare_script_url"
        elif key == "useCloudflareIntegration":
            suggest = "use_cloudflare_integration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsFingerprint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsFingerprint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsFingerprint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 public_api_key: str,
                 secret_api_key: str,
                 cloudflare_endpoint_url: Optional[str] = None,
                 cloudflare_script_url: Optional[str] = None,
                 description: Optional[str] = None,
                 id: Optional[str] = None,
                 use_cloudflare_integration: Optional[bool] = None):
        """
        :param str name: A custom name for your connector.
        :param str public_api_key: The Fingerprint public API key.
        :param str secret_api_key: The Fingerprint secret API key.
        :param str cloudflare_endpoint_url: The Cloudflare integration Endpoint URL.
        :param str cloudflare_script_url: The Cloudflare integration Script URL.
        :param str description: A description of what your connector is used for.
        :param bool use_cloudflare_integration: Enable to configure the relevant Cloudflare integration parameters if Cloudflare integration is set in your Fingerprint account.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "public_api_key", public_api_key)
        pulumi.set(__self__, "secret_api_key", secret_api_key)
        if cloudflare_endpoint_url is not None:
            pulumi.set(__self__, "cloudflare_endpoint_url", cloudflare_endpoint_url)
        if cloudflare_script_url is not None:
            pulumi.set(__self__, "cloudflare_script_url", cloudflare_script_url)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if use_cloudflare_integration is not None:
            pulumi.set(__self__, "use_cloudflare_integration", use_cloudflare_integration)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicApiKey")
    def public_api_key(self) -> str:
        """
        The Fingerprint public API key.
        """
        return pulumi.get(self, "public_api_key")

    @property
    @pulumi.getter(name="secretApiKey")
    def secret_api_key(self) -> str:
        """
        The Fingerprint secret API key.
        """
        return pulumi.get(self, "secret_api_key")

    @property
    @pulumi.getter(name="cloudflareEndpointUrl")
    def cloudflare_endpoint_url(self) -> Optional[str]:
        """
        The Cloudflare integration Endpoint URL.
        """
        return pulumi.get(self, "cloudflare_endpoint_url")

    @property
    @pulumi.getter(name="cloudflareScriptUrl")
    def cloudflare_script_url(self) -> Optional[str]:
        """
        The Cloudflare integration Script URL.
        """
        return pulumi.get(self, "cloudflare_script_url")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="useCloudflareIntegration")
    def use_cloudflare_integration(self) -> Optional[bool]:
        """
        Enable to configure the relevant Cloudflare integration parameters if Cloudflare integration is set in your Fingerprint account.
        """
        return pulumi.get(self, "use_cloudflare_integration")


@pulumi.output_type
class ProjectConnectorsFingerprintDescope(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customDomain":
            suggest = "custom_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsFingerprintDescope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsFingerprintDescope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsFingerprintDescope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 custom_domain: Optional[str] = None,
                 description: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str name: A custom name for your connector.
        :param str custom_domain: The custom domain to fetch
        :param str description: A description of what your connector is used for.
        """
        pulumi.set(__self__, "name", name)
        if custom_domain is not None:
            pulumi.set(__self__, "custom_domain", custom_domain)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="customDomain")
    def custom_domain(self) -> Optional[str]:
        """
        The custom domain to fetch
        """
        return pulumi.get(self, "custom_domain")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectConnectorsForter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretKey":
            suggest = "secret_key"
        elif key == "siteId":
            suggest = "site_id"
        elif key == "overrideIpAddress":
            suggest = "override_ip_address"
        elif key == "overrideUserEmail":
            suggest = "override_user_email"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsForter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsForter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsForter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 secret_key: str,
                 site_id: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None,
                 override_ip_address: Optional[str] = None,
                 override_user_email: Optional[str] = None,
                 overrides: Optional[bool] = None):
        """
        :param str name: A custom name for your connector.
        :param str secret_key: The Forter secret key.
        :param str site_id: The Forter site ID.
        :param str description: A description of what your connector is used for.
        :param str override_ip_address: Override the user IP address.
        :param str override_user_email: Override the user email.
        :param bool overrides: Override the user's IP address or email so that Forter can provide a specific decision or recommendation. Contact the Forter team for further details. Note: Overriding the user IP address or email is intended for testing purpose and should not be utilized in production environments.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "site_id", site_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if override_ip_address is not None:
            pulumi.set(__self__, "override_ip_address", override_ip_address)
        if override_user_email is not None:
            pulumi.set(__self__, "override_user_email", override_user_email)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        The Forter secret key.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> str:
        """
        The Forter site ID.
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="overrideIpAddress")
    def override_ip_address(self) -> Optional[str]:
        """
        Override the user IP address.
        """
        return pulumi.get(self, "override_ip_address")

    @property
    @pulumi.getter(name="overrideUserEmail")
    def override_user_email(self) -> Optional[str]:
        """
        Override the user email.
        """
        return pulumi.get(self, "override_user_email")

    @property
    @pulumi.getter
    def overrides(self) -> Optional[bool]:
        """
        Override the user's IP address or email so that Forter can provide a specific decision or recommendation. Contact the Forter team for further details. Note: Overriding the user IP address or email is intended for testing purpose and should not be utilized in production environments.
        """
        return pulumi.get(self, "overrides")


@pulumi.output_type
class ProjectConnectorsGenericSmsGateway(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postUrl":
            suggest = "post_url"
        elif key == "hmacSecret":
            suggest = "hmac_secret"
        elif key == "useStaticIps":
            suggest = "use_static_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsGenericSmsGateway. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsGenericSmsGateway.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsGenericSmsGateway.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 post_url: str,
                 authentication: Optional['outputs.ProjectConnectorsGenericSmsGatewayAuthentication'] = None,
                 description: Optional[str] = None,
                 headers: Optional[Mapping[str, str]] = None,
                 hmac_secret: Optional[str] = None,
                 id: Optional[str] = None,
                 insecure: Optional[bool] = None,
                 sender: Optional[str] = None,
                 use_static_ips: Optional[bool] = None):
        """
        :param str name: A custom name for your connector.
        :param str post_url: The URL of the post message request
        :param 'ProjectConnectorsGenericSmsGatewayAuthenticationArgs' authentication: Authentication Information
        :param str description: A description of what your connector is used for.
        :param Mapping[str, str] headers: The headers to send with the request
        :param str hmac_secret: HMAC is a method for message signing with a symmetrical key. This secret will be used to sign the base64 encoded payload, and the resulting signature will be sent in the `x-descope-webhook-s256` header. The receiving service should use this secret to verify the integrity and authenticity of the payload by checking the provided signature
        :param bool insecure: Will ignore certificate errors raised by the client
        :param str sender: The sender number
        :param bool use_static_ips: Whether the connector should send all requests from specific static IPs.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "post_url", post_url)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if hmac_secret is not None:
            pulumi.set(__self__, "hmac_secret", hmac_secret)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if sender is not None:
            pulumi.set(__self__, "sender", sender)
        if use_static_ips is not None:
            pulumi.set(__self__, "use_static_ips", use_static_ips)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="postUrl")
    def post_url(self) -> str:
        """
        The URL of the post message request
        """
        return pulumi.get(self, "post_url")

    @property
    @pulumi.getter
    def authentication(self) -> Optional['outputs.ProjectConnectorsGenericSmsGatewayAuthentication']:
        """
        Authentication Information
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Mapping[str, str]]:
        """
        The headers to send with the request
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="hmacSecret")
    def hmac_secret(self) -> Optional[str]:
        """
        HMAC is a method for message signing with a symmetrical key. This secret will be used to sign the base64 encoded payload, and the resulting signature will be sent in the `x-descope-webhook-s256` header. The receiving service should use this secret to verify the integrity and authenticity of the payload by checking the provided signature
        """
        return pulumi.get(self, "hmac_secret")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Will ignore certificate errors raised by the client
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter
    def sender(self) -> Optional[str]:
        """
        The sender number
        """
        return pulumi.get(self, "sender")

    @property
    @pulumi.getter(name="useStaticIps")
    def use_static_ips(self) -> Optional[bool]:
        """
        Whether the connector should send all requests from specific static IPs.
        """
        return pulumi.get(self, "use_static_ips")


@pulumi.output_type
class ProjectConnectorsGenericSmsGatewayAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "bearerToken":
            suggest = "bearer_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsGenericSmsGatewayAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsGenericSmsGatewayAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsGenericSmsGatewayAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional['outputs.ProjectConnectorsGenericSmsGatewayAuthenticationApiKey'] = None,
                 basic: Optional['outputs.ProjectConnectorsGenericSmsGatewayAuthenticationBasic'] = None,
                 bearer_token: Optional[str] = None):
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if basic is not None:
            pulumi.set(__self__, "basic", basic)
        if bearer_token is not None:
            pulumi.set(__self__, "bearer_token", bearer_token)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional['outputs.ProjectConnectorsGenericSmsGatewayAuthenticationApiKey']:
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def basic(self) -> Optional['outputs.ProjectConnectorsGenericSmsGatewayAuthenticationBasic']:
        return pulumi.get(self, "basic")

    @property
    @pulumi.getter(name="bearerToken")
    def bearer_token(self) -> Optional[str]:
        return pulumi.get(self, "bearer_token")


@pulumi.output_type
class ProjectConnectorsGenericSmsGatewayAuthenticationApiKey(dict):
    def __init__(__self__, *,
                 key: str,
                 token: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def token(self) -> str:
        return pulumi.get(self, "token")


@pulumi.output_type
class ProjectConnectorsGenericSmsGatewayAuthenticationBasic(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")


@pulumi.output_type
class ProjectConnectorsGoogleCloudTranslation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "serviceAccountJson":
            suggest = "service_account_json"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsGoogleCloudTranslation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsGoogleCloudTranslation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsGoogleCloudTranslation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 project_id: str,
                 service_account_json: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str name: A custom name for your connector.
        :param str project_id: The Google Cloud project ID where the Google Cloud Translation is managed.
        :param str service_account_json: Service Account JSON associated with the current project.
        :param str description: A description of what your connector is used for.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "service_account_json", service_account_json)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The Google Cloud project ID where the Google Cloud Translation is managed.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="serviceAccountJson")
    def service_account_json(self) -> str:
        """
        Service Account JSON associated with the current project.
        """
        return pulumi.get(self, "service_account_json")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectConnectorsHibp(dict):
    def __init__(__self__, *,
                 name: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str name: A custom name for your connector.
        :param str description: A description of what your connector is used for.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectConnectorsHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseUrl":
            suggest = "base_url"
        elif key == "hmacSecret":
            suggest = "hmac_secret"
        elif key == "includeHeadersInContext":
            suggest = "include_headers_in_context"
        elif key == "useStaticIps":
            suggest = "use_static_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_url: str,
                 name: str,
                 authentication: Optional['outputs.ProjectConnectorsHttpAuthentication'] = None,
                 description: Optional[str] = None,
                 headers: Optional[Mapping[str, str]] = None,
                 hmac_secret: Optional[str] = None,
                 id: Optional[str] = None,
                 include_headers_in_context: Optional[bool] = None,
                 insecure: Optional[bool] = None,
                 use_static_ips: Optional[bool] = None):
        """
        :param str base_url: The base URL to fetch
        :param str name: A custom name for your connector.
        :param 'ProjectConnectorsHttpAuthenticationArgs' authentication: Authentication Information
        :param str description: A description of what your connector is used for.
        :param Mapping[str, str] headers: The headers to send with the request
        :param str hmac_secret: HMAC is a method for message signing with a symmetrical key. This secret will be used to sign the base64 encoded payload, and the resulting signature will be sent in the `x-descope-webhook-s256` header. The receiving service should use this secret to verify the integrity and authenticity of the payload by checking the provided signature
        :param bool include_headers_in_context: The connector response context will also include the headers. The context will have a "body" attribute and a "headers" attribute. See more details in the help guide
        :param bool insecure: Will ignore certificate errors raised by the client
        :param bool use_static_ips: Whether the connector should send all requests from specific static IPs.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "name", name)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if hmac_secret is not None:
            pulumi.set(__self__, "hmac_secret", hmac_secret)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if include_headers_in_context is not None:
            pulumi.set(__self__, "include_headers_in_context", include_headers_in_context)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if use_static_ips is not None:
            pulumi.set(__self__, "use_static_ips", use_static_ips)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> str:
        """
        The base URL to fetch
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def authentication(self) -> Optional['outputs.ProjectConnectorsHttpAuthentication']:
        """
        Authentication Information
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Mapping[str, str]]:
        """
        The headers to send with the request
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="hmacSecret")
    def hmac_secret(self) -> Optional[str]:
        """
        HMAC is a method for message signing with a symmetrical key. This secret will be used to sign the base64 encoded payload, and the resulting signature will be sent in the `x-descope-webhook-s256` header. The receiving service should use this secret to verify the integrity and authenticity of the payload by checking the provided signature
        """
        return pulumi.get(self, "hmac_secret")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="includeHeadersInContext")
    def include_headers_in_context(self) -> Optional[bool]:
        """
        The connector response context will also include the headers. The context will have a "body" attribute and a "headers" attribute. See more details in the help guide
        """
        return pulumi.get(self, "include_headers_in_context")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Will ignore certificate errors raised by the client
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="useStaticIps")
    def use_static_ips(self) -> Optional[bool]:
        """
        Whether the connector should send all requests from specific static IPs.
        """
        return pulumi.get(self, "use_static_ips")


@pulumi.output_type
class ProjectConnectorsHttpAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "bearerToken":
            suggest = "bearer_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsHttpAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsHttpAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsHttpAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional['outputs.ProjectConnectorsHttpAuthenticationApiKey'] = None,
                 basic: Optional['outputs.ProjectConnectorsHttpAuthenticationBasic'] = None,
                 bearer_token: Optional[str] = None):
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if basic is not None:
            pulumi.set(__self__, "basic", basic)
        if bearer_token is not None:
            pulumi.set(__self__, "bearer_token", bearer_token)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional['outputs.ProjectConnectorsHttpAuthenticationApiKey']:
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def basic(self) -> Optional['outputs.ProjectConnectorsHttpAuthenticationBasic']:
        return pulumi.get(self, "basic")

    @property
    @pulumi.getter(name="bearerToken")
    def bearer_token(self) -> Optional[str]:
        return pulumi.get(self, "bearer_token")


@pulumi.output_type
class ProjectConnectorsHttpAuthenticationApiKey(dict):
    def __init__(__self__, *,
                 key: str,
                 token: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def token(self) -> str:
        return pulumi.get(self, "token")


@pulumi.output_type
class ProjectConnectorsHttpAuthenticationBasic(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")


@pulumi.output_type
class ProjectConnectorsHubspot(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessToken":
            suggest = "access_token"
        elif key == "baseUrl":
            suggest = "base_url"
        elif key == "useStaticIps":
            suggest = "use_static_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsHubspot. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsHubspot.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsHubspot.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_token: str,
                 name: str,
                 base_url: Optional[str] = None,
                 description: Optional[str] = None,
                 id: Optional[str] = None,
                 use_static_ips: Optional[bool] = None):
        """
        :param str access_token: The HubSpot private API access token generated for the Descope service.
        :param str name: A custom name for your connector.
        :param str base_url: The base URL of the HubSpot API, when using a custom domain in HubSpot, default value is https://api.hubapi.com .
        :param str description: A description of what your connector is used for.
        :param bool use_static_ips: Whether the connector should send all requests from specific static IPs.
        """
        pulumi.set(__self__, "access_token", access_token)
        pulumi.set(__self__, "name", name)
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if use_static_ips is not None:
            pulumi.set(__self__, "use_static_ips", use_static_ips)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> str:
        """
        The HubSpot private API access token generated for the Descope service.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[str]:
        """
        The base URL of the HubSpot API, when using a custom domain in HubSpot, default value is https://api.hubapi.com .
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="useStaticIps")
    def use_static_ips(self) -> Optional[bool]:
        """
        Whether the connector should send all requests from specific static IPs.
        """
        return pulumi.get(self, "use_static_ips")


@pulumi.output_type
class ProjectConnectorsIncode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "apiUrl":
            suggest = "api_url"
        elif key == "flowId":
            suggest = "flow_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsIncode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsIncode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsIncode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str,
                 api_url: str,
                 flow_id: str,
                 name: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str api_key: Your InCode API key.
        :param str api_url: The base URL of the Incode API
        :param str flow_id: Your wanted InCode's flow ID.
        :param str name: A custom name for your connector.
        :param str description: A description of what your connector is used for.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "api_url", api_url)
        pulumi.set(__self__, "flow_id", flow_id)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        Your InCode API key.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> str:
        """
        The base URL of the Incode API
        """
        return pulumi.get(self, "api_url")

    @property
    @pulumi.getter(name="flowId")
    def flow_id(self) -> str:
        """
        Your wanted InCode's flow ID.
        """
        return pulumi.get(self, "flow_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectConnectorsIntercom(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None,
                 region: Optional[str] = None):
        """
        :param str name: A custom name for your connector.
        :param str token: The Intercom access token.
        :param str description: A description of what your connector is used for.
        :param str region: Regional Hosting - US, EU, or AU. default: US
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The Intercom access token.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Regional Hosting - US, EU, or AU. default: US
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class ProjectConnectorsLokalise(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiToken":
            suggest = "api_token"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "cardId":
            suggest = "card_id"
        elif key == "teamId":
            suggest = "team_id"
        elif key == "translationProvider":
            suggest = "translation_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsLokalise. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsLokalise.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsLokalise.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_token: str,
                 name: str,
                 project_id: str,
                 card_id: Optional[str] = None,
                 description: Optional[str] = None,
                 id: Optional[str] = None,
                 team_id: Optional[str] = None,
                 translation_provider: Optional[str] = None):
        """
        :param str api_token: Lokalise API token.
        :param str name: A custom name for your connector.
        :param str project_id: Lokalise project ID.
        :param str card_id: (Optional) The ID of the payment card to use for translation orders. If not provided, the team credit will be used.
        :param str description: A description of what your connector is used for.
        :param str team_id: Lokalise team ID. If not provided, the oldest available team will be used.
        :param str translation_provider: The translation provider to use ('gengo', 'google', 'lokalise', 'deepl'), default is 'deepl'.
        """
        pulumi.set(__self__, "api_token", api_token)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        if card_id is not None:
            pulumi.set(__self__, "card_id", card_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if translation_provider is not None:
            pulumi.set(__self__, "translation_provider", translation_provider)

    @property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> str:
        """
        Lokalise API token.
        """
        return pulumi.get(self, "api_token")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        Lokalise project ID.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="cardId")
    def card_id(self) -> Optional[str]:
        """
        (Optional) The ID of the payment card to use for translation orders. If not provided, the team credit will be used.
        """
        return pulumi.get(self, "card_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[str]:
        """
        Lokalise team ID. If not provided, the oldest available team will be used.
        """
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter(name="translationProvider")
    def translation_provider(self) -> Optional[str]:
        """
        The translation provider to use ('gengo', 'google', 'lokalise', 'deepl'), default is 'deepl'.
        """
        return pulumi.get(self, "translation_provider")


@pulumi.output_type
class ProjectConnectorsMparticle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "apiSecret":
            suggest = "api_secret"
        elif key == "baseUrl":
            suggest = "base_url"
        elif key == "defaultEnvironment":
            suggest = "default_environment"
        elif key == "useStaticIps":
            suggest = "use_static_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsMparticle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsMparticle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsMparticle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str,
                 api_secret: str,
                 name: str,
                 base_url: Optional[str] = None,
                 default_environment: Optional[str] = None,
                 description: Optional[str] = None,
                 id: Optional[str] = None,
                 use_static_ips: Optional[bool] = None):
        """
        :param str api_key: The mParticle Server to Server Key generated for the Descope service.
        :param str api_secret: The mParticle Server to Server Secret generated for the Descope service.
        :param str name: A custom name for your connector.
        :param str base_url: The base URL of the mParticle API, when using a custom domain in mParticle. default value is https://s2s.mparticle.com/
        :param str default_environment: The default environment of which connector send data to, either “production” or “development“. default value: production. This field can be overridden per event (see at flows).
        :param str description: A description of what your connector is used for.
        :param bool use_static_ips: Whether the connector should send all requests from specific static IPs.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "api_secret", api_secret)
        pulumi.set(__self__, "name", name)
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if default_environment is not None:
            pulumi.set(__self__, "default_environment", default_environment)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if use_static_ips is not None:
            pulumi.set(__self__, "use_static_ips", use_static_ips)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        The mParticle Server to Server Key generated for the Descope service.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="apiSecret")
    def api_secret(self) -> str:
        """
        The mParticle Server to Server Secret generated for the Descope service.
        """
        return pulumi.get(self, "api_secret")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[str]:
        """
        The base URL of the mParticle API, when using a custom domain in mParticle. default value is https://s2s.mparticle.com/
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter(name="defaultEnvironment")
    def default_environment(self) -> Optional[str]:
        """
        The default environment of which connector send data to, either “production” or “development“. default value: production. This field can be overridden per event (see at flows).
        """
        return pulumi.get(self, "default_environment")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="useStaticIps")
    def use_static_ips(self) -> Optional[bool]:
        """
        Whether the connector should send all requests from specific static IPs.
        """
        return pulumi.get(self, "use_static_ips")


@pulumi.output_type
class ProjectConnectorsNewrelic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "auditEnabled":
            suggest = "audit_enabled"
        elif key == "auditFilters":
            suggest = "audit_filters"
        elif key == "dataCenter":
            suggest = "data_center"
        elif key == "logsPrefix":
            suggest = "logs_prefix"
        elif key == "overrideLogsPrefix":
            suggest = "override_logs_prefix"
        elif key == "troubleshootLogEnabled":
            suggest = "troubleshoot_log_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsNewrelic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsNewrelic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsNewrelic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str,
                 name: str,
                 audit_enabled: Optional[bool] = None,
                 audit_filters: Optional[Sequence['outputs.ProjectConnectorsNewrelicAuditFilter']] = None,
                 data_center: Optional[str] = None,
                 description: Optional[str] = None,
                 id: Optional[str] = None,
                 logs_prefix: Optional[str] = None,
                 override_logs_prefix: Optional[bool] = None,
                 troubleshoot_log_enabled: Optional[bool] = None):
        """
        :param str api_key: Ingest License Key of the account you want to report data to.
        :param str name: A custom name for your connector.
        :param str data_center: The New Relic data center the account belongs to. Possible values are: `US`, `EU`, `FedRAMP`. Default is `US`.
        :param str description: A description of what your connector is used for.
        :param str logs_prefix: Specify a custom prefix for all log fields. The default prefix is `descope.`.
        :param bool override_logs_prefix: Enable this option to use a custom prefix for log fields.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "name", name)
        if audit_enabled is not None:
            pulumi.set(__self__, "audit_enabled", audit_enabled)
        if audit_filters is not None:
            pulumi.set(__self__, "audit_filters", audit_filters)
        if data_center is not None:
            pulumi.set(__self__, "data_center", data_center)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if logs_prefix is not None:
            pulumi.set(__self__, "logs_prefix", logs_prefix)
        if override_logs_prefix is not None:
            pulumi.set(__self__, "override_logs_prefix", override_logs_prefix)
        if troubleshoot_log_enabled is not None:
            pulumi.set(__self__, "troubleshoot_log_enabled", troubleshoot_log_enabled)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        Ingest License Key of the account you want to report data to.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="auditEnabled")
    def audit_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "audit_enabled")

    @property
    @pulumi.getter(name="auditFilters")
    def audit_filters(self) -> Optional[Sequence['outputs.ProjectConnectorsNewrelicAuditFilter']]:
        return pulumi.get(self, "audit_filters")

    @property
    @pulumi.getter(name="dataCenter")
    def data_center(self) -> Optional[str]:
        """
        The New Relic data center the account belongs to. Possible values are: `US`, `EU`, `FedRAMP`. Default is `US`.
        """
        return pulumi.get(self, "data_center")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logsPrefix")
    def logs_prefix(self) -> Optional[str]:
        """
        Specify a custom prefix for all log fields. The default prefix is `descope.`.
        """
        return pulumi.get(self, "logs_prefix")

    @property
    @pulumi.getter(name="overrideLogsPrefix")
    def override_logs_prefix(self) -> Optional[bool]:
        """
        Enable this option to use a custom prefix for log fields.
        """
        return pulumi.get(self, "override_logs_prefix")

    @property
    @pulumi.getter(name="troubleshootLogEnabled")
    def troubleshoot_log_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "troubleshoot_log_enabled")


@pulumi.output_type
class ProjectConnectorsNewrelicAuditFilter(dict):
    def __init__(__self__, *,
                 key: str,
                 operator: str,
                 values: Sequence[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def operator(self) -> str:
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class ProjectConnectorsRecaptcha(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretKey":
            suggest = "secret_key"
        elif key == "siteKey":
            suggest = "site_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsRecaptcha. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsRecaptcha.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsRecaptcha.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 secret_key: str,
                 site_key: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str name: A custom name for your connector.
        :param str secret_key: The secret key authorizes communication between Descope backend and the reCAPTCHA server to verify the user's response.
        :param str site_key: The site key is used to invoke reCAPTCHA service on your site or mobile application.
        :param str description: A description of what your connector is used for.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "site_key", site_key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        The secret key authorizes communication between Descope backend and the reCAPTCHA server to verify the user's response.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="siteKey")
    def site_key(self) -> str:
        """
        The site key is used to invoke reCAPTCHA service on your site or mobile application.
        """
        return pulumi.get(self, "site_key")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectConnectorsRecaptchaEnterprise(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "siteKey":
            suggest = "site_key"
        elif key == "assessmentScore":
            suggest = "assessment_score"
        elif key == "overrideAssessment":
            suggest = "override_assessment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsRecaptchaEnterprise. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsRecaptchaEnterprise.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsRecaptchaEnterprise.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str,
                 name: str,
                 project_id: str,
                 site_key: str,
                 assessment_score: Optional[float] = None,
                 description: Optional[str] = None,
                 enterprise: Optional[bool] = None,
                 id: Optional[str] = None,
                 override_assessment: Optional[bool] = None):
        """
        :param str api_key: API key associated with the current project.
        :param str name: A custom name for your connector.
        :param str project_id: The Google Cloud project ID where the reCAPTCHA Enterprise is managed.
        :param str site_key: The site key is used to invoke reCAPTCHA Enterprise service on your site or mobile application.
        :param float assessment_score: When configured, the Recaptcha action will return the score without assessing the request. The score ranges between 0 and 1, where 1 is a human interaction and 0 is a bot.
        :param str description: A description of what your connector is used for.
        :param bool override_assessment: Override the default assessment model. Note: Overriding assessment is intended for automated testing and should not be utilized in production environments.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "site_key", site_key)
        if assessment_score is not None:
            pulumi.set(__self__, "assessment_score", assessment_score)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise is not None:
            pulumi.set(__self__, "enterprise", enterprise)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if override_assessment is not None:
            pulumi.set(__self__, "override_assessment", override_assessment)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        API key associated with the current project.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The Google Cloud project ID where the reCAPTCHA Enterprise is managed.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="siteKey")
    def site_key(self) -> str:
        """
        The site key is used to invoke reCAPTCHA Enterprise service on your site or mobile application.
        """
        return pulumi.get(self, "site_key")

    @property
    @pulumi.getter(name="assessmentScore")
    def assessment_score(self) -> Optional[float]:
        """
        When configured, the Recaptcha action will return the score without assessing the request. The score ranges between 0 and 1, where 1 is a human interaction and 0 is a bot.
        """
        return pulumi.get(self, "assessment_score")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enterprise(self) -> Optional[bool]:
        return pulumi.get(self, "enterprise")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="overrideAssessment")
    def override_assessment(self) -> Optional[bool]:
        """
        Override the default assessment model. Note: Overriding assessment is intended for automated testing and should not be utilized in production environments.
        """
        return pulumi.get(self, "override_assessment")


@pulumi.output_type
class ProjectConnectorsRekognition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyId":
            suggest = "access_key_id"
        elif key == "collectionId":
            suggest = "collection_id"
        elif key == "secretAccessKey":
            suggest = "secret_access_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsRekognition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsRekognition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsRekognition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key_id: str,
                 collection_id: str,
                 name: str,
                 secret_access_key: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str access_key_id: The AWS access key ID
        :param str collection_id: The collection to store registered users in. Should match `[a-zA-Z0-9_.-]+` pattern. Changing this will cause losing existing users.
        :param str name: A custom name for your connector.
        :param str secret_access_key: The AWS secret access key
        :param str description: A description of what your connector is used for.
        """
        pulumi.set(__self__, "access_key_id", access_key_id)
        pulumi.set(__self__, "collection_id", collection_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_access_key", secret_access_key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> str:
        """
        The AWS access key ID
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> str:
        """
        The collection to store registered users in. Should match `[a-zA-Z0-9_.-]+` pattern. Changing this will cause losing existing users.
        """
        return pulumi.get(self, "collection_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> str:
        """
        The AWS secret access key
        """
        return pulumi.get(self, "secret_access_key")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectConnectorsSalesforce(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseUrl":
            suggest = "base_url"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsSalesforce. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsSalesforce.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsSalesforce.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_url: str,
                 client_id: str,
                 client_secret: str,
                 name: str,
                 version: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str base_url: The Salesforce API base URL.
        :param str client_id: The consumer key of the connected app.
        :param str client_secret: The consumer secret of the connected app.
        :param str name: A custom name for your connector.
        :param str version: REST API Version.
        :param str description: A description of what your connector is used for.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> str:
        """
        The Salesforce API base URL.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The consumer key of the connected app.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> str:
        """
        The consumer secret of the connected app.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        REST API Version.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectConnectorsSalesforceMarketingCloud(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "accountId":
            suggest = "account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsSalesforceMarketingCloud. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsSalesforceMarketingCloud.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsSalesforceMarketingCloud.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 client_secret: str,
                 name: str,
                 subdomain: str,
                 account_id: Optional[str] = None,
                 description: Optional[str] = None,
                 id: Optional[str] = None,
                 scope: Optional[str] = None):
        """
        :param str client_id: Client ID issued when you create the API integration in Installed Packages.
        :param str client_secret: Client secret issued when you create the API integration in Installed Packages.
        :param str name: A custom name for your connector.
        :param str subdomain: The Salesforce Marketing Cloud endpoint subdomain.
        :param str account_id: Account identifier, or MID, of the target business unit.
        :param str description: A description of what your connector is used for.
        :param str scope: Space-separated list of data-access permissions for your connector.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "subdomain", subdomain)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        Client ID issued when you create the API integration in Installed Packages.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> str:
        """
        Client secret issued when you create the API integration in Installed Packages.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def subdomain(self) -> str:
        """
        The Salesforce Marketing Cloud endpoint subdomain.
        """
        return pulumi.get(self, "subdomain")

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[str]:
        """
        Account identifier, or MID, of the target business unit.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        Space-separated list of data-access permissions for your connector.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class ProjectConnectorsSe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyId":
            suggest = "access_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsSe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsSe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsSe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key_id: str,
                 name: str,
                 region: str,
                 secret: str,
                 sender: 'outputs.ProjectConnectorsSeSender',
                 description: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str access_key_id: AWS Access key ID.
        :param str name: A custom name for your connector.
        :param str region: AWS region to send requests to (e.g. `us-west-2`).
        :param str secret: AWS Secret Access Key.
        :param 'ProjectConnectorsSeSenderArgs' sender: The sender details that should be displayed in the email message.
        :param str description: A description of what your connector is used for.
        :param str endpoint: An optional endpoint URL (hostname only or fully qualified URI).
        """
        pulumi.set(__self__, "access_key_id", access_key_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "sender", sender)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> str:
        """
        AWS Access key ID.
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        AWS region to send requests to (e.g. `us-west-2`).
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        AWS Secret Access Key.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def sender(self) -> 'outputs.ProjectConnectorsSeSender':
        """
        The sender details that should be displayed in the email message.
        """
        return pulumi.get(self, "sender")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        An optional endpoint URL (hostname only or fully qualified URI).
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectConnectorsSeSender(dict):
    def __init__(__self__, *,
                 email: str,
                 name: Optional[str] = None):
        pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def email(self) -> str:
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class ProjectConnectorsSegment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "writeKey":
            suggest = "write_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsSegment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsSegment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsSegment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 write_key: str,
                 description: Optional[str] = None,
                 host: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str name: A custom name for your connector.
        :param str write_key: The Segment Write Key generated for the Descope service.
        :param str description: A description of what your connector is used for.
        :param str host: The base URL of the Segment API, when using a custom domain in Segment.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "write_key", write_key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="writeKey")
    def write_key(self) -> str:
        """
        The Segment Write Key generated for the Descope service.
        """
        return pulumi.get(self, "write_key")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        The base URL of the Segment API, when using a custom domain in Segment.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectConnectorsSendgrid(dict):
    def __init__(__self__, *,
                 authentication: 'outputs.ProjectConnectorsSendgridAuthentication',
                 name: str,
                 sender: 'outputs.ProjectConnectorsSendgridSender',
                 description: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str name: A custom name for your connector.
        :param 'ProjectConnectorsSendgridSenderArgs' sender: The sender details that should be displayed in the email message.
        :param str description: A description of what your connector is used for.
        """
        pulumi.set(__self__, "authentication", authentication)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sender", sender)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def authentication(self) -> 'outputs.ProjectConnectorsSendgridAuthentication':
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def sender(self) -> 'outputs.ProjectConnectorsSendgridSender':
        """
        The sender details that should be displayed in the email message.
        """
        return pulumi.get(self, "sender")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectConnectorsSendgridAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsSendgridAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsSendgridAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsSendgridAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str):
        pulumi.set(__self__, "api_key", api_key)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        return pulumi.get(self, "api_key")


@pulumi.output_type
class ProjectConnectorsSendgridSender(dict):
    def __init__(__self__, *,
                 email: str,
                 name: Optional[str] = None):
        pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def email(self) -> str:
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class ProjectConnectorsSlack(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str name: A custom name for your connector.
        :param str token: The OAuth token for Slack's Bot User, used to authenticate API requests.
        :param str description: A description of what your connector is used for.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The OAuth token for Slack's Bot User, used to authenticate API requests.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectConnectorsSmartling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountUid":
            suggest = "account_uid"
        elif key == "userIdentifier":
            suggest = "user_identifier"
        elif key == "userSecret":
            suggest = "user_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsSmartling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsSmartling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsSmartling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_uid: str,
                 name: str,
                 user_identifier: str,
                 user_secret: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str account_uid: The account UID for the Smartling account.
        :param str name: A custom name for your connector.
        :param str user_identifier: The user identifier for the Smartling account.
        :param str user_secret: The user secret for the Smartling account.
        :param str description: A description of what your connector is used for.
        """
        pulumi.set(__self__, "account_uid", account_uid)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "user_identifier", user_identifier)
        pulumi.set(__self__, "user_secret", user_secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="accountUid")
    def account_uid(self) -> str:
        """
        The account UID for the Smartling account.
        """
        return pulumi.get(self, "account_uid")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="userIdentifier")
    def user_identifier(self) -> str:
        """
        The user identifier for the Smartling account.
        """
        return pulumi.get(self, "user_identifier")

    @property
    @pulumi.getter(name="userSecret")
    def user_secret(self) -> str:
        """
        The user secret for the Smartling account.
        """
        return pulumi.get(self, "user_secret")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectConnectorsSmtp(dict):
    def __init__(__self__, *,
                 authentication: 'outputs.ProjectConnectorsSmtpAuthentication',
                 name: str,
                 sender: 'outputs.ProjectConnectorsSmtpSender',
                 server: 'outputs.ProjectConnectorsSmtpServer',
                 description: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str name: A custom name for your connector.
        :param 'ProjectConnectorsSmtpSenderArgs' sender: The sender details that should be displayed in the email message.
        :param str description: A description of what your connector is used for.
        """
        pulumi.set(__self__, "authentication", authentication)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sender", sender)
        pulumi.set(__self__, "server", server)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def authentication(self) -> 'outputs.ProjectConnectorsSmtpAuthentication':
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def sender(self) -> 'outputs.ProjectConnectorsSmtpSender':
        """
        The sender details that should be displayed in the email message.
        """
        return pulumi.get(self, "sender")

    @property
    @pulumi.getter
    def server(self) -> 'outputs.ProjectConnectorsSmtpServer':
        return pulumi.get(self, "server")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectConnectorsSmtpAuthentication(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str,
                 method: Optional[str] = None):
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if method is not None:
            pulumi.set(__self__, "method", method)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        return pulumi.get(self, "method")


@pulumi.output_type
class ProjectConnectorsSmtpSender(dict):
    def __init__(__self__, *,
                 email: str,
                 name: Optional[str] = None):
        pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def email(self) -> str:
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class ProjectConnectorsSmtpServer(dict):
    def __init__(__self__, *,
                 host: str,
                 port: Optional[int] = None):
        pulumi.set(__self__, "host", host)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def host(self) -> str:
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        return pulumi.get(self, "port")


@pulumi.output_type
class ProjectConnectorsSn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyId":
            suggest = "access_key_id"
        elif key == "entityId":
            suggest = "entity_id"
        elif key == "organizationNumber":
            suggest = "organization_number"
        elif key == "senderId":
            suggest = "sender_id"
        elif key == "templateId":
            suggest = "template_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsSn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsSn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsSn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key_id: str,
                 name: str,
                 region: str,
                 secret: str,
                 description: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 entity_id: Optional[str] = None,
                 id: Optional[str] = None,
                 organization_number: Optional[str] = None,
                 sender_id: Optional[str] = None,
                 template_id: Optional[str] = None):
        """
        :param str access_key_id: AWS Access key ID.
        :param str name: A custom name for your connector.
        :param str region: AWS region to send requests to (e.g. `us-west-2`).
        :param str secret: AWS Secret Access Key.
        :param str description: A description of what your connector is used for.
        :param str endpoint: An optional endpoint URL (hostname only or fully qualified URI).
        :param str entity_id: The entity ID or principal entity (PE) ID for sending text messages to recipients in India.
        :param str organization_number: An optional phone number from which the text messages are going to be sent. Make sure it is registered properly in your server.
        :param str sender_id: The name of the sender from which the text message is going to be sent (see SNS documentation regarding acceptable IDs and supported regions/countries).
        :param str template_id: The template for sending text messages to recipients in India. The template ID must be associated with the sender ID.
        """
        pulumi.set(__self__, "access_key_id", access_key_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "secret", secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if organization_number is not None:
            pulumi.set(__self__, "organization_number", organization_number)
        if sender_id is not None:
            pulumi.set(__self__, "sender_id", sender_id)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> str:
        """
        AWS Access key ID.
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        AWS region to send requests to (e.g. `us-west-2`).
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        AWS Secret Access Key.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        An optional endpoint URL (hostname only or fully qualified URI).
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[str]:
        """
        The entity ID or principal entity (PE) ID for sending text messages to recipients in India.
        """
        return pulumi.get(self, "entity_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="organizationNumber")
    def organization_number(self) -> Optional[str]:
        """
        An optional phone number from which the text messages are going to be sent. Make sure it is registered properly in your server.
        """
        return pulumi.get(self, "organization_number")

    @property
    @pulumi.getter(name="senderId")
    def sender_id(self) -> Optional[str]:
        """
        The name of the sender from which the text message is going to be sent (see SNS documentation regarding acceptable IDs and supported regions/countries).
        """
        return pulumi.get(self, "sender_id")

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[str]:
        """
        The template for sending text messages to recipients in India. The template ID must be associated with the sender ID.
        """
        return pulumi.get(self, "template_id")


@pulumi.output_type
class ProjectConnectorsSumologic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpSourceUrl":
            suggest = "http_source_url"
        elif key == "auditEnabled":
            suggest = "audit_enabled"
        elif key == "auditFilters":
            suggest = "audit_filters"
        elif key == "troubleshootLogEnabled":
            suggest = "troubleshoot_log_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsSumologic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsSumologic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsSumologic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_source_url: str,
                 name: str,
                 audit_enabled: Optional[bool] = None,
                 audit_filters: Optional[Sequence['outputs.ProjectConnectorsSumologicAuditFilter']] = None,
                 description: Optional[str] = None,
                 id: Optional[str] = None,
                 troubleshoot_log_enabled: Optional[bool] = None):
        """
        :param str http_source_url: The URL associated with an HTTP Hosted collector
        :param str name: A custom name for your connector.
        :param str description: A description of what your connector is used for.
        """
        pulumi.set(__self__, "http_source_url", http_source_url)
        pulumi.set(__self__, "name", name)
        if audit_enabled is not None:
            pulumi.set(__self__, "audit_enabled", audit_enabled)
        if audit_filters is not None:
            pulumi.set(__self__, "audit_filters", audit_filters)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if troubleshoot_log_enabled is not None:
            pulumi.set(__self__, "troubleshoot_log_enabled", troubleshoot_log_enabled)

    @property
    @pulumi.getter(name="httpSourceUrl")
    def http_source_url(self) -> str:
        """
        The URL associated with an HTTP Hosted collector
        """
        return pulumi.get(self, "http_source_url")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="auditEnabled")
    def audit_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "audit_enabled")

    @property
    @pulumi.getter(name="auditFilters")
    def audit_filters(self) -> Optional[Sequence['outputs.ProjectConnectorsSumologicAuditFilter']]:
        return pulumi.get(self, "audit_filters")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="troubleshootLogEnabled")
    def troubleshoot_log_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "troubleshoot_log_enabled")


@pulumi.output_type
class ProjectConnectorsSumologicAuditFilter(dict):
    def __init__(__self__, *,
                 key: str,
                 operator: str,
                 values: Sequence[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def operator(self) -> str:
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class ProjectConnectorsTelesign(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "customerId":
            suggest = "customer_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsTelesign. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsTelesign.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsTelesign.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str,
                 customer_id: str,
                 name: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str api_key: The unique Telesign API key
        :param str customer_id: The unique Telesign account Customer ID
        :param str name: A custom name for your connector.
        :param str description: A description of what your connector is used for.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "customer_id", customer_id)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        The unique Telesign API key
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="customerId")
    def customer_id(self) -> str:
        """
        The unique Telesign account Customer ID
        """
        return pulumi.get(self, "customer_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectConnectorsTraceable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretKey":
            suggest = "secret_key"
        elif key == "euRegion":
            suggest = "eu_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsTraceable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsTraceable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsTraceable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 secret_key: str,
                 description: Optional[str] = None,
                 eu_region: Optional[bool] = None,
                 id: Optional[str] = None):
        """
        :param str name: A custom name for your connector.
        :param str secret_key: The Traceable secret key.
        :param str description: A description of what your connector is used for.
        :param bool eu_region: EU(Europe) Region deployment of Traceable platform.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_key", secret_key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eu_region is not None:
            pulumi.set(__self__, "eu_region", eu_region)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        The Traceable secret key.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="euRegion")
    def eu_region(self) -> Optional[bool]:
        """
        EU(Europe) Region deployment of Traceable platform.
        """
        return pulumi.get(self, "eu_region")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectConnectorsTwilioCore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountSid":
            suggest = "account_sid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsTwilioCore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsTwilioCore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsTwilioCore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_sid: str,
                 authentication: 'outputs.ProjectConnectorsTwilioCoreAuthentication',
                 name: str,
                 senders: 'outputs.ProjectConnectorsTwilioCoreSenders',
                 description: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str name: A custom name for your connector.
        :param str description: A description of what your connector is used for.
        """
        pulumi.set(__self__, "account_sid", account_sid)
        pulumi.set(__self__, "authentication", authentication)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "senders", senders)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="accountSid")
    def account_sid(self) -> str:
        return pulumi.get(self, "account_sid")

    @property
    @pulumi.getter
    def authentication(self) -> 'outputs.ProjectConnectorsTwilioCoreAuthentication':
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def senders(self) -> 'outputs.ProjectConnectorsTwilioCoreSenders':
        return pulumi.get(self, "senders")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectConnectorsTwilioCoreAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "apiSecret":
            suggest = "api_secret"
        elif key == "authToken":
            suggest = "auth_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsTwilioCoreAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsTwilioCoreAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsTwilioCoreAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 api_secret: Optional[str] = None,
                 auth_token: Optional[str] = None):
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if api_secret is not None:
            pulumi.set(__self__, "api_secret", api_secret)
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="apiSecret")
    def api_secret(self) -> Optional[str]:
        return pulumi.get(self, "api_secret")

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[str]:
        return pulumi.get(self, "auth_token")


@pulumi.output_type
class ProjectConnectorsTwilioCoreSenders(dict):
    def __init__(__self__, *,
                 sms: 'outputs.ProjectConnectorsTwilioCoreSendersSms',
                 voice: Optional['outputs.ProjectConnectorsTwilioCoreSendersVoice'] = None):
        pulumi.set(__self__, "sms", sms)
        if voice is not None:
            pulumi.set(__self__, "voice", voice)

    @property
    @pulumi.getter
    def sms(self) -> 'outputs.ProjectConnectorsTwilioCoreSendersSms':
        return pulumi.get(self, "sms")

    @property
    @pulumi.getter
    def voice(self) -> Optional['outputs.ProjectConnectorsTwilioCoreSendersVoice']:
        return pulumi.get(self, "voice")


@pulumi.output_type
class ProjectConnectorsTwilioCoreSendersSms(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messagingServiceSid":
            suggest = "messaging_service_sid"
        elif key == "phoneNumber":
            suggest = "phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsTwilioCoreSendersSms. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsTwilioCoreSendersSms.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsTwilioCoreSendersSms.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 messaging_service_sid: Optional[str] = None,
                 phone_number: Optional[str] = None):
        if messaging_service_sid is not None:
            pulumi.set(__self__, "messaging_service_sid", messaging_service_sid)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="messagingServiceSid")
    def messaging_service_sid(self) -> Optional[str]:
        return pulumi.get(self, "messaging_service_sid")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[str]:
        return pulumi.get(self, "phone_number")


@pulumi.output_type
class ProjectConnectorsTwilioCoreSendersVoice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "phoneNumber":
            suggest = "phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsTwilioCoreSendersVoice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsTwilioCoreSendersVoice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsTwilioCoreSendersVoice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 phone_number: str):
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> str:
        return pulumi.get(self, "phone_number")


@pulumi.output_type
class ProjectConnectorsTwilioVerify(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountSid":
            suggest = "account_sid"
        elif key == "serviceSid":
            suggest = "service_sid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsTwilioVerify. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsTwilioVerify.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsTwilioVerify.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_sid: str,
                 authentication: 'outputs.ProjectConnectorsTwilioVerifyAuthentication',
                 name: str,
                 service_sid: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None,
                 sender: Optional[str] = None):
        """
        :param str name: A custom name for your connector.
        :param str description: A description of what your connector is used for.
        """
        pulumi.set(__self__, "account_sid", account_sid)
        pulumi.set(__self__, "authentication", authentication)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service_sid", service_sid)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if sender is not None:
            pulumi.set(__self__, "sender", sender)

    @property
    @pulumi.getter(name="accountSid")
    def account_sid(self) -> str:
        return pulumi.get(self, "account_sid")

    @property
    @pulumi.getter
    def authentication(self) -> 'outputs.ProjectConnectorsTwilioVerifyAuthentication':
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A custom name for your connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceSid")
    def service_sid(self) -> str:
        return pulumi.get(self, "service_sid")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of what your connector is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def sender(self) -> Optional[str]:
        return pulumi.get(self, "sender")


@pulumi.output_type
class ProjectConnectorsTwilioVerifyAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "apiSecret":
            suggest = "api_secret"
        elif key == "authToken":
            suggest = "auth_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectConnectorsTwilioVerifyAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectConnectorsTwilioVerifyAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectConnectorsTwilioVerifyAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional[str] = None,
                 api_secret: Optional[str] = None,
                 auth_token: Optional[str] = None):
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if api_secret is not None:
            pulumi.set(__self__, "api_secret", api_secret)
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="apiSecret")
    def api_secret(self) -> Optional[str]:
        return pulumi.get(self, "api_secret")

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[str]:
        return pulumi.get(self, "auth_token")


@pulumi.output_type
class ProjectFlows(dict):
    def __init__(__self__, *,
                 data: str):
        pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def data(self) -> str:
        return pulumi.get(self, "data")


@pulumi.output_type
class ProjectInviteSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addMagiclinkToken":
            suggest = "add_magiclink_token"
        elif key == "inviteUrl":
            suggest = "invite_url"
        elif key == "requireInvitation":
            suggest = "require_invitation"
        elif key == "sendEmail":
            suggest = "send_email"
        elif key == "sendText":
            suggest = "send_text"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectInviteSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectInviteSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectInviteSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 add_magiclink_token: Optional[bool] = None,
                 invite_url: Optional[str] = None,
                 require_invitation: Optional[bool] = None,
                 send_email: Optional[bool] = None,
                 send_text: Optional[bool] = None):
        if add_magiclink_token is not None:
            pulumi.set(__self__, "add_magiclink_token", add_magiclink_token)
        if invite_url is not None:
            pulumi.set(__self__, "invite_url", invite_url)
        if require_invitation is not None:
            pulumi.set(__self__, "require_invitation", require_invitation)
        if send_email is not None:
            pulumi.set(__self__, "send_email", send_email)
        if send_text is not None:
            pulumi.set(__self__, "send_text", send_text)

    @property
    @pulumi.getter(name="addMagiclinkToken")
    def add_magiclink_token(self) -> Optional[bool]:
        return pulumi.get(self, "add_magiclink_token")

    @property
    @pulumi.getter(name="inviteUrl")
    def invite_url(self) -> Optional[str]:
        return pulumi.get(self, "invite_url")

    @property
    @pulumi.getter(name="requireInvitation")
    def require_invitation(self) -> Optional[bool]:
        return pulumi.get(self, "require_invitation")

    @property
    @pulumi.getter(name="sendEmail")
    def send_email(self) -> Optional[bool]:
        return pulumi.get(self, "send_email")

    @property
    @pulumi.getter(name="sendText")
    def send_text(self) -> Optional[bool]:
        return pulumi.get(self, "send_text")


@pulumi.output_type
class ProjectJwtTemplates(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyTemplates":
            suggest = "access_key_templates"
        elif key == "userTemplates":
            suggest = "user_templates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectJwtTemplates. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectJwtTemplates.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectJwtTemplates.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key_templates: Optional[Sequence['outputs.ProjectJwtTemplatesAccessKeyTemplate']] = None,
                 user_templates: Optional[Sequence['outputs.ProjectJwtTemplatesUserTemplate']] = None):
        """
        :param Sequence['ProjectJwtTemplatesAccessKeyTemplateArgs'] access_key_templates: A list of `Access Key` type JWT Templates.
        :param Sequence['ProjectJwtTemplatesUserTemplateArgs'] user_templates: A list of `User` type JWT Templates.
        """
        if access_key_templates is not None:
            pulumi.set(__self__, "access_key_templates", access_key_templates)
        if user_templates is not None:
            pulumi.set(__self__, "user_templates", user_templates)

    @property
    @pulumi.getter(name="accessKeyTemplates")
    def access_key_templates(self) -> Optional[Sequence['outputs.ProjectJwtTemplatesAccessKeyTemplate']]:
        """
        A list of `Access Key` type JWT Templates.
        """
        return pulumi.get(self, "access_key_templates")

    @property
    @pulumi.getter(name="userTemplates")
    def user_templates(self) -> Optional[Sequence['outputs.ProjectJwtTemplatesUserTemplate']]:
        """
        A list of `User` type JWT Templates.
        """
        return pulumi.get(self, "user_templates")


@pulumi.output_type
class ProjectJwtTemplatesAccessKeyTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authSchema":
            suggest = "auth_schema"
        elif key == "conformanceIssuer":
            suggest = "conformance_issuer"
        elif key == "emptyClaimPolicy":
            suggest = "empty_claim_policy"
        elif key == "enforceIssuer":
            suggest = "enforce_issuer"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectJwtTemplatesAccessKeyTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectJwtTemplatesAccessKeyTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectJwtTemplatesAccessKeyTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 template: str,
                 auth_schema: Optional[str] = None,
                 conformance_issuer: Optional[bool] = None,
                 description: Optional[str] = None,
                 empty_claim_policy: Optional[str] = None,
                 enforce_issuer: Optional[bool] = None,
                 id: Optional[str] = None):
        """
        :param str name: Name of the JWT Template.
        :param str auth_schema: The authorization claims format - `default`, `tenantOnly` or `none`. Read more about schema types [here](https://docs.descope.com/project-settings/jwt-templates).
        :param str description: Description of the JWT Template.
        :param str empty_claim_policy: Policy for empty claims - `none`, `nil` or `delete`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "template", template)
        if auth_schema is not None:
            pulumi.set(__self__, "auth_schema", auth_schema)
        if conformance_issuer is not None:
            pulumi.set(__self__, "conformance_issuer", conformance_issuer)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if empty_claim_policy is not None:
            pulumi.set(__self__, "empty_claim_policy", empty_claim_policy)
        if enforce_issuer is not None:
            pulumi.set(__self__, "enforce_issuer", enforce_issuer)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the JWT Template.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def template(self) -> str:
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="authSchema")
    def auth_schema(self) -> Optional[str]:
        """
        The authorization claims format - `default`, `tenantOnly` or `none`. Read more about schema types [here](https://docs.descope.com/project-settings/jwt-templates).
        """
        return pulumi.get(self, "auth_schema")

    @property
    @pulumi.getter(name="conformanceIssuer")
    def conformance_issuer(self) -> Optional[bool]:
        return pulumi.get(self, "conformance_issuer")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the JWT Template.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="emptyClaimPolicy")
    def empty_claim_policy(self) -> Optional[str]:
        """
        Policy for empty claims - `none`, `nil` or `delete`.
        """
        return pulumi.get(self, "empty_claim_policy")

    @property
    @pulumi.getter(name="enforceIssuer")
    def enforce_issuer(self) -> Optional[bool]:
        return pulumi.get(self, "enforce_issuer")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectJwtTemplatesUserTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authSchema":
            suggest = "auth_schema"
        elif key == "conformanceIssuer":
            suggest = "conformance_issuer"
        elif key == "emptyClaimPolicy":
            suggest = "empty_claim_policy"
        elif key == "enforceIssuer":
            suggest = "enforce_issuer"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectJwtTemplatesUserTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectJwtTemplatesUserTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectJwtTemplatesUserTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 template: str,
                 auth_schema: Optional[str] = None,
                 conformance_issuer: Optional[bool] = None,
                 description: Optional[str] = None,
                 empty_claim_policy: Optional[str] = None,
                 enforce_issuer: Optional[bool] = None,
                 id: Optional[str] = None):
        """
        :param str name: Name of the JWT Template.
        :param str auth_schema: The authorization claims format - `default`, `tenantOnly` or `none`. Read more about schema types [here](https://docs.descope.com/project-settings/jwt-templates).
        :param str description: Description of the JWT Template.
        :param str empty_claim_policy: Policy for empty claims - `none`, `nil` or `delete`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "template", template)
        if auth_schema is not None:
            pulumi.set(__self__, "auth_schema", auth_schema)
        if conformance_issuer is not None:
            pulumi.set(__self__, "conformance_issuer", conformance_issuer)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if empty_claim_policy is not None:
            pulumi.set(__self__, "empty_claim_policy", empty_claim_policy)
        if enforce_issuer is not None:
            pulumi.set(__self__, "enforce_issuer", enforce_issuer)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the JWT Template.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def template(self) -> str:
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="authSchema")
    def auth_schema(self) -> Optional[str]:
        """
        The authorization claims format - `default`, `tenantOnly` or `none`. Read more about schema types [here](https://docs.descope.com/project-settings/jwt-templates).
        """
        return pulumi.get(self, "auth_schema")

    @property
    @pulumi.getter(name="conformanceIssuer")
    def conformance_issuer(self) -> Optional[bool]:
        return pulumi.get(self, "conformance_issuer")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the JWT Template.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="emptyClaimPolicy")
    def empty_claim_policy(self) -> Optional[str]:
        """
        Policy for empty claims - `none`, `nil` or `delete`.
        """
        return pulumi.get(self, "empty_claim_policy")

    @property
    @pulumi.getter(name="enforceIssuer")
    def enforce_issuer(self) -> Optional[bool]:
        return pulumi.get(self, "enforce_issuer")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class ProjectProjectSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyJwtTemplate":
            suggest = "access_key_jwt_template"
        elif key == "accessKeySessionTokenExpiration":
            suggest = "access_key_session_token_expiration"
        elif key == "appUrl":
            suggest = "app_url"
        elif key == "approvedDomains":
            suggest = "approved_domains"
        elif key == "cookieDomain":
            suggest = "cookie_domain"
        elif key == "cookiePolicy":
            suggest = "cookie_policy"
        elif key == "customDomain":
            suggest = "custom_domain"
        elif key == "enableInactivity":
            suggest = "enable_inactivity"
        elif key == "inactivityTime":
            suggest = "inactivity_time"
        elif key == "refreshTokenExpiration":
            suggest = "refresh_token_expiration"
        elif key == "refreshTokenRotation":
            suggest = "refresh_token_rotation"
        elif key == "sessionTokenExpiration":
            suggest = "session_token_expiration"
        elif key == "stepUpTokenExpiration":
            suggest = "step_up_token_expiration"
        elif key == "testUsersLoginidRegexp":
            suggest = "test_users_loginid_regexp"
        elif key == "testUsersStaticOtp":
            suggest = "test_users_static_otp"
        elif key == "testUsersVerifierRegexp":
            suggest = "test_users_verifier_regexp"
        elif key == "tokenResponseMethod":
            suggest = "token_response_method"
        elif key == "trustedDeviceTokenExpiration":
            suggest = "trusted_device_token_expiration"
        elif key == "userJwtTemplate":
            suggest = "user_jwt_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectProjectSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectProjectSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectProjectSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key_jwt_template: Optional[str] = None,
                 access_key_session_token_expiration: Optional[str] = None,
                 app_url: Optional[str] = None,
                 approved_domains: Optional[Sequence[str]] = None,
                 cookie_domain: Optional[str] = None,
                 cookie_policy: Optional[str] = None,
                 custom_domain: Optional[str] = None,
                 enable_inactivity: Optional[bool] = None,
                 inactivity_time: Optional[str] = None,
                 refresh_token_expiration: Optional[str] = None,
                 refresh_token_rotation: Optional[bool] = None,
                 session_token_expiration: Optional[str] = None,
                 step_up_token_expiration: Optional[str] = None,
                 test_users_loginid_regexp: Optional[str] = None,
                 test_users_static_otp: Optional[str] = None,
                 test_users_verifier_regexp: Optional[str] = None,
                 token_response_method: Optional[str] = None,
                 trusted_device_token_expiration: Optional[str] = None,
                 user_jwt_template: Optional[str] = None):
        """
        :param str access_key_jwt_template: Name of the access key JWT Template.
        :param str access_key_session_token_expiration: The expiry time for access key session tokens. Use values such as "10 minutes", "4 hours", etc. The value needs to be at least 3 minutes and can't be longer than 4 weeks.
        :param Sequence[str] approved_domains: The list of approved domains that are allowed for redirect and verification URLs for different authentication methods.
        :param str cookie_domain: The domain name for custom domain set up. To read more about custom domain and cookie policy click [here](https://docs.descope.com/how-to-deploy-to-production/custom-domain).
        :param str cookie_policy: Use "strict", "lax" or "none". To read more about custom domain and cookie policy click [here](https://docs.descope.com/how-to-deploy-to-production/custom-domain).
        :param bool enable_inactivity: Use `True` to enable session inactivity. To read more about session inactivity click [here](https://docs.descope.com/project-settings#session-inactivity).
        :param str inactivity_time: The session inactivity time. Use values such as "15 minutes", "1 hour", etc. The minimum value is "10 minutes".
        :param str refresh_token_expiration: The expiry time for the refresh token, after which the user must log in again. Use values such as "4 weeks", "14 days", etc. The minimum value is "3 minutes".
        :param bool refresh_token_rotation: Every time the user refreshes their session token via their refresh token, the refresh token itself is also updated to a new one.
        :param str session_token_expiration: The expiry time of the session token, used for accessing the application's resources. The value needs to be at least 3 minutes and can't be longer than the refresh token expiration.
        :param str step_up_token_expiration: The expiry time for the step up token, after which it will not be valid and the user will automatically go back to the session token.
        :param str test_users_loginid_regexp: Define a regular expression so that whenever a user is created with a matching login ID it will automatically be marked as a test user.
        :param str test_users_static_otp: A 6 digit static OTP code for use with test users.
        :param str test_users_verifier_regexp: The pattern of the verifiers that will be used for testing.
        :param str token_response_method: Configure how refresh tokens are managed by the Descope SDKs. Must be either `response_body` or `cookies`. The default value is `response_body`.
        :param str trusted_device_token_expiration: The expiry time for the trusted device token. The minimum value is "3 minutes".
        :param str user_jwt_template: Name of the user JWT Template.
        """
        if access_key_jwt_template is not None:
            pulumi.set(__self__, "access_key_jwt_template", access_key_jwt_template)
        if access_key_session_token_expiration is not None:
            pulumi.set(__self__, "access_key_session_token_expiration", access_key_session_token_expiration)
        if app_url is not None:
            pulumi.set(__self__, "app_url", app_url)
        if approved_domains is not None:
            pulumi.set(__self__, "approved_domains", approved_domains)
        if cookie_domain is not None:
            pulumi.set(__self__, "cookie_domain", cookie_domain)
        if cookie_policy is not None:
            pulumi.set(__self__, "cookie_policy", cookie_policy)
        if custom_domain is not None:
            pulumi.set(__self__, "custom_domain", custom_domain)
        if enable_inactivity is not None:
            pulumi.set(__self__, "enable_inactivity", enable_inactivity)
        if inactivity_time is not None:
            pulumi.set(__self__, "inactivity_time", inactivity_time)
        if refresh_token_expiration is not None:
            pulumi.set(__self__, "refresh_token_expiration", refresh_token_expiration)
        if refresh_token_rotation is not None:
            pulumi.set(__self__, "refresh_token_rotation", refresh_token_rotation)
        if session_token_expiration is not None:
            pulumi.set(__self__, "session_token_expiration", session_token_expiration)
        if step_up_token_expiration is not None:
            pulumi.set(__self__, "step_up_token_expiration", step_up_token_expiration)
        if test_users_loginid_regexp is not None:
            pulumi.set(__self__, "test_users_loginid_regexp", test_users_loginid_regexp)
        if test_users_static_otp is not None:
            pulumi.set(__self__, "test_users_static_otp", test_users_static_otp)
        if test_users_verifier_regexp is not None:
            pulumi.set(__self__, "test_users_verifier_regexp", test_users_verifier_regexp)
        if token_response_method is not None:
            pulumi.set(__self__, "token_response_method", token_response_method)
        if trusted_device_token_expiration is not None:
            pulumi.set(__self__, "trusted_device_token_expiration", trusted_device_token_expiration)
        if user_jwt_template is not None:
            pulumi.set(__self__, "user_jwt_template", user_jwt_template)

    @property
    @pulumi.getter(name="accessKeyJwtTemplate")
    def access_key_jwt_template(self) -> Optional[str]:
        """
        Name of the access key JWT Template.
        """
        return pulumi.get(self, "access_key_jwt_template")

    @property
    @pulumi.getter(name="accessKeySessionTokenExpiration")
    def access_key_session_token_expiration(self) -> Optional[str]:
        """
        The expiry time for access key session tokens. Use values such as "10 minutes", "4 hours", etc. The value needs to be at least 3 minutes and can't be longer than 4 weeks.
        """
        return pulumi.get(self, "access_key_session_token_expiration")

    @property
    @pulumi.getter(name="appUrl")
    def app_url(self) -> Optional[str]:
        return pulumi.get(self, "app_url")

    @property
    @pulumi.getter(name="approvedDomains")
    def approved_domains(self) -> Optional[Sequence[str]]:
        """
        The list of approved domains that are allowed for redirect and verification URLs for different authentication methods.
        """
        return pulumi.get(self, "approved_domains")

    @property
    @pulumi.getter(name="cookieDomain")
    def cookie_domain(self) -> Optional[str]:
        """
        The domain name for custom domain set up. To read more about custom domain and cookie policy click [here](https://docs.descope.com/how-to-deploy-to-production/custom-domain).
        """
        return pulumi.get(self, "cookie_domain")

    @property
    @pulumi.getter(name="cookiePolicy")
    def cookie_policy(self) -> Optional[str]:
        """
        Use "strict", "lax" or "none". To read more about custom domain and cookie policy click [here](https://docs.descope.com/how-to-deploy-to-production/custom-domain).
        """
        return pulumi.get(self, "cookie_policy")

    @property
    @pulumi.getter(name="customDomain")
    def custom_domain(self) -> Optional[str]:
        return pulumi.get(self, "custom_domain")

    @property
    @pulumi.getter(name="enableInactivity")
    def enable_inactivity(self) -> Optional[bool]:
        """
        Use `True` to enable session inactivity. To read more about session inactivity click [here](https://docs.descope.com/project-settings#session-inactivity).
        """
        return pulumi.get(self, "enable_inactivity")

    @property
    @pulumi.getter(name="inactivityTime")
    def inactivity_time(self) -> Optional[str]:
        """
        The session inactivity time. Use values such as "15 minutes", "1 hour", etc. The minimum value is "10 minutes".
        """
        return pulumi.get(self, "inactivity_time")

    @property
    @pulumi.getter(name="refreshTokenExpiration")
    def refresh_token_expiration(self) -> Optional[str]:
        """
        The expiry time for the refresh token, after which the user must log in again. Use values such as "4 weeks", "14 days", etc. The minimum value is "3 minutes".
        """
        return pulumi.get(self, "refresh_token_expiration")

    @property
    @pulumi.getter(name="refreshTokenRotation")
    def refresh_token_rotation(self) -> Optional[bool]:
        """
        Every time the user refreshes their session token via their refresh token, the refresh token itself is also updated to a new one.
        """
        return pulumi.get(self, "refresh_token_rotation")

    @property
    @pulumi.getter(name="sessionTokenExpiration")
    def session_token_expiration(self) -> Optional[str]:
        """
        The expiry time of the session token, used for accessing the application's resources. The value needs to be at least 3 minutes and can't be longer than the refresh token expiration.
        """
        return pulumi.get(self, "session_token_expiration")

    @property
    @pulumi.getter(name="stepUpTokenExpiration")
    def step_up_token_expiration(self) -> Optional[str]:
        """
        The expiry time for the step up token, after which it will not be valid and the user will automatically go back to the session token.
        """
        return pulumi.get(self, "step_up_token_expiration")

    @property
    @pulumi.getter(name="testUsersLoginidRegexp")
    def test_users_loginid_regexp(self) -> Optional[str]:
        """
        Define a regular expression so that whenever a user is created with a matching login ID it will automatically be marked as a test user.
        """
        return pulumi.get(self, "test_users_loginid_regexp")

    @property
    @pulumi.getter(name="testUsersStaticOtp")
    def test_users_static_otp(self) -> Optional[str]:
        """
        A 6 digit static OTP code for use with test users.
        """
        return pulumi.get(self, "test_users_static_otp")

    @property
    @pulumi.getter(name="testUsersVerifierRegexp")
    def test_users_verifier_regexp(self) -> Optional[str]:
        """
        The pattern of the verifiers that will be used for testing.
        """
        return pulumi.get(self, "test_users_verifier_regexp")

    @property
    @pulumi.getter(name="tokenResponseMethod")
    def token_response_method(self) -> Optional[str]:
        """
        Configure how refresh tokens are managed by the Descope SDKs. Must be either `response_body` or `cookies`. The default value is `response_body`.
        """
        return pulumi.get(self, "token_response_method")

    @property
    @pulumi.getter(name="trustedDeviceTokenExpiration")
    def trusted_device_token_expiration(self) -> Optional[str]:
        """
        The expiry time for the trusted device token. The minimum value is "3 minutes".
        """
        return pulumi.get(self, "trusted_device_token_expiration")

    @property
    @pulumi.getter(name="userJwtTemplate")
    def user_jwt_template(self) -> Optional[str]:
        """
        Name of the user JWT Template.
        """
        return pulumi.get(self, "user_jwt_template")


@pulumi.output_type
class ProjectStyles(dict):
    def __init__(__self__, *,
                 data: str):
        pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def data(self) -> str:
        return pulumi.get(self, "data")


