# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.support.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.support.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class ChatTranscriptDetails(ProxyResource):
    """Object that represents a Chat Transcript resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.support.models.SystemData
    :ivar messages: List of chat transcript communication resources.
    :vartype messages: list[~azure.mgmt.support.models.MessageProperties]
    :ivar start_time: Time in UTC (ISO 8601 format) when the chat began.
    :vartype start_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "start_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "messages": {"key": "properties.messages", "type": "[MessageProperties]"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
    }

    def __init__(self, *, messages: Optional[List["_models.MessageProperties"]] = None, **kwargs: Any) -> None:
        """
        :keyword messages: List of chat transcript communication resources.
        :paramtype messages: list[~azure.mgmt.support.models.MessageProperties]
        """
        super().__init__(**kwargs)
        self.messages = messages
        self.start_time = None


class ChatTranscriptsListResult(_serialization.Model):
    """Collection of Chat Transcripts resources.

    :ivar value: List of Chat Transcripts resources.
    :vartype value: list[~azure.mgmt.support.models.ChatTranscriptDetails]
    :ivar next_link: The URI to fetch the next page of Chat Transcripts resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ChatTranscriptDetails]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ChatTranscriptDetails"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Chat Transcripts resources.
        :paramtype value: list[~azure.mgmt.support.models.ChatTranscriptDetails]
        :keyword next_link: The URI to fetch the next page of Chat Transcripts resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CheckNameAvailabilityInput(_serialization.Model):
    """Input of CheckNameAvailability API.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The resource name to validate. Required.
    :vartype name: str
    :ivar type: The type of resource. Required. Known values are:
     "Microsoft.Support/supportTickets" and "Microsoft.Support/communications".
    :vartype type: str or ~azure.mgmt.support.models.Type
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: str, type: Union[str, "_models.Type"], **kwargs: Any) -> None:
        """
        :keyword name: The resource name to validate. Required.
        :paramtype name: str
        :keyword type: The type of resource. Required. Known values are:
         "Microsoft.Support/supportTickets" and "Microsoft.Support/communications".
        :paramtype type: str or ~azure.mgmt.support.models.Type
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class CheckNameAvailabilityOutput(_serialization.Model):
    """Output of check name availability API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: Indicates whether the name is available.
    :vartype name_available: bool
    :ivar reason: The reason why the name is not available.
    :vartype reason: str
    :ivar message: The detailed error message describing why the name is not available.
    :vartype message: str
    """

    _validation = {
        "name_available": {"readonly": True},
        "reason": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class CommunicationDetails(_serialization.Model):
    """Object that represents a Communication resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Id of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource 'Microsoft.Support/communications'.
    :vartype type: str
    :ivar communication_type: Communication type. Known values are: "web" and "phone".
    :vartype communication_type: str or ~azure.mgmt.support.models.CommunicationType
    :ivar communication_direction: Direction of communication. Known values are: "inbound" and
     "outbound".
    :vartype communication_direction: str or ~azure.mgmt.support.models.CommunicationDirection
    :ivar sender: Email address of the sender. This property is required if called by a service
     principal.
    :vartype sender: str
    :ivar subject: Subject of the communication.
    :vartype subject: str
    :ivar body: Body of the communication.
    :vartype body: str
    :ivar created_date: Time in UTC (ISO 8601 format) when the communication was created.
    :vartype created_date: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "communication_type": {"readonly": True},
        "communication_direction": {"readonly": True},
        "created_date": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "communication_type": {"key": "properties.communicationType", "type": "str"},
        "communication_direction": {"key": "properties.communicationDirection", "type": "str"},
        "sender": {"key": "properties.sender", "type": "str"},
        "subject": {"key": "properties.subject", "type": "str"},
        "body": {"key": "properties.body", "type": "str"},
        "created_date": {"key": "properties.createdDate", "type": "iso-8601"},
    }

    def __init__(
        self, *, sender: Optional[str] = None, subject: Optional[str] = None, body: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword sender: Email address of the sender. This property is required if called by a service
         principal.
        :paramtype sender: str
        :keyword subject: Subject of the communication.
        :paramtype subject: str
        :keyword body: Body of the communication.
        :paramtype body: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.communication_type = None
        self.communication_direction = None
        self.sender = sender
        self.subject = subject
        self.body = body
        self.created_date = None


class CommunicationsListResult(_serialization.Model):
    """Collection of Communication resources.

    :ivar value: List of Communication resources.
    :vartype value: list[~azure.mgmt.support.models.CommunicationDetails]
    :ivar next_link: The URI to fetch the next page of Communication resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CommunicationDetails]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.CommunicationDetails"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Communication resources.
        :paramtype value: list[~azure.mgmt.support.models.CommunicationDetails]
        :keyword next_link: The URI to fetch the next page of Communication resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ContactProfile(_serialization.Model):
    """Contact information associated with the support ticket.

    All required parameters must be populated in order to send to Azure.

    :ivar first_name: First name. Required.
    :vartype first_name: str
    :ivar last_name: Last name. Required.
    :vartype last_name: str
    :ivar preferred_contact_method: Preferred contact method. Required. Known values are: "email"
     and "phone".
    :vartype preferred_contact_method: str or ~azure.mgmt.support.models.PreferredContactMethod
    :ivar primary_email_address: Primary email address. Required.
    :vartype primary_email_address: str
    :ivar additional_email_addresses: Additional email addresses listed will be copied on any
     correspondence about the support ticket.
    :vartype additional_email_addresses: list[str]
    :ivar phone_number: Phone number. This is required if preferred contact method is phone.
    :vartype phone_number: str
    :ivar preferred_time_zone: Time zone of the user. This is the name of the time zone from
     `Microsoft Time Zone Index Values
     <https://support.microsoft.com/help/973627/microsoft-time-zone-index-values>`_. Required.
    :vartype preferred_time_zone: str
    :ivar country: Country of the user. This is the ISO 3166-1 alpha-3 code. Required.
    :vartype country: str
    :ivar preferred_support_language: Preferred language of support from Azure. Support languages
     vary based on the severity you choose for your support ticket. Learn more at `Azure Severity
     and responsiveness <https://azure.microsoft.com/support/plans/response>`_. Use the standard
     language-country code. Valid values are 'en-us' for English, 'zh-hans' for Chinese, 'es-es' for
     Spanish, 'fr-fr' for French, 'ja-jp' for Japanese, 'ko-kr' for Korean, 'ru-ru' for Russian,
     'pt-br' for Portuguese, 'it-it' for Italian, 'zh-tw' for Chinese and 'de-de' for German.
     Required.
    :vartype preferred_support_language: str
    """

    _validation = {
        "first_name": {"required": True},
        "last_name": {"required": True},
        "preferred_contact_method": {"required": True},
        "primary_email_address": {"required": True},
        "preferred_time_zone": {"required": True},
        "country": {"required": True},
        "preferred_support_language": {"required": True},
    }

    _attribute_map = {
        "first_name": {"key": "firstName", "type": "str"},
        "last_name": {"key": "lastName", "type": "str"},
        "preferred_contact_method": {"key": "preferredContactMethod", "type": "str"},
        "primary_email_address": {"key": "primaryEmailAddress", "type": "str"},
        "additional_email_addresses": {"key": "additionalEmailAddresses", "type": "[str]"},
        "phone_number": {"key": "phoneNumber", "type": "str"},
        "preferred_time_zone": {"key": "preferredTimeZone", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "preferred_support_language": {"key": "preferredSupportLanguage", "type": "str"},
    }

    def __init__(
        self,
        *,
        first_name: str,
        last_name: str,
        preferred_contact_method: Union[str, "_models.PreferredContactMethod"],
        primary_email_address: str,
        preferred_time_zone: str,
        country: str,
        preferred_support_language: str,
        additional_email_addresses: Optional[List[str]] = None,
        phone_number: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword first_name: First name. Required.
        :paramtype first_name: str
        :keyword last_name: Last name. Required.
        :paramtype last_name: str
        :keyword preferred_contact_method: Preferred contact method. Required. Known values are:
         "email" and "phone".
        :paramtype preferred_contact_method: str or ~azure.mgmt.support.models.PreferredContactMethod
        :keyword primary_email_address: Primary email address. Required.
        :paramtype primary_email_address: str
        :keyword additional_email_addresses: Additional email addresses listed will be copied on any
         correspondence about the support ticket.
        :paramtype additional_email_addresses: list[str]
        :keyword phone_number: Phone number. This is required if preferred contact method is phone.
        :paramtype phone_number: str
        :keyword preferred_time_zone: Time zone of the user. This is the name of the time zone from
         `Microsoft Time Zone Index Values
         <https://support.microsoft.com/help/973627/microsoft-time-zone-index-values>`_. Required.
        :paramtype preferred_time_zone: str
        :keyword country: Country of the user. This is the ISO 3166-1 alpha-3 code. Required.
        :paramtype country: str
        :keyword preferred_support_language: Preferred language of support from Azure. Support
         languages vary based on the severity you choose for your support ticket. Learn more at `Azure
         Severity and responsiveness <https://azure.microsoft.com/support/plans/response>`_. Use the
         standard language-country code. Valid values are 'en-us' for English, 'zh-hans' for Chinese,
         'es-es' for Spanish, 'fr-fr' for French, 'ja-jp' for Japanese, 'ko-kr' for Korean, 'ru-ru' for
         Russian, 'pt-br' for Portuguese, 'it-it' for Italian, 'zh-tw' for Chinese and 'de-de' for
         German. Required.
        :paramtype preferred_support_language: str
        """
        super().__init__(**kwargs)
        self.first_name = first_name
        self.last_name = last_name
        self.preferred_contact_method = preferred_contact_method
        self.primary_email_address = primary_email_address
        self.additional_email_addresses = additional_email_addresses
        self.phone_number = phone_number
        self.preferred_time_zone = preferred_time_zone
        self.country = country
        self.preferred_support_language = preferred_support_language


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.support.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.support.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.support.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.support.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class FileDetails(ProxyResource):
    """Object that represents File Details resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.support.models.SystemData
    :ivar created_on: Time in UTC (ISO 8601 format) when file workspace was created.
    :vartype created_on: ~datetime.datetime
    :ivar chunk_size: Size of each chunk.
    :vartype chunk_size: float
    :ivar file_size: Size of the file to be uploaded.
    :vartype file_size: float
    :ivar number_of_chunks: Number of chunks to be uploaded.
    :vartype number_of_chunks: float
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "created_on": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "created_on": {"key": "properties.createdOn", "type": "iso-8601"},
        "chunk_size": {"key": "properties.chunkSize", "type": "float"},
        "file_size": {"key": "properties.fileSize", "type": "float"},
        "number_of_chunks": {"key": "properties.numberOfChunks", "type": "float"},
    }

    def __init__(
        self,
        *,
        chunk_size: Optional[float] = None,
        file_size: Optional[float] = None,
        number_of_chunks: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword chunk_size: Size of each chunk.
        :paramtype chunk_size: float
        :keyword file_size: Size of the file to be uploaded.
        :paramtype file_size: float
        :keyword number_of_chunks: Number of chunks to be uploaded.
        :paramtype number_of_chunks: float
        """
        super().__init__(**kwargs)
        self.created_on = None
        self.chunk_size = chunk_size
        self.file_size = file_size
        self.number_of_chunks = number_of_chunks


class FilesListResult(_serialization.Model):
    """Object that represents a collection of File resources.

    :ivar value: List of File resources.
    :vartype value: list[~azure.mgmt.support.models.FileDetails]
    :ivar next_link: The URI to fetch the next page of File resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[FileDetails]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.FileDetails"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of File resources.
        :paramtype value: list[~azure.mgmt.support.models.FileDetails]
        :keyword next_link: The URI to fetch the next page of File resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FileWorkspaceDetails(ProxyResource):
    """Object that represents FileWorkspaceDetails resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.support.models.SystemData
    :ivar created_on: Time in UTC (ISO 8601 format) when file workspace was created.
    :vartype created_on: ~datetime.datetime
    :ivar expiration_time: Time in UTC (ISO 8601 format) when file workspace is going to expire.
    :vartype expiration_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "created_on": {"readonly": True},
        "expiration_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "created_on": {"key": "properties.createdOn", "type": "iso-8601"},
        "expiration_time": {"key": "properties.expirationTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.created_on = None
        self.expiration_time = None


class MessageProperties(_serialization.Model):
    """Describes the properties of a Message Details resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar content_type: Content type.
    :vartype content_type: str or ~azure.mgmt.support.models.TranscriptContentType
    :ivar communication_direction: Direction of communication. Known values are: "inbound" and
     "outbound".
    :vartype communication_direction: str or ~azure.mgmt.support.models.CommunicationDirection
    :ivar sender: Name of the sender.
    :vartype sender: str
    :ivar body: Body of the communication. Required.
    :vartype body: str
    :ivar created_date: Time in UTC (ISO 8601 format) when the communication was created.
    :vartype created_date: ~datetime.datetime
    """

    _validation = {
        "content_type": {"readonly": True},
        "communication_direction": {"readonly": True},
        "body": {"required": True},
        "created_date": {"readonly": True},
    }

    _attribute_map = {
        "content_type": {"key": "contentType", "type": "str"},
        "communication_direction": {"key": "communicationDirection", "type": "str"},
        "sender": {"key": "sender", "type": "str"},
        "body": {"key": "body", "type": "str"},
        "created_date": {"key": "createdDate", "type": "iso-8601"},
    }

    def __init__(self, *, body: str, sender: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword sender: Name of the sender.
        :paramtype sender: str
        :keyword body: Body of the communication. Required.
        :paramtype body: str
        """
        super().__init__(**kwargs)
        self.content_type = None
        self.communication_direction = None
        self.sender = sender
        self.body = body
        self.created_date = None


class Operation(_serialization.Model):
    """The operation supported by Microsoft Support resource provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that describes the operation.
    :vartype display: ~azure.mgmt.support.models.OperationDisplay
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: The object that describes the operation.
        :paramtype display: ~azure.mgmt.support.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.display = display


class OperationDisplay(_serialization.Model):
    """The object that describes the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The description of the operation.
    :vartype description: str
    :ivar operation: The action that users can perform, based on their permission level.
    :vartype operation: str
    :ivar provider: Service provider: Microsoft Support.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed.
    :vartype resource: str
    """

    _validation = {
        "description": {"readonly": True},
        "operation": {"readonly": True},
        "provider": {"readonly": True},
        "resource": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.description = None
        self.operation = None
        self.provider = None
        self.resource = None


class OperationsListResult(_serialization.Model):
    """The list of operations supported by Microsoft Support resource provider.

    :ivar value: The list of operations supported by Microsoft Support resource provider.
    :vartype value: list[~azure.mgmt.support.models.Operation]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
    }

    def __init__(self, *, value: Optional[List["_models.Operation"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of operations supported by Microsoft Support resource provider.
        :paramtype value: list[~azure.mgmt.support.models.Operation]
        """
        super().__init__(**kwargs)
        self.value = value


class ProblemClassification(_serialization.Model):
    """ProblemClassification resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Id of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource 'Microsoft.Support/problemClassification'.
    :vartype type: str
    :ivar display_name: Localized name of problem classification.
    :vartype display_name: str
    :ivar secondary_consent_enabled: This property indicates whether secondary consent is present
     for problem classification.
    :vartype secondary_consent_enabled: list[~azure.mgmt.support.models.SecondaryConsentEnabled]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "secondary_consent_enabled": {"key": "properties.secondaryConsentEnabled", "type": "[SecondaryConsentEnabled]"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        secondary_consent_enabled: Optional[List["_models.SecondaryConsentEnabled"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: Localized name of problem classification.
        :paramtype display_name: str
        :keyword secondary_consent_enabled: This property indicates whether secondary consent is
         present for problem classification.
        :paramtype secondary_consent_enabled: list[~azure.mgmt.support.models.SecondaryConsentEnabled]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.display_name = display_name
        self.secondary_consent_enabled = secondary_consent_enabled


class ProblemClassificationsListResult(_serialization.Model):
    """Collection of ProblemClassification resources.

    :ivar value: List of ProblemClassification resources.
    :vartype value: list[~azure.mgmt.support.models.ProblemClassification]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ProblemClassification]"},
    }

    def __init__(self, *, value: Optional[List["_models.ProblemClassification"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of ProblemClassification resources.
        :paramtype value: list[~azure.mgmt.support.models.ProblemClassification]
        """
        super().__init__(**kwargs)
        self.value = value


class QuotaChangeRequest(_serialization.Model):
    """This property is required for providing the region and new quota limits.

    :ivar region: Region for which the quota increase request is being made.
    :vartype region: str
    :ivar payload: Payload of the quota increase request.
    :vartype payload: str
    """

    _attribute_map = {
        "region": {"key": "region", "type": "str"},
        "payload": {"key": "payload", "type": "str"},
    }

    def __init__(self, *, region: Optional[str] = None, payload: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword region: Region for which the quota increase request is being made.
        :paramtype region: str
        :keyword payload: Payload of the quota increase request.
        :paramtype payload: str
        """
        super().__init__(**kwargs)
        self.region = region
        self.payload = payload


class QuotaTicketDetails(_serialization.Model):
    """Additional set of information required for quota increase support ticket for certain quota
    types, e.g.: Virtual machine cores. Get complete details about Quota payload support request
    along with examples at `Support quota request <https://aka.ms/supportrpquotarequestpayload>`_.

    :ivar quota_change_request_sub_type: Required for certain quota types when there is a sub type,
     such as Batch, for which you are requesting a quota increase.
    :vartype quota_change_request_sub_type: str
    :ivar quota_change_request_version: Quota change request version.
    :vartype quota_change_request_version: str
    :ivar quota_change_requests: This property is required for providing the region and new quota
     limits.
    :vartype quota_change_requests: list[~azure.mgmt.support.models.QuotaChangeRequest]
    """

    _attribute_map = {
        "quota_change_request_sub_type": {"key": "quotaChangeRequestSubType", "type": "str"},
        "quota_change_request_version": {"key": "quotaChangeRequestVersion", "type": "str"},
        "quota_change_requests": {"key": "quotaChangeRequests", "type": "[QuotaChangeRequest]"},
    }

    def __init__(
        self,
        *,
        quota_change_request_sub_type: Optional[str] = None,
        quota_change_request_version: Optional[str] = None,
        quota_change_requests: Optional[List["_models.QuotaChangeRequest"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword quota_change_request_sub_type: Required for certain quota types when there is a sub
         type, such as Batch, for which you are requesting a quota increase.
        :paramtype quota_change_request_sub_type: str
        :keyword quota_change_request_version: Quota change request version.
        :paramtype quota_change_request_version: str
        :keyword quota_change_requests: This property is required for providing the region and new
         quota limits.
        :paramtype quota_change_requests: list[~azure.mgmt.support.models.QuotaChangeRequest]
        """
        super().__init__(**kwargs)
        self.quota_change_request_sub_type = quota_change_request_sub_type
        self.quota_change_request_version = quota_change_request_version
        self.quota_change_requests = quota_change_requests


class SecondaryConsent(_serialization.Model):
    """This property indicates secondary consent for the support ticket.

    :ivar user_consent: User consent value provided. Known values are: "Yes" and "No".
    :vartype user_consent: str or ~azure.mgmt.support.models.UserConsent
    :ivar type: The service name for which the secondary consent is being provided. The value needs
     to be retrieved from the Problem Classification API response.
    :vartype type: str
    """

    _attribute_map = {
        "user_consent": {"key": "userConsent", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        user_consent: Optional[Union[str, "_models.UserConsent"]] = None,
        type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_consent: User consent value provided. Known values are: "Yes" and "No".
        :paramtype user_consent: str or ~azure.mgmt.support.models.UserConsent
        :keyword type: The service name for which the secondary consent is being provided. The value
         needs to be retrieved from the Problem Classification API response.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.user_consent = user_consent
        self.type = type


class SecondaryConsentEnabled(_serialization.Model):
    """This property indicates whether secondary consent is present for problem classification.

    :ivar description: User consent description.
    :vartype description: str
    :ivar type: The Azure service for which secondary consent is needed for case creation.
    :vartype type: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description: User consent description.
        :paramtype description: str
        :keyword type: The Azure service for which secondary consent is needed for case creation.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.type = type


class Service(_serialization.Model):
    """Object that represents a Service resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Id of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource 'Microsoft.Support/services'.
    :vartype type: str
    :ivar display_name: Localized name of the Azure service.
    :vartype display_name: str
    :ivar resource_types: ARM Resource types.
    :vartype resource_types: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "resource_types": {"key": "properties.resourceTypes", "type": "[str]"},
    }

    def __init__(
        self, *, display_name: Optional[str] = None, resource_types: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword display_name: Localized name of the Azure service.
        :paramtype display_name: str
        :keyword resource_types: ARM Resource types.
        :paramtype resource_types: list[str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.display_name = display_name
        self.resource_types = resource_types


class ServiceLevelAgreement(_serialization.Model):
    """Service Level Agreement details for a support ticket.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar start_time: Time in UTC (ISO 8601 format) when the service level agreement starts.
    :vartype start_time: ~datetime.datetime
    :ivar expiration_time: Time in UTC (ISO 8601 format) when the service level agreement expires.
    :vartype expiration_time: ~datetime.datetime
    :ivar sla_minutes: Service Level Agreement in minutes.
    :vartype sla_minutes: int
    """

    _validation = {
        "start_time": {"readonly": True},
        "expiration_time": {"readonly": True},
        "sla_minutes": {"readonly": True},
    }

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "expiration_time": {"key": "expirationTime", "type": "iso-8601"},
        "sla_minutes": {"key": "slaMinutes", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.start_time = None
        self.expiration_time = None
        self.sla_minutes = None


class ServicesListResult(_serialization.Model):
    """Collection of Service resources.

    :ivar value: List of Service resources.
    :vartype value: list[~azure.mgmt.support.models.Service]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Service]"},
    }

    def __init__(self, *, value: Optional[List["_models.Service"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of Service resources.
        :paramtype value: list[~azure.mgmt.support.models.Service]
        """
        super().__init__(**kwargs)
        self.value = value


class SupportEngineer(_serialization.Model):
    """Support engineer information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar email_address: Email address of the Azure Support engineer assigned to the support
     ticket.
    :vartype email_address: str
    """

    _validation = {
        "email_address": {"readonly": True},
    }

    _attribute_map = {
        "email_address": {"key": "emailAddress", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.email_address = None


class SupportTicketDetails(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Object that represents SupportTicketDetails resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Id of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource 'Microsoft.Support/supportTickets'.
    :vartype type: str
    :ivar support_ticket_id: System generated support ticket Id that is unique.
    :vartype support_ticket_id: str
    :ivar description: Detailed description of the question or issue.
    :vartype description: str
    :ivar problem_classification_id: Each Azure service has its own set of issue categories, also
     known as problem classification. This parameter is the unique Id for the type of problem you
     are experiencing.
    :vartype problem_classification_id: str
    :ivar problem_classification_display_name: Localized name of problem classification.
    :vartype problem_classification_display_name: str
    :ivar severity: A value that indicates the urgency of the case, which in turn determines the
     response time according to the service level agreement of the technical support plan you have
     with Azure. Note: 'Highest critical impact', also known as the 'Emergency - Severe impact'
     level in the Azure portal is reserved only for our Premium customers. Known values are:
     "minimal", "moderate", "critical", and "highestcriticalimpact".
    :vartype severity: str or ~azure.mgmt.support.models.SeverityLevel
    :ivar enrollment_id: Enrollment Id associated with the support ticket.
    :vartype enrollment_id: str
    :ivar require24_x7_response: Indicates if this requires a 24x7 response from Azure.
    :vartype require24_x7_response: bool
    :ivar advanced_diagnostic_consent: Advanced diagnostic consent to be updated on the support
     ticket. Known values are: "Yes" and "No".
    :vartype advanced_diagnostic_consent: str or ~azure.mgmt.support.models.Consent
    :ivar problem_scoping_questions: Problem scoping questions associated with the support ticket.
    :vartype problem_scoping_questions: str
    :ivar support_plan_id: Support plan id associated with the support ticket.
    :vartype support_plan_id: str
    :ivar contact_details: Contact information of the user requesting to create a support ticket.
    :vartype contact_details: ~azure.mgmt.support.models.ContactProfile
    :ivar service_level_agreement: Service Level Agreement information for this support ticket.
    :vartype service_level_agreement: ~azure.mgmt.support.models.ServiceLevelAgreement
    :ivar support_engineer: Information about the support engineer working on this support ticket.
    :vartype support_engineer: ~azure.mgmt.support.models.SupportEngineer
    :ivar support_plan_type: Support plan type associated with the support ticket.
    :vartype support_plan_type: str
    :ivar support_plan_display_name: Support plan type associated with the support ticket.
    :vartype support_plan_display_name: str
    :ivar title: Title of the support ticket.
    :vartype title: str
    :ivar problem_start_time: Time in UTC (ISO 8601 format) when the problem started.
    :vartype problem_start_time: ~datetime.datetime
    :ivar service_id: This is the resource Id of the Azure service resource associated with the
     support ticket.
    :vartype service_id: str
    :ivar service_display_name: Localized name of the Azure service.
    :vartype service_display_name: str
    :ivar status: Status of the support ticket.
    :vartype status: str
    :ivar created_date: Time in UTC (ISO 8601 format) when the support ticket was created.
    :vartype created_date: ~datetime.datetime
    :ivar modified_date: Time in UTC (ISO 8601 format) when the support ticket was last modified.
    :vartype modified_date: ~datetime.datetime
    :ivar file_workspace_name: File workspace name.
    :vartype file_workspace_name: str
    :ivar technical_ticket_details: Additional ticket details associated with a technical support
     ticket request.
    :vartype technical_ticket_details: ~azure.mgmt.support.models.TechnicalTicketDetails
    :ivar quota_ticket_details: Additional ticket details associated with a quota support ticket
     request.
    :vartype quota_ticket_details: ~azure.mgmt.support.models.QuotaTicketDetails
    :ivar secondary_consent: This property indicates secondary consents for the support ticket.
    :vartype secondary_consent: list[~azure.mgmt.support.models.SecondaryConsent]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "problem_classification_display_name": {"readonly": True},
        "enrollment_id": {"readonly": True},
        "support_plan_type": {"readonly": True},
        "support_plan_display_name": {"readonly": True},
        "service_display_name": {"readonly": True},
        "status": {"readonly": True},
        "created_date": {"readonly": True},
        "modified_date": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "support_ticket_id": {"key": "properties.supportTicketId", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "problem_classification_id": {"key": "properties.problemClassificationId", "type": "str"},
        "problem_classification_display_name": {"key": "properties.problemClassificationDisplayName", "type": "str"},
        "severity": {"key": "properties.severity", "type": "str"},
        "enrollment_id": {"key": "properties.enrollmentId", "type": "str"},
        "require24_x7_response": {"key": "properties.require24X7Response", "type": "bool"},
        "advanced_diagnostic_consent": {"key": "properties.advancedDiagnosticConsent", "type": "str"},
        "problem_scoping_questions": {"key": "properties.problemScopingQuestions", "type": "str"},
        "support_plan_id": {"key": "properties.supportPlanId", "type": "str"},
        "contact_details": {"key": "properties.contactDetails", "type": "ContactProfile"},
        "service_level_agreement": {"key": "properties.serviceLevelAgreement", "type": "ServiceLevelAgreement"},
        "support_engineer": {"key": "properties.supportEngineer", "type": "SupportEngineer"},
        "support_plan_type": {"key": "properties.supportPlanType", "type": "str"},
        "support_plan_display_name": {"key": "properties.supportPlanDisplayName", "type": "str"},
        "title": {"key": "properties.title", "type": "str"},
        "problem_start_time": {"key": "properties.problemStartTime", "type": "iso-8601"},
        "service_id": {"key": "properties.serviceId", "type": "str"},
        "service_display_name": {"key": "properties.serviceDisplayName", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "created_date": {"key": "properties.createdDate", "type": "iso-8601"},
        "modified_date": {"key": "properties.modifiedDate", "type": "iso-8601"},
        "file_workspace_name": {"key": "properties.fileWorkspaceName", "type": "str"},
        "technical_ticket_details": {"key": "properties.technicalTicketDetails", "type": "TechnicalTicketDetails"},
        "quota_ticket_details": {"key": "properties.quotaTicketDetails", "type": "QuotaTicketDetails"},
        "secondary_consent": {"key": "properties.secondaryConsent", "type": "[SecondaryConsent]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        support_ticket_id: Optional[str] = None,
        description: Optional[str] = None,
        problem_classification_id: Optional[str] = None,
        severity: Optional[Union[str, "_models.SeverityLevel"]] = None,
        require24_x7_response: Optional[bool] = None,
        advanced_diagnostic_consent: Optional[Union[str, "_models.Consent"]] = None,
        problem_scoping_questions: Optional[str] = None,
        support_plan_id: Optional[str] = None,
        contact_details: Optional["_models.ContactProfile"] = None,
        service_level_agreement: Optional["_models.ServiceLevelAgreement"] = None,
        support_engineer: Optional["_models.SupportEngineer"] = None,
        title: Optional[str] = None,
        problem_start_time: Optional[datetime.datetime] = None,
        service_id: Optional[str] = None,
        file_workspace_name: Optional[str] = None,
        technical_ticket_details: Optional["_models.TechnicalTicketDetails"] = None,
        quota_ticket_details: Optional["_models.QuotaTicketDetails"] = None,
        secondary_consent: Optional[List["_models.SecondaryConsent"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword support_ticket_id: System generated support ticket Id that is unique.
        :paramtype support_ticket_id: str
        :keyword description: Detailed description of the question or issue.
        :paramtype description: str
        :keyword problem_classification_id: Each Azure service has its own set of issue categories,
         also known as problem classification. This parameter is the unique Id for the type of problem
         you are experiencing.
        :paramtype problem_classification_id: str
        :keyword severity: A value that indicates the urgency of the case, which in turn determines the
         response time according to the service level agreement of the technical support plan you have
         with Azure. Note: 'Highest critical impact', also known as the 'Emergency - Severe impact'
         level in the Azure portal is reserved only for our Premium customers. Known values are:
         "minimal", "moderate", "critical", and "highestcriticalimpact".
        :paramtype severity: str or ~azure.mgmt.support.models.SeverityLevel
        :keyword require24_x7_response: Indicates if this requires a 24x7 response from Azure.
        :paramtype require24_x7_response: bool
        :keyword advanced_diagnostic_consent: Advanced diagnostic consent to be updated on the support
         ticket. Known values are: "Yes" and "No".
        :paramtype advanced_diagnostic_consent: str or ~azure.mgmt.support.models.Consent
        :keyword problem_scoping_questions: Problem scoping questions associated with the support
         ticket.
        :paramtype problem_scoping_questions: str
        :keyword support_plan_id: Support plan id associated with the support ticket.
        :paramtype support_plan_id: str
        :keyword contact_details: Contact information of the user requesting to create a support
         ticket.
        :paramtype contact_details: ~azure.mgmt.support.models.ContactProfile
        :keyword service_level_agreement: Service Level Agreement information for this support ticket.
        :paramtype service_level_agreement: ~azure.mgmt.support.models.ServiceLevelAgreement
        :keyword support_engineer: Information about the support engineer working on this support
         ticket.
        :paramtype support_engineer: ~azure.mgmt.support.models.SupportEngineer
        :keyword title: Title of the support ticket.
        :paramtype title: str
        :keyword problem_start_time: Time in UTC (ISO 8601 format) when the problem started.
        :paramtype problem_start_time: ~datetime.datetime
        :keyword service_id: This is the resource Id of the Azure service resource associated with the
         support ticket.
        :paramtype service_id: str
        :keyword file_workspace_name: File workspace name.
        :paramtype file_workspace_name: str
        :keyword technical_ticket_details: Additional ticket details associated with a technical
         support ticket request.
        :paramtype technical_ticket_details: ~azure.mgmt.support.models.TechnicalTicketDetails
        :keyword quota_ticket_details: Additional ticket details associated with a quota support ticket
         request.
        :paramtype quota_ticket_details: ~azure.mgmt.support.models.QuotaTicketDetails
        :keyword secondary_consent: This property indicates secondary consents for the support ticket.
        :paramtype secondary_consent: list[~azure.mgmt.support.models.SecondaryConsent]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.support_ticket_id = support_ticket_id
        self.description = description
        self.problem_classification_id = problem_classification_id
        self.problem_classification_display_name = None
        self.severity = severity
        self.enrollment_id = None
        self.require24_x7_response = require24_x7_response
        self.advanced_diagnostic_consent = advanced_diagnostic_consent
        self.problem_scoping_questions = problem_scoping_questions
        self.support_plan_id = support_plan_id
        self.contact_details = contact_details
        self.service_level_agreement = service_level_agreement
        self.support_engineer = support_engineer
        self.support_plan_type = None
        self.support_plan_display_name = None
        self.title = title
        self.problem_start_time = problem_start_time
        self.service_id = service_id
        self.service_display_name = None
        self.status = None
        self.created_date = None
        self.modified_date = None
        self.file_workspace_name = file_workspace_name
        self.technical_ticket_details = technical_ticket_details
        self.quota_ticket_details = quota_ticket_details
        self.secondary_consent = secondary_consent


class SupportTicketsListResult(_serialization.Model):
    """Object that represents a collection of SupportTicket resources.

    :ivar value: List of SupportTicket resources.
    :vartype value: list[~azure.mgmt.support.models.SupportTicketDetails]
    :ivar next_link: The URI to fetch the next page of SupportTicket resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SupportTicketDetails]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SupportTicketDetails"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of SupportTicket resources.
        :paramtype value: list[~azure.mgmt.support.models.SupportTicketDetails]
        :keyword next_link: The URI to fetch the next page of SupportTicket resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.support.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.support.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.support.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.support.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TechnicalTicketDetails(_serialization.Model):
    """Additional information for technical support ticket.

    :ivar resource_id: This is the resource Id of the Azure service resource (For example: A
     virtual machine resource or an HDInsight resource) for which the support ticket is created.
    :vartype resource_id: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
    }

    def __init__(self, *, resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword resource_id: This is the resource Id of the Azure service resource (For example: A
         virtual machine resource or an HDInsight resource) for which the support ticket is created.
        :paramtype resource_id: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id


class UpdateContactProfile(_serialization.Model):
    """Contact information associated with the support ticket.

    :ivar first_name: First name.
    :vartype first_name: str
    :ivar last_name: Last name.
    :vartype last_name: str
    :ivar preferred_contact_method: Preferred contact method. Known values are: "email" and
     "phone".
    :vartype preferred_contact_method: str or ~azure.mgmt.support.models.PreferredContactMethod
    :ivar primary_email_address: Primary email address.
    :vartype primary_email_address: str
    :ivar additional_email_addresses: Email addresses listed will be copied on any correspondence
     about the support ticket.
    :vartype additional_email_addresses: list[str]
    :ivar phone_number: Phone number. This is required if preferred contact method is phone.
    :vartype phone_number: str
    :ivar preferred_time_zone: Time zone of the user. This is the name of the time zone from
     `Microsoft Time Zone Index Values
     <https://support.microsoft.com/help/973627/microsoft-time-zone-index-values>`_.
    :vartype preferred_time_zone: str
    :ivar country: Country of the user. This is the ISO 3166-1 alpha-3 code.
    :vartype country: str
    :ivar preferred_support_language: Preferred language of support from Azure. Support languages
     vary based on the severity you choose for your support ticket. Learn more at `Azure Severity
     and responsiveness <https://azure.microsoft.com/support/plans/response/>`_. Use the standard
     language-country code. Valid values are 'en-us' for English, 'zh-hans' for Chinese, 'es-es' for
     Spanish, 'fr-fr' for French, 'ja-jp' for Japanese, 'ko-kr' for Korean, 'ru-ru' for Russian,
     'pt-br' for Portuguese, 'it-it' for Italian, 'zh-tw' for Chinese and 'de-de' for German.
    :vartype preferred_support_language: str
    """

    _attribute_map = {
        "first_name": {"key": "firstName", "type": "str"},
        "last_name": {"key": "lastName", "type": "str"},
        "preferred_contact_method": {"key": "preferredContactMethod", "type": "str"},
        "primary_email_address": {"key": "primaryEmailAddress", "type": "str"},
        "additional_email_addresses": {"key": "additionalEmailAddresses", "type": "[str]"},
        "phone_number": {"key": "phoneNumber", "type": "str"},
        "preferred_time_zone": {"key": "preferredTimeZone", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "preferred_support_language": {"key": "preferredSupportLanguage", "type": "str"},
    }

    def __init__(
        self,
        *,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        preferred_contact_method: Optional[Union[str, "_models.PreferredContactMethod"]] = None,
        primary_email_address: Optional[str] = None,
        additional_email_addresses: Optional[List[str]] = None,
        phone_number: Optional[str] = None,
        preferred_time_zone: Optional[str] = None,
        country: Optional[str] = None,
        preferred_support_language: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword first_name: First name.
        :paramtype first_name: str
        :keyword last_name: Last name.
        :paramtype last_name: str
        :keyword preferred_contact_method: Preferred contact method. Known values are: "email" and
         "phone".
        :paramtype preferred_contact_method: str or ~azure.mgmt.support.models.PreferredContactMethod
        :keyword primary_email_address: Primary email address.
        :paramtype primary_email_address: str
        :keyword additional_email_addresses: Email addresses listed will be copied on any
         correspondence about the support ticket.
        :paramtype additional_email_addresses: list[str]
        :keyword phone_number: Phone number. This is required if preferred contact method is phone.
        :paramtype phone_number: str
        :keyword preferred_time_zone: Time zone of the user. This is the name of the time zone from
         `Microsoft Time Zone Index Values
         <https://support.microsoft.com/help/973627/microsoft-time-zone-index-values>`_.
        :paramtype preferred_time_zone: str
        :keyword country: Country of the user. This is the ISO 3166-1 alpha-3 code.
        :paramtype country: str
        :keyword preferred_support_language: Preferred language of support from Azure. Support
         languages vary based on the severity you choose for your support ticket. Learn more at `Azure
         Severity and responsiveness <https://azure.microsoft.com/support/plans/response/>`_. Use the
         standard language-country code. Valid values are 'en-us' for English, 'zh-hans' for Chinese,
         'es-es' for Spanish, 'fr-fr' for French, 'ja-jp' for Japanese, 'ko-kr' for Korean, 'ru-ru' for
         Russian, 'pt-br' for Portuguese, 'it-it' for Italian, 'zh-tw' for Chinese and 'de-de' for
         German.
        :paramtype preferred_support_language: str
        """
        super().__init__(**kwargs)
        self.first_name = first_name
        self.last_name = last_name
        self.preferred_contact_method = preferred_contact_method
        self.primary_email_address = primary_email_address
        self.additional_email_addresses = additional_email_addresses
        self.phone_number = phone_number
        self.preferred_time_zone = preferred_time_zone
        self.country = country
        self.preferred_support_language = preferred_support_language


class UpdateSupportTicket(_serialization.Model):
    """Updates severity, ticket status, and contact details in the support ticket.

    :ivar severity: Severity level. Known values are: "minimal", "moderate", "critical", and
     "highestcriticalimpact".
    :vartype severity: str or ~azure.mgmt.support.models.SeverityLevel
    :ivar status: Status to be updated on the ticket. Known values are: "open" and "closed".
    :vartype status: str or ~azure.mgmt.support.models.Status
    :ivar contact_details: Contact details to be updated on the support ticket.
    :vartype contact_details: ~azure.mgmt.support.models.UpdateContactProfile
    :ivar advanced_diagnostic_consent: Advanced diagnostic consent to be updated on the support
     ticket. Known values are: "Yes" and "No".
    :vartype advanced_diagnostic_consent: str or ~azure.mgmt.support.models.Consent
    :ivar secondary_consent: This property indicates secondary consents for the support ticket.
    :vartype secondary_consent: list[~azure.mgmt.support.models.SecondaryConsent]
    """

    _attribute_map = {
        "severity": {"key": "severity", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "contact_details": {"key": "contactDetails", "type": "UpdateContactProfile"},
        "advanced_diagnostic_consent": {"key": "advancedDiagnosticConsent", "type": "str"},
        "secondary_consent": {"key": "secondaryConsent", "type": "[SecondaryConsent]"},
    }

    def __init__(
        self,
        *,
        severity: Optional[Union[str, "_models.SeverityLevel"]] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
        contact_details: Optional["_models.UpdateContactProfile"] = None,
        advanced_diagnostic_consent: Optional[Union[str, "_models.Consent"]] = None,
        secondary_consent: Optional[List["_models.SecondaryConsent"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword severity: Severity level. Known values are: "minimal", "moderate", "critical", and
         "highestcriticalimpact".
        :paramtype severity: str or ~azure.mgmt.support.models.SeverityLevel
        :keyword status: Status to be updated on the ticket. Known values are: "open" and "closed".
        :paramtype status: str or ~azure.mgmt.support.models.Status
        :keyword contact_details: Contact details to be updated on the support ticket.
        :paramtype contact_details: ~azure.mgmt.support.models.UpdateContactProfile
        :keyword advanced_diagnostic_consent: Advanced diagnostic consent to be updated on the support
         ticket. Known values are: "Yes" and "No".
        :paramtype advanced_diagnostic_consent: str or ~azure.mgmt.support.models.Consent
        :keyword secondary_consent: This property indicates secondary consents for the support ticket.
        :paramtype secondary_consent: list[~azure.mgmt.support.models.SecondaryConsent]
        """
        super().__init__(**kwargs)
        self.severity = severity
        self.status = status
        self.contact_details = contact_details
        self.advanced_diagnostic_consent = advanced_diagnostic_consent
        self.secondary_consent = secondary_consent


class UploadFile(_serialization.Model):
    """File content associated with the file under a workspace.

    :ivar content: File Content in base64 encoded format.
    :vartype content: str
    :ivar chunk_index: Index of the uploaded chunk (Index starts at 0).
    :vartype chunk_index: float
    """

    _attribute_map = {
        "content": {"key": "content", "type": "str"},
        "chunk_index": {"key": "chunkIndex", "type": "float"},
    }

    def __init__(self, *, content: Optional[str] = None, chunk_index: Optional[float] = None, **kwargs: Any) -> None:
        """
        :keyword content: File Content in base64 encoded format.
        :paramtype content: str
        :keyword chunk_index: Index of the uploaded chunk (Index starts at 0).
        :paramtype chunk_index: float
        """
        super().__init__(**kwargs)
        self.content = content
        self.chunk_index = chunk_index
