# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, TYPE_CHECKING

from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient

from .. import models as _models
from .._serialization import Deserializer, Serializer
from ._configuration import MicrosoftSupportConfiguration
from .operations import (
    ChatTranscriptsNoSubscriptionOperations,
    ChatTranscriptsOperations,
    CommunicationsNoSubscriptionOperations,
    CommunicationsOperations,
    FileWorkspacesNoSubscriptionOperations,
    FileWorkspacesOperations,
    FilesNoSubscriptionOperations,
    FilesOperations,
    Operations,
    ProblemClassificationsOperations,
    ServicesOperations,
    SupportTicketChatTranscriptsNoSubscriptionOperations,
    SupportTicketCommunicationsNoSubscriptionOperations,
    SupportTicketsNoSubscriptionOperations,
    SupportTicketsOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential


class MicrosoftSupport:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Microsoft Azure Support Resource Provider.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.support.aio.operations.Operations
    :ivar services: ServicesOperations operations
    :vartype services: azure.mgmt.support.aio.operations.ServicesOperations
    :ivar problem_classifications: ProblemClassificationsOperations operations
    :vartype problem_classifications:
     azure.mgmt.support.aio.operations.ProblemClassificationsOperations
    :ivar support_tickets: SupportTicketsOperations operations
    :vartype support_tickets: azure.mgmt.support.aio.operations.SupportTicketsOperations
    :ivar support_tickets_no_subscription: SupportTicketsNoSubscriptionOperations operations
    :vartype support_tickets_no_subscription:
     azure.mgmt.support.aio.operations.SupportTicketsNoSubscriptionOperations
    :ivar communications: CommunicationsOperations operations
    :vartype communications: azure.mgmt.support.aio.operations.CommunicationsOperations
    :ivar communications_no_subscription: CommunicationsNoSubscriptionOperations operations
    :vartype communications_no_subscription:
     azure.mgmt.support.aio.operations.CommunicationsNoSubscriptionOperations
    :ivar support_ticket_communications_no_subscription:
     SupportTicketCommunicationsNoSubscriptionOperations operations
    :vartype support_ticket_communications_no_subscription:
     azure.mgmt.support.aio.operations.SupportTicketCommunicationsNoSubscriptionOperations
    :ivar chat_transcripts: ChatTranscriptsOperations operations
    :vartype chat_transcripts: azure.mgmt.support.aio.operations.ChatTranscriptsOperations
    :ivar support_ticket_chat_transcripts_no_subscription:
     SupportTicketChatTranscriptsNoSubscriptionOperations operations
    :vartype support_ticket_chat_transcripts_no_subscription:
     azure.mgmt.support.aio.operations.SupportTicketChatTranscriptsNoSubscriptionOperations
    :ivar chat_transcripts_no_subscription: ChatTranscriptsNoSubscriptionOperations operations
    :vartype chat_transcripts_no_subscription:
     azure.mgmt.support.aio.operations.ChatTranscriptsNoSubscriptionOperations
    :ivar file_workspaces: FileWorkspacesOperations operations
    :vartype file_workspaces: azure.mgmt.support.aio.operations.FileWorkspacesOperations
    :ivar file_workspaces_no_subscription: FileWorkspacesNoSubscriptionOperations operations
    :vartype file_workspaces_no_subscription:
     azure.mgmt.support.aio.operations.FileWorkspacesNoSubscriptionOperations
    :ivar files: FilesOperations operations
    :vartype files: azure.mgmt.support.aio.operations.FilesOperations
    :ivar files_no_subscription: FilesNoSubscriptionOperations operations
    :vartype files_no_subscription: azure.mgmt.support.aio.operations.FilesNoSubscriptionOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: Azure subscription Id. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2022-09-01-preview". Note that overriding
     this default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = MicrosoftSupportConfiguration(credential=credential, subscription_id=subscription_id, **kwargs)
        self._client: AsyncARMPipelineClient = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.services = ServicesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.problem_classifications = ProblemClassificationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.support_tickets = SupportTicketsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.support_tickets_no_subscription = SupportTicketsNoSubscriptionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.communications = CommunicationsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.communications_no_subscription = CommunicationsNoSubscriptionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.support_ticket_communications_no_subscription = SupportTicketCommunicationsNoSubscriptionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.chat_transcripts = ChatTranscriptsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.support_ticket_chat_transcripts_no_subscription = SupportTicketChatTranscriptsNoSubscriptionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.chat_transcripts_no_subscription = ChatTranscriptsNoSubscriptionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.file_workspaces = FileWorkspacesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.file_workspaces_no_subscription = FileWorkspacesNoSubscriptionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.files = FilesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.files_no_subscription = FilesNoSubscriptionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "MicrosoftSupport":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details: Any) -> None:
        await self._client.__aexit__(*exc_details)
