import { Construct, ISynthesisSession } from '@aws-cdk/core';
import { FingerprintOptions } from './fs';
export interface StagingProps extends FingerprintOptions {
    readonly sourcePath: string;
}
/**
 * Stages a file or directory from a location on the file system into a staging
 * directory.
 *
 * This is controlled by the context key 'aws:cdk:asset-staging' and enabled
 * by the CLI by default in order to ensure that when the CDK app exists, all
 * assets are available for deployment. Otherwise, if an app references assets
 * in temporary locations, those will not be available when it exists (see
 * https://github.com/aws/aws-cdk/issues/1716).
 *
 * The `stagedPath` property is a stringified token that represents the location
 * of the file or directory after staging. It will be resolved only during the
 * "prepare" stage and may be either the original path or the staged path
 * depending on the context setting.
 *
 * The file/directory are staged based on their content hash (fingerprint). This
 * means that only if content was changed, copy will happen.
 */
export declare class Staging extends Construct {
    /**
     * The path to the asset (stringinfied token).
     *
     * If asset staging is disabled, this will just be the original path.
     * If asset staging is enabled it will be the staged path.
     */
    readonly stagedPath: string;
    /**
     * The path of the asset as it was referenced by the user.
     */
    readonly sourcePath: string;
    /**
     * A cryptographic hash of the source document(s).
     */
    readonly sourceHash: string;
    private readonly fingerprintOptions;
    private readonly relativePath?;
    constructor(scope: Construct, id: string, props: StagingProps);
    protected synthesize(session: ISynthesisSession): void;
}
