"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupMode = exports.Compression = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Possible compression options Kinesis Data Firehose can use to compress data on delivery.
 */
class Compression {
    /**
     * @param value the string value of the Compression.
     */
    constructor(value) {
        this.value = value;
    }
    /**
     * Creates a new Compression instance with a custom value.
     */
    static of(value) {
        return new Compression(value);
    }
}
exports.Compression = Compression;
_a = JSII_RTTI_SYMBOL_1;
Compression[_a] = { fqn: "@aws-cdk/aws-kinesisfirehose-destinations.Compression", version: "1.146.0" };
/**
 * gzip
 */
Compression.GZIP = new Compression('GZIP');
/**
 * Hadoop-compatible Snappy
 */
Compression.HADOOP_SNAPPY = new Compression('HADOOP_SNAPPY');
/**
 * Snappy
 */
Compression.SNAPPY = new Compression('Snappy');
/**
 * ZIP
 */
Compression.ZIP = new Compression('ZIP');
/**
 * Options for S3 record backup of a delivery stream.
 */
var BackupMode;
(function (BackupMode) {
    /**
     * All records are backed up.
     */
    BackupMode[BackupMode["ALL"] = 0] = "ALL";
    /**
     * Only records that failed to deliver or transform are backed up.
     */
    BackupMode[BackupMode["FAILED"] = 1] = "FAILED";
})(BackupMode = exports.BackupMode || (exports.BackupMode = {}));
//# sourceMappingURL=data:application/json;base64,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