"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.flinkApplicationConfiguration = void 0;
/**
 * Build the nested Cfn FlinkApplicationConfiguration object. This function
 * doesn't return empty config objects, returning the minimal config needed to
 * express the supplied properties.
 *
 * This function also handles the quirky configType: 'CUSTOM' setting required
 * whenever config in one of the nested groupings.
 */
function flinkApplicationConfiguration(config) {
    const checkpointConfiguration = configFor({
        checkpointingEnabled: config.checkpointingEnabled,
        checkpointInterval: config.checkpointInterval?.toMilliseconds(),
        minPauseBetweenCheckpoints: config.minPauseBetweenCheckpoints?.toMilliseconds(),
    });
    const monitoringConfiguration = configFor({
        logLevel: config.logLevel,
        metricsLevel: config.metricsLevel,
    });
    const parallelismConfiguration = configFor({
        autoScalingEnabled: config.autoScalingEnabled,
        parallelism: config.parallelism,
        parallelismPerKpu: config.parallelismPerKpu,
    });
    const applicationConfiguration = {
        checkpointConfiguration,
        monitoringConfiguration,
        parallelismConfiguration,
    };
    if (isEmptyObj(applicationConfiguration)) {
        return;
    }
    return applicationConfiguration;
}
exports.flinkApplicationConfiguration = flinkApplicationConfiguration;
function configFor(config) {
    if (isEmptyObj(config)) {
        return;
    }
    return {
        ...config,
        configurationType: 'CUSTOM',
    };
}
function isEmptyObj(obj) {
    return Object.values(obj).every(v => v === undefined);
}
//# sourceMappingURL=data:application/json;base64,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