PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE data_source (
	id INTEGER NOT NULL, 
	name VARCHAR(100), 
	uri VARCHAR(200), 
	md5 VARCHAR(32), 
	notes VARCHAR(1000), 
	PRIMARY KEY (id), 
	UNIQUE (md5)
);
INSERT INTO data_source VALUES(1,'Import of controls.fasta','controls.fasta','edb7776a3eb1b0bf999aca6cc8069ea0','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(2,'Import of 2019-BL-1B_S117_L001.fasta','single_isolates/2019-BL-1B_S117_L001.fasta','410868d1b3a20dae9588e2dec224d35d','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(3,'Import of 2019-Pp2_S176_L001.fasta','single_isolates/2019-Pp2_S176_L001.fasta','635eba28bca958be156600f5a76fa130','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(4,'Import of 75-BT3-1gDNA-P-austrocedrae-F08_S68_L001.fasta','single_isolates/75-BT3-1gDNA-P-austrocedrae-F08_S68_L001.fasta','b9d033fb512a938bbd43a9d37a02617a','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(5,'Import of 76-GA3-1gDNA-P-austrocedrae-G08_S80_L001.fasta','single_isolates/76-GA3-1gDNA-P-austrocedrae-G08_S80_L001.fasta','a0f23279ec301b6e24fbd917bca8f9d2','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(6,'Import of 78-CPB-DNA-from-FR-dil-1-100-P-obscura-H08_S92_L001.fasta','single_isolates/78-CPB-DNA-from-FR-dil-1-100-P-obscura-H08_S92_L001.fasta','24e99e17cc8762f1f3a3be3b70ab8251','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(7,'Import of 88069-P-infestans-56-A04_S4_L001.fasta','single_isolates/88069-P-infestans-56-A04_S4_L001.fasta','0c3feb4c0fe4dbcee2a8211e45c88c0b','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(8,'Import of P-Europaea-DNA-from-FR-dil-1-100-F07_S67_L001.fasta','single_isolates/P-Europaea-DNA-from-FR-dil-1-100-F07_S67_L001.fasta','be94bad04e61973e3cedafcbee01049c','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(9,'Import of P-cinnamomi-82-1-10-A07_S7_L001.fasta','single_isolates/P-cinnamomi-82-1-10-A07_S7_L001.fasta','e908d7662bf813cbbd1579bab316a2cc','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(10,'Import of P-foliorum_S165_L001.fasta','single_isolates/P-foliorum_S165_L001.fasta','ef558628310ffd3f7ab3b453456817f1','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(11,'Import of Pd2c_S105_L001.fasta','single_isolates/Pd2c_S105_L001.fasta','48cd9b09775236178a0e605caa41bd7c','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(12,'Import of RG161_S139_L001.fasta','single_isolates/RG161_S139_L001.fasta','ce517ab8e7df28177f0d0d3f158c5306','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(13,'Import of SCRP-1161-P-austrocedrae-1-C03_S27_L001.fasta','single_isolates/SCRP-1161-P-austrocedrae-1-C03_S27_L001.fasta','f8969263fa5826630533a64c813e2622','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(14,'Import of SCRP-1161-P-austrocedrae-1-G01_S73_L001.fasta','single_isolates/SCRP-1161-P-austrocedrae-1-G01_S73_L001.fasta','46ad4dde36e46288c54f50aa539aac1f','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(15,'Import of SCRP-1161-P-austrocedrae-2-D03_S39_L001.fasta','single_isolates/SCRP-1161-P-austrocedrae-2-D03_S39_L001.fasta','3713ec1a19429c90b78022103c55b4e2','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(16,'Import of SCRP-1161-P-austrocedrae-2-D10_S46_L001.fasta','single_isolates/SCRP-1161-P-austrocedrae-2-D10_S46_L001.fasta','868c7b450a4c7bc23654eb5c3887518b','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(17,'Import of SCRP-1161-P-austrocedrae-2-H01_S85_L001.fasta','single_isolates/SCRP-1161-P-austrocedrae-2-H01_S85_L001.fasta','2af51b23a7044a5bac99cbc22d2f69a5','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(18,'Import of SCRP-1161-P-austrocedrae-3-A02_S2_L001.fasta','single_isolates/SCRP-1161-P-austrocedrae-3-A02_S2_L001.fasta','542a75fb4f1200fb53f85b8295721ced','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(19,'Import of SCRP-1161-P-austrocedrae-3-E03_S51_L001.fasta','single_isolates/SCRP-1161-P-austrocedrae-3-E03_S51_L001.fasta','a11ec91a4bb7ab5783f89cdacb64acc5','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(20,'Import of SCRP-1161-P-austrocedrae-3-E10_S58_L001.fasta','single_isolates/SCRP-1161-P-austrocedrae-3-E10_S58_L001.fasta','7f77d2ca72611ab2fbc097df1ebf0498','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(21,'Import of SCRP-1163-P-gonapodyides-C06_S30_L001.fasta','single_isolates/SCRP-1163-P-gonapodyides-C06_S30_L001.fasta','e3becd9bca1b9dae7d64b57bac23d5f2','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(22,'Import of SCRP-1170-P-Erythroseptica-B08_S20_L001.fasta','single_isolates/SCRP-1170-P-Erythroseptica-B08_S20_L001.fasta','ab5969cfa74cbdfae2e8709c6e8a1db2','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(23,'Import of SCRP-1171-P-Erythroseptica-C08_S32_L001.fasta','single_isolates/SCRP-1171-P-Erythroseptica-C08_S32_L001.fasta','5e4b1918da6bddba2762de9d43d42229','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(24,'Import of SCRP-1197-P-nicotianae-50-or-51-C04_S28_L001.fasta','single_isolates/SCRP-1197-P-nicotianae-50-or-51-C04_S28_L001.fasta','0930f783ab98db5c23d4258a638b238f','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(25,'Import of SCRP-734-P-pseudosyringae-1-D01_S37_L001.fasta','single_isolates/SCRP-734-P-pseudosyringae-1-D01_S37_L001.fasta','2cccb1400e24c869165229914a18c522','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(26,'Import of SCRP-734-P-pseudosyringae-1-H02_S86_L001.fasta','single_isolates/SCRP-734-P-pseudosyringae-1-H02_S86_L001.fasta','52691ec02b9f2c0e06aba8e34def7dae','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(27,'Import of SCRP-734-P-pseudosyringae-2-A03_S3_L001.fasta','single_isolates/SCRP-734-P-pseudosyringae-2-A03_S3_L001.fasta','4a9fee9d3ea2d3e6fee66422dea7bb1a','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(28,'Import of SCRP-734-P-pseudosyringae-2-A10_S10_L001.fasta','single_isolates/SCRP-734-P-pseudosyringae-2-A10_S10_L001.fasta','fdf9cbab00b6ef0f2c1e49899c933c5e','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(29,'Import of SCRP-734-P-pseudosyringae-2-E01_S49_L001.fasta','single_isolates/SCRP-734-P-pseudosyringae-2-E01_S49_L001.fasta','c5b212be82d798ce53d8e8abf866c6a8','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(30,'Import of SCRP-734-P-pseudosyringae-3-B03_S15_L001.fasta','single_isolates/SCRP-734-P-pseudosyringae-3-B03_S15_L001.fasta','85a836986733ee22e41de822b4e53a09','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(31,'Import of SCRP-734-P-pseudosyringae-3-B10_S22_L001.fasta','single_isolates/SCRP-734-P-pseudosyringae-3-B10_S22_L001.fasta','66dc12b09af8d0ab08b974b6c52956bf','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(32,'Import of SCRP-734-P-pseudosyringae-3-F01_S61_L001.fasta','single_isolates/SCRP-734-P-pseudosyringae-3-F01_S61_L001.fasta','ee1d2a67f92a04c637636511acc02ab0','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(33,'Import of SCRP10-P-aln-G06_S78_L001.fasta','single_isolates/SCRP10-P-aln-G06_S78_L001.fasta','f8f27981a37a487e1519569b4e435b60','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(34,'Import of SCRP1022-P-capsici-40-B05_S17_L001.fasta','single_isolates/SCRP1022-P-capsici-40-B05_S17_L001.fasta','de4e34757e41d78cd06e0971ec4f5f48','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(35,'Import of SCRP1161-P-austrocedrae-1-20-1-C10_S34_L001.fasta','single_isolates/SCRP1161-P-austrocedrae-1-20-1-C10_S34_L001.fasta','08c99d3effea5a8d7bd23ed7042c27d1','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(36,'Import of SCRP1162-P-austrocedrae-E08_S56_L001.fasta','single_isolates/SCRP1162-P-austrocedrae-E08_S56_L001.fasta','c4bb3e46150402c1e226f0a1905ea1a4','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(37,'Import of SCRP1218_S174_L001.fasta','single_isolates/SCRP1218_S174_L001.fasta','40c5346460c7092a496554815167bc0a','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(38,'Import of SCRP1220_S151_L001.fasta','single_isolates/SCRP1220_S151_L001.fasta','20457e003ea03927c65e4a502da9910e','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(39,'Import of SCRP1222_S187_L001.fasta','single_isolates/SCRP1222_S187_L001.fasta','3250d35908ce49b9ec60660f6c170c33','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(40,'Import of SCRP1226_S186_L001.fasta','single_isolates/SCRP1226_S186_L001.fasta','d29f93bed44dbc54d419e9601a31ef0c','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(41,'Import of SCRP1227_S103_L001.fasta','single_isolates/SCRP1227_S103_L001.fasta','e60694b4ef3d691de374936234e377f0','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(42,'Import of SCRP165-P-citricola-T-60-D05_S41_L001.fasta','single_isolates/SCRP165-P-citricola-T-60-D05_S41_L001.fasta','3879365d7d1df03d7196fa2decaa68f2','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(43,'Import of SCRP179_S177_L001.fasta','single_isolates/SCRP179_S177_L001.fasta','f658223ca78a1d1f1013abcc387f9b00','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(44,'Import of SCRP207-P-Cryptogea-72-or-73-A08_S8_L001.fasta','single_isolates/SCRP207-P-Cryptogea-72-or-73-A08_S8_L001.fasta','5a677701dd0859de85bf4b312334ff9b','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(45,'Import of SCRP23-P-boehmeriae-1-B09_S21_L001.fasta','single_isolates/SCRP23-P-boehmeriae-1-B09_S21_L001.fasta','e0717d26d51db4824192dd5efca69f4d','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(46,'Import of SCRP231-P-cajani-71-1-10-C07_S31_L001.fasta','single_isolates/SCRP231-P-cajani-71-1-10-C07_S31_L001.fasta','51feea1bd7f7ad00bfa1ba1511adb456','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(47,'Import of SCRP333-P-rubi-race-3-45-E07_S55_L001.fasta','single_isolates/SCRP333-P-rubi-race-3-45-E07_S55_L001.fasta','e5cb0b82772fa9c9eaad1c47316bee02','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(48,'Import of SCRP35-1-or-2-P-cactorum-CAC17-R222-E04_S52_L001.fasta','single_isolates/SCRP35-1-or-2-P-cactorum-CAC17-R222-E04_S52_L001.fasta','f3a196ad5363cb2c98aa6957d6883ac7','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(49,'Import of SCRP37-P-cactorum-CAC19-145H-F04_S64_L001.fasta','single_isolates/SCRP37-P-cactorum-CAC19-145H-F04_S64_L001.fasta','2ef825ce0e519fa051c3188aa22828a7','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(50,'Import of SCRP371-P-idaei-41-A05_S5_L001.fasta','single_isolates/SCRP371-P-idaei-41-A05_S5_L001.fasta','bd71cd2dc3f11e28bf1f60a06377b35b','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(51,'Import of SCRP372-P-idaei-47-H04_S88_L001.fasta','single_isolates/SCRP372-P-idaei-47-H04_S88_L001.fasta','c5ffdbf050c1bea2f9e054bbd35d4cbc','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(52,'Import of SCRP377-P-ilicis-62-E05_S53_L001.fasta','single_isolates/SCRP377-P-ilicis-62-E05_S53_L001.fasta','aa05088fdddbcdef3efa42d63b8f762c','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(53,'Import of SCRP386-P-iranica-48-D04_S40_L001.fasta','single_isolates/SCRP386-P-iranica-48-D04_S40_L001.fasta','d057c13577581d15d1071c1791406044','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(54,'Import of SCRP388-P-castaneae-44-H05_S89_L001.fasta','single_isolates/SCRP388-P-castaneae-44-H05_S89_L001.fasta','73903eca1d478b0ef7af0f34c3bb55ac','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(55,'Import of SCRP390_S129_L001.fasta','single_isolates/SCRP390_S129_L001.fasta','9311bd8dea14d0d9937bfa6e9866e25e','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(56,'Import of SCRP417-1-OR-2-P-megasperma-B06_S18_L001.fasta','single_isolates/SCRP417-1-OR-2-P-megasperma-B06_S18_L001.fasta','c0a24e66621635578470beb91eced8ff','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(57,'Import of SCRP420-P-megasperma-66-A06_S6_L001.fasta','single_isolates/SCRP420-P-megasperma-66-A06_S6_L001.fasta','5acf6c06b4d62f75a6e123db53a6296c','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(58,'Import of SCRP455-P-melonis-70-B07_S19_L001.fasta','single_isolates/SCRP455-P-melonis-70-B07_S19_L001.fasta','4b0bf6de70eb3d7f579886718b79c628','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(59,'Import of SCRP474-P-palmivora-11-F05_S65_L001.fasta','single_isolates/SCRP474-P-palmivora-11-F05_S65_L001.fasta','3befac09d8878973c82e7eb44fcfa3d0','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(60,'Import of SCRP526-P-palmivora-64A-G05_S77_L001.fasta','single_isolates/SCRP526-P-palmivora-64A-G05_S77_L001.fasta','f8ca44626ff7db82d9058334cbc24cea','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(61,'Import of SCRP56-P-cactorum-CH97-46-G04_S76_L001.fasta','single_isolates/SCRP56-P-cactorum-CH97-46-G04_S76_L001.fasta','eb4672cd94ded5acded4804cb58fac98','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(62,'Import of SCRP607-P-fallax-12-A09_S9_L001.fasta','single_isolates/SCRP607-P-fallax-12-A09_S9_L001.fasta','eee190f0dcd5ef525330aa6749178139','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(63,'Import of SCRP645-P-inundata-68-D06_S42_L001.fasta','single_isolates/SCRP645-P-inundata-68-D06_S42_L001.fasta','c3fb81d5717bde4e7c02724b14aa91b5','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(64,'Import of SCRP660-P-syringae-83-H07_S91_L001.fasta','single_isolates/SCRP660-P-syringae-83-H07_S91_L001.fasta','0d64fab90e2d9adb856694021488ccb0','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(65,'Import of SCRP660_S153_L001.fasta','single_isolates/SCRP660_S153_L001.fasta','f3d25ef3e862f31f1f8db427c41a14a2','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(66,'Import of SCRP71-P-cambivora-69-cam5-H06_S90_L001.fasta','single_isolates/SCRP71-P-cambivora-69-cam5-H06_S90_L001.fasta','c5dc489ab31a75f6c71f358693c6f7e5','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(67,'Import of SCRP722_S141_L001.fasta','single_isolates/SCRP722_S141_L001.fasta','4c872ee9200a34b28e7875ead4824085','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(68,'Import of SCRP734-1-or-2-P-pseudosyringae-1-H09_S93_L001.fasta','single_isolates/SCRP734-1-or-2-P-pseudosyringae-1-H09_S93_L001.fasta','74999328eb896c5a45fc0312555198cb','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(69,'Import of SCRP893-P-sojae-22-D07_S43_L001.fasta','single_isolates/SCRP893-P-sojae-22-D07_S43_L001.fasta','6fa60abf7f948991beb77b07ee6c2d83','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(70,'Import of SCRP9-P-aln-F06_S66_L001.fasta','single_isolates/SCRP9-P-aln-F06_S66_L001.fasta','c75bffcc1dbe0796d93ce8a94260e480','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(71,'Import of SRCP1221_S175_L001.fasta','single_isolates/SRCP1221_S175_L001.fasta','54911ef6e9117cbbd553c59aa227bc33','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(72,'Import of T-30-4-1-A01_S1_L001.fasta','single_isolates/T-30-4-1-A01_S1_L001.fasta','80c04900062c2ba8e982b2fb637f51f3','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(73,'Import of T-30-4-1-E02_S50_L001.fasta','single_isolates/T-30-4-1-E02_S50_L001.fasta','34c531f18befe1491edcbc07ec012e4d','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(74,'Import of T-30-4-2-B01_S13_L001.fasta','single_isolates/T-30-4-2-B01_S13_L001.fasta','f9fc3f1112d2884a014b3ffdc2aa30da','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(75,'Import of T-30-4-2-F02_S62_L001.fasta','single_isolates/T-30-4-2-F02_S62_L001.fasta','8adbc9331abd7ee1773c7e0d3f905be9','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(76,'Import of T-30-4-2-F09_S69_L001.fasta','single_isolates/T-30-4-2-F09_S69_L001.fasta','83a1a21c498a999507a8ec35c86417b0','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(77,'Import of T-30-4-3-C01_S25_L001.fasta','single_isolates/T-30-4-3-C01_S25_L001.fasta','f6e61f47db1ba63aecc7d0734931542b','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(78,'Import of T-30-4-3-G02_S74_L001.fasta','single_isolates/T-30-4-3-G02_S74_L001.fasta','491646427d79cb86f4e5197e3e4708da','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(79,'Import of T-30-4-3-G09_S81_L001.fasta','single_isolates/T-30-4-3-G09_S81_L001.fasta','de47994e2847642ce2f866cc7effe56d','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(80,'Import of T30-4-P-infestans-55-1-20-1-E09_S57_L001.fasta','single_isolates/T30-4-P-infestans-55-1-20-1-E09_S57_L001.fasta','f5a8a74f793605f8ae25dd951a6fb5e9','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(81,'Import of WL54_S128_L001.fasta','single_isolates/WL54_S128_L001.fasta','23ea6eb01b59cb5325acfc772383f218','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(82,'Import of WL77_S152_L001.fasta','single_isolates/WL77_S152_L001.fasta','8793ff33cef54442371a8943b666df7c','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(83,'Import of 2021-05-20-ITS_Oomycota_w32.fasta','2021-05-20-ITS_Oomycota_w32.fasta','6836a6163a48deed89ae18e84dc09b59','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(84,'Import of Nothophytophthora_ITS1_curated.fasta','Nothophytophthora_ITS1_curated.fasta','24e4f65f515b9e8428f6f635f4189dab','Imported with thapbi_pict v0.9.7');
INSERT INTO data_source VALUES(85,'Import of Phytophthora_ITS1_curated.fasta','Phytophthora_ITS1_curated.fasta','f707dd4f0b03d290019e580aa919c783','Imported with thapbi_pict v0.9.7');
CREATE TABLE taxonomy (
	id INTEGER NOT NULL, 
	ncbi_taxid INTEGER, 
	genus VARCHAR(100) NOT NULL, 
	species VARCHAR(100) NOT NULL, 
	PRIMARY KEY (id)
);
INSERT INTO taxonomy VALUES(1,4765,'Achlya','');
INSERT INTO taxonomy VALUES(2,4769,'Saprolegnia','');
INSERT INTO taxonomy VALUES(3,4778,'Bremia','');
INSERT INTO taxonomy VALUES(4,4780,'Plasmopara','');
INSERT INTO taxonomy VALUES(5,4783,'Phytophthora','');
INSERT INTO taxonomy VALUES(6,4797,'Pythium','');
INSERT INTO taxonomy VALUES(7,4802,'Lagenidium','');
INSERT INTO taxonomy VALUES(8,65356,'Albugo','');
INSERT INTO taxonomy VALUES(9,70742,'Peronospora','');
INSERT INTO taxonomy VALUES(10,74556,'Thraustotheca','');
INSERT INTO taxonomy VALUES(11,74559,'Dictyuchus','');
INSERT INTO taxonomy VALUES(12,92968,'Pythiopsis','');
INSERT INTO taxonomy VALUES(13,92971,'Aplanopsis','');
INSERT INTO taxonomy VALUES(14,92975,'Leptolegnia','');
INSERT INTO taxonomy VALUES(15,92980,'Apodachlya','');
INSERT INTO taxonomy VALUES(16,100860,'Aphanomyces','');
INSERT INTO taxonomy VALUES(17,100862,'Plectospira','');
INSERT INTO taxonomy VALUES(18,100865,'Leptomitus','');
INSERT INTO taxonomy VALUES(19,100873,'Sapromyces','');
INSERT INTO taxonomy VALUES(20,112093,'Brevilegnia','');
INSERT INTO taxonomy VALUES(21,120399,'Aplanes','');
INSERT INTO taxonomy VALUES(22,120403,'Calyptralegnia','');
INSERT INTO taxonomy VALUES(23,120410,'Pachymetra','');
INSERT INTO taxonomy VALUES(24,120422,'Scoliolegnia','');
INSERT INTO taxonomy VALUES(25,127445,'Halophytophthora','');
INSERT INTO taxonomy VALUES(26,134688,'Isoachlya','');
INSERT INTO taxonomy VALUES(27,135472,'Haliphthoros','');
INSERT INTO taxonomy VALUES(28,135475,'Atkinsiella','');
INSERT INTO taxonomy VALUES(29,135478,'Halocrusticida','');
INSERT INTO taxonomy VALUES(30,143452,'Pseudoperonospora','');
INSERT INTO taxonomy VALUES(31,159316,'Eurychasma','');
INSERT INTO taxonomy VALUES(32,162127,'Basidiophora','');
INSERT INTO taxonomy VALUES(33,162129,'Sclerospora','');
INSERT INTO taxonomy VALUES(34,162131,'Paraperonospora','');
INSERT INTO taxonomy VALUES(35,184462,'Hyaloperonospora','');
INSERT INTO taxonomy VALUES(36,184464,'Perofascia','');
INSERT INTO taxonomy VALUES(37,230838,'Peronosclerospora','');
INSERT INTO taxonomy VALUES(38,244731,'Viennotia','');
INSERT INTO taxonomy VALUES(39,335372,'Protobremia','');
INSERT INTO taxonomy VALUES(40,369777,'Benua','');
INSERT INTO taxonomy VALUES(41,369781,'Plasmoverna','');
INSERT INTO taxonomy VALUES(42,369783,'Graminivora','');
INSERT INTO taxonomy VALUES(43,371951,'Protoachlya','');
INSERT INTO taxonomy VALUES(44,377433,'Haptoglossa','');
INSERT INTO taxonomy VALUES(45,414971,'Halodaphnea','');
INSERT INTO taxonomy VALUES(46,416807,'Olpidiopsis','');
INSERT INTO taxonomy VALUES(47,421926,'Diasporangium','');
INSERT INTO taxonomy VALUES(48,442664,'Myzocytiopsis','');
INSERT INTO taxonomy VALUES(49,461276,'Novotelnova','');
INSERT INTO taxonomy VALUES(50,467175,'Sclerophthora','');
INSERT INTO taxonomy VALUES(51,485443,'Chlamydomyzium','');
INSERT INTO taxonomy VALUES(52,572136,'Wilsoniana','');
INSERT INTO taxonomy VALUES(53,572138,'Pustula','');
INSERT INTO taxonomy VALUES(54,650118,'Halioticida','');
INSERT INTO taxonomy VALUES(55,795339,'Phytopythium','');
INSERT INTO taxonomy VALUES(56,944615,'Pythiogeton','');
INSERT INTO taxonomy VALUES(57,983658,'Salisapilia','');
INSERT INTO taxonomy VALUES(58,1009718,'Eraphthora','');
INSERT INTO taxonomy VALUES(59,1432540,'Geolegnia','');
INSERT INTO taxonomy VALUES(60,1440114,'Paralagenidium','');
INSERT INTO taxonomy VALUES(61,1448050,'Elongisporangium','');
INSERT INTO taxonomy VALUES(62,1448052,'Globisporangium','');
INSERT INTO taxonomy VALUES(63,1448054,'Ovatisporangium','');
INSERT INTO taxonomy VALUES(64,1489788,'Lagena','');
INSERT INTO taxonomy VALUES(65,1495611,'Aquastella','');
INSERT INTO taxonomy VALUES(66,1618012,'Newbya','');
INSERT INTO taxonomy VALUES(67,1635158,'Pilasporangium','');
INSERT INTO taxonomy VALUES(68,1663099,'Anisolpidium','');
INSERT INTO taxonomy VALUES(69,1672053,'Blastulidium','');
INSERT INTO taxonomy VALUES(70,1682048,'Lagenisma','');
INSERT INTO taxonomy VALUES(71,1702222,'Salilagenidium','');
INSERT INTO taxonomy VALUES(72,1729147,'Phragmosporangium','');
INSERT INTO taxonomy VALUES(73,1779447,'Baobabopsis','');
INSERT INTO taxonomy VALUES(74,1862710,'Salispina','');
INSERT INTO taxonomy VALUES(75,2025987,'Nothophytophthora','');
INSERT INTO taxonomy VALUES(76,2050023,'Calycofera','');
INSERT INTO taxonomy VALUES(77,2182427,'Crypticola','');
INSERT INTO taxonomy VALUES(78,2203426,'Miracula','');
INSERT INTO taxonomy VALUES(79,2494380,'Ectrogella','');
INSERT INTO taxonomy VALUES(80,2494382,'Pontisma','');
INSERT INTO taxonomy VALUES(81,2681695,'Diatomophthora','');
INSERT INTO taxonomy VALUES(82,2815746,'Periplasma','');
INSERT INTO taxonomy VALUES(83,112026,'Achlya','americana');
INSERT INTO taxonomy VALUES(84,112027,'Achlya','conspicua');
INSERT INTO taxonomy VALUES(85,112028,'Achlya','aquatica');
INSERT INTO taxonomy VALUES(86,112029,'Achlya','crenulata');
INSERT INTO taxonomy VALUES(87,112030,'Achlya','heterosexualis');
INSERT INTO taxonomy VALUES(88,112031,'Achlya','oligacantha');
INSERT INTO taxonomy VALUES(89,4768,'Achlya','ambisexualis');
INSERT INTO taxonomy VALUES(90,112032,'Achlya','proliferoides');
INSERT INTO taxonomy VALUES(91,4766,'Achlya','bisexualis');
INSERT INTO taxonomy VALUES(92,4767,'Achlya','klebsiana');
INSERT INTO taxonomy VALUES(93,481581,'Achlya','stellata');
INSERT INTO taxonomy VALUES(94,74555,'Achlya','intricata');
INSERT INTO taxonomy VALUES(95,281403,'Achlya','prolifera');
INSERT INTO taxonomy VALUES(96,1628356,'Achlya','androgyna');
INSERT INTO taxonomy VALUES(97,1628357,'Achlya','catenulata');
INSERT INTO taxonomy VALUES(98,944587,'Achlya','sparrowii');
INSERT INTO taxonomy VALUES(99,120396,'Achlya','papillosa');
INSERT INTO taxonomy VALUES(100,120397,'Achlya','treleaseana');
INSERT INTO taxonomy VALUES(101,112078,'Achlya','caroliniana');
INSERT INTO taxonomy VALUES(102,112079,'Achlya','colorata');
INSERT INTO taxonomy VALUES(103,946379,'Achlya','rodrigueziana');
INSERT INTO taxonomy VALUES(104,112081,'Achlya','dubia');
INSERT INTO taxonomy VALUES(105,112082,'Achlya','flagellata');
INSERT INTO taxonomy VALUES(106,112083,'Achlya','glomerata');
INSERT INTO taxonomy VALUES(107,120401,'Achlya','ornata');
INSERT INTO taxonomy VALUES(108,1202772,'Achlya','hypogyna');
INSERT INTO taxonomy VALUES(109,112087,'Achlya','racemosa');
INSERT INTO taxonomy VALUES(110,112088,'Achlya','radiosa');
INSERT INTO taxonomy VALUES(111,112089,'Achlya','recurva');
INSERT INTO taxonomy VALUES(112,1618016,'Achlya','debaryana');
INSERT INTO taxonomy VALUES(113,286561,'Achlya','spiralis');
INSERT INTO taxonomy VALUES(114,1618017,'Achlya','bonariensis');
INSERT INTO taxonomy VALUES(115,558704,'Achlya','primoachlya');
INSERT INTO taxonomy VALUES(116,1729143,'Achlya','orion');
INSERT INTO taxonomy VALUES(117,1729144,'Achlya','oviparvula');
INSERT INTO taxonomy VALUES(118,944640,'Saprolegnia','asterophora');
INSERT INTO taxonomy VALUES(119,944641,'Saprolegnia','delica');
INSERT INTO taxonomy VALUES(120,944642,'Saprolegnia','lapponica');
INSERT INTO taxonomy VALUES(121,1686789,'Saprolegnia','aenigmatica');
INSERT INTO taxonomy VALUES(122,1686790,'Saprolegnia','racemosa');
INSERT INTO taxonomy VALUES(123,370328,'Saprolegnia','cf. ferax');
INSERT INTO taxonomy VALUES(124,2268959,'Saprolegnia','maragheica');
INSERT INTO taxonomy VALUES(125,4770,'Saprolegnia','ferax');
INSERT INTO taxonomy VALUES(126,1873451,'Saprolegnia','milanezii');
INSERT INTO taxonomy VALUES(127,227376,'Saprolegnia','multispora');
INSERT INTO taxonomy VALUES(128,37553,'Saprolegnia','monoica');
INSERT INTO taxonomy VALUES(129,228916,'Saprolegnia','bulbosa');
INSERT INTO taxonomy VALUES(130,281400,'Saprolegnia','salmonis');
INSERT INTO taxonomy VALUES(131,281401,'Saprolegnia','semihypogyna');
INSERT INTO taxonomy VALUES(132,281402,'Saprolegnia','australis');
INSERT INTO taxonomy VALUES(133,1729208,'Saprolegnia','truncata');
INSERT INTO taxonomy VALUES(134,334524,'Saprolegnia','subterranea');
INSERT INTO taxonomy VALUES(135,334525,'Saprolegnia','furcata');
INSERT INTO taxonomy VALUES(136,334526,'Saprolegnia','mixta');
INSERT INTO taxonomy VALUES(137,334527,'Saprolegnia','polymorpha');
INSERT INTO taxonomy VALUES(138,334528,'Saprolegnia','terrestris');
INSERT INTO taxonomy VALUES(139,334529,'Saprolegnia','turfosa');
INSERT INTO taxonomy VALUES(140,327753,'Saprolegnia','megasperma');
INSERT INTO taxonomy VALUES(141,2681168,'Saprolegnia','glomerata');
INSERT INTO taxonomy VALUES(142,2681169,'Saprolegnia','blelhamensis');
INSERT INTO taxonomy VALUES(143,101203,'Saprolegnia','parasitica');
INSERT INTO taxonomy VALUES(144,230109,'Saprolegnia','oliviae');
INSERT INTO taxonomy VALUES(145,230111,'Saprolegnia','longicaulis');
INSERT INTO taxonomy VALUES(146,120416,'Saprolegnia','eccentrica');
INSERT INTO taxonomy VALUES(147,120417,'Saprolegnia','hypogyna');
INSERT INTO taxonomy VALUES(148,112098,'Saprolegnia','diclina');
INSERT INTO taxonomy VALUES(149,120418,'Saprolegnia','litoralis');
INSERT INTO taxonomy VALUES(150,120419,'Saprolegnia','monilifera');
INSERT INTO taxonomy VALUES(151,120420,'Saprolegnia','torulosa');
INSERT INTO taxonomy VALUES(152,120421,'Saprolegnia','unispora');
INSERT INTO taxonomy VALUES(153,120415,'Saprolegnia','anisospora');
INSERT INTO taxonomy VALUES(154,362222,'Saprolegnia','anomalies');
INSERT INTO taxonomy VALUES(155,502112,'Bremia','ovata');
INSERT INTO taxonomy VALUES(156,502113,'Bremia','saussureae');
INSERT INTO taxonomy VALUES(157,502114,'Bremia','sonchicola');
INSERT INTO taxonomy VALUES(158,1484098,'Bremia','aff. lagoseridis GLM68027');
INSERT INTO taxonomy VALUES(159,1484099,'Bremia','picridis');
INSERT INTO taxonomy VALUES(160,1484100,'Bremia','elliptica');
INSERT INTO taxonomy VALUES(161,913194,'Bremia','cirsii');
INSERT INTO taxonomy VALUES(162,4779,'Bremia','lactucae');
INSERT INTO taxonomy VALUES(163,913195,'Bremia','lapsanae');
INSERT INTO taxonomy VALUES(164,913196,'Bremia','tulasnei');
INSERT INTO taxonomy VALUES(165,913197,'Bremia','taraxaci');
INSERT INTO taxonomy VALUES(166,2562513,'Bremia','cf. cirsii');
INSERT INTO taxonomy VALUES(167,2507514,'Bremia','itoana');
INSERT INTO taxonomy VALUES(168,461275,'Bremia','centaureae');
INSERT INTO taxonomy VALUES(169,502111,'Bremia','microspora');
INSERT INTO taxonomy VALUES(170,1089797,'Plasmopara','majewskii');
INSERT INTO taxonomy VALUES(171,562958,'Plasmopara','siegesbeckiae');
INSERT INTO taxonomy VALUES(172,2575762,'Plasmopara','elegantissima');
INSERT INTO taxonomy VALUES(173,1196443,'Plasmopara','muralis');
INSERT INTO taxonomy VALUES(174,1825568,'Plasmopara','australis');
INSERT INTO taxonomy VALUES(175,343460,'Plasmopara','wilsonii');
INSERT INTO taxonomy VALUES(176,343461,'Plasmopara','praetermissa');
INSERT INTO taxonomy VALUES(177,240424,'Plasmopara','megasperma');
INSERT INTO taxonomy VALUES(178,4781,'Plasmopara','halstedii');
INSERT INTO taxonomy VALUES(179,2019373,'Plasmopara','velutina');
INSERT INTO taxonomy VALUES(180,2019374,'Plasmopara','destructor');
INSERT INTO taxonomy VALUES(181,438833,'Plasmopara','constantinescui');
INSERT INTO taxonomy VALUES(182,235575,'Plasmopara','wildemaniana');
INSERT INTO taxonomy VALUES(183,235576,'Plasmopara','solidaginis');
INSERT INTO taxonomy VALUES(184,235577,'Plasmopara','baudysii');
INSERT INTO taxonomy VALUES(185,235579,'Plasmopara','angelicae');
INSERT INTO taxonomy VALUES(186,235580,'Plasmopara','peucedani');
INSERT INTO taxonomy VALUES(187,235581,'Plasmopara','pastinacae');
INSERT INTO taxonomy VALUES(188,235582,'Plasmopara','mei-foeniculi');
INSERT INTO taxonomy VALUES(189,235584,'Plasmopara','chaerophylli');
INSERT INTO taxonomy VALUES(190,235585,'Plasmopara','epilobii');
INSERT INTO taxonomy VALUES(191,235586,'Plasmopara','skvortzovii');
INSERT INTO taxonomy VALUES(192,2770502,'Plasmopara','carlottae');
INSERT INTO taxonomy VALUES(193,2770503,'Plasmopara','latifolii');
INSERT INTO taxonomy VALUES(194,162136,'Plasmopara','sii');
INSERT INTO taxonomy VALUES(195,162137,'Plasmopara','pimpinellae');
INSERT INTO taxonomy VALUES(196,162138,'Plasmopara','geranii');
INSERT INTO taxonomy VALUES(197,162139,'Plasmopara','pusilla');
INSERT INTO taxonomy VALUES(198,143451,'Plasmopara','viticola');
INSERT INTO taxonomy VALUES(199,162140,'Plasmopara','obducens');
INSERT INTO taxonomy VALUES(200,162141,'Plasmopara','densa');
INSERT INTO taxonomy VALUES(201,436701,'Plasmopara','penniseti');
INSERT INTO taxonomy VALUES(202,461279,'Plasmopara','euphrasiae');
INSERT INTO taxonomy VALUES(203,1564265,'Plasmopara','sphagneticolae');
INSERT INTO taxonomy VALUES(204,1344363,'Plasmopara','laserpitii');
INSERT INTO taxonomy VALUES(205,369779,'Plasmopara','nivea');
INSERT INTO taxonomy VALUES(206,1463539,'Plasmopara','invertifolia');
INSERT INTO taxonomy VALUES(207,338422,'Plasmopara','geranii-sylvatici');
INSERT INTO taxonomy VALUES(208,222716,'Plasmopara','angustiterminalis');
INSERT INTO taxonomy VALUES(209,67591,'Phytophthora','macrochlamydospora');
INSERT INTO taxonomy VALUES(210,67592,'Phytophthora','iranica');
INSERT INTO taxonomy VALUES(211,67593,'Phytophthora','sojae');
INSERT INTO taxonomy VALUES(212,67594,'Phytophthora','syringae');
INSERT INTO taxonomy VALUES(213,67595,'Phytophthora','vignae');
INSERT INTO taxonomy VALUES(214,639000,'Phytophthora','plurivora');
INSERT INTO taxonomy VALUES(215,565287,'Phytophthora','irrigata');
INSERT INTO taxonomy VALUES(216,565288,'Phytophthora','hydropathica');
INSERT INTO taxonomy VALUES(217,2811959,'Phytophthora','theobromicola');
INSERT INTO taxonomy VALUES(218,1216624,'Phytophthora','cf. tropicalis');
INSERT INTO taxonomy VALUES(219,1216625,'Phytophthora','cf. insolita');
INSERT INTO taxonomy VALUES(220,1216626,'Phytophthora','cf. mexicana');
INSERT INTO taxonomy VALUES(221,596104,'Phytophthora','multivora');
INSERT INTO taxonomy VALUES(222,544909,'Phytophthora','parsiana');
INSERT INTO taxonomy VALUES(223,2719893,'Phytophthora','cf. meadii');
INSERT INTO taxonomy VALUES(224,1704119,'Phytophthora','cf. fluvialis hybrid DH117');
INSERT INTO taxonomy VALUES(225,1704120,'Phytophthora','cf. fluvialis hybrid VHS29992');
INSERT INTO taxonomy VALUES(226,1704121,'Phytophthora','cf. thermophila hybrid DH106');
INSERT INTO taxonomy VALUES(227,1704123,'Phytophthora','moyootj x thermophila');
INSERT INTO taxonomy VALUES(228,1704125,'Phytophthora','amnicola x moyootj');
INSERT INTO taxonomy VALUES(229,1704126,'Phytophthora','moyootj x fluvialis');
INSERT INTO taxonomy VALUES(230,1704127,'Phytophthora','fluvialis x moyootj');
INSERT INTO taxonomy VALUES(231,1704128,'Phytophthora','moyootj x litoralis');
INSERT INTO taxonomy VALUES(232,1704129,'Phytophthora','litoralis x moyootj');
INSERT INTO taxonomy VALUES(233,1704130,'Phytophthora','thermophila x moyootj');
INSERT INTO taxonomy VALUES(234,1861846,'Phytophthora','attenuata');
INSERT INTO taxonomy VALUES(235,1861847,'Phytophthora','x heterohybrida');
INSERT INTO taxonomy VALUES(236,1861857,'Phytophthora','formosana');
INSERT INTO taxonomy VALUES(237,1861858,'Phytophthora','x incrassata');
INSERT INTO taxonomy VALUES(238,1861859,'Phytophthora','flexuosa');
INSERT INTO taxonomy VALUES(239,1861860,'Phytophthora','intricata');
INSERT INTO taxonomy VALUES(240,1857766,'Phytophthora','aff. meadii');
INSERT INTO taxonomy VALUES(241,415976,'Phytophthora','foliorum');
INSERT INTO taxonomy VALUES(242,1806582,'Phytophthora','aff. meadii AdP-2013');
INSERT INTO taxonomy VALUES(243,2822405,'Phytophthora','multibullata');
INSERT INTO taxonomy VALUES(244,2822406,'Phytophthora','insulinativitatica');
INSERT INTO taxonomy VALUES(245,2822408,'Phytophthora','x vanyenensis');
INSERT INTO taxonomy VALUES(246,1696062,'Phytophthora','ornamentata');
INSERT INTO taxonomy VALUES(247,129347,'Phytophthora','arecae');
INSERT INTO taxonomy VALUES(248,129348,'Phytophthora','botryosa');
INSERT INTO taxonomy VALUES(249,129349,'Phytophthora','cajani');
INSERT INTO taxonomy VALUES(250,129350,'Phytophthora','colocasiae');
INSERT INTO taxonomy VALUES(251,129351,'Phytophthora','heveae');
INSERT INTO taxonomy VALUES(252,129352,'Phytophthora','humicola');
INSERT INTO taxonomy VALUES(253,129353,'Phytophthora','inflata');
INSERT INTO taxonomy VALUES(254,129354,'Phytophthora','katsurae');
INSERT INTO taxonomy VALUES(255,129355,'Phytophthora','lateralis');
INSERT INTO taxonomy VALUES(256,129356,'Phytophthora','mirabilis');
INSERT INTO taxonomy VALUES(257,129357,'Phytophthora','multivesiculata');
INSERT INTO taxonomy VALUES(258,221518,'Phytophthora','pseudosyringae');
INSERT INTO taxonomy VALUES(259,129358,'Phytophthora','phaseoli');
INSERT INTO taxonomy VALUES(260,129359,'Phytophthora','porri');
INSERT INTO taxonomy VALUES(261,129360,'Phytophthora','primulae');
INSERT INTO taxonomy VALUES(262,129361,'Phytophthora','sinensis');
INSERT INTO taxonomy VALUES(263,129362,'Phytophthora','tentaculata');
INSERT INTO taxonomy VALUES(264,129364,'Phytophthora','rubi');
INSERT INTO taxonomy VALUES(265,239968,'Phytophthora','nemorosa');
INSERT INTO taxonomy VALUES(266,1218935,'Phytophthora','cf. citricola FM-2012');
INSERT INTO taxonomy VALUES(267,2802040,'Phytophthora','cf. castaneae');
INSERT INTO taxonomy VALUES(268,2802041,'Phytophthora','cf. heveae');
INSERT INTO taxonomy VALUES(269,1218936,'Phytophthora','aff. citricola 1 FM-2012');
INSERT INTO taxonomy VALUES(270,1218937,'Phytophthora','aff. citricola 2 FM-2012');
INSERT INTO taxonomy VALUES(271,1218938,'Phytophthora','cf. citrophthora 1b FM-2012');
INSERT INTO taxonomy VALUES(272,1218939,'Phytophthora','cf. citrophthora 2 FM-2012');
INSERT INTO taxonomy VALUES(273,1218940,'Phytophthora','cf. cryptogea 1 FM-2012');
INSERT INTO taxonomy VALUES(274,1218942,'Phytophthora','cf. heveae 1 FM-2012');
INSERT INTO taxonomy VALUES(275,299391,'Phytophthora','alni');
INSERT INTO taxonomy VALUES(276,299392,'Phytophthora','x alni');
INSERT INTO taxonomy VALUES(277,283009,'Phytophthora','andina');
INSERT INTO taxonomy VALUES(278,283010,'Phytophthora','hybrid Dutch variant');
INSERT INTO taxonomy VALUES(279,299393,'Phytophthora','uniformis');
INSERT INTO taxonomy VALUES(280,283007,'Phytophthora','ipomoeae');
INSERT INTO taxonomy VALUES(281,299394,'Phytophthora','x multiformis');
INSERT INTO taxonomy VALUES(282,1218943,'Phytophthora','cf. heveae 2 FM-2012');
INSERT INTO taxonomy VALUES(283,1218944,'Phytophthora','cf. katsurae 1 FM-2012');
INSERT INTO taxonomy VALUES(284,1218945,'Phytophthora','cf. katsurae 2 FM-2012');
INSERT INTO taxonomy VALUES(285,1218947,'Phytophthora','cf. cryptogea 2 FM-2012');
INSERT INTO taxonomy VALUES(286,1380738,'Phytophthora','pachypleura');
INSERT INTO taxonomy VALUES(287,244122,'Phytophthora','inundata');
INSERT INTO taxonomy VALUES(288,78236,'Phytophthora','quercina');
INSERT INTO taxonomy VALUES(289,78237,'Phytophthora','gonapodyides');
INSERT INTO taxonomy VALUES(290,555429,'Phytophthora','sansomeana');
INSERT INTO taxonomy VALUES(291,2064827,'Phytophthora','aff. syringae');
INSERT INTO taxonomy VALUES(292,1104319,'Phytophthora','obscura');
INSERT INTO taxonomy VALUES(293,909764,'Phytophthora','cf. rosacearum');
INSERT INTO taxonomy VALUES(294,1771973,'Phytophthora','crassamura');
INSERT INTO taxonomy VALUES(295,244167,'Phytophthora','rosacearum');
INSERT INTO taxonomy VALUES(296,1401295,'Phytophthora','stricta');
INSERT INTO taxonomy VALUES(297,1286608,'Phytophthora','hydrogena');
INSERT INTO taxonomy VALUES(298,1401296,'Phytophthora','macilentosa');
INSERT INTO taxonomy VALUES(299,192975,'Phytophthora','meadii');
INSERT INTO taxonomy VALUES(300,127442,'Phytophthora','insolita');
INSERT INTO taxonomy VALUES(301,127443,'Phytophthora','richardiae');
INSERT INTO taxonomy VALUES(302,127444,'Phytophthora','undulata');
INSERT INTO taxonomy VALUES(303,928215,'Phytophthora','himalsilva');
INSERT INTO taxonomy VALUES(304,944600,'Phytophthora','aff. botryosa');
INSERT INTO taxonomy VALUES(305,944601,'Phytophthora','aff. sansomeana');
INSERT INTO taxonomy VALUES(306,944602,'Phytophthora','batemanensis');
INSERT INTO taxonomy VALUES(307,907744,'Phytophthora','aff. infestans');
INSERT INTO taxonomy VALUES(308,907745,'Phytophthora','aff. rosacearum');
INSERT INTO taxonomy VALUES(309,944609,'Phytophthora','tabaci');
INSERT INTO taxonomy VALUES(310,907748,'Phytophthora','aff. primulae');
INSERT INTO taxonomy VALUES(311,164328,'Phytophthora','ramorum');
INSERT INTO taxonomy VALUES(312,174576,'Phytophthora','pistaciae');
INSERT INTO taxonomy VALUES(313,2755056,'Phytophthora','aysenensis');
INSERT INTO taxonomy VALUES(314,1692154,'Phytophthora','chlamydospora');
INSERT INTO taxonomy VALUES(315,1286650,'Phytophthora','x pelgrandis');
INSERT INTO taxonomy VALUES(316,137729,'Phytophthora','tropicalis');
INSERT INTO taxonomy VALUES(317,1477121,'Phytophthora','virginiana');
INSERT INTO taxonomy VALUES(318,100870,'Phytophthora','litchii');
INSERT INTO taxonomy VALUES(319,1034759,'Phytophthora','cf. arenaria');
INSERT INTO taxonomy VALUES(320,911891,'Phytophthora','capensis');
INSERT INTO taxonomy VALUES(321,1821206,'Phytophthora','pseudocryptogea');
INSERT INTO taxonomy VALUES(322,2691624,'Phytophthora','citricola IX');
INSERT INTO taxonomy VALUES(323,2691625,'Phytophthora','citricola VII');
INSERT INTO taxonomy VALUES(324,2691626,'Phytophthora','citricola VIII');
INSERT INTO taxonomy VALUES(325,2691627,'Phytophthora','citricola X');
INSERT INTO taxonomy VALUES(326,2691628,'Phytophthora','citricola XI');
INSERT INTO taxonomy VALUES(327,1196597,'Phytophthora','amnicola');
INSERT INTO taxonomy VALUES(328,295481,'Phytophthora','hedraiandra');
INSERT INTO taxonomy VALUES(329,631358,'Phytophthora','asparagi');
INSERT INTO taxonomy VALUES(330,631361,'Phytophthora','austrocedri');
INSERT INTO taxonomy VALUES(331,111171,'Phytophthora','erythroseptica');
INSERT INTO taxonomy VALUES(332,2077275,'Phytophthora','pseudolactucae');
INSERT INTO taxonomy VALUES(333,2077276,'Phytophthora','lilii');
INSERT INTO taxonomy VALUES(334,109152,'Phytophthora','boehmeriae');
INSERT INTO taxonomy VALUES(335,1190534,'Phytophthora','lacustris');
INSERT INTO taxonomy VALUES(336,631433,'Phytophthora','cf. botryosa');
INSERT INTO taxonomy VALUES(337,1049225,'Phytophthora','aff. asparagi');
INSERT INTO taxonomy VALUES(338,1985165,'Phytophthora','castanetorum');
INSERT INTO taxonomy VALUES(339,1985166,'Phytophthora','tubulina');
INSERT INTO taxonomy VALUES(340,1985167,'Phytophthora','tyrrhenica');
INSERT INTO taxonomy VALUES(341,1985168,'Phytophthora','vulcanica');
INSERT INTO taxonomy VALUES(342,180900,'Phytophthora','europaea');
INSERT INTO taxonomy VALUES(343,180901,'Phytophthora','psychrophila');
INSERT INTO taxonomy VALUES(344,180902,'Phytophthora','uliginosa');
INSERT INTO taxonomy VALUES(345,4784,'Phytophthora','capsici');
INSERT INTO taxonomy VALUES(346,4785,'Phytophthora','cinnamomi');
INSERT INTO taxonomy VALUES(347,4786,'Phytophthora','cryptogea');
INSERT INTO taxonomy VALUES(348,4787,'Phytophthora','infestans');
INSERT INTO taxonomy VALUES(349,4788,'Phytophthora','megasperma');
INSERT INTO taxonomy VALUES(350,4790,'Phytophthora','nicotianae');
INSERT INTO taxonomy VALUES(351,4792,'Phytophthora','parasitica');
INSERT INTO taxonomy VALUES(352,4793,'Phytophthora','citrophthora');
INSERT INTO taxonomy VALUES(353,4794,'Phytophthora','drechsleri');
INSERT INTO taxonomy VALUES(354,4795,'Phytophthora','megakarya');
INSERT INTO taxonomy VALUES(355,4796,'Phytophthora','palmivora');
INSERT INTO taxonomy VALUES(356,2056922,'Phytophthora','x cambivora');
INSERT INTO taxonomy VALUES(357,53983,'Phytophthora','cambivora');
INSERT INTO taxonomy VALUES(358,53984,'Phytophthora','citricola');
INSERT INTO taxonomy VALUES(359,53985,'Phytophthora','fragariae');
INSERT INTO taxonomy VALUES(360,53986,'Phytophthora','idaei');
INSERT INTO taxonomy VALUES(361,53987,'Phytophthora','pseudotsugae');
INSERT INTO taxonomy VALUES(362,2691818,'Phytophthora','cf. attenuata 2');
INSERT INTO taxonomy VALUES(363,2691820,'Phytophthora','cf. attenuata 1');
INSERT INTO taxonomy VALUES(364,2691823,'Phytophthora','cf. virginiana');
INSERT INTO taxonomy VALUES(365,2691824,'Phytophthora','cf. Grenada 3');
INSERT INTO taxonomy VALUES(366,2691825,'Phytophthora','cf. attenuata 3');
INSERT INTO taxonomy VALUES(367,2691827,'Phytophthora','cf. meadii 2');
INSERT INTO taxonomy VALUES(368,2691828,'Phytophthora','cf. meadii 1');
INSERT INTO taxonomy VALUES(369,2691829,'Phytophthora','cf. tropicalis 2');
INSERT INTO taxonomy VALUES(370,1737462,'Phytophthora','urerae');
INSERT INTO taxonomy VALUES(371,2691830,'Phytophthora','cf. quininea');
INSERT INTO taxonomy VALUES(372,2691831,'Phytophthora','cf. gallica 2');
INSERT INTO taxonomy VALUES(373,2691832,'Phytophthora','cf. gallica 1');
INSERT INTO taxonomy VALUES(374,1913598,'Phytophthora','formosa');
INSERT INTO taxonomy VALUES(375,1567491,'Phytophthora','x serendipita');
INSERT INTO taxonomy VALUES(376,1131323,'Phytophthora','pisi');
INSERT INTO taxonomy VALUES(377,1880901,'Phytophthora','bishii');
INSERT INTO taxonomy VALUES(378,977741,'Phytophthora','litoralis');
INSERT INTO taxonomy VALUES(379,1241941,'Phytophthora','acerina');
INSERT INTO taxonomy VALUES(380,2675548,'Phytophthora','caryae');
INSERT INTO taxonomy VALUES(381,2759522,'Phytophthora','personensis');
INSERT INTO taxonomy VALUES(382,1747825,'Phytophthora','intercalaris');
INSERT INTO taxonomy VALUES(383,1833877,'Phytophthora','versiformis');
INSERT INTO taxonomy VALUES(384,2065305,'Phytophthora','humicola x inundata');
INSERT INTO taxonomy VALUES(385,2065306,'Phytophthora','cf. megasperma');
INSERT INTO taxonomy VALUES(386,2065307,'Phytophthora','cf. parsiana');
INSERT INTO taxonomy VALUES(387,359324,'Phytophthora','gallica');
INSERT INTO taxonomy VALUES(388,1582016,'Phytophthora','cf. lacustris NJG-2014');
INSERT INTO taxonomy VALUES(389,1862603,'Phytophthora','rhizophorae');
INSERT INTO taxonomy VALUES(390,1862604,'Phytophthora','estuarina');
INSERT INTO taxonomy VALUES(391,445396,'Phytophthora','cuyabensis');
INSERT INTO taxonomy VALUES(392,445398,'Phytophthora','sulawesiensis');
INSERT INTO taxonomy VALUES(393,2714593,'Phytophthora','betacei');
INSERT INTO taxonomy VALUES(394,1577959,'Phytophthora','moyootj');
INSERT INTO taxonomy VALUES(395,2792423,'Phytophthora','mekongensis');
INSERT INTO taxonomy VALUES(396,2792424,'Phytophthora','prodigiosa');
INSERT INTO taxonomy VALUES(397,2153462,'Phytophthora','cf. citricola/pini');
INSERT INTO taxonomy VALUES(398,2153463,'Phytophthora','cf. niederhauseri');
INSERT INTO taxonomy VALUES(399,977911,'Phytophthora','citricola E');
INSERT INTO taxonomy VALUES(400,1049592,'Phytophthora','fluvialis');
INSERT INTO taxonomy VALUES(401,658425,'Phytophthora','pini');
INSERT INTO taxonomy VALUES(402,658426,'Phytophthora','mengei');
INSERT INTO taxonomy VALUES(403,2692152,'Phytophthora','cf. multivesiculata 1');
INSERT INTO taxonomy VALUES(404,459882,'Phytophthora','mexicana');
INSERT INTO taxonomy VALUES(405,459883,'Phytophthora','quercetorum');
INSERT INTO taxonomy VALUES(406,2651252,'Phytophthora','aff. megasperma');
INSERT INTO taxonomy VALUES(407,2651253,'Phytophthora','niederhauseri');
INSERT INTO taxonomy VALUES(408,2651254,'Phytophthora','aff. niederhauseri');
INSERT INTO taxonomy VALUES(409,2651256,'Phytophthora','pseudocryptogea x sp kelmania');
INSERT INTO taxonomy VALUES(410,2651258,'Phytophthora','aff. pseudocryptogea');
INSERT INTO taxonomy VALUES(411,2651262,'Phytophthora','aff. attenuata');
INSERT INTO taxonomy VALUES(412,2651263,'Phytophthora','aff. cambivora');
INSERT INTO taxonomy VALUES(413,2651268,'Phytophthora','aff. heterohybrida');
INSERT INTO taxonomy VALUES(414,2651269,'Phytophthora','niederhauseri x aff. asparagi');
INSERT INTO taxonomy VALUES(415,2651270,'Phytophthora','occultans x aff. citrophthora');
INSERT INTO taxonomy VALUES(416,324745,'Phytophthora','medicaginis x cryptogea');
INSERT INTO taxonomy VALUES(417,1385620,'Phytophthora','occultans');
INSERT INTO taxonomy VALUES(418,1385621,'Phytophthora','terminalis');
INSERT INTO taxonomy VALUES(419,2651289,'Phytophthora','amnicola x chlamydospora');
INSERT INTO taxonomy VALUES(420,2651290,'Phytophthora','aff. boehmeriae');
INSERT INTO taxonomy VALUES(421,2651291,'Phytophthora','chlamydospora x lacustris');
INSERT INTO taxonomy VALUES(422,2651292,'Phytophthora','cactorum x aff. hedraiandra');
INSERT INTO taxonomy VALUES(423,1330343,'Phytophthora','pluvialis');
INSERT INTO taxonomy VALUES(424,2675888,'Phytophthora','pseudopolonica');
INSERT INTO taxonomy VALUES(425,175300,'Phytophthora','hibernalis');
INSERT INTO taxonomy VALUES(426,120023,'Phytophthora','melonis');
INSERT INTO taxonomy VALUES(427,29920,'Phytophthora','cactorum');
INSERT INTO taxonomy VALUES(428,1529059,'Phytophthora','asiatica');
INSERT INTO taxonomy VALUES(429,54510,'Phytophthora','medicaginis');
INSERT INTO taxonomy VALUES(430,54511,'Phytophthora','trifolii');
INSERT INTO taxonomy VALUES(431,89334,'Phytophthora','clandestina');
INSERT INTO taxonomy VALUES(432,89335,'Phytophthora','ilicis');
INSERT INTO taxonomy VALUES(433,1320215,'Phytophthora','cichorii');
INSERT INTO taxonomy VALUES(434,1320216,'Phytophthora','dauci');
INSERT INTO taxonomy VALUES(435,1320217,'Phytophthora','lactucae');
INSERT INTO taxonomy VALUES(436,134455,'Phytophthora','quininea');
INSERT INTO taxonomy VALUES(437,134457,'Phytophthora','cf. cryptogea/drechsleri');
INSERT INTO taxonomy VALUES(438,1334606,'Phytophthora','cf. rosacearum PB-2013');
INSERT INTO taxonomy VALUES(439,2575701,'Phytophthora','chlamydospora x amnicola');
INSERT INTO taxonomy VALUES(440,376151,'Phytophthora','cactorum x hedraiandra');
INSERT INTO taxonomy VALUES(441,1273180,'Phytophthora','cyperi');
INSERT INTO taxonomy VALUES(442,376158,'Phytophthora','nicotianae x cactorum');
INSERT INTO taxonomy VALUES(443,540036,'Phytophthora','parvispora');
INSERT INTO taxonomy VALUES(444,707995,'Phytophthora','alticola');
INSERT INTO taxonomy VALUES(445,707996,'Phytophthora','himalayensis');
INSERT INTO taxonomy VALUES(446,374175,'Phytophthora','polonica');
INSERT INTO taxonomy VALUES(447,187813,'Phytophthora','brassicae');
INSERT INTO taxonomy VALUES(448,611798,'Phytophthora','aquimorbida');
INSERT INTO taxonomy VALUES(449,2579937,'Phytophthora','cf. citricola');
INSERT INTO taxonomy VALUES(450,2606568,'Phytophthora','cathayensis');
INSERT INTO taxonomy VALUES(451,572926,'Phytophthora','citricola I');
INSERT INTO taxonomy VALUES(452,572927,'Phytophthora','citricola II');
INSERT INTO taxonomy VALUES(453,572928,'Phytophthora','citricola III');
INSERT INTO taxonomy VALUES(454,572929,'Phytophthora','citricola IV');
INSERT INTO taxonomy VALUES(455,132615,'Phytophthora','glovera');
INSERT INTO taxonomy VALUES(456,1486344,'Phytophthora','amaranthi');
INSERT INTO taxonomy VALUES(457,1490495,'Phytophthora','fragariaefolia');
INSERT INTO taxonomy VALUES(458,2496075,'Phytophthora','aleatoria');
INSERT INTO taxonomy VALUES(459,187986,'Phytophthora','bisheria');
INSERT INTO taxonomy VALUES(460,581215,'Phytophthora','morindae');
INSERT INTO taxonomy VALUES(461,1197709,'Phytophthora','cf. gregata');
INSERT INTO taxonomy VALUES(462,1197710,'Phytophthora','bilorbang');
INSERT INTO taxonomy VALUES(463,1396423,'Phytophthora','mississippiae');
INSERT INTO taxonomy VALUES(464,1857252,'Phytophthora','chesapeakensis');
INSERT INTO taxonomy VALUES(465,1185511,'Phytophthora','riparia');
INSERT INTO taxonomy VALUES(466,1185512,'Phytophthora','borealis');
INSERT INTO taxonomy VALUES(467,1283836,'Phytophthora','cactorum/hedraiandra SP-2013');
INSERT INTO taxonomy VALUES(468,1464076,'Phytophthora','aff. cactorum FNM-2014');
INSERT INTO taxonomy VALUES(469,880411,'Phytophthora','gibbosa');
INSERT INTO taxonomy VALUES(470,880412,'Phytophthora','gregata');
INSERT INTO taxonomy VALUES(471,929565,'Phytophthora','constricta');
INSERT INTO taxonomy VALUES(472,880414,'Phytophthora','thermophila');
INSERT INTO taxonomy VALUES(473,2488101,'Phytophthora','abietivora');
INSERT INTO taxonomy VALUES(474,929574,'Phytophthora','arenaria');
INSERT INTO taxonomy VALUES(475,2801445,'Phytophthora','aquae-cooljarloo');
INSERT INTO taxonomy VALUES(476,669489,'Phytophthora','frigida');
INSERT INTO taxonomy VALUES(477,1214257,'Phytophthora','aff. arenaria');
INSERT INTO taxonomy VALUES(478,1214258,'Phytophthora','aff. humicola');
INSERT INTO taxonomy VALUES(479,2305843,'Phytophthora','oreophila');
INSERT INTO taxonomy VALUES(480,2305844,'Phytophthora','cacuminis');
INSERT INTO taxonomy VALUES(481,1771325,'Phytophthora','cf. inundata D0S1P25');
INSERT INTO taxonomy VALUES(482,565057,'Phytophthora','gemini');
INSERT INTO taxonomy VALUES(483,2023236,'Phytophthora','aff. citricola');
INSERT INTO taxonomy VALUES(484,325452,'Phytophthora','kernoviae');
INSERT INTO taxonomy VALUES(485,2107226,'Phytophthora','oleae');
INSERT INTO taxonomy VALUES(486,905063,'Phytophthora','elongata');
INSERT INTO taxonomy VALUES(487,905064,'Phytophthora','cf. elongata');
INSERT INTO taxonomy VALUES(488,2017134,'Phytophthora','aff. capsici');
INSERT INTO taxonomy VALUES(489,436079,'Phytophthora','siskiyouensis');
INSERT INTO taxonomy VALUES(490,2017135,'Phytophthora','aff. cichorii');
INSERT INTO taxonomy VALUES(491,2017136,'Phytophthora','aff. citrophthora');
INSERT INTO taxonomy VALUES(492,2017137,'Phytophthora','aff. cryptogea');
INSERT INTO taxonomy VALUES(493,2017138,'Phytophthora','aff. dauci');
INSERT INTO taxonomy VALUES(494,2017139,'Phytophthora','aff. erythroseptica');
INSERT INTO taxonomy VALUES(495,2017140,'Phytophthora','aff. hedraiandra');
INSERT INTO taxonomy VALUES(496,2017141,'Phytophthora','aff. himalsilva');
INSERT INTO taxonomy VALUES(497,2017142,'Phytophthora','aff. parsiana');
INSERT INTO taxonomy VALUES(498,2017143,'Phytophthora','aff. pseudotsugae');
INSERT INTO taxonomy VALUES(499,2017144,'Phytophthora','gondwanensis');
INSERT INTO taxonomy VALUES(500,1785729,'Phytophthora','boodjera');
INSERT INTO taxonomy VALUES(501,2742166,'Phytophthora','acaciivora');
INSERT INTO taxonomy VALUES(502,2054050,'Phytophthora','balyanboodja');
INSERT INTO taxonomy VALUES(503,2054051,'Phytophthora','condilina');
INSERT INTO taxonomy VALUES(504,2054052,'Phytophthora','cooljarloo');
INSERT INTO taxonomy VALUES(505,2054053,'Phytophthora','kwongonina');
INSERT INTO taxonomy VALUES(506,2054054,'Phytophthora','pseudorosacearum');
INSERT INTO taxonomy VALUES(507,538568,'Phytophthora','pinifolia');
INSERT INTO taxonomy VALUES(508,360399,'Phytophthora','fallax');
INSERT INTO taxonomy VALUES(509,360400,'Phytophthora','captiosa');
INSERT INTO taxonomy VALUES(510,1525714,'Phytophthora','nagaii');
INSERT INTO taxonomy VALUES(511,1499098,'Phytophthora','lacustris x riparia');
INSERT INTO taxonomy VALUES(512,1642459,'Phytophthora','agathidicida');
INSERT INTO taxonomy VALUES(513,1642464,'Phytophthora','cocois');
INSERT INTO taxonomy VALUES(514,1642465,'Phytophthora','castaneae');
INSERT INTO taxonomy VALUES(515,638948,'Phytophthora','chrysanthemi');
INSERT INTO taxonomy VALUES(516,1216510,'Phytophthora','thermophila x amnicola');
INSERT INTO taxonomy VALUES(517,82945,'Pythium','periilum');
INSERT INTO taxonomy VALUES(518,82946,'Pythium','periplocum');
INSERT INTO taxonomy VALUES(519,82947,'Pythium','rostratum');
INSERT INTO taxonomy VALUES(520,82938,'Pythium','inflatum');
INSERT INTO taxonomy VALUES(521,82949,'Pythium','sulcatum');
INSERT INTO taxonomy VALUES(522,82951,'Pythium','vanterpoolii');
INSERT INTO taxonomy VALUES(523,1201160,'Pythium','breve');
INSERT INTO taxonomy VALUES(524,82953,'Pythium','volutum');
INSERT INTO taxonomy VALUES(525,1201161,'Pythium','baisense');
INSERT INTO taxonomy VALUES(526,104971,'Pythium','prolatum');
INSERT INTO taxonomy VALUES(527,1903600,'Pythium','ershadii');
INSERT INTO taxonomy VALUES(528,1903601,'Pythium','pyrioosporum');
INSERT INTO taxonomy VALUES(529,658966,'Pythium','guangxiense');
INSERT INTO taxonomy VALUES(530,166937,'Pythium','longandrum');
INSERT INTO taxonomy VALUES(531,166938,'Pythium','terrestris');
INSERT INTO taxonomy VALUES(532,1903602,'Pythium','urmianum');
INSERT INTO taxonomy VALUES(533,1632285,'Pythium','burgundicum');
INSERT INTO taxonomy VALUES(534,2108448,'Pythium','cf. salpingophorum/conidiophorum');
INSERT INTO taxonomy VALUES(535,65069,'Pythium','acanthicum');
INSERT INTO taxonomy VALUES(536,65070,'Pythium','aphanidermatum');
INSERT INTO taxonomy VALUES(537,114742,'Pythium','insidiosum');
INSERT INTO taxonomy VALUES(538,610363,'Pythium','echinogynum');
INSERT INTO taxonomy VALUES(539,610364,'Pythium','stipitatum');
INSERT INTO taxonomy VALUES(540,319040,'Pythium','phragmitis');
INSERT INTO taxonomy VALUES(541,216130,'Pythium','destruens');
INSERT INTO taxonomy VALUES(542,475204,'Pythium','aff. phragmitis');
INSERT INTO taxonomy VALUES(543,643143,'Pythium','senticosum');
INSERT INTO taxonomy VALUES(544,643144,'Pythium','takayamanum');
INSERT INTO taxonomy VALUES(545,1938515,'Pythium','heteroogonium');
INSERT INTO taxonomy VALUES(546,41045,'Pythium','oligandrum');
INSERT INTO taxonomy VALUES(547,1938517,'Pythium','longipapillum');
INSERT INTO taxonomy VALUES(548,1938518,'Pythium','oryzicollum');
INSERT INTO taxonomy VALUES(549,1882210,'Pythium','cedri');
INSERT INTO taxonomy VALUES(550,410723,'Pythium','quercum');
INSERT INTO taxonomy VALUES(551,299625,'Pythium','rhizo-oryzae');
INSERT INTO taxonomy VALUES(552,1771327,'Pythium','cf. periplocum 4SE010');
INSERT INTO taxonomy VALUES(553,1771328,'Pythium','cf. porphyrae D0S3P02');
INSERT INTO taxonomy VALUES(554,1448060,'Pythium','salinum');
INSERT INTO taxonomy VALUES(555,1525374,'Pythium','cf. amazonianum C022');
INSERT INTO taxonomy VALUES(556,1525375,'Pythium','cf. amazonianum C024');
INSERT INTO taxonomy VALUES(557,1525376,'Pythium','cf. vexans C061');
INSERT INTO taxonomy VALUES(558,349325,'Pythium','apiculatum');
INSERT INTO taxonomy VALUES(559,369823,'Pythium','sterilum');
INSERT INTO taxonomy VALUES(560,1588901,'Pythium','utonaiense');
INSERT INTO taxonomy VALUES(561,1588902,'Pythium','brachiatum');
INSERT INTO taxonomy VALUES(562,1588903,'Pythium','biforme');
INSERT INTO taxonomy VALUES(563,1588904,'Pythium','junctum');
INSERT INTO taxonomy VALUES(564,1450477,'Pythium','cederbergense');
INSERT INTO taxonomy VALUES(565,4798,'Pythium','hydnosporum');
INSERT INTO taxonomy VALUES(566,4799,'Pythium','torulosum');
INSERT INTO taxonomy VALUES(567,255166,'Pythium','viniferum');
INSERT INTO taxonomy VALUES(568,172234,'Pythium','grandisporangium');
INSERT INTO taxonomy VALUES(569,946380,'Pythium','aff. iwayamai');
INSERT INTO taxonomy VALUES(570,1277646,'Pythium','schmitthenneri');
INSERT INTO taxonomy VALUES(571,1277647,'Pythium','selbyi');
INSERT INTO taxonomy VALUES(572,1278159,'Pythium','caudatum');
INSERT INTO taxonomy VALUES(573,1485010,'Pythium','brassicum');
INSERT INTO taxonomy VALUES(574,2175193,'Pythium','aff. pachycaule');
INSERT INTO taxonomy VALUES(575,2056924,'Pythium','rishiriense');
INSERT INTO taxonomy VALUES(576,2056925,'Pythium','alternatum');
INSERT INTO taxonomy VALUES(577,2691826,'Pythium','cf. conidiophorum');
INSERT INTO taxonomy VALUES(578,2506486,'Pythium','subutonaiense');
INSERT INTO taxonomy VALUES(579,147703,'Pythium','jasmonium');
INSERT INTO taxonomy VALUES(580,147706,'Pythium','uncinulatum');
INSERT INTO taxonomy VALUES(581,2603265,'Pythium','aff. attrantheridum');
INSERT INTO taxonomy VALUES(582,88834,'Pythium','porphyrae');
INSERT INTO taxonomy VALUES(583,2603266,'Pythium','aff. cederbergense');
INSERT INTO taxonomy VALUES(584,2603267,'Pythium','aff. rostratum');
INSERT INTO taxonomy VALUES(585,2603268,'Pythium','aff. undulatum');
INSERT INTO taxonomy VALUES(586,140044,'Pythium','aristosporum');
INSERT INTO taxonomy VALUES(587,140045,'Pythium','butleri');
INSERT INTO taxonomy VALUES(588,140047,'Pythium','salpingophorum');
INSERT INTO taxonomy VALUES(589,140048,'Pythium','tracheiphilum');
INSERT INTO taxonomy VALUES(590,1792277,'Pythium','yorkensis');
INSERT INTO taxonomy VALUES(591,1792278,'Pythium','aff. intermedium JEB-2016');
INSERT INTO taxonomy VALUES(592,1792279,'Pythium','aff. undulatum JEB-2016');
INSERT INTO taxonomy VALUES(593,92964,'Pythium','monospermum');
INSERT INTO taxonomy VALUES(594,49446,'Pythium','pachycaule');
INSERT INTO taxonomy VALUES(595,162088,'Pythium','aff. vanterpoolii');
INSERT INTO taxonomy VALUES(596,290088,'Pythium','minus');
INSERT INTO taxonomy VALUES(597,1027885,'Pythium','aff. canariense OW1707');
INSERT INTO taxonomy VALUES(598,944634,'Pythium','kashmirense');
INSERT INTO taxonomy VALUES(599,135483,'Pythium','myophilum');
INSERT INTO taxonomy VALUES(600,289596,'Pythium','adhaerens');
INSERT INTO taxonomy VALUES(601,289597,'Pythium','chondricola');
INSERT INTO taxonomy VALUES(602,289598,'Pythium','angustatum');
INSERT INTO taxonomy VALUES(603,289599,'Pythium','conidiophorum');
INSERT INTO taxonomy VALUES(604,289600,'Pythium','apleroticum');
INSERT INTO taxonomy VALUES(605,289601,'Pythium','capillosum');
INSERT INTO taxonomy VALUES(606,289602,'Pythium','pyrilobum');
INSERT INTO taxonomy VALUES(607,944637,'Pythium','sukuiense');
INSERT INTO taxonomy VALUES(608,657220,'Pythium','emineosum');
INSERT INTO taxonomy VALUES(609,1771326,'Pythium','cf. deliense D2.5S2P21-2');
INSERT INTO taxonomy VALUES(610,289606,'Pythium','anandrum');
INSERT INTO taxonomy VALUES(611,289607,'Pythium','helicandrum');
INSERT INTO taxonomy VALUES(612,657222,'Pythium','camurandrum');
INSERT INTO taxonomy VALUES(613,596297,'Pythium','oopapillum');
INSERT INTO taxonomy VALUES(614,289609,'Pythium','cucurbitacearum');
INSERT INTO taxonomy VALUES(615,1489738,'Pythium','polare');
INSERT INTO taxonomy VALUES(616,289612,'Pythium','amasculinum');
INSERT INTO taxonomy VALUES(617,289613,'Pythium','folliculosum');
INSERT INTO taxonomy VALUES(618,289614,'Pythium','zingiberis');
INSERT INTO taxonomy VALUES(619,289615,'Pythium','scleroteichum');
INSERT INTO taxonomy VALUES(620,289616,'Pythium','dissimile');
INSERT INTO taxonomy VALUES(621,289617,'Pythium','plurisporium');
INSERT INTO taxonomy VALUES(622,289618,'Pythium','lutarium');
INSERT INTO taxonomy VALUES(623,289619,'Pythium','marinum');
INSERT INTO taxonomy VALUES(624,289620,'Pythium','flevoense');
INSERT INTO taxonomy VALUES(625,289626,'Pythium','indigoferae');
INSERT INTO taxonomy VALUES(626,1391457,'Pythium','phragmiticola');
INSERT INTO taxonomy VALUES(627,110438,'Pythium','contiguanum');
INSERT INTO taxonomy VALUES(628,182683,'Pythium','okanoganense');
INSERT INTO taxonomy VALUES(629,181666,'Pythium','macrosporum');
INSERT INTO taxonomy VALUES(630,490914,'Pythium','ornamentatum');
INSERT INTO taxonomy VALUES(631,1629122,'Pythium','barbulae');
INSERT INTO taxonomy VALUES(632,1632203,'Pythium','kandovanense');
INSERT INTO taxonomy VALUES(633,83917,'Pythium','catenulatum');
INSERT INTO taxonomy VALUES(634,141266,'Pythium','dimorphum');
INSERT INTO taxonomy VALUES(635,156628,'Pythium','diclinum');
INSERT INTO taxonomy VALUES(636,156629,'Pythium','pectinolyticum');
INSERT INTO taxonomy VALUES(637,112097,'Pythium','aquatile');
INSERT INTO taxonomy VALUES(638,944611,'Pythium','afertile');
INSERT INTO taxonomy VALUES(639,1077222,'Pythium','aff. monospermum');
INSERT INTO taxonomy VALUES(640,1077223,'Pythium','aff. heterothallicum');
INSERT INTO taxonomy VALUES(641,1077224,'Pythium','aff. macrosporum');
INSERT INTO taxonomy VALUES(642,1077225,'Pythium','aff. canariense');
INSERT INTO taxonomy VALUES(643,944618,'Pythium','aff. diclinum');
INSERT INTO taxonomy VALUES(644,944619,'Pythium','aff. dictyosporum');
INSERT INTO taxonomy VALUES(645,944620,'Pythium','aff. dissotocum');
INSERT INTO taxonomy VALUES(646,944621,'Pythium','aff. hydnosporum');
INSERT INTO taxonomy VALUES(647,944622,'Pythium','aff. hypogynum');
INSERT INTO taxonomy VALUES(648,944623,'Pythium','aff. periilum');
INSERT INTO taxonomy VALUES(649,944624,'Pythium','aff. perplexum');
INSERT INTO taxonomy VALUES(650,944625,'Pythium','aff. pleroticum');
INSERT INTO taxonomy VALUES(651,944626,'Pythium','aff. polymastum');
INSERT INTO taxonomy VALUES(652,944627,'Pythium','aff. torulosum');
INSERT INTO taxonomy VALUES(653,82932,'Pythium','arrhenomanes');
INSERT INTO taxonomy VALUES(654,944628,'Pythium','aff. volutum');
INSERT INTO taxonomy VALUES(655,82934,'Pythium','coloratum');
INSERT INTO taxonomy VALUES(656,82935,'Pythium','deliense');
INSERT INTO taxonomy VALUES(657,82936,'Pythium','dissotocum');
INSERT INTO taxonomy VALUES(658,82937,'Pythium','graminicola');
INSERT INTO taxonomy VALUES(659,429562,'Pythium','guiyangense');
INSERT INTO taxonomy VALUES(660,944629,'Pythium','cf. dictyosporum');
INSERT INTO taxonomy VALUES(661,944636,'Pythium','lycopersicum');
INSERT INTO taxonomy VALUES(662,82941,'Pythium','myriotylum');
INSERT INTO taxonomy VALUES(663,944638,'Pythium','tardicrescens');
INSERT INTO taxonomy VALUES(664,1243776,'Lagenidium','albertoi');
INSERT INTO taxonomy VALUES(665,1884448,'Lagenidium','juracyae');
INSERT INTO taxonomy VALUES(666,4803,'Lagenidium','giganteum');
INSERT INTO taxonomy VALUES(667,884619,'Lagenidium','deciduum');
INSERT INTO taxonomy VALUES(668,1441741,'Lagenidium','aff. deciduum LEV5864');
INSERT INTO taxonomy VALUES(669,1470262,'Lagenidium','ajelloi');
INSERT INTO taxonomy VALUES(670,135481,'Lagenidium','caudatum');
INSERT INTO taxonomy VALUES(671,135482,'Lagenidium','humanum');
INSERT INTO taxonomy VALUES(672,323840,'Albugo','chardoni');
INSERT INTO taxonomy VALUES(673,2306945,'Albugo','arenosa');
INSERT INTO taxonomy VALUES(674,323849,'Albugo','trianthemae');
INSERT INTO taxonomy VALUES(675,468623,'Albugo','lepidii');
INSERT INTO taxonomy VALUES(676,468624,'Albugo','capparis');
INSERT INTO taxonomy VALUES(677,934033,'Albugo','rorippae');
INSERT INTO taxonomy VALUES(678,2780433,'Albugo','koreana');
INSERT INTO taxonomy VALUES(679,226325,'Albugo','occidentalis');
INSERT INTO taxonomy VALUES(680,2203415,'Albugo','tropica');
INSERT INTO taxonomy VALUES(681,1631665,'Albugo','lepigoni');
INSERT INTO taxonomy VALUES(682,330677,'Albugo','evolvuli');
INSERT INTO taxonomy VALUES(683,295094,'Albugo','ipomoeae-panduratae');
INSERT INTO taxonomy VALUES(684,330679,'Albugo','gomphrenae');
INSERT INTO taxonomy VALUES(685,330678,'Albugo','caryophyllacearum');
INSERT INTO taxonomy VALUES(686,2770500,'Albugo','cruciferarum');
INSERT INTO taxonomy VALUES(687,682055,'Albugo','mauginii');
INSERT INTO taxonomy VALUES(688,864584,'Albugo','resedae');
INSERT INTO taxonomy VALUES(689,65357,'Albugo','candida');
INSERT INTO taxonomy VALUES(690,913886,'Albugo','leimonios s.l.');
INSERT INTO taxonomy VALUES(691,643578,'Albugo','capparidis');
INSERT INTO taxonomy VALUES(692,653948,'Albugo','laibachii');
INSERT INTO taxonomy VALUES(693,913021,'Albugo','leimonios');
INSERT INTO taxonomy VALUES(694,913022,'Albugo','hesleri');
INSERT INTO taxonomy VALUES(695,913023,'Albugo','hohenheimia');
INSERT INTO taxonomy VALUES(696,337960,'Peronospora','narbonensis');
INSERT INTO taxonomy VALUES(697,1234955,'Peronospora','jagei');
INSERT INTO taxonomy VALUES(698,2603534,'Peronospora','salviae-officinalis');
INSERT INTO taxonomy VALUES(699,337961,'Peronospora','sepium');
INSERT INTO taxonomy VALUES(700,230421,'Peronospora','asperuginis');
INSERT INTO taxonomy VALUES(701,230422,'Peronospora','lotorum');
INSERT INTO taxonomy VALUES(702,230423,'Peronospora','ranunculi');
INSERT INTO taxonomy VALUES(703,230424,'Peronospora','illyrica');
INSERT INTO taxonomy VALUES(704,230425,'Peronospora','aff. ranunculi');
INSERT INTO taxonomy VALUES(705,230426,'Peronospora','alpicola');
INSERT INTO taxonomy VALUES(706,230427,'Peronospora','dicentrae');
INSERT INTO taxonomy VALUES(707,230428,'Peronospora','chrysosplenii');
INSERT INTO taxonomy VALUES(708,230429,'Peronospora','esulae');
INSERT INTO taxonomy VALUES(709,230430,'Peronospora','paula');
INSERT INTO taxonomy VALUES(710,230431,'Peronospora','parva');
INSERT INTO taxonomy VALUES(711,230432,'Peronospora','arenariae');
INSERT INTO taxonomy VALUES(712,230433,'Peronospora','claytoniae');
INSERT INTO taxonomy VALUES(713,230434,'Peronospora','polygoni');
INSERT INTO taxonomy VALUES(714,230435,'Peronospora','holostei');
INSERT INTO taxonomy VALUES(715,230436,'Peronospora','arthurii');
INSERT INTO taxonomy VALUES(716,1869342,'Peronospora','mesembryanthemi');
INSERT INTO taxonomy VALUES(717,230438,'Peronospora','obovata');
INSERT INTO taxonomy VALUES(718,230439,'Peronospora','tabacina');
INSERT INTO taxonomy VALUES(719,230440,'Peronospora','kochiae-scopariae');
INSERT INTO taxonomy VALUES(720,230441,'Peronospora','chenopodii-polyspermi');
INSERT INTO taxonomy VALUES(721,134698,'Peronospora','farinosa');
INSERT INTO taxonomy VALUES(722,230442,'Peronospora','valerianellae');
INSERT INTO taxonomy VALUES(723,230443,'Peronospora','tranzscheliana');
INSERT INTO taxonomy VALUES(724,230445,'Peronospora','radii');
INSERT INTO taxonomy VALUES(725,230446,'Peronospora','silvatica');
INSERT INTO taxonomy VALUES(726,230447,'Peronospora','sherardiae');
INSERT INTO taxonomy VALUES(727,230448,'Peronospora','knautiae');
INSERT INTO taxonomy VALUES(728,230444,'Peronospora','stigmaticola');
INSERT INTO taxonomy VALUES(729,230449,'Peronospora','alchemillae');
INSERT INTO taxonomy VALUES(730,2789430,'Peronospora','chenopodii-ficifolii');
INSERT INTO taxonomy VALUES(731,1484356,'Peronospora','valerianae');
INSERT INTO taxonomy VALUES(732,1632325,'Peronospora','litoralis');
INSERT INTO taxonomy VALUES(733,1484358,'Peronospora','honckenyae');
INSERT INTO taxonomy VALUES(734,1484359,'Peronospora','phacae');
INSERT INTO taxonomy VALUES(735,1484360,'Peronospora','potentillae-anserinae');
INSERT INTO taxonomy VALUES(736,1484361,'Peronospora','potentillae-reptantis');
INSERT INTO taxonomy VALUES(737,1484362,'Peronospora','rubi');
INSERT INTO taxonomy VALUES(738,1484363,'Peronospora','salviae-plebeiae');
INSERT INTO taxonomy VALUES(739,1484364,'Peronospora','saxifragae');
INSERT INTO taxonomy VALUES(740,1484365,'Peronospora','schachtii');
INSERT INTO taxonomy VALUES(741,1099854,'Peronospora','dianthicola');
INSERT INTO taxonomy VALUES(742,1484366,'Peronospora','stachydis');
INSERT INTO taxonomy VALUES(743,1484367,'Peronospora','symphyti');
INSERT INTO taxonomy VALUES(744,1484368,'Peronospora','scleranthi');
INSERT INTO taxonomy VALUES(745,1484369,'Peronospora','scutellariae');
INSERT INTO taxonomy VALUES(746,1484371,'Peronospora','teucrii');
INSERT INTO taxonomy VALUES(747,1484372,'Peronospora','tomentosa');
INSERT INTO taxonomy VALUES(748,1484373,'Peronospora','vernalis');
INSERT INTO taxonomy VALUES(749,1484374,'Peronospora','verbasci');
INSERT INTO taxonomy VALUES(750,70743,'Peronospora','sparsa');
INSERT INTO taxonomy VALUES(751,1484375,'Peronospora','debaryi');
INSERT INTO taxonomy VALUES(752,1484376,'Peronospora','dipsaci');
INSERT INTO taxonomy VALUES(753,1484377,'Peronospora','echii');
INSERT INTO taxonomy VALUES(754,1484378,'Peronospora','erodii');
INSERT INTO taxonomy VALUES(755,120412,'Peronospora','ficariae');
INSERT INTO taxonomy VALUES(756,1484379,'Peronospora','galii');
INSERT INTO taxonomy VALUES(757,1484380,'Peronospora','glechomae');
INSERT INTO taxonomy VALUES(758,1484381,'Peronospora','affinis');
INSERT INTO taxonomy VALUES(759,1484382,'Peronospora','antirrhini');
INSERT INTO taxonomy VALUES(760,1484383,'Peronospora','argemones');
INSERT INTO taxonomy VALUES(761,1484384,'Peronospora','cerastii-anomali');
INSERT INTO taxonomy VALUES(762,1484385,'Peronospora','cerastii-brachypetali');
INSERT INTO taxonomy VALUES(763,1484386,'Peronospora','consolidae');
INSERT INTO taxonomy VALUES(764,1484387,'Peronospora','corydalis-intermediae');
INSERT INTO taxonomy VALUES(765,1910894,'Peronospora','aconiti');
INSERT INTO taxonomy VALUES(766,542832,'Peronospora','effusa');
INSERT INTO taxonomy VALUES(767,1679947,'Peronospora','cf. fagopyri MK-2015');
INSERT INTO taxonomy VALUES(768,1484431,'Peronospora','cyparissiae');
INSERT INTO taxonomy VALUES(769,184466,'Peronospora','arborescens');
INSERT INTO taxonomy VALUES(770,1151129,'Peronospora','saturejae-hortensis');
INSERT INTO taxonomy VALUES(771,1945754,'Peronospora','cf. ducometii');
INSERT INTO taxonomy VALUES(772,1632326,'Peronospora','polycarpi');
INSERT INTO taxonomy VALUES(773,1632327,'Peronospora','atriplicis-hastatae');
INSERT INTO taxonomy VALUES(774,434349,'Peronospora','fulva');
INSERT INTO taxonomy VALUES(775,434350,'Peronospora','medicaginis-minimae');
INSERT INTO taxonomy VALUES(776,434351,'Peronospora','lathyri-verni');
INSERT INTO taxonomy VALUES(777,434352,'Peronospora','lathyrina');
INSERT INTO taxonomy VALUES(778,434353,'Peronospora','tetragonolobi');
INSERT INTO taxonomy VALUES(779,2057904,'Peronospora','pseudostellaria');
INSERT INTO taxonomy VALUES(780,434355,'Peronospora','medicaginis-orbicularis');
INSERT INTO taxonomy VALUES(781,434356,'Peronospora','ornithopi');
INSERT INTO taxonomy VALUES(782,2057905,'Peronospora','stellariae-aquaticae');
INSERT INTO taxonomy VALUES(783,1287862,'Peronospora','plantaginis');
INSERT INTO taxonomy VALUES(784,2057906,'Peronospora','stellariae-uliginosae');
INSERT INTO taxonomy VALUES(785,434360,'Peronospora','trifolii-arvensis');
INSERT INTO taxonomy VALUES(786,434361,'Peronospora','orobi');
INSERT INTO taxonomy VALUES(787,507576,'Peronospora','perillae');
INSERT INTO taxonomy VALUES(788,1484475,'Peronospora','lapponica');
INSERT INTO taxonomy VALUES(789,1484476,'Peronospora','lepigoni');
INSERT INTO taxonomy VALUES(790,1484477,'Peronospora','linariae');
INSERT INTO taxonomy VALUES(791,1484478,'Peronospora','linariae-genistifoliae');
INSERT INTO taxonomy VALUES(792,1761981,'Peronospora','chlorae');
INSERT INTO taxonomy VALUES(793,1484480,'Peronospora','lithospermi');
INSERT INTO taxonomy VALUES(794,1484481,'Peronospora','meconopsidis');
INSERT INTO taxonomy VALUES(795,1484482,'Peronospora','melandryi-noctiflori');
INSERT INTO taxonomy VALUES(796,1484483,'Peronospora','minor');
INSERT INTO taxonomy VALUES(797,1484484,'Peronospora','oblatispora');
INSERT INTO taxonomy VALUES(798,1484485,'Peronospora','polygoni-convolvuli');
INSERT INTO taxonomy VALUES(799,1762014,'Peronospora','statices');
INSERT INTO taxonomy VALUES(800,102135,'Peronospora','cristata');
INSERT INTO taxonomy VALUES(801,102136,'Peronospora','viciae');
INSERT INTO taxonomy VALUES(802,210167,'Peronospora','corydalis');
INSERT INTO taxonomy VALUES(803,120572,'Peronospora','bulbocapni');
INSERT INTO taxonomy VALUES(804,658183,'Peronospora','elsholtziae');
INSERT INTO taxonomy VALUES(805,749328,'Peronospora','verbenae');
INSERT INTO taxonomy VALUES(806,240414,'Peronospora','aquatica');
INSERT INTO taxonomy VALUES(807,240418,'Peronospora','verna');
INSERT INTO taxonomy VALUES(808,291619,'Peronospora','campestris');
INSERT INTO taxonomy VALUES(809,291620,'Peronospora','trigonotidis');
INSERT INTO taxonomy VALUES(810,162094,'Peronospora','hiemalis');
INSERT INTO taxonomy VALUES(811,162095,'Peronospora','pulveracea');
INSERT INTO taxonomy VALUES(812,162096,'Peronospora','trivialis');
INSERT INTO taxonomy VALUES(813,162097,'Peronospora','alsinearum');
INSERT INTO taxonomy VALUES(814,162098,'Peronospora','myosotidis');
INSERT INTO taxonomy VALUES(815,162099,'Peronospora','coronillae');
INSERT INTO taxonomy VALUES(816,162100,'Peronospora','boni-henrici');
INSERT INTO taxonomy VALUES(817,162101,'Peronospora','rumicis');
INSERT INTO taxonomy VALUES(818,162102,'Peronospora','variabilis');
INSERT INTO taxonomy VALUES(819,162103,'Peronospora','trifoliorum');
INSERT INTO taxonomy VALUES(820,162104,'Peronospora','trifolii-minoris');
INSERT INTO taxonomy VALUES(821,162105,'Peronospora','trifolii-hybridi');
INSERT INTO taxonomy VALUES(822,162106,'Peronospora','trifolii-alpestris');
INSERT INTO taxonomy VALUES(823,162107,'Peronospora','aestivalis');
INSERT INTO taxonomy VALUES(824,162108,'Peronospora','calotheca');
INSERT INTO taxonomy VALUES(825,162109,'Peronospora','aparines');
INSERT INTO taxonomy VALUES(826,86334,'Peronospora','manshurica');
INSERT INTO taxonomy VALUES(827,86335,'Peronospora','destructor');
INSERT INTO taxonomy VALUES(828,162110,'Peronospora','violacea');
INSERT INTO taxonomy VALUES(829,162111,'Peronospora','potentillae-sterilis');
INSERT INTO taxonomy VALUES(830,162112,'Peronospora','sanguisorbae');
INSERT INTO taxonomy VALUES(831,162113,'Peronospora','conglomerata');
INSERT INTO taxonomy VALUES(832,162114,'Peronospora','silvestris');
INSERT INTO taxonomy VALUES(833,162115,'Peronospora','arvensis');
INSERT INTO taxonomy VALUES(834,162116,'Peronospora','grisea');
INSERT INTO taxonomy VALUES(835,162117,'Peronospora','alta');
INSERT INTO taxonomy VALUES(836,162118,'Peronospora','lamii');
INSERT INTO taxonomy VALUES(837,680264,'Peronospora','trigonellae');
INSERT INTO taxonomy VALUES(838,1484102,'Peronospora','anagallidis');
INSERT INTO taxonomy VALUES(839,2746716,'Peronospora','lanceolatae');
INSERT INTO taxonomy VALUES(840,622444,'Peronospora','belbahrii');
INSERT INTO taxonomy VALUES(841,2770501,'Peronospora','ranunculi-peduncularis');
INSERT INTO taxonomy VALUES(842,2126764,'Peronospora','erucastri');
INSERT INTO taxonomy VALUES(843,1320378,'Peronospora','digitalis');
INSERT INTO taxonomy VALUES(844,2750911,'Peronospora','clinopodii');
INSERT INTO taxonomy VALUES(845,2750912,'Peronospora','chenopodii-ambrosioidis');
INSERT INTO taxonomy VALUES(846,2028483,'Peronospora','aff. claytoniae');
INSERT INTO taxonomy VALUES(847,2028485,'Peronospora','cf. viciae');
INSERT INTO taxonomy VALUES(848,230362,'Peronospora','romanica');
INSERT INTO taxonomy VALUES(849,230363,'Peronospora','meliloti');
INSERT INTO taxonomy VALUES(850,230364,'Peronospora','mayorii');
INSERT INTO taxonomy VALUES(851,230365,'Peronospora','ervi');
INSERT INTO taxonomy VALUES(852,598569,'Peronospora','swinglei');
INSERT INTO taxonomy VALUES(853,230368,'Peronospora','trifolii-repentis');
INSERT INTO taxonomy VALUES(854,230369,'Peronospora','potentillae');
INSERT INTO taxonomy VALUES(855,230370,'Peronospora','aff. potentillae');
INSERT INTO taxonomy VALUES(856,230371,'Peronospora','violae');
INSERT INTO taxonomy VALUES(857,230372,'Peronospora','agrestis');
INSERT INTO taxonomy VALUES(858,230373,'Peronospora','flava');
INSERT INTO taxonomy VALUES(859,230374,'Peronospora','sordida');
INSERT INTO taxonomy VALUES(860,1855969,'Peronospora','agrimoniae');
INSERT INTO taxonomy VALUES(861,230379,'Peronospora','astragalina');
INSERT INTO taxonomy VALUES(862,1491441,'Peronospora','apula');
INSERT INTO taxonomy VALUES(863,1491442,'Peronospora','somniferi');
INSERT INTO taxonomy VALUES(864,2583025,'Peronospora','ranunculi-sardoi');
INSERT INTO taxonomy VALUES(865,944643,'Thraustotheca','terrestris');
INSERT INTO taxonomy VALUES(866,74557,'Thraustotheca','clavata');
INSERT INTO taxonomy VALUES(867,74560,'Dictyuchus','sterilis');
INSERT INTO taxonomy VALUES(868,1729145,'Dictyuchus','pseudodictyon');
INSERT INTO taxonomy VALUES(869,120407,'Dictyuchus','monosporus');
INSERT INTO taxonomy VALUES(870,334530,'Pythiopsis','humphreyana');
INSERT INTO taxonomy VALUES(871,334531,'Pythiopsis','terrestris');
INSERT INTO taxonomy VALUES(872,92969,'Pythiopsis','cymosa');
INSERT INTO taxonomy VALUES(873,1729207,'Pythiopsis','irregularis');
INSERT INTO taxonomy VALUES(874,1618014,'Pythiopsis','intermedia');
INSERT INTO taxonomy VALUES(875,92972,'Aplanopsis','terrestris');
INSERT INTO taxonomy VALUES(876,983690,'Leptolegnia','CAL-2011b');
INSERT INTO taxonomy VALUES(877,92976,'Leptolegnia','caudata');
INSERT INTO taxonomy VALUES(878,92984,'Leptolegnia','chapmanii');
INSERT INTO taxonomy VALUES(879,1729146,'Leptolegnia','eccentrica');
INSERT INTO taxonomy VALUES(880,100864,'Apodachlya','pirifera');
INSERT INTO taxonomy VALUES(881,92981,'Apodachlya','brachynema');
INSERT INTO taxonomy VALUES(882,134686,'Apodachlya','minima');
INSERT INTO taxonomy VALUES(883,601994,'Aphanomyces','iridis');
INSERT INTO taxonomy VALUES(884,942735,'Aphanomyces','cf. repetans');
INSERT INTO taxonomy VALUES(885,157072,'Aphanomyces','invadans');
INSERT INTO taxonomy VALUES(886,289317,'Aphanomyces','repetans');
INSERT INTO taxonomy VALUES(887,135856,'Aphanomyces','piscicida');
INSERT INTO taxonomy VALUES(888,281399,'Aphanomyces','frigidophilus');
INSERT INTO taxonomy VALUES(889,2174906,'Aphanomyces','fennicus');
INSERT INTO taxonomy VALUES(890,2518591,'Aphanomyces','raphani');
INSERT INTO taxonomy VALUES(891,935871,'Aphanomyces','salsuginosus');
INSERT INTO taxonomy VALUES(892,1617996,'Aphanomyces','scaber');
INSERT INTO taxonomy VALUES(893,120398,'Aphanomyces','stellatus');
INSERT INTO taxonomy VALUES(894,1125843,'Aphanomyces','sinensis');
INSERT INTO taxonomy VALUES(895,112090,'Aphanomyces','astaci');
INSERT INTO taxonomy VALUES(896,112091,'Aphanomyces','cochlioides');
INSERT INTO taxonomy VALUES(897,112092,'Aphanomyces','laevis');
INSERT INTO taxonomy VALUES(898,253176,'Aphanomyces','cladogamus');
INSERT INTO taxonomy VALUES(899,170619,'Aphanomyces','helicoides');
INSERT INTO taxonomy VALUES(900,100861,'Aphanomyces','euteiches');
INSERT INTO taxonomy VALUES(901,1980705,'Plectospira','gemmifera');
INSERT INTO taxonomy VALUES(902,100863,'Plectospira','myriandra');
INSERT INTO taxonomy VALUES(903,100866,'Leptomitus','lacteus');
INSERT INTO taxonomy VALUES(904,100874,'Sapromyces','elongatus');
INSERT INTO taxonomy VALUES(905,1579205,'Brevilegnia','minutandra');
INSERT INTO taxonomy VALUES(906,944588,'Brevilegnia','gracilis');
INSERT INTO taxonomy VALUES(907,944594,'Brevilegnia','unisperma');
INSERT INTO taxonomy VALUES(908,120402,'Brevilegnia','megasperma');
INSERT INTO taxonomy VALUES(909,944596,'Brevilegnia','variabilis');
INSERT INTO taxonomy VALUES(910,1631803,'Brevilegnia','longicaulis');
INSERT INTO taxonomy VALUES(911,309403,'Brevilegnia','macrospora');
INSERT INTO taxonomy VALUES(912,112094,'Brevilegnia','bispora');
INSERT INTO taxonomy VALUES(913,120400,'Aplanes','androgynus');
INSERT INTO taxonomy VALUES(914,1618019,'Aplanes','treleaseanus');
INSERT INTO taxonomy VALUES(915,120404,'Calyptralegnia','achlyoides');
INSERT INTO taxonomy VALUES(916,120411,'Pachymetra','chaunorhiza');
INSERT INTO taxonomy VALUES(917,120423,'Scoliolegnia','asterophora');
INSERT INTO taxonomy VALUES(918,758752,'Halophytophthora','cf. polymorphica');
INSERT INTO taxonomy VALUES(919,758753,'Halophytophthora','cf. batemanensis');
INSERT INTO taxonomy VALUES(920,758754,'Halophytophthora','epistomium');
INSERT INTO taxonomy VALUES(921,758755,'Halophytophthora','bahamensis');
INSERT INTO taxonomy VALUES(922,1446881,'Halophytophthora','fluviatilis');
INSERT INTO taxonomy VALUES(923,758758,'Halophytophthora','cf. exoprolifera');
INSERT INTO taxonomy VALUES(924,758760,'Halophytophthora','vesicula');
INSERT INTO taxonomy VALUES(925,289610,'Halophytophthora','avicenniae');
INSERT INTO taxonomy VALUES(926,743708,'Halophytophthora','porrigovesica');
INSERT INTO taxonomy VALUES(927,127446,'Halophytophthora','batemanensis');
INSERT INTO taxonomy VALUES(928,707993,'Halophytophthora','exoprolifera');
INSERT INTO taxonomy VALUES(929,980346,'Halophytophthora','masteri');
INSERT INTO taxonomy VALUES(930,758748,'Halophytophthora','elongata');
INSERT INTO taxonomy VALUES(931,758750,'Halophytophthora','mycoparasitica');
INSERT INTO taxonomy VALUES(932,758751,'Halophytophthora','polymorphica');
INSERT INTO taxonomy VALUES(933,134689,'Isoachlya','toruloides');
INSERT INTO taxonomy VALUES(934,135473,'Haliphthoros','milfordensis');
INSERT INTO taxonomy VALUES(935,135474,'Haliphthoros','philippinensis');
INSERT INTO taxonomy VALUES(936,135477,'Atkinsiella','dubia');
INSERT INTO taxonomy VALUES(937,413850,'Halocrusticida','parasitica');
INSERT INTO taxonomy VALUES(938,413851,'Halocrusticida','baliensis');
INSERT INTO taxonomy VALUES(939,135479,'Halocrusticida','okinawaensis');
INSERT INTO taxonomy VALUES(940,291622,'Pseudoperonospora','cannabina');
INSERT INTO taxonomy VALUES(941,291623,'Pseudoperonospora','celtidis');
INSERT INTO taxonomy VALUES(942,162120,'Pseudoperonospora','humuli');
INSERT INTO taxonomy VALUES(943,162119,'Pseudoperonospora','urticae');
INSERT INTO taxonomy VALUES(944,143453,'Pseudoperonospora','cubensis');
INSERT INTO taxonomy VALUES(945,159317,'Eurychasma','dicksonii');
INSERT INTO taxonomy VALUES(946,162128,'Basidiophora','entospora');
INSERT INTO taxonomy VALUES(947,1632271,'Basidiophora','simplex');
INSERT INTO taxonomy VALUES(948,162130,'Sclerospora','graminicola');
INSERT INTO taxonomy VALUES(949,162132,'Paraperonospora','leptosperma');
INSERT INTO taxonomy VALUES(950,461278,'Paraperonospora','tanaceti');
INSERT INTO taxonomy VALUES(951,502252,'Paraperonospora','minor');
INSERT INTO taxonomy VALUES(952,714891,'Hyaloperonospora','lobulariae');
INSERT INTO taxonomy VALUES(953,714893,'Hyaloperonospora','rorippae-islandicae');
INSERT INTO taxonomy VALUES(954,714894,'Hyaloperonospora','sisymbrii-sophiae');
INSERT INTO taxonomy VALUES(955,184463,'Hyaloperonospora','niessleana');
INSERT INTO taxonomy VALUES(956,697875,'Hyaloperonospora','drabae');
INSERT INTO taxonomy VALUES(957,240413,'Hyaloperonospora','aff. dentariae MG 18-6');
INSERT INTO taxonomy VALUES(958,240415,'Hyaloperonospora','erophilae');
INSERT INTO taxonomy VALUES(959,240417,'Hyaloperonospora','thlaspeos-perfoliati');
INSERT INTO taxonomy VALUES(960,697890,'Hyaloperonospora','norvegica');
INSERT INTO taxonomy VALUES(961,453155,'Hyaloperonospora','parasitica species group');
INSERT INTO taxonomy VALUES(962,240425,'Hyaloperonospora','aff. dentariae MG 5-8');
INSERT INTO taxonomy VALUES(963,2126763,'Hyaloperonospora','erucae');
INSERT INTO taxonomy VALUES(964,230450,'Hyaloperonospora','camelinae');
INSERT INTO taxonomy VALUES(965,230451,'Hyaloperonospora','lunariae');
INSERT INTO taxonomy VALUES(966,230452,'Hyaloperonospora','tribulina');
INSERT INTO taxonomy VALUES(967,2057907,'Hyaloperonospora','arabidis-glabrae');
INSERT INTO taxonomy VALUES(968,2057908,'Hyaloperonospora','nasturtii-montanii');
INSERT INTO taxonomy VALUES(969,272952,'Hyaloperonospora','arabidopsidis');
INSERT INTO taxonomy VALUES(970,272953,'Hyaloperonospora','berteroae');
INSERT INTO taxonomy VALUES(971,2057909,'Hyaloperonospora','nasturtii-palustris');
INSERT INTO taxonomy VALUES(972,2713659,'Hyaloperonospora','daughtreyae');
INSERT INTO taxonomy VALUES(973,272956,'Hyaloperonospora','cardaminopsidis');
INSERT INTO taxonomy VALUES(974,272957,'Hyaloperonospora','cheiranthi');
INSERT INTO taxonomy VALUES(975,272958,'Hyaloperonospora','cochleariae');
INSERT INTO taxonomy VALUES(976,272962,'Hyaloperonospora','galligena');
INSERT INTO taxonomy VALUES(977,272963,'Hyaloperonospora','hesperidis');
INSERT INTO taxonomy VALUES(978,272965,'Hyaloperonospora','isatidis');
INSERT INTO taxonomy VALUES(979,272967,'Hyaloperonospora','nasturtii-aquatici');
INSERT INTO taxonomy VALUES(980,162122,'Hyaloperonospora','barbareae');
INSERT INTO taxonomy VALUES(981,162123,'Hyaloperonospora','dentariae');
INSERT INTO taxonomy VALUES(982,162124,'Hyaloperonospora','thlaspeos-arvensis');
INSERT INTO taxonomy VALUES(983,162125,'Hyaloperonospora','brassicae');
INSERT INTO taxonomy VALUES(984,272970,'Hyaloperonospora','sisymbrii-loeselii');
INSERT INTO taxonomy VALUES(985,272973,'Hyaloperonospora','teesdaliae');
INSERT INTO taxonomy VALUES(986,858704,'Hyaloperonospora','praecox');
INSERT INTO taxonomy VALUES(987,230375,'Hyaloperonospora','nesliae');
INSERT INTO taxonomy VALUES(988,230378,'Hyaloperonospora','arabidis-alpinae');
INSERT INTO taxonomy VALUES(989,1344364,'Hyaloperonospora','cardamines-laciniatae');
INSERT INTO taxonomy VALUES(990,1344365,'Hyaloperonospora','dentariae-macrophyllae');
INSERT INTO taxonomy VALUES(991,1344366,'Hyaloperonospora','malyi');
INSERT INTO taxonomy VALUES(992,1344368,'Hyaloperonospora','cardamines-enneaphyllos');
INSERT INTO taxonomy VALUES(993,184465,'Perofascia','lepidii');
INSERT INTO taxonomy VALUES(994,886948,'Peronosclerospora','philippinensis');
INSERT INTO taxonomy VALUES(995,886949,'Peronosclerospora','maydis');
INSERT INTO taxonomy VALUES(996,1891364,'Peronosclerospora','sargae');
INSERT INTO taxonomy VALUES(997,1891365,'Peronosclerospora','australiensis');
INSERT INTO taxonomy VALUES(998,1081074,'Peronosclerospora','eriochloae');
INSERT INTO taxonomy VALUES(999,1081075,'Peronosclerospora','cf. eriochloae');
INSERT INTO taxonomy VALUES(1000,1081076,'Peronosclerospora','miscanthi');
INSERT INTO taxonomy VALUES(1001,230839,'Peronosclerospora','sorghi');
INSERT INTO taxonomy VALUES(1002,467161,'Peronosclerospora','sacchari');
INSERT INTO taxonomy VALUES(1003,467162,'Peronosclerospora','heteropogonis');
INSERT INTO taxonomy VALUES(1004,467163,'Peronosclerospora','noblei');
INSERT INTO taxonomy VALUES(1005,244732,'Viennotia','oplismeni');
INSERT INTO taxonomy VALUES(1006,335373,'Protobremia','sphaerosperma');
INSERT INTO taxonomy VALUES(1007,369778,'Benua','kellermanii');
INSERT INTO taxonomy VALUES(1008,369782,'Plasmoverna','pygmaea');
INSERT INTO taxonomy VALUES(1009,371029,'Plasmoverna','anemones-ranunculoides');
INSERT INTO taxonomy VALUES(1010,162142,'Plasmoverna','isopyrithalictroides');
INSERT INTO taxonomy VALUES(1011,369784,'Graminivora','graminicola');
INSERT INTO taxonomy VALUES(1012,371952,'Protoachlya','paradoxa');
INSERT INTO taxonomy VALUES(1013,371956,'Protoachlya','polysporus');
INSERT INTO taxonomy VALUES(1014,377434,'Haptoglossa','heterospora');
INSERT INTO taxonomy VALUES(1015,505981,'Haptoglossa','zoospora');
INSERT INTO taxonomy VALUES(1016,413849,'Halodaphnea','panulirata');
INSERT INTO taxonomy VALUES(1017,2494378,'Olpidiopsis','saprolegniae');
INSERT INTO taxonomy VALUES(1018,2546172,'Olpidiopsis','parthenogenetica');
INSERT INTO taxonomy VALUES(1019,1638924,'Olpidiopsis','feldmanni');
INSERT INTO taxonomy VALUES(1020,485441,'Myzocytiopsis','intermedia');
INSERT INTO taxonomy VALUES(1021,485442,'Myzocytiopsis','vermicola');
INSERT INTO taxonomy VALUES(1022,1484486,'Myzocytiopsis','osiris');
INSERT INTO taxonomy VALUES(1023,442665,'Myzocytiopsis','glutinospora');
INSERT INTO taxonomy VALUES(1024,1702225,'Myzocytiopsis','humicola');
INSERT INTO taxonomy VALUES(1025,1702226,'Myzocytiopsis','lenticularis');
INSERT INTO taxonomy VALUES(1026,1702227,'Myzocytiopsis','subuliformis');
INSERT INTO taxonomy VALUES(1027,461277,'Novotelnova','scorzonerae');
INSERT INTO taxonomy VALUES(1028,467176,'Sclerophthora','macrospora');
INSERT INTO taxonomy VALUES(1029,1702224,'Chlamydomyzium','anomalum');
INSERT INTO taxonomy VALUES(1030,1190596,'Chlamydomyzium','dictyuchoides');
INSERT INTO taxonomy VALUES(1031,572137,'Wilsoniana','portulacae');
INSERT INTO taxonomy VALUES(1032,642602,'Wilsoniana','platensis');
INSERT INTO taxonomy VALUES(1033,642603,'Wilsoniana','achyranthis');
INSERT INTO taxonomy VALUES(1034,642601,'Wilsoniana','bliti');
INSERT INTO taxonomy VALUES(1035,330680,'Wilsoniana','amaranthi');
INSERT INTO taxonomy VALUES(1036,913185,'Pustula','centaurii');
INSERT INTO taxonomy VALUES(1037,2069634,'Pustula','cancriniae');
INSERT INTO taxonomy VALUES(1038,2069635,'Pustula','xinyuanensis');
INSERT INTO taxonomy VALUES(1039,642600,'Pustula','spinulosa');
INSERT INTO taxonomy VALUES(1040,572139,'Pustula','tragopogonis');
INSERT INTO taxonomy VALUES(1041,1909805,'Pustula','junggarensis');
INSERT INTO taxonomy VALUES(1042,1471603,'Pustula','obtusata');
INSERT INTO taxonomy VALUES(1043,1005363,'Pustula','helianthicola');
INSERT INTO taxonomy VALUES(1044,650119,'Halioticida','noduliformans');
INSERT INTO taxonomy VALUES(1045,2014980,'Phytopythium','leanoi');
INSERT INTO taxonomy VALUES(1046,2014981,'Phytopythium','dogmae');
INSERT INTO taxonomy VALUES(1047,707994,'Phytopythium','kandeliae');
INSERT INTO taxonomy VALUES(1048,907947,'Phytopythium','vexans');
INSERT INTO taxonomy VALUES(1049,221743,'Phytopythium','citrinum');
INSERT INTO taxonomy VALUES(1050,546104,'Phytopythium','mercuriale');
INSERT INTO taxonomy VALUES(1051,946373,'Phytopythium','oedochilum');
INSERT INTO taxonomy VALUES(1052,795340,'Phytopythium','sindhum');
INSERT INTO taxonomy VALUES(1053,1334604,'Phytopythium','cf. citrinum A PB-2013');
INSERT INTO taxonomy VALUES(1054,220750,'Phytopythium','carbonicum');
INSERT INTO taxonomy VALUES(1055,1334605,'Phytopythium','cf. citrinum B PB-2013');
INSERT INTO taxonomy VALUES(1056,1130067,'Phytopythium','fagopyri');
INSERT INTO taxonomy VALUES(1057,1602131,'Phytopythium','mirpurense');
INSERT INTO taxonomy VALUES(1058,1130069,'Phytopythium','iriomotense');
INSERT INTO taxonomy VALUES(1059,1602133,'Phytopythium','palingenes');
INSERT INTO taxonomy VALUES(1060,340183,'Phytopythium','litorale');
INSERT INTO taxonomy VALUES(1061,944610,'Phytopythium','aff. vexans');
INSERT INTO taxonomy VALUES(1062,1130980,'Phytopythium','delawarense');
INSERT INTO taxonomy VALUES(1063,214887,'Phytopythium','montanum');
INSERT INTO taxonomy VALUES(1064,1049196,'Phytopythium','boreale');
INSERT INTO taxonomy VALUES(1065,82933,'Phytopythium','chamaehyphon');
INSERT INTO taxonomy VALUES(1066,126844,'Phytopythium','helicoides');
INSERT INTO taxonomy VALUES(1067,126845,'Phytopythium','megacarpum');
INSERT INTO taxonomy VALUES(1068,126846,'Phytopythium','ostracodes');
INSERT INTO taxonomy VALUES(1069,944616,'Pythiogeton','zeae');
INSERT INTO taxonomy VALUES(1070,1217585,'Pythiogeton','zizaniae');
INSERT INTO taxonomy VALUES(1071,1217586,'Pythiogeton','ramosum');
INSERT INTO taxonomy VALUES(1072,1217587,'Pythiogeton','uniforme');
INSERT INTO taxonomy VALUES(1073,1217588,'Pythiogeton','puliense');
INSERT INTO taxonomy VALUES(1074,1217589,'Pythiogeton','oblongilobum');
INSERT INTO taxonomy VALUES(1075,1217590,'Pythiogeton','microzoosporum');
INSERT INTO taxonomy VALUES(1076,1217591,'Pythiogeton','abundans');
INSERT INTO taxonomy VALUES(1077,1217592,'Pythiogeton','paucisporum');
INSERT INTO taxonomy VALUES(1078,1217593,'Pythiogeton','proliferatum');
INSERT INTO taxonomy VALUES(1079,983659,'Salisapilia','nakagirii');
INSERT INTO taxonomy VALUES(1080,983660,'Salisapilia','sapeloensis');
INSERT INTO taxonomy VALUES(1081,983661,'Salisapilia','tartarea');
INSERT INTO taxonomy VALUES(1082,1009719,'Eraphthora','butleri');
INSERT INTO taxonomy VALUES(1083,1432543,'Geolegnia','helicoides');
INSERT INTO taxonomy VALUES(1084,2517218,'Paralagenidium','ajellopsis');
INSERT INTO taxonomy VALUES(1085,1440115,'Paralagenidium','karlingii');
INSERT INTO taxonomy VALUES(1086,82950,'Globisporangium','sylvaticum');
INSERT INTO taxonomy VALUES(1087,82952,'Globisporangium','violae');
INSERT INTO taxonomy VALUES(1088,190219,'Globisporangium','abappressorium');
INSERT INTO taxonomy VALUES(1089,228749,'Globisporangium','glomeratum');
INSERT INTO taxonomy VALUES(1090,140046,'Globisporangium','polymastum');
INSERT INTO taxonomy VALUES(1091,373630,'Globisporangium','spiculum');
INSERT INTO taxonomy VALUES(1092,192020,'Globisporangium','carolinianum');
INSERT INTO taxonomy VALUES(1093,114966,'Globisporangium','erinaceum');
INSERT INTO taxonomy VALUES(1094,231958,'Globisporangium','debaryanum');
INSERT INTO taxonomy VALUES(1095,2125992,'Globisporangium','acanthophoron');
INSERT INTO taxonomy VALUES(1096,222890,'Globisporangium','rhizosaccharum');
INSERT INTO taxonomy VALUES(1097,2125994,'Globisporangium','orthogonon');
INSERT INTO taxonomy VALUES(1098,2125995,'Globisporangium','paroecandrum');
INSERT INTO taxonomy VALUES(1099,2708265,'Globisporangium','heterothallicum');
INSERT INTO taxonomy VALUES(1100,2125998,'Globisporangium','spinosum');
INSERT INTO taxonomy VALUES(1101,186163,'Globisporangium','cylindrosporum');
INSERT INTO taxonomy VALUES(1102,255163,'Globisporangium','hypogynum');
INSERT INTO taxonomy VALUES(1103,255165,'Globisporangium','longisporangium');
INSERT INTO taxonomy VALUES(1104,105151,'Globisporangium','echinulatum');
INSERT INTO taxonomy VALUES(1105,105152,'Globisporangium','nodosum');
INSERT INTO taxonomy VALUES(1106,105153,'Globisporangium','ornacarpum');
INSERT INTO taxonomy VALUES(1107,1935936,'Globisporangium','lacustre');
INSERT INTO taxonomy VALUES(1108,289603,'Globisporangium','acrogynum');
INSERT INTO taxonomy VALUES(1109,289604,'Globisporangium','multisporum');
INSERT INTO taxonomy VALUES(1110,289605,'Globisporangium','pleroticum');
INSERT INTO taxonomy VALUES(1111,295491,'Globisporangium','cystogenes');
INSERT INTO taxonomy VALUES(1112,2052682,'Globisporangium','ultimum');
INSERT INTO taxonomy VALUES(1113,1489740,'Globisporangium','solare');
INSERT INTO taxonomy VALUES(1114,173901,'Globisporangium','proliferatum');
INSERT INTO taxonomy VALUES(1115,1489741,'Globisporangium','recalcitrans');
INSERT INTO taxonomy VALUES(1116,2711120,'Globisporangium','macrosporum');
INSERT INTO taxonomy VALUES(1117,2711121,'Globisporangium','okanoganense');
INSERT INTO taxonomy VALUES(1118,2711122,'Globisporangium','rostratifingens');
INSERT INTO taxonomy VALUES(1119,2711123,'Globisporangium','rostratum');
INSERT INTO taxonomy VALUES(1120,289621,'Globisporangium','radiosum');
INSERT INTO taxonomy VALUES(1121,289622,'Globisporangium','parvum');
INSERT INTO taxonomy VALUES(1122,289623,'Globisporangium','marsipium');
INSERT INTO taxonomy VALUES(1123,289624,'Globisporangium','kunmingense');
INSERT INTO taxonomy VALUES(1124,115417,'Globisporangium','iwayamae');
INSERT INTO taxonomy VALUES(1125,115418,'Globisporangium','mamillatum');
INSERT INTO taxonomy VALUES(1126,115419,'Globisporangium','paddicum');
INSERT INTO taxonomy VALUES(1127,115420,'Globisporangium','pulchrum');
INSERT INTO taxonomy VALUES(1128,209243,'Globisporangium','segnitium');
INSERT INTO taxonomy VALUES(1129,289625,'Globisporangium','nagaii');
INSERT INTO taxonomy VALUES(1130,529119,'Globisporangium','cryptoirregulare');
INSERT INTO taxonomy VALUES(1131,1955676,'Globisporangium','oryzicola');
INSERT INTO taxonomy VALUES(1132,121062,'Globisporangium','perplexum');
INSERT INTO taxonomy VALUES(1133,36331,'Globisporangium','irregulare');
INSERT INTO taxonomy VALUES(1134,82926,'Globisporangium','splendens');
INSERT INTO taxonomy VALUES(1135,241406,'Globisporangium','attrantheridium');
INSERT INTO taxonomy VALUES(1136,1448053,'Globisporangium','intermedium');
INSERT INTO taxonomy VALUES(1137,147702,'Globisporangium','buismaniae');
INSERT INTO taxonomy VALUES(1138,196599,'Globisporangium','regulare');
INSERT INTO taxonomy VALUES(1139,147704,'Globisporangium','mastophorum');
INSERT INTO taxonomy VALUES(1140,147705,'Globisporangium','megalacanthum');
INSERT INTO taxonomy VALUES(1141,228342,'Globisporangium','campanulatum');
INSERT INTO taxonomy VALUES(1142,944635,'Globisporangium','lucens');
INSERT INTO taxonomy VALUES(1143,82940,'Globisporangium','middletonii');
INSERT INTO taxonomy VALUES(1144,189821,'Globisporangium','bifurcatum');
INSERT INTO taxonomy VALUES(1145,82942,'Globisporangium','nunn');
INSERT INTO taxonomy VALUES(1146,182783,'Globisporangium','canariense');
INSERT INTO taxonomy VALUES(1147,1489789,'Lagena','radicicola');
INSERT INTO taxonomy VALUES(1148,1495612,'Aquastella','attenuata');
INSERT INTO taxonomy VALUES(1149,1495613,'Aquastella','acicularis');
INSERT INTO taxonomy VALUES(1150,2692336,'Newbya','oblongata');
INSERT INTO taxonomy VALUES(1151,1618020,'Newbya','dichotoma');
INSERT INTO taxonomy VALUES(1152,1618013,'Newbya','spinosa');
INSERT INTO taxonomy VALUES(1153,2692335,'Newbya','apiculata');
INSERT INTO taxonomy VALUES(1154,1635159,'Pilasporangium','apinafurcum');
INSERT INTO taxonomy VALUES(1155,1926936,'Anisolpidium','rosenvingei');
INSERT INTO taxonomy VALUES(1156,1663100,'Anisolpidium','ectocarpii');
INSERT INTO taxonomy VALUES(1157,1672054,'Blastulidium','paedophthorum');
INSERT INTO taxonomy VALUES(1158,1682049,'Lagenisma','coscinodisci');
INSERT INTO taxonomy VALUES(1159,135480,'Salilagenidium','callinectes');
INSERT INTO taxonomy VALUES(1160,134690,'Salilagenidium','chthamalophilum');
INSERT INTO taxonomy VALUES(1161,135484,'Salilagenidium','thermophilum');
INSERT INTO taxonomy VALUES(1162,1702223,'Salilagenidium','myophilum');
INSERT INTO taxonomy VALUES(1163,1729148,'Phragmosporangium','uniseriatum');
INSERT INTO taxonomy VALUES(1164,1697476,'Baobabopsis','donbarrettii');
INSERT INTO taxonomy VALUES(1165,1697477,'Baobabopsis','enneapogonis');
INSERT INTO taxonomy VALUES(1166,1861792,'Salispina','intermedia');
INSERT INTO taxonomy VALUES(1167,980197,'Salispina','spinosa');
INSERT INTO taxonomy VALUES(1168,980198,'Salispina','lobata');
INSERT INTO taxonomy VALUES(1169,2025988,'Nothophytophthora','amphigynosa');
INSERT INTO taxonomy VALUES(1170,2025989,'Nothophytophthora','caduca');
INSERT INTO taxonomy VALUES(1171,2025990,'Nothophytophthora','chlamydospora');
INSERT INTO taxonomy VALUES(1172,2025991,'Nothophytophthora','intricata');
INSERT INTO taxonomy VALUES(1173,2025992,'Nothophytophthora','valdiviana');
INSERT INTO taxonomy VALUES(1174,2025993,'Nothophytophthora','vietnamensis');
INSERT INTO taxonomy VALUES(1175,1971756,'Calycofera','operculata');
INSERT INTO taxonomy VALUES(1176,1971757,'Calycofera','cryptica');
INSERT INTO taxonomy VALUES(1177,2182428,'Crypticola','clavulifera');
INSERT INTO taxonomy VALUES(1178,2203427,'Miracula','helgolandica');
INSERT INTO taxonomy VALUES(1179,2492455,'Miracula','moenusica');
INSERT INTO taxonomy VALUES(1180,2494383,'Ectrogella','bacillariacearum');
INSERT INTO taxonomy VALUES(1181,416808,'Pontisma','porphyrae');
INSERT INTO taxonomy VALUES(1182,2020009,'Pontisma','muelleri');
INSERT INTO taxonomy VALUES(1183,2020010,'Pontisma','palmariae');
INSERT INTO taxonomy VALUES(1184,2047754,'Pontisma','heterosiphoniae');
INSERT INTO taxonomy VALUES(1185,2487436,'Pontisma','bostrychiae');
INSERT INTO taxonomy VALUES(1186,1686415,'Pontisma','pyropiae');
INSERT INTO taxonomy VALUES(1187,2494385,'Pontisma','lagenidioides');
INSERT INTO taxonomy VALUES(1188,2203424,'Diatomophthora','drebesii');
INSERT INTO taxonomy VALUES(1189,2681712,'Diatomophthora','perforans');
INSERT INTO taxonomy VALUES(1190,2358464,'Diatomophthora','gillii');
INSERT INTO taxonomy VALUES(1191,2584052,'Periplasma','isogametum');
INSERT INTO taxonomy VALUES(1192,32630,'synthetic','construct C1');
INSERT INTO taxonomy VALUES(1193,32630,'synthetic','construct C2');
INSERT INTO taxonomy VALUES(1194,32630,'synthetic','construct C3');
INSERT INTO taxonomy VALUES(1195,32630,'synthetic','construct C4');
CREATE TABLE its1_sequence (
	id INTEGER NOT NULL, 
	md5 VARCHAR(32), 
	sequence VARCHAR(250), 
	PRIMARY KEY (id), 
	UNIQUE (md5), 
	UNIQUE (sequence)
);
INSERT INTO its1_sequence VALUES(1,'3b3cb03c4aa9604e922913ad148cd12c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCGGGTCCCGGACAGCTCCGATGCCCTGTATCAGTGCCGGTTTGCTACGGTAGATCCCCCGTTCCCGTGTTGGTCATGCACGAACCTGTCCTCGTGGCGTCTTTATGTAATGGTGGCCCTTGCTTCGTGAGGACGAAGTTTACCCAGGCTGGCGGGCGTTCGGACGCAGAGCAGTTCGTGGAAATAGAAACTGTG');
INSERT INTO its1_sequence VALUES(2,'6ad4c7e0216fc47df90fe208a3b7806c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACAATAGAACCATGTCTGTTATGCTACTAGTCCGTGAGTGTCTCTGCAGCCAGTTTCCTTCCAACTGTTTTCATGTCATTTACTGGCTTCCTCCCCGTGTGTTCTAGTTATCGGTGATGGTAGGAGAACGAGGTTGGAGCAGGTAAAAAAGCTCGGCGGCGAACTGTCCACAACTGTCTAGCTTCAATCGAGGGGC');
INSERT INTO its1_sequence VALUES(3,'8613c7627e99537203fe5895d0a24e8e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTATTACAGCCAGAGTAACTATATAATCTACGAGGGTGTTAGCTGTACGATGAGCGCGTCTGGTATTGCGTTCATTGGGGTCGATATTCCGACCTGCATGGTCCCGTTGCCAGCATGGTGTCTTTTCTTCGGGCTTGTAGCTCGTACAGTCTGACCGTGTAGGTTTGCAGGACCTCGGCCAGTCCCCTAGGCCGTTGC');
INSERT INTO its1_sequence VALUES(4,'8c55f39152a1c260dbbe1317db10f100','TTTCCGTAGGTGAACCTGCGGAAGGATCATTAAGGTCCGAGAGGTACTTCCTAGCCATTAGGCAGGCTAGTGCATTGCCGCAGCTTCCAGTCGTTCCGACGGGATGGTTCAATTTGCCCCCTACGCCACAAATGCCTCAGAGTTGCCGTCGGGGAGGTAGCCTCTCCAATGCTCCGAGGATGTTTGTAAACAAACCCCACGGAATACAAGCATGCTGACAGCTCTGT');
INSERT INTO its1_sequence VALUES(5,'88531412fbe9f8496ee2e80d1cbfa17d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(6,'29c57fb8bb431163a028917e552a1259','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAACATAAATTGGGGGTGATCCTGACGGTAGCTGCTGGTTTTTTACTGGCGGTAACTATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGTCTGGCGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(7,'f48331c6566caa6da14adda9329f1d9a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAACTTAAATTGGGGGTGATCTTGACGGTAGCTGCTGGTTTTTTACTGGCGGTAACTATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTCGTCTGGCGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(8,'dd7e2a61f258d6befab1d2a55242e5e0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAACTTAAATTGGGGGTGATCTTGACGGTAGCTGCTGGTTTTTTACTGGCGGTAACTATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGTCTGGCGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(9,'d9bc3879fdab3b4184c04bfbb5cf6afb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAATCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGTCTGGGTGGCGGCTCTATCATGGTGACCGCTCTGGGCTTCGGCTTGGAGTTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(10,'688ca1f52e3ffeb2417adceff1011655','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGGCTGGGTGGCGGCTCTATCATGGCGACCGCTCTGGGCTTCGGCCTGGAGTTAGTAGCTCACTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(11,'259d50fc8098473b48ceacb48eb3ed99','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(12,'3d3fa2fd6fe0f183cad80771f5950b27','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGTCCTGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(13,'f1d4c0432c89f005ec2b4e467839f5cc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(14,'86faa3e6c55cb63348af05c3272a51ed','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAGCATACT');
INSERT INTO its1_sequence VALUES(15,'f696591f997895f8ae62d4b9c44f4ccd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACACCCTTAGTTGGGGGCTGCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCCTGGGCCTTCGGGTCTGAGCTAGTAGCCCACTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(16,'8c593016c6c188d66817d7c0ada433d5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCTGCTGGTGGCATGTTTTTGCTGGCTGGCTACTGCTGAGCGAACCCTATCATGGCGAGTGTTCTGACCTCGGTTGGAGCTAGTAGCTTAAATTGTAAACCCATTCTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(17,'ab082031f945cad0319dffaf35beade5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACAATCCACGTGAACCGTATCAACCCCCCTTAATTGGGGCTTCCCTGCTGTCTTGTGCTGGCTGAGCTTTGTTGTTCGGCTGGTCGAGGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTTTGTTAGTAGCTTTTTTTTGCGACCGAGCGTTTGTGCCGACTATTGATGGAATCGCTTTTGCAAGCAGGCCAGTTACCTGTAGCATTGGCTTGAATCCGGACGCGGTTGGCGCGAGCTAGTAGTTTTGCAAAAGTTTTTTAAACCCTTTACTAAATACTGAAAAACT');
INSERT INTO its1_sequence VALUES(18,'04f98d2bf3f9dd49f7102ea1db7a128f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATAATCCACGTGAACCGTATCAACCCCCCTTAATTGGGGCTTCCCTGCTGTCTTGTGCTGGCTGAGCTTTGTTGTTCGGCTGGTCGAGGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTTTGTTAGTAGCTTTTTTTTGCGACCGAGCGTTTGTGCCGACTATTGATGGAATCGCTTTTGCAAGCAGGCCAGTTACCTGTAGCATTGGCTTGAATCCGGACGCGGTTGGCGCGAGCTAGTAGTTTTGCAAAAGTTTTTTAAACCCTTTACTAAATACTGAAAAACT');
INSERT INTO its1_sequence VALUES(19,'ed44806393cfa394e5056fca15b45a5c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACAATCCACGTGAACCGTATCAACCCCCCTTAATTGGGGCTTCCCTGCTGTCTTGTGCTGGCTGAGCTTTGTTGTTCGGCTGGTCGAGGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTTTGTTAGTAGCTTTTTTTTTGCGAACGAGCGTTTGTGCCGACTATTGATGGAATCGCTTTTGCAAGCAGGCCAGTTACCTGTAGCATTGGCTTGAATCCGGACGCGGTTGGCGCGAGCTAGTAGTTTTGCAAAAGTTTTTTAAACCCTTTACTAAATACTGAAAAACT');
INSERT INTO its1_sequence VALUES(20,'ed15fefb7a3655147115fc28a8d6d671','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(21,'af46526f85cbf2d345d419a0f30e854a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(22,'f65d8c80202d42fc17e32da2bb7f2858','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(23,'10ba08ab269b69142b6f83328e3e7099','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(24,'a012903e04863a4c2f904dee8dabc5cb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(25,'b1199a1082e563c9954dee14b4150557','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(26,'2e4f0ed53888ed39a2aee6d6d8e02206','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(27,'b3b684fc69437b76cc7921e2ed287dae','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(28,'12dc63e906f613f17219530896e88839','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(29,'c50b7fc6de0f1405b4388e95bdb01b4c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(30,'18ab920ad62eb511ae7b88fdccec0e36','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(31,'6bcdcba67f36c711c34f3a5ec368babb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGTCTGGGTGGCGGCTCTATCATGGTGACCGCTCTGGGCTTCGGCTTGGAGTTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(32,'d343fb37b0b42e3533546d8cbae33048','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGTCTGGGTGGCGGCTCTATCATGGTGACCACTCTGGGCTTCGGCTTGGAGTTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(33,'e827e3de506c4ff02217fde4a95bfa70','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(34,'602d96b1f4128367c10946522fe33269','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(35,'88c30cd5198b5c00764cb64ead1ea822','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(36,'783143261c94eddc7a13630cd5ba33ee','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTTTACT');
INSERT INTO its1_sequence VALUES(37,'ed32541ef8addf4b146847ac02646b28','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(38,'681a00ee195ffe65ef3f2dfd47598653','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCCACGTGAACTGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(39,'28c639a1150d8b7e4c6fba0e424e0271','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(40,'3c94d5e2cb0abf95075ee1a12aa129c8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(41,'e6371979623484f3c17cb4805b8a3940','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(42,'7ac50609279c89c7fc3d88ffed426dac','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(43,'4b5e99f8fcd8d04270c10da2bf59020b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(44,'a2ac9d97f7118c5cd7fa12880050a74a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTACCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(45,'d8613e80b8803b13f7ea5d097f8fe46f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(46,'f27df8e8755049e831b1ea4521ad6eb3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(47,'fe1bd3a42e730f95c9fde798e32f8478','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGTGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(48,'8950417251c8298320f60deda691b35b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(49,'a59091bd29e998d270db901e842e9bef','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAATATTTCCACGTGAACCGTTTCAACCAAAAAAATTTGGGGGTCTTGTTTGGCGGCGGCTACTGGCTTTATTGCTGGCGGCTGCTGCTGGACGAGCCCTAACGCGAAAGTTTAGACTTCGGTCTGGGCTAGTAGCTTTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(50,'29de890989becddc5e0b10ecbbc11b1a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCGGCTGCTGGCTTTGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(51,'36ad9a45fa33397a67d7f6be02a39964','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCATGGGCCTTCGGGTCTGAGCTAGTAGCCCTCTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(52,'24be91088cd4734b066a717bd2de041c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGACTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCATGGGCCTTCGGGTCTGAGCTAGTAGCCCTCTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(53,'7f3b213656cc5541bdcdf4692a3ed5bb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(54,'d48d9e6e3548bfd92a88d1b46d19bde1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGTTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(55,'8b835ab53506bff14285df6262625455','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(56,'76ca49ebff534e95634d75561c06cf23','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATATT');
INSERT INTO its1_sequence VALUES(57,'c971cc015791eec087271765b2b19cc3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(58,'c79d286595a487be4d76cd8dd3bd384d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(59,'5661d8e6ef0f1cc4e6cf61e4d7500fcb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGTGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(60,'a7471bc623c89cef2d91a9d43df99579','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(61,'07874837d1d9a8477337081d921a38d4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAATTCCACGTGAACTGTATTGTCAACCAAATTCGGGGATTCCTTGCTAGCGTGCCTTCGGGCGTGCCGGTAGGTTGAGACCCATCAAACGAAAACATCGGCTGAAAGGTCGGAGCCAGTAGTTAACTTTGTAAACCCTTTACTAAATACTGAAAAACT');
INSERT INTO its1_sequence VALUES(62,'91bf0a26b1eb21d6e54ac6a814c62775','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAATTCCACGTGAACTGTATTGTCAACCAAATTCGGGGATTCCTTGCTAGCGTGCCTTCGGGCGTGCCGGTAGGTTGAGACCCATCAAACGAAAACATCGGCTGAAAGGTCGGAGCCAGTAGTTACCTTTGTAAACCCTTTACTAAATACTGAAAAACT');
INSERT INTO its1_sequence VALUES(63,'0a61e6d1bd2525462225d081bea9c3ce','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAATTCCACGTGAACTGTATTGTCAACCAAATTCGGGGATTCCTTGCTAGCGTGCCTTCGGGCGTGCCGGTAGGTTGAGACCCATCAAACGAAAACATCGGCTGAAAGGTCGGAGCCAGTAGTTACCTTTGTAAACCCTTCACTAAATACTGAAAAACT');
INSERT INTO its1_sequence VALUES(64,'ac00bb7b4811bcc240d374d8bf03cd72','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATACT');
INSERT INTO its1_sequence VALUES(65,'3efd1e21521baf83a4751ccd90d39421','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTCTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATACT');
INSERT INTO its1_sequence VALUES(66,'32159de6cbb6df37d084e31c37c30e7b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(67,'972db44c016a166de86a2bacab3f4226','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(68,'21d6308d89d74b8ed493d73a2cb4adb5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(69,'99977bef41e2f50048e6c730637dc941','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(70,'301acf5db567b162de87ca69423a8440','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(71,'4ae6aaf0acd68944c1274608a7211df3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTATTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(72,'366a3b698343fa24129a272f807ccf94','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAATTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(73,'d9e6de1308a8ac1448de351747d023c0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(74,'f502b76965836568a0a113e2074879c8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(75,'2843e160cc0859ffa1b6ac4f6ec7c508','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(76,'3d3f43d07f2d4dd63fe88aa3d6df9b52','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTAAAAAACTAGTTGGGGGCTCCTCGTTGGCAGTTTCGACTGTTAGTGGGTTGAGTTCTATCAAACGATCGATTTGGGCTGCAAAGTCGGAATTGAGAGTTTCTTTTTTAAACCCATTACTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(77,'951ac00b20e25e3e1664a5edef2acb6c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGACGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(78,'66abcf5b8d99d1570bd815e67442f666','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(79,'8b82f3e8bc9c3b11d34027df788ab8b9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(80,'4b639550662bfcf27f9face76af10d6b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGTGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(81,'b88010d58905d035f845a320e18e00c3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(82,'ebf17b7149dc75e8063184ccc3e2115f','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(83,'d2f79ee350b1a26e592ec9acf46aeaa6','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTGTCCACGTGAACCGTATCAACCCAAGTAGTTGGGGGCGTTACTGTTCTGCGCAGGCTGTCGATGTGAAAGTCGGCGGCTGGTGCGGAGCGGTGATGCCCTATCATGGCGAAGGTGTTGTGTTCCTCTCGGGGGACGTGATGTCGGCTGCCCTCTGTTTTAAACCCATTCCTAATAACTGATTAATACT');
INSERT INTO its1_sequence VALUES(84,'c9ada13adb72000a23195213711c7c41','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(85,'bb04f7764615f35f290ec81ed57a285d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGTACACTGTTGGGTTTCGCTGGCGCGTGTTTTCTTGTCGAATGTAGTGTTTGACGGCGCGCGGCGGCTGGAGGCCATCAGGGCGTCTGTTGTTGTGATGGACGCTCTTTTTGTAAACCCCCTTTTTTTTGTTATTTTGTGAAACTGATTGTACT');
INSERT INTO its1_sequence VALUES(86,'1ba4dfd7af0dd5c02769b16641baaafb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTTTTCTCTCTCTCTCTTTTGGGGGAGGGGATGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTTTTGATAACTGAAACATACT');
INSERT INTO its1_sequence VALUES(87,'5af8bd9fecdc11a35378b4bd68f4b5fe','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTTGAGTATTGTTGGGGACTTGTTCGGCGGCGTGCGCTTTTCGGAGCGCGTGCTACTGGGCGAGACCTATCATGGGCGCGATCGCTCGGGCTTCGGTCTGGGCTAGTAGCTGCTCTTTTTTAAACCCATTCGTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(88,'2e0b58e8c1868ccee83b69cbcb38d807','TTCCCGTAGGTGAACCTGCGGAAGGGATCATTACCCACACCTTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGNAGGGTGATCTTAATGGAGGGCTACTGGTCATTTTTGACTGGAGGCTACTATCGAGTGAACCTTATCATGACGAAAAATTAGGCTTATGTCTAGTGAAGTAGTGAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(89,'c235f6ea18ec86df70cc0b1652b5de7c','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(90,'0b05ab6b8fb55f6d437a0fc7406df0e8','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(91,'0da6aab1797bea65158e304dbda9eff6','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(92,'51c2049cc591015dda17da26c85cd4e1','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCCGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(93,'53e1a65ecf593b64bbb48b74478782ad','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(94,'06a6d3654806b1a7b908f7643e48ed2b','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTCTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(95,'4d5fa3f36faef5add3740adc94624936','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(96,'2b13ab9a70c1db5c7ec0abed13e925fa','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(97,'fcc64a72a6b0440c24b223279df24eec','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(98,'1044332b717569424a4d5ae2bad695e8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGACGGTAGCTACTGGTTTTTTACTGGCGGTAACCATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGCCTGACGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(99,'8513f958408b8a4a3b7c44620bc2c19a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(100,'6d85285e77611ff5d472b91005d2437d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACAATCCACGTGAACCGTATCAACCCAATAATTGGGGGTTTACTTGGCGGCGGCTGCTAGCATCTTTTTGCTGGCTGGCTACTGCTGAGTGAATCCTATCGCGAGCGTTCTGACTTCGGTTGGAGCTAGTAGCTTAACTTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(101,'856d53c7a6d239561ae28b79bbf5d941','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACAATCCACGTGAACCGTATCAACCCAATAATTGGGGGTTTACTTGGCGGCGGCTGCTAGCATCTTTTTGCTGGCTGGCTACTGCTGAGTGAATCCTATCGCGAGCGTTCTGACTTCGGTTGGAGCTAGTAGCTTAACTTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(102,'e728e682481346b013c6d197dd53f2e6','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATAACTTGGGGGTTTAATTGGCGGCTGCTGCTGGTATCTTTTTACTGGCTGGCGGCTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(103,'6fbeade395be8dbcf9beca25ccbc2d07','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTTAATTGGCGGCTGCTGCTGGTATCTTTTTACTGGCTGGCGGCTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(104,'5f6e5cf246ace4ab7809083ec0ab0f7d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTTATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(105,'fe8e4668ef29f3e3de3dd7bf3b5fdc5e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTTATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAACGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(106,'3b3d7017bb0704e653f1013630ca487e','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTATTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(107,'fd18002dfea696481aa89788dc794cba','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGTCGGGCTCTATCATGGGCGAGCGTTTGGGCTTGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(108,'3058d6421cffeac1fd0bbb9978b787a4','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTATAAACCATTACTTTTTACTGATTATACT');
INSERT INTO its1_sequence VALUES(109,'475cd908a78967e65e144153ef9820d7','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(110,'f945858f0b811b505119f9fbd4eb356d','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(111,'3b727c62621b67a073e326975cfa1cad','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGACGAGTAGCCTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(112,'835aa47db171a3ebf793ad23e5b3fb9a','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(113,'10a03f57248843ddf484e2d87a7b8473','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTAACTGATTTCGTGTGTTTTCCTATTTTTGGACACTAGAAGACAGGATTCAGCAGGACGAAGGTTAGTCTCTCTTAATGCAAGTTAGGAGGAGGATTAGCTGATGAACTTTTNTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(114,'370005b0daef9507e9b65c8d2f8d70af','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(115,'60c91384928b4233ce2d4c529462716f','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(116,'9025fdfe8864e9671f4bdb3742520708','TTTCCGTAGGTGAACCTGCGGAGGATCATTACCACACCTAAAAAATTTCCACGTGAACCGTTTCAACCAAAAGTTGGGGGTCTTGTTTGGCGGTGACTGCTGGCTTTATTGCTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAAAGTTTGGACTTCGGTCTGAGCTAGTAGTTATTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(117,'f536a0b271339b12326e25148e6aa2aa','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(118,'e0878938e6b23431cc66f1695359875a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(119,'de16621f8d58a174870c5a53995ef7aa','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAATCTTTCCACGTGAACTGTTTTTGTAAATTTGGGCTTCGCCTGCTGCGTTCTTTTACCATTTAATTATTTATTTTTTTCTTTGGTGAGGGAATGCGACGGCTTGAGGCCATCAGGGTGCGCTTGCTTGGTTACTTTTGTTTGTACCATTCAAAAAAATGTAATCGAGCGAGTGCGCTCTTTGTCAACCCATTTCTTTTGAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(120,'708813ddaef97718f2c301884a0bca41','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTCCACGTGAACCGTATCAACCAATTAATTGGGGGCTTTCTTGGCAACGGCTGCGAGCATCTTTTTGCTGGCTAGTTCTTGCGGAGGAAGCCCTATCATGGCGAGCGTTCGGACCTCGGTCTGAACTAGTAGCTTCAACTTGTAAACCCTTTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(121,'92e3f27103b24dd4889e47553f1714fc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAATCTTTCCACGTGAACCGTATCAACCCAATACATTGGGGGTTAGCTTGGTGGTGGCTGCTGGCATCTTTTTGCTGGCTGGCTGCTGCTGAGCAAGCCCTATCATGGCGATCGTACGGACTTCGGTCTGAACTAGTAGCTTCAATTGTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(122,'bfa53084c50e0c682fcb537ca8309205','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGGTGGTGGCTACTAGTCTTTGGCTGGTGGTAACTACTAGGTGAACCTCATCATGGCGAACCATTGGGCTTTTGTCTAATGTAGTAGTATAAATTTTAAACACTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(123,'ebaf56e503ad9ea65861df2155fd3b2a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAATTTAAATTGGGAGCGATCTTGGTGGTGGCTACTAGTCTTTTGGCTGGTGGCTACTATTGGGTGAGCTCCATCATGGCGAACCATTGGACTTTGTCTAATGTAGTAGTATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(124,'41633fca3ba2580f02234d6f6bda6568','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCACCCATTTGGGGGTTTGTTTGGCGACTGCTACTGGCATCTTTTTGCTGGCTGCTGTTTCTGGGCAAACCCTATCATGGCGAGCGCTCGGACCTTGGTCGGAGCTAGTAGCTTTCTTTTAAACCCATTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(125,'93ea3dd682f13feec67aeaad84db6ce4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCTAATAAATTGGGGGTTTAATTGGCGGTGGCTGCTGGCATCTTTTTGTTGGCGGCTGTTGCTGAGCAAGCCCTATCATGGCGAACGTTTGGACCTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(126,'255a21ada2166aa92c2888c34bfa43c1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTATCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTAATTGGCGGCGGCTGCTGGCATATTGCTGGCTGGCTGCTGCTGAGCGAGCCCTATCATGGCGAGCGCTTGGGCTTCGGTCTGAGCTAGTAGCTTTTATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(127,'8923222158a12cc3586e1c920c0eb9b5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTAATTGGCGGCGGCTGCTGGCATATTGCTGGCTGGCTGCTGCTAAGCGAGCCCTATCATGGCGAGCGCTTGGGCTTCGGTCGGAGCTAGTAGCTTTTATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(128,'33ef3d9a577f74c0af17a7b08ab17b6e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTAATTAATTGGGGGCTTAATTGGCGGCGGCTGCTGGCATCTTGCTGGCTGGCTGCTGCTGAACGAGCCCTATCATGGCGAGCGCTTGGGCTTCGGTCTGGGTTAGTAGCTTTTATTTTAAACCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(129,'7026eab909f51daa1e6d447b943d5563','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(130,'5cdd7c7d5c8fab6c0ddc0f117d3633e3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATTCAACAATTATAATTGGGGGTGATCTTGGTGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAATTAGGCTTTTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(131,'e3e5a040ac67cdfcda4f2cb6c8af4829','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATTCAACAATTATAATTGGGGGTGATCTTGGTGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAATTAGGCTTTTGGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(132,'826aec1ee8a066f97a0eeaa26747e320','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(133,'d4f0f164d6b1f6bf2e2f1f08e11008fb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAACTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(134,'b9cd13d5a142a34fa9a27ae4b1a5a8ce','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAACAACTTAAATTGGGGACGAAGATCTTGGTGGTAACTACTAGTCTCGACTGGTGGTAGCTACTAGGTGAGTAGTCTCATCATGGCGAACCATTGGGCTTTTGTCTAATGTAGTAGTATAAATTGTAAACACTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(135,'b41a92def772e860fbb8eac8172ea242','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTCCACGTGAACTGTATCAACAACTTAAATTGGGGACGAAGATCTTGGTGGTAACTACTAGTCTCGACTGGTGGTAGCTACTAGGTGAGTAGTCTCATCATGGCGAACCATTGGGCTTTTGTCTAATGTAGTAGTATAAATTGTAAACACTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(136,'863482727724d44031d5d6ef252cac3e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTCCACGTGGACCGTTCAACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTTGTGAGCCTCATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTATTCTTTTAAACCATTACTTCATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(137,'715ffa19d36ed46d2755b609191b3c01','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATTCAACAATTATAATTGGGGGTGATCTTGGTGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAATTAGGCTTTTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(138,'56ceaf4df9464d7509f1c99541f2c4ed','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGGACCGTTTCACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTTGTGAGCCTCATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTATTCTTTTAAACCATTACTTCATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(139,'4bf8c2745368880ccc4522be8998707b','TTTTCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAATTATAATTGGGGGTGATCTTGGTGATGGCTACCAGTCTATGACTGGCGGTCTACTGAGTGAACCCTATCATGGCGAACCATTGGGCTTTGGTCTAATGTAGTAGTATAAATTTTAAACCCTTACCTAATTACTGATTTACT');
INSERT INTO its1_sequence VALUES(140,'b04e88ef83262ac85a7573fcd12d7384','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACACACCTAAAACTTTCCACGTGACGTATCACAATTATAATTGGGGGTGATCTTGGTGATGGCTACCAGTCTATGACTGGCGGTCTACTGAGTGAACCCTATCATGGCGAACCATTGGACTTTGGTCTAATGTAGTAGTATAAATTTTAAACCCTTACCTAATTACTGATTTACT');
INSERT INTO its1_sequence VALUES(141,'30e386355fec666b8f9a191fbd9110fc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTCCACGTGAACTGTATCACAATTATAATTGGGGGTGATCTTGGTGATGGCTACCAGTCTATGACTGGCGGTCTACTGAGTGAACCCTATCATGGCGAACCATTGGGCTTTGGTCTAATGTAGTAGTATAAATTTTAAACCCTTACCTAATTACTGATTTACT');
INSERT INTO its1_sequence VALUES(142,'0f215d00d967a49a40b5134549ad7ba3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTCCACGTGAACCGTATCACAATTATAATTGGGGGTGATCTTGGTGATGGCTACCAGTCTATGACTGGCGGTCTACTGAGTGAACCCTATCATGGCGAACCATTGGGCTTTGGTCTAATGTAGTAGTATAAATTTTAAACCCTTACCTAATTACTGATTTACT');
INSERT INTO its1_sequence VALUES(143,'3c40ffb101830dc1d5c3df83b36082b7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGAGGTGACCTTAATGGAGGCTACTAGTCATTTTGGCTGGCGGCTACTATCGAGTGAATCTCATCATGGCGAAAAATTAGGCTTCGGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(144,'79d7a18d5a009bf7ad9557cb4b97d9c2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATTACAATTATAATTGGAGGTGACCTTAATGGAGGCTACTAGTCATTTTGGCTGGCGGCTACTATCGAGTGAATCTCATCATGGCGAAAAATTAGGCTTCGGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(145,'93ce19c8d140792dc9864b3100ff4bb5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGACCGTATTAACAATTATAATTGGAGGTGACCTTAATGGAGGCTACTAGTCATTTTGGCTGGCGGCTACTATCGAGTGAATCTCATCATGGCGAAAAATTAGGCTTCGGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(146,'9240f7d151759ca688a64c91eb24987b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGGACCGTCTCAACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTCGTGAGCCTTATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTACTTTTTTAAACCATTACTTTACTACTGATTATACT');
INSERT INTO its1_sequence VALUES(147,'18d58d7cf3403b57e0d94f0bbf83dca0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGGACCGTTTCAACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTCGTGAGCCTTATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTACTTTTTTAAACCATTACTTTACTACTGATTATACT');
INSERT INTO its1_sequence VALUES(148,'f34f88e4c1ca303a88f2d648e626079d','TTTCCGTAGGTGAACCCTGCGGAAGGATCATTACCACACCTAAAACTTTCCACGTGGACGTTTTACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTCGTGAGCCTTATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTACTTTTTTAAACCATTACTTTACTACTGATTATACT');
INSERT INTO its1_sequence VALUES(149,'d936c7a268cb71e1fa8e3ea9b1e6c2ca','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTCCACGTGGACCGTTTCACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTTGTGAGCCTTATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTACTTTTTTAAACCATTACTTTACTACTGATTATACT');
INSERT INTO its1_sequence VALUES(150,'d6b8e74a58fbe5d993b65de811735cb9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAATTTTAATTGGGGGTGATCTTGGCGGTAGCTACTGGTTTTGTACTGGCGGTAACTATTGAGTGAACCTTATCATGACGAACCGTTGGGCTTTTGTCTGGCGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(151,'c5ab809f6fbfee2f97373c411096ecc5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACATTTATAATTGGGGGCGATCTTGGCGGCGGCTACTAGTCTATGACTGGCGGCGGCTACTGGGTGAGCCTCATCATGACGAATCGTTGGGCTTTTGTCTAATGTAGTAGTAAAATTTTAAACCCTTACCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(152,'5ec367879dbc8a844e32fc2faf53684b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTCCACGTGAACCGTATCAACATTTATAATTGGGGGCGATCTTGGCGGCGGCTACTAGTCTATGACTGGCGGCGGCTACTGGGTGAGCCTCATCATGACGAATCGTTGGGCTTTTGTCTAATGTAGTAGTAAAATTTTAAACCCTTACCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(153,'11209f488e9451525341984073b9c972','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCCACGTGAACCGTATCAACTTTTTTAATTCGGGGGACGCTAGGTGGCGATTGCCGGTCTCTTTGACTGGCGATTGCTACTAGGCGACTCAACCGTGGCTAAGGTCAGGCTTCTGTTTGATAACTTAGTGATATTGTAAACCATTCTTTAATTACTGTATACT');
INSERT INTO its1_sequence VALUES(154,'90c45b44fd7abb30407b209a8049c4a3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCCACCGTGAACCGTATCAACTTTTTTAATTCGGGGGACGCTAGGTGGCGATTGCCGGTCTTTTTGACTGGCGATTGCTACTAGGCGACTCAACCGTGGCTAAGGCCAGGCTTCTGTTTGATAACTTAGTGATATTGTAAACCATTCTTTAATTACTGTATACT');
INSERT INTO its1_sequence VALUES(155,'a4081b4f14371f872a28aaa1c4d21b44','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTCCACCGTGAACCGTATCAACTTTTTTAATTCGGGGGACGCTAGGTGGCGATTGCCGGTCTTTTTGACTGGCGATTGCTACTAGGCGACTCAACCGTGGCTAAGGTCAGGCTTCTGTTTGATAACTTAGTGATATTGTAAACCATTCTTTAATTACTGTATACT');
INSERT INTO its1_sequence VALUES(156,'44473736a9868c934c5be8456c0256f9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCCACCGTGAACCGTATCAACTTTTTTAATTCGGGGGACGCTAGGTGGCGATTGCCGGTCTTTTTGACTGGCGATTGCTACTAGGCGACTCAACCGTGGCTAAGGTCAGGCTTCTGTTTGATAACTTAGTGATATTGTAAACCATTCTTTAATTACTGTATACT');
INSERT INTO its1_sequence VALUES(157,'4c2ca12e8525ec7de8f3a3671e01b626','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTNCACGTGAACCGTATCAAACCAATTCATTGGGGGTTTGTTTGGCGGCGGCTGCTGGCATCTTTTTGCTGGCTGCTGCTGCTGAGCGAGCCCTATCATGGCAAGCGCTCGGACCTCGGTCGGAGCTAGTAGCATTCATTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(158,'c83e20e2c5832013e0a68552564a9dd9','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACGCCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(159,'3bdf5286000b2ca5eb7b90835e3cc935','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(160,'77adca129f2d827c43c57ce137e33515','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(161,'7544808057374eb181cc4a2e3334faae','TCCGTACGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGTCGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTCTCGTAATGCAAGTTATGGGGGACTAGCTGATGAACTTTTCTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(162,'5045df00b7ef969171c5c55bb2133907','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCAAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(163,'fe95518c0a00500728a72f4605e5bbd7','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(164,'d9b1961bdc806d3a2815ea4c035ad2e8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGATCTGGTGTTTTTGGATACTGGATCGGGAGTGAGCAGGACGAAGGTTGGTCTCGTAATGTAAATTATGGGACTAGCTGATGCATTCGTTTTTCAAACCCTTACCTAAATACTGATTGATACT');
INSERT INTO its1_sequence VALUES(165,'47a8a864eb87593a23f664638e2f87a4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAACTTTCCACGTGAACTGTCATTGCATGTTTTGTGCCTTTAATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCATTCTTAAACACTGATTTATACT');
INSERT INTO its1_sequence VALUES(166,'58f037eddc83ec4fb217818a33cfbf0c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCCGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(167,'d0fbcc7c0c60219018e29330c7b101a9','TTCCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCTTGAGCCTTCGGGTCTGAGCTAGTAGCCCACTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(168,'17941b175ac7798ad8b9556063659808','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAAACTATCCACGTGAACCGTTTGTACCAAGATTTGCGTCAAGATGTTTGTGCATGTTTGTTGTATCACTGTGTATTCGTACGCGGTGTGTGGCAAGTATGTATGACGCTTGGCTGATCGAAGGTCGTGTCGCACTTGATTGTGTGTATCGGCTGACTTATTTTTCAAACCCATTCTTTAGTACTGATTATACT');
INSERT INTO its1_sequence VALUES(169,'b3979d23e362a1c73671ad4b26e75d98','TTTCCGTAGGTGAACCTGCGGAAAGGATCATTACCACACCAAAAATCCTTTCCACGTGAACTGTCGTATTTGATTCGCGCCGTGACGTGTGTCGTCGCTGCGTGTGCGTTTGTGCGTGCGTCTTCTTGGAGATGTGTGCGCGAGTGCGCGCGTGGCGGTGACTGCGTGGGTCGGCTGATCGAAAGGTCGCTTTGCGCTGTCTGGCGCGGAGCGGCTGACTTATTCTTTCAAACCCATTCGTTAGTACTGAAACATACT');
INSERT INTO its1_sequence VALUES(171,'1660d452397da144120f7eda91b85982','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAACTTTCCACGTGAACTGTCTTAGCATGTTTTGTGCCTTTTATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATCTTTTTAAACCCATTACTTTATTACTGATTTATACT');
INSERT INTO its1_sequence VALUES(172,'6f1aa39f52d96240df6a5aa9f6733e66','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAACTTTCCACGTGAACTGTCTTAACATGTTTTGTGCCTTTTAATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATTTATCTTTTTAAACCCCTTACTTAATTACTGATTTATACT');
INSERT INTO its1_sequence VALUES(173,'723addf7247cc370289affd5bd44936b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAACTTTCCACGTGAACTGTCTTAACATGTTTTGTGCCTTTAATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATCTTTTTAAACCCCTTACTTAATTACTGATTTATACT');
INSERT INTO its1_sequence VALUES(174,'79fcddffa171bab6dc1cb9d8d1633408','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGATCTGGTGTTTTCGGATACTGGATCGGGAGTCAGCAGGACGAAGGTTGGTCTCGTAATGTAAATTATGGGACTAGCTGATGCATTCCTTTTTCAAACCCTTACCTAAATACTGATTGATACT');
INSERT INTO its1_sequence VALUES(175,'72bab5ead7563838ced9566a9273817c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTTGTGTTTGCTTTTGTTTGTCTCGCTCTTCGGGGTGTGGTGGACAAGAGGAAGCGCAAGGCTAAACGAAGGCTGCGAGTCTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAACACTGAACTATACT');
INSERT INTO its1_sequence VALUES(176,'b36b5e9e0544064810e75a157831bc54','TTTCCGTAGGTGAACCTGSGGAAGGATCATTACCACACCTAATAAACTTTCCACGTGAACCGTCAACCCAGCCAGTTTAGCGTCACTTTGTGTGCGTCTTTTCTCGATTGCCGTTTTTAATGAAATGGCGAGAGAGGGGAAACAAGCGCAATTTAGACAGAACGAAGGTCGAGCTGTTTTTCTATTCGTAGTGAGACGGCTTGGCTGATTTATTCTTTTCAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(177,'58abf2d07461a8d8725bc8300f5aadfc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAATAAACTTTCCACGTGAACCGTCAACCCAGCCAGTTTAGCGTCACTTTGTGTGCGTCTTTTCTCGATTGCCGTTTTTAATGAAATGGCGAGAGAGGAGAAACAAGCGCAATTTAGACAGAACGAAGGTCGAGCTGTTTTTCTATTCGTAGTGAGACGGCTTGGCTGATTTATTCTTTTCAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(178,'0916adb8d3909e059eb787b1089f8256','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTCAAATGAAACTAGTTTTGTGCCGGGTTGTGTGCGTTCTTAACGGAACAAGCGCGGCCTGGCTAAACGAAGGTCGAGTTGTTTTTCCTTTATTGGAGAGACGGCGTGGCTGATTTATTTTTCAAACCCATTACCTAAATACTGATGATACT');
INSERT INTO its1_sequence VALUES(179,'80da1f71212fb400df0c284672b31c10','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGTTGTAAGTTGGGCTTCGCTGGCGTGTTCTGTTTTCGGACGGAGCGCAACGGCTTGAGGCCATCAGGGCGTTTATTGTGTCGTGCAGTATTCGCTCTTTTTGTAAACCCATTTTTGATGAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(180,'559fdd3bdc30917df45fa305f1e7d36f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAATCTTTCCACGTGAATTGTTTGTCGTTGTTTGGGCTTCGCCTGCGCGCTTTGTTTCGTTCTGTTTTTGTTCGGACGAGGTGCAACGGCTTGAGGCCATCAGAGCGTTTTATTTGTGCTTTTGTACGAGTAATCGCTCTTTTTTGTAAACCCCTTTTTTTTTTAACATGAAAACTGATTTATACT');
INSERT INTO its1_sequence VALUES(181,'6d9139626cac4cc6c265b62636b8b8a6','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTGTTGCAATGTTGGGCCTCGCTGGGCTAGGATTTTCCTGGTTCGGTTGGAGGTCATCAGGGCGTGTCGTTGCTTTGTGATTCGTTTTGCATGGTGTCGCGCGCTCTTTTTGTAAACCCATTTAATTGAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(182,'aaac9608e2bc6c8d19ccb91f3fabb70b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTGTTCTCTCTGTTTTGGGGGGAGGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTCTTTGATAACTGAAACATACT');
INSERT INTO its1_sequence VALUES(183,'b217c3d3022a4f6b354be5ec16acc31e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATTGTTGGGCTTGTCTTTCTTTCGGGGAGGATGAGCTATCTGTAAACTTGTCAAACCCCTTTCTTTTTTTATAAAACTGAAACATACT');
INSERT INTO its1_sequence VALUES(184,'b717c1ab773e83a1a52d6fa8dea6157e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTATCCACGTGAACCGTTAAGTAAAAGTCTAGTTGGCTTGTGTTGTTGGGGAGTGTGTTGGGAAAAGCTTGGAGATGTCTTTGGATATTTCGATGCGTAGTACTGGTCATTCTAACGAGCGAGTCGGGTAGCAACGAAGGTCGGGAGTTCGCTTGCGGACTGATGTGCGCTTGTCGCATGTCGGTCGAAAGGCTTGAGCAAACGGCTGATCTATTCMTTTTAAACCATACCATAAGTACTGATTATACT');
INSERT INTO its1_sequence VALUES(185,'33f32a66a3b03e9cf6348ebfb784d87d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAACAACTTTCCACGTGAACTGTCGTACGAGATTCGCGCCGTGACGCGTGTTGGCGCTGTGTGTGTCTGTCTGTGTCTTCTTTCGGGAGGATGTGGATGGATGGTGCATGGCGTTGACCGCGTGGGTCGGCTGATCGAAGGTCGCGTTGTGCATTCTTGCATGGCGCGGCTGACTTATTCTTTCAAACCCATTACTAATACTACTGATTCATACT');
INSERT INTO its1_sequence VALUES(186,'e798a519c94d44abd72be67445cdae84','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTCTGTCCGTTTTGTGCCGTTGCTGTTGTCGTGCTTCGACGAGAAGAGCAGTGGCTAAACGAAGGCTGTGAGCTTCGTGCTTGCGGTCGATTTATTCTTTCAAACCCCATACGTTAAGAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(187,'0d0fec88a3d9e7fcf0d8824de6bdc806','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTGTTGTTTTCGCTCTGCTCTGTGCCTTCGGGTGTAGAGTGTGGAGTGGGAAGAAAGCTCCAGGCTAAACGAAGGCTGCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAAGACTGAAATATACT');
INSERT INTO its1_sequence VALUES(188,'f257387dee3a31332a4a2f39c11a54cf','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAATAAACTTTCCACGTGAACCGTCAACCCAACCAGTTTAGCGTCATCTTGTGTGCGTCTTTTCTCGATTGCTTTTTAATTAAATTGCGAGAGAGGGGAAACAAGCGCAATTTAGACAGAACGAAGGTCGAGCTGTTTTTCTATTCGTAGTGAGACGGCTTGGCTGATTTATCCTTTTCAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(189,'06d53952668adb0008128c3613112e2e','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTCTCCGCGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(190,'5641d474912b437f90ae4af8cca5139a','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(191,'0eee3ae6092f08f69963d7c417034086','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGATCTGGTGTTTTGTGATACTGGATCGGGAGTGAGCAGGACGAAGGTTGGTCTCGTAATGTAAATTGTGGGACTAGCTGATGCATTCGTTTTTTCAAACCCTTACCTAAATACTGATTGATACT');
INSERT INTO its1_sequence VALUES(192,'3b916ca14070e375adbe8069a72a888d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTCGTTGGCGGCTGTTGCTGGCATGTTTTTGCTGGCTGGCAGCTGCTGAGTAAGCCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(193,'c6c3999113602df0d684348261478b43','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(194,'468dc60921568e6ca5c197d04032eb44','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(196,'d8b485933dbde7387d58cf825bba6ec1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCATAAAAACTTTCCACGTGAACCGTTACAATTATGTTCTGTGCTCTCTCTCGGGAGGGCTGAACGAAGGTAGAGCTGCATGTAAAAGTGCGGTTTCTGCCGATGTACTTTTAAACCCATTCACACTAATACTGAACTATACTCCGAGAACGAAAGTTTTTGGTTTTAGATCAATAACAACTTTCA');
INSERT INTO its1_sequence VALUES(197,'1cee4bf5c654f172587bb1fb745f55e2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGGTGGTGCGTCTGGGAANCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGNGTCGTCCTGGACACGCTGTCGATCGGAGTCGGCTAAACGAAGGTCGGGCGTCTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTNTTTCAAACCATACGTGACGTACTGATTATATCT');
INSERT INTO its1_sequence VALUES(198,'3b173718adfdb6e41fd6c5770548c30a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAAACTTTCCACGTGAACCGTTGTAACTAAGTTCTTGTGCTTTCCTTTCGGGGAAGGCTGAACGAAGGTGAGCTGCTTAATTGTGGCTTGCCGATGTAACTTTTCAAACCCATTTTTACTAAATACTGAACTATACTCCGAAAACGAAAGTCTTTGGTTTTAATCAATAACAACTTCAG');
INSERT INTO its1_sequence VALUES(199,'3118884f9c8741b6be923f0fac7dbfcf','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTGTAACTATGTTCTGTGCTCTCTTCTCGGAGAGAGCTGAACGAAGGTGGGCTGCTTAATTGTAGTCTGCCGATGTACTTTTAAACCCATTAAACTAATACTGAACTATACTCCGAAAACGAAAGTCTTTGGTTTTAATCAATAACAAC');
INSERT INTO its1_sequence VALUES(200,'0df7f90c31099085afd275f076c2a588','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGAGCTTCGGCTCGAGCTAGTAGCTTTAATTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(201,'8328540b8b3ad6f06442b5be8688da47','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAATACTTTCCACGTGAACTGTCTTACGAGATTCGCGCCGTGACGTGTGTTGTCGCTGCGTGCGCTGTATTTATATAGTGCGCATAGCGTCGACTGCGTGGGTCGGCTGATCGAAGGTCGCATTGTGCTGTATTGCGCAGTGTGGCTGACTTATTCTTTCAAACCCATTCCTTCATTACTGATTCATACT');
INSERT INTO its1_sequence VALUES(202,'b1437c5cb42f4ca4b1451769f61411fb','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAATCCTTTCCACGTGAACTGTCTTACGAGATTCGCACCGTGACGTGTGTTGTCACTGTGTGTGCTGTACATATATATATGTATGGTGCGCATGGTGGCGACTGCGTGGGTCGGCTGATCGAAGGTCGCATTGTGCTGTATTGCGCAGTGTGGCTGACTTATTCTTTCAAACCCATTCCTTAATGACTGATTCATACT');
INSERT INTO its1_sequence VALUES(203,'f252faaf78caf9a3d02577d562593a2f','TTTCCTTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(204,'b3c1fb99eca1959f32d6d514afd8f765','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(205,'0a22e0be09570d2d5f3622188dc9b80c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGGGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(206,'ed5b93072af57d34851564d0417bde50','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(207,'189e9cd1ed790d20ea3616cdae209150','TTTCCGTAGGTGAACCTGCGGAAGGATCATTTCCACACCTTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(208,'0f5434e268d592c8e8879e9062d60419','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(209,'e0263a8f47c37a4ce0b8e188cf488de9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(210,'85537de69bca6eed39b0db1d5308bf03','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGCCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(211,'c8dab198b98ba03720142cdfc778d4ff','TTTCCGTAGGTGAACTTGGGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(212,'5a5b313bf7de860d163445c8bd9e02c1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAACTTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(213,'0d8f066ff9b4958fb217fc45baf3edf4','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACCTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(214,'e33d51c1dcd3d26d01f27ddf2280a40b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGTCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(215,'a5e7459087f6628b1011045a18099552','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGTCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(216,'abbd658918a5b375bb9cdf763e2c32d9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTATAATGGGTTGGTGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAATTACTGAAATACT');
INSERT INTO its1_sequence VALUES(217,'96a5fa947b6fe404820922a66387ce10','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTTGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(218,'fb9355a99ecb412246ea04de8eadedd9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGTCTCGGCCTGGGTTAGTAGCTTCTCTTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(219,'ceedcd60e6e02a713ec00ed3d5e5a2eb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATTCCACGTGAACCGTATCAACCCCAAGTTGGGGGTTTCATTGGCGGCGGCTGCTGGCATCTTTTTGCTGGCTGGCTACTGCTGAGAGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTATTATAAACCCATTCCTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(220,'ba4392a2e3199f77b7ac3dece0eadc36','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCTTGAGCCTTCGGGTCTGAGCTAGTAGCCCACTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(221,'b57a74bfa1a8a5f9141f0d02f8ebeb1f','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCTTGAGCCTTCGGGTCTGAGCTAGTAGCCCACTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(222,'695e24b21aaa4c2c50a949d7862217d5','TCCGTAGGTGAACCTGCGGAAGGATCATTACACACTAAAACTTCCCACGTGAACCGTATCAAACCAATTCATTGGGGGTTTGTTTGGCGGCGGGCTGCTGGCATCTTTTTGCTGGCTGCTGCTGCTGAGCGAGCCCTATCATGGCAAGCGCTCGGACCTCGGTCGGAGCTAGTAGCATTCATTTTAAACCCATTCCTAATGACTAAATATACT');
INSERT INTO its1_sequence VALUES(223,'af5522eac4c6d9f8b1e75ad37e8b0335','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTAATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGTGATCGTTTCAACCTCGGTTGAAATAAGTAGCTAAATTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(224,'9054bf901cfe5dbdd5ac56468bebcb93','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAACTTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGAGCATTTCGACCTTGGTTGAAATGAGTAGCTAAATTTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(225,'b3b5ea72cd147541dfa6cba860a8c0dd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTCCACGTGAACTGTATCAAACTTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGAGCATTTCGACCTTGGTTGAAATGAGTAGCTAAATTTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(226,'26029e20e8d4bfad564502e525de6321','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(227,'3257c62afa883ce39dc94f3606715be7','CCCGTATGTGAACCTGCGGAAGGATCATTACCCACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGGTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(228,'acecba67b97ef4f0b6c7fc30079db885','ATTCCGTAGGTGAACCTGCGGAAGGATCATTCCCACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(229,'f066fa8f09bbc7ad2c615ff4abc5b73d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(230,'8aac44b365f465a4d1862759d6c2c653','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(231,'fecfb10d71898434fcde9533203c528e','TTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(232,'818fbe16d4878e16fb6e453c5d96fad8','TTTCCGTAGGTGANCCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGTTGTAAACTTGGGCTTCGCCGTTGTTTCCTACTTGTGAGAGAAGGGAGCGCGGTTGGAGGCCATCAGGGGTGCGTTTGTCGTGAATTTATATTTGCGCGAATGCGTCCTTTTGTCAACCCATTTCTTTTTGAAAACTGATCATACT');
INSERT INTO its1_sequence VALUES(233,'f39d1fc4a489aa764020ae6939baad11','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTAACAACCCCTTTAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(234,'3c8cf2635297e7c71b353978a70d5d96','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(235,'6e847180a4da6eed316e1fb98b21218f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(236,'0ddb0e124c655b9f38fe29e666c96ba9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(237,'67c28bffa343eb242b9793b0666845b4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(238,'5f5b7d4fc028c587fca2d4b37a06e935','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAACTTTCCACGTGAACTGTCTTAGCATGTTTTGTGCCTTTAATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCATTCTTAAACACTGATTTATACT');
INSERT INTO its1_sequence VALUES(239,'9b57053b5946075e77b47569325c6981','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGACTTTATTGTTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(240,'b323cdabe8a1af3a8de2e337fb96000c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGACTTTATTGTTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(241,'35429ab6104efdd8f863ea7e3abc511b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTNGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(242,'c2eb091ccfc0deac3dc646365813e9c1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAACTACTGAACATACT');
INSERT INTO its1_sequence VALUES(243,'d77c5bc02785b9ef5cdf3e591dfca7cc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGANCCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(244,'7ec8e52c0b4b5aed0cb532054a969dd2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(245,'91887f2c7c65630f6c3fe33ba4221820','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(246,'5c274a2592e4095b9dd7341a1c0ea817','TTTCCGTAGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(247,'09edb4649c86e99f86c9211ee8512f4c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTNGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(248,'a5e79e809a499ecd876a47267ec06ee9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTTCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(249,'70a650ac5f5794a43c573099fb852aea','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTTCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(250,'46e829a1976bc099d99d76d6f1491ba7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTGTTTTAAACCCATTTCACAATACTGATAATACT');
INSERT INTO its1_sequence VALUES(251,'35b9b7110c578df9dea9deace96ebb11','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATAAACCAAAATTTGGGAGTTTATAAGGTATATACTGCTAACATTTTTATATGCGGTTAATACTTTATAAACTCTATCATGGCGAATGCTTGGATTTCGGTCTAAAGCTAGTAGCTGTTTTAAACCATTAATTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(252,'821ba75e948a627dd19343a8a30be8cf','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATTAAAACTTAATTGGGGACAAATTAGGCGGCGACTGCAGACTTTGATGTTAGCGGTTGCTGCTAGATAAGTCTCATCATGGCGATTGTTTCGACCTTGGTCGGGACTAGTAGCTGTTCTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(253,'d4638b7ab7986355cc759e118950864a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATTAAAAATTAGTTGGGGATTTATCAGGCGGAGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGAGTCCTATCATGATGGCGAGCGTAACGACCTTGGTCGGAGCTAGTAGCTATTTTTATAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(254,'ece86753d3594a7ff9a9316bc75f7091','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATTAAAATTAGTTGGGGGCTTATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGAGTCCTATCATAATAGCGAGCGTAACGACCTTGGTCGAAGCTAGTAGCTATATTTGAAACCTTTACTAACTACTGATTATACT');
INSERT INTO its1_sequence VALUES(255,'16ca2300d2bd222c6c09415bdb0bc1bc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACCTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATTGTTCTGACCTTGGTCGGAACAAGTAGCTAAACTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(256,'44c95e6ffa5637c1f05c5dde3150f28a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTACAGACTTTATTAGTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(257,'55620fe486f5c66a255658024dae9d28','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTACTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACCTTGGTTGAGATTAGTAGCTACATTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(258,'63956cdc186d4157ccb80092c105f143','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCRACTGCAGACTTAATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATTGCGATCGTTTCGACCTTGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(259,'aa6a7d2e66d188ee3251d784b0cd4240','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATCGTTTCGACCTCGGTTGAAATTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(260,'e3bd2c62353f8f35a48f6816a6c241dc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCGGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATCGTTTCGACCTCGGTTGAAATTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(261,'3f84f64fd3e7463c5f4ec98eb5d72acd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCRACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATCGTTTCGACCTCGGTTGAAATTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(262,'4d77b62b389e01f2f74c390cf3ca5c1a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACAGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCAACTTCGGTTGAAACTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(263,'5603cafc041e4cf4622e513e70eac74d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAATTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(264,'5bc32e2e61bc0fd22f299c5fa70734ad','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAACTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(265,'544032f80c151c5c4d616fa8e1f2f250','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(266,'7a57117327960d93fcb6245ee5e5fc03','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGCGGCTGCTGCTGACATAATTGTTGGCGGCTGCTGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACCTCGGTCCGAGCTAGTAGCTATTTTTAAACCATTAATTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(267,'64dcf9f4d953fbbd1e7e02f462117805','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAYTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAATTAGGCGGCGRCTGCTGACTTTATTGTTGGCGGATGCTGCTAGATGAATCCTATCATAGTGAAGTGGTTTGGACTTCGGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(268,'6fed17e532e91bb0c3a761d7341023fe','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAYTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAATTAGGCGGCGACTGCTGACTTTATTGTTGGCGGATGCTGCTAGATGAATCCTATCATAGTGAAGTGGTTTGGACTTCGGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(269,'2cd09e377d564881ac4b99d145f3429d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAATTAGGCGGCGACTGCTGACTTTATTGTTGGCGGATGCTGCTAGATGAATCCTATCATAGTGAAGTGGTTTGGACTTCGGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(270,'3cccb1f9781a76016a34c91c98803a21','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAATTAGGCGGCGACTGCTGACTTTATTGTTGGCGGATGCTGCTAGATGAATCCTATCATAGTGAAGTGGTTTGGACTTCGGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(271,'275ec227f84ad7e0c84b51317cf2dee2','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCTCCACGTGAACTGTTGTATCAGATTAGCGCCAAGATTTTCGTGCGTGTTTGTGGTATCGCTATGTATTCGTACGTGGTGTTAGCAAGCATTGTATGGAGCTTGGCTGATCGAAGGTCGGTGCGCACCTTGTGTGTGTATTGGCTGATTAACCTTTTAAACCCTTTCAATAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(272,'a2bc846b75dcb286fcdf181f6eaed772','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCTCCACGTGAACTGTTTGTATCAGATTAGCGCCGAGATTTTCGTGCGTGTTTGTGGTATCGCTATGTATTCGTACGTGGCGTTAGCAAGCATTGTATGGAGCTTGGCTGATCGAAGGTCGGTGCACACCTTGTGTGTGTGTTGGCTGATTAACCTTTCAAACCCTTTCAATAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(273,'044db8a32bb000180f4a65e171681185','TTTCCGTAGGTGAACTTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(274,'05f6d966e58d6da27438709ca9cb2695','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(275,'3d944f84b8274a67241746a7826f4100','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGTTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(276,'3b7f032192e8c231037d1f1c9879f267','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(277,'84f30676996cdabaa4e9ad2f1e2577d6','TTTCCGTAGGTGAACNTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(278,'703b081e2ba3492355ffc2d089676dc2','TTTCCGTAGGTGANCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(279,'fb594e9f7314902b3630670cc1744e67','TTTCNGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(280,'aeece02ad2d9cccf8131ceb1ef8d638b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(281,'a0d9bbe111ffe197b559440df53e1a35','TTTCCGTAGGTGAACNTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATACT');
INSERT INTO its1_sequence VALUES(282,'96e0e2f0475bd1617a4b05e778bb04c9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(283,'9ba3657d5ecb7d8f35ce7f5feacbc3f7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(284,'81ddb943bcc0de589f73020a3c670f4c','TTTCCGTAGGTGAACNGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(285,'606fb0b056b4b80c38cbba24fddce3a5','TTTCCGTAGGNGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(286,'a7360f237aa7135ba3ecc13a44b1f1ed','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(287,'78089b51075c8bc137d4aec53e4eefc0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTNGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(288,'409ad8cbf29bfb895d4782bd2cc5faed','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCTTGCTCTGGCGTGCGGCTGTTGACCTGTAATGGGCTGACGGCTGCTGCTGGGCGGGCTCTATCAAAGGCGAGCGTTTGGACCTCGGTCCGAGCTAGTAGCTTTACTTTTTTAAACCCATTCTTTACATACTGAATATACT');
INSERT INTO its1_sequence VALUES(289,'426911b323b1ddad56e09dfa290bf04f','TTTCCGTAGGTGAACNTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(290,'79b4ce1cdc03ee2e9af377e6de9223a7','TTTCCGTAGGTGAACCTGCGGAAATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(291,'707626c1f9f65dfa85432685fdb06cd9','TTTCCGTAGGTGAACCTGCGGAAGGCTCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCNGTATTTTTTAAACCATTCCTAATTACTGAAAAAACTT');
INSERT INTO its1_sequence VALUES(292,'3128796eef17cbcd3ad3b1e5a9797451','TTCCCGTAGGTGAACCTGCGGAAGGCTCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATAACTTTGTTTTTAACCCTTACCTAAAACTATTTATACT');
INSERT INTO its1_sequence VALUES(293,'9ce3eccef73d8b4725b1938cc8f5568b','TTTCCGTAGGTGAACCTGCGGAAGGCTCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCAGTATTTTTTAAACCATTCCTAATTACTTGAAAAAACTT');
INSERT INTO its1_sequence VALUES(294,'03db0b23fe1682ed026a92b09bdea01e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTTGATTTATACT');
INSERT INTO its1_sequence VALUES(295,'03d98fbad6045a2c8bd15d861cfa16b1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGTATTTTTTAAACCATTCCTAATTACTTGAAAAAACT');
INSERT INTO its1_sequence VALUES(296,'b757fdd9c830990ea1f90d16dc935762','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(297,'a65a2cf7dc2f2cb28bd56a585ff0a7d0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(298,'9efb8bb971e5320b1da23ce10f2c354a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGNCTTTATTGTTGGCGGCTGCTGCTGGNCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(299,'a89c5be6cf14173b0c7ac57c941fb29f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(300,'bba05d4d4aac8b7ccaa286afad44acb4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(301,'38a7928f5fd9f7b4ca9c4636b55c2d15','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(302,'f2a6a813f6f006452afa0be752b9aa2f','TTTCCGTAGGTGAACNTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(303,'11b74237bf44899f24ace62be657172a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(304,'6b314f83ce021591cfbf595337040b86','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(305,'dcedc83a57776c9594d28c2dec55dffe','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGCTTCTGTTCGGCTGGCTTTTGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCCTGGGCCTTCGGGTCTGAGCTAGTAGTCTTCTTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(306,'0c2322caa3d7c51a5b8e79272a1f71b1','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(307,'4d15b99abf01573c46c675f8c7f4b80b','TCCGTAGGTGAACCTGCGAAGGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(308,'d88fafb4c053cca34831650e33e56dab','TTTCCGTAGGTGACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTGGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(309,'703e4af16de0fb6f326b7050580088be','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(310,'c3ec33641d1ff129d8e5ba75084fdfac','TTCCGTAGGGAACCTGGGGAGGGATCATTACCACACCTAAAAACCTTTTCCACGTGAACCGGTTTCAACCCAATAGTGGGGGGTCTTACTGGGCGGCGGCTGCTGCCTTTATTGCTGCCGGCTACTGCTGGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(311,'9b64fd9f0780dd0feb28abc6a1a03f07','TTTCCGTAGGTGAACCTGGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(312,'db7883ca7a5baacaf4e322a5eb022d68','TTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(313,'578710db0966a4dc8019aca35a5a2568','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(314,'631509780f0391507ec0a77bcfbdd13b','TCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(315,'c6b909637840e252a1df1bc23d90624f','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(316,'976eb3744da68f5e28e674b26c8b4d0f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTTCCACGCTGAACCGCTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(317,'0f4154c98a01cb08fb18f090d51f3c9f','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(318,'97a6b4745c13545c7f3341f36be584d1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(319,'2e030f23eb72e967fff36b8f57e83ef6','TTCCGTAGGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(320,'4d02336870bbc3fb5a720938b1b5d4c6','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(321,'98d90d2cf6a19318abb1d7b767015945','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(322,'fcfcc1044d784d86620a53c606935300','TTCCGTAGGTGAACTGCGGAAGGATCATTACCACACTTAAAAACTTTCCACGTGAACCGTTTCACCCCAATAGTTGGGGTTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGTTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(323,'359e7c4596b5ad023dffe21b41afa963','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTACTGGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(324,'a8ee42751dca99de7d353dde9053d9a2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(325,'bae80cfc18bc8b8089221aa8d7fb0c1a','TTTCCGTAGGTGAACCTGCGGAGGACATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTAGATTTATACT');
INSERT INTO its1_sequence VALUES(326,'8b7ec3f98d6fa904dee73e2a9b5f4b5d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCGCTGGTCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTTGTAAACCCTTTTTACTATTTTCTGATGATACT');
INSERT INTO its1_sequence VALUES(327,'9ea2f65e5d94a2adbe60fb0728cdb377','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCAACATAATTGGGGGTTTATTTGGCGGCGGCTGCTGGCATTTTGTGCTGGCTGGCTGCTACTGGGCAAGCCCTATCGCGAGCGTTTGGGCCTTGGCCTGAGCTAGTAGCTTTTATTTTAAACCATTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(328,'0007d64cf0fc6d78095351cb39323335','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGTCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(329,'0557224e2fdca9647380562657d854d4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCTCCCCTAAACAACTTTCCCCGTGAACCGTATCCACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGACGAGATAGCTTTTTGTTTTAAACCCATTTCTCAGTACTGATTATACT');
INSERT INTO its1_sequence VALUES(330,'70f559ad623a00ec20743c67f79f983e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGACGAGTAGCTTTTTGTTTTAAACCCATTTCACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(331,'aeda52b90bcd3d061a434df95f4508d3','TTTCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACTTTATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(332,'77eaaee8b5e011b45671be7f44c3c674','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTGGGGGGCGTGCCGTTCGCGGCGGCTCCATCAAACGAGGCCCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(333,'0238a15a2f2dbb5eafd4edd4965e9e48','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCGCTGGTCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTTGTAAACCCTTTTTAATATTTTCTGATGATACT');
INSERT INTO its1_sequence VALUES(334,'9941e83036c615f524c8148d2aaaea39','TTTCCGTAGGTGAACCTAGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(335,'eb8113a30581951505a4943f00173b54','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(336,'d25ca50dbc97548c6d29d0c9a1b085e9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGAGCTTGTTTGGCGGCGTGTGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(337,'43ffd9318141f025b3fd8c0bdb44ed13','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(338,'f4ab19ea587564f4a73de8675d4ee929','TTTCCGTAGGTGAACCTGCGGAAGGATCATTTCCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTAGTTGGGGGTTTAATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACTTCGGTTGGAGCTAGTAGCTTGTATTTTAAACCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(339,'6a553fbb4c02acf49d0842e5bd5168f3','TTTCCGTTGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(340,'94af1852cb2de2d92cadaa416feaa9a7','TTCCGTAGGGTGACTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCRGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(341,'e9f8bf83d9d9998b28a218dedebd4bb4','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCGTGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(342,'ba38d44bddc3017e4e1e04ada49165ea','GTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCAAAAATCCTTTCCACGTGAACTGTCGTATTGATTCGCGCCGTGACGTGTGTGTCGCTGCGAGTGCGTTCGTGCGTGCGTCTTCTTGGAGATGTGTGCGCGAGTGCGCGCGTGGCGTCGACTGCGTGGGTCGGCTGATCGAAGGTCGCTTTGTGCTGTCTGGCGCGGAGCGGCTGACTTATTCTTTCAAACCCATATCTGTAGTACTGAAACATACT');
INSERT INTO its1_sequence VALUES(343,'9d87ebed2edc09847cb26077b6d8765f','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACTTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(344,'c4c1e775d64914a228498df57ec3a2d9','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACTTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(346,'104be96dea7edb9bb1955ff4bd6ad1b3','GTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCAAAAACAACTTTCCACGTGAACTGTCTTACGAGATTCGCGCCGTGACGCGTGTTGACGCTGTGTGTGTTTGTGTCTTCTTTCGAGAGGATATTGTGATGCAAACAGTGTTGACCGTGTGGGTCGGCTGATCGAAGGTCGCTTTGTGCATTATTGTATGGAGCGGCTGACTTATTCTTTCAAACCCATTACACAATACTACTGATTCATACT');
INSERT INTO its1_sequence VALUES(347,'d8efc82596d277fbcac3ca2c6e5ed44f','CTTCCGTAGGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(348,'cbbf2db424c839609c5b16a6cf1f640b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCAACAAATTGGGGGTTTGTTTGGCGACAGCTGCTGGCATCTTTTTTGCTAGCGGCTGCTGCTGAGCAACCCTATCATGGCGAGCGTTCGGACCTCGGTCGGAGCCAGTAGCTTTCATTGTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(349,'0cc6b9e59b8172d8400acbef1265bf1c','TTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(350,'f44ceb8cd2c1e6b8f9fee417118a1dff','GTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTCTGTCCGTTTTGTGCCGTTGCTGTGTCGGCGTTTGTCGAGAAGAGCAGTGGCTAAACGAAGGCTGTGAGCTTTGTTGCTTGCGGTCGATTTACTCTTTCAAACCCCATACGTTAAGAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(351,'a2c541e717c27592983da94f0574883b','TTTCCGTAGGTGAACCTGCGGAAGGATCATCACCACACCTAAATAACTTTCCACGTGANCCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(352,'97d704573f84ecd81c3c7f2bd8cfe768','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCNTGATTTAGTAGTCTTTTTTTCTTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(353,'a46e3698664f663c18def5a8008bf034','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(354,'c706fbf2a393612ee9b81b52b69d60f4','TTTCGTAGTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(355,'45aaf5b5e3448f8608ed9a836aac5f21','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACTCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(356,'a75471225c256d99ae2fa877a402307d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCMTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(357,'a6d37168c367f12441e4c50a42d7485f','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(358,'d2ab6ab527a7252b3a6b44e7e2c0521f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(359,'d9c6ea4551c68ac939a80b5118238a6d','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(360,'2b0fb8f896789112752902da4388b9ab','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(361,'e71071d698a48898827e3e8408e4936a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(362,'e0f43da2346edf0c8b402dadee5452d6','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCTACTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(363,'5a5bec99f665f2649af2fbc00fee48ec','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGCGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATACT');
INSERT INTO its1_sequence VALUES(364,'c62665f8bb267be1cb4fb5b8f9b1cbbe','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTGTCGATGTTGGGGCGTGCTGGGCGTGCGTGTTTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGYGTTCTTTGTTACTGTTTTAAATCCTTCTTRTAGACTGATTGTACT');
INSERT INTO its1_sequence VALUES(365,'9088dc4d4b53e41876bcbbc328daea9c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTGTCGATGTTGGGGCGTGCTGGGCGTGCGTGTGTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCGTTCTTTGTTACTGTTTTAAATCCTTCTTATAGACTGATTGTACT');
INSERT INTO its1_sequence VALUES(366,'076cc341940e9457a686d9af642e4c60','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTGTCGATGTTGGGGCGTGCTGGGCGTGCGTGTGTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGYGTTCTTTGTTACTGTTTTAAATCCTTCTTATACACTGATTGTACT');
INSERT INTO its1_sequence VALUES(367,'38ee2b1c022e0281a31ebd92cba0eaaa','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAAAATTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGTGGCTGTTGTTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(368,'1b31fdd8ad336e8c1689a582f491d0ba','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(369,'2e06d5cacfd23669f60f3be9f89bbf84','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTYTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(370,'05b3bcfc073ea8dea040becdc3d1c682','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(371,'8383a2adb59ec462a368cec481980f55','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(372,'48a56b5bc7960f7a3abf27155d746743','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTCTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(373,'f0a3c5aae76eb46fd57bea4877f384a4','TTTCCGTAGGTGAACCCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(374,'c19a5c2ec79b91912351f2bda62d82d4','TTTCCGTAGGTGAACCTCCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(375,'6f0043db557f51fd8b3b3d55e61b785d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCYGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(376,'b142870e537d9894344f9ba9fd3b02e6','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(377,'4b3128660945b4c813c8ab1f3492e590','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTAGAAACTATCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(378,'c17e132009b5dd541ffc9f5cbf220c5c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(379,'5f430b56aa9cbd8b7e2313645ab8d33a','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(380,'af921f0c69e7c4fd68ea7c8ea981f1f4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(381,'bd445bdaa983dab945bc502fa286d63e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGACGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(382,'2856efcce50f73d0869b56a3a11573c8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACATAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(383,'9003de7226966a0ed7bf98f6d874b89e','TCTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAACTCCTTTCCACGTGCACTGTCTTACGAGATTCGCGCCGTGACGTGTGTTCTCGCTGTGTGTGCTGTATGTATGTTTACATATGTATGGTGCGCATGGTGGCGACTGCGTGGGTCGGCTGATCGAAGGTCGCATTGTGCTGTATTGCGCAGTGTGGCTGACTTATTCTTTCAAACCCATTCCTTAATGACTGATTCATACT');
INSERT INTO its1_sequence VALUES(384,'2f6368a968d8a9d69b3bec7d6567af9d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAGCTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGCCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(385,'febde0e5e3c64ca579a4271a98147af3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAGCCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(386,'e3419d8a8b442a8fe8d7b6be670a813e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGACGGTAGCTACTGGTTTTCTACTGGTGGTAACTATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGTCTGACGTAGTAGAATAAATTTTAAACCATTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(387,'9d4a4a383efe798c04b520bebe68fe35','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTATCCACGTGAACCGTATCAACAATTATATTTGGGGGTGATCTTGGTGGTGCTACCAGTCTCTGACTGGCGGCCTACTGAGTGAGCCCTATCATGGCGAACCATTAGGCTTTGGTCTGATGTAGTAGTAAATTTTTAAACCCATACCTAATTACTGATTTACT');
INSERT INTO its1_sequence VALUES(388,'273216ec7b0fdebeaa0777360305e5b3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAATTATATTTGGGGGTGATCTTGGTGGTGCTACCAGTCTCTGACTGGCGGCCTACTGAGTGAGCCCTATCATGGCGAACCATTAGGCTTTGGTCTGATGTAGTAGTAAATTTTTAAACCCATACCTAATTACTGATTTACT');
INSERT INTO its1_sequence VALUES(389,'ed286291132771717b7215691bff93b1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACTTTATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(390,'0ff1f8b33fd6580576d13bb42a9614d1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(391,'5dade03ea56d839c93134d4f85de86c4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGTTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACTCCTTTCTTAAAAAACTGAACATACT');
INSERT INTO its1_sequence VALUES(392,'51f0cbc65e13865f7a36ee073ac5e0ab','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTWAATTTGGGGGCTTGYTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAMTTTTAAACTCCTTTCTTWAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(393,'69eb2a483b767127e98ff2d79ce8dc0f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGTTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACTCCTTTCTTAAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(394,'a829d569a7edc749cb86a111f687e10f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTGTTGAGCTTGGGGCGTGCTGGGCGTGCGTGTGCGTGTGGCTTCGGCCGCGTGCGTGCGYGTGTTYGGCGTGCTCATCAAACGAAGAGGCGGGTCGCAAGGCCTGCTTTGGTAGTTACTTTTTTAAATCCTTCTKTWWAACTGATTATACT');
INSERT INTO its1_sequence VALUES(395,'64c33b1964919f78247f44b83ce152ff','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTGTTGAGCTTGGGGCGTGCTGGGCGTGCGTGTGCGTGTGGCTTCGGCCGCGTGCGTGCGTGTGTTTGGCGTGCTCATCAAACGAAGAGGCGGGTCGCAAGGCCTGCTTTGGTAGTTACTTTTTTAAATCCTTCTKTWWAACTGATTATACT');
INSERT INTO its1_sequence VALUES(396,'a9e9ff04cca5ffb6f780c2e657c95337','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTGTTGAGCTTGGGGCGTGCTGGGCGTGCGTGTGCGTGTGGCTTCGGCCGCGTGCGTGCGTGTGTTTGGCGTGCTCATCAAACGAAGAGGCGGGTCGCAAGGCCTGCTTTGGTAGTTACTTTTTTAAATCCTTCTTGTTAACTGATTATACT');
INSERT INTO its1_sequence VALUES(397,'3506613f7d1c8fcd7f4d3838c6d3d1d4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGTGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTTGAGTGTGTGTTCGCATACAATTAAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(398,'1dd4277036f006f4c82ec1a64eb83a01','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(399,'9fc2d9f990c21adc1e55c14e46757dc7','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(400,'b699b6e6e8dfebe5ffdf5403b3b2c799','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(401,'72376b730437eb12e0ec1935392f48ee','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTGAAATCTTTCCACGTGAACTGTTGGGATTGCCGTTGGGCATGACGTGGGGCTTCCGTGCTGCTTTGCGGTTTTGCTGCTTTGCGCGTGGAGGCCCCGTCTGGGTGTTGCTGTGCCGTTTRGGCTTGGCGGTGCCTGGCGCCTTTTTGTTTTGAACCCGTTACGTAATGACTGAGTATACT');
INSERT INTO its1_sequence VALUES(402,'dcd6316eb77be50ee344fbeca6e005c7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCTTGAGCCTTCGGGTCTGAGCTAGTAGCCCACTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(403,'353f176534f3c4af3bc936a03a56ed22','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCAAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(404,'75a4b4c171ecaf3e4b3ca04060d3e310','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTTCATGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(405,'2f13a21c7b20c2fe0bf9757b5b8c814d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACYCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(406,'419ba098165eeae2cbe3d90569b521ce','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTCCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(407,'cab2875a481e358a4993910872ec53a6','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGTCCTGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(408,'b224f508faf26009511efd4b55970f08','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGYTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(409,'9d9730d2e14c109f91f4218672a05b08','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATTAACCAAATAGTTGGGGATTTGCTAGGTAGTGACTGCTGACTTAATTGTTGGCTGTTGCTGCTAGGCGAATCCTATCATGACGAGCGTTTAGACTTCGGTCTAAGCTAGTAGTTATTTTTTAAACCATTCATAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(410,'af06b9143985bbf5c0b28bf3ff4623bd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAATATCACGTGAACCGTTTCAACCAAATAGTTGGGGATAAATTAGGCAGCGACTGCTGACATTACTGTTGGTGGTTACTGCTCGATAAGTCCTATCATAGTGAAGTGGCTTGGACTTCGGTCCGTGCTAGTAGCTATTTTAAAACCATTACTAAATTCTGATAATACT');
INSERT INTO its1_sequence VALUES(411,'590f1647264759ee155e9cad57bff622','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTAGTTACCCGATTAGCGCCGCGACGCGTGTCTGCGATGCATGTATGTGTGTTGTGGGCGTGTGGGCTCGGCTGATCGAAGGTTGTCGTGCCTGTTTGTGTTGCCTTGTGCGACGCGAGCGTGTGCGCGGCGGCTGACTTATTCTTTCAAACCCCTTACTTTAAAACTGATGTATACT');
INSERT INTO its1_sequence VALUES(412,'5a0d68fbfc03a3c7c1034f353dd63419','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(413,'5299cbe2a369a605a0b42070f0f954a6','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(414,'6abf31007c1f26561b4fd535e4b6c58a','ATTCCGTAGGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(415,'7dd27e642851130aaa95e40ea03f9103','CTTCCGTAGNGTGACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(416,'00efbfbaadb2fe542966870b75609af2','CATCCGTAGGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(417,'2c8d07bfb6d825695123cfa268f01132','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(418,'25c9901e30366642996b2e1a1676665f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(419,'af3282a9797a70b6922e29e68c0b2bdc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(420,'0bca08a93b59b84a4339100bd86cd0c3','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACTTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTTCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(421,'aa5ee9d565f1b48ef682693634088b40','TTCCGTAGGTGGAACCTGCCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(422,'63e1f4c32faa22ba141e9b8b7bc61d43','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTCCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(423,'d279b80c995a8bf2992fd0ccd7bd5521','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCCTTGCGCAATTGAAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(425,'9075894e545142d7bc05d7fec6c89003','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGCGTTCTCTCTGTTTTGGGGGGAGGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTCTTTGATAACTGAAACATACT');
INSERT INTO its1_sequence VALUES(426,'85ed4e1cc97faa97133272abfa0109e8','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTTTTCTCTCTCTCTTTTGGGGGAGGGGATGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTTTTTGATAACTGAAACATACT');
INSERT INTO its1_sequence VALUES(427,'e194320f9bc5d39db54c071e7bae1acb','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGATCTGGTGTTTTTGGATACTGGATCGGGAGTGAGCAGGACGAAGGTTGGTCTCGTAATGTAAATTATGGGACTAGCTGATGCATTCGTTTTTCAAACCCTTACCTAAATACTGATTGATACT');
INSERT INTO its1_sequence VALUES(428,'f665558f726d4cd876844a10f698751c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGYCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(429,'931f8ea73c055c156ef36db9adf648d0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(430,'6a5735e3565bb831a73114b1ab33a52d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGTCTTGCTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(431,'662d837e3c52d7b1eda8f84c9a12f887','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGGTTGGCGATGATCGCTAACTTAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(432,'a3a2d4d1a20702ec081912e41503c3af','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAAGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(433,'bcc38dc6454cb609f6d6aa19563d9cfc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGGTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGATAAGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(434,'3ab5216ed6be7d2629fd65d6a07b6ad2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGGTTGGCGATGATCGCTAACTTAATTGCTGGTTGATTACTGCTAAGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(435,'3cda763a7e9d996246ad9e6795dd7068','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGGTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(436,'be0b430fcfe0f2476561ad9c8be71d41','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGATAAGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(437,'358546744ed88ab7015585c45bb85f76','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGATAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(438,'fda4226e454c44e1935dda95eba0ac0e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGGTTGGCGATGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAAGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(439,'0bb8743153006d1faf9767aec6260fb0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAATCTTTCCACGTGAACTGTTTTTGTAAATTTGGGCTTCGCCTGCTGCGTTCTTTTACCATTTAATTATTTATTTTTTTCTTTGGTGAAGGAATGCGACGGCTTGAGGCCATCAGGGTGCGCTTGCTTGGTTACTTTTGTTTGTACCATTCAAAAAAATGTAATCGAGCGAGTGCGCTCTTTGTCAACCCATTTCTTTTGAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(440,'3dd3b5989ee07ed2d2b3fac826dbb94f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGCTGTACCTTTGGGCTTCGCCGTTGTCTTGTTCTTTTGTAAGAGAAAGGGGGAGGCGCGGTTGGAGGCCATCAGGGGTGTGTTCGTCGCGGTTTGTTTCTTTTGTTGGAACTTGCGCGCGGATGCGTCCTTTTGTCAACCCATTTTTTGAATGAAAAACTGATCATACT');
INSERT INTO its1_sequence VALUES(441,'e16426989a336ad828be4cb4d6d55db7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAACTGTTTTGTAAATTTGGGCTTCGCCTGCTGCGCGCTTTGCTTTTTCGTGAAGAGTGCGACGGCTTGAGGCCATCAGGGTGCGCTTGCTTGATTTTTTTTGGAATCGGGCGAGTGCGCTCTTTGTCAACCCATTTCTTTTGAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(442,'520dd408b1c8c34d572f886dfc82d946','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACATCTTTCCACGTGAATTGTTTTTGTTGTAAGCTTGGGCTTCGCTGTGTGTGTGCGCTTGTCGTACCATCGGTTTGAGGCCATCAGGACTTGTACGAGTCCTTCTTTGTAAACCCATTTCTTTTGTTATTATTAAAACTGATCATTACT');
INSERT INTO its1_sequence VALUES(443,'501ce547299e7c41f30976431e3d9c22','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAACTATCCACGTGAACCGTTTGTACCAAGATTTGCGCCGAGATGTTTGTGCGTATTTGTTGTATCACTGTGTATTCGTACGCGGTGTGTGTCAAATATGTATGTCGCTTGGCTGATCGAAGGTCGTATCGCACTGTATTGTGTGTGTCGGCTGACTTATTTTTCAAACCCATTCTTACATACTGATTATACT');
INSERT INTO its1_sequence VALUES(444,'9453c342aac20b69a9f6fe68c1bb2512','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCCTTTTTGTTGTTTTTTCGTATTGTTTTTTTTTTTTAAATGAAACGGAGAATAACGGAAGGCTAAACGAAGGCTGCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCCATACATTATATACTGAACTATACT');
INSERT INTO its1_sequence VALUES(445,'db6722de2c4890b7ef3d3a6b71db214c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGATGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGAGCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATGATACT');
INSERT INTO its1_sequence VALUES(446,'61256721c23efaa9da67878f020c7d33','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTTTGTACCAGATTAGCGCCGTGACGTGCGATTGTTGTTCTTTTTTGCTGCATATGTGGCGACAACGATTGTGCGGACGCGGCTGATCGAAGGTCGTGTGCGTGCTAGCGCGTGCTCGGCTGACTTATCATTTTCAAACCCCTTCTTACTTTAACAACTGATCTTTACT');
INSERT INTO its1_sequence VALUES(447,'277e9b888a70dd3e5fbfa2935ce20971','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAACTTTCCACGTGAACTGTCTTAGCATGTTTTGTGCCTTTGATTAKGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCCTTACTTAAACACTGATTTATACT');
INSERT INTO its1_sequence VALUES(448,'84c5a8bf81375d6ed827da4ef391b6c8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTATTCACGTGAACCGTCAATTAAACCAGTTTTGTGTCGCGTTGTGTGCGTGTTTTCCATTTCAATTGCTTTTTTTAAACGAATCGCGAGCGAGGAGGAGAAGACAATCGCAATGTCGACTGAACGAAGGTCGAGTTTGTTTTCTATTCGTAGAGAACGAGTTTGGCTGATTTATTCTTTTTCAAACCCTAAATCCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(449,'ab383244716b36871abc7508df043468','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAATCCTTTCCACGTGAACTGTCTTACGAGATTCGCGCCGTGACGCGTGTTAGCGCTGTGTGTATATGTCTGTGTCTTCTTTCGGGGAGATGTGGATTGTGTGCACATGGTGCTGACTGCGTGGGTCGGCTGATCGAAGGTCGCTTTGTGCTGTATGTATAGTGCAAAGTGGCTGACTTATTCTTTCAAACCCATTACTCAATACTACTGATTAATACT');
INSERT INTO its1_sequence VALUES(450,'690d1f0ee357088ae511715e717d9b2b','CTTCCGTAGGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTTCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(451,'a04a413be08d7e9a4c4c8e896679298b','CTTCCGTAGGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(452,'42c445a8cf3f97d84d765b972a79f212','GTTCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCGTTGCGCAATTAAAACGTCCAAACCCTTTTAAACCCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(453,'7c4aa61e319a01684ac520d340eae1e2','TTTCGTAGTGAACTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCGTTGCGCAATTAAAACGTCCAAACCCTTTTAAACCCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(454,'5ae632c57e47cf5df40e28c13fbdd991','TTTCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCGTTGCGCAATTAAAACGTCCAAACCCTTTTAAACCCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(455,'c28b086bae183783267aea373e6017a4','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCATGGGCCTTCGGGTCTGAGCTAGTAGCCCTCTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(456,'09a61080fac555762020523d9d0c65d4','TTTCCGTAGGTGAACTTGCGGAAGGATCATTCCCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(457,'7075d38f892326f8f9a73322068d15a6','TCTCCGTAGGTGAACCTGCGGAAGGATCATTTACCACACCTAAAAAACTCTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(458,'2c7490e46e89d73eb484cbeadbb0547b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTATCCCACCTAAAAAACCTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGGTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(459,'8a7b3ba717cc915bea47c8014e8e4c98','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(460,'92c29bc27345a49ab5cba840ac4a01f5','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(461,'d61e6c80f717f3105619e6a026f7058c','CTTCCGTAGGGTGAACCTGCGGGAAGGATCATTACCACACCTAAACAACTTTCCACGTGAACCGTATCAACAAGTAGTTGCGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(462,'fd195011543e7136a047dfe60140db7b','TTCCCGTAGGGTGGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(463,'25269a233837ab8bb0bc14e27374325b','TTCCCGTAAGGTGAACCTGCGGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(464,'9658301642ee9b858160b9a549e98dfc','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(465,'c11f90edae716b4b780ec14c67492c4d','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCTTGAGCCTTCGGGTCTGAGCTAGTAGCCCACTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(466,'955a02294bda1d76a622148d3d9b434e','CCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(467,'f6a0f223ba6612a08dacc0d5aed1376f','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(468,'2f4efde9c1dd2b2be46b56d546ba31de','TTTCCGTAGGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(469,'f290875068ce712a4c4540ec9a952f35','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTATTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(470,'cccc5940b8faac002d4a919653736c2e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGTGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTTGAGTGTGTGTTCGCATACAATTGAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(471,'5a458880acf3c93daa0874ab0dab14d0','TTTCCGTAGTGAACCTGCGGAAGGATCATTTCCACACCTAAAACACCTTTCCACGTGAACCGTATCAATCCAATGAGTTGGGGGTTTATTTGGTAATGGCTGCTGGCATGTTTTATGCAGGCTGGCTGTTGCTGAGTAAGTCCTATCGTGAGCGTTTGGACCTCGTCGGTCTGAGCTAGTAACTTGAAATTGTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(472,'a946c62cbec42ee01a9f27cac2641093','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTCAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(473,'a0f16354a0ecc4940972b2aef84a8bb1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(474,'38e9ac5563db2a74294b9db716d52089','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAAYGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTCCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(475,'0df4fff59813ce219204d862ac82162b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGKCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTCCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(476,'e5886806762e2c964d2fcbb23700a053','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTRCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(477,'1890f11e1c00b68914cfa865d05701af','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGYTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(478,'6365b9d59fdaea9e71c336df5b55db66','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCACCCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATACT');
INSERT INTO its1_sequence VALUES(479,'dff82cdd8ded5b1003849d434f9b2d9b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAAACTATCCACGTGAACCGTTTGTACCCAGATTTGCGCCGAGATTTTCGTGCGTGTTTGTTTGTATCACTGTGTATTCGTACGCGGTGTGTGGCAAATATGTATGGAGCTTGGCTGATCGAAGGTCGTATCGCACTTTATTGTGTGTGTCGGCTGACTTATTTTTCAAACCCATTACTTACTACTGATTATACT');
INSERT INTO its1_sequence VALUES(480,'55c0e89766b0decb3b721563c7d584e2','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGCTGTACCTTTGGGCTTCGCCGTTGTCTTGTTCTTTTGTAAGAGAAAGGGGGAGGCGCGGTTGGAGGCCATCAGGGGTGTGTTCGTCGCGGTTTGTTTCTTTTGTTGGAACTTGCGCGCGGATGCGTCCTTTTGTCAACCCATTTTTTGAATGAAAAACTGATCATACT');
INSERT INTO its1_sequence VALUES(482,'be2eb2eea7c3b7cad3594538b48352d8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCTCCACGTGAACTGTCTGATCCGATTCGCGCCGTGACGCGTGCTGCGGGTTTGTAAAAGAATCTGCGGCGTGCGGGCTCGGCTGATCGAAGGTTTCATTGCTGCGAGCGTGTGCTTTTCGGAGCGCGCGTTTATCGGCGGTGGGGCTGACTTACTCTTTCAAACCCCTTTACCGAATGACTGATGTATACT');
INSERT INTO its1_sequence VALUES(483,'0df67e279a276edd7458d432fddd2707','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGCTGTACCTTTGGGCTTCGCCGTTGTCTTGTTCTTTTGTAAGAGAAAGGGGGAGGCGCGGTTGGAGGCCATCAGGGGTGCGTTCGTCGCGGTTTGTTTCTTTTGTTGAAACTTGCCCGCGAATGCGTCCTTTTGTCAACCCATTTTTTGAATGAAAAACTGATCATACT');
INSERT INTO its1_sequence VALUES(484,'eedb1816618a4e690fa397e83c6c8fd0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTAACTGATCTAGTGCTTTTCCTATTTTTGGGACACTGGAATACAGGATTCAGCAGGACGAAGGTTAGTCTCTCGTAATGCAAATTAGGAGGACTAGCTGATGAACTTTTCTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(485,'888e981a2b2846f2f45284af68e441ff','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGTGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTTGAGGCCATCAAGCGGCGTTTTGAGTGTGTGTTCGCATACAATTAAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(486,'a96f466b160c121b875fcea5ba990d63','TCTCCGTAGGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCAAACCGTTTTAGTTGGGGGTCTTGCTTGGCATTTTGCTGAGCCGCCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCATTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(487,'4f6ec6bb5bfe9857d933ff96eb96ced0','TTTCTGTAGGTGAACATGCGGAAGGATCATTACCACACATAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(488,'43f613224a8ab0943a0d34575f41664e','TTTCTGTAGGTGACTGCGGAAGGATCATTACCACACGTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(489,'5f1ac58fe15890d49245861e9031a5f4','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGGGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(490,'3123418326cdbe0ae3f8663adfe6587f','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATAGCGTGCAATTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTAAACTTTTTTTCCCTTTAATACTCTTTTTCTGTGGGGACGTATCTTTTTTCTTTTTTGATTCC');
INSERT INTO its1_sequence VALUES(491,'0779f13c1f00a7d17a438590355dcd75','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(492,'aebf57764e329ea0772a4227caa7774a','TTTCCGTAGATGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(493,'706fa349f33364e400be9cd14236a4f2','GTTCCGTAGGTGAACCTGCGGAAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATTACCAAAGTTAGTTGGGGACTCCCTGTTGTTGGTCGATGTAGCAATATGTTGACCGGCGGCGGGTTGAGACCTATCAAACGACGGCGACGAATGTGCGGGCTGAAAAGTCGGCACGTTTGTTTCTGAAGTTTCTCTTTTAAACTCCTTCTTATTTAACTGAACATACT');
INSERT INTO its1_sequence VALUES(494,'a541ea370f26ebd3abdbb53e792d505c','TTTCCGTAGGTGAACCTGCGGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCGCTGGTCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTTGTAAACCCTTTTTAATATTTTCTGATGATACT');
INSERT INTO its1_sequence VALUES(495,'9ac09b835e9e517eb814cbeb5bbf96b7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCTGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(496,'9bf1f9e07f01983d74280cc4f546eb66','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGCCCTTGGTGGTGGCTCCATCAAACGAGGCCCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTGTTGTAAACCCTTTTGTAATTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(497,'580f8527ff86c4d9141248aa214a024c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAACTTTCCACGTGAACTGTCTTAGCATGTTTTGTGCCTTTGATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCCTTACTTAAACACTGATTTATACT');
INSERT INTO its1_sequence VALUES(498,'7569d70ed6e495569202109ff978aae3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGCCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGGGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(499,'137ccb18340a59821a97c1359e322156','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(500,'ff3f4d95350ee27b4aa7c2116ac5ff19','TTTCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(501,'7f31770b87b54f1ce1d83fc6be9fbae9','TTTCGTAGGTGAACTGCGGAAGGATCATTACCCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(502,'51166230544c4248de315c58446a2d83','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(503,'9625dfc9c662a2d0fe385dd9a01eca4b','TTCGTAGGTGAACCTGCGGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(504,'25246a770a67ef7b29d6274b2765a402','TTTCGTAGGTGAACTGCGGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(505,'1c471fab01d15528a6181215d85e6676','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(506,'c9ffbe55146983661f684c9b22ebd5fb','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(507,'8a0f2eece3abe12c27d34cae6d831139','TTTCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(508,'de307c46f163c26f9d0e0a51b028c83e','TTCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(509,'a648240a0692f31f13181f7519d04523','TTTCTGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(510,'900f431295cb1b61cf5a4817f349e4e8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(511,'f6fdb8abff76857755e50980d8709dc6','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAATTTAAATTGGGAGCGATCTTGGTGGTGGCTTCTAGTCTTTTGACTGGTGGCTACTATTGGGTGAGCTCCATCATGGCGAACCATTGGACTTTGTCTAATGTAGTAGTATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(512,'26dfe6e36479116861fb8b687e172475','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGCGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(513,'a1290b71d32ef4510c9c4b445565e40f','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(514,'2ee6dbeaaa5665e1aa8e8c64e339f308','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(515,'4dfb42c0d964c78956a1fa99aa4c6a17','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGCTGTAATTTTGGGCTTCGCCGTTGTCTTTTTTCTTTTTTTCTTTTTTGTAAAAAAGGGGGAGCGCGGTTGGAGGCCATCAGGGGCGTGTTCGTCGTGCGTTTTATGATTCTATGATTCTATGATTCGCGCGCGAGTGCGTCCTTTTGTCAACCCATTTCTTTTGAAAAACTGATCATACT');
INSERT INTO its1_sequence VALUES(516,'a9d05e6ffc89812632209e5d1ae79869','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGCTGTAATTTTGGGCTTCGCCGTTGTCTTTTTTCTTTTTTTCTTTTTTGTAAAAAAGGGGGAGCGCGGTTGGAGGCCATCAGGGGCGTGTTCGTCGTGCGTTTTATGATTCTATGATTCTATGATTCGCGCGCGAGTGCGTCCTTTTGTCAACCCATTTCTTTTGAAAAACTGATCATACT');
INSERT INTO its1_sequence VALUES(517,'bf9aa1795af1e8356c93ad8b590ddae8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGCTGTAATTTTGGGCTTCGCCGTTGTCTTTTTTCTTTTTTTTCTTTTTGTAAAAAAGGGGGAGCGCGGTTGGAGGCCATCAGGGGCGTGTTCGTCGTGCGTTTTATGATTCTATGATTCTATGATTCGCGCGCGAGTGCGTCCTTTTGTCAACCCATTTCTTTTGAAAAACTGATCATACT');
INSERT INTO its1_sequence VALUES(518,'12887ae18ccdc8b16975d73329f3226c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTGCTGTAATTTGGGCTTCGTCGCTGCGTGTCCGTGAAAAAGGCGCGCGCGGCTGGAGGCCATCAGGGGTGCGTTTCTTTCGGACCGCTCCCTTTTGTCAACCCATTTGTATTCTTTTGAAAACTGATCATACT');
INSERT INTO its1_sequence VALUES(519,'1b5f542578dcfe73f3a1559317ac2bfa','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATCGTTTGCTGCAATGTTGGGCTTCGCTGGGCGTGAGTTCGGTTGGAGGCCATCAGGGCGTGCTGTTCTTGTGACGGTCGCTCTTTTTGTAAACCCATTTGTATTGAAACTGATTGTACT');
INSERT INTO its1_sequence VALUES(520,'d7044a6ee0a49534ccde949acba546a8','TTTCCGTAGGTGAACCTGCGGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(521,'277709cfd2a669d578981a2309f1d7a8','TTTCCGAAGGTGAACCTGCGGAAGGATCATACCACACATAAAAACTTTCCACGTGAACCGTTTTCAACCCAATAGTTGGGGGGTCTTACTTGGCGGCGGGCTGCTGGCTTTATTGCTGGCGGATACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTAGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(522,'1a04508e37fc4cb7e42019bad0e57424','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGACCGTTTCAACCCAATAGTGGGGGTCTTACTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(523,'c5abc7d6c8e1ec8a84038725f639898f','TTTCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTCGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(524,'07d0b76907342047f51b97b79f769e65','TTTCCGTAGGTGAAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(525,'4b53389ae30dad1bb0a6296fd4520855','TTTCTGTAGTTTAACCTGCGGAAGGATCATTACCACACATAAAAACTCTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(526,'d3cff96b65c034eb5f07106895a7571a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTCGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(527,'814f2bc749d26cc69042d59b891e2010','TTTCCGTAGGTGAAGCTGCGGAAGGATCATTACCACACATAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(528,'24739260e17ede86b47fd1873757e46c','TTTCTGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(529,'003e673466229ef503fe2c2adaec5a71','TCTCAGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(530,'18f1ae214733a74d770d47b35cc287de','TTTCTGTAGGTGAACCTGCGGAAGGATCATTTACCACACATAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(531,'802ef17fd5d2e2cc425538d2546b4f78','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(532,'d5de54c06b7f94f5b93800269b703a89','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACATAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(533,'8099b056bfc997be4223229bc82c9e09','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTCGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(534,'ca72e970a6f55e364ca1e93b21c1dec1','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(535,'8355fdff40c93d7bc9f06fd2b545d3cb','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACATAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(536,'bd25422fd0ec807db6140fb700c049a3','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAGCTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(537,'f82e6a4a226636f8cdad41f4deb0f3a7','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGTTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(538,'b9ef98ee5822b990f18e5b7e9e389d29','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(539,'e7fef18ac04e5189c0811481c4bcf112','ATCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(540,'d1b86b1de6486880b7e0c519671cebd6','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACGCCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(541,'ee47beb745e4d4778fe5e6b8df789032','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACATAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(542,'f29805ddd76df0b38decee0ab2bc461c','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACCTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(543,'34772cbba882b0c6f5d6210bf9ce528d','TTCTGTAGGTGAACTTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTCAACCTTTTAGTTGGGGACTCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGCGACCTATCAAAACGAGTGATTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(544,'fd870caeabfede41198133a363d92a66','TTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(545,'139b6366b0fc2302dc06511d35e8e39f','TTCCGTAGGTGAACTGCGGAAGGATCATTACCACACGTAAAAAACTTTCCACGTGAACCGTTCAACTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(546,'1c01455b4119772b0e83161fb74a8295','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAGAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(547,'18b82f367d8ad7441d45244ff9eb6be6','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAGCCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(548,'00cd61435353ce76cd17a974c01462aa','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCAACTTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(549,'1827f397d9f5d1595055f35a1aad6db8','TTCCGTAGGTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(550,'045887d8c3a0573c7c031b5a1efde6e0','ATTCCGTAGGTGAACTGCGGAAGGATCATTACCAACACTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(551,'aad954aa0a048154a3e1ccf39a463d79','TCCGTAGGTGAACCTGCGGAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(552,'3b4d0ae8c9a718f7299dc4da7d3016f1','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGCGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(553,'6629dacda6d37a957717fc437e88968a','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTTCAACTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(554,'c6efff0d661d1c2e0b08b1774c1be3b7','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCCACCACTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(555,'46445620ace373f38517c9dfc741565f','ATTCCGTAGGTGAACTGCGGAAGGATCATTACCACCACTAAAAAACTTTCCACGTGAACCGTTCAACTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(556,'8b8ca81821bf3977efe1f88a5df2ede0','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACAACTAAAAAACTTTCCACGTGACCGTTCAACTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTGAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(557,'3fb7e0af331ca0f81df1bf13e1bf4560','TTTCGTAGGTGAACTGCGGAAGGATCATTACCAACACTAAAAAACTTTCCACGTGAACCGTTCAACATTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(558,'2c73026d0d7622bce09e9f20531ec2cf','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAGAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(559,'d99c93fb05833c9a383af80b4051cf69','TTTCCGTAGCTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTCCACGTGAACGTTCAACTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(560,'01fb098b0b8ccf49b9be1b0bd2561d1b','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCAACTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(561,'5fbed6b60c0107bca8099628ced96235','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTTCAACTTTTAGTTGGGGACCCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(562,'66fae0637486b259809e88f2ad8aa23b','TCCGTAGGTGAACCTGCGGAAGGATCATTACCCACACCCAAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(563,'b0bd7663c21c94f7b66434935b4e3086','TTCCGTAGGTGAACCTGCGGAAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(564,'a09ccfd0dbb469d88d6f07438d77915d','TTCCGTAGGTGAACCTGCGGAAAGGATCATTACCACCACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(565,'79c360dd99f4f687be76af1e14516ed3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGTTCTTATTGGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(566,'5c8eaed20b3e7243ed9723ffb8213a56','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTAATTGGCGGCGGTTGTTGGCTTAATTGTTGGCGGTTGTTGTTGAATAAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(567,'dd6abca251d58114a5968abe35d5f8b6','TTTCCGTAGCGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(568,'449446a960d84d7470357ee6881daf46','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCCAATTATTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(569,'0868c7e26b5796a52421b5c05076bd2c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCCCCCCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTTTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(570,'a4894a052eedd68859f7f56f992dba2f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGAGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAAATTACTGATTATACTGTGAGAACGAAAGTTCTTGCTTTTAA');
INSERT INTO its1_sequence VALUES(571,'151c09244508dad69144e45a2b803083','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCTGTATTTGTTGTGTGTCTGCGCGTGCTGGCGTGCGTTTTGCGTGCCGGCGTGTGCGGACTGAACGAAGGTCGTGTCGCTGTGCGGCTGACTTCTTTTTCAAACCCCATACGTAAATGACTGATTATACTGTGAGAACGAAAGTTCTTGCTTGAAC');
INSERT INTO its1_sequence VALUES(572,'b698887af7137f62186ea387a559f38b','TTTCCGTAGGTGAACCCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTATGCGCGTGAAGGATGTGCGCCACACACGCTTCGGTGTCCCGATTGCGTGTAAGCAATTCGCGGACTGAGAGAAAGTCGTGTTGCTCATTTCTTGCCACAGGAACGGGTTTCCACTGATTTGCATGTTGGTGTGGGAGCGGCAAGTTATGATGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAA');
INSERT INTO its1_sequence VALUES(573,'c7ebb4dafbdb6bf0ded1a329e9ba495e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCATTTTCGGACGCGGACGCGGCGGAGGCTGAACGAAGGTTGGTTTTCTTCTTGTGAGAGACCAGCTGATATATTTTTTCAAACCCCTTTTTACAAAATGACTGATCAATACTGTGAGAACGAAAGTTCTTGCTTTAACCTAGATAACAACTTTCAGCAGTGGATGTCTAGGCTCGCACATCGATGAAGAACGCT');
INSERT INTO its1_sequence VALUES(574,'f6c1630312c013b6dea0263b9364ea09','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACTGTGAGAACGAAAGTTCTTGCTTTTAACTAGATAACA');
INSERT INTO its1_sequence VALUES(575,'3392f6c7949c6129059ff8959ba808ab','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTGCTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGCKTGCGTGTGTTTGGCGTGCCCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTATTTTAAACCCTTTTAYTGTTAACTGATATACT');
INSERT INTO its1_sequence VALUES(576,'ad76d2b630120164a0c2c93f8bbd41ae','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTGCTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGCGTGCGTGTGTTTGGCGTGCCCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTATTTTAAACCCTTTTACTGTTAACTGATATACT');
INSERT INTO its1_sequence VALUES(577,'ba6340f463186b78fa1c0531518dc5e7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTYCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(578,'8ecb567b5e5716d6f750c120606c4248','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAACTTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGATGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(579,'28c48ef7d181958172daf8eae8228686','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTNCACGTGAACCCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(580,'dde63c479dd20ce5b18386c22379287b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(581,'e7b5749d2adf6ae689f41a38e1dd9b61','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCCGTATCAACCCATTTAGTTGGGGGCTTGTCCTGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(582,'c4d9d7cae0475d2fe8adc27110a6ec1d','TTTCCGTAGGTGAACCTGCGGGAAGGATCATTACCNCACCTAAAAAACTTTNNACGTGAACCCGTATCAACCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(583,'83a3f1230b199848a978988709babca4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTCAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(584,'80b6f53914bca8629394fdad682b4404','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATTACCACCCAGTTGGGGACTCTCTGTTGGTGGTTGGGGCTGGCTAGCGCTGGCTTTGACTGTCGATGGGTTGAGACCTATCAAACGACGCGTTTGGGCTGCAAGGCCTGAGTGTTGTCTGTTTCTCTTGTAAACCCATTTCTAAAAACTGAATATACT');
INSERT INTO its1_sequence VALUES(585,'ec642d4b8148085bb3f426829665755d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(586,'36f4940573cc05c6fdb488b251b8ec79','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCCTTACTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(587,'6325c50638b988c4093b76c353f1e9bf','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCGCTGGTCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTTGTAAACCCTTTTTAMTATTTTCTGATGATACT');
INSERT INTO its1_sequence VALUES(588,'8d5a19d0b6609eb2f1f754a0d4fcfb7b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGTCTGCCKGTTGGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(589,'9e8bb971a4f1451db144392e5eb77ce7','GTTCCGTAGGTGAACTGCGGAAGGATCATTAACCAAAAATCCTTTCCACGTGAACTGTCGTATTTGATTCGCGCCGTGACGTGTGTCGTCGCTGCGTGTGCGTTTGTGCGTGCGTCTTCTTGGAGATGTGTGCGCGAGTGCGCGCGTGGCGGTGACTGCGTGGGTCGGCTGATCGAAGGTCGCTTTGCGCTGTCTGGCGCGGAGCGGCTGACTTATTCTTTCAAACCCATTCGTTAGTACTGAAACATACT');
INSERT INTO its1_sequence VALUES(590,'f0432c3c662dda226aedebf1c7cb8a36','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAATTTCCACGTGAACCGTTTCAACCAAAAGTTGGGGGTCTTGTTTGGCGGTGACTGCTGGCTTTATTGCTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAAAGTTTGGACTTCGGTCTGAGCTAGTAGTTATTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(591,'65b51e51b328da714cc5c4893d6fcc85','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTGTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(592,'afacccc1b2d58d3a50a23673e5ed686b','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTTGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(593,'67df3f2122a6981f257efe2affa6eebf','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTACGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(594,'c74ed94dd12163bb458c10e384c46efa','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCCAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(595,'dd96e95b7b93c47b418490e0fe10a69b','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(596,'4ba69422aa80a919ae213b635ed4b307','TTTCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTCTAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(597,'765d0fa712e105d935265b989c785ee0','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACGTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(598,'e343bdcb1c1a7993f4e59624ba1c3794','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(599,'19873bf5a0614d5ae96fc3252a03c417','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGGGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(600,'60a9d525a5769eb1d6925342e9bb2753','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGGAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(601,'0a321e94415cdd5143383d1f3c361a73','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATTCCACGTGAACCGTATCAACCCCAAGTTGGGGGTTCGATTGGCGGCGGCTGCTGGCATCTTTTTGCTGGCTGGCTACTGCCGAGAGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTTATTATAAACCCATTCCTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(602,'b4ce0eafd08dd1ddfc125a6e9dea1aa6','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAATCTTTCCACGTGAACCGTTTTGTGTAATAGTTGGGCTTCGCTGCCTGGCAGTCTGCGCTCGCAGTCTGTTGGAACGCTTGAGGCTATCAAGTGGGTGTGTGGTCTGTCGCTCTCGGGCGCGGGTCGCACTTCCGCTTCTGTTTGAACCCATACTTAACTTCTGAACATACT');
INSERT INTO its1_sequence VALUES(603,'c7c11b511c63bb6dcda50fe8968ad5b2','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(604,'f296d6107b332f824077df66868871a2','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(605,'1b01ff321444067ba1f94e0b5dbcba95','TCCGTAGGTGAACCTGCGGAAGGATCATTACCCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(606,'5f0483d287d79efa03640fc9ff7077e5','TCCGTAGGTGAACCTGCGGAAGGATCATTACCCACACTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(607,'8b63dad7bf52c6c0fa1b485d2e6570f3','TCCGTAGGTGAAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(608,'52bfcad2d248b791e14a0f11f3e6708b','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(609,'36b1270325b76676449673a07eac8634','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(610,'24cf314f0c5f56d7546749b67324c232','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACCACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(611,'3a0c840a0db4016dc62fe90b54df9064','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(612,'f71e91c7ea4f984b64fa66390b1f526a','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(613,'4a937dceaeffdc52d9887267f5e9f601','CTTCGTATGTGAACCTGCGGAAGGATCATTACCACACATAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(614,'ff8ba2bc05cfe9151217bdb986adc1cc','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(615,'77aeaf72f5886c11f9b67da4d4393b91','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAACCGTATCAACCCCCTTCGTTGGGGGCCTGCTCTGGGCGGCGGCTGYCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(616,'2303d391291904d6c4002d718919b455','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(617,'0f9cb39229055b782eb8aa7403474039','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCYWGTCCYGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTWTCTTTTAAACCCATTCTTGAATACTGAAYATACT');
INSERT INTO its1_sequence VALUES(618,'d3570e57b23b50a42b35083e7fb6c7e5','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(619,'f92ce0ecac86007829d5779e5a13b5ec','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGACGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(620,'5eecfb8148b3384d6369a066fa52ee1b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(621,'c64f61c7c4f67b1517dd5982b5b57363','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGTAGGCTCTATCGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATTAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(622,'6ee0634c2c460285d24c1736d3ec0d20','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCAATTAGTTGGGGGCTTGCTCTGGCGTGCGGCTGTTGACCTGTAATGGGCTGACGGCTGCTGCTGGGCGGGCTCTATCAAAGGCGAGCGTTTGGACCTCGGTCCGAGCTAGTAGCTTTACTTTTTTAAACCCATTCTTTACATACTGAATATACT');
INSERT INTO its1_sequence VALUES(623,'889f79422e2ffc567cc61c27dfbcbdb4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTYCCGTCTGGCCGGCCGGTTCTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(624,'65abe9be0c092b96f374849a7bdb18cc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(625,'7639e707a2de8bfb144f9c5f2e03c759','TTCCGTAGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACACCCTTAGTTGGGGGCTGCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCCTGGGCCTTCGGGTCTGAGCTAGTAGCCCACTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(626,'193f136c4bd08d9605ce19b428eb8305','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAATCTTTCCACGTGAATTGTTTGGACCATGTTGGGCTTCGCTGGTGTGTTTGCTTTGTACGGGTATTCCTTTTTGGAACTATTCGTAAAAAGCGGACGCGTCGGCTTGAGGCTATCAGGGCGTTGGACGCTCTCTTTGAATTTCGTGTTCGAGGAGAGTGTCTGTCGCTCTTTTGTAAACCCATTTGTAATGAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(627,'909898bdc6f044b983625ae41633c558','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGTCTGCCTGTTGGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(628,'f2ad6bd2e66b38efdb54bb616cc12fe5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGGCATGGTTGGGCTTGTGCGTTTTCTCTCTTTTGTAGGGGGGATGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTTTTTGATAACTGAAACATACT');
INSERT INTO its1_sequence VALUES(629,'e1f1bf06b199288151b9cbe1b40daa06','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTAGTTGGGGGTTTGATTGGCGGCTGCTGCTGACATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCCTGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(630,'9c901f099a5a1e1bf31497b75b3ace48','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTTATTGGGGGTTTCATTGACGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGATCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(631,'c96e87d12fe1125ad17bee911413b401','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTAGTTGGGGGTTTGATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCRACTGCTGAGCGAACCCTATCTTGGTGATCGTTCTGACCTTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(632,'291e8e1f770ffcf4b40143d4a0cfc89f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCATTAGTTGGGGGTTTGATTGGCGGTTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCTTGGCGATTGTTCTGACCTTCGGTTGGAGTGAGTAGCTTGCATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(633,'dcd8f572a3963026c1e81fcfcdfef8fe','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGSMWGKAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATACT');
INSERT INTO its1_sequence VALUES(634,'fcf0da69e576456b29517383aaa4265a','TTTCCGTAGGTGAACCTTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(635,'0fc1531c6d4df12afe9aa709a68610c9','GTTCCGTCAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCCGAATGTTTGGGAATTTCGGTCCGGGCGAGTAAGCTTTTTGTTTTAAACCCTTTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(636,'5cca5784dda345f896e1fd9c409c9143','TTCCGTAGGTGAGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(637,'0f71712d7612c06a63ce7091d462b338','TTTCCGTAAGAGAACCTGAGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(638,'d4a4551f98476ad29bcfb9eb2ffa1c02','GTTCCGTAGGTGAACGACTGCGGAAGGATCATTACCACCACTTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(639,'6e5b47e4bb778b5e8cb54149f7b1b31c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(640,'245efb631925e5c9d579c427318ad336','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAAACTATCCACGTGAACCGTTTGTATGAAGATTTGCGCCGAGATGTTTGTGCGTGTTTGTTGTATCACTGTGTGTTCGTACGCGGTGTGTGGCAAGTATGTATGACGCTTGGCTGATCGAAGGTCGATATGCACTTGATTGTGTGTGTCGGCTGACTTATTTTTCAAACCCATTCTACAGTACTGATTATACT');
INSERT INTO its1_sequence VALUES(641,'5648b3a45a3c228e8522f1fecb5459f0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCRCWCCTAAAAAACACYCTTTCCACGTGMACCGTTNTTGTTTTGCTTTCGAGTGCYTTGTTGCGACYTCACCWTCATTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(642,'9974ae43fd33fb0ad6015fc1ecb4c7e1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACWCCTAAAAACMYCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGMYCGSAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTTTGAGTGTGCTTGCGCATTTTGAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(643,'dd87a4a3ec6653b9c24e1109de2f455d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAACCGTATCAACCCCCTTCGTTGGGGGCCTGCTCTGGGCGGCGGCTGCCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(644,'96c8e77e563908036f335d34089c802a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(645,'91eaac3e1e4cb921440878e2098aeae5','TTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTGGAGTGTGCTTGCGCACANTTTTAGACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(646,'35d607edc1e89843f292c825b27a5d74','TTTCCGTAGGTGAACCTGCGGAAGGATCAYTWCCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCKSAGCAYGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTGGAGTGTGTGCTTGCGCACATTTTGAATGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(647,'25e68bc34b3ba17f8ab0cb154ae487d7','TTTCCGTAGGTGAACCTGCGGAAGGATCAYTACCRCACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGCAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTGKWGWGTGTGCTTGCGCACATTTTGAATCGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(648,'4b2ce35aad592a07add8a10b59f68992','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTGGAGTGTGTGCTTGCGCACATTTTGAATGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(649,'d6e051b77d05ca16f9eb2fe26e4a8dc1','TTTCCGTAGGTGACCTTGCGGAAGGATCATTMCCACCCCTAAAAANCACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(650,'0a86b4c68d0ae0bfa68441b38ce3fa3c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCRCACCTAAAAACACCCTTCCACGTGAACCGTKYTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTGCACATTTTTTGAACGTCCAAACCTTTTAAACCCATTTGATTTGAAAACTGAAATATACT');
INSERT INTO its1_sequence VALUES(651,'4c171f14423e55f0705b0942f45b08e9','GTTCCGTAGGTRACCTGCGGAAGGATCATTACCCCMCCCTAAAAAACACCCTTNCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(652,'3caccabb2423b0f0773b4f30adb82c1d','TTTCTGTAGGTAAACCTGCGGAAGGATCATTACCRCWSYTAAAAAACACCCTNTCCACGTGARCCGTKTTGGTTTNGCTTTCTRGTGMTTTGTTGCGCTCKSAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(653,'a72916a906146c532ced0eba9cbc6b08','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACACCCTTCCACNGTGAACCGTTNTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(655,'f65cb12b202fc8fec0e92307b9a46c39','TTTCCGTAGGTGWACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTTGTGGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTTGAGTGTGTGTTCGCATACAATTAAAACGTCCAAACCTTTTAAACCCATTTGATTGCAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(656,'887162ae495d7616ceffc3cc7d3e655a','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTTTGAGTGTGCTTGCGCATTTTGAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(657,'fbac189093d584d1e62a7335d01ab2d3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCTACTGCTGAGCGAACCCTATCATGGTGAGCGCTCTGACCTCGGTTGGAGCTAGTAGCTTGAATTGTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(658,'d12ad32ed234c43004ba6946f227df94','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGATTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(659,'d8c9096936594359fab2a2297fa37088','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(660,'960b79da22cb89a499914f331ed5a857','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTTTTCTCTCTCTCTTTTGGGGGAGGGGATGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTTTTTGATAACTGAAACATACT');
INSERT INTO its1_sequence VALUES(661,'7e0a7eb4e4e265d03a1761147f8394f7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAATTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(662,'1efe8cc39292cd3d3bb960e8812aad84','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(663,'0208c7514d7117d8b53cc2fdd1d5703a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTACAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(664,'c9acdbe68a68335fc8ad16ba6db91ea8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAATTAGTAGCTAATTTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(665,'03290fd04e27108a966e02d45ac9214e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATCGTTTCGACCTTGGTTGAGATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(666,'47141ece4e9f2792920234543f2629da','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCTCCTGGTGATCGTTTCGACCTTTGGTTGGAATTAGTAGCTAAAAATTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(667,'b29aa2af855f1f59e123e682ed7bea0e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTAATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATTGCGATCGTTTCGACCTTGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(668,'b08ee056a5607a13249edb16d5639f3a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGACCGTTTCGACCTTGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(669,'808682f6b3eb35c6b53b1b1948c07498','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTTTTGTCAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACCTTGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(670,'ed87d9d5ec60d6a88c6c7986dc88b927','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCAACCTTGGTTGAAATTAGTAGCTAAACTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(671,'b45e66d6b8e8098dd24aff3d8c019d05','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATTAAAACTTAGTTGGGGACAATTCGGGCGGCGACTGTAGACTTAATTGTCGGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATCGTTTCGACCTTGGTTGAAGTTAGTAGCTGAATTTTTAAACCTTTAATTATACTGATTATACT');
INSERT INTO its1_sequence VALUES(672,'7716549bafdc5c393881c254823ddb6e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATTAAAACTTAGTTGGGGACAATTCGGGCGGCGACTGTAGACTTAATTGTCGGCGGTTGCTGCTAGATGCGTCCTATCGTGGCGATCGTTTCAACCTTGGTTGAAGTTAGTAGCTGAATTTTAAACCTTTAATTATACTGATTATACT');
INSERT INTO its1_sequence VALUES(673,'8b9d1f6d406d8820e9ab6044be0e4311','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACCTTGGTTGAGATTAGTAGCTACATTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(674,'ddba7b904d0aafbd2d5b03b93cdc6f1c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCACGTGAACCGTATCAAATTTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGAACGTTTCGACTTTTGTTGAAACGAGTAGCTAAATTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(675,'5fc82dd0f13e7a0faef2391c8885e295','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTCCACGTGAACCGTATCAAATTTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGAACGTTTCGACTTTTGTTGAAATGAGTAGCTAAATTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(676,'b9714f9e1a00eef26bbc3f823dba1e07','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCACGTGAACCGTATCAAATTTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGAACGTTTCGACTTTTGTTGAAATGAGTAGCTAAATTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(677,'5de6034227f1b2a0ac7a0b2be5d76282','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTCCACGTGAACTGTATCAAACTTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGAGCATTTCGACCTTGGTTGAAATGAGTAGCTGAATTTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(678,'1e0653c2f0f09d0db35cd74f9c93c70b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGTGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACCTTGGTTGAAATTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(679,'e2f4d432931aa1a7caefd569b6fae188','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATCGTTTCAACCTTGGTTGAGATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(680,'9a78214740ce259f0cc964049be27e59','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTAATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACCTTGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(681,'848c0486e984fc6fef4f37d5b3a30d88','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGACGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(682,'f3e69d0797229426939262c50f985938','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAACTAATTGGGGGTTTGTTTGGCGGCGGCTGCTGGCATTTTGTGCTGGCTGGCTGCTACTAGACGAGCCCTATCGCGAGCGTTTGGGCCTTGGCCTGAGCTAGTAGCTTTAATTTTAAACCATTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(683,'bd647c77278f864b0be38f60085b4349','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGRGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(684,'71790d020f98cde9a4206a9dfbbca6e0','TTCCGTAGGTGAACATGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(685,'2d1983c9fc8f05b00de282ec320fffe3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTRGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(686,'59ca7ac2c721724bb21476bba0b5d79b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(687,'492e9f5ae3391e0c0a59dbb9a99ae22b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(688,'214a92c6c3b391a9cf254a1ff972611d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTGTTCTCTCTCCTTTTGGGGGAGGGGAGGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTCTTTGATAACTGAAACATACT');
INSERT INTO its1_sequence VALUES(689,'bef7dd790969e115ad13f3e8feb29c89','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTRCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(690,'a08f8c8576cffc2c1615a1a9e6613a50','CTTCCGTAGGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCACCCCATTAATTCGGGGGTTTAATTGGCGGCGGCTGCTGGCATCTTTTTGCTGGCTGGCTGCTGCTGAGCGAATCCCATCATGGCGAGCGCTCGGACCTCGGTCGGAGCTAGTAGCGTTAATTTTAAACCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(691,'32e89ca22e4633bd095b9b96aaf291ce','TTCGTAGTGAACCTGCGGAAGGATCATTACCACACCCTAAACATCTTTCCCGTGAACCGTTTGTGACATTGTTGGGCTTGTCTTTCTTTCGGGGAGGATGAGCTATCTGTAAACTTGTCAAACCCCTTTCTTTTTTTATAAAACTGAAACATACT');
INSERT INTO its1_sequence VALUES(692,'82adbb7d385c75826ba18410f0ed6ac3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTAGTGACAAGATTAGCGCCGTGACGCGTGCTGCGGGTACTTGATTGTATCTGCGGCGTGCGGGCTCGGCTGATCGAAGGCTTCATTGCTGCGAGTGTGTGCTCTTCGGAGCGCGTCTCGCGGCGGTGAGCTGACTTACTCTTTCAAACCCCTTCCTTAATGACTGATGTATACT');
INSERT INTO its1_sequence VALUES(693,'d8bcfdac895cbffee42fd108ec2e6778','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTACGTTTTGTGCTTTTTGTTTTTCCATTTCCGCTCTATGAGTGGGGAAGGAGAAACGCTAGGCTAAACGAAGGCCGCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAATACTGAACTATACT');
INSERT INTO its1_sequence VALUES(694,'b51e4ec97f1d0c61b3a39982c396a0ca','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTCTGTCCGTTTTGTGCCGTTGCTGTTGTCGTCATTCGACGAGAAGAGCAGTGGCTAAACGAAGGCTGTGAGCTTCGTGCTTGCGGTCGATTTATTCTTTCAAACCCCATACGTTAAGAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(695,'98355008ec0b0447c05c1dd43a4e64be','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(696,'f8c2252a9521e5892ad828ea460e581b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCCTTGTGTTTGCTTTTGTTTGTCTCGCTCTTCGGGGTGTGGTGAACAAGAGGAAACGCAAGGCTAAACGAAGGCTGCGAGTCTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAACACTGAACTATACT');
INSERT INTO its1_sequence VALUES(697,'bbdeaef4751657007c44a081b5d8c992','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTAACTGATCTAGTGTTTTCCTATTTTTGGGACACTGGAATACAGGATTCAGCAGGACGAAGGTTAGTCTCTCGTAATGCAAATTAGGAGGACTAGCTGATGAACTTTTCTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(698,'260e0ea9dd65ff4c6ddf57ee9e865ae2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACGCCAAAAACTATCCACGTGAACCGTTAAACAAACAGAAAGGGTCGTCCTATTTGATGCGATGTTTGGGAGATACTTTGTATTTTCTAGGCATTTCATTGAGTAGGTCGACTGTCGAAGGTCGGGCGTTCGCCTATAGTGTAGCTTTTGTTGCGCTGTAAGCTTGAGCAAACGGCTGATTTATTCTTTTAAACCATACCTGAACCTACTGATTATACT');
INSERT INTO its1_sequence VALUES(699,'fa83abef09bdfe9721374ea79e2e0dcb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTCACTGAGCTGGTGTTTTCCAATATATATATATTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTCTTGTAATGCAAGTTATGAGAGACTAGCTGATGAACTTTTCTTTTTAAACCCTTCTTACCTAAATATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(700,'1fad4c4994eac717bc717c7fe22ec8aa','GTTCCGTAGGGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTTTTTTCGATCTGCTGCTCTGTGGAGTGTGTGGGGAAGAAAAAGCTCCAGGCTAAACGAAGGCTGCGAGTTTCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAATACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(701,'438975b416bfffe16109d9036bcbd7f6','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTTGTGTTTGCTTTTGTTTGTCTCGCTCTTCGGGGTGTGGTGGACAAGAGGAAGCGCAAGGCTAAACGAAGGCTGCGAGTCTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAACACTGAACTATACT');
INSERT INTO its1_sequence VALUES(702,'f98c76e966cd82d59c180d4eb20d3d0c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGGTGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGATCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATTATACT');
INSERT INTO its1_sequence VALUES(703,'a1a415f58f41b0eb2a1e565d7ef87bbc','TTTCCGTAGGTGACCTGCGGAAGGATCATACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGAGCTTGTTTGGCGGCGTGTGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(704,'7607a118b32e91e7fa83c9598d83e499','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTCGTGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGATCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATTATACT');
INSERT INTO its1_sequence VALUES(705,'9e1a4e7a55d33fe214240c1cc49209bd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAGTTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTACGGGTTGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGACTCGTGTTGGGCTTCGGCTCGAGCGAGTAGCTTTTCCTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(706,'198440accecdb83da09862ddf83ab0f2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTTGTGTTTGCTTTTGTTTGTCTCGCTCTTCGGGGTGTGGTGGACAAGAGGAAGCGCAAGGCTAAACGAAGGCTGCGAGTCTCGTGCTTGYGGCCGATTTATTCTTTCAAACCCATACATTAAACACTGAACTATACT');
INSERT INTO its1_sequence VALUES(707,'682945315aea1273d9820044fad0a348','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGATGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGAGCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATGATACT');
INSERT INTO its1_sequence VALUES(708,'46ee07987c9e8fc573d164046a054357','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGATGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGAGCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGTACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATTATACT');
INSERT INTO its1_sequence VALUES(710,'9c2f1edde56784729c4dc4b5911aede6','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGAYGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(711,'4d0da30ebda04ea666337590b5092947','TTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(712,'a0dd28d12079207af470914bdd20abbe','TTCCCGTAGGTGAACCTGCGGAAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(713,'eae6dea24a07773800450b98a8103a93','TTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTCTGTCCGTTTTGTGCCGTTGCTGTTGTCGTCATTCGACGAGAAGAGCAGTGGCTAAACGAAGGCTGTGAGCTTCGTGCTTGCGGTCGATTTATTCTTTCAAACCCCATACGTTAAGAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(714,'1f70621c04bace5cb297a544538ff94f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATTTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(715,'7a72065ca59298892f85d6938bf95ae8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAACAACTTTCCACGTGAACTGTCTTACGAGATTCGCGCCGTGACGCGTGTTGGCGCTGTGTGTGTCTGTGTCTTCTTTCGAGAGGATATTGTGATGCAAACAGTGTTGACCGTGTGGGTCGGCTGATCGAAGGTCGCTTTGTGCATTATTGTATGGAGCGGCTGACTTATTCTTTCAAACCCATTACACAATACTACTGATTCATACT');
INSERT INTO its1_sequence VALUES(716,'e68b4635f0c1b073d9473328c6f8bb5f','TTTCCGTAGGTGACCTGCGGAAGGATCATACCACACTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(717,'0c56dd964c332e2317bc4a553433ff8d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTTTTCCTTTTCCGCTCTATGAGTGGGGAAGGGAAACTTCAGGCTAAACGAAGGCTGCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAATACTGAACTATACT');
INSERT INTO its1_sequence VALUES(718,'f277e0e265185bff4fc487600a7d5f0d','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTTGTGTTTGCTTTTGTTTGTCTCGCTCTTCGGGGTGTGGTGGACAAGAGGAAGCGCAAGGCTAAACGAAGGCTGCGAGTCTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAACACTGAACTATACT');
INSERT INTO its1_sequence VALUES(719,'040c04bdc5e4a6b01a03c31e29c893e5','GTTCCGTAGGGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGATGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGAGCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATGATACT');
INSERT INTO its1_sequence VALUES(720,'f011e114f1a573e19e5c5c564aa0b50e','GTTCCGTAGGTGACCCTGGGGAAGGATCATTACGCACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGATGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGAGCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATGATACT');
INSERT INTO its1_sequence VALUES(721,'9316bd3be088afa9a6daf8d68efa39c2','TTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGGTGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGATCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATTATACT');
INSERT INTO its1_sequence VALUES(722,'5d3e78d071579e833c8d29c8d957bb73','TTTCCGTAGGGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGATGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGAGCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATGATACT');
INSERT INTO its1_sequence VALUES(723,'9581595ab3cec2ddf48310abea2f45a8','TTTCTGTAGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTCACTGAGCTGGTGTTTTCCAATATATATATATTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTCTTGTAATGCAAGTTATGAGAGACTAGCTGATGAACTTTTCTTTTTAAACCCTTCTTACCTAAATATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(724,'aaecee014eb7f226923987b1bc651fd0','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTCTGTCCGTTTTGTGCCGTTGCTGTTGTCTCGATTCGTCGAGAAGAGCAGTGGCTAAACGAAGGCTGTGAGCTTCGTGCTTGCGGTCGATTTATTCTTTCAAACCCCATACGTTAAGAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(725,'cc07315edaa190f7d765ee8d8596146d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTACGTTTTGTGCTTTTTGTTTTGTCTCTTCTGCTCTCGCGAGTGGAAAAGGCGGAACACTAGGCTAAACGAAGGCTGCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAACACTGAACTATACT');
INSERT INTO its1_sequence VALUES(726,'189043118780da31e3fdc539b495f0d9','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTTTTCCTTTTCCGCTCTATGAGTGGGGAAGGGAAACTTCAGGCTAAACGAAGGCTGCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAATACTGAACTATACT');
INSERT INTO its1_sequence VALUES(727,'543fa19c52a1de484838806dd690b13b','GTTCCGTAGGGGACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTTTTTTCGATCTGCTGCTCTGTGGAGTGTGTGGGGAAGAAAAAGCTCCAGGCTAAACGAAGGCTGCGAGTTTCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAATACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(728,'7a23ef79729b4524b46d4afe781886b2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTCTGTCCGTTTTGTGCCGCTGCTGTTGTCGCGATTCGTCGAGAAGAGCAGTGGCTAAACGAAGGCTGTGAGCTTCGTGCTTGCGGTCGATTTATTCTTTCAAACCCCATACGTTAAGAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(729,'7eefbcf39b2ab7a30e32cddaab727ca3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTCCCACCCCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTTTCGATCTGCTCTGTGCCTTCGGGTGTGGAGTAGAGAAGAAAACTCTAGGCTAAACGAAGGCTGCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAACACTGAACTATACT');
INSERT INTO its1_sequence VALUES(730,'f62b8783d6c5b712d53526f064bcd3f2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTTTTTTCGATCTGCTGCTCTGTGGAGTGTGTGGGGAAGAAAAAGCTCCAGGCTAAACGAAGGCTGCGAGTTTCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAATACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(731,'273c71b0efa1e874b7bad4ac79fb7b33','TTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGATGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGAGCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATGATACT');
INSERT INTO its1_sequence VALUES(732,'aeb9e8c96d896eb7ee8f99d3aa1dffaf','GTTCCGTAGTGAACCTGCGGAAGGATCATTACCACACCTTAAAACTATCCACGTGAACCGTTTGTACCCAGATTTGCGCCGAGATTTTCGTGCGTGTTTGTTTGTATCACTGTGTATTCGTACGCGGTGTGTGGCAAATATGTATGGAGCTTGGCTGATCGAAGGTCGTATCGCACTTTATTGTGTGTGTCGGCTGACTTATTTTTCAAACCCATTACTTACTACTGATTATACT');
INSERT INTO its1_sequence VALUES(733,'f0d9e85de0a95d78d95101d5cc34d2bc','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACATAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(734,'c463e83cbb905c559953373792833568','TCTGTAGGTGAACTTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTCAACCTTTTAGTTGGGGACTCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGCGACCTATCAAAACGAGTGATTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(735,'af3944ea025d1ccef7f0deb2a114aa99','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(736,'a3972477d15e25491b11e43c43d8283f','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(737,'f1fc55f645711984d42f617ab252efae','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGTCTTTCTGGCCCCATCAAACGAGGCGCTGGGCTGCAAAGTCTGGCGTAGTAGTTACTTTTTGTAAACCCCTTTACCTTATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(738,'40e926b6c9ea5525a32c6efbe30c6106','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAACCGTATCAACCCCCTTCGTTGGGGGCCTGCTCTGGGCGGCGGCTGYCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(739,'04ddd78c93386cedb4a98975303900a8','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCCCGCCCTATCATGGCGAATGTTTGGACTTCGGTTTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(740,'2d0e59f05bef25b99c92e9fa2f09d3c8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACRTGAACTGTCTGTGATGTTGGGGGCGTGTCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACTTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(741,'f2a1e9ab5665bccde391c3a0d1ae5da3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGTCGTTCGCGGCGGCTCCATCAAACGAGGCCYTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACTTTTTCTGATGATACT');
INSERT INTO its1_sequence VALUES(742,'15927be11bf5d2b928f47eacd21e1d38','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGYCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGMAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACWTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(743,'4feadbd894c41df2a833c5e6153a80e0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGYCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACWTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(744,'6442a7ff073b0b1119dd00f7c6639830','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAACAACTTTCCACGTGAACTGTCTTACGAGATTCGCGCCGTGACGCGTGTTGACGCTGTGTGTGTCTGTGTCTTCTTTCGAGAGGATATTGTGATGCAAACAGTGTTGACCGTGTGGGTCGGCTGATCGAAGGTCGCTTTGTGCATTATTGTATGGAGCGGCTGACTTATTCTTTCAAACCCATTACACAATACTACTGATTCATACT');
INSERT INTO its1_sequence VALUES(745,'eda164d73eb8b0cb77ea1d4724a001c5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAAACTATCCACGTGAACCGTTTGTACCAAGATTTGCGCCGAGATGTTTGTGCGTGTTTGTTGTATCACTGTGTATTCGTACGCGGTGTGTGGCAAGTATGTATGACGCTTGGCTGATCGAAGGTCGTCTTGCACTTGATTGTGTGTGTCGGCTGACTTATTTTTCAAACCCATTCTGAACTACTGATTATACT');
INSERT INTO its1_sequence VALUES(746,'14ac885a391c69c8ea23dd50558e1452','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTATAAATTGGGGGTTCAACTGGCGGTTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCGTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(747,'fd70f49d31675550292ff31d4fb86e8e','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGTGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTTGAGTGTGTGTTCGCATACAATTGAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(748,'4017e66726ea356327c2cf644157cce9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTTAATTGGCGGCGGCTGCTGGCATTTTTTTGCTGGCTGGCTACTGCTGAGTGAACCCTATCATAGTGAGTGTTCTGACTTCGGTTGGAACTAGTAGCTTGAATTACAAACCCTTTCTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(749,'26042e9a0f45680600df3e1c24b1ce6a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACCCCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(750,'ec26f65db22489f065c223b40da47ee4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGGTTAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(751,'51a426fa6765bbc0429d493c59a307b9','TTTTCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACTGTGAGAACGAAAGTTCTTGCTTTTAACTAGATAACAACTTTCAGCAGTGGATGTCTAGGCTC');
INSERT INTO its1_sequence VALUES(752,'f682426d5ab0bd6d2e4a30f6371241f5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAAAGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(753,'067873f405031fb02ef22de6dcbf7268','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAGCTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(754,'799d06c2b59dbf0405c17123461e1708','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTCCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(755,'1c0bb5900f0f781b7f0d11c9e023ca76','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGATTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(756,'0c2a9a39e4b55df4eaee64d472722561','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGATTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGACTATACT');
INSERT INTO its1_sequence VALUES(757,'c00ce2ac2d2350a8f2eb0a4552d8fbed','TCCGTAGGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(758,'544dff009d0c4ced40236a568c1ed797','TCCGTAGGGTGACCTGCGGAAGGATCATTAGCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCATTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(759,'386e52576114e6d3ab6c5be08cc6a1f9','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCGTTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(760,'febd734fc3b85fbff00f43d5757b361c','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(761,'82cc390a45f370d78f394e89c7b55a1e','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTTTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(762,'efa970ca86218d7ec99368d8238ce0f5','TCCGTAGGTGAACCTGCGGAAGGATCATTACTACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTTGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(763,'c64c385a133edec9708c554a81cf6869','TTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(764,'b686924690b255add8895dc13c8adea2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(765,'fc815de9ce3c10f1f53fe80ad52b3b02','GTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(766,'8d9848b2b8eb124e9fdf9a0b2f526bad','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGTACACTGTTGGGTTTCGCTGGCGCGTGTTTTCTTGTCGAATGTAGTGTTTGACGGCGCGCGGCGGCTGGAGGCCATCAGGGCGTCTGTTGTTGTGATGGACGCTCTTTTTGTAAACCCCCTTTTTTTTTATTTTGTGAAACTGATTGTACT');
INSERT INTO its1_sequence VALUES(767,'19a9ea4424345a1a773d872c4d64d1df','GTTCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCCGGTGTTTTCATTTTTGGACACTGGAGCGGGAGTCAGCAGGACGAAGGTTGGTCTCTCGTAATGCAAGTTATGGGGGACTAGCTGATGAACTTTTCTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(768,'2d29bc7fbc54630aa976305122b1af18','TTTCGTAGGTGACCTGCGGAAGGATCATTACCACACCAAAATACTTTCCACGTGAACTGTCTTACGAGATTCGCGCCGTGACGTGTGTTGTCGCTGCGTGCGCTGTATTTATATAGTGCGCATAGCGTCGACTGCGTGGGTCGGCTGATCGAAGGTCGCATTGTGCTGTATTGCGCATTGTGGCTGACTTATTCTTTCAAACCCATTTCTTTATTACTGATTCATACT');
INSERT INTO its1_sequence VALUES(769,'6eb8fdd940fabdee7d396b2cd14010fa','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGTCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(770,'7eda94ec340340a29660aa989677eaff','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCCTTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(771,'c63e8f1a85bc910ee0ee9fedab5c0f06','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTTTGATTATACT');
INSERT INTO its1_sequence VALUES(772,'3be3fe92bb13d7bdaf90a07e6993e1b7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCCCACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(773,'37073c649a9b254a127ccbf4d6142b10','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(774,'0372499603839e39e1ddbd5d90182be9','ATCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(775,'1d6f74a0d9f439dbc67626e473dbd754','GTTCCGTAGGTGAGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(776,'edb8670563451a6a154d5438d9e90e12','ATCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(777,'360278fe99c1e78da46843292a75393e','AATCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(778,'0103977ae3e3533fef87584d57cd9d95','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGTCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACTTTTTCTGATGATACT');
INSERT INTO its1_sequence VALUES(779,'28c0fccc653470c8a3102071658fd2ad','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCATTCCAATATTTTCTGATGATACT');
INSERT INTO its1_sequence VALUES(780,'9e1d3498e37fd7ba98a1f01230ff0194','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGGACTGTCTGTGATGTTGGGGGCCTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGAGTAGTAGTTACTTTTTGTAAACCCATTCCAATATTTTCTGATGATACT');
INSERT INTO its1_sequence VALUES(781,'1887ada0e8c19ad524b8a4fdb9aafa19','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGTTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(782,'99013ce0fe7a9115a0c9af86d9d7c052','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(783,'5f5878afffea8638cc2aacc28f949dcb','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(784,'cfde732a2e3e43a9d7e59a44d914e4e2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCACCTAGTTGGGGTTCTCGGTAGCTGTGTGGCATGTGGACTCGTTCTACGTGCTGCTGGCGGCTGAGACCTATCATGGCGAGCGTTTGGGCTTTCGGGCCTGGATTAGTAGCCCTCTTTTAAACTCATTCTGTAAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(785,'8c6ab9e16d51ecb45144aea499b096c0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCAATAAATTGGGGGTTTAATTGGCGGTGGCTGCTGGCATCTTTTTGTTGGCGGCTGTTGCTGAGCAAGCCCTATCATGGCGAACGTTTGGACCTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(786,'218adb11e4c9d1e926bb3341ddd0366a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCATAAAAACTTTCCACGTGAACCGTTGAAATCATGTTCTGTGCTCTCTTTCGGGAGGGCTGAACGAAGGTGGGCTGCTTAATTGTAGTCTGCCGATGTATTTTTCAAACCCATTTACCTAATACTGATCTATACTCCAAAAACGAAAGTTTATGGTTTTAATCTATAACAACTTTCAGCAGTGGATGTCTAGGCTCGCACATCGATGAAGAACGCTGCGAACTGCGATACGTAATGCGAATTGCAGAATTCA');
INSERT INTO its1_sequence VALUES(787,'c66a0ace8143902f39061e53dbd71c14','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAACAACTTTCCACGTGAACCGTATCAACCCTATGTCTTGGGGGTTTGTTTCATGACCGCTGTTGGCATGTTTTGCTTGATGGCTACTATGGAACGAGCCCTATCGTGCGTGTTTGGACCTTGGTCTAAACAAGTAGCATTAATATTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(788,'45eda0a18d2010bdd33fba26a3011e61','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACAACTTTCCACGTGAACCGTATCAACCCTATATCTTGGGGGTTTGTTTCATGACCGCTGTTGGCATCTTTTTGCTTGATGGCTACTATGGAACGAGCCCTATCGTGCGTGTTTCGACCTTGGTCTGAACAAGTAGCATTAACATTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(789,'c04c1213903ccdf691a81064a0cdf8e4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCATTACTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(790,'7aae9031be0b11a9b65e5eaf6d3e1c6d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(791,'3eebed5a2713b4857c48939e5b8df627','TTTCCGTAGGTGAACTTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(792,'87bde5e81c6774b3b95fb5c9f21b2fe4','TTTCCGTAGGTGAACCTGCGGAAGGATCWTTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCCTTACTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(793,'4d65be9a82ff26f5b0dcbfe7e7b40a6d','TTTCCGTAGGTGAACCTGCGCAAGGATCATTACCACACCTAAAACACCTGTCCACGTGAACCGTTTGTGAAGCAGTTGGGTCGGTTGTCGTTTCGCGACTGCCTGGCCATCAAGGAGTAGTGTGTTTGCGCACATCTCTCCTTCGCTTTAAACCCATTTCAATTGAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(794,'3475cfebaf0d58404caab5615d582481','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCCCGTGAACCGTTTCAACCCAATATTTGGGGGCCTTATTTGCCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCGGCTGACTGAGCCCTTTCAAAAAAAAGCCCAACGTTTGGGCTTCGGCCTAATTTAGTATTCTTTTTTTCCTCTAAACCCATTCCTTAATACT');
INSERT INTO its1_sequence VALUES(795,'64f040ddd9dae79f1c2a51b4fa8d372c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAATTCCACGTGAACCGTATCAAATTTTTAAGTTGGGGGTCTTGTTTGGCGTGCGACTGCTTCGGTAGTTGCTGCTGGGCAAGCCCTATCGCGAACCGTTTGGACTTCGGTCTGAGCTAGTAGCTAAATTTTTTAAACCCATTAATTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(796,'294b8b10a14322f4dd2a6c23691b0029','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGTTTCATTGGCGGCTGCTACTGGCATCTTTTTGCTGGCTGGCTACTGCTGAGCAAACCCTATCGTGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGAATTTTTAACCCATTCTTACATACTGAAATTACT');
INSERT INTO its1_sequence VALUES(797,'14f347f90d6e0ff135b1199dc40e6c1f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGYGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(798,'dd8d1ab6129ea9ab0e9121309218a6c6','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(799,'f64d6bbb45ff34d9fd5f42693be578fe','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGCTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(800,'7cdc9f2ee5c786329e4364cf3659c82a','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(801,'787fc8e8e605798b17d7d8209533828f','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(802,'b8e8b744951d6256ae03b8c2095fe76c','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(803,'214c78f65764a863dad8cc5f44119ed0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(804,'87c49e58b385e5347538b50b1cd8e0a6','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(805,'bfb111d0803aa80122a862284a471ba8','TTTCCGTAGGTGAACTTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(806,'91a57596fb3cce8b687bebb30a29ef2b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTGGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(807,'49758de9498ea675be5912baa90abaac','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTTGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(808,'7b530ceacdffa9f6a2d74cd7013c62b0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTACTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(809,'40103bb284376757dddd792b05edabf5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCCTGCCTGCTGGCCTGTAATGGGTTGGCGTGCTGCTGCTGGGCCGGCTTTATCATGGGCGAGCGGTTGGGGTTTGGCTTGAGGTTGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(810,'2e8aa2a83c42d7530ee26750e81fc075','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCCTGCCTTCTGGCCTGTAATGGGTTGGCGTGCTGCTGCTGGGCGGGCTTTATCATGGGCGAGCGCTTGGGCTTTGGCTCGAGCTTGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(811,'0673593abf6e6947da5b2e9f34002f28','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTTGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(812,'e7a5484da94577caa7bddb51c92be5b9','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(813,'d32a870434817af3da15653334feb977','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(814,'349bc0b31fe130b2a1b17fae711a802a','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(815,'b2fe2a97b047e98934e86bc24acdce46','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(816,'8395798f08e3be866f3ce4e0e29a630e','TTTCCGTAGGTGAACGTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(817,'4c0503621dab654c7fadd31c85f05843','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(818,'a4a4274bd489ce903dbe89605d172235','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(819,'d5dcfc50de533c6a4dc04e1552e5ef2c','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(820,'07bf081f75634d5f7d1f5e516b55b331','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCCTATAATTTGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(821,'3bd5720f7e529ba4830ab3970bc709b2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(822,'d7b39edee0c8b6580b92799394509952','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(823,'c5fdfd74a90a5ffdbf9ca47ac81025c3','TTTCTGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTAGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(824,'37337465b07c71311de188b4f2b7f5b7','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(825,'3d8e523d9b764fc1aa11b27658c7216a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(826,'bfd9ace0d95f4b45e232001d6d358933','TTTCCGTAGGGAACTGCGGAAGGATCATTACCACACTTAAAACTTTCCACGTGAACTGTCTGTGATGTGGGGGCTGTCTGCCTGTTGGCGGCGGCTCCATCAAACGAGGCTCTGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(827,'f5a0401ca6371fb4614ceb55e5842d74','TCCGTAGGGACCTGCGAAGGATCATTACCACACCTAAAACTTTCCACGTGAACTGTCTGTGATGTGGGGGCTGTCTGCCTTTGGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(828,'46fe5730f64be11bcf5f1202a9581500','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGTTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(829,'d945b2321c41c3b3ae4cf9f5bcb4dbff','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCTTTCTTAAAAAACTGAACATACT');
INSERT INTO its1_sequence VALUES(830,'6a9d08d481246f5171f1342be7284bd2','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(831,'44acd6ea9163bde807c8bd15210d1bbe','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(832,'c10f243d1b62c84af47e4f22ba3f9745','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(833,'53a029e622e744b1d5bf615bc49cb4eb','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(834,'6d616d9c50baec27d44d31b8d401be89','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTYTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(835,'97c2dff00e2155757700caaea357a8a3','TTTCTGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(836,'415410a6be65fad641df16d856354372','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTRGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTCCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(837,'e32346ee3cc6cdb95a523893c78b1cbc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTTTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(838,'6117ab04ddb0dfded99fb9295ae40dfc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGRCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(839,'6ce55a5b41379afa19282addbe42ee84','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTAGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(840,'fc789b5ed63b0ea04a61aa066b8d6900','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(841,'c1b4973c04a5f8e3604019a09b25bbe2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAAATACTGAAYATACT');
INSERT INTO its1_sequence VALUES(842,'45763fe0cb7f75f80f6d3fd285a6e9a1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCYCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(843,'fd87b504d3758f0ea3165820866c6b74','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGTCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(844,'80129190c537d933d3d94b07b6acd9ed','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACTTAAAAACTTTCCACGTGAACCGTATTAACAATTATAATGGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(845,'a8c8d2dc73c9db3aceb8609707f6ce21','TCCGTAGGTGAACTGCGGAAGGATCATTAACACACTAAAAAACTTTCCACCTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(846,'9b30c985c59508690f12d2c5f9397583','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACTTAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(847,'5d82c115a21efd576c2828806680398b','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTTTTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(848,'2f924c2ad6d64bb58651af856683e9da','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACCTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(849,'810139eea4997e745eef57eef8eb5925','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACTTAAAAACTTTCCACGTGAACCGTATTACCAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(850,'c5fc854fc068eebda3c52dae6648393c','TCCGTAGGTGAACTGCGGAAGGATCACTACCACACTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(851,'245e153c69d4125c529d8c2b3894bf30','TCCGTAGGTGAACTGCGGAAGGATCATTCCCACCCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATGGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(852,'a9861207cf15d66a39dbbcdbd4f1da6e','TCCGTAGGTGAACTGCGGAAGGATCATTACCACCCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(853,'bc202404a2afc98dd98b425d03dfa3a0','TTTCCGTAGGTGAACCTGCGGAAGGATCATCACCACACCTCAAAAACTTCTCACGTGAACCGTTTCAACCCAATAGTTGGGGGTATTATTTGGCGGCGGCTGCTGGTGTAATAGTTGTCGGCTGCTGCTGAGTAATCCCTATCAAAAAAAAAGGCGAACGTTTGGGGCTTCGGCCTGATTTAGTTAGTTTTTTTTTCTTTTACAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(854,'55e0bda7c74732074453002bddd5a5df','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTTAATTGGCGGCTGCTGCTGGTATCTTTTTACTGGCTGGCGGCTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(855,'e006fbee2ea65903c2cf370e0c01644d','AATGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(856,'fffc8ca05179c4ee3d36a0a6145ee1a8','ATTGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(857,'716164a30f0693e67b1d2e0f4fdcf1ed','GCAGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(858,'e32d4c97dea72b4e7fbd8daff86c8247','TTTCCGGTAAGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(859,'2fa3fa314bee97bec9353997bfb33c24','TTTCCGTAGGTTGACTGCGGAAGGATCATTACCACACCATAAAAACTTTCCACGTGAACCGTTACAATTATGTTCTGTGCTCTCTCTCGGGAGGGCTGAACGAAGGTAGAGCTGCATGTTAAAGTGCGGTTTCTGCCGATGTACTTTTAAACCCATTACACTAATACTGAACTATACTCCGAGAACGAAAGTTTTTGGTTTTAATCAATAACAACTTTCAGCAGTGGATGTCTAGGCTCGCGCATCGATG');
INSERT INTO its1_sequence VALUES(860,'4418860f4c4c9c7a9624aebc42af412e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCCCACCAAAAAAACTTTCCACGTGACCCGTTTTGTGCGTTTTGTGCTTTGTGTTTGCTTTTGTTTGTCTCGCTCTTCGGGGTGTGGTGAAGAAGAGGAAGCGCAAGGCTAAACGAAGGCTGCGAGTCTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAACACTGAACTATACT');
INSERT INTO its1_sequence VALUES(861,'83a77f47e93e6a0c24a82ac3b520841c','TTTCCGTAGTGAACCTGCCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(862,'8a90868597e39d6022e18e35af2bd920','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGTCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(863,'776d7fe7659da743d1ea6354e0d4c26f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGRCTTTATTGTTGGCGGCTGCTGCTGGRYGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(864,'b3dba9fe986be0cbd7eaba174629e329','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGRGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(865,'18232970a6d564f54e4649d0a206091e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(866,'f50cdac836eafa107a43d5dc2a7a1cfd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGKCTGTCGATGTCAAAGTCGACGGCTGGCTGCTRTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(867,'d51cac62893847dacdcf8ad9537ca2cc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTYTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(868,'63557a7e131edfbee297906141db19de','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCRTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(869,'5ee5253f198df6f18113950c73720207','TTTCCGTAGGTGAACTGCGGAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(870,'a6c1d01ea30e8a9b97f8e73e5bf60304','TTTCCGTAGGTGAACTGCGGAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(871,'20eddc875172304412c495dad98eb03a','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTRCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(872,'623e495742c5a624949e09321e254934','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACCCCTAAAAAACCTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTTTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(873,'55172f9e1424726af3b5e3d45264c2d4','TTTCCGTAGGTGAACGTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(874,'4d8f5abc348efd8b24565d378a49e095','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(875,'b32c788be80116af1bfbc4bb0a193efe','CTTCCGTAGGTCAACCTGCGGAAGGATCATTACCACCACTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTCGCATTTTGCTGAGCCGCGCCGTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGGTTTTAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(876,'b7d07c8adaafc0fa1674f319b82e7add','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTTTTATTCGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(877,'9ebe18312d6cf790be0a1f7af58fc1e7','TTTCCGTAGGTGAACCTGCCGAAGGATCATTACCACCCCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(878,'ddb451bcd1ea54169fc8bd1ab70b9146','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACGCCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(879,'4016b08de4a00c23d00285693efa9b4f','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGAGCTGTCTGCCTGTTGGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(880,'8d8c394cf88ca412d75f8900ac21b280','TTTCCGTAGGTGAACCTGCCGGAAAGGATCCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(881,'c13b2be38ae87d8b32f21d47805827ee','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(882,'5b6d09f18c32289e5027fa24ec044180','GTTCCGTAGGTGAACCTGCAGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(883,'8c0cc73466c8ed75403b80ea696d6d2c','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATACT');
INSERT INTO its1_sequence VALUES(884,'fb0d5faf9aae8a92e152c8de06bf107f','CTTCCGTAAGGTGAACCTGCGGAAGGATCATTTCCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTTGTTGGCGGGGTTGCGTGCTGGCCTGTAATGGGTTGGGCGTGGTGGTGCTAGGCGGGCTCTATTATGGGCGAGCGCTTGGGATTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(885,'27fdf5749d98cb64080f30940a7b15fe','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCCGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(886,'10616d908c4d092a4182365299a5ea13','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACCAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(887,'7c640a74741d88d1aa8d41565e443d6e','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAATCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(888,'dd21b9c6a00c5c05d930ac29e02046f5','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTAGTTGGGGGTCTTTTTCGGCGGCGGCTGCTGGTTTAATTACTGGCGGTTGCTGCTGGGAGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(889,'da7a47cdb10854a321b90967394991aa','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTAGTTGGGGGTCTTTTTCGGCGGCGGCTGCTGGTTTAATTACTGGCGGTTGCTGCTGGGAGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(890,'84c9e67bc2cf5f15e31071e9b34fbe9d','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGCGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(891,'b04d3611b6b58a4957e4d19fe341d1e4','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(892,'1965d94cf09538222eabeab061fbf751','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(893,'5090f1ffdd54f81f7c8aa73b42facd62','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTKCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(894,'3294fc64512805d3301442046c30aba3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(895,'cd4a834ba83015f7ea444e1e2bb92ba1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGTGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(896,'49c7dbfa3024522a5f4cfc8dd6d84914','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGTGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTTGAGGCCATCAAGCGGCGTTTTGAGTGTGTGTTCGCACACAATTAAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(897,'23c0e3b432b479395613e85954289549','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTTATTGGTGGTGGCTGCTGCTAGCATCTTTTTGCTGGCTGGCGACTGCTAAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(898,'45bea3ad64dda08df659b2055fe99bad','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCAATTAATTGGGGGTTTTATTGGTGGTGGCTGCTGCTAGCATCTTTTTGCTGGCTGGCGACTGCTAAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(899,'888e1383adce12bf83dbbbf657ea59b9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTCGTTGGCGGCTGCTGCTGGCATGTTTTTGCTGGCTGGCAGCTGCTGAGTAAACCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(900,'836c78e2e147d8b8eaa5c9e9776d9b77','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTAGTTGGGGGTTTGATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCTTGGTGATCGTTCTGACCTTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(901,'da5433f1bf2b7acd154847542e9c8d5b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCATTAGTTGGGGGTTTGATTGGCGGTTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCTTGGCGATTGTTCTGACCTTCGGTTGGAGTGAGTAGCTTGCATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(902,'bad6143729068c16a79878381981b4cd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTAGTTGGGGGTTTGATTGGCAGCTGCTGCTGGCATCTTTTGTGCTGGCTGGCGACTGCTGAGCGAACTCTATCCTGGCGATCGCTCTGACCTTCGGTTGGAGCTAGTAACTTGCATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(903,'a59480c18ef4ff69c9c15003cf807da3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTAGTTGGGGGTTTGATTGGCGGCTGTTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCCTGGCGATCGCTCTGACCTTCGGTTGGAGCTAGTAACTTGCATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(904,'a9bb0898e88d5cad0eba835b8dab3491','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTTATTGGGGGTTTCATTGGCGGCTGCTGCTGGCATCTTTTTGCTGACTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGTATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(905,'8d45c74e667faf5bd6f5f5a50cb8e1ef','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTTATTGGGGGTTTCATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(906,'3e6a8e21237f60e19806ab946a8568ac','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCATAAAAACTTTCCACGTGAACCGTTACAATTATGTTCTGTGCCTTCTCTCGGGGAGGCTGAACGAAGGTGGGCTGCTGTTATGGCGGACTGCCGATGTATTTTTCAAACCCATTTACTWAATACTGAACTATACTCCGAGAACGAAAGTTTTTGGTTTTAATCCATAACAACTTTCAGCAGTGGATGTCTAGGCTCGCACATCGATGAAKAACGCTGCGAACTGCGATACGTAATGCGAATTGCAGAATTCAGTGAATCATCGA');
INSERT INTO its1_sequence VALUES(907,'eae5d9539aad7b3b4908c2dcc166e5a7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(908,'6d6ee67552d25aab4403e65f6cc67790','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTCTGCTGCTCTTCTTCGGAGGAGGAGCGAGCTATCTGTAAACTTGTCAAACCCATTCTTACGATATAACTGAAACATACT');
INSERT INTO its1_sequence VALUES(909,'c565708ae7e9c40ba00b3109615502a0','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACACCTGTCCACGTGAACCGTTTGTGAAGCAGTTGGGTCGGTTGTCGTTTCGCGACTGCCTGGCCATCAAGGAGTCGTGCATGCACTTTTCCTTCGCTTTAAACCCATTTCAATTGAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(910,'c9a023b8460aa9e211864392211aaecd','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTAGTTACCCGATTAGCGCCGTGACGCGTGTCTGCGATGCATGTATGTGTGTTGTGGGCGTGTGGGCTCGGCTGATCGAAGGTTGTCGTGCCTGTTTGTGTTGCCTTGTGCGACGCGAGCGTGTGCGCGGCGGCTGACTTATTCTTTCAAACCCCTTACTTTAAAACTGATGTATACT');
INSERT INTO its1_sequence VALUES(911,'11ff28ca4561156bc0c7402d1c8ac9a7','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTTTTCTCTCTCTTTTGGGGGAGGGGATGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTTTTTGATAACTGAAACATACT');
INSERT INTO its1_sequence VALUES(912,'19908d3f510c222e6113b5763458a8a6','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGCTGTAACTTTGGGCTTCGCCGTTGTCTTGTTCTTTTGTAAGAGAAAGGGGGAGGCGCGGTTGGAGGCCATCAGGGGTGCGTTCGTCGCGGTTTCTTTTGTTTTTGGAACTTGCGCGCGGATGCGTCCTTTTGTCAACCCATTTTTTTGAATGAAAAACTGATCATACT');
INSERT INTO its1_sequence VALUES(913,'9a62b9dca9194feaefdd411bb7edb1d5','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAATCTTTCCACGTGAACCGTTTGTGACATTGTTGGGCTCTGCGCGTCTCGAGAGGGGTGCGCAAGCTATCTGTAAAACTTGTCAAACCCATTCTACCAATAACTGAAACATACT');
INSERT INTO its1_sequence VALUES(914,'71d4ec21b2298fd00f863ed1e13e87fb','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACATAAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGTCCTGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(915,'5a3589389576e7d444e0075dc4dc9c38','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTATTCACGTGAACCGTCAATTAAACCAGTTTTGTGTCGCGTTGTGTGCGTGTTTTCCATTTCAATTGCTTTTTTTAAACGAATCGCGAGCGAGGAGGAGAAGACAATCGCAATGTCGACTGAACGAAGGTCGAGTTTGTTTTCTATTCGTAGAGAACGAGTTTGGCTGATTTATTCTTTTTCAAACCCTAAATCCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(916,'df4fe29b427e58b5db6db8475783c528','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTCTGTCCGTTTTGTGCCGTTGCTGTTGTCTCGATTCGTCGAGAAGAGCAGTGGCTAAACGAAGGCTGTGAGCTTCGTGCTTGCGGTCGATTTATTCTTTCAAACCCCATACGTTAAGAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(917,'bc12f543302b074257b895adf44ba142','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAACTAGTAGCTAAATTTKTRAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(918,'bc2d4c68f3219db3457e1fd8eb0c5aba','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATTAAAACTTAGTTGGGGACAATTCGGGCGGCGACTGTAGACTTAATTGTCAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATCGTTTCGACCTTGGTTGAAGTTAGTAGCTGAATTTTTAAACCTTTAATTATACTGATTATACT');
INSERT INTO its1_sequence VALUES(919,'6ebc358ec63863572339406316c0ea24','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATTAAAACTTAATTGGGGACAAATTAGGCGGCGACTGCAGACTTTGATGTTAGCGATTGCTGCTAGATAAGTCTCATCATGGCGATTGTTTCGACCTTGGTCGGGACTAGTAGCTGTTCTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(920,'dc0072958501b8072c3f3a811d651dd8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAACTAGTAGCTAAWTTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(921,'856e82f26acaf6cfbdc547ebdc618bb9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAAYTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(922,'fc0b467c823e892f93eb0481303b7386','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAAYTTAGTTGGGRAYAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(923,'488cc087b1e94442c16254e017a85084','TTTCCGTAGGTGRACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAAYTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGRTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(924,'bcb76ba38308b87c078b8ddad271db9a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAAYTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAAYGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACWTTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(925,'83373f4979bf3e82d1ae5cab5cbe83d6','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAAYTTAGTTGGGGAYAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACMTTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(926,'37e48a8bf6ac7e823cff9c7689a1825a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTYTATTGTYAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(927,'0e2c7b50412fd62188bd71a3d64f2016','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCRTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(928,'8381608534dcae00658a5b9391372bcd','TTTCYGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTACAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAATTAGTAGCTAAATTATTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(929,'2a1c898bf1fe1f77c7d0cace33d5d2f4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATMAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(930,'15793e77128f6da2b829051aec3de1ea','TTTCCRTAGGTGAACYTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAAYTTAGTTGGGGACAAATTAGGCGGCGAYTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACWTTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(931,'3a20de18b27eaa2ce27a76e5fb40c0a3','TTTCCGTAGGTGAACCTGCGGAAGGATCAYTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAAYTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACWTTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(932,'535ab17a6972b3b10cb741e5a657ec9b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACWTTTTTAAAYCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(933,'9422b4c2d8e1541810f119143916b91a','TYTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAARACTTCCACGTGAACTGTATCAAAAYTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACWTTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(934,'d40420b1045a68a0d0c41fafc46f5669','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTARAAAACTTCCACKTGAACTGTATCAAAAYTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCAYCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACWTTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(935,'8584c284c9ebd5783b986fbbe81f176d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAARAACTTCCACGTGAACTGTATCAAAAYTTAGTTGGGGACAAATTAGGCGRCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACWTTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(936,'846c85dcefb60e671b95fd5cae5b88d0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTAGTGATTATACT');
INSERT INTO its1_sequence VALUES(937,'8f99a94eeefb42f0b0037f7fe2541e82','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGCTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(938,'ea6ffeb05118e0f2127b3f646ad1f80f','TTTCCGTAGGTGAACCTGCGGAGGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAGACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(939,'73cb087b6394781382ef6baf2de6617c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTCAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(940,'a39b9dd85f775e08b719caefa418e240','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTCTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(941,'3c0025ad90eacdeef05730487d5fda42','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTCTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(942,'65ec3e506822419f35705022a37e4f17','TTTCCGTAGGTGAACCTGCAGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(943,'87c938df3d48662248a41b984983ac0c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTAAACT');
INSERT INTO its1_sequence VALUES(944,'16cf6bf570063e60116c9830e3f58093','YTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAARAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(945,'1fbf254f52d1cbcc4765eb5758888785','TTTCCGTAGGYGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAAYTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACWTTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(946,'35c3dec9f51051bad76ee1cbc5fbd79d','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(947,'16140c5d5e9806903424c6cd5e0690ca','GTTCCGTAGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(948,'ef222fce3a4926631ea94bbef8f03ab9','GTTCGTAGTGAACCTGCGGAAGGATCATTACCACCACCTAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGGTGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGATCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATTATACT');
INSERT INTO its1_sequence VALUES(949,'ca7992bb1226646d3415466768b3dadf','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACCACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(950,'8714a9572c7bc6990202b30ef443306e','GTTCCGTAGGTGAACCTTGCGGAAGGATCAATTACCCCCCCTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(951,'8a7bc8e4c86c91decf1057b7c712dbbe','GTTCCGTAGGTGAACCTTGGGAAGGATCATTACCACCACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(952,'35f6b757b45c69c902858905d8aadf6d','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTTAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(953,'a278bbfe77516ac2440c9456261ab1d5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTTAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(954,'9bef5e33ff3992b04d7804bda3cee669','TTTCCGTAGGTGAACCTGCGGAAAGGATCATTACCACACCTMTAAAAACTATCCCACGTGAACCGTTAAGCAACAAGTTAAGGCAGGCGCGATTGGTGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGATCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATTATACT');
INSERT INTO its1_sequence VALUES(955,'455583b76c9ede9d267fb97b5252df3b','TTTCCGTAGGTGAACCTGCGGAAAGGATCATTACCACACCTAAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGGTGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGATCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATTATACT');
INSERT INTO its1_sequence VALUES(956,'a486452589cad0221028f09b77432306','GTTCGTAGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(957,'f0aa60b3fe8f667959405a85867b99f7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTTCCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGGTGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGATCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATTATACT');
INSERT INTO its1_sequence VALUES(958,'b2675dbd8ed49706747c2cf0a7c31a03','TTCCGTAGGGAACCTGCGGAAGGATCATTACCACACTTTAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTAACTGATCTAGTGTTTTCCTATTTTTGGGACACTGGAATACAGGATTCAGCAGGACGAAGGTTAGTCTCTCGTAATGCAAATTAGGAGGACTAGCTGATGAACTTTTCTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(959,'2be420a2048fc47f1b8867471105c36e','GTTCCGTAGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTTTTTTCGATCTGCTGCTCTGTGGAGTGTGTGGGGAAGAGAAAGCTCCAGGCTAAACGAAGGCTGCGAGTTTCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATGAAATACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(960,'20443baae8a0e84017178a3d325e9296','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTGTTTTTCGATCTGCTGCTCTGTGGAGTGTGTGGGGAAGAAAAAGCTCCAGGCTAAACGAAGGCTGCGAGTTTCGAGTTTCGTGCTTGCGGTCGATTTATTCTTTCAAACCCATACATTAAATACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(961,'9a45bc1b8b5d20ccc48756fc8f6df038','TTCGTAGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTTTTTTCGATCTGCTGCTCTGTGGAGTGTGTGGGGAAGAGAAAGCTCCAGGCTAAACGAAGGCTGCGAGTTTCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATGAAATACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(962,'03056e9093d9a51a5cf5dc4caa0ad4c3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTTTTTTCGATCTGCTGCTCTGTGGAGTGTGTGGGGAAGAGAAAGCTCCAGGCTAAACGAAGGCTGCGAGTTTCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATGAAATACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(963,'55ee6f9121d8d809915d80c5cf136fa2','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAANAACTTTCCACGTGAACCGTTCTGTCCGTTTTGTGCCGTTGCTGTTGTCTCGATTCGTCGAGAAGAGCAGTGGCTAAACGAAGGCTGTGAGCTTCGTGCTTGCGGTCGATTTATTCTTTCAAACCCCATACGTTAAGAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(964,'af92eae1129194995c87b098be2654d5','GTTCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTCTGTCCGTTTTGTGCCGTTGCTGTTGTCTCGATTCGTCGAGAAGAGCAGTGGCTAAACGAAGGCTGTGAGCTTCGTGCTTGCGGTCGATTTATTCTTTCAAACCCCATACGTTAAGAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(965,'56aeb2a58e948afa72cfc08125ee66a4','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTAACTGATCTAGTGTTTTCCTATTTTTGGGACACTGGAATACAGGATTCAGCAGGACGAAGGTTAGTCTCTCGTAATGCAAATTAGGAGGACTAGCTGATGAACTTTTCTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(966,'254b758bbf7f85b89178969d57c539ec','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTTTTTTCGATCTGCTGCTCTGTGGAGCGTGTGGGGAAGAGAAAGCTCCAGGCTAAACGAAGGCTGCGAGTTTCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATGAAATACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(967,'2cf601ba47b04971378f8ea2646c9308','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(968,'9d5087894443343fb1b2116208a8822a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(969,'62c630c5b6cbcb55d5ac33bbc0d1b370','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGCAGTCAGCAGGACGAAAGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(970,'64d657dd6f773676a1c5e4cd06196744','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTCTGTCCGTTTTGTGCCGTTGCTGTTGTCTCGATTCGTCGAGAAGAGCAGTGGCTAAACGAAGGCTGTGAGCTTCGTGCTTGCGGTCGATTTATTCTTTCAAACCCCATACGTTAAGAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(971,'d371583fc04930d29403715e308dae37','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCTCCACGTGAACTGTCTGATCCGATTCGCGCCGTGACGCGTGCTGCGGGTTTGTAAAAGAATCTGCGGCGTGCGGGCTCGGCTGATCGAAGGTTTCATTGCTGCGAGCGTGTGCTTTTCGGAGCGCGCGTTTCGCGGCGGTGGGGCTGACTTACTCTTTCAAACCCCTTTACCGAATGACTGATGTATACT');
INSERT INTO its1_sequence VALUES(972,'a91fc675a99a1c210680b44cd9a737d4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTTCCACCCTAAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGATGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGAGCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATGATACT');
INSERT INTO its1_sequence VALUES(973,'35cf41da0aa1e76a1ad2671a378ba538','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCTCCACGTGAACTGTCTGATCCGATTCGCGCCGTGACGCGTGCTGCGGGTTTGTAAAAGAATCTGCGGCGTGCGGGCTCGGCTGATCGAAGGTTTCATTGCTGCGAGCGTGTGCTTTTCGGAGCGCGCGTTTCGCGGCGGTGGGGCTGACTTACTCTTTCAAACCCCTTTACCGAATGACTGATGTATACT');
INSERT INTO its1_sequence VALUES(974,'52695afec93993744b2fce322a20dc9c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCTCCACGTGAACTGTCTGATCCGATTCGCGCCGTGACGCGTGCTGCGGGTTTGTAAAAGAATCTGCGGCGTGCGGGCTCGGCTGATCGAAGGTTTCATTGCTGCGAGCGTGTGCTTTTCGGAGCGCGCGTTTCGCGGCGGTGGGGCTGACTTACTCTTTCAAACCCCTTTACCGAATGACTGATGTATACT');
INSERT INTO its1_sequence VALUES(975,'ad4b7954375a5138b52c4f4441248437','TTTCCGTAGGTGAACCTGCGGAAGGGATCATTACCACACCCAAAAAAAACTTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTTGTGTTTGCTTTTGTTTGTCTCGCTCTTCGGGGTGTGGTGGACAAGAGGAAGCGCAAGGCTAAACGAAGGCTGCGAGTCTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAACACTGAACTATACT');
INSERT INTO its1_sequence VALUES(976,'e22c4c4875a52883adf8f290b0e943d1','TTTCCGTAGGTGAACCTGCGGAAAGGATCATTACCACACCTAAAAAACTCTCCACGTGAACTGTCTGATCCGATTCGCGCCGTGACGCGTGCTGCGGGTTTGTAAAAGAATCTGCGGCGTGCGGGCTCGGCTGATCGAAGGTTTCATTGCTGCGAGCGTGTGCTTTTCGGAGCGCGCGTTTCGCGGCGGTGGGGCTGACTTACTCTTTCAAACCCCTTTACCGAATGACTGATGTATACT');
INSERT INTO its1_sequence VALUES(977,'5959c180cc6bd1e44810fd57b975981e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTAACTGATCTAGTGTTTTCCTATTTTTGGGACACTGGAATACAGGATTCAGCAGGACGAAGGTTAGTCTCTCGTAATGCAAATTAGGAGGACTAGCTGATGAACTTTTCTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(978,'084f3bcc2638c0936ee0f30343a4be6d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTTGAGTGCTTGCACAATTAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(979,'faeb53445fe42c7c6629309cb0e95f6e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGTACACTGTTGGGTTTCGCTGGCGCGTGTTTTCTTGTCGAATGTAGTGTTTGACGGCGCGCGGCGGCTGGAGGCCATCAGGGCGTCTGTTGTTGTGATGGACGCTCTTTTTGTAAACCCCCTTTTTTTTTATTTTGTGAAACTGATTGGACT');
INSERT INTO its1_sequence VALUES(980,'82a84fb62742c2dd370401c8a4c3f34b','TTTCAGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAACCGTATCAACCCCCTTCGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(981,'df9d3e9c1f49c6b45fb43077fb35d708','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAATAACACCCTTCCACGTGAACCGTTCTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTCTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(982,'a08e4a202160b94cecaf814f9e4aaa69','TTTCCGTAGGTGAACCTGCGGAAGGATCATTTCCCACACCTAAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(983,'f6b4a1cb2cea8ff4659ec51c1489d23a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGATTTGCTTGGTGTGCGGCTAGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTGGGCGAGTCCTATCATGGCAAACGTTTGGGCTTCGGTCTGAGCAAGTAGCTTTTTTTAAACCATTTCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(984,'fd86e8ee2cab3b478ceeeee5cbeaf4f2','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(985,'e59f3460fb7785d83ed77f178f83117f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGCTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(986,'caa2893d0eb5a4f368078ada4b94f643','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAAACCCGTWTCAACCCAATAWTTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGCTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(987,'8ce34b6a6687e801135420f9a6142690','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCTGTTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(988,'90185ec7af557bbf42427e24cd41f8e7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCGGCTGCTGGCATAGTTTTGCTGGCTGCTGCTGCCGAGTGAGCCCTATCATGGCGAGTGTTTGGACCTCGGTCTGAGCTAGTAGCTTTAATTTCAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(989,'77afb165ed2e7caeca7f24a9ebc1f86c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGCTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACACTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(990,'d05cfc7afc0c835e1bd9810002fefb71','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTCATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(991,'03c1551f4098935690ea8d879bbe01db','TTTCCGTAGGTGAACCTGCGGAAGGATCATTCCCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCATACATTGGGGGCTAATTTGCCCTACCATGGCGAGTGTTTGGACTTCGGTCTGAATTAGTAGCTTGAATTGTAAACCCTTTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(992,'075892f9e6b64c0b394d6cca9c054485','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTTCACGTGAACCGTATCAAACACTTTATTGGGGGCTGACTTGGTGGCGGCTGCTGGTATCTATTTTTTTACTGACTGGCTGCTGCTTTGAGAAAGCCCTATCATGGCGATCGCTTGGACTTATATTCGAGCTAGTAGCTACTATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(993,'85fe415b12c6552982281f36c0628882','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGAGCTTGTTTGGCGGCGTGTGTGTTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(994,'389db2cedc1847cdab796af43fa0753a','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAAAATTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGTGGCTGTTGTTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(995,'303f97b0ef55cd727448ab47d1eb6ecb','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAAAATTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGTGGCTGTTGTTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(996,'c2a49809ff5c007215e9930089cbde9c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAAAATTAAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGTGGCTGTTGTTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(997,'9e66292bf57505d45468b05dd41a952c','TTTCCGTAGGTGAACCTGCGGAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAAAATTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGTGGCTGTTGTTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(998,'cafbd617a91c7cd7237e2a1abd0537c7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(999,'4eb736bccc03228c9d26a7947ca998cf','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCCGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1000,'ad12baaa7843a74d3ad851c437ebdb82','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1001,'b2926ecff45a634f167244f4dd6e3e69','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCACGTGAACCCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1002,'43bd9bcbfa6f070215e142eaeeb9b67c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGTTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACTCCTTTCTTAAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1003,'e06f12ffa0d39a27e61fbdf4b69e631e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTNCTTTATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1004,'312a8c106c3bba28ec0550e1991756a4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTNCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGNGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1005,'1bec8fbd147dc77e10fdf850fa2064ed','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1006,'5025b608a8298ba088ad09e497598208','TTCCGTAGGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1007,'744ba4681d0c75c64dada316de98f885','TTTCGTAGGTGAACCTGCGGAAAGGATCATTACCCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1008,'6acdafa593dce6702d292f27b2336942','TTTCCGTAAGGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1009,'46f9fbe531ea4cc217088c772823d949','TCCGTAGGGTAACCTGAGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1010,'ea4c443a80892b91571f6bc0c4df6ca3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGTGTTCGCATACAATTAAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(1011,'0b4fcfd6140b2540b97ff2cebd58db02','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCNTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGTGTTCGCATACAATTAAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(1012,'6dac899b75ce53c7900abbec1d9ff0c7','GTTCCGTAGGGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(1013,'7c215b6179d17ddcdb386bd01e691378','TTTCGTAGGGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCTCCACGTGAACTGTTCGTATAAGATTAGCGCCGAGATTTTCGTGCGTGTTTGTGGTATCGCTATGTATTCGTACGTGGCGTTAGCAAGCATTGTATGGAGCTTGGCTGATCGAAGGTCGGTGTGCACCTTGTGTGTGTATCGGCTGATTAACCTTTCAAACCCTTTAAATTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1014,'512721f332d1d8d2b76997dd281d457f','GTTCGTAGGGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCTCCACGTGAACTGTTCGTATAAGATTAGCGCCGAGATTTTCGTGCGTGTTTGTGGTATCGCTATGTATTCGTACGTGGCGTTAGCAAGCATTGTATGGAGCTTGGCTGATCGAAGGTCGGTGTGCACCTTGTGTGTGTATCGGCTGATTAACCTTTCAAACCCTTTAAATTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1015,'3172ad37a07926906d88d22317b0d826','TTTCGTAGGTAACCTGCGGAAGGATCATTACCACACCTAAAAACTCTCCACGTGAACTGTTCGTATAAGATTAGCGCCGAGATTTTCGTGCGTGTTTGTGGTATCGCTATGTATTCGTACGTGGCGTTAGCAAGCATTGTATGGAGCTTGGCTGATCGAAGGTCGGTGTGCACCTTGTGTGTGTATCGGCTGATTAACCTTTCAAACCCTTTAAATTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1016,'494ebc22952d9af02324e88fc56e0428','GTTCGTAGGTAACCTGCGGAAGGATCATTACCACACCAAAAACAACTTTCCACGTGAACTGTCTTACGAGATTCGCGCCGTGACGCGTGTTGGCGCTGTGTGTGTCTGTGTCTTCTTTCGAGAGGATATTGTGATGCAAACAGTGTTGACCGTGTGGGTCGGCTGATCGAAGGTCGCTTTGTGCATTATTGTATGGAGCGGCTGACTTATTCTTTCAAACCCATTACACAATACTACTGATTCATACT');
INSERT INTO its1_sequence VALUES(1017,'a64c4ae066e89ab715e04d0dfafbe8d9','GTTCCGTAGGTAACCTGCGGAAGGATCATTACCACACCAAAAACAACTTTCCACGTGAACTGTCTTACGAGATTCGCGCCGTGACGCGTGTTGGCGCTGTGTGTGTCTGTGTCTTCTTTCGAGAGGATATTGTGATGCAAACAGTGTTGACCGTGTGGGTCGGCTGATCGAAGGTCGCTTTGTGCATTATTGTATGGAGCGGCTGACTTATTCTTTCAAACCCATTACACAATACTACTGATTCATACT');
INSERT INTO its1_sequence VALUES(1018,'25df7ccdea6c54d2aee64d1b545f1d7e','TTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTTAAAACTATCCACGTGAACCGTTTGTACCCAGATTTGCGCCGAGATTTTCGTGCGTGTTTGTTTGTATCACTGTGTATTCGTACGCAGTGTGTGGCAAATATGTATGGAGCTTGGCTGATCGAAGGTCGTATCGCACTTTATTGTGTGTGTCGGCTGACTTATTTTTCAAACCCATTACTTACTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1019,'8d9f501ed50d6e798c8ead01b438b5ab','TTTCGTAGGGAACCTGCGGAAGGATCATTACCACACCTTAAAACTATCCACGTGAACCGTTTGTACCCAGATTTGCGCCGAGATTTTCGTGCGTGTTTGTTTGTATCACTGTGTATTCGTACGCGGTGTGTGGCAAATATGTATGGAGCTTGGCTGATCGAAGGTCGTATCGCACTTTATTGTGTGTGTCGGCTGACTTATTTTTCAAACCCATTACTTACTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1020,'4b58cc2d0e30658c85ac693592ae3e63','TTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTTAAAACTATCCACGTGAACCGTTTGTATGAAGATTTGCGCCGAGATGTTTGTGCGTGTTTGTTGTATCACTGTGTGTTCGTACGCGGTGTGTGGCAAGTATGTATGACGCTTGGCTGATCGAAGGTCGATATGCACTTGATTGTGTGTGTCGGCTGACTTATTTTTCAAACCCATTCTACAGTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1021,'464fb2453ed1bf80f0f3a4be2615a77a','TTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTTAAAACTATCCACGTGAACCGTTTGTATGAAGATTTGCGCCGAGATGTTTGTGCGTGTTTGTTGTATCACTGTGTGTTCGTACGCGGTGTGTGGCAAGTATGTATGACGCTTGGCTGATCGAAGGTCGATATGCACTTGGTTGCGTGTGTCGGCTGACTTATTTTTCAAACCCATTCTACAGTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1022,'e07ca9536f1d7933e30514b718c24405','GTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAAACTATCCACGTGAACCGTTTGTATGAAGATTTGCGCCGAGATGTTTGTGCGTGTTTGTTGTATCACTGTGTGTTCGTACGCGGTGTGTGGCAAGTATGTATGACGCTTGGCTGATCGAAGGTCGATATGCACTTGATTGTGTGTGTCGGCTGACTTATTTTTCAAACCCATTCTACAGTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1023,'904a5aecace708dc17e059afc51523c9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTCCCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(1024,'1fae0f13e51bc87faae2c6d4e1502985','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1025,'912e1f1a91937bd17ff670bc36b7be16','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTACGAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1026,'290746c0a5177dfd5233486cb35e0df2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1027,'809eeee5c9feee79f02281161dd64e8e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCCGCTGCTGAGTGAGCCCTATCAAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1028,'5eaddf6a1456bff8aef5b43e83c9d4ae','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACGCCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1029,'a3b5ff2c4259f1151d567363e168736e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCCCACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCACTAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1030,'e64b8c3a6a36dc2a9ea68e830f0847a5','TTTCCGTAGGTGAACCTGCGGAAGGATCTTTACCCCACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1031,'abefb4e6377f84f650e1a7f3615e1718','TTTCCGTAGGTGAACCTGCGGAAGGATCATTCCCCCCCCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTTTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1032,'d46cc27995065661a2f890250827bc6c','TTTCGGTAGGTGACCTTGCGGAAGGATCATTACCACCACTTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1033,'152c8173704801a56c115cbc3f6160c6','TCTCCGTAGGTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATACT');
INSERT INTO its1_sequence VALUES(1034,'4518fc107a247fe175293daee052ff69','TTCCCGTAGGTGAACCTGCCGAAGGATCATTACCACCACCTAAAAAACCTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTTGGCGGCGGCTGCTGGCTTAATTGTTGGCCGCCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1035,'59819862b7872062b3bf59320e44a35d','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACCCCCTAAAAACCTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1036,'7ad75c1d5789fd543d02a6c7317538c3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTACGAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1037,'da5a60a7f49f86257ff3703316d9786d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTTAATTGGCGGCTGCTGCTGGTATCTTTTTACTGGCTGGCGGCTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTTTGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1038,'c100f3b7044bdc40854e58dfe49b5670','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTTTTCTCTCTCTCTTTTGGGGGAGAGGATTCCTACCAACTATCAGTATACTTGACCAATCTCTTTTTTTTGATAGCTGAAACCTGCTGAGACGACAATCTTCTCTGCTATGAACAAAATATCTACTTTCAGCAGAGGA');
INSERT INTO its1_sequence VALUES(1039,'523a180e0d0117ba9e0ec0b4e85c1d8f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTTTTCTCTCTCTCTTTTGGGGGAGAGGATGCCTACCAACTATCTGTATTCTTGTCCAATCCCTTTTTTTTGATAACTGAAACCTGCTGTGAGGACAATCTTCTCTGCTATGAACTAGATAGCTTCTTTCAGCAGAGGA');
INSERT INTO its1_sequence VALUES(1040,'b41a637348c865e9d867746da928ad87','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTGTTTTCTTCCTTTTGGGGGAGGCTTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTCTTTGATAACTGAAACATACT');
INSERT INTO its1_sequence VALUES(1041,'69242a58097c246426b5f36f4e9414d9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTGTTCTCTCTCTTTTGGGGGAGGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTCTTTGATAACTGAAACATACT');
INSERT INTO its1_sequence VALUES(1042,'1fb2c0ff61e288eabe0e3740f5642d6e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTGTTCTCTCTCTTTTGGGGGAGGCGTGCGAACTATCTGTAGACTTGTCAAACCCATTCTCTTTGATAACTGAAACATACT');
INSERT INTO its1_sequence VALUES(1043,'8f0afdf3fe55da15b078c954d406bcdd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAACGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAACCCCCATACCTAACTTACTGATTATACTGTGAGAACGAAAGTTCTTGCTTTTAACTAGATAACAACTTCAGCAGTGGA');
INSERT INTO its1_sequence VALUES(1044,'00a1fa65b5abba1ad078d0dc772866d3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGARTGCSTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACTGTGAGAACGAAAGTTCTTGCTTTTAACTAGATAACAACTTCAGCAGTGGA');
INSERT INTO its1_sequence VALUES(1045,'dac32e2b4ee90a62710eccaad8f77419','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTTGAGTGTGCTTGCGCAATTGAAACGTCCAAACCTTTTAAACCCATTTGATTGCAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(1046,'152a527f0e13ffa1d59d198532ec9910','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTATAACTATGTTCTGTGCTTCGTCGCAAGACTTGAGGCTGAACGAAGGTGAGTCTGCGTCTATTTTGGATGCGGATTTGCTGATGTTATTTTAAACACCTATTACTTAATACTGAACTATACTCCGAATACGAAAGTTTTTGGTTTTAACAATTAACAACTTTCAGCAGTGGA');
INSERT INTO its1_sequence VALUES(1047,'ce6ca5792f1a7637f40a49ef4b70d507','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCCCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAATCCTTACTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1048,'7c908ba95dd4c5172216a3a06d712aee','TTTCCGTAGGTGAACCTGCGGAAGGATCCTTTACCCCCCCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGNTCTGGCCGGCCGGTTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1049,'f9b5db5ccd93514a26191e343241b7bc','GTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1050,'c0da65a80a455170803345def2fc9132','GTTCCGTAGGTGAACCTGCGGAAGGATCCTTTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1051,'725344da87ed7a026a6255fdf93ab8dc','TTTCCGTAGGTGAACGGCGGAAGGATCATTACCACACCTAAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1052,'00064639be0396195c149a91d27e0410','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTCTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1053,'6fbc0430126818eefad73f35f22171b7','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1054,'3da1bca3ae36e55373f551dab12a2046','TTTCCGTAGGTGAAACTGCGGAAGGGATCATTACCCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1055,'40de8db9306c23d2c4412dbd678fef4f','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1056,'348bb91526d93a37f3afa452c27417df','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATAATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(1057,'67ce22f69d4a3f7896d386153625e4fe','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATRATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(1058,'1173a7c57963c3f5d2e1c938c49c46a4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTATCCACGTGAACTGTCTGATCCGATTCGCGCCGTGACGCGTGCTGCGGGTTTGTAAAAGAATCTGCGGCGTGCGGGCTCGGCTGATCGAAGGTTTCATTGCTGCGAGCGTGTGCTTTTCGGAGCGCGCGTGTTGCGGCGGTGGGGCTGACTTACTCTTTCAAACCCGTTTACCGAATGACTGATGTATACT');
INSERT INTO its1_sequence VALUES(1059,'2abac8241200c22d053dbf27326a5dd6','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATTGTTGGGCTTGTCTTTCTTTCGAGGAGGATGAGCTATCTGTAAACTTGTCAAACCCCTTTCTTTTATTATAAAACTGAAACATACT');
INSERT INTO its1_sequence VALUES(1060,'0ea3c59de328c705e983f736ffc4d3cc','TTTCCGTAGGTGAACCTGCGGAWGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCKTGCGCATTTTGAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(1061,'f23d6ba7ff5d2024f58b764895f96a81','TTTCCGTAGGTGAACTTGCGGAAGGATCATTACCACACCTAAAAAAATTTTTCACGTTATCCGTATCATCCTTTTTATTTGGGGTTCTTGTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1062,'a3009917467dc1736322aa6d7a0b872b','TTCCGTAGGTGAACCGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1063,'696b2c5440d500455f145294ff64812b','TTCCGTAGGTGAACCGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1064,'cea131f773b0bedbb4ba870eabe000fe','TTCCGTAGGTGAACCGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTCCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1065,'9891a69393a9e47069b804fa36395bba','TTCCGTAGGTGAACCGCGGAAGGATCATTACCACACCTCAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1066,'6cc846759b0f069a60eecc6c73004746','TTCCGTAGGTGAACCGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1067,'ba937f483877591dc95e440f31413f42','TTCCGTAGGTGAACCGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1068,'9197ca49c0d842d4a9a14eeb02183f63','TTCCGTAGGTGAACCGCGGAAGGATCATTTCCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1069,'6afebb694fc734c87182c22a61867906','TTCCGTAGGTGAACCGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTAGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1070,'3b78ca647debaf3334718e0380c2fce4','TTCCGTAGGTGAACCGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTCTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1071,'5ffe6137ac64210a99bb422a3a9e8760','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCC');
INSERT INTO its1_sequence VALUES(1072,'1738594bdba8e22c2c6f2c0fd5ecb921','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1073,'b7bebbf82339eb6d8a63d5253e5569fd','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAGCCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGTTTTTTGTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1074,'c9f43635a4802f3ccc4a7adceff5ba0b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTTCCCCACTTTAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGATCTGGTGTTTTCGGATAGTGGATCGGGAGTCAGCAGGACGAAGGTTGGTCTCGTAATGTAAATTATGGGACTAGCTGATGCATTCCTTTTTTCAAACCCTTACATAAATACTGATTGATACT');
INSERT INTO its1_sequence VALUES(1075,'6943bb99648975850fedbb7698e575b3','CTTCTGTAGGTGAACCTGCGGAAGGATCATTCCCTCACCTAAAAAACAACCTTGCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(1076,'d0cf4b56667a308517ba7f54eb69381c','TTTCCGTAGGTGACCCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTGTTCTCTCTGTTTTGGGGGGAGGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTCTTTGATAACTGAAACATACT');
INSERT INTO its1_sequence VALUES(1077,'c17804cab76491cf00202d97c3ff086c','TTTCCGTAGGTGAACCTGCGGAAGGATCACTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGTCGTGTTCTCTCTGTTTTGGGGGGAGGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTCTTTGATAACTGAAACATACT');
INSERT INTO its1_sequence VALUES(1078,'6a898b08296b8db3ba36bce3b16a52b8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGCGTTCTCTCTGTTTTGGGGGGAGGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTCTTTGATAACTGAAACATACT');
INSERT INTO its1_sequence VALUES(1079,'be2cd53965c817f89b3df7e05ec1601e','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGACGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1080,'163cd2eb0ea382ea97486200abc9795a','CTTCCGTAGGGTGAACGTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1081,'7ab5d60845995b336ee247d647d91b8b','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1082,'52df510e24f607cbc03ea3b5025cede3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTTGAGTGTGTGTTCGCATACAATTAAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(1083,'449d3901489a7ceb7c8cf2d4d2284ad4','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTTCACGTGAACCGTTTCAACCAAATAGTTGGGAACGAGTTAGGCGGCGACTGCTGACTTTATTGTTGGTGGTTACTGCTAGACGAGTTCTATCATAGTGAAGTGGTTTGGACTTCGGTTCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1084,'87c87263f4f952a11f75c6594574ba27','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTCACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTCTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO its1_sequence VALUES(1085,'2c9d820af2ab59fbb991bdf24fff0577','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTTGAGTGTGTGTTCGCATACAATTAAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAACTATACT');
INSERT INTO its1_sequence VALUES(1086,'2c4674a7a2762aa85ac47a8d5fe5a70e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTGGAGTGTGCTTGCGCACATTTTGAATGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO its1_sequence VALUES(1087,'81b90282bc9c346fcdbd2ec9e1eec946','GGTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATAGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1088,'8c4109758e97f907b790de4f83804c66','TTTCCGTAGGTGAACGTGCGGAAGGATCATTACCACACATAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTGTTCTCTCTGTTTTGGGGGGGAGGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTCTTTGATAACTGAAACATACT');
INSERT INTO its1_sequence VALUES(1089,'0385ee2c62701b414f37088ec2c6243d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTTCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGTGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1090,'6ff4ab53f4102f5e0fff3d34cf88ce00','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAATTTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTCATGGGTCGGCGTGCTGCTGCTGGGTGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1091,'1ae614214aded5421b07e8269a11a515','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1092,'7e0c5fec257d83d2d0765deae033aae8','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCTGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1093,'860e54ca2cd2786375fd88746ff01798','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATTACCAAAGTTAGTTGGGGACTCCCTGTTGTTGGTCGATGTAGCAATATGTTGACCGGCGGCGGGTTGAGACCTATCAAACGACGGCGACGAATGTGCGGGCTGAAAAGTCGGCACGTTTGTTTCTGAAGTTTCTCTTTTAAACTCCTTCTTATTTAACTGAACATACT');
INSERT INTO its1_sequence VALUES(1094,'dcc5f7a39bf0070fc6284f61de480c9a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTGTTGTCGATGTTGGGGGCTGGGCTGGCGTTTGTTCGTCAGTTGGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTTTAAGTTTTTCTGAATATACT');
INSERT INTO its1_sequence VALUES(1095,'0cc6d92876184aae488d6415912a83cc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACCCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1096,'b6b515f69f9b04a6ed627c507cb23b63','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACAATCCACGTGAACCGTATCAACCCCCCTTAATTGGGGCTTCCCTGCTGTCTTGTGCTGGCTGAGCTTTGTTGTTCGGCTGGTCGAGGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTTTGTTAGTAGCTTTTTTTTGCGAACGAGCGTTTGTGCCGACTATTGAAGGAATCGCTTTTGCAAGCAGGCCAGTTACCTGTAGCATTGGCTTGAATCCGGACGCGGTTGGCGCGAGCTAGTAGTTTTGCAAAAGTTTTTTTAAACCCTTTACTAAATACTGAAAAACT');
INSERT INTO its1_sequence VALUES(1097,'81f86052f357dfc24465a09abf492c78','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACAATCCACGTGAACCGTATCAACCAACTTGTAATTGGGGCCTCCCTGCTGTATTGTGGGTTGAGGCCTATCAGCGAACGCTTTGTTTCTGTTTGTTGTTGGCTGTCTGTTTTTTKGGGGGACTCGCTTGGGCGCCCGGTTTGATTAAGTTCGCTGGGAGGAAAGGTTTGAGGCTCTTTTTGGACGGACGGCTGGCTTTGGACATAAAGTTAGTAGCTTTTTTTAAACCCTTACTAAATACTGAAAAACT');
INSERT INTO its1_sequence VALUES(1098,'f48b3530ddf5868a93d5b559ad3a1b37','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACAATCCACGTGAACCGTATCAACCAACTTGTAATTGGGGCCTCCCTGCTGTATTGTGGGTTGAGGCCTATCAGCGAACGCTTTGTTTCTGTTTGTTGTTGGCTGTCTGTTTTTTTGGGGGACTCGCTTGGGCGCCCGGTTTGATTAAGTTCGCTGGGAGGAAAGGTTTGAGGCTCTTTTTGGACGGACGGCTGGCTTTGGACATAAAGTTAGTAGCTTTTTTTAAACCCTTACTAAATACTGAAAAACT');
INSERT INTO its1_sequence VALUES(1099,'914d49af030df99f78c1a7e2bbc8e906','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACAATCCACGTGAACCGTATCAACCACCCCTTAATTGGGGCTTCCCTGCTGTATTGTGCTGGCTGAGCTTTAATTGTTCGGCCGGTCAAAGCGGTGGGTTGAGGCCTATCAGCGAACGCTTTTCAAGTTAGTAGCTTTTTGTGAACGAGTGTTTGTACCGACTATTGATGGAATCGCTTTTTGCAAGCAGGCCAAATTACCTGTAGTAGAGGTTTGAATCCGGAAGTGGTTGGTGTGAGCTAGTAGTTTGCAAATCTTTTTTAAACCCTTACTAAATACTGAAAAACT');
INSERT INTO its1_sequence VALUES(1100,'cb12fec948fb03509c6846797c8f3808','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACAATCCACGTGAACCGTATCAACCACCCCTTAATTGGGGCTTCCCTGCTGTATTGTGCTGGCTGAGCTTTAATTGTTCGGCCGGTCAAAGCGGTGGGTTGAGGCCTATCAGCGAACGCTTTTCAAGTTAGTAGCTTTTTGTGAACGAGTGTTTGTACCGACTATTGATGGAATCGCTTTTTGCAAGCAGGCCAAATTACCTGTAGTAGAGGTTTGAATCCGGAAGTGGTTGGTGTGAGCTAGTAGTTTGCAAATCTTTTTTTAAACCCTTACTAAATACTGAAAAACT');
INSERT INTO its1_sequence VALUES(1101,'83e04ad8e9d43950e24e815ddb50e010','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACAATCCACGTGAACCGTATCAACCACCCCTTAATTGGGGCTTCCCTGCTGTCTTGTGCTGGCTGAGCTTTAATTGTTCGGYCGGTCAAAGCGGTGGGTTGAGGCCTATCAGCGAACGCTTTTCAAGTTAGTAGCTTTTTGTGAACGAGTGTTTGTACCGACTATTGATGGAATCGCTTTTTGCAAGCAGGCCAAATTACCTGTAGTAGAGGTTTGAATCCGGAAGTGGTTGGTGTGAGCTAGTAGTTTGCAAATCTTTTTTTAAACCCTTACTAAATACTGAAAAACT');
INSERT INTO its1_sequence VALUES(1102,'bcb7f48bf7f61a8c1bedd5237f4e4710','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACAATCCACGTGAACCGTATCAACCCCCCTTAATTGGGGCTTCCCTGCTGTCTTGTGCTGGCTGAGCTTTGTTGTTCGGCTGGTCGAGGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTTTGTTAGTAGCTTTTTTTTGCGAACGAGCGTTTGTGCCGACTATTGATGGAATCGCTTTTGCAAGCAGGCCAGTTACCTGTAGCATTGGCTTGAATCCGGACGCGGTTGGCGCGAGCTAGTAGTTTTGCAAAAGTTTTTTTAAACCCTTACTAAATACTGAAAAACT');
INSERT INTO its1_sequence VALUES(1103,'2d959f82e21fc13b0ed235b2116367c5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACAACTAAAAATTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1104,'ae0a3566a49e975ea7bfcfd8f128d2ca','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAACGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1105,'30bf4df196ae47f5006321126295c54b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1106,'d2e70c0b6f39fe8876b0a5948339363b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTCCACGTGAACCGTATCAACCCTTTAATATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCAGCTCTAGCGCGAGCGTTCTGAGCTTCGGCTTGGGGCTAGTAGCTTTTTTTAAACCCATTCTTAACTACTGTAATACT');
INSERT INTO its1_sequence VALUES(1107,'bf26ba8c31c4ad9451e5224ee7c790e1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCATGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1108,'b51486d26a984ee6613632fd8969546c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGTTTGGCGGCGTGTGTGCTGGCCTGTTAAGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGAGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1109,'18bf3de496b0e33ac8c7ad579d605d6c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1110,'204b9fd585df16e71c2ff6db3911074e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATTTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1111,'abccac2dd0d5071cec84150fa2182ecd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTAAATTGGGGGTCTTGCTTGGTGTGCGGCTGGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTGGGCGAGCCCTATCATGGCAAACGTTTGGGCTTCGGTCTGAGCTAGTAGCTTTATTTTTAAACCCATTTCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1112,'51414f16b7c7844ddf50e69b064a5013','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1113,'189d60b21afd31b7fc103efb16f3d4f5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1114,'accbf46be25afe6adf2bf2afc1098154','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1115,'6f428a7008840ad71efe279b4f964f50','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCATTTTAAACTCATTCAATAATATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1116,'2a95700955b33ff095bb4765ac5701c8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGACGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1117,'1673f59df5861284c97acedebd2247c8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1118,'ccf49bafc9118040d3db2cc5fae19dad','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTATCAACCAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGTTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1119,'94b22b9655455c2f020906a53dc4fe25','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACTAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1120,'bb8fe99ddf33f00d9bb9f3a69070c238','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACACTTTTCCACGTGAACCGTATCACCCCTTTTAATTGGGGATTTGCTCGGTGTGCGGCTAGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTAGGCGAGTCCTATCATGGCAAACGTTTGGGCTTCGGCTTGAGCTAGTAGCTTTTTTTTTAAACCATTTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1121,'693eb3fe1f900cc4191b5124a82acc64','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTATCAACCCAAGTAGTTGGGGGCGTTACTGTTCTGCGCAGGCTGTCGATGTGAAAGTCGGCGGCTGGTGCGGAGCGGTGATGCCCTATCATGGCGAAGGTGTTGTGTCCCTCTCGGGGGACGTGATGTCGGCTGCCCTCTGTTTTAAACCCATTCCTAATAACTGATTAATACT');
INSERT INTO its1_sequence VALUES(1122,'8c5fff465555fdfa822c1dacb15a1e28','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTGTCCACGTGAACCGTATCAACCCAAGTAGTTGGGGGCGTTACTGTTCTGCGCAGGCTGTCGATGTGAAAGTCGGCGGCTGGTGCGGGGCGGTGATGCCCTATCATGGCGAAGGTGTTGTGTCCCTCTCGGGGGACGTGATGTCGGCTGCCCTCTGTTTTAAACCCATTCCTAATAACTGATTAATACT');
INSERT INTO its1_sequence VALUES(1123,'9bcb0ae39f1e201b53a49ed6880c0a96','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCATGGGCCTTCGGGTCTGAGCTAGTAGCCCTCTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1124,'a77f09a90fd6b54658269b2a6c48b738','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1125,'16ae33060a1b4a7343845abb4b0e6351','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCCACGTGAACCGTATCAACCCTTTAATATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCAGCTCTAGCGCGAGCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTTCTTTTAAACCCATTCTTAATTACTGTAATACT');
INSERT INTO its1_sequence VALUES(1126,'b84047315514dfc365eab35e7b68a035','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGCATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1127,'6591d2a48ca18148737841d197747fe1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCGGCTGCTGGCTTTGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTTCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1128,'06bb33dab4da9d3d074b4178356fc5eb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAACTTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGAATGAGCCCTATCATGGCGAGCGTTTAGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1129,'fb5c95b85ba0bd601b2c1ad80008c43c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGAGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1130,'354155d5139b0697459987afe0520d9e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGTCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGATCTGGATCATGAGCCCACTTTTTAAATCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1131,'c845064c265618b5a6d18ec572d00994','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCACCTAGTTGGGGTTCTCGGTAGCCGTGTGGCATGTGGACTCGTTCTACGTGCTGCTGGCGGCTGAGACCTATCATGGCGAGCGTTTGGGCTTTCGGGCCTGGATTAGTAGCCCTCTTTTAAACTCATTCTGTAAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(1132,'af377ed1846b4c693468606612919f64','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1133,'7848a2de5900d170dbea9266dec68600','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACCGAGCCAGTAGCCCTTTTCTTTCAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1134,'bf70bd2daac24263c5e41d1a4cae3d1a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTAGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1135,'d4710310a11c0cc546e6a18f6eb2ed73','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGCTCGGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTCTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1136,'3c50b66a456d94cb5353652d20f871ff','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1137,'12ccc0977c10d0368bc1e952bff77e75','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1138,'8a5056f910a345b5a88cfc028a8178fa','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTTCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1139,'17355e0662c13b70191a137683b53c77','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGTTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1140,'78cf5eb050d52e4da46c2663a5b65d20','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAGTTGGGGGTCTTGCTTGGCGTGCGGCTGCTGGCCTTTATTGGTTGGCTGGCTGCGTGCTGGGCGAGCCCTATCATGGCGATCGTTTGGACCTCGGTCTGAGCTAGTAGCTTTTGTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1141,'14f9b916c45da114ae6ad243c3b3a3e9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTAGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTATTTTAAACCCATTCTTAATTTACTGAAATACT');
INSERT INTO its1_sequence VALUES(1142,'8aef3951805f9df72761965a444e1cc4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGCGGCGGCTCTAGCGCGAGCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTTCTTTTAAACCCATTCTTAATTTACTGAAATACT');
INSERT INTO its1_sequence VALUES(1143,'6ed02912b2f7fd120bde804f02f7a5a3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGGCTTGTTTGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1144,'ffe9bc68a52fad924e7198da946de675','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1145,'39aebaff88cc30e75a121fe9b14f6ca5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1146,'f0a78c8ba775e42ce018e769875fc901','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1147,'0e6a252f97b48cae486abc3721261ddc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTCACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1148,'7d5ba154869497ef9ebeccad0ac26fe0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1149,'5954e4e70b640a6ca19d972387aeadaa','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1150,'adbf589e479defef4edc82a06338e61b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGGCTTGTTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCTTTCTTAAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1151,'ee2f0522589c99870ed046a2d48c3ecc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAAATTGGGAGCTTTCGTCTGGCCGGCCGGCTTTTGGCTGGTTGGGCGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCTTGGGCTAGTAGCTTCTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1152,'56b2abe6202721a09d052c7d2689fc63','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGCTTTCGGCTGACTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCTTGGGCTAGTAGCTTCTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1153,'5517b62e19d6566b08fabe4b994b99ff','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1154,'a8fd7e7b2073a7c1cb26fa060b152656','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1155,'388980472e820fa93a31a6781955849d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATTACCAAAGTTAGTTGGGGACTCCCTGTTGTTGGTCGATGTAGCAATATGTTGACCGGCGGCGGGTTGAGACCTATCAAACGACGGCGACGAATGTGCGGGCTGAAAAGTCGGCACGTTTGTTTCTGAAGTTTCTCTTTTAAACTCCTTCTTATTTAACTGAACATACT');
INSERT INTO its1_sequence VALUES(1156,'e2eb2e800b1f113a1242417c5f152332','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTAAAACTTTAGTTGGGGACTCCTCATTGGCAGTTTGTTCTGTTGGTGAGTTGAGGCCTATCAAACGATCAATTTGGGCTGCAAAGTCGGAGTTGAGAGTTTCTTTTTTAAACCCATGCTTTTATTACTGAAAATACT');
INSERT INTO its1_sequence VALUES(1157,'c1c159ae5ae463e54e716ce5c931daf7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1158,'91cb922176351e35556563036bc82277','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1159,'bad52d46f2c0e8db2034aa71f00e19b7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCGGCTGCTGGCTTTGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1160,'6289b62a54bd257e3552c6bdcfe1efea','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGTCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGATCTGGATCATGAGCCCACTTTTTAAATCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1161,'4e778a063acb21f8d7a82b53a652d2ec','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAATTCACGTGAACCGTTTCAAACAAATAGTTGGGGGTTTTGTTTGGCGGCGGCTGCTGACTTTATTGTTGGCGGCTGCTGCTGGGCGAACCCTATCATGGCGAACGTTTGGACTTTGGTCTGAGCTAGTAGCTTTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1162,'c21bace7ad4663d2bf1eee832c662b0e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAATTTCCACGTGAACCGTTTCAACCAAAAGTTGGGGGTCTTGTTTGGCGGTGACTGCTGGCTTTATTGCTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAAAGTTTGGACTTCGGTCTGAGCTAGTAGTTATTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1163,'b9119916a84bcc1e52191c6f468f1d53','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTACTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGCGTGCGTGTGTTTGGCGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTCTTTTAAACCCTTTTACTATTAACTGATATACT');
INSERT INTO its1_sequence VALUES(1164,'8a8aff1be29e1eb884987538f35896d7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTGCTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGCGTGCGTGTGTTTGGCGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTCTTTTAAACCCTTTTACTATTAACTGATATACT');
INSERT INTO its1_sequence VALUES(1165,'be05ff935418be15ac22b1375e5595c1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTCCACGTGAACCGTATCAACCCTTTAATATTGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCAGCTCTAGCGCGAGCGTTCTGAGCTTCGGCTTGGGGCTAGTAGCTTTTTTAAACCCATTCTTAACTACTGTAATACT');
INSERT INTO its1_sequence VALUES(1166,'a41c22a55e202d73d0ac8d38b7278cf8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTCCCCCGTGAACCGTATCAACCCTTTTTTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTCTTTTTAAACCCATTCTTAATTTACTGAAATACT');
INSERT INTO its1_sequence VALUES(1167,'15a72c0e2a3ebbdc2c450833cf2acec7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACACTCTTAGTTGGGGCTTCTGTCTGGCTGGCTTCGGCCGGGTGGGCGGAGGCTCTATCATGGCGACCGCTTGGGCCTCGGCTCGAGCTAGTAGCCCACATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1168,'369e7108969ee6e31faf3d1727758fd1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGCTAGCCTGGTAACGGCTGTTGGCTGTAATGGCTGACGGCTGTAACTGGGCAGGCCCTAACGCGACCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTATTTTAAACCATTACTAATTACTGAAAAAACG');
INSERT INTO its1_sequence VALUES(1169,'3d2b83b12f28c97b33e47423d44644d7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1170,'e3ec7579f77c7a0a268985570888abd7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGCTTGCTCGGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTCTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1171,'f71da539236d7298a3336f35c67d4ee2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGCTCGGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTCTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1172,'ac4a7551b8e1964a99cdb356412ccae0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGCTCGGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGTGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTCTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1173,'4e5271ad5412f2f388699b6b7543c742','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATACT');
INSERT INTO its1_sequence VALUES(1174,'2e1cfd0b59a262f4d1c7e524d012081c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTATAATTGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTATTATGGGTCGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTTAAACCCATTCTTTAATTACTGAAATACT');
INSERT INTO its1_sequence VALUES(1175,'036430ad3943c47104acec43b6e8f4f1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1176,'52d2775e6d190ce2b11f9e4169ed79fa','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTCATTTTAAACCCATTCTTAATTTACTGAAATACT');
INSERT INTO its1_sequence VALUES(1177,'bd9f7c026231518694e42c5f0aa42558','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTATTATTGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCAGCTCTAGCGCGAGCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTTCTTTTAAACCCATTCTTAACTACTGTAATACT');
INSERT INTO its1_sequence VALUES(1178,'9d39facd71e9a9882c3a52d16d7c16b8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1179,'611adb2e200b51580231fbd3d7e2cdbc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1180,'f7172611dceeaf56cb1ebb6c6c09244e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGCTGTTGGGTGAGCCCTATCATCGACGAACGTTTAGGCTTCAGTCTGGACAAGTACTCTCTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1181,'546b1dc9a898762b2a9e53616a88bde2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTTTACT');
INSERT INTO its1_sequence VALUES(1182,'04e3b3287f8294563e2601d6e11c3a74','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTAGTTGGGGGTCTTTTTCGGCGGCGGCTGCTGGTTTAATTACTGGCGGTTGCTGCTGGGAGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1183,'6d25e9a730b3de86d7da69f75693d2ff','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAATCCATTTAGTTGGGGGCTAGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1184,'a617ef702a606e8fa6c270a7cf391bce','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAATCCATTTAGTTGGGGGCTAGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGACT');
INSERT INTO its1_sequence VALUES(1185,'0e40eb87b3e706aad90568a57ffe5b9c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1186,'f3dae98682339abb95053bc01213c6dd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTGTTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1187,'6e209f0a5d8ce42a64c7bbce6aba389d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1188,'89d4ba3ead2861ddd81d800b274dead8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGGCTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1189,'ad19937af794f90448b7092a70958d8e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1190,'c9a4662af671e7f9486fce74a3215213','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1191,'f2ba78db2f0b4eb5040b7de6e3ab4775','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATTGTCTGTTGTTGGGGGCTTGGGCTGGCGTTTCGGCGCCGGCTCGGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCTGGGGTAGTAGTTACATTTTTTGTAAACCCTTTTCTTAATTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1192,'b061545e6120779e5cd1b643a28cf6d9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCCTTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACCCAACCTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1193,'6f0db7964d0b012c62e04315e4efded1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACTCAACCTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1194,'88b8f690696f04fde7fdfd2fa4791d82','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1195,'b2aed55a231718a3b05f2c6015684b41','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGGCTGCTGCTGCTGCTTCGGTGGCGGCGTGCTCCCATCAAACGAGGCCCTGGGCTGCAAAGTCGGGGGTAGTAGTTACTTTTTGTAAACCCTTTTCCTGTATTTTCTGAATATACT');
INSERT INTO its1_sequence VALUES(1196,'4095581ad779eeb56c6190a9c9eaa952','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTGTTGTCGATGTTGGGGGCTGGGCTGGCGTTTGTTCGTCGGTTGGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTTTAAGTTTTTCTGAATATACT');
INSERT INTO its1_sequence VALUES(1197,'945f5df4c2ab4e4b47d3dcf710557519','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCCCGTGAACCGTATCAACCCTTTTTTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCCTGGGGCTAGTAGCTTTCTTTTTAAACCATTCTTAATTTACTGAAATACT');
INSERT INTO its1_sequence VALUES(1198,'3bf5410f93f0acc727f67b09edbcf975','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAACCGTATCAACCCCCTTCGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1199,'4541e767ffb21c357cb5d2621acd0220','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATTTCCACGTGAACCGTTTCAACCCAAAAAATTGGGGGTCTTGTTTGGTGGTGGCTGCTGGCTTTATTGCTGGCGGCTGCTGCTGGATGAGCCCTAACGCGAAAGTTTAGACTTCGGTCCGGGCTAGTAGCTTTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1200,'8ac99f38a140c704b6240b12a5d3b01b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACACTTTCCACGTGAACCGTATCAACCCCTTCAAATTGGGGGCTTGCTCGGCGGTGGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGTTGCTGGGTGGGCTCTATCATGGGCGAGCGTTTGAGCTTCGGCTCGAGCTAGTAGCTTTTCTTTTAAACCCCTTCTTTAATAACTGAAATACT');
INSERT INTO its1_sequence VALUES(1201,'a8472295a350bb6dd3d1ba3e943cb207','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACACTTTCCACGTGAACCGTATCAACCCTTCAAATCGAGGGCTTGCTCGGCGGTGGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGTTGCTGGGTGGGCTCTATCATGGGCGAGCGTTTGAGCTTCGGCTCGAGCTAGTAGCTTTTCTTTTAAACCCCTTCTTGAATAACTGAAATACT');
INSERT INTO its1_sequence VALUES(1202,'422fdfd853c35bfa3052203368ea0aed','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTCCACGTGAACCGTATTTTTGACGTTGGGGACTCCTGGCTTCGGCCGGTTGAGACCTATCACGCGACCGCTCGGGCTGAAAAGTCGGGGCCAGTAGCCTTTTTTAAACCCATTCCGAACTACTGAACCATACT');
INSERT INTO its1_sequence VALUES(1203,'bc1fd2ec3df354d0302c02c5b4822829','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1204,'18055b7d13e07928ff23dc1ded700dde','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTTCCACGTGAACCGTATTTTTGACGTTGGGGACTCCTGGCTTCGGCCGGTTGAGACCTATCACGCGACCGCTCGGGCTGAAAAGTCGGGGCCAGTAGCCTTTTTTTAAACCCATTCCGAACTACTGAACCATACT');
INSERT INTO its1_sequence VALUES(1205,'8fe470cfc5374219043fb54f9fbbe9ec','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAATTTTCCACGTGAACCGTATTTTTGACGTTGGGGACTCCTGGCTTCGGCCGGTTGAGACCTATCACGCGACCGCTCGGGCTGAAAAGTCGGGGCCAGTAGCCTTTTTTTAAACCCATTCCGAACTACTGAACCATACT');
INSERT INTO its1_sequence VALUES(1206,'76256930e82daf27b7988f640125a3c1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAACACTTTCCACGTGAACTGTATCAACCCTTTTAATTGGGAGCCTGCTAGGCGGCGGCGTGTTGACCTGTAATGGGCTGACATACTGCTGCTAGACGGGCTCTATCATAGGCGAGCGTTTGGACTTCGGTCCGAGCTAGTAGCTTTTTTAAACCCTTTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1207,'50d012ecc53cec368cd2b816f352a73d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAAAAACCATCCACGTGAACCGTATTGTCAAAACATTTGGGGACTCCTTGCTAGCGGGCTTTCGGGCTTGCCGGTCGGTTGAGACCTAACACGAGAGCCTTGGCTGAAAAGCCGGGGTGAGTAGTTTCTTTTTAAACCCTTTACTAAAAACTGAAAAACT');
INSERT INTO its1_sequence VALUES(1208,'8518ae1aa5511454eec68a67c555270a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAAAAATTCCACGTGAACTGTATTGTCAACCAAATTCGGGGACTCCTTGCTAGTGTGCTTTCGGGCGTGCCGGTAGGTTGAGACCCATCAAACGAAAACATCGACTGAAAGGTCGGAGCCAGTAGTTACCTTTGTAAACCCTTTACTAAATACTGAAAAACT');
INSERT INTO its1_sequence VALUES(1209,'3b2049d7070d6fb291909ce4bf2f01bf','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAAAAATTCCACGTGAACTGTATTGTCAACCAAATTCGGGGATTCCTTGCTAGCGTGCCTTCGGGCGTGCCGGTAGGTTGAGACCCATCAAACGAAAACATCGGCTGAAAGGTCGGAGCCAGTAGTTACCTTTGTAAACCCTTTACTAAATACTGAAAAACT');
INSERT INTO its1_sequence VALUES(1210,'5a7076479a2d227a52382f0a559453f5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAAAATTTCCACGTGAACTGTATTGTCAACCAAATTCGGGGACTCCTTGCTAGCGTGCCTTCGGGCGTGCCGGTAGGTTGAGACCCATCAAACGAAAACATCGGCTGAAAGGTCGGAGCCAGTAGTTACCTTTGTAAACCCTTTACTAAATACTGAAAAACT');
INSERT INTO its1_sequence VALUES(1211,'4a2d6b8f1ad2243d2a56a61cc37c151c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAAACTTTCCACGTGAACCGTTTCAACCTTTTATTGGGGCCTGCTAGGCGGAGGCGTGTTGACCTATTATAGGCTGATATGCTACTGCTAGGCGGGCTCCATCAAAGGCGATTGTTTGGACTTTTGTCTGAGCAGTTGCTTTTTATTTTAAACCATTTCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1212,'3e25efef9d49cedafdde60f671d8bd50','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTGGCGTGCTGAGCAAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTGTTTTAAACCCATTCGAAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1213,'fbc6e2eb3a9934daa99ba3fa3d4f9c7f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTGGCGTGCTGAGCAAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCGAAAATACTGATTATACT');
CREATE TABLE synonym (
	id INTEGER NOT NULL, 
	taxonomy_id INTEGER, 
	name VARCHAR(100) NOT NULL, 
	PRIMARY KEY (id), 
	FOREIGN KEY(taxonomy_id) REFERENCES taxonomy (id), 
	UNIQUE (name)
);
INSERT INTO synonym VALUES(1,91,'Achlya bisexuallis');
INSERT INTO synonym VALUES(2,96,'Saprolegnia androgyna');
INSERT INTO synonym VALUES(3,97,'Achlya sp. GHJ-2015');
INSERT INTO synonym VALUES(4,98,'Achlya sparrowi');
INSERT INTO synonym VALUES(5,103,'Saprolegnia sp. CAL-2011 rodrigueziana');
INSERT INTO synonym VALUES(6,108,'Achlya hypogyna ATCC 48635');
INSERT INTO synonym VALUES(7,115,'Thraustotheca sp. F-1532');
INSERT INTO synonym VALUES(8,121,'Saprolegnia sp. NeSS1');
INSERT INTO synonym VALUES(9,121,'Saprolegnia sp. NeSS2');
INSERT INTO synonym VALUES(10,121,'Saprolegnia sp. PelSS');
INSERT INTO synonym VALUES(11,124,'Saprolegnia maragheica A.C. Bouket, Y. Tanaka, 2018');
INSERT INTO synonym VALUES(12,124,'Saprolegnia sp. LB-2018a');
INSERT INTO synonym VALUES(13,125,'Saprolegnia sp. WD1B');
INSERT INTO synonym VALUES(14,126,'Saprolegnia sp. SCOR-2016a');
INSERT INTO synonym VALUES(15,127,'Achlya sp. F-1245');
INSERT INTO synonym VALUES(16,128,'Saprolegnia monoica var. acidamica');
INSERT INTO synonym VALUES(17,129,'Saprolegnia sp. WD1H');
INSERT INTO synonym VALUES(18,129,'Saprolegnia sp. WD20C');
INSERT INTO synonym VALUES(19,134,'Isoachlya subterranea');
INSERT INTO synonym VALUES(20,141,'Saprolegnia monoica var. glomerata');
INSERT INTO synonym VALUES(21,142,'Scoliolegnia blelhamensis');
INSERT INTO synonym VALUES(22,143,'Saprolegnia parasitica CBS 223.65');
INSERT INTO synonym VALUES(23,143,'Saprolegnia parasitica N12');
INSERT INTO synonym VALUES(24,145,'Saprolegnia sp. K07');
INSERT INTO synonym VALUES(25,145,'Saprolegnia sp. WD1D');
INSERT INTO synonym VALUES(26,145,'Saprolegnia sp. WD1K');
INSERT INTO synonym VALUES(27,145,'Saprolegnia sp. WD1L');
INSERT INTO synonym VALUES(28,148,'Saprolegnia declina');
INSERT INTO synonym VALUES(29,148,'Saprolegnia declina VS20');
INSERT INTO synonym VALUES(30,148,'Saprolegnia diclina VS20');
INSERT INTO synonym VALUES(31,148,'Saprolegnia sp. GD18A');
INSERT INTO synonym VALUES(32,148,'Saprolegnia sp. WD1F');
INSERT INTO synonym VALUES(33,149,'Saprolegnia sp. WD4D');
INSERT INTO synonym VALUES(34,149,'Saprolegnia sp. WD7C');
INSERT INTO synonym VALUES(35,153,'Saprolegnia anisopora');
INSERT INTO synonym VALUES(36,153,'Saprolegnia sp. 837A');
INSERT INTO synonym VALUES(37,153,'Saprolegnia sp. WD1A');
INSERT INTO synonym VALUES(38,158,'Bremia cf. lagoseridis YJC-2015');
INSERT INTO synonym VALUES(39,164,'Bremia tulasneii');
INSERT INTO synonym VALUES(40,170,'Plasmopara sp. MT-2011');
INSERT INTO synonym VALUES(41,172,'Plasmopara sp. YJC-2019a');
INSERT INTO synonym VALUES(42,173,'Plasmopara sp. HOH HUH1024');
INSERT INTO synonym VALUES(43,174,'Peronospora australis');
INSERT INTO synonym VALUES(44,177,'Bremiella megasperma');
INSERT INTO synonym VALUES(45,178,'Peronospora halstedii');
INSERT INTO synonym VALUES(46,179,'Plasmopara sp. BM-2017a');
INSERT INTO synonym VALUES(47,180,'Plasmopara sp. BM-2017b');
INSERT INTO synonym VALUES(48,181,'Plasmopara sp. constantinescui');
INSERT INTO synonym VALUES(49,182,'Plasmopara wildemanniana');
INSERT INTO synonym VALUES(50,184,'Bremiella baudysii');
INSERT INTO synonym VALUES(51,203,'Plasmopara sp. ARMT-2014');
INSERT INTO synonym VALUES(52,205,'Peronospora nivea Unger 1847');
INSERT INTO synonym VALUES(53,205,'Peronospora umbelliferarum Casp. 1855');
INSERT INTO synonym VALUES(54,205,'Plasmopara crustosa');
INSERT INTO synonym VALUES(55,205,'Plasmopara umbelliferarum');
INSERT INTO synonym VALUES(56,208,'Plasmopara angustitermina Novot. 1962lis');
INSERT INTO synonym VALUES(57,211,'Phytophthora megasperma f. sp. glycinea');
INSERT INTO synonym VALUES(58,211,'Phytophthora sojae strain P6497');
INSERT INTO synonym VALUES(59,213,'Phytophthora vignae f. sp. adzukicola');
INSERT INTO synonym VALUES(60,213,'Phytophthora vignae f. sp. vignae');
INSERT INTO synonym VALUES(61,215,'Phytophthora sp. 42B9');
INSERT INTO synonym VALUES(62,215,'Phytophthora sp. 44E4');
INSERT INTO synonym VALUES(63,215,'Phytophthora sp. 4E4');
INSERT INTO synonym VALUES(64,216,'Phytophthora sp. hydropathica');
INSERT INTO synonym VALUES(65,217,'Phytophthora sp. DP-2021a');
INSERT INTO synonym VALUES(66,221,'Phytophthora sp. TIB-2007-4');
INSERT INTO synonym VALUES(67,221,'Phytophthora sp. australis');
INSERT INTO synonym VALUES(68,221,'Phytophthora sp. multivora');
INSERT INTO synonym VALUES(69,222,'Phytophthora sp. isolate C19');
INSERT INTO synonym VALUES(70,222,'Phytophthora sp. isolate C25');
INSERT INTO synonym VALUES(71,222,'Phytophthora sp. isolate C7');
INSERT INTO synonym VALUES(72,222,'Phytophthora sp. isolate Rf17');
INSERT INTO synonym VALUES(73,222,'Phytophthora sp. isolate Rf6');
INSERT INTO synonym VALUES(74,222,'Phytophthora sp. isolate SCRP237');
INSERT INTO synonym VALUES(75,227,'Phytophthora moyootj x Phytophthora thermophila');
INSERT INTO synonym VALUES(76,228,'Phytophthora amnicola x Phytophthora moyootj');
INSERT INTO synonym VALUES(77,229,'Phytophthora moyootj x Phytophthora fluvialis');
INSERT INTO synonym VALUES(78,230,'Phytophthora fluvialis x Phytophthora moyootj');
INSERT INTO synonym VALUES(79,231,'Phytophthora moyootj x Phytophthora litoralis');
INSERT INTO synonym VALUES(80,233,'Phytophthora thermophila x Phytophthora moyootj');
INSERT INTO synonym VALUES(81,234,'Phytophthora sp. MHJ-2016a');
INSERT INTO synonym VALUES(82,235,'Phytophthora xheterohybrida');
INSERT INTO synonym VALUES(83,237,'Phytophthora xincrassata');
INSERT INTO synonym VALUES(84,238,'Phytophthora sp. JB-2016b');
INSERT INTO synonym VALUES(85,239,'Phytophthora sp. JB-2016c');
INSERT INTO synonym VALUES(86,245,'Phytophthora vanyenensis');
INSERT INTO synonym VALUES(87,246,'Phytophthora sp. BS-2015b');
INSERT INTO synonym VALUES(88,251,'Phytophthora hevea');
INSERT INTO synonym VALUES(89,253,'Phytophthora sp. 6-2prime-a');
INSERT INTO synonym VALUES(90,253,'Phytophthora sp. 6-2prime-b');
INSERT INTO synonym VALUES(91,253,'Phytophthora sp. 6-3prime-a');
INSERT INTO synonym VALUES(92,253,'Phytophthora sp. 6-3prime-b');
INSERT INTO synonym VALUES(93,253,'Phytophthora sp. 6-3prime-c');
INSERT INTO synonym VALUES(94,253,'Phytophthora sp. 6-3prime-d');
INSERT INTO synonym VALUES(95,253,'Phytophthora sp. 6-3prime-e');
INSERT INTO synonym VALUES(96,253,'Phytophthora sp. 6-3prime-f');
INSERT INTO synonym VALUES(97,253,'Phytophthora sp. 747');
INSERT INTO synonym VALUES(98,253,'Phytophthora sp. 754A');
INSERT INTO synonym VALUES(99,253,'Phytophthora sp. 755');
INSERT INTO synonym VALUES(100,253,'Phytophthora sp. 769A');
INSERT INTO synonym VALUES(101,253,'Phytophthora sp. 772');
INSERT INTO synonym VALUES(102,253,'Phytophthora sp. 776');
INSERT INTO synonym VALUES(103,253,'Phytophthora sp. 777A');
INSERT INTO synonym VALUES(104,253,'Phytophthora sp. 778');
INSERT INTO synonym VALUES(105,253,'Phytophthora sp. 779A');
INSERT INTO synonym VALUES(106,253,'Phytophthora sp. 780A');
INSERT INTO synonym VALUES(107,253,'Phytophthora sp. 785');
INSERT INTO synonym VALUES(108,253,'Phytophthora sp. 786');
INSERT INTO synonym VALUES(109,253,'Phytophthora sp. 787A');
INSERT INTO synonym VALUES(110,253,'Phytophthora sp. 787B');
INSERT INTO synonym VALUES(111,253,'Phytophthora sp. 788');
INSERT INTO synonym VALUES(112,253,'Phytophthora sp. 791A');
INSERT INTO synonym VALUES(113,253,'Phytophthora sp. 794');
INSERT INTO synonym VALUES(114,253,'Phytophthora sp. 801');
INSERT INTO synonym VALUES(115,253,'Phytophthora sp. 804');
INSERT INTO synonym VALUES(116,253,'Phytophthora sp. 806');
INSERT INTO synonym VALUES(117,255,'Phytophthora lateralis MPF4');
INSERT INTO synonym VALUES(118,255,'Phytophthora lateralis MPF6');
INSERT INTO synonym VALUES(119,255,'Phytophthora lateralis SMST21');
INSERT INTO synonym VALUES(120,256,'Phytophthora mirabilis PIC 99114');
INSERT INTO synonym VALUES(121,259,'Phytophthora phaseoli race F_18');
INSERT INTO synonym VALUES(122,264,'Phytophthora fragariae var. rubi');
INSERT INTO synonym VALUES(123,276,'Phytophthora alni subsp. alni');
INSERT INTO synonym VALUES(124,276,'Phytophthora sp. JB-2016d');
INSERT INTO synonym VALUES(125,276,'Phytophthora xalni');
INSERT INTO synonym VALUES(126,277,'Phytophthora andina EC3425');
INSERT INTO synonym VALUES(127,277,'Phytophthora sp. CAL-2011 andina');
INSERT INTO synonym VALUES(128,277,'Phytophthora sp. andina BOLD:AAO5683');
INSERT INTO synonym VALUES(129,279,'Phytophthora alni subsp. uniformis');
INSERT INTO synonym VALUES(130,280,'Phytophthora ipomoeae PIC 99167');
INSERT INTO synonym VALUES(131,281,'Phytophthora alni subsp. multiformis');
INSERT INTO synonym VALUES(132,281,'Phytophthora sp. JB-2016e');
INSERT INTO synonym VALUES(133,281,'Phytophthora xmultiformis');
INSERT INTO synonym VALUES(134,286,'Phytophthora sp. 1 BH-2013');
INSERT INTO synonym VALUES(135,287,'Phytophthora sp. P1052');
INSERT INTO synonym VALUES(136,287,'Phytophthora sp. P210');
INSERT INTO synonym VALUES(137,287,'Phytophthora sp. P246b');
INSERT INTO synonym VALUES(138,287,'Phytophthora sp. P895');
INSERT INTO synonym VALUES(139,289,'Pythiomorpha gonapodyides');
INSERT INTO synonym VALUES(140,290,'Phytophthora sp. 1819B');
INSERT INTO synonym VALUES(141,290,'Phytophthora sp. CBS 117693');
INSERT INTO synonym VALUES(142,290,'Phytophthora sp. QT-2009a');
INSERT INTO synonym VALUES(143,294,'Phytophthora sp. BS-2015a');
INSERT INTO synonym VALUES(144,295,'Phytophthora sp. 52');
INSERT INTO synonym VALUES(145,295,'Phytophthora sp. P462');
INSERT INTO synonym VALUES(146,295,'Phytophthora sp. rosacearum');
INSERT INTO synonym VALUES(147,296,'Phytophthora sp. MS1');
INSERT INTO synonym VALUES(148,297,'Phytophthora sp. 1 XY-2013');
INSERT INTO synonym VALUES(149,298,'Phytophthora sp. MS2');
INSERT INTO synonym VALUES(150,302,'Elongisporangium undulatum');
INSERT INTO synonym VALUES(151,302,'Pythium sp. 759');
INSERT INTO synonym VALUES(152,302,'Pythium sp. 775');
INSERT INTO synonym VALUES(153,302,'Pythium sp. GD35A');
INSERT INTO synonym VALUES(154,302,'Pythium sp. GD43B');
INSERT INTO synonym VALUES(155,302,'Pythium undulata');
INSERT INTO synonym VALUES(156,302,'Pythium undulatum');
INSERT INTO synonym VALUES(157,303,'Phytophthora sp. AMV-2010');
INSERT INTO synonym VALUES(158,311,'Phytophthora sp. ex Parrotia persica');
INSERT INTO synonym VALUES(159,311,'ramorum blight');
INSERT INTO synonym VALUES(160,311,'sudden oak death');
INSERT INTO synonym VALUES(161,314,'Phytophthora sp. P236');
INSERT INTO synonym VALUES(162,315,'Ph. cactorum (Leb. & Cohn) Schroet. x Ph. nicotianaevan Breda de Haan');
INSERT INTO synonym VALUES(163,318,'Peronophythora litchii');
INSERT INTO synonym VALUES(164,327,'Phytophthora sp. 16 TIB-2012');
INSERT INTO synonym VALUES(165,328,'Phytophthora hedraiandra de Cock & Man in ''t Veld');
INSERT INTO synonym VALUES(166,329,'Phytophthora sp. asparagi');
INSERT INTO synonym VALUES(167,330,'Phytophthora austrocedrae');
INSERT INTO synonym VALUES(168,330,'Phytophthora sp. austrocedrae');
INSERT INTO synonym VALUES(169,331,'Phytophthora erythroseptica var. pisi');
INSERT INTO synonym VALUES(170,335,'Phytophthora salixsoil');
INSERT INTO synonym VALUES(171,335,'Phytophthora sp. 920');
INSERT INTO synonym VALUES(172,335,'Phytophthora sp. 921');
INSERT INTO synonym VALUES(173,335,'Phytophthora sp. 922');
INSERT INTO synonym VALUES(174,335,'Phytophthora sp. 923');
INSERT INTO synonym VALUES(175,335,'Phytophthora sp. B01');
INSERT INTO synonym VALUES(176,335,'Phytophthora sp. B02');
INSERT INTO synonym VALUES(177,335,'Phytophthora sp. B04');
INSERT INTO synonym VALUES(178,335,'Phytophthora sp. B14');
INSERT INTO synonym VALUES(179,335,'Phytophthora sp. BO3');
INSERT INTO synonym VALUES(180,335,'Phytophthora sp. GD15A');
INSERT INTO synonym VALUES(181,335,'Phytophthora sp. GD18G');
INSERT INTO synonym VALUES(182,335,'Phytophthora sp. GD36D');
INSERT INTO synonym VALUES(183,335,'Phytophthora sp. GD36F');
INSERT INTO synonym VALUES(184,335,'Phytophthora sp. GD40A');
INSERT INTO synonym VALUES(185,335,'Phytophthora sp. GD40C');
INSERT INTO synonym VALUES(186,335,'Phytophthora sp. GD40D');
INSERT INTO synonym VALUES(187,335,'Phytophthora sp. GD7B');
INSERT INTO synonym VALUES(188,335,'Phytophthora sp. GD7C');
INSERT INTO synonym VALUES(189,335,'Phytophthora sp. GD7G');
INSERT INTO synonym VALUES(190,335,'Phytophthora sp. GD7H');
INSERT INTO synonym VALUES(191,335,'Phytophthora sp. P245');
INSERT INTO synonym VALUES(192,335,'Phytophthora sp. P878');
INSERT INTO synonym VALUES(193,335,'Phytophthora sp. Salixsoil');
INSERT INTO synonym VALUES(194,335,'Phytophthora sp. WD37A');
INSERT INTO synonym VALUES(195,335,'Phytophthora sp. WD37B');
INSERT INTO synonym VALUES(196,335,'Phytophthora sp. WD37C');
INSERT INTO synonym VALUES(197,335,'Phytophthora sp. WD38A');
INSERT INTO synonym VALUES(198,335,'Phytophthora sp. WD38B');
INSERT INTO synonym VALUES(199,335,'Phytophthora sp. WD39A');
INSERT INTO synonym VALUES(200,335,'Phytophthora sp. WD39B');
INSERT INTO synonym VALUES(201,335,'Phytophthora sp. WD40A');
INSERT INTO synonym VALUES(202,335,'Phytophthora sp. WD40C');
INSERT INTO synonym VALUES(203,335,'Phytophthora sp. WD40D');
INSERT INTO synonym VALUES(204,335,'Phytophthora sp. WD40E');
INSERT INTO synonym VALUES(205,335,'Phytophthora sp. WD41a');
INSERT INTO synonym VALUES(206,335,'Phytophthora sp. WD43A');
INSERT INTO synonym VALUES(207,335,'Phytophthora sp. WD44B');
INSERT INTO synonym VALUES(208,335,'Phytophthora sp. WD44C');
INSERT INTO synonym VALUES(209,335,'Phytophthora sp. WD45A');
INSERT INTO synonym VALUES(210,335,'Phytophthora sp. WD45B');
INSERT INTO synonym VALUES(211,335,'Phytophthora sp. WD45C');
INSERT INTO synonym VALUES(212,335,'Phytophthora sp. WD47A');
INSERT INTO synonym VALUES(213,335,'Phytophthora sp. WD47C');
INSERT INTO synonym VALUES(214,335,'Phytophthora sp. taxon Salixsoil');
INSERT INTO synonym VALUES(215,335,'Phytophthora taxon salixsoil');
INSERT INTO synonym VALUES(216,338,'Phytophthora sp. BS-2017a');
INSERT INTO synonym VALUES(217,339,'Phytophthora sp. BS-2017b');
INSERT INTO synonym VALUES(218,340,'Phytophthora sp. BS-2017c');
INSERT INTO synonym VALUES(219,341,'Phytophthora sp. BS-2017d');
INSERT INTO synonym VALUES(220,345,'Phytophthora capsici LT1534');
INSERT INTO synonym VALUES(221,346,'Phytophthora cinnamomi var robiniae');
INSERT INTO synonym VALUES(222,346,'Phytophthora cinnamomi var. cinnamomi');
INSERT INTO synonym VALUES(223,346,'Phytophthora cinnamomi var. cinnamomi CBS 144.22');
INSERT INTO synonym VALUES(224,346,'Phytophthora cinnamomi var. parvispora');
INSERT INTO synonym VALUES(225,346,'Phytophthora cinnamomi var. robiniae');
INSERT INTO synonym VALUES(226,347,'Halophytophthora cryptogea');
INSERT INTO synonym VALUES(227,347,'Phytophthora cryptogea f.sp. begoniae');
INSERT INTO synonym VALUES(228,348,'Botrytis infestans');
INSERT INTO synonym VALUES(229,348,'Phytophthora infestans 90128');
INSERT INTO synonym VALUES(230,348,'Phytophthora infestans PIC99189');
INSERT INTO synonym VALUES(231,348,'Phytophthora infestans T30-4');
INSERT INTO synonym VALUES(232,348,'Phytophthora infestans strain T30-4');
INSERT INTO synonym VALUES(233,349,'Phytophthora x megasperma');
INSERT INTO synonym VALUES(234,350,'Phytophthora nicotianae var. parasitica');
INSERT INTO synonym VALUES(235,351,'Phytophthora parasitica CJ01A1');
INSERT INTO synonym VALUES(236,351,'Phytophthora parasitica INRA-310');
INSERT INTO synonym VALUES(237,351,'Phytophthora parasitica P10297');
INSERT INTO synonym VALUES(238,351,'Phytophthora parasitica P1569');
INSERT INTO synonym VALUES(239,351,'Phytophthora parasitica P1976');
INSERT INTO synonym VALUES(240,351,'Phytophthora parasitica var. nicotianae');
INSERT INTO synonym VALUES(241,351,'Phytophthora parasitica var. piperina');
INSERT INTO synonym VALUES(242,352,'Phytophthora citrophthora var. clementina');
INSERT INTO synonym VALUES(243,353,'Phytophthora drechsleri var. cajani');
INSERT INTO synonym VALUES(244,355,'Phytophthora palmivora var. palmivora');
INSERT INTO synonym VALUES(245,355,'Phytophthora palmovora');
INSERT INTO synonym VALUES(246,355,'Pythium palmivorum');
INSERT INTO synonym VALUES(247,359,'Phytophthora fragariae var. fragariae');
INSERT INTO synonym VALUES(248,370,'Phytophthora sp. VJF-2015a');
INSERT INTO synonym VALUES(249,375,'P. hedraiandra x P. cactorum');
INSERT INTO synonym VALUES(250,376,'Phytophthora sp. JEB-2011');
INSERT INTO synonym VALUES(251,378,'Phytophthora sp. 11');
INSERT INTO synonym VALUES(252,378,'Phytophthora sp. TIB-2010c');
INSERT INTO synonym VALUES(253,378,'Phytophthora sp. VHS17085');
INSERT INTO synonym VALUES(254,379,'Phytophthora sp. BG-2012');
INSERT INTO synonym VALUES(255,382,'Phytophthora sp. XY-2015');
INSERT INTO synonym VALUES(256,383,'Phytophthora sp. TIB-2016a');
INSERT INTO synonym VALUES(257,384,'Phytophthora humicola x Phytophthora inundata');
INSERT INTO synonym VALUES(258,389,'Phytophthora sp. GHJ-2016a');
INSERT INTO synonym VALUES(259,390,'Phytophthora sp. GHJ-2016b');
INSERT INTO synonym VALUES(260,394,'Phytophthora sp. TIB-2014a');
INSERT INTO synonym VALUES(261,394,'Phytophthora sp. VHS16108');
INSERT INTO synonym VALUES(262,399,'Phytophthora citricola group E');
INSERT INTO synonym VALUES(263,400,'Phytophthora sp. TIB-2011');
INSERT INTO synonym VALUES(264,400,'Phytophthora sp. VHS17350');
INSERT INTO synonym VALUES(265,405,'Phytophthora sp. MD 92');
INSERT INTO synonym VALUES(266,405,'Phytophthora sp. parvasperma');
INSERT INTO synonym VALUES(267,407,'Phytophthora sp. BL-2009a');
INSERT INTO synonym VALUES(268,407,'Phytophthora taxon niederhauserii');
INSERT INTO synonym VALUES(269,409,'Phytophthora pseudocryptogea x Phytophthora sp kelmania');
INSERT INTO synonym VALUES(270,414,'Phytophthora niederhauseri x Phytophthora aff. asparagi');
INSERT INTO synonym VALUES(271,415,'Phytophthora occultans x Phytophthora aff. citrophthora');
INSERT INTO synonym VALUES(272,416,'Phytophthora medicaginis x Phytophthora cryptogea');
INSERT INTO synonym VALUES(273,417,'Phytophthora sp. 1 WAMitV-2013');
INSERT INTO synonym VALUES(274,418,'Phytophthora sp. 2 WAMitV-2013');
INSERT INTO synonym VALUES(275,419,'Phytophthora amnicola x Phytophthora chlamydospora');
INSERT INTO synonym VALUES(276,421,'Phytophthora chlamydospora x Phytophthora lacustris');
INSERT INTO synonym VALUES(277,422,'Phytophthora cactorum x Phytophthora aff. hedraiandra');
INSERT INTO synonym VALUES(278,423,'Phytophthora sp. 1 WCS-2013');
INSERT INTO synonym VALUES(279,427,'Phytophthora applanata');
INSERT INTO synonym VALUES(280,427,'Phytophthora cactorum var. applanata');
INSERT INTO synonym VALUES(281,427,'Phytophthora sp. 748');
INSERT INTO synonym VALUES(282,427,'Phytophthora sp. 753');
INSERT INTO synonym VALUES(283,427,'Phytophthora sp. 764A');
INSERT INTO synonym VALUES(284,427,'Phytophthora sp. 798');
INSERT INTO synonym VALUES(285,427,'Phytophthora sp. 813');
INSERT INTO synonym VALUES(286,427,'Phytophthora sp. CSL 20316642');
INSERT INTO synonym VALUES(287,428,'Phytophthora sp. Toku-1');
INSERT INTO synonym VALUES(288,428,'Phytophthora sp. Toku_1');
INSERT INTO synonym VALUES(289,428,'Phytophthora sp. Toku_3');
INSERT INTO synonym VALUES(290,428,'Phytophthora sp. Toku_8');
INSERT INTO synonym VALUES(291,433,'Phytophthora sp. 1 LB-2013');
INSERT INTO synonym VALUES(292,434,'Phytophthora sp. 2 LB-2013');
INSERT INTO synonym VALUES(293,435,'Phytophthora sp. 3 LB-2013');
INSERT INTO synonym VALUES(294,436,'Phytophthora sp. P3247');
INSERT INTO synonym VALUES(295,439,'Phytophthora chlamydospora x Phytophthora amnicola');
INSERT INTO synonym VALUES(296,440,'Phytophthora cactorum x Phytophthora hedraiandra');
INSERT INTO synonym VALUES(297,442,'Phytophthora nicotianae x Phytophthora cactorum');
INSERT INTO synonym VALUES(298,443,'Phytophthora sp. CH-2008a');
INSERT INTO synonym VALUES(299,446,'Phytophthora sp. GD7A');
INSERT INTO synonym VALUES(300,446,'Phytophthora sp. GD7D');
INSERT INTO synonym VALUES(301,446,'Phytophthora sp. GD7I');
INSERT INTO synonym VALUES(302,448,'Phytophthora sp. CCH-2009b');
INSERT INTO synonym VALUES(303,450,'Phytophthora sp. ''Carya''');
INSERT INTO synonym VALUES(304,450,'Phytophthora sp. CMR-2019a');
INSERT INTO synonym VALUES(305,450,'Phytophthora sp. CMR-2020a');
INSERT INTO synonym VALUES(306,456,'Phytophthora sp. PJA-2014');
INSERT INTO synonym VALUES(307,457,'Phytophthora sp. CH05MT11');
INSERT INTO synonym VALUES(308,457,'Phytophthora sp. CH05MT31');
INSERT INTO synonym VALUES(309,457,'Phytophthora sp. CH05MT40');
INSERT INTO synonym VALUES(310,457,'Phytophthora sp. CH05NSU11');
INSERT INTO synonym VALUES(311,457,'Phytophthora sp. CH05NSU21');
INSERT INTO synonym VALUES(312,457,'Phytophthora sp. CH05NSU31');
INSERT INTO synonym VALUES(313,457,'Phytophthora sp. HSP501');
INSERT INTO synonym VALUES(314,457,'Phytophthora sp. HSP502');
INSERT INTO synonym VALUES(315,457,'Phytophthora sp. HSP503');
INSERT INTO synonym VALUES(316,457,'Phytophthora sp. HSP504');
INSERT INTO synonym VALUES(317,457,'Phytophthora sp. HSP505');
INSERT INTO synonym VALUES(318,457,'Phytophthora sp. HSP506');
INSERT INTO synonym VALUES(319,457,'Phytophthora sp. fragaefolia');
INSERT INTO synonym VALUES(320,458,'Phytophthora sp. NZFRI-2018a');
INSERT INTO synonym VALUES(321,460,'Phytophthora sp. ZGA-2008');
INSERT INTO synonym VALUES(322,464,'Phytophthora sp. WMitV-2016a');
INSERT INTO synonym VALUES(323,465,'Phytophthora sp. VI_3-100B9F');
INSERT INTO synonym VALUES(324,465,'Phytophthora sp. WS-2012a');
INSERT INTO synonym VALUES(325,466,'Phytophthora sp. AKWA58.1-0708');
INSERT INTO synonym VALUES(326,466,'Phytophthora sp. WS-2012b');
INSERT INTO synonym VALUES(327,467,'Phytophthora cactorum/Phytophthora hedraiandra SP-2013');
INSERT INTO synonym VALUES(328,469,'Phytophthora sp. TIB-2010a');
INSERT INTO synonym VALUES(329,470,'Phytophthora sp. 7 TIB-2007');
INSERT INTO synonym VALUES(330,470,'Phytophthora sp. TIB-2007-7');
INSERT INTO synonym VALUES(331,470,'Phytophthora sp. TIB-2010b');
INSERT INTO synonym VALUES(332,470,'Phytophthora sp. raspberry WA');
INSERT INTO synonym VALUES(333,471,'Phytophthora sp. 9 TIB-2007');
INSERT INTO synonym VALUES(334,471,'Phytophthora sp. AJR-2010b');
INSERT INTO synonym VALUES(335,471,'Phytophthora sp. TIB-2007-9');
INSERT INTO synonym VALUES(336,472,'Phytophthora sp. 3 TIB-2007');
INSERT INTO synonym VALUES(337,472,'Phytophthora sp. P10457');
INSERT INTO synonym VALUES(338,472,'Phytophthora sp. TIB-2007-3');
INSERT INTO synonym VALUES(339,472,'Phytophthora sp. TIB-2010d');
INSERT INTO synonym VALUES(340,473,'Phytophthora sp. NPS-2018a');
INSERT INTO synonym VALUES(341,474,'Phytophthora sp. 1 TIB-2007');
INSERT INTO synonym VALUES(342,474,'Phytophthora sp. AJR-2010a');
INSERT INTO synonym VALUES(343,474,'Phytophthora sp. DDS1221');
INSERT INTO synonym VALUES(344,474,'Phytophthora sp. TIB-2007-1');
INSERT INTO synonym VALUES(345,479,'Phytophthora sp. TB-2018a');
INSERT INTO synonym VALUES(346,480,'Phytophthora sp. TB-2018b');
INSERT INTO synonym VALUES(347,482,'Phytophthora sp. WMihV-2008');
INSERT INTO synonym VALUES(348,484,'Phytophthora kernoviae 00238/432');
INSERT INTO synonym VALUES(349,484,'Phytophthora kernoviae 00629/1');
INSERT INTO synonym VALUES(350,484,'Phytophthora kernoviae 00844/4');
INSERT INTO synonym VALUES(351,485,'Phytophthora sp. DRR-2018a');
INSERT INTO synonym VALUES(352,486,'Phytophthora sp. 2 TIB-2007');
INSERT INTO synonym VALUES(353,486,'Phytophthora sp. TIB-2007-2');
INSERT INTO synonym VALUES(354,486,'Phytophthora sp. TIB-2009a');
INSERT INTO synonym VALUES(355,487,'Phytophthora sp. TIB-2009b');
INSERT INTO synonym VALUES(356,501,'Phytophthora sp. TIB-2016b');
INSERT INTO synonym VALUES(357,502,'Phytophthora sp. TIB-2017a');
INSERT INTO synonym VALUES(358,502,'Phytophthora sp. cyperaceae');
INSERT INTO synonym VALUES(359,502,'Phytophthora taxon cyperaceae');
INSERT INTO synonym VALUES(360,503,'Phytophthora sp. TIB-2017b');
INSERT INTO synonym VALUES(361,503,'Phytophthora sp. casuarina');
INSERT INTO synonym VALUES(362,503,'Phytophthora sp. humicola-like/TIB-2010');
INSERT INTO synonym VALUES(363,503,'Phytophthora taxon casuarina');
INSERT INTO synonym VALUES(364,504,'Phytophthora sp. TIB-2017c');
INSERT INTO synonym VALUES(365,504,'Phytophthora sp. kwongan/TIB-2010');
INSERT INTO synonym VALUES(366,505,'Phytophthora sp. DDS3599');
INSERT INTO synonym VALUES(367,505,'Phytophthora sp. IMI329669');
INSERT INTO synonym VALUES(368,505,'Phytophthora sp. TIB-2017d');
INSERT INTO synonym VALUES(369,506,'Phytophthora sp. TIB-2017e');
INSERT INTO synonym VALUES(370,506,'Phytophthora sp. rosacearum-like/TIB-2010');
INSERT INTO synonym VALUES(371,507,'Phytophthora sp. AAD-2008');
INSERT INTO synonym VALUES(372,510,'Phytophthora sp. CH00MKR1');
INSERT INTO synonym VALUES(373,510,'Phytophthora sp. CH00MKR2');
INSERT INTO synonym VALUES(374,510,'Phytophthora sp. CH02PHR1');
INSERT INTO synonym VALUES(375,510,'Phytophthora sp. CH04PHR11');
INSERT INTO synonym VALUES(376,510,'Phytophthora sp. CH04PHR12');
INSERT INTO synonym VALUES(377,510,'Phytophthora sp. CH94PHR1');
INSERT INTO synonym VALUES(378,510,'Phytophthora sp. CH95PHR10');
INSERT INTO synonym VALUES(379,510,'Phytophthora sp. CH95PHR16');
INSERT INTO synonym VALUES(380,510,'Phytophthora sp. CH95PHR17');
INSERT INTO synonym VALUES(381,510,'Phytophthora sp. CH97PHR1');
INSERT INTO synonym VALUES(382,510,'Phytophthora sp. P-A');
INSERT INTO synonym VALUES(383,510,'Phytophthora sp. P-B');
INSERT INTO synonym VALUES(384,511,'Phytophthora lacustris x Phytophthora riparia');
INSERT INTO synonym VALUES(385,515,'Phytophthora sp. Chr3');
INSERT INTO synonym VALUES(386,515,'Phytophthora sp. GF749');
INSERT INTO synonym VALUES(387,515,'Phytophthora sp. MMAM-2009a');
INSERT INTO synonym VALUES(388,515,'Phytophthora sp. MN-2008');
INSERT INTO synonym VALUES(389,516,'Phytophthora thermophila x Phytophthora amnicola');
INSERT INTO synonym VALUES(390,523,'Pythium sp. CNN213');
INSERT INTO synonym VALUES(391,523,'Pythium sp. YYL-2011c');
INSERT INTO synonym VALUES(392,525,'Pythium sp. QBS123');
INSERT INTO synonym VALUES(393,525,'Pythium sp. YYL-2011a');
INSERT INTO synonym VALUES(394,527,'Pythium sp. MA-2016a');
INSERT INTO synonym VALUES(395,528,'Pythium sp. MA-2016c');
INSERT INTO synonym VALUES(396,529,'Pythium sp. D223');
INSERT INTO synonym VALUES(397,532,'Pythium sp. MA-2016b');
INSERT INTO synonym VALUES(398,536,'Pythium aphanidermatum DAOM BR444');
INSERT INTO synonym VALUES(399,536,'Rheosporangium aphanidermatum');
INSERT INTO synonym VALUES(400,538,'Pythium sp. BP-2009a');
INSERT INTO synonym VALUES(401,539,'Pythium sp. BP-2009b');
INSERT INTO synonym VALUES(402,549,'Pythium sp. JJC-2016a');
INSERT INTO synonym VALUES(403,551,'Pythium rhizooryzae');
INSERT INTO synonym VALUES(404,558,'Pythium sp. F-1326');
INSERT INTO synonym VALUES(405,559,'Pythium sp. B07');
INSERT INTO synonym VALUES(406,559,'Pythium sp. B09');
INSERT INTO synonym VALUES(407,559,'Pythium sp. WD41C');
INSERT INTO synonym VALUES(408,559,'Pythium sp. WD41D');
INSERT INTO synonym VALUES(409,569,'Pythium sp. aff iwayamai');
INSERT INTO synonym VALUES(410,570,'Pythium sp. G7-1');
INSERT INTO synonym VALUES(411,571,'Pythium sp. G7-2');
INSERT INTO synonym VALUES(412,572,'Lagenidium caudatum G.L. Barron 1976');
INSERT INTO synonym VALUES(413,573,'Pythium sp. MES-2014');
INSERT INTO synonym VALUES(414,575,'Phytophthora sp. GUCC0007');
INSERT INTO synonym VALUES(415,576,'Phytophthora sp. GUCC0015');
INSERT INTO synonym VALUES(416,578,'Pythium sp. JJC-2018a');
INSERT INTO synonym VALUES(417,590,'Pythium aff. acanthophoron JEB-2016');
INSERT INTO synonym VALUES(418,593,'Nematosporangium monospermum');
INSERT INTO synonym VALUES(419,594,'Pythium pachycaule var. ramificatum');
INSERT INTO synonym VALUES(420,599,'Lagenidium myophilum');
INSERT INTO synonym VALUES(421,608,'Pythium sp. DAOM BR0479');
INSERT INTO synonym VALUES(422,608,'Pythium sp. DAOM BR0836');
INSERT INTO synonym VALUES(423,608,'Pythium sp. DAOM BR479');
INSERT INTO synonym VALUES(424,608,'Pythium sp. DAOM BR836');
INSERT INTO synonym VALUES(425,610,'Elongisporangium anandrum');
INSERT INTO synonym VALUES(426,610,'Pythium sp. GD40G');
INSERT INTO synonym VALUES(427,612,'Pythium sp. DAOM BR0876');
INSERT INTO synonym VALUES(428,612,'Pythium sp. DAOM BR876');
INSERT INTO synonym VALUES(429,613,'Pythium sp. oopapillum');
INSERT INTO synonym VALUES(430,614,'Phytopythium cucurbitacearum');
INSERT INTO synonym VALUES(431,615,'Pythium sp. AvdB-2012');
INSERT INTO synonym VALUES(432,615,'Pythium sp. OPU1078');
INSERT INTO synonym VALUES(433,615,'Pythium sp. OPU1084');
INSERT INTO synonym VALUES(434,615,'Pythium sp. OPU1243');
INSERT INTO synonym VALUES(435,615,'Pythium sp. OPU1244');
INSERT INTO synonym VALUES(436,615,'Pythium sp. OPU1335');
INSERT INTO synonym VALUES(437,615,'Pythium sp. OPU1336');
INSERT INTO synonym VALUES(438,615,'Pythium sp. OPU1435');
INSERT INTO synonym VALUES(439,618,'Pythium zingiberum');
INSERT INTO synonym VALUES(440,622,'Pythium sp. 746B');
INSERT INTO synonym VALUES(441,622,'Pythium sp. 749A');
INSERT INTO synonym VALUES(442,622,'Pythium sp. 749B');
INSERT INTO synonym VALUES(443,622,'Pythium sp. B11');
INSERT INTO synonym VALUES(444,622,'Pythium sp. WD46B');
INSERT INTO synonym VALUES(445,624,'Pythium sp. W006');
INSERT INTO synonym VALUES(446,624,'Pythium sp. W015');
INSERT INTO synonym VALUES(447,624,'Pythium sp. W019');
INSERT INTO synonym VALUES(448,624,'Pythium sp. W021');
INSERT INTO synonym VALUES(449,624,'Pythium sp. W029');
INSERT INTO synonym VALUES(450,624,'Pythium sp. W041');
INSERT INTO synonym VALUES(451,624,'Pythium sp. WD1o');
INSERT INTO synonym VALUES(452,627,'syn. Pythium dreschleri Paul');
INSERT INTO synonym VALUES(453,631,'Pythium sp. MT-2015');
INSERT INTO synonym VALUES(454,632,'Pythium sp. ACB-2015');
INSERT INTO synonym VALUES(455,633,'Pythium sp. WD7A');
INSERT INTO synonym VALUES(456,634,'Pythium sp. 761');
INSERT INTO synonym VALUES(457,634,'Pythium sp. 762');
INSERT INTO synonym VALUES(458,634,'Pythium sp. 773B');
INSERT INTO synonym VALUES(459,634,'Pythium sp. 833A');
INSERT INTO synonym VALUES(460,637,'Pythium sp. 796A');
INSERT INTO synonym VALUES(461,653,'Pythium arrhenomanes ATCC 12531');
INSERT INTO synonym VALUES(462,657,'Pythium sp. GD7F');
INSERT INTO synonym VALUES(463,664,'Lagenidium sp. LM-2012a');
INSERT INTO synonym VALUES(464,665,'Lagenidium sp. RV-2016a');
INSERT INTO synonym VALUES(465,666,'Lagenidium giganteum f. caninum');
INSERT INTO synonym VALUES(466,667,'Lagenidium sp. CBS 135281');
INSERT INTO synonym VALUES(467,667,'Lagenidium sp. CBS135281');
INSERT INTO synonym VALUES(468,667,'Lagenidium sp. PWL-2010c');
INSERT INTO synonym VALUES(469,669,'Lagenidium sp. LM-2014a');
INSERT INTO synonym VALUES(470,677,'Albugo sp. YJC-2010b');
INSERT INTO synonym VALUES(471,681,'Cystopus lepigoni');
INSERT INTO synonym VALUES(472,686,'Uredo cruciferarum');
INSERT INTO synonym VALUES(473,688,'Cystopus resedae');
INSERT INTO synonym VALUES(474,689,'Aecidium candidum');
INSERT INTO synonym VALUES(475,689,'Albugo candida 2VRR');
INSERT INTO synonym VALUES(476,689,'Albugo candida Ac 2V');
INSERT INTO synonym VALUES(477,689,'Albugo candida Ac Bol');
INSERT INTO synonym VALUES(478,689,'Albugo candida Ac Bot');
INSERT INTO synonym VALUES(479,689,'Albugo candida AcNc2');
INSERT INTO synonym VALUES(480,692,'Albugo laibachii Alem1');
INSERT INTO synonym VALUES(481,692,'Albugo laibachii Nc14');
INSERT INTO synonym VALUES(482,692,'Albugo sp. MT-2009');
INSERT INTO synonym VALUES(483,697,'Peronospora sp. MMT-2012');
INSERT INTO synonym VALUES(484,721,'Peronospora chenopodii');
INSERT INTO synonym VALUES(485,721,'Peronospora farinosa f. sp. betae');
INSERT INTO synonym VALUES(486,721,'Peronospora farinosa f. sp. chenopodii');
INSERT INTO synonym VALUES(487,721,'Peronospora farinosa f. sp. spinaciae');
INSERT INTO synonym VALUES(488,721,'Peronospora farinosa f.sp. betae');
INSERT INTO synonym VALUES(489,721,'Peronospora farinosa f.sp. chenopodii');
INSERT INTO synonym VALUES(490,771,'Peronospora cf. ducometi');
INSERT INTO synonym VALUES(491,772,'Peronospora polycarponis');
INSERT INTO synonym VALUES(492,795,'Peronospora melandrii-noctiflori');
INSERT INTO synonym VALUES(493,801,'Peronospora pisi');
INSERT INTO synonym VALUES(494,801,'Peronospora viciae f. sp. fabae');
INSERT INTO synonym VALUES(495,801,'Peronospora viciae f. sp. pisi');
INSERT INTO synonym VALUES(496,801,'Peronospora viciae f.sp. pisi');
INSERT INTO synonym VALUES(497,804,'Peronospora elscholtziae');
INSERT INTO synonym VALUES(498,819,'Peronospora trifolii-pratensis');
INSERT INTO synonym VALUES(499,819,'Peronospora trifoliorum f. trifolii-pratensis');
INSERT INTO synonym VALUES(500,840,'Peronospora sp. HV2280');
INSERT INTO synonym VALUES(501,843,'Peronospora digitalidis');
INSERT INTO synonym VALUES(502,862,'Peronospora sp. HV-2014a');
INSERT INTO synonym VALUES(503,863,'Peronospora sp. HV-2014b');
INSERT INTO synonym VALUES(504,870,'Isoachlya humphreyana');
INSERT INTO synonym VALUES(505,872,'Pythiopsis sp. 760B');
INSERT INTO synonym VALUES(506,889,'Aphanomyces sp. SH-2018a');
INSERT INTO synonym VALUES(507,891,'Aphanomyces sp. NJM 0801');
INSERT INTO synonym VALUES(508,891,'Aphanomyces sp. NJM 0802');
INSERT INTO synonym VALUES(509,891,'Aphanomyces sp. NJM 0803');
INSERT INTO synonym VALUES(510,891,'Aphanomyces sp. NJM 0804');
INSERT INTO synonym VALUES(511,891,'Aphanomyces sp. NJM 0805');
INSERT INTO synonym VALUES(512,894,'Aphanomyces sp. NJM 0719');
INSERT INTO synonym VALUES(513,894,'Aphanomyces sp. NJM 0817');
INSERT INTO synonym VALUES(514,894,'Aphanomyces sp. NJM 0818');
INSERT INTO synonym VALUES(515,894,'Aphanomyces sp. NJM 0901');
INSERT INTO synonym VALUES(516,894,'Aphanomyces sp. NJM 0902');
INSERT INTO synonym VALUES(517,900,'Aphanomyces euteiches f. sp. phaseoli');
INSERT INTO synonym VALUES(518,907,'Brevilegnia unisperma var. delica');
INSERT INTO synonym VALUES(519,920,'Phytophthora epistomium');
INSERT INTO synonym VALUES(520,921,'Phytophthora bahamensis');
INSERT INTO synonym VALUES(521,922,'Halophytophthora sp. XY-2014');
INSERT INTO synonym VALUES(522,924,'Phytophthora vesicula');
INSERT INTO synonym VALUES(523,925,'Phytophthora avicenniae');
INSERT INTO synonym VALUES(524,926,'Phytophthora sp. P15166');
INSERT INTO synonym VALUES(525,931,'Phytophthora mycoparasitica');
INSERT INTO synonym VALUES(526,932,'Phytophthora polymorphica');
INSERT INTO synonym VALUES(527,939,'Atkinsiella okinawaensis');
INSERT INTO synonym VALUES(528,947,'Peronospora simplex');
INSERT INTO synonym VALUES(529,948,'Protomyces graminicola');
INSERT INTO synonym VALUES(530,949,'Paraperonospora leptosperma (de Bary) Constant');
INSERT INTO synonym VALUES(531,950,'Plasmopara tanaceti');
INSERT INTO synonym VALUES(532,952,'Peronospora lobulariae');
INSERT INTO synonym VALUES(533,953,'Peronospora rorippae-islandicae');
INSERT INTO synonym VALUES(534,954,'Peronospora sisymbrii-sophiae');
INSERT INTO synonym VALUES(535,955,'Peronospora niessleana');
INSERT INTO synonym VALUES(536,955,'Peronospora niessliana');
INSERT INTO synonym VALUES(537,956,'Peronospora drabae');
INSERT INTO synonym VALUES(538,958,'Peronospora drabae-majusculae');
INSERT INTO synonym VALUES(539,958,'Peronospora erophilae');
INSERT INTO synonym VALUES(540,959,'Peronospora thlaspeos-alpestris');
INSERT INTO synonym VALUES(541,959,'Peronospora thlaspeos-perfoliati');
INSERT INTO synonym VALUES(542,960,'Peronospora norvegica');
INSERT INTO synonym VALUES(543,961,'Hyaloperonospora aff. parasitica');
INSERT INTO synonym VALUES(544,961,'Hyaloperonospora parasitica');
INSERT INTO synonym VALUES(545,961,'Hyaloperonospora parasitica f. brassicae');
INSERT INTO synonym VALUES(546,961,'Hyaloperonospora parasitica f. raphani');
INSERT INTO synonym VALUES(547,961,'Hyaloperonospora parasitica sensu lato');
INSERT INTO synonym VALUES(548,961,'Peronospora crispula');
INSERT INTO synonym VALUES(549,961,'Peronospora diplotaxidis');
INSERT INTO synonym VALUES(550,961,'Peronospora iberidis');
INSERT INTO synonym VALUES(551,961,'Peronospora lepidii-sativi');
INSERT INTO synonym VALUES(552,961,'Peronospora parasitica');
INSERT INTO synonym VALUES(553,961,'Peronospora sisymbrii-officinalis');
INSERT INTO synonym VALUES(554,961,'[Peronospora] crispula');
INSERT INTO synonym VALUES(555,961,'[Peronospora] diplotaxidis');
INSERT INTO synonym VALUES(556,961,'[Peronospora] iberidis');
INSERT INTO synonym VALUES(557,961,'[Peronospora] lepidii-sativi');
INSERT INTO synonym VALUES(558,961,'[Peronospora] sisymbrii-officinalis');
INSERT INTO synonym VALUES(559,964,'Peronospora camelinae');
INSERT INTO synonym VALUES(560,965,'Peronospora lunariae');
INSERT INTO synonym VALUES(561,966,'Peronospora tribulina');
INSERT INTO synonym VALUES(562,967,'Peronospora arabidis-glabrae');
INSERT INTO synonym VALUES(563,968,'Peronospora nasturtii-montani');
INSERT INTO synonym VALUES(564,969,'Hyaloperonospora arabidopsidis East Malling Oystese 2');
INSERT INTO synonym VALUES(565,969,'Hyaloperonospora arabidopsidis Emoy2');
INSERT INTO synonym VALUES(566,969,'Hyaloperonospora arabidopsis');
INSERT INTO synonym VALUES(567,969,'Hyaloperonospora parasitica Emoy2');
INSERT INTO synonym VALUES(568,969,'Hyaloperonospora parasitica strain Emoy2');
INSERT INTO synonym VALUES(569,969,'Peronospora arabidopsidis');
INSERT INTO synonym VALUES(570,970,'Peronospora berteroae');
INSERT INTO synonym VALUES(571,971,'Peronospora nasturtii-palustris');
INSERT INTO synonym VALUES(572,972,'Hyaloperonospora sp. CSS-2020a');
INSERT INTO synonym VALUES(573,973,'Peronospora cardaminopsidis');
INSERT INTO synonym VALUES(574,974,'Peronospora cheiranthi');
INSERT INTO synonym VALUES(575,974,'Peronospora erysimi');
INSERT INTO synonym VALUES(576,975,'Peronospora cochleariae');
INSERT INTO synonym VALUES(577,976,'Peronospora galligena');
INSERT INTO synonym VALUES(578,977,'Peronospora buniadis');
INSERT INTO synonym VALUES(579,977,'Peronospora hesperidis');
INSERT INTO synonym VALUES(580,978,'Peronospora isatidis');
INSERT INTO synonym VALUES(581,979,'Peronospora nasturtii-aquatici');
INSERT INTO synonym VALUES(582,980,'Peronospora barbareae');
INSERT INTO synonym VALUES(583,981,'Peronospora dentariae');
INSERT INTO synonym VALUES(584,982,'Peronospora thlaspeos-arvensis');
INSERT INTO synonym VALUES(585,983,'Peronospora brassicae');
INSERT INTO synonym VALUES(586,984,'Peronospora sisymbrii-loeselii');
INSERT INTO synonym VALUES(587,985,'Peronospora teesdaliae');
INSERT INTO synonym VALUES(588,986,'Hyaloperonospora sp. HHV-2010');
INSERT INTO synonym VALUES(589,987,'Peronospora nesleae');
INSERT INTO synonym VALUES(590,988,'Peronospora arabis-alpinae');
INSERT INTO synonym VALUES(591,989,'Peronospora cardamines-laciniatae');
INSERT INTO synonym VALUES(592,990,'Peronospora dentariae-macrophyllae');
INSERT INTO synonym VALUES(593,991,'Peronospora malyi');
INSERT INTO synonym VALUES(594,994,'Peronosclerospora phillippinensis');
INSERT INTO synonym VALUES(595,994,'Sclerospora philippinensis');
INSERT INTO synonym VALUES(596,995,'Peronospora maydis');
INSERT INTO synonym VALUES(597,1005,'Plasmopara oplismeni');
INSERT INTO synonym VALUES(598,1006,'Plasmopara sphaerosperma');
INSERT INTO synonym VALUES(599,1008,'Botrytis pygmaea');
INSERT INTO synonym VALUES(600,1008,'Plasmopara pygmaea');
INSERT INTO synonym VALUES(601,1008,'Plasmoverna pygmea');
INSERT INTO synonym VALUES(602,1009,'Plasmoverna anemone-ranunculoides');
INSERT INTO synonym VALUES(603,1009,'Plasmoverna anemones-ranunculoidis');
INSERT INTO synonym VALUES(604,1010,'Plasmopara isopyri-thalictroidis');
INSERT INTO synonym VALUES(605,1011,'Bremia graminicola');
INSERT INTO synonym VALUES(606,1016,'Atkinsiella panulirata');
INSERT INTO synonym VALUES(607,1016,'Halocrusticida panulirata');
INSERT INTO synonym VALUES(608,1016,'Halocrusticida panuliri');
INSERT INTO synonym VALUES(609,1018,'Olpidiopsis sp. AB-2019a');
INSERT INTO synonym VALUES(610,1019,'Pontisma feldmannii');
INSERT INTO synonym VALUES(611,1030,'Chlamydomyzium sp. TYJ-2012');
INSERT INTO synonym VALUES(612,1031,'Albugo portulacae');
INSERT INTO synonym VALUES(613,1031,'Albugo portulaceae');
INSERT INTO synonym VALUES(614,1032,'Albugo platensis');
INSERT INTO synonym VALUES(615,1033,'Albugo achyranthis');
INSERT INTO synonym VALUES(616,1034,'Albugo bliti');
INSERT INTO synonym VALUES(617,1035,'Albugo amaranthi');
INSERT INTO synonym VALUES(618,1036,'Pustula sp. SSP-2010a');
INSERT INTO synonym VALUES(619,1037,'Pustula sp. BX-2017a');
INSERT INTO synonym VALUES(620,1038,'Pustula sp. BX-2017b');
INSERT INTO synonym VALUES(621,1039,'Albugo spinulosus');
INSERT INTO synonym VALUES(622,1040,'Albugo tragopogonis');
INSERT INTO synonym VALUES(623,1040,'Puccinia tragopogonis');
INSERT INTO synonym VALUES(624,1041,'Pustula sp. BX-2016a');
INSERT INTO synonym VALUES(625,1042,'Caeoma (Uredo) obtusatum');
INSERT INTO synonym VALUES(626,1042,'Caeoma obtusatum');
INSERT INTO synonym VALUES(627,1043,'Pustula sp. MT-2011');
INSERT INTO synonym VALUES(628,1044,'Haliphthoraceae sp. NJM 0447');
INSERT INTO synonym VALUES(629,1044,'Haliphthoraceae sp. NJM 0451');
INSERT INTO synonym VALUES(630,1044,'Haliphthoraceae sp. NJM 0462');
INSERT INTO synonym VALUES(631,1044,'Haliphthoraceae sp. NJM 0631');
INSERT INTO synonym VALUES(632,1045,'Phytopythium sp. RB-2017b');
INSERT INTO synonym VALUES(633,1046,'Phytopythium sp. RB-2017a');
INSERT INTO synonym VALUES(634,1047,'Halophytophthora kandeliae');
INSERT INTO synonym VALUES(635,1047,'Halophytophthora kandelii');
INSERT INTO synonym VALUES(636,1047,'Phytopythium sp. AVM-2014');
INSERT INTO synonym VALUES(637,1048,'Ovatisporangium vexans');
INSERT INTO synonym VALUES(638,1048,'Phytopythium sp. AL-2010');
INSERT INTO synonym VALUES(639,1048,'Phytopythium vexans DAOM BR484');
INSERT INTO synonym VALUES(640,1048,'Pythium vexans');
INSERT INTO synonym VALUES(641,1049,'Ovatisporangium citrinum');
INSERT INTO synonym VALUES(642,1049,'Pythium citrinum');
INSERT INTO synonym VALUES(643,1050,'Phytopythium sp. MAB-2011a');
INSERT INTO synonym VALUES(644,1050,'Pythium mercuriale');
INSERT INTO synonym VALUES(645,1050,'Pythium sp. STE-U 6124');
INSERT INTO synonym VALUES(646,1050,'Pythium sp. STE-U 6125');
INSERT INTO synonym VALUES(647,1050,'Pythium sp. STE-U 6126');
INSERT INTO synonym VALUES(648,1050,'Pythium sp. STE-U 6127');
INSERT INTO synonym VALUES(649,1050,'Pythium sp. STE-U 6204');
INSERT INTO synonym VALUES(650,1050,'Pythium sp. STE-U 6205');
INSERT INTO synonym VALUES(651,1050,'Pythium sp. STE-U 6206');
INSERT INTO synonym VALUES(652,1050,'Pythium sp. STE-U 6207');
INSERT INTO synonym VALUES(653,1051,'Pythium oedichilum');
INSERT INTO synonym VALUES(654,1051,'Pythium oedochilum');
INSERT INTO synonym VALUES(655,1054,'Pythium carbonicum');
INSERT INTO synonym VALUES(656,1056,'Phytophthora fagopyri');
INSERT INTO synonym VALUES(657,1056,'Phytopythium sp. MAB-2011c');
INSERT INTO synonym VALUES(658,1057,'Phytopythium sp. TLR-2014');
INSERT INTO synonym VALUES(659,1058,'Phytopythium sp. MAB-2011e');
INSERT INTO synonym VALUES(660,1059,'Pythium palingenes');
INSERT INTO synonym VALUES(661,1060,'Ovatisporangium litorale');
INSERT INTO synonym VALUES(662,1060,'Pythium litorale');
INSERT INTO synonym VALUES(663,1060,'Pythium litoralis');
INSERT INTO synonym VALUES(664,1062,'Phytopythium sp. MAB-2011d');
INSERT INTO synonym VALUES(665,1062,'Pythium delawarei');
INSERT INTO synonym VALUES(666,1062,'Pythium delawarense');
INSERT INTO synonym VALUES(667,1062,'Pythium delawarii');
INSERT INTO synonym VALUES(668,1062,'Pythium sp. delawarii');
INSERT INTO synonym VALUES(669,1063,'Ovatisporangium montanum');
INSERT INTO synonym VALUES(670,1063,'Pythium montanum');
INSERT INTO synonym VALUES(671,1063,'Pythium sp. 334');
INSERT INTO synonym VALUES(672,1064,'Pythium boreale');
INSERT INTO synonym VALUES(673,1065,'Phytopythium chamaihyphon');
INSERT INTO synonym VALUES(674,1065,'Phytopythium sp. MAB-2011f');
INSERT INTO synonym VALUES(675,1065,'Pythium chamaehyphon');
INSERT INTO synonym VALUES(676,1065,'Pythium chamaihyphon');
INSERT INTO synonym VALUES(677,1066,'Pythium helicoides');
INSERT INTO synonym VALUES(678,1067,'Pythium megacarpum');
INSERT INTO synonym VALUES(679,1068,'Ovatisporangium ostracodes');
INSERT INTO synonym VALUES(680,1068,'Phytopythium sp. MAB-2011b');
INSERT INTO synonym VALUES(681,1068,'Pythium ostracodes');
INSERT INTO synonym VALUES(682,1073,'Pythiogeton puliensis');
INSERT INTO synonym VALUES(683,1073,'Pythiogeton sp. JH-2012a');
INSERT INTO synonym VALUES(684,1074,'Pythiogeton sp. JH-2012b');
INSERT INTO synonym VALUES(685,1075,'Pythiogeton sp. JH-2012c');
INSERT INTO synonym VALUES(686,1076,'Pythiogeton sp. JH-2012d');
INSERT INTO synonym VALUES(687,1077,'Pythiogeton sp. JH-2012e');
INSERT INTO synonym VALUES(688,1078,'Pythiogeton sp. JH-2012f');
INSERT INTO synonym VALUES(689,1081,'Halophytophthora tartarea');
INSERT INTO synonym VALUES(690,1082,'Basidiophora butleri');
INSERT INTO synonym VALUES(691,1082,'Sclerophthora butleri');
INSERT INTO synonym VALUES(692,1082,'Sclerospora butleri');
INSERT INTO synonym VALUES(693,1084,'Paralagenidium sp. LM-2019a');
INSERT INTO synonym VALUES(694,1085,'Lagenidium karlingii');
INSERT INTO synonym VALUES(695,1085,'Lagenidium sp. LM-2012c');
INSERT INTO synonym VALUES(696,1086,'Pythium sylvaticum');
INSERT INTO synonym VALUES(697,1087,'Pythium violae');
INSERT INTO synonym VALUES(698,1088,'Pythium abappressorium');
INSERT INTO synonym VALUES(699,1088,'Pythium sp. abappressorium');
INSERT INTO synonym VALUES(700,1089,'Pythium glomeratum');
INSERT INTO synonym VALUES(701,1090,'Pythium polymastum');
INSERT INTO synonym VALUES(702,1091,'Pythium sp. F-1022');
INSERT INTO synonym VALUES(703,1091,'Pythium spiculum');
INSERT INTO synonym VALUES(704,1092,'Pythium carolinianum');
INSERT INTO synonym VALUES(705,1093,'Pythium erinaceum');
INSERT INTO synonym VALUES(706,1094,'Pythium debaryanum');
INSERT INTO synonym VALUES(707,1095,'Pythium acanthophoron');
INSERT INTO synonym VALUES(708,1096,'Pythium rhizosaccharum');
INSERT INTO synonym VALUES(709,1097,'Pythium orthogonon');
INSERT INTO synonym VALUES(710,1098,'Pythium paroecandrum');
INSERT INTO synonym VALUES(711,1098,'Pythium sp. 839A');
INSERT INTO synonym VALUES(712,1099,'Pythium heterothallicum');
INSERT INTO synonym VALUES(713,1099,'Pythium sp. 847A');
INSERT INTO synonym VALUES(714,1100,'Pythium spinosum');
INSERT INTO synonym VALUES(715,1101,'Pythium cylindrosporum');
INSERT INTO synonym VALUES(716,1102,'Pythium hypogynum');
INSERT INTO synonym VALUES(717,1103,'Pythium longisporangium');
INSERT INTO synonym VALUES(718,1104,'Pythium echinulatum');
INSERT INTO synonym VALUES(719,1105,'Pythium nodosum');
INSERT INTO synonym VALUES(720,1106,'Pythium ornacarpum');
INSERT INTO synonym VALUES(721,1107,'Pythium sp. SU-2017');
INSERT INTO synonym VALUES(722,1108,'Pythium acrogynum');
INSERT INTO synonym VALUES(723,1109,'Pythium multisporum');
INSERT INTO synonym VALUES(724,1110,'Pythium pleroticum');
INSERT INTO synonym VALUES(725,1111,'Pythium cystogenes');
INSERT INTO synonym VALUES(726,1112,'Globisporangium ultimum DAOM BR144');
INSERT INTO synonym VALUES(727,1112,'Globisporangium ultimum DAOM BR748');
INSERT INTO synonym VALUES(728,1112,'Globisporangium ultimum var. sporangiiferum');
INSERT INTO synonym VALUES(729,1112,'Globisporangium ultimum var. sporangiiferum BR650');
INSERT INTO synonym VALUES(730,1112,'Globisporangium ultimum var. ultimum');
INSERT INTO synonym VALUES(731,1112,'Pythium ultimum');
INSERT INTO synonym VALUES(732,1112,'Pythium ultimum var. sporangiiferum');
INSERT INTO synonym VALUES(733,1112,'Pythium ultimum var. ultimum');
INSERT INTO synonym VALUES(734,1113,'Pythium solare');
INSERT INTO synonym VALUES(735,1114,'Pythium proliferatum');
INSERT INTO synonym VALUES(736,1115,'Pythium recalcitrans');
INSERT INTO synonym VALUES(737,1116,'Pythium macrosporum');
INSERT INTO synonym VALUES(738,1117,'Pythium okanoganense');
INSERT INTO synonym VALUES(739,1118,'Pythium rostratifingens');
INSERT INTO synonym VALUES(740,1119,'Pythium rostratum');
INSERT INTO synonym VALUES(741,1120,'Pythium radiosum');
INSERT INTO synonym VALUES(742,1121,'Pythium parvum');
INSERT INTO synonym VALUES(743,1122,'Pythium marsipium');
INSERT INTO synonym VALUES(744,1123,'Pythium kunmingense');
INSERT INTO synonym VALUES(745,1124,'Globisporangium iwayamae DAOM BR242034');
INSERT INTO synonym VALUES(746,1124,'Pythium iwayamae');
INSERT INTO synonym VALUES(747,1125,'Pythium mamillatum');
INSERT INTO synonym VALUES(748,1125,'Pythium sp. 836A');
INSERT INTO synonym VALUES(749,1125,'Pythium sp. 838A');
INSERT INTO synonym VALUES(750,1126,'Pythium paddicum');
INSERT INTO synonym VALUES(751,1127,'Pythium pulchrum');
INSERT INTO synonym VALUES(752,1128,'Pythium segnitium');
INSERT INTO synonym VALUES(753,1129,'Pythium nagaii');
INSERT INTO synonym VALUES(754,1130,'Pythium cryptoirregulare');
INSERT INTO synonym VALUES(755,1131,'Globisporangium sp. SU-2016');
INSERT INTO synonym VALUES(756,1131,'Pythium sp. UZ382');
INSERT INTO synonym VALUES(757,1132,'Pythium perplexum');
INSERT INTO synonym VALUES(758,1133,'Globisporangium irregulare DAOM BR486');
INSERT INTO synonym VALUES(759,1133,'Pythium irregulare');
INSERT INTO synonym VALUES(760,1133,'Pythium sp. 766');
INSERT INTO synonym VALUES(761,1133,'Pythium sp. 851A');
INSERT INTO synonym VALUES(762,1134,'Pythium splendens');
INSERT INTO synonym VALUES(763,1135,'Pythium attrantheridium');
INSERT INTO synonym VALUES(764,1136,'Pythium intermedium');
INSERT INTO synonym VALUES(765,1137,'Pythium buismaniae');
INSERT INTO synonym VALUES(766,1138,'Pythium regulare');
INSERT INTO synonym VALUES(767,1139,'Pythium mastophorum');
INSERT INTO synonym VALUES(768,1140,'Pythium megalacanthum');
INSERT INTO synonym VALUES(769,1141,'Pythium campanulatum');
INSERT INTO synonym VALUES(770,1142,'Pythium lucens');
INSERT INTO synonym VALUES(771,1143,'Pythium middletonii');
INSERT INTO synonym VALUES(772,1145,'Pythium nunn');
INSERT INTO synonym VALUES(773,1146,'Pythium canariense');
INSERT INTO synonym VALUES(774,1147,'Lagenocystis radicicola');
INSERT INTO synonym VALUES(775,1150,'Achlya oblongata');
INSERT INTO synonym VALUES(776,1152,'Achlya spinosa');
INSERT INTO synonym VALUES(777,1153,'Achlya apiculata');
INSERT INTO synonym VALUES(778,1154,'Pythium apinafurcum');
INSERT INTO synonym VALUES(779,1154,'Pythium sp. UZ300');
INSERT INTO synonym VALUES(780,1155,'Pleotrachelus rosenvingii');
INSERT INTO synonym VALUES(781,1159,'Lagenidium callinectes');
INSERT INTO synonym VALUES(782,1160,'Lagenidium chthamalophilum');
INSERT INTO synonym VALUES(783,1161,'Lagenidium thermophilum');
INSERT INTO synonym VALUES(784,1164,'Boababopsis donbarretti');
INSERT INTO synonym VALUES(785,1165,'Peronosporales sp. YJC-2015b');
INSERT INTO synonym VALUES(786,1166,'Halophytophthora sp. GHJ-2016a');
INSERT INTO synonym VALUES(787,1167,'Halophytophthora spinosa');
INSERT INTO synonym VALUES(788,1167,'Halophytophthora spinosa var. spinosa');
INSERT INTO synonym VALUES(789,1167,'Phytophthora spinosa');
INSERT INTO synonym VALUES(790,1167,'Salispina spinosa var. spinosa');
INSERT INTO synonym VALUES(791,1168,'Halophytophthora spinosa var. lobata');
INSERT INTO synonym VALUES(792,1168,'Phytophthora spinosa var. lobata');
INSERT INTO synonym VALUES(793,1175,'Halophytophthora operculata');
INSERT INTO synonym VALUES(794,1175,'Peronosporaceae sp. RB-2017a');
INSERT INTO synonym VALUES(795,1175,'Phytophthora operculata');
INSERT INTO synonym VALUES(796,1175,'Phytopythium operculatum');
INSERT INTO synonym VALUES(797,1175,'Phytopythium sp. TLR-2014a');
INSERT INTO synonym VALUES(798,1176,'Peronosporaceae sp. RB-2017b');
INSERT INTO synonym VALUES(799,1179,'Miracula sp. AB-2018a');
INSERT INTO synonym VALUES(800,1181,'Olpidiopsis porphyrae');
INSERT INTO synonym VALUES(801,1181,'Olpidiopsis sp. porphyrae');
INSERT INTO synonym VALUES(802,1182,'Olpidiopsis muelleri');
INSERT INTO synonym VALUES(803,1182,'Olpidiopsis sp. YB-2017a');
INSERT INTO synonym VALUES(804,1183,'Olpidiopsis palmariae');
INSERT INTO synonym VALUES(805,1183,'Olpidiopsis sp. YB-2017b');
INSERT INTO synonym VALUES(806,1184,'Olpidiopsis heterosiphoniae');
INSERT INTO synonym VALUES(807,1185,'Olpidiopsis bostrychiae');
INSERT INTO synonym VALUES(808,1186,'Olpidiopsis pyropiae');
INSERT INTO synonym VALUES(809,1188,'Olpidiopsis drebesii');
INSERT INTO synonym VALUES(810,1189,'Diatomophthora perforans subsp. destruens');
INSERT INTO synonym VALUES(811,1189,'Diatomophthora perforans subsp. norvegica');
INSERT INTO synonym VALUES(812,1189,'Diatomophthora perforans subsp. pleurosigmae');
INSERT INTO synonym VALUES(813,1189,'Diatomophthora sp. AB-2019a');
INSERT INTO synonym VALUES(814,1189,'Diatomophthora sp. AB-2019b');
INSERT INTO synonym VALUES(815,1189,'Diatomophthora sp. AB-2019c');
INSERT INTO synonym VALUES(816,1189,'Diatomophthora sp. AB-2019d');
INSERT INTO synonym VALUES(817,1189,'Ectrogella perforans');
INSERT INTO synonym VALUES(818,1190,'Olpidiopsis gillii');
INSERT INTO synonym VALUES(819,1190,'Olpidium gillii De Wild., 1896');
INSERT INTO synonym VALUES(820,1191,'Leptomitales sp. WWM-2019a');
INSERT INTO synonym VALUES(821,1,'Achlya sp. BKKU1005');
INSERT INTO synonym VALUES(822,1,'Achlya sp. BKKU1009');
INSERT INTO synonym VALUES(823,1,'Achlya sp. BKKU1117');
INSERT INTO synonym VALUES(824,1,'Achlya sp. BKKU1118');
INSERT INTO synonym VALUES(825,1,'Achlya sp. BKKU1127');
INSERT INTO synonym VALUES(826,1,'Achlya sp. BKKU1134');
INSERT INTO synonym VALUES(827,1,'Achlya sp. YC');
INSERT INTO synonym VALUES(828,1,'Achlya sp. S2AC');
INSERT INTO synonym VALUES(829,1,'Achlya sp. (in: Oomycetes)');
INSERT INTO synonym VALUES(830,1,'Achlya sp. 1 HM-2018');
INSERT INTO synonym VALUES(831,1,'Achlya sp. 02RCT');
INSERT INTO synonym VALUES(832,1,'Achlya sp. CORA1');
INSERT INTO synonym VALUES(833,1,'Achlya sp. DG');
INSERT INTO synonym VALUES(834,1,'Achlya sp. EM23');
INSERT INTO synonym VALUES(835,1,'Achlya sp. EM25');
INSERT INTO synonym VALUES(836,1,'Achlya sp. EM26B');
INSERT INTO synonym VALUES(837,1,'Achlya sp. EM31B');
INSERT INTO synonym VALUES(838,1,'Achlya sp. EM31E');
INSERT INTO synonym VALUES(839,1,'Achlya sp. EM32C');
INSERT INTO synonym VALUES(840,1,'Achlya sp. EM47A');
INSERT INTO synonym VALUES(841,1,'Achlya sp. EM7');
INSERT INTO synonym VALUES(842,1,'Achlya sp. MOT2');
INSERT INTO synonym VALUES(843,1,'Achlya sp. MOTAD3');
INSERT INTO synonym VALUES(844,1,'Achlya sp. O3EG1');
INSERT INTO synonym VALUES(845,1,'Achlya sp. PCRTB2');
INSERT INTO synonym VALUES(846,1,'Achlya sp. SCAAD');
INSERT INTO synonym VALUES(847,1,'Achlya sp. BMS8');
INSERT INTO synonym VALUES(848,1,'Achlya sp. BMS1');
INSERT INTO synonym VALUES(849,1,'Achlya sp. BMF1');
INSERT INTO synonym VALUES(850,1,'Achlya sp. 2 HM-2018');
INSERT INTO synonym VALUES(851,1,'Achlya sp. MNS-2014a');
INSERT INTO synonym VALUES(852,1,'Achlya sp. LB63');
INSERT INTO synonym VALUES(853,1,'Achlya sp. LB35');
INSERT INTO synonym VALUES(854,1,'Achlya sp. strain S3');
INSERT INTO synonym VALUES(855,2,'Saprolegnia sp. 14');
INSERT INTO synonym VALUES(856,2,'Saprolegnia sp. 06');
INSERT INTO synonym VALUES(857,2,'Saprolegnia sp. CY1');
INSERT INTO synonym VALUES(858,2,'Saprolegnia sp. HZL1');
INSERT INTO synonym VALUES(859,2,'Saprolegnia sp. JE1');
INSERT INTO synonym VALUES(860,2,'Saprolegnia sp. JY2');
INSERT INTO synonym VALUES(861,2,'Saprolegnia sp. RACA0702');
INSERT INTO synonym VALUES(862,2,'Saprolegnia sp. SAP0792');
INSERT INTO synonym VALUES(863,2,'Saprolegnia sp. BOLD:AAO5998');
INSERT INTO synonym VALUES(864,2,'Saprolegnia sp. SAP0900');
INSERT INTO synonym VALUES(865,2,'Saprolegnia sp. SAP0933');
INSERT INTO synonym VALUES(866,2,'Saprolegnia sp. DC3U2_2007');
INSERT INTO synonym VALUES(867,2,'Saprolegnia sp. DC3U9_2007');
INSERT INTO synonym VALUES(868,2,'Saprolegnia sp. HP');
INSERT INTO synonym VALUES(869,2,'Saprolegnia cf. kauffmanniana H1E2');
INSERT INTO synonym VALUES(870,2,'Saprolegnia sp. AE1');
INSERT INTO synonym VALUES(871,2,'Saprolegnia sp. BBE08');
INSERT INTO synonym VALUES(872,2,'Saprolegnia sp. BBE15');
INSERT INTO synonym VALUES(873,2,'Saprolegnia sp. BBE17');
INSERT INTO synonym VALUES(874,2,'Saprolegnia sp. BBE20');
INSERT INTO synonym VALUES(875,2,'Saprolegnia sp. H1E1');
INSERT INTO synonym VALUES(876,2,'Saprolegnia sp. H1E4');
INSERT INTO synonym VALUES(877,2,'Saprolegnia sp. H2E1');
INSERT INTO synonym VALUES(878,2,'Saprolegnia sp. H2E3');
INSERT INTO synonym VALUES(879,2,'Saprolegnia sp. H3E1');
INSERT INTO synonym VALUES(880,2,'Saprolegnia sp. H3E2');
INSERT INTO synonym VALUES(881,2,'Saprolegnia sp. H3E3');
INSERT INTO synonym VALUES(882,2,'Saprolegnia sp. H3E5');
INSERT INTO synonym VALUES(883,2,'Saprolegnia sp. SAP1103');
INSERT INTO synonym VALUES(884,2,'Saprolegnia sp. crucian carp/strain JL');
INSERT INTO synonym VALUES(885,2,'Saprolegnia sp. THMK0306');
INSERT INTO synonym VALUES(886,2,'Saprolegnia sp. SAP1280');
INSERT INTO synonym VALUES(887,2,'Saprolegnia sp. SAP1298');
INSERT INTO synonym VALUES(888,2,'Saprolegnia sp. SAP1304');
INSERT INTO synonym VALUES(889,2,'Saprolegnia sp. SAP1310');
INSERT INTO synonym VALUES(890,2,'Saprolegnia sp. SAP1311');
INSERT INTO synonym VALUES(891,2,'Saprolegnia sp. SAP1312');
INSERT INTO synonym VALUES(892,2,'Saprolegnia sp. F-1561.8');
INSERT INTO synonym VALUES(893,2,'Saprolegnia sp. WD4C');
INSERT INTO synonym VALUES(894,2,'Saprolegnia sp. SAP1');
INSERT INTO synonym VALUES(895,2,'Saprolegnia sp. SAP2');
INSERT INTO synonym VALUES(896,2,'Saprolegnia sp. SAP3');
INSERT INTO synonym VALUES(897,2,'Saprolegnia sp. SAP4');
INSERT INTO synonym VALUES(898,2,'Saprolegnia sp. EM14');
INSERT INTO synonym VALUES(899,2,'Saprolegnia sp. EM25');
INSERT INTO synonym VALUES(900,2,'Saprolegnia sp. P8203');
INSERT INTO synonym VALUES(901,2,'Saprolegnia sp. SAP0261');
INSERT INTO synonym VALUES(902,2,'Saprolegnia sp. CAL-2011b');
INSERT INTO synonym VALUES(903,2,'Saprolegnia sp. SAP0265');
INSERT INTO synonym VALUES(904,2,'Saprolegnia sp. SAP0267');
INSERT INTO synonym VALUES(905,2,'Saprolegnia cf. ferax VI02389');
INSERT INTO synonym VALUES(906,2,'Saprolegnia cf. ferax VI04808');
INSERT INTO synonym VALUES(907,2,'Saprolegnia sp. VI04818');
INSERT INTO synonym VALUES(908,2,'Saprolegnia sp. SAP0268');
INSERT INTO synonym VALUES(909,2,'Saprolegnia sp. SAP0277');
INSERT INTO synonym VALUES(910,2,'Saprolegnia sp. SAP0284');
INSERT INTO synonym VALUES(911,2,'Saprolegnia sp. SAP0285');
INSERT INTO synonym VALUES(912,2,'Saprolegnia sp. SAP0291');
INSERT INTO synonym VALUES(913,2,'Saprolegnia sp. SAP0382');
INSERT INTO synonym VALUES(914,2,'Saprolegnia sp. SAP0433');
INSERT INTO synonym VALUES(915,2,'Saprolegnia sp. SAP0445');
INSERT INTO synonym VALUES(916,2,'Saprolegnia sp. SAP0446');
INSERT INTO synonym VALUES(917,2,'Saprolegnia sp. SAP0457');
INSERT INTO synonym VALUES(918,2,'Saprolegnia sp. SAP0458');
INSERT INTO synonym VALUES(919,2,'Saprolegnia sp. SAP0470');
INSERT INTO synonym VALUES(920,2,'Saprolegnia sp. SAP0477');
INSERT INTO synonym VALUES(921,2,'Saprolegnia sp. SAP0500');
INSERT INTO synonym VALUES(922,2,'Saprolegnia sp. SAP0533');
INSERT INTO synonym VALUES(923,2,'Saprolegnia sp. SAP0562');
INSERT INTO synonym VALUES(924,2,'Saprolegnia sp. SAP0575');
INSERT INTO synonym VALUES(925,2,'Saprolegnia sp. SAP0580');
INSERT INTO synonym VALUES(926,2,'Saprolegnia sp. SAP0624');
INSERT INTO synonym VALUES(927,2,'Saprolegnia sp. SAP0625');
INSERT INTO synonym VALUES(928,2,'Saprolegnia sp. SAP0626');
INSERT INTO synonym VALUES(929,2,'Saprolegnia sp. SAP0645');
INSERT INTO synonym VALUES(930,2,'Saprolegnia sp. SAP0649');
INSERT INTO synonym VALUES(931,2,'Saprolegnia sp. SAP0653');
INSERT INTO synonym VALUES(932,2,'Saprolegnia sp. SAP0656');
INSERT INTO synonym VALUES(933,2,'Saprolegnia sp. SAP0708');
INSERT INTO synonym VALUES(934,2,'Saprolegnia sp. SAP0709');
INSERT INTO synonym VALUES(935,2,'Saprolegnia sp. SAP0771');
INSERT INTO synonym VALUES(936,2,'Saprolegnia sp. SAP0776');
INSERT INTO synonym VALUES(937,2,'Saprolegnia sp. SAP0781');
INSERT INTO synonym VALUES(938,2,'Saprolegnia sp. SAP0783');
INSERT INTO synonym VALUES(939,2,'Saprolegnia sp. SAP0794');
INSERT INTO synonym VALUES(940,2,'Saprolegnia sp. SAP0808');
INSERT INTO synonym VALUES(941,2,'Saprolegnia sp. SAP0812');
INSERT INTO synonym VALUES(942,2,'Saprolegnia sp. SAP0813');
INSERT INTO synonym VALUES(943,2,'Saprolegnia sp. SAP0819');
INSERT INTO synonym VALUES(944,2,'Saprolegnia sp. SAP0820');
INSERT INTO synonym VALUES(945,2,'Saprolegnia sp. SAP0955');
INSERT INTO synonym VALUES(946,2,'Saprolegnia sp. SAP0956');
INSERT INTO synonym VALUES(947,2,'Saprolegnia sp. SAP0957');
INSERT INTO synonym VALUES(948,2,'Saprolegnia sp. SAP0958');
INSERT INTO synonym VALUES(949,2,'Saprolegnia sp. SAP0829');
INSERT INTO synonym VALUES(950,2,'Saprolegnia sp. SAP0987');
INSERT INTO synonym VALUES(951,2,'Saprolegnia sp. SAP0988');
INSERT INTO synonym VALUES(952,2,'Saprolegnia sp. SAP0992');
INSERT INTO synonym VALUES(953,2,'Saprolegnia sp. SAP0999');
INSERT INTO synonym VALUES(954,2,'Saprolegnia sp. SAP1006');
INSERT INTO synonym VALUES(955,2,'Saprolegnia sp. SAP1008');
INSERT INTO synonym VALUES(956,2,'Saprolegnia sp. SAP0971');
INSERT INTO synonym VALUES(957,2,'Saprolegnia sp. SAP1037');
INSERT INTO synonym VALUES(958,2,'Saprolegnia sp. SAP1088');
INSERT INTO synonym VALUES(959,2,'Saprolegnia sp. SAP1101');
INSERT INTO synonym VALUES(960,2,'Saprolegnia sp. SAP1102');
INSERT INTO synonym VALUES(961,2,'Saprolegnia sp. SAP1028');
INSERT INTO synonym VALUES(962,2,'Saprolegnia sp. SAP1104');
INSERT INTO synonym VALUES(963,2,'Saprolegnia sp. SAP1112');
INSERT INTO synonym VALUES(964,2,'Saprolegnia sp. SAP1124');
INSERT INTO synonym VALUES(965,2,'Saprolegnia sp. SAP1138');
INSERT INTO synonym VALUES(966,2,'Saprolegnia sp. SAP1164');
INSERT INTO synonym VALUES(967,2,'Saprolegnia sp. SAP1165');
INSERT INTO synonym VALUES(968,2,'Saprolegnia sp. SAP1168');
INSERT INTO synonym VALUES(969,2,'Saprolegnia sp. SAP1169');
INSERT INTO synonym VALUES(970,2,'Saprolegnia sp. SAP1185');
INSERT INTO synonym VALUES(971,2,'Saprolegnia sp. SAP1187');
INSERT INTO synonym VALUES(972,2,'Saprolegnia sp. Arg 009');
INSERT INTO synonym VALUES(973,2,'Saprolegnia sp. WM_1');
INSERT INTO synonym VALUES(974,2,'Saprolegnia sp. WM_2');
INSERT INTO synonym VALUES(975,2,'Saprolegnia sp. WM_3');
INSERT INTO synonym VALUES(976,2,'Saprolegnia sp. SAP1209');
INSERT INTO synonym VALUES(977,2,'Saprolegnia sp. SAP1246');
INSERT INTO synonym VALUES(978,2,'Saprolegnia sp. SAP1253');
INSERT INTO synonym VALUES(979,2,'Saprolegnia sp. SAP1261');
INSERT INTO synonym VALUES(980,2,'Saprolegnia sp. SAP1267');
INSERT INTO synonym VALUES(981,2,'Saprolegnia sp. SAP1272');
INSERT INTO synonym VALUES(982,2,'Saprolegnia sp. SAP1302');
INSERT INTO synonym VALUES(983,2,'Saprolegnia sp. SAP1303');
INSERT INTO synonym VALUES(984,2,'Saprolegnia sp. SAP1308');
INSERT INTO synonym VALUES(985,2,'Saprolegnia sp. SAP1309');
INSERT INTO synonym VALUES(986,2,'Saprolegnia sp. SAP1278');
INSERT INTO synonym VALUES(987,2,'Saprolegnia sp. MCA 3030');
INSERT INTO synonym VALUES(988,2,'Saprolegnia sp. MCA 3070');
INSERT INTO synonym VALUES(989,2,'Saprolegnia sp. SAP1315');
INSERT INTO synonym VALUES(990,2,'Saprolegnia sp. SAP1316');
INSERT INTO synonym VALUES(991,2,'Saprolegnia sp. SAP1323');
INSERT INTO synonym VALUES(992,2,'Saprolegnia sp. SAP1326');
INSERT INTO synonym VALUES(993,2,'Saprolegnia sp. SAP1330');
INSERT INTO synonym VALUES(994,2,'Saprolegnia sp. SAP1360');
INSERT INTO synonym VALUES(995,2,'Saprolegnia sp. SAP1370');
INSERT INTO synonym VALUES(996,2,'Saprolegnia sp. SAP1383');
INSERT INTO synonym VALUES(997,2,'Saprolegnia sp. BP-S1');
INSERT INTO synonym VALUES(998,2,'Saprolegnia sp. SAP1424');
INSERT INTO synonym VALUES(999,2,'Saprolegnia sp. SAP1425');
INSERT INTO synonym VALUES(1000,2,'Saprolegnia sp. SAP1436');
INSERT INTO synonym VALUES(1001,2,'Saprolegnia sp. SAP1439');
INSERT INTO synonym VALUES(1002,2,'Saprolegnia sp. SAP1440');
INSERT INTO synonym VALUES(1003,2,'Saprolegnia sp. SAP1441');
INSERT INTO synonym VALUES(1004,2,'Saprolegnia sp. SAP1449');
INSERT INTO synonym VALUES(1005,2,'Saprolegnia sp. SAP1456');
INSERT INTO synonym VALUES(1006,2,'Saprolegnia sp. SAP1459');
INSERT INTO synonym VALUES(1007,2,'Saprolegnia sp. SAP1536');
INSERT INTO synonym VALUES(1008,2,'Saprolegnia sp. SAP1560');
INSERT INTO synonym VALUES(1009,2,'Saprolegnia sp. SAP1550');
INSERT INTO synonym VALUES(1010,2,'Saprolegnia sp. SAP1562');
INSERT INTO synonym VALUES(1011,2,'Saprolegnia sp. SAP1563');
INSERT INTO synonym VALUES(1012,2,'Saprolegnia sp. SAP1570');
INSERT INTO synonym VALUES(1013,2,'Saprolegnia sp. SAP1574');
INSERT INTO synonym VALUES(1014,2,'Saprolegnia sp. SAP1642');
INSERT INTO synonym VALUES(1015,2,'Saprolegnia sp. SAP1693');
INSERT INTO synonym VALUES(1016,2,'Saprolegnia sp. SAP1734');
INSERT INTO synonym VALUES(1017,2,'Saprolegnia sp. SAP1698');
INSERT INTO synonym VALUES(1018,2,'Saprolegnia sp. SAP1823');
INSERT INTO synonym VALUES(1019,2,'Saprolegnia sp. SAP1793');
INSERT INTO synonym VALUES(1020,2,'Saprolegnia sp. SAP1853');
INSERT INTO synonym VALUES(1021,2,'Saprolegnia sp. SAP1872');
INSERT INTO synonym VALUES(1022,2,'Saprolegnia sp. SAP1881');
INSERT INTO synonym VALUES(1023,2,'Saprolegnia sp. SAP1938');
INSERT INTO synonym VALUES(1024,2,'Saprolegnia sp. SAP1950');
INSERT INTO synonym VALUES(1025,2,'Saprolegnia sp. SAP1951');
INSERT INTO synonym VALUES(1026,2,'Saprolegnia sp. SAP1979');
INSERT INTO synonym VALUES(1027,2,'Saprolegnia sp. SAP1975');
INSERT INTO synonym VALUES(1028,2,'Saprolegnia sp. SAP1996');
INSERT INTO synonym VALUES(1029,2,'Saprolegnia sp. SAP1997');
INSERT INTO synonym VALUES(1030,2,'Saprolegnia sp. UNCW372');
INSERT INTO synonym VALUES(1031,2,'Saprolegnia sp. UNCW374');
INSERT INTO synonym VALUES(1032,2,'Saprolegnia sp. UNCW384');
INSERT INTO synonym VALUES(1033,2,'Saprolegnia sp. BF1');
INSERT INTO synonym VALUES(1034,2,'Saprolegnia sp. BMF11');
INSERT INTO synonym VALUES(1035,2,'Saprolegnia sp. BMF12');
INSERT INTO synonym VALUES(1036,2,'Saprolegnia sp. BMF13');
INSERT INTO synonym VALUES(1037,2,'Saprolegnia sp. BMF15');
INSERT INTO synonym VALUES(1038,2,'Saprolegnia sp. BMF16');
INSERT INTO synonym VALUES(1039,2,'Saprolegnia sp. BMF19');
INSERT INTO synonym VALUES(1040,2,'Saprolegnia sp. BMF3');
INSERT INTO synonym VALUES(1041,2,'Saprolegnia sp. BMF4');
INSERT INTO synonym VALUES(1042,2,'Saprolegnia sp. BMF5');
INSERT INTO synonym VALUES(1043,2,'Saprolegnia sp. BMF6');
INSERT INTO synonym VALUES(1044,2,'Saprolegnia sp. BMF7');
INSERT INTO synonym VALUES(1045,2,'Saprolegnia sp. BMF8');
INSERT INTO synonym VALUES(1046,2,'Saprolegnia sp. BMF9');
INSERT INTO synonym VALUES(1047,2,'Saprolegnia sp. BMS11');
INSERT INTO synonym VALUES(1048,2,'Saprolegnia sp. BMS14');
INSERT INTO synonym VALUES(1049,2,'Saprolegnia sp. JY');
INSERT INTO synonym VALUES(1050,2,'Saprolegnia sp. BMY');
INSERT INTO synonym VALUES(1051,2,'Saprolegnia sp. Leka.Manoch');
INSERT INTO synonym VALUES(1052,2,'Saprolegnia sp. II-2');
INSERT INTO synonym VALUES(1053,2,'Saprolegnia sp. LB');
INSERT INTO synonym VALUES(1054,2,'Saprolegnia sp. H-');
INSERT INTO synonym VALUES(1055,2,'Saprolegnia sp. MF-2010');
INSERT INTO synonym VALUES(1056,2,'Saprolegnia sp. 736F2');
INSERT INTO synonym VALUES(1057,2,'Saprolegnia sp. 746F4');
INSERT INTO synonym VALUES(1058,2,'Saprolegnia sp.');
INSERT INTO synonym VALUES(1059,2,'Saprolegnia sp. MNS-2014d');
INSERT INTO synonym VALUES(1060,2,'Saprolegnia sp. HL0602');
INSERT INTO synonym VALUES(1061,2,'Saprolegnia sp. 1 APM-2013');
INSERT INTO synonym VALUES(1062,2,'Saprolegnia sp. LR11');
INSERT INTO synonym VALUES(1063,2,'Saprolegnia sp. LB52');
INSERT INTO synonym VALUES(1064,2,'Saprolegnia sp. MB35/MB13');
INSERT INTO synonym VALUES(1065,2,'Saprolegnia sp. LB26');
INSERT INTO synonym VALUES(1066,2,'Saprolegnia sp. MB70');
INSERT INTO synonym VALUES(1067,2,'Saprolegnia sp. LB39');
INSERT INTO synonym VALUES(1068,2,'Saprolegnia sp. LR2');
INSERT INTO synonym VALUES(1069,2,'Saprolegnia sp. MB12');
INSERT INTO synonym VALUES(1070,2,'Saprolegnia sp. LB46');
INSERT INTO synonym VALUES(1071,2,'Saprolegnia sp. WD18C');
INSERT INTO synonym VALUES(1072,2,'Saprolegnia sp. WD1E');
INSERT INTO synonym VALUES(1073,2,'Saprolegnia sp. WD1G');
INSERT INTO synonym VALUES(1074,2,'Saprolegnia sp. WD1I');
INSERT INTO synonym VALUES(1075,2,'Saprolegnia sp. WD1J');
INSERT INTO synonym VALUES(1076,2,'Saprolegnia sp. UNCW105');
INSERT INTO synonym VALUES(1077,2,'Saprolegnia sp. WD1M');
INSERT INTO synonym VALUES(1078,2,'Saprolegnia sp. UNCW114');
INSERT INTO synonym VALUES(1079,2,'Saprolegnia sp. WD34A');
INSERT INTO synonym VALUES(1080,2,'Saprolegnia sp. WD3A');
INSERT INTO synonym VALUES(1081,2,'Saprolegnia sp. WD3B');
INSERT INTO synonym VALUES(1082,2,'Saprolegnia sp. WD3D');
INSERT INTO synonym VALUES(1083,2,'Saprolegnia sp. WD3E');
INSERT INTO synonym VALUES(1084,2,'Saprolegnia sp. P8205');
INSERT INTO synonym VALUES(1085,2,'Saprolegnia sp. WD3G');
INSERT INTO synonym VALUES(1086,2,'Saprolegnia sp. UNCW162');
INSERT INTO synonym VALUES(1087,2,'Saprolegnia sp. UNCW170');
INSERT INTO synonym VALUES(1088,2,'Saprolegnia sp. UNCW172');
INSERT INTO synonym VALUES(1089,2,'Saprolegnia sp. UNCW176');
INSERT INTO synonym VALUES(1090,2,'Saprolegnia sp. UNCW177');
INSERT INTO synonym VALUES(1091,2,'Saprolegnia sp. UNCW217');
INSERT INTO synonym VALUES(1092,2,'Saprolegnia sp. UNCW218');
INSERT INTO synonym VALUES(1093,2,'Saprolegnia sp. UNCW219');
INSERT INTO synonym VALUES(1094,2,'Saprolegnia sp. UNCW244');
INSERT INTO synonym VALUES(1095,2,'Saprolegnia sp. UNCW250');
INSERT INTO synonym VALUES(1096,2,'Saprolegnia sp. UNCW251');
INSERT INTO synonym VALUES(1097,2,'Saprolegnia sp. UNCW253');
INSERT INTO synonym VALUES(1098,2,'Saprolegnia sp. UNCW254');
INSERT INTO synonym VALUES(1099,2,'Saprolegnia sp. UNCW257');
INSERT INTO synonym VALUES(1100,2,'Saprolegnia sp. UNCW258');
INSERT INTO synonym VALUES(1101,2,'Saprolegnia sp. UNCW259');
INSERT INTO synonym VALUES(1102,2,'Saprolegnia sp. UNCW260');
INSERT INTO synonym VALUES(1103,2,'Saprolegnia sp. UNCW261');
INSERT INTO synonym VALUES(1104,2,'Saprolegnia sp. UNCW263');
INSERT INTO synonym VALUES(1105,2,'Saprolegnia sp. UNCW264');
INSERT INTO synonym VALUES(1106,2,'Saprolegnia sp. UNCW266');
INSERT INTO synonym VALUES(1107,2,'Saprolegnia sp. UNCW269');
INSERT INTO synonym VALUES(1108,2,'Saprolegnia sp. UNCW271');
INSERT INTO synonym VALUES(1109,2,'Saprolegnia sp. UNCW272');
INSERT INTO synonym VALUES(1110,2,'Saprolegnia sp. UNCW273');
INSERT INTO synonym VALUES(1111,2,'Saprolegnia sp. UNCW277');
INSERT INTO synonym VALUES(1112,2,'Saprolegnia sp. UNCW278');
INSERT INTO synonym VALUES(1113,2,'Saprolegnia sp. UNCW280');
INSERT INTO synonym VALUES(1114,2,'Saprolegnia sp. UNCW283');
INSERT INTO synonym VALUES(1115,2,'Saprolegnia sp. UNCW284');
INSERT INTO synonym VALUES(1116,2,'Saprolegnia sp. UNCW285');
INSERT INTO synonym VALUES(1117,2,'Saprolegnia sp. UNCW286');
INSERT INTO synonym VALUES(1118,2,'Saprolegnia sp. UNCW288');
INSERT INTO synonym VALUES(1119,2,'Saprolegnia sp. UNCW289');
INSERT INTO synonym VALUES(1120,2,'Saprolegnia sp. UNCW290');
INSERT INTO synonym VALUES(1121,2,'Saprolegnia sp. UNCW292');
INSERT INTO synonym VALUES(1122,2,'Saprolegnia sp. UNCW295');
INSERT INTO synonym VALUES(1123,2,'Saprolegnia sp. UNCW298');
INSERT INTO synonym VALUES(1124,2,'Saprolegnia sp. UNCW299');
INSERT INTO synonym VALUES(1125,2,'Saprolegnia sp. UNCW312');
INSERT INTO synonym VALUES(1126,2,'Saprolegnia sp. UNCW314');
INSERT INTO synonym VALUES(1127,2,'Saprolegnia sp. UNCW315');
INSERT INTO synonym VALUES(1128,2,'Saprolegnia sp. UNCW316');
INSERT INTO synonym VALUES(1129,2,'Saprolegnia sp. UNCW375');
INSERT INTO synonym VALUES(1130,2,'Saprolegnia sp. UNCW320');
INSERT INTO synonym VALUES(1131,2,'Saprolegnia sp. UNCW328');
INSERT INTO synonym VALUES(1132,2,'Saprolegnia sp. UNCW329');
INSERT INTO synonym VALUES(1133,2,'Saprolegnia sp. UNCW291');
INSERT INTO synonym VALUES(1134,2,'Saprolegnia sp. UNCW300');
INSERT INTO synonym VALUES(1135,2,'Saprolegnia sp. UNCW373');
INSERT INTO synonym VALUES(1136,2,'Saprolegnia sp. UNCW385');
INSERT INTO synonym VALUES(1137,2,'Saprolegnia sp. UNCW386');
INSERT INTO synonym VALUES(1138,2,'Saprolegnia sp. UNCW262');
INSERT INTO synonym VALUES(1139,2,'Saprolegnia sp. UNCW377');
INSERT INTO synonym VALUES(1140,2,'Saprolegnia sp. UNCW380');
INSERT INTO synonym VALUES(1141,2,'Saprolegnia sp. UNCW381');
INSERT INTO synonym VALUES(1142,2,'Saprolegnia sp. UNCW382');
INSERT INTO synonym VALUES(1143,2,'Saprolegnia sp. UNCW383');
INSERT INTO synonym VALUES(1144,2,'Saprolegnia sp. PB-2012');
INSERT INTO synonym VALUES(1145,2,'Saprolegnia sp. 2 JVS-2015');
INSERT INTO synonym VALUES(1146,2,'Saprolegnia sp. 1 JVS-2015');
INSERT INTO synonym VALUES(1147,2,'Saprolegnia sp. W805b');
INSERT INTO synonym VALUES(1148,2,'Saprolegnia sp. HEE-2014-1');
INSERT INTO synonym VALUES(1149,2,'Saprolegnia sp. RACL2005Karraker');
INSERT INTO synonym VALUES(1150,2,'Saprolegnia sp. nuchiae');
INSERT INTO synonym VALUES(1151,2,'Saprolegnia sp. VI03782');
INSERT INTO synonym VALUES(1152,2,'Saprolegnia sp. VI03788');
INSERT INTO synonym VALUES(1153,2,'Saprolegnia sp. VI03796');
INSERT INTO synonym VALUES(1154,2,'Saprolegnia sp. VI03812');
INSERT INTO synonym VALUES(1155,2,'Saprolegnia brachydanionis (nom. inval.)');
INSERT INTO synonym VALUES(1156,2,'Saprolegnia sp. AESB');
INSERT INTO synonym VALUES(1157,2,'Saprolegnia sp. SPE');
INSERT INTO synonym VALUES(1158,2,'Saprolegnia sp. strain 2 (fish)');
INSERT INTO synonym VALUES(1159,2,'Saprolegnia sp. strain 1 (fish eggs)');
INSERT INTO synonym VALUES(1160,2,'Saprolegnia sp. 197907');
INSERT INTO synonym VALUES(1161,2,'Saprolegnia sp. salmon/trout/2012');
INSERT INTO synonym VALUES(1162,2,'Saprolegnia sp. MNS-2014a');
INSERT INTO synonym VALUES(1163,2,'Saprolegnia sp. MNS-2014b');
INSERT INTO synonym VALUES(1164,2,'Saprolegnia sp. MNS-2014c');
INSERT INTO synonym VALUES(1165,2,'Saprolegnia sp. JR-2014a');
INSERT INTO synonym VALUES(1166,2,'Saprolegnia sp. 5 SR-2014');
INSERT INTO synonym VALUES(1167,3,'Bremia sp. UASWS0324');
INSERT INTO synonym VALUES(1168,3,'Bremia sp. UASWS0325');
INSERT INTO synonym VALUES(1169,3,'Bremia sp. UASWS0326');
INSERT INTO synonym VALUES(1170,3,'Bremia sp. ex Leonthodon hispidus');
INSERT INTO synonym VALUES(1171,3,'Bremia sp. ex Arctium sp.');
INSERT INTO synonym VALUES(1172,3,'Bremia sp. ex Carlina acaulis');
INSERT INTO synonym VALUES(1173,3,'Bremia sp. ex Hieracium murorum');
INSERT INTO synonym VALUES(1174,3,'Bremia sp. ex Helichrysum sp.');
INSERT INTO synonym VALUES(1175,3,'Bremia sp. ex Cirsium acaule');
INSERT INTO synonym VALUES(1176,3,'Bremia sp. ex Centaurea jacea');
INSERT INTO synonym VALUES(1177,3,'Bremia sp. YJC-2015');
INSERT INTO synonym VALUES(1178,3,'Bremia sp.');
INSERT INTO synonym VALUES(1179,3,'Bremia sp. YJC-2015b');
INSERT INTO synonym VALUES(1180,3,'Bremia sp. UASWS0322');
INSERT INTO synonym VALUES(1181,3,'Bremia sp. UASWS0323');
INSERT INTO synonym VALUES(1182,4,'Plasmopara sp.');
INSERT INTO synonym VALUES(1183,4,'Plasmopara sp. KUS-F 23331');
INSERT INTO synonym VALUES(1184,4,'Plasmopara sp. KUS-F 23332');
INSERT INTO synonym VALUES(1185,4,'Plasmopara sp. KUS-F 23333');
INSERT INTO synonym VALUES(1186,4,'Plasmopara sp. KUS-F 23334');
INSERT INTO synonym VALUES(1187,4,'Plasmopara sp. KUS-F 23336');
INSERT INTO synonym VALUES(1188,4,'Plasmopara sp. KUS-F 23337');
INSERT INTO synonym VALUES(1189,4,'Plasmopara sp. 1 HV-2013');
INSERT INTO synonym VALUES(1190,4,'Plasmopara sp. HV-2014a');
INSERT INTO synonym VALUES(1191,5,'Phytophthora sp. 1 KS-2013');
INSERT INTO synonym VALUES(1192,5,'Phytophthora sp. NJB-2016a');
INSERT INTO synonym VALUES(1193,5,'Phytophthora sp. P12745');
INSERT INTO synonym VALUES(1194,5,'Phytophthora sp. P12845');
INSERT INTO synonym VALUES(1195,5,'Phytophthora sp. EL_8701');
INSERT INTO synonym VALUES(1196,5,'Phytophthora sp. EL_8703');
INSERT INTO synonym VALUES(1197,5,'Phytophthora sp. EC3414');
INSERT INTO synonym VALUES(1198,5,'Phytophthora sp. KACC40449');
INSERT INTO synonym VALUES(1199,5,'Phytophthora sp. BF1');
INSERT INTO synonym VALUES(1200,5,'Phytophthora sp. BF3');
INSERT INTO synonym VALUES(1201,5,'Phytophthora sp. BF36');
INSERT INTO synonym VALUES(1202,5,'Phytophthora sp. BF4');
INSERT INTO synonym VALUES(1203,5,'Phytophthora sp. BFA');
INSERT INTO synonym VALUES(1204,5,'Phytophthora sp. BFK');
INSERT INTO synonym VALUES(1205,5,'Phytophthora sp. BFR');
INSERT INTO synonym VALUES(1206,5,'Phytophthora sp. BLW71');
INSERT INTO synonym VALUES(1207,5,'Phytophthora sp. MC1A');
INSERT INTO synonym VALUES(1208,5,'Phytophthora sp. MC32');
INSERT INTO synonym VALUES(1209,5,'Phytophthora sp. novaeguinee');
INSERT INTO synonym VALUES(1210,5,'Phytophthora sp. MC5');
INSERT INTO synonym VALUES(1211,5,'Phytophthora sp. MC53');
INSERT INTO synonym VALUES(1212,5,'Phytophthora sp. MCH');
INSERT INTO synonym VALUES(1213,5,'Phytophthora sp. MCO');
INSERT INTO synonym VALUES(1214,5,'Phytophthora sp. TF16');
INSERT INTO synonym VALUES(1215,5,'Phytophthora sp. WA28-022404');
INSERT INTO synonym VALUES(1216,5,'Phytophthora sp. Umtamvuna');
INSERT INTO synonym VALUES(1217,5,'Phytophthora sp. canthium');
INSERT INTO synonym VALUES(1218,5,'Phytophthora sp. emzansi');
INSERT INTO synonym VALUES(1219,5,'Phytophthora sp. EC3090');
INSERT INTO synonym VALUES(1220,5,'Phytophthora sp. EC3094');
INSERT INTO synonym VALUES(1221,5,'Phytophthora sp. EC3099');
INSERT INTO synonym VALUES(1222,5,'Phytophthora sp. EC3154');
INSERT INTO synonym VALUES(1223,5,'Phytophthora sp. EC3199');
INSERT INTO synonym VALUES(1224,5,'Phytophthora sp. EC3237');
INSERT INTO synonym VALUES(1225,5,'Phytophthora sp. EC3238');
INSERT INTO synonym VALUES(1226,5,'Phytophthora sp. EC3240');
INSERT INTO synonym VALUES(1227,5,'Phytophthora sp. EC3253');
INSERT INTO synonym VALUES(1228,5,'Phytophthora sp. EC3300');
INSERT INTO synonym VALUES(1229,5,'Phytophthora sp. EC3308');
INSERT INTO synonym VALUES(1230,5,'Phytophthora sp. EC3309');
INSERT INTO synonym VALUES(1231,5,'Phytophthora sp. EC3310');
INSERT INTO synonym VALUES(1232,5,'Phytophthora sp. EC3330');
INSERT INTO synonym VALUES(1233,5,'Phytophthora sp. EC3331');
INSERT INTO synonym VALUES(1234,5,'Phytophthora sp. EC3335');
INSERT INTO synonym VALUES(1235,5,'Phytophthora sp. EC3336');
INSERT INTO synonym VALUES(1236,5,'Phytophthora sp. EC3364');
INSERT INTO synonym VALUES(1237,5,'Phytophthora sp. EC3394');
INSERT INTO synonym VALUES(1238,5,'Phytophthora sp. EC3449');
INSERT INTO synonym VALUES(1239,5,'Phytophthora sp. hybrid type 1');
INSERT INTO synonym VALUES(1240,5,'Phytophthora sp. hybrid type 2');
INSERT INTO synonym VALUES(1241,5,'Phytophthora sp. hybrid type 3');
INSERT INTO synonym VALUES(1242,5,'Phytophthora sp. hybrid VHS2713');
INSERT INTO synonym VALUES(1243,5,'Phytophthora sp. x amnicola');
INSERT INTO synonym VALUES(1244,5,'Phytophthora sp. WH-2012');
INSERT INTO synonym VALUES(1245,5,'Phytophthora sp. MN 23');
INSERT INTO synonym VALUES(1246,5,'Phytophthora sp. NJB-2015');
INSERT INTO synonym VALUES(1247,5,'Phytophthora sp. forestsoil-like');
INSERT INTO synonym VALUES(1248,5,'Phytophthora sp. occultans-like');
INSERT INTO synonym VALUES(1249,5,'Phytophthora sp. x Kunnunara-like');
INSERT INTO synonym VALUES(1250,5,'Phytophthora sp. x botryosa-like');
INSERT INTO synonym VALUES(1251,5,'Phytophthora sp. x insolita-like');
INSERT INTO synonym VALUES(1252,5,'Phytophthora sp. x meadii-like');
INSERT INTO synonym VALUES(1253,5,'Phytophthora sp. x virginiana-like-1');
INSERT INTO synonym VALUES(1254,5,'Phytophthora sp. x virginiana-like-2');
INSERT INTO synonym VALUES(1255,5,'Phytophthora sp. x virginiana-like-3');
INSERT INTO synonym VALUES(1256,5,'Phytophthora sp. bitahaiensis');
INSERT INTO synonym VALUES(1257,5,'Phytophthora sp. nixiensis');
INSERT INTO synonym VALUES(1258,5,'Phytophthora taxon Pgchlamydo');
INSERT INTO synonym VALUES(1259,5,'Phytophthora sp. SUC654');
INSERT INTO synonym VALUES(1260,5,'Phytophthora sp. ''germisporangia''');
INSERT INTO synonym VALUES(1261,5,'Phytophthora sp. ''awatangi''');
INSERT INTO synonym VALUES(1262,5,'Phytophthora sp. 2 ROH-2015');
INSERT INTO synonym VALUES(1263,5,'Phytophthora sp. isolate 1410');
INSERT INTO synonym VALUES(1264,5,'Phytophthora sp. VHSC13615');
INSERT INTO synonym VALUES(1265,5,'Phytophthora sp. VHSC13713');
INSERT INTO synonym VALUES(1266,5,'Phytophthora sp. UQ2141');
INSERT INTO synonym VALUES(1267,5,'Phytophthora taxon walnut');
INSERT INTO synonym VALUES(1268,5,'Phytophthora taxon forestsoil');
INSERT INTO synonym VALUES(1269,5,'uncultured Phytophthora');
INSERT INTO synonym VALUES(1270,5,'Phytophthora cf. capsici FM-2011');
INSERT INTO synonym VALUES(1271,5,'Phytophthora cf. citricola 1 FM-2011');
INSERT INTO synonym VALUES(1272,5,'Phytophthora cf. citrophthora 1a FM-2011');
INSERT INTO synonym VALUES(1273,5,'Phytophthora cf. citrophthora 1b FM-2011');
INSERT INTO synonym VALUES(1274,5,'Phytophthora cf. citrophthora 2 FM-2011');
INSERT INTO synonym VALUES(1275,5,'Phytophthora cf. cryptogea 2 FM-2011');
INSERT INTO synonym VALUES(1276,5,'Phytophthora cf. cryptogea FM-2011');
INSERT INTO synonym VALUES(1277,5,'Phytophthora cf. heveae 2 FM-2011');
INSERT INTO synonym VALUES(1278,5,'Phytophthora cf. heveae 1 FM-2011');
INSERT INTO synonym VALUES(1279,5,'Phytophthora cf. meadii 1 FM-2011');
INSERT INTO synonym VALUES(1280,5,'Phytophthora cf. porri 1 FM-2011');
INSERT INTO synonym VALUES(1281,5,'Phytophthora cf. porri 2 FM-2011');
INSERT INTO synonym VALUES(1282,5,'Phytophthora cf. citricola 2 FM-2011');
INSERT INTO synonym VALUES(1283,5,'Phytophthora sp. FM-2012');
INSERT INTO synonym VALUES(1284,5,'Phytophthora sp. TARI 29352');
INSERT INTO synonym VALUES(1285,5,'Phytophthora sp. Ph1');
INSERT INTO synonym VALUES(1286,5,'Phytophthora sp. Spathiphyllum');
INSERT INTO synonym VALUES(1287,5,'Phytophthora sp. ''rasp tasm''');
INSERT INTO synonym VALUES(1288,5,'Phytophthora sp. GUCC0313');
INSERT INTO synonym VALUES(1289,5,'Phytophthora sp. ''cadmea''');
INSERT INTO synonym VALUES(1290,5,'Phytophthora sp. ''juncus''');
INSERT INTO synonym VALUES(1291,5,'Phytophthora sp. 1 EEO-2011');
INSERT INTO synonym VALUES(1292,5,'Phytophthora sp. PS1');
INSERT INTO synonym VALUES(1293,5,'Phytophthora sp. PS10');
INSERT INTO synonym VALUES(1294,5,'Phytophthora taxon banihashemiana');
INSERT INTO synonym VALUES(1295,5,'Phytophthora sp. PS2');
INSERT INTO synonym VALUES(1296,5,'Phytophthora sp. PS3');
INSERT INTO synonym VALUES(1297,5,'Phytophthora sp. PS4');
INSERT INTO synonym VALUES(1298,5,'Phytophthora sp. PS5');
INSERT INTO synonym VALUES(1299,5,'Phytophthora sp. PS6');
INSERT INTO synonym VALUES(1300,5,'Phytophthora sp. PS7');
INSERT INTO synonym VALUES(1301,5,'Phytophthora sp. PS8');
INSERT INTO synonym VALUES(1302,5,'Phytophthora sp. PS9');
INSERT INTO synonym VALUES(1303,5,'Phytophthora sp. ex Drimys winteri');
INSERT INTO synonym VALUES(1304,5,'Phytophthora sp. SCRP1086');
INSERT INTO synonym VALUES(1305,5,'Phytophthora sp. SCRP1087');
INSERT INTO synonym VALUES(1306,5,'Phytophthora sp. SCRP1088');
INSERT INTO synonym VALUES(1307,5,'Phytophthora sp. SP1');
INSERT INTO synonym VALUES(1308,5,'Phytophthora sp. SP4');
INSERT INTO synonym VALUES(1309,5,'Phytophthora sp. SP9');
INSERT INTO synonym VALUES(1310,5,'Phytophthora sp. SUC605');
INSERT INTO synonym VALUES(1311,5,'Phytophthora sp. 77-231');
INSERT INTO synonym VALUES(1312,5,'Phytophthora sp. SUC606');
INSERT INTO synonym VALUES(1313,5,'Phytophthora sp. SUC607');
INSERT INTO synonym VALUES(1314,5,'Phytophthora sp. 3 EEO-2011');
INSERT INTO synonym VALUES(1315,5,'Phytophthora sp. 2 EEO-2011');
INSERT INTO synonym VALUES(1316,5,'Phytophthora sp. SUC608');
INSERT INTO synonym VALUES(1317,5,'Phytophthora sp. SUC614');
INSERT INTO synonym VALUES(1318,5,'Phytophthora sp. SUC615');
INSERT INTO synonym VALUES(1319,5,'Phytophthora sp. SUC616');
INSERT INTO synonym VALUES(1320,5,'Phytophthora sp. SUC617');
INSERT INTO synonym VALUES(1321,5,'Phytophthora sp. SUC619');
INSERT INTO synonym VALUES(1322,5,'Phytophthora sp. SUC622');
INSERT INTO synonym VALUES(1323,5,'Phytophthora sp. SUC623');
INSERT INTO synonym VALUES(1324,5,'Phytophthora sp. SUC626');
INSERT INTO synonym VALUES(1325,5,'Phytophthora sp. SUC627');
INSERT INTO synonym VALUES(1326,5,'Phytophthora sp. SUC628');
INSERT INTO synonym VALUES(1327,5,'Phytophthora sp. SUC630');
INSERT INTO synonym VALUES(1328,5,'Phytophthora sp. SUC636');
INSERT INTO synonym VALUES(1329,5,'Phytophthora sp. SUC641');
INSERT INTO synonym VALUES(1330,5,'Phytophthora sp. P1049');
INSERT INTO synonym VALUES(1331,5,'Phytophthora sp. LMQO-2010');
INSERT INTO synonym VALUES(1332,5,'Phytophthora sp. P510');
INSERT INTO synonym VALUES(1333,5,'Phytophthora sp. P896');
INSERT INTO synonym VALUES(1334,5,'Phytophthora sp. WAC6627');
INSERT INTO synonym VALUES(1335,5,'Phytophthora sp. P1054');
INSERT INTO synonym VALUES(1336,5,'Phytophthora sp. P1055');
INSERT INTO synonym VALUES(1337,5,'Phytophthora sp. P1056');
INSERT INTO synonym VALUES(1338,5,'Phytophthora sp. P1050');
INSERT INTO synonym VALUES(1339,5,'Phytophthora sp. P1044');
INSERT INTO synonym VALUES(1340,5,'Phytophthora sp. P532');
INSERT INTO synonym VALUES(1341,5,'Phytophthora sp. cc2124');
INSERT INTO synonym VALUES(1342,5,'Phytophthora sp. cc2286');
INSERT INTO synonym VALUES(1343,5,'Phytophthora sp. cc2300');
INSERT INTO synonym VALUES(1344,5,'Phytophthora sp. cc2378');
INSERT INTO synonym VALUES(1345,5,'Phytophthora sp. WV BSC');
INSERT INTO synonym VALUES(1346,5,'Phytophthora taxon Pgchlamydo x Phytophthora amnicola');
INSERT INTO synonym VALUES(1347,5,'Phytophthora thermophila x Phytophthora taxon Pgchlamydo');
INSERT INTO synonym VALUES(1348,5,'Phytophthora sp. NJB-2014');
INSERT INTO synonym VALUES(1349,5,'Phytophthora sp. zentmyerii');
INSERT INTO synonym VALUES(1350,5,'Phytophthora taxon totara');
INSERT INTO synonym VALUES(1351,5,'Phytophthora sp. 91-112');
INSERT INTO synonym VALUES(1352,5,'Phytophthora sp. ICMP 16471');
INSERT INTO synonym VALUES(1353,5,'Phytophthora sp. P8485');
INSERT INTO synonym VALUES(1354,5,'Phytophthora sp. TTB-2010');
INSERT INTO synonym VALUES(1355,5,'Phytophthora sp. emzansi/CCB-2010');
INSERT INTO synonym VALUES(1356,5,'Phytophthora sp. ripicola');
INSERT INTO synonym VALUES(1357,5,'Phytophthora sp. 1 TIB-2013');
INSERT INTO synonym VALUES(1358,5,'Phytophthora sp. B089');
INSERT INTO synonym VALUES(1359,5,'Phytophthora sp. B101');
INSERT INTO synonym VALUES(1360,5,'Phytophthora sp. B106');
INSERT INTO synonym VALUES(1361,5,'Phytophthora sp. B163');
INSERT INTO synonym VALUES(1362,5,'Phytophthora sp. 2_WS');
INSERT INTO synonym VALUES(1363,5,'Phytophthora sp. Hennops river');
INSERT INTO synonym VALUES(1364,5,'Phytophthora sp. P13803');
INSERT INTO synonym VALUES(1365,5,'Phytophthora sp. P16853');
INSERT INTO synonym VALUES(1366,5,'Phytophthora sp. P16911');
INSERT INTO synonym VALUES(1367,5,'Phytophthora sp. P3132');
INSERT INTO synonym VALUES(1368,5,'Phytophthora sp. 11652');
INSERT INTO synonym VALUES(1369,5,'Phytophthora sp. Banksia/Lancelin/AUS');
INSERT INTO synonym VALUES(1370,5,'Phytophthora sp. AL78');
INSERT INTO synonym VALUES(1371,5,'Phytophthora sp. WAMItV-2012');
INSERT INTO synonym VALUES(1372,5,'Phytophthora sp. thermophilum');
INSERT INTO synonym VALUES(1373,5,'Phytophthora sp. napoensis');
INSERT INTO synonym VALUES(1374,5,'Phytophthora sp. CJL-2014');
INSERT INTO synonym VALUES(1375,5,'Phytophthora sp. CAL-2011b');
INSERT INTO synonym VALUES(1376,5,'Phytophthora sp. 458');
INSERT INTO synonym VALUES(1377,5,'Phytophthora sp. Ps-56');
INSERT INTO synonym VALUES(1378,5,'Phytophthora sp. Ps-57');
INSERT INTO synonym VALUES(1379,5,'Phytophthora sp. Ps-63');
INSERT INTO synonym VALUES(1380,5,'Phytophthora sp. Ps-7');
INSERT INTO synonym VALUES(1381,5,'Phytophthora sp. CMR-2020');
INSERT INTO synonym VALUES(1382,5,'Phytophthora sp. unk1');
INSERT INTO synonym VALUES(1383,5,'Phytophthora sp. unk2');
INSERT INTO synonym VALUES(1384,5,'Phytophthora sp. unk3');
INSERT INTO synonym VALUES(1385,5,'Phytophthora sp. AL-2010a');
INSERT INTO synonym VALUES(1386,5,'Phytophthora sp. AL-2010b');
INSERT INTO synonym VALUES(1387,5,'Phytophthora sp. 1 FFL-2008');
INSERT INTO synonym VALUES(1388,5,'Phytophthora sp. 2 FFL-2008');
INSERT INTO synonym VALUES(1389,5,'Phytophthora sp. 4 FFL-2008');
INSERT INTO synonym VALUES(1390,5,'Phytophthora sp. CH-2012');
INSERT INTO synonym VALUES(1391,5,'Phytophthora sp. 160_1670-11');
INSERT INTO synonym VALUES(1392,5,'Phytophthora sp. 58_MC-38');
INSERT INTO synonym VALUES(1393,5,'Phytophthora sp. BLW NRA');
INSERT INTO synonym VALUES(1394,5,'Phytophthora sp. 1670-08');
INSERT INTO synonym VALUES(1395,5,'Phytophthora sp. 1670-11');
INSERT INTO synonym VALUES(1396,5,'Phytophthora sp. ST18-37');
INSERT INTO synonym VALUES(1397,5,'Phytophthora sp. WM-2018a');
INSERT INTO synonym VALUES(1398,5,'Phytophthora sp. CH98ASP051');
INSERT INTO synonym VALUES(1399,5,'Phytophthora sp. CH98ASP061');
INSERT INTO synonym VALUES(1400,5,'Phytophthora sp. CH98ASP063');
INSERT INTO synonym VALUES(1401,5,'Phytophthora sp. CH98ASP069');
INSERT INTO synonym VALUES(1402,5,'Phytophthora sp. PR12-475');
INSERT INTO synonym VALUES(1403,5,'Phytophthora sp. PR13-109');
INSERT INTO synonym VALUES(1404,5,'Phytophthora cf. Peru 4');
INSERT INTO synonym VALUES(1405,5,'Phytophthora cf. Kunnunara');
INSERT INTO synonym VALUES(1406,5,'Phytophthora sp. MAFF237500');
INSERT INTO synonym VALUES(1407,5,'Phytophthora ohioensis (nom. inval.)');
INSERT INTO synonym VALUES(1408,5,'Phytophthora sp. Asparagus 117');
INSERT INTO synonym VALUES(1409,5,'Phytophthora sp. Asparagus 287');
INSERT INTO synonym VALUES(1410,5,'Phytophthora sp. P16825');
INSERT INTO synonym VALUES(1411,5,'Phytophthora sp. SY1982');
INSERT INTO synonym VALUES(1412,5,'Phytophthora sp. P10080');
INSERT INTO synonym VALUES(1413,5,'Phytophthora sp. P10335');
INSERT INTO synonym VALUES(1414,5,'Phytophthora sp. P10442');
INSERT INTO synonym VALUES(1415,5,'Phytophthora sp. P10456');
INSERT INTO synonym VALUES(1416,5,'Phytophthora sp. P10679');
INSERT INTO synonym VALUES(1417,5,'Phytophthora sp. P1679');
INSERT INTO synonym VALUES(1418,5,'Phytophthora sp. P1825');
INSERT INTO synonym VALUES(1419,5,'Phytophthora sp. P3007');
INSERT INTO synonym VALUES(1420,5,'Phytophthora sp. P3103');
INSERT INTO synonym VALUES(1421,5,'Phytophthora sp. P7491');
INSERT INTO synonym VALUES(1422,5,'Phytophthora sp. P8480');
INSERT INTO synonym VALUES(1423,5,'Phytophthora sp. PDA576');
INSERT INTO synonym VALUES(1424,5,'Phytophthora sp. cuyabensis');
INSERT INTO synonym VALUES(1425,5,'Phytophthora sp. PDA984');
INSERT INTO synonym VALUES(1426,5,'Phytophthora sp. TARI 27147');
INSERT INTO synonym VALUES(1427,5,'Phytophthora sp. TARI 28041');
INSERT INTO synonym VALUES(1428,5,'Phytophthora sp. VPRI 22561');
INSERT INTO synonym VALUES(1429,5,'Phytophthora sp. VPRI 30465');
INSERT INTO synonym VALUES(1430,5,'Phytophthora sp. VPRI 32027');
INSERT INTO synonym VALUES(1431,5,'Phytophthora sp. VPRI 32085');
INSERT INTO synonym VALUES(1432,5,'Phytophthora sp. VPRI 20622');
INSERT INTO synonym VALUES(1433,5,'Phytophthora sp. VPRI 32025');
INSERT INTO synonym VALUES(1434,5,'Phytophthora sp. VPRI 32026');
INSERT INTO synonym VALUES(1435,5,'Phytophthora sp. AL-2010d');
INSERT INTO synonym VALUES(1436,5,'Phytophthora sp. AL-2010c');
INSERT INTO synonym VALUES(1437,5,'Phytophthora sp. AL-2010e');
INSERT INTO synonym VALUES(1438,5,'Phytophthora sp. EBK-2013');
INSERT INTO synonym VALUES(1439,5,'Phytophthora sp. KACC 40914');
INSERT INTO synonym VALUES(1440,5,'Phytophthora sp. JP1');
INSERT INTO synonym VALUES(1441,5,'Phytophthora sp. JP2');
INSERT INTO synonym VALUES(1442,5,'Phytophthora sp. JP3');
INSERT INTO synonym VALUES(1443,5,'Phytophthora sp. JP4');
INSERT INTO synonym VALUES(1444,5,'Phytophthora sp. JP5');
INSERT INTO synonym VALUES(1445,5,'Phytophthora sp. JP6');
INSERT INTO synonym VALUES(1446,5,'Phytophthora sp. JP7');
INSERT INTO synonym VALUES(1447,5,'Phytophthora sp. AUS2D');
INSERT INTO synonym VALUES(1448,5,'Phytophthora taxon juncus');
INSERT INTO synonym VALUES(1449,5,'Phytophthora sp. ''guadalupesoil''');
INSERT INTO synonym VALUES(1450,5,'Phytophthora sp. PNG2A');
INSERT INTO synonym VALUES(1451,5,'Phytophthora sp. PNG2B');
INSERT INTO synonym VALUES(1452,5,'Phytophthora sp. VTN2A');
INSERT INTO synonym VALUES(1453,5,'Phytophthora sp. VTN2B');
INSERT INTO synonym VALUES(1454,5,'Phytophthora sp. VHS16115');
INSERT INTO synonym VALUES(1455,5,'Phytophthora sp. VHS17779');
INSERT INTO synonym VALUES(1456,5,'Phytophthora sp. VHS5185');
INSERT INTO synonym VALUES(1457,5,'Phytophthora sp. CH14NA1');
INSERT INTO synonym VALUES(1458,5,'Phytophthora sp. CH14NB1');
INSERT INTO synonym VALUES(1459,5,'Phytophthora sp. FS08ASP1');
INSERT INTO synonym VALUES(1460,5,'Phytophthora sp. Marion-2012');
INSERT INTO synonym VALUES(1461,5,'Phytophthora sp. isolate SCRP233');
INSERT INTO synonym VALUES(1462,5,'Phytophthora sp. citIX');
INSERT INTO synonym VALUES(1463,5,'Phytophthora sp. IP-2015');
INSERT INTO synonym VALUES(1464,5,'Phytophthora sp. ''x 4''');
INSERT INTO synonym VALUES(1465,5,'Phytophthora sp. CAL-2011a');
INSERT INTO synonym VALUES(1466,5,'Phytophthora sp. SH-2011');
INSERT INTO synonym VALUES(1467,5,'Phytophthora sp. LS-2018a');
INSERT INTO synonym VALUES(1468,5,'Phytophthora sp. neb 1543');
INSERT INTO synonym VALUES(1469,5,'Phytophthora sp. PV-29');
INSERT INTO synonym VALUES(1470,5,'Phytophthora sp. PV-47');
INSERT INTO synonym VALUES(1471,5,'Phytophthora taxon Buxus');
INSERT INTO synonym VALUES(1472,5,'Phytophthora sp. LS-2018b');
INSERT INTO synonym VALUES(1473,5,'Phytophthora sp. LS-2018c');
INSERT INTO synonym VALUES(1474,5,'Phytophthora sp. AUS-10A');
INSERT INTO synonym VALUES(1475,5,'Phytophthora sp. AUS-1A');
INSERT INTO synonym VALUES(1476,5,'Phytophthora sp. ''mugwort''');
INSERT INTO synonym VALUES(1477,5,'Phytophthora sp. AUS-1B');
INSERT INTO synonym VALUES(1478,5,'Phytophthora sp. AUS-1C');
INSERT INTO synonym VALUES(1479,5,'Phytophthora sp. AUS-1D');
INSERT INTO synonym VALUES(1480,5,'Phytophthora cf. sp. sylvatica 2');
INSERT INTO synonym VALUES(1481,5,'Phytophthora cf. sp. sylvatica 3');
INSERT INTO synonym VALUES(1482,5,'Phytophthora sp. AUS-2A');
INSERT INTO synonym VALUES(1483,5,'Phytophthora cf. sp. bitahaiensis');
INSERT INTO synonym VALUES(1484,5,'Phytophthora cf. sp. sylvatica 1');
INSERT INTO synonym VALUES(1485,5,'Phytophthora sp. AUS-2B');
INSERT INTO synonym VALUES(1486,5,'Phytophthora sp. AUS-3A');
INSERT INTO synonym VALUES(1487,5,'Phytophthora sp. AUS-5A');
INSERT INTO synonym VALUES(1488,5,'Phytophthora sp. AUS-6A');
INSERT INTO synonym VALUES(1489,5,'Phytophthora cf. ''kelmania''');
INSERT INTO synonym VALUES(1490,5,'Phytophthora sp. AUS-6B');
INSERT INTO synonym VALUES(1491,5,'Phytophthora sp. AUS-6C');
INSERT INTO synonym VALUES(1492,5,'Phytophthora sp. P8618');
INSERT INTO synonym VALUES(1493,5,'Phytophthora sp. P8619');
INSERT INTO synonym VALUES(1494,5,'Phytophthora sp. ''personii''');
INSERT INTO synonym VALUES(1495,5,'Phytophthora sp. P11555');
INSERT INTO synonym VALUES(1496,5,'Phytophthora sp. P10417');
INSERT INTO synonym VALUES(1497,5,'Phytophthora sp. P10672');
INSERT INTO synonym VALUES(1498,5,'Phytophthora sp. P47');
INSERT INTO synonym VALUES(1499,5,'Phytophthora sp. P51');
INSERT INTO synonym VALUES(1500,5,'Phytophthora sp. P61');
INSERT INTO synonym VALUES(1501,5,'Phytophthora sp. P79 (BO-15)');
INSERT INTO synonym VALUES(1502,5,'Phytophthora sp. P10090');
INSERT INTO synonym VALUES(1503,5,'Phytophthora sp. P82 (B13A)');
INSERT INTO synonym VALUES(1504,5,'Phytophthora sp. P14');
INSERT INTO synonym VALUES(1505,5,'Phytophthora sp. P31');
INSERT INTO synonym VALUES(1506,5,'Phytophthora sp. P32');
INSERT INTO synonym VALUES(1507,5,'Phytophthora sp. P34');
INSERT INTO synonym VALUES(1508,5,'Phytophthora sp. P6875');
INSERT INTO synonym VALUES(1509,5,'Phytophthora sp. P10690');
INSERT INTO synonym VALUES(1510,5,'Phytophthora sp. P10705');
INSERT INTO synonym VALUES(1511,5,'Phytophthora sp. IBL/2011/5/1/1');
INSERT INTO synonym VALUES(1512,5,'Phytophthora sp. IBL/2012/7');
INSERT INTO synonym VALUES(1513,5,'Phytophthora sp. AUS-9A');
INSERT INTO synonym VALUES(1514,5,'Phytophthora sp. AUS-9B');
INSERT INTO synonym VALUES(1515,5,'Phytophthora sp. ''hedraiandra-related1''');
INSERT INTO synonym VALUES(1516,5,'Phytophthora sp. ''hedraiandra-related2''');
INSERT INTO synonym VALUES(1517,5,'Phytophthora sp. AUS-9C');
INSERT INTO synonym VALUES(1518,5,'Phytophthora aff. porri x Phytophthora sp. ''parsley''');
INSERT INTO synonym VALUES(1519,5,'Phytophthora sp. ''novaeguineae''');
INSERT INTO synonym VALUES(1520,5,'Phytophthora sp. ''Peru4-related''');
INSERT INTO synonym VALUES(1521,5,'Phytophthora sp. AUS-9D');
INSERT INTO synonym VALUES(1522,5,'Phytophthora sp. stellaris');
INSERT INTO synonym VALUES(1523,5,'Phytophthora sp. ''x Hennops-related''');
INSERT INTO synonym VALUES(1524,5,'Phytophthora sp. ''citrophthora 1 KP-2019''');
INSERT INTO synonym VALUES(1525,5,'Phytophthora sp. ''citrophthora 2 KP-2019''');
INSERT INTO synonym VALUES(1526,5,'Phytophthora sp. AUS-9E');
INSERT INTO synonym VALUES(1527,5,'Phytophthora sp. xHennops');
INSERT INTO synonym VALUES(1528,5,'Phytophthora sp. ''citrophthora-related1''');
INSERT INTO synonym VALUES(1529,5,'Phytophthora sp. ''citrophthora-related2''');
INSERT INTO synonym VALUES(1530,5,'Phytophthora hedraiandra x Phytophthora sp. ''hedraiandra 1-KP-2019''');
INSERT INTO synonym VALUES(1531,5,'Phytophthora sp. xWS');
INSERT INTO synonym VALUES(1532,5,'Phytophthora sp. P28');
INSERT INTO synonym VALUES(1533,5,'Phytophthora sp. KPh2010_1_1');
INSERT INTO synonym VALUES(1534,5,'Phytophthora sp. KPh2010_3_2');
INSERT INTO synonym VALUES(1535,5,'Phytophthora sp. KPh2010_4_1');
INSERT INTO synonym VALUES(1536,5,'Phytophthora sp. KPh2011_1_1');
INSERT INTO synonym VALUES(1537,5,'Phytophthora sp. KPh2013_1_1');
INSERT INTO synonym VALUES(1538,5,'Phytophthora sp. KPh2013_2_1');
INSERT INTO synonym VALUES(1539,5,'Phytophthora sp. KPh2013_3_2');
INSERT INTO synonym VALUES(1540,5,'Phytophthora sp. KPh2013_4_1');
INSERT INTO synonym VALUES(1541,5,'Phytophthora sp. SW08');
INSERT INTO synonym VALUES(1542,5,'Phytophthora sp. SW09');
INSERT INTO synonym VALUES(1543,5,'Phytophthora sp. SWKA');
INSERT INTO synonym VALUES(1544,5,'Phytophthora sp. MZ09');
INSERT INTO synonym VALUES(1545,5,'Phytophthora sp. KM09');
INSERT INTO synonym VALUES(1546,5,'Phytophthora sp. YZ09');
INSERT INTO synonym VALUES(1547,5,'Phytophthora sp. HK09');
INSERT INTO synonym VALUES(1548,5,'Phytophthora sp. P1200');
INSERT INTO synonym VALUES(1549,5,'Phytophthora sp. FM-2011');
INSERT INTO synonym VALUES(1550,5,'Phytophthora sp. ''aureomontensis''');
INSERT INTO synonym VALUES(1551,5,'Phytophthora sp. AG43');
INSERT INTO synonym VALUES(1552,5,'Phytophthora sp. AG52');
INSERT INTO synonym VALUES(1553,5,'Phytophthora sp. AG34');
INSERT INTO synonym VALUES(1554,5,'Phytophthora sp. P1896');
INSERT INTO synonym VALUES(1555,5,'Phytophthora sp. P8222');
INSERT INTO synonym VALUES(1556,5,'Phytophthora sp. P8225');
INSERT INTO synonym VALUES(1557,5,'Phytophthora sp. P8226');
INSERT INTO synonym VALUES(1558,5,'Phytophthora sp. P8227');
INSERT INTO synonym VALUES(1559,5,'Phytophthora sp. P8228');
INSERT INTO synonym VALUES(1560,5,'Phytophthora sp. P8229');
INSERT INTO synonym VALUES(1561,5,'Phytophthora sp. P8233');
INSERT INTO synonym VALUES(1562,5,'Phytophthora aff. meadii isolate Pr3');
INSERT INTO synonym VALUES(1563,5,'Phytophthora sp. MN14d');
INSERT INTO synonym VALUES(1564,5,'Phytophthora sp.');
INSERT INTO synonym VALUES(1565,5,'Phytophthora sp. CL8');
INSERT INTO synonym VALUES(1566,5,'Phytophthora sp. SKS-2017');
INSERT INTO synonym VALUES(1567,5,'Phytophthora sp. CL9-1');
INSERT INTO synonym VALUES(1568,5,'Phytophthora sp. 2 FFL-2010');
INSERT INTO synonym VALUES(1569,5,'Phytophthora sp. raspberry/TIB-2010');
INSERT INTO synonym VALUES(1570,5,'Phytophthora sp. AUS-8C');
INSERT INTO synonym VALUES(1571,5,'Phytophthora sp. taxon castitis');
INSERT INTO synonym VALUES(1572,5,'Phytophthora sp. taxon parsley');
INSERT INTO synonym VALUES(1573,5,'Phytophthora sp. P8213');
INSERT INTO synonym VALUES(1574,5,'Phytophthora sp. LT');
INSERT INTO synonym VALUES(1575,5,'Phytophthora taxon hungarica');
INSERT INTO synonym VALUES(1576,5,'Phytophthora sp. sylvatica');
INSERT INTO synonym VALUES(1577,5,'Phytophthora sp. 2 TIB-2013');
INSERT INTO synonym VALUES(1578,5,'Phytophthora sp. PNS-2014');
INSERT INTO synonym VALUES(1579,5,'Phytophthora sp. Costa Rica 1');
INSERT INTO synonym VALUES(1580,5,'Phytophthora sp. Costa Rica 11');
INSERT INTO synonym VALUES(1581,5,'Phytophthora sp. Costa Rica 3');
INSERT INTO synonym VALUES(1582,5,'Phytophthora sp. Costa Rica 5');
INSERT INTO synonym VALUES(1583,5,'Phytophthora sp. Costa Rica 8');
INSERT INTO synonym VALUES(1584,5,'Phytophthora sp. REB326-69');
INSERT INTO synonym VALUES(1585,5,'Phytophthora sp. CH-2008b');
INSERT INTO synonym VALUES(1586,5,'Phytophthora sp. CH-2008c');
INSERT INTO synonym VALUES(1587,5,'Phytophthora sp. REB327-68');
INSERT INTO synonym VALUES(1588,5,'Phytophthora sp. REB327-73');
INSERT INTO synonym VALUES(1589,5,'Phytophthora sp. ICMP 18407');
INSERT INTO synonym VALUES(1590,5,'Phytophthora sp. Grenada 1');
INSERT INTO synonym VALUES(1591,5,'Phytophthora sp. Grenada 2');
INSERT INTO synonym VALUES(1592,5,'Phytophthora sp. Grenada 3');
INSERT INTO synonym VALUES(1593,5,'Phytophthora sp. Maryland 1');
INSERT INTO synonym VALUES(1594,5,'Phytophthora sp. Maryland 2');
INSERT INTO synonym VALUES(1595,5,'Phytophthora sp. Maryland 4');
INSERT INTO synonym VALUES(1596,5,'Phytophthora sp. Maryland 5');
INSERT INTO synonym VALUES(1597,5,'Phytophthora sp. Maryland 6');
INSERT INTO synonym VALUES(1598,5,'Phytophthora sp. Maryland 7');
INSERT INTO synonym VALUES(1599,5,'Phytophthora sp. Maryland 8');
INSERT INTO synonym VALUES(1600,5,'Phytophthora sp. Maryland 9');
INSERT INTO synonym VALUES(1601,5,'Phytophthora sp. Peru 1');
INSERT INTO synonym VALUES(1602,5,'Phytophthora sp. Peru 3');
INSERT INTO synonym VALUES(1603,5,'Phytophthora sp. Peru 4');
INSERT INTO synonym VALUES(1604,5,'Phytophthora sp. Taxodium 1');
INSERT INTO synonym VALUES(1605,5,'Phytophthora sp. Taxodium 2');
INSERT INTO synonym VALUES(1606,5,'Phytophthora sp. AUS-8A');
INSERT INTO synonym VALUES(1607,5,'Phytophthora sp. P10369');
INSERT INTO synonym VALUES(1608,5,'Phytophthora sp. P10800');
INSERT INTO synonym VALUES(1609,5,'Phytophthora sp. 6 TIB-2007');
INSERT INTO synonym VALUES(1610,5,'Phytophthora sp. P11656');
INSERT INTO synonym VALUES(1611,5,'Phytophthora sp. 8 TIB-2007');
INSERT INTO synonym VALUES(1612,5,'Phytophthora sp. P15002');
INSERT INTO synonym VALUES(1613,5,'Phytophthora sp. P1714');
INSERT INTO synonym VALUES(1614,5,'Phytophthora sp. P21283');
INSERT INTO synonym VALUES(1615,5,'Phytophthora sp. BR514');
INSERT INTO synonym VALUES(1616,5,'Phytophthora sp. P3587');
INSERT INTO synonym VALUES(1617,5,'Phytophthora sp. P3602');
INSERT INTO synonym VALUES(1618,5,'Phytophthora sp. P3849');
INSERT INTO synonym VALUES(1619,5,'Phytophthora sp. glovera');
INSERT INTO synonym VALUES(1620,5,'Phytophthora sp. ''kelmania''');
INSERT INTO synonym VALUES(1621,5,'Phytophthora sp. ''lagoariana''');
INSERT INTO synonym VALUES(1622,5,'Phytophthora sp. AUS-8B');
INSERT INTO synonym VALUES(1623,5,'Phytophthora sp. P0622');
INSERT INTO synonym VALUES(1624,5,'Phytophthora sp. P10860');
INSERT INTO synonym VALUES(1625,5,'Phytophthora sp. P10866');
INSERT INTO synonym VALUES(1626,5,'Phytophthora sp. P10870');
INSERT INTO synonym VALUES(1627,5,'Phytophthora sp. P10873');
INSERT INTO synonym VALUES(1628,5,'Phytophthora sp. P10875');
INSERT INTO synonym VALUES(1629,5,'Phytophthora sp. P10878');
INSERT INTO synonym VALUES(1630,5,'Phytophthora sp. P11055');
INSERT INTO synonym VALUES(1631,5,'Phytophthora sp. P11098');
INSERT INTO synonym VALUES(1632,5,'Phytophthora sp. P11498');
INSERT INTO synonym VALUES(1633,5,'Phytophthora sp. P15127');
INSERT INTO synonym VALUES(1634,5,'Phytophthora sp. P19007');
INSERT INTO synonym VALUES(1635,5,'Phytophthora sp. P19018');
INSERT INTO synonym VALUES(1636,5,'Phytophthora sp. P19030');
INSERT INTO synonym VALUES(1637,5,'Phytophthora sp. P19041');
INSERT INTO synonym VALUES(1638,5,'Phytophthora sp. P19052');
INSERT INTO synonym VALUES(1639,5,'Phytophthora sp. P19055');
INSERT INTO synonym VALUES(1640,5,'Phytophthora sp. P19071');
INSERT INTO synonym VALUES(1641,5,'Phytophthora sp. P19081');
INSERT INTO synonym VALUES(1642,5,'Phytophthora sp. P19083');
INSERT INTO synonym VALUES(1643,5,'Phytophthora sp. P19085');
INSERT INTO synonym VALUES(1644,5,'Phytophthora sp. 1-21-1');
INSERT INTO synonym VALUES(1645,5,'Phytophthora sp. 1931');
INSERT INTO synonym VALUES(1646,5,'Phytophthora sp. 2-04B');
INSERT INTO synonym VALUES(1647,5,'Phytophthora sp. 62169-00');
INSERT INTO synonym VALUES(1648,5,'Phytophthora sp. 80213-91');
INSERT INTO synonym VALUES(1649,5,'Phytophthora sp. B-6');
INSERT INTO synonym VALUES(1650,5,'Phytophthora sp. P19104');
INSERT INTO synonym VALUES(1651,5,'Phytophthora sp. P19105');
INSERT INTO synonym VALUES(1652,5,'Phytophthora sp. P19106');
INSERT INTO synonym VALUES(1653,5,'Phytophthora sp. CCH-2009a');
INSERT INTO synonym VALUES(1654,5,'Phytophthora sp. P19108');
INSERT INTO synonym VALUES(1655,5,'Phytophthora sp. P19110');
INSERT INTO synonym VALUES(1656,5,'Phytophthora sp. P19114');
INSERT INTO synonym VALUES(1657,5,'Phytophthora sp. P19117');
INSERT INTO synonym VALUES(1658,5,'Phytophthora sp. P19121');
INSERT INTO synonym VALUES(1659,5,'Phytophthora sp. P19134');
INSERT INTO synonym VALUES(1660,5,'Phytophthora sp. P19144');
INSERT INTO synonym VALUES(1661,5,'Phytophthora sp. P19145');
INSERT INTO synonym VALUES(1662,5,'Phytophthora sp. P19146');
INSERT INTO synonym VALUES(1663,5,'Phytophthora sp. P19156');
INSERT INTO synonym VALUES(1664,5,'Phytophthora sp. P19160');
INSERT INTO synonym VALUES(1665,5,'Phytophthora sp. P19163');
INSERT INTO synonym VALUES(1666,5,'Phytophthora sp. P19168');
INSERT INTO synonym VALUES(1667,5,'Phytophthora sp. GD7E');
INSERT INTO synonym VALUES(1668,5,'Phytophthora sp. P19172');
INSERT INTO synonym VALUES(1669,5,'Phytophthora sp. P19173');
INSERT INTO synonym VALUES(1670,5,'Phytophthora sp. P19175');
INSERT INTO synonym VALUES(1671,5,'Phytophthora sp. P19176');
INSERT INTO synonym VALUES(1672,5,'Phytophthora sp. P19177');
INSERT INTO synonym VALUES(1673,5,'Phytophthora sp. P19178');
INSERT INTO synonym VALUES(1674,5,'Phytophthora sp. P19179');
INSERT INTO synonym VALUES(1675,5,'Phytophthora sp. P19180');
INSERT INTO synonym VALUES(1676,5,'Phytophthora sp. P19181');
INSERT INTO synonym VALUES(1677,5,'Phytophthora sp. P3773');
INSERT INTO synonym VALUES(1678,5,'Phytophthora sp. P6127');
INSERT INTO synonym VALUES(1679,5,'Phytophthora sp. P6129');
INSERT INTO synonym VALUES(1680,5,'Phytophthora sp. P6130');
INSERT INTO synonym VALUES(1681,5,'Phytophthora sp. 59');
INSERT INTO synonym VALUES(1682,5,'Phytophthora sp. 63');
INSERT INTO synonym VALUES(1683,5,'Phytophthora sp. 64');
INSERT INTO synonym VALUES(1684,5,'Phytophthora sp. 65');
INSERT INTO synonym VALUES(1685,5,'Phytophthora sp. 1 DB-2021');
INSERT INTO synonym VALUES(1686,5,'Phytophthora sp. Y5');
INSERT INTO synonym VALUES(1687,5,'Phytophthora sp. Ak-6-1');
INSERT INTO synonym VALUES(1688,5,'Phytophthora sp. Fk-3');
INSERT INTO synonym VALUES(1689,5,'Phytophthora sp. Ku-1');
INSERT INTO synonym VALUES(1690,5,'Phytophthora sp. CH84S-2');
INSERT INTO synonym VALUES(1691,5,'Phytophthora sp. LS-2018');
INSERT INTO synonym VALUES(1692,5,'Phytophthora sp. 23J7');
INSERT INTO synonym VALUES(1693,5,'Phytophthora sp. MFM-2016a');
INSERT INTO synonym VALUES(1694,5,'Phytophthora sp. ''kelmania'' x Phytophthora sansomeana');
INSERT INTO synonym VALUES(1695,5,'Phytophthora sp. P1087');
INSERT INTO synonym VALUES(1696,5,'Phytophthora sp. P8071');
INSERT INTO synonym VALUES(1697,5,'Phytophthora sp. P8057');
INSERT INTO synonym VALUES(1698,5,'Phytophthora sp. P9105');
INSERT INTO synonym VALUES(1699,5,'Phytophthora sp. P8056');
INSERT INTO synonym VALUES(1700,5,'Phytophthora sp. P9151');
INSERT INTO synonym VALUES(1701,5,'Phytophthora sp. N9022');
INSERT INTO synonym VALUES(1702,5,'Phytophthora sp. P8096');
INSERT INTO synonym VALUES(1703,5,'Phytophthora sp. P8012');
INSERT INTO synonym VALUES(1704,5,'Phytophthora sp. P8085');
INSERT INTO synonym VALUES(1705,5,'Phytophthora sp. P8050');
INSERT INTO synonym VALUES(1706,5,'Phytophthora sp. P8088');
INSERT INTO synonym VALUES(1707,5,'Phytophthora sp. N9036');
INSERT INTO synonym VALUES(1708,5,'Phytophthora sp. P9104');
INSERT INTO synonym VALUES(1709,5,'Phytophthora sp. N9035');
INSERT INTO synonym VALUES(1710,5,'Phytophthora sp. P8072');
INSERT INTO synonym VALUES(1711,5,'Phytophthora sp. GD2f');
INSERT INTO synonym VALUES(1712,5,'Phytophthora sp. GD4a');
INSERT INTO synonym VALUES(1713,5,'Phytophthora sp. GD4b');
INSERT INTO synonym VALUES(1714,5,'Phytophthora sp. GD4c');
INSERT INTO synonym VALUES(1715,5,'Phytophthora sp. GD4f');
INSERT INTO synonym VALUES(1716,5,'Phytophthora sp. WD40b');
INSERT INTO synonym VALUES(1717,5,'Phytophthora sp. N9071');
INSERT INTO synonym VALUES(1718,5,'Phytophthora sp. P8074');
INSERT INTO synonym VALUES(1719,5,'Phytophthora sp. P9144');
INSERT INTO synonym VALUES(1720,5,'Phytophthora sp. N9041');
INSERT INTO synonym VALUES(1721,5,'Phytophthora sp. N9012');
INSERT INTO synonym VALUES(1722,5,'Phytophthora sp. N9029');
INSERT INTO synonym VALUES(1723,5,'Phytophthora sp. N9010');
INSERT INTO synonym VALUES(1724,5,'Phytophthora sp. P9148');
INSERT INTO synonym VALUES(1725,5,'Phytophthora sp. P9127');
INSERT INTO synonym VALUES(1726,5,'Phytophthora sp. N9042');
INSERT INTO synonym VALUES(1727,5,'Phytophthora sp. EL-8701');
INSERT INTO synonym VALUES(1728,5,'Phytophthora sp. MK-2019a');
INSERT INTO synonym VALUES(1729,5,'Phytophthora sp. NBRC32176');
INSERT INTO synonym VALUES(1730,5,'Phytophthora sp. MAFF 238158');
INSERT INTO synonym VALUES(1731,5,'Phytophthora sp. APC001');
INSERT INTO synonym VALUES(1732,5,'Phytophthora sp. 1 NS-2019');
INSERT INTO synonym VALUES(1733,5,'Phytophthora sp. P16987');
INSERT INTO synonym VALUES(1734,5,'Phytophthora sp. P16991');
INSERT INTO synonym VALUES(1735,5,'Phytophthora sp. 92-207');
INSERT INTO synonym VALUES(1736,5,'Phytophthora sp. 92-209C');
INSERT INTO synonym VALUES(1737,5,'Phytophthora taxon asparagi');
INSERT INTO synonym VALUES(1738,5,'Phytophthora sp. P16992');
INSERT INTO synonym VALUES(1739,5,'Phytophthora sp. P16993');
INSERT INTO synonym VALUES(1740,5,'Phytophthora sp. P16994');
INSERT INTO synonym VALUES(1741,5,'Phytophthora sp. P16995');
INSERT INTO synonym VALUES(1742,5,'Phytophthora sp. P16996');
INSERT INTO synonym VALUES(1743,5,'Phytophthora sp. P16997');
INSERT INTO synonym VALUES(1744,5,'Phytophthora sp. TIB-2012');
INSERT INTO synonym VALUES(1745,5,'Phytophthora sp. P10918');
INSERT INTO synonym VALUES(1746,5,'Phytophthora sp. MYA-4555');
INSERT INTO synonym VALUES(1747,5,'Phytophthora sp. Kunnunara');
INSERT INTO synonym VALUES(1748,5,'Phytophthora sp. MYA-4554');
INSERT INTO synonym VALUES(1749,5,'Phytophthora sp. MDC-2012b');
INSERT INTO synonym VALUES(1750,5,'Phytophthora sp. MDC-2012c');
INSERT INTO synonym VALUES(1751,5,'Phytophthora sp. MDC-2012d');
INSERT INTO synonym VALUES(1752,5,'Phytophthora sp. H-6/02');
INSERT INTO synonym VALUES(1753,5,'Phytophthora sp. H-7/02');
INSERT INTO synonym VALUES(1754,5,'Phytophthora sp. H-8/02');
INSERT INTO synonym VALUES(1755,5,'Phytophthora sp. CB-2020a');
INSERT INTO synonym VALUES(1756,5,'Phytophthora sp. Chile5');
INSERT INTO synonym VALUES(1757,5,'Phytophthora sp. P1212');
INSERT INTO synonym VALUES(1758,5,'Phytophthora sp. P16855');
INSERT INTO synonym VALUES(1759,5,'Phytophthora sp. BUX1');
INSERT INTO synonym VALUES(1760,5,'Phytophthora sp. BUX2');
INSERT INTO synonym VALUES(1761,5,'Phytophthora sp. R1');
INSERT INTO synonym VALUES(1762,5,'Phytophthora sp. R2');
INSERT INTO synonym VALUES(1763,5,'Phytophthora sp. P16858');
INSERT INTO synonym VALUES(1764,5,'Phytophthora sp. P16859');
INSERT INTO synonym VALUES(1765,5,'Phytophthora sp. P3600');
INSERT INTO synonym VALUES(1766,5,'Phytophthora sp. MN20FF');
INSERT INTO synonym VALUES(1767,5,'Phytophthora sp. MN1');
INSERT INTO synonym VALUES(1768,5,'Phytophthora taxon paludosa');
INSERT INTO synonym VALUES(1769,5,'Phytophthora x stagnum');
INSERT INTO synonym VALUES(1770,5,'Phytophthora taxon Oaksoil');
INSERT INTO synonym VALUES(1771,5,'Phytophthora sp. ST_20190627');
INSERT INTO synonym VALUES(1772,5,'Phytophthora taxon raspberry');
INSERT INTO synonym VALUES(1773,5,'Phytophthora sp. ''clade 6D''');
INSERT INTO synonym VALUES(1774,5,'Phytophthora sp. RMG-2020a');
INSERT INTO synonym VALUES(1775,5,'Phytophthora sp. gondwanense');
INSERT INTO synonym VALUES(1776,5,'Phytophthora sp. boodjera');
INSERT INTO synonym VALUES(1777,5,'Phytophthora sp. W6');
INSERT INTO synonym VALUES(1778,5,'Phytophthora sp. V24');
INSERT INTO synonym VALUES(1779,5,'Phytophthora sp. V53');
INSERT INTO synonym VALUES(1780,5,'Phytophthora sp. FFM-2010');
INSERT INTO synonym VALUES(1781,5,'Phytophthora sp. frigida');
INSERT INTO synonym VALUES(1782,5,'Phytophthora sp. alticola');
INSERT INTO synonym VALUES(1783,5,'Phytophthora amnicola x Phytophthora taxon PgChlamydo');
INSERT INTO synonym VALUES(1784,5,'Phytophthora taxon Sisuluriver');
INSERT INTO synonym VALUES(1785,6,'Pythium sp. BP-2009c');
INSERT INTO synonym VALUES(1786,6,'Pythium sp. SHT-2010a');
INSERT INTO synonym VALUES(1787,6,'Pythium sp. JN-1');
INSERT INTO synonym VALUES(1788,6,'Pythium sp. N053');
INSERT INTO synonym VALUES(1789,6,'Pythium sp. UASWS0263');
INSERT INTO synonym VALUES(1790,6,'Pythium sp. UASWS0268');
INSERT INTO synonym VALUES(1791,6,'Pythium sp. UASWS0269');
INSERT INTO synonym VALUES(1792,6,'Pythium sp. UASWS0271');
INSERT INTO synonym VALUES(1793,6,'Pythium sp. YYL-2011b');
INSERT INTO synonym VALUES(1794,6,'Pythium sp. P15845');
INSERT INTO synonym VALUES(1795,6,'Pythium sp. group G');
INSERT INTO synonym VALUES(1796,6,'Pythium sp. I-276');
INSERT INTO synonym VALUES(1797,6,'Pythium sp. I-806');
INSERT INTO synonym VALUES(1798,6,'Pythium sp. I-840');
INSERT INTO synonym VALUES(1799,6,'Pythium sp. I-845');
INSERT INTO synonym VALUES(1800,6,'Pythium sp. I-846');
INSERT INTO synonym VALUES(1801,6,'Pythium sp. I-848');
INSERT INTO synonym VALUES(1802,6,'Pythium sp. I-867');
INSERT INTO synonym VALUES(1803,6,'Pythium sp. I-879');
INSERT INTO synonym VALUES(1804,6,'Pythium sp. I-881');
INSERT INTO synonym VALUES(1805,6,'Pythium sp. I-886');
INSERT INTO synonym VALUES(1806,6,'Pythium sp. I-918');
INSERT INTO synonym VALUES(1807,6,'Pythium sp. I-978');
INSERT INTO synonym VALUES(1808,6,'Pythium sp. F-1509');
INSERT INTO synonym VALUES(1809,6,'Pythium sp. F-166');
INSERT INTO synonym VALUES(1810,6,'Pythium sp. F-42.1');
INSERT INTO synonym VALUES(1811,6,'Pythium sp. F-713');
INSERT INTO synonym VALUES(1812,6,'Pythium sp. F-923.1');
INSERT INTO synonym VALUES(1813,6,'Pythium sp. tumidum');
INSERT INTO synonym VALUES(1814,6,'Pythium sp. Arg 3.5');
INSERT INTO synonym VALUES(1815,6,'Pythium sp. I-987');
INSERT INTO synonym VALUES(1816,6,'Pythium sp. PV Wi 22h');
INSERT INTO synonym VALUES(1817,6,'Pythium sp. PV Wi 36e');
INSERT INTO synonym VALUES(1818,6,'Pythium sp. SB10-1');
INSERT INTO synonym VALUES(1819,6,'Pythium sp. PB2-R8-A Lr');
INSERT INTO synonym VALUES(1820,6,'Pythium sp. SB9-4');
INSERT INTO synonym VALUES(1821,6,'Pythium sp. CLZ223');
INSERT INTO synonym VALUES(1822,6,'Pythium sp. DBH114');
INSERT INTO synonym VALUES(1823,6,'Pythium sp. P19301');
INSERT INTO synonym VALUES(1824,6,'Pythium sp. MDC-2012');
INSERT INTO synonym VALUES(1825,6,'Pythium sp. solare');
INSERT INTO synonym VALUES(1826,6,'Pythium sp. 1 KC-2014');
INSERT INTO synonym VALUES(1827,6,'Pythium sp. 2 KC-2014');
INSERT INTO synonym VALUES(1828,6,'Pythium sp. 1106-4-4B');
INSERT INTO synonym VALUES(1829,6,'Pythium sp. E06');
INSERT INTO synonym VALUES(1830,6,'Pythium sp. 96-224');
INSERT INTO synonym VALUES(1831,6,'Pythium sp. CAL-2011a');
INSERT INTO synonym VALUES(1832,6,'Pythium sp. groupF CAL-2011b');
INSERT INTO synonym VALUES(1833,6,'Pythium sp. CAL-2011c');
INSERT INTO synonym VALUES(1834,6,'Pythium sp. E17');
INSERT INTO synonym VALUES(1835,6,'Pythium sp. E20');
INSERT INTO synonym VALUES(1836,6,'Pythium sp. F-1545.7');
INSERT INTO synonym VALUES(1837,6,'Pythium sp. 1 ROH-2015');
INSERT INTO synonym VALUES(1838,6,'Pythium sp. 2 ROH-2015');
INSERT INTO synonym VALUES(1839,6,'Pythium sp. JEB-2016');
INSERT INTO synonym VALUES(1840,6,'Pythium sp. AR_204');
INSERT INTO synonym VALUES(1841,6,'Pythium sp. AR_235');
INSERT INTO synonym VALUES(1842,6,'Pythium sp. C WLL-2012');
INSERT INTO synonym VALUES(1843,6,'Pythium sp. B WLL-2012');
INSERT INTO synonym VALUES(1844,6,'Pythium sp. A WLL-2012');
INSERT INTO synonym VALUES(1845,6,'Pythium sp. UASWS Py26');
INSERT INTO synonym VALUES(1846,6,'Pythium sp. UASWS STEU6208');
INSERT INTO synonym VALUES(1847,6,'Pythium sp. UASWS STEU6209');
INSERT INTO synonym VALUES(1848,6,'Pythium sp. UASWS STEU6210');
INSERT INTO synonym VALUES(1849,6,'Pythium sp. recalcitrans');
INSERT INTO synonym VALUES(1850,6,'Pythium sp. Turkey 1');
INSERT INTO synonym VALUES(1851,6,'Pythium sp. PPRI8403');
INSERT INTO synonym VALUES(1852,6,'Pythium sp. PPRI8411');
INSERT INTO synonym VALUES(1853,6,'Pythium sp. PPRI8424');
INSERT INTO synonym VALUES(1854,6,'Pythium sp. PPRI8598');
INSERT INTO synonym VALUES(1855,6,'Pythium sp. PPRI8614');
INSERT INTO synonym VALUES(1856,6,'Pythium sp. PPRI8622');
INSERT INTO synonym VALUES(1857,6,'Pythium sp. WJB-1');
INSERT INTO synonym VALUES(1858,6,'Pythium sp. WJB-2');
INSERT INTO synonym VALUES(1859,6,'Pythium sp. WJB-3');
INSERT INTO synonym VALUES(1860,6,'Pythium sp. B-23');
INSERT INTO synonym VALUES(1861,6,'Pythium sp. 991b eu');
INSERT INTO synonym VALUES(1862,6,'Pythium sp. UASWS0276');
INSERT INTO synonym VALUES(1863,6,'Pythium sp. quercum');
INSERT INTO synonym VALUES(1864,6,'Pythium sp. UASWS0189');
INSERT INTO synonym VALUES(1865,6,'Pythium sp. OPU809');
INSERT INTO synonym VALUES(1866,6,'Pythium sp. F-1541.11');
INSERT INTO synonym VALUES(1867,6,'Pythium sp. F-163');
INSERT INTO synonym VALUES(1868,6,'Pythium sp. F-162');
INSERT INTO synonym VALUES(1869,6,'Pythium sp. F-1412');
INSERT INTO synonym VALUES(1870,6,'Pythium sp. F-1413');
INSERT INTO synonym VALUES(1871,6,'Pythium sp. rooibos 2');
INSERT INTO synonym VALUES(1872,6,'Pythium sp. 93-68P');
INSERT INTO synonym VALUES(1873,6,'Pythium sp. Tun-30');
INSERT INTO synonym VALUES(1874,6,'Pythium sp. Tun-2');
INSERT INTO synonym VALUES(1875,6,'Pythium sp. F-1241');
INSERT INTO synonym VALUES(1876,6,'Pythium sp. M2-05');
INSERT INTO synonym VALUES(1877,6,'Pythium sp. takayamanum');
INSERT INTO synonym VALUES(1878,6,'Pythium sp. senticosum');
INSERT INTO synonym VALUES(1879,6,'Pythium sp. UASWS0288');
INSERT INTO synonym VALUES(1880,6,'Pythium sp. UASWS0290');
INSERT INTO synonym VALUES(1881,6,'Pythium sp. UASWS0291');
INSERT INTO synonym VALUES(1882,6,'Pythium sp. UASWS0292');
INSERT INTO synonym VALUES(1883,6,'Pythium sp. UASWS0293');
INSERT INTO synonym VALUES(1884,6,'Pythium sp. WD2B');
INSERT INTO synonym VALUES(1885,6,'Pythium sp. WD2C');
INSERT INTO synonym VALUES(1886,6,'Pythium sp. HT2-5');
INSERT INTO synonym VALUES(1887,6,'Pythium sp. WY-2020a');
INSERT INTO synonym VALUES(1888,6,'Pythium sp. 93-70P');
INSERT INTO synonym VALUES(1889,6,'Pythium sp. PID095');
INSERT INTO synonym VALUES(1890,6,'Pythium sp. PE16');
INSERT INTO synonym VALUES(1891,6,'Pythium sp. stipitatum (TUR 14-3)');
INSERT INTO synonym VALUES(1892,6,'Pythium sp. balticum');
INSERT INTO synonym VALUES(1893,6,'Pythium sp. F-147C');
INSERT INTO synonym VALUES(1894,6,'Pythium sp. F-1517.1');
INSERT INTO synonym VALUES(1895,6,'Pythium sp. F-1525.4');
INSERT INTO synonym VALUES(1896,6,'Pythium sp. F1630');
INSERT INTO synonym VALUES(1897,6,'Pythium sp. cernum/BP-2010');
INSERT INTO synonym VALUES(1898,6,'Pythium sp. longicarpum/BP-2010');
INSERT INTO synonym VALUES(1899,6,'Pythium sp. JN-5');
INSERT INTO synonym VALUES(1900,6,'Pythium sp. JN-6');
INSERT INTO synonym VALUES(1901,6,'Pythium sp. CBS 101876');
INSERT INTO synonym VALUES(1902,6,'Pythium sp. CBS 113341');
INSERT INTO synonym VALUES(1903,6,'Pythium sp. CBS 122647');
INSERT INTO synonym VALUES(1904,6,'Pythium sp. CBS 750.96');
INSERT INTO synonym VALUES(1905,6,'Pythium sp. SCOR-2015');
INSERT INTO synonym VALUES(1906,6,'Pythium sp. ''cluster B2A''');
INSERT INTO synonym VALUES(1907,6,'Pythium sp. P11577');
INSERT INTO synonym VALUES(1908,6,'Pythium sp. P11838');
INSERT INTO synonym VALUES(1909,6,'Pythium sp. A16');
INSERT INTO synonym VALUES(1910,6,'Pythium sp. P8243');
INSERT INTO synonym VALUES(1911,6,'Pythium sp. RSC-2004');
INSERT INTO synonym VALUES(1912,6,'Pythium sp. B12');
INSERT INTO synonym VALUES(1913,6,'Pythium sp. B35');
INSERT INTO synonym VALUES(1914,6,'Pythium sp. B57');
INSERT INTO synonym VALUES(1915,6,'Pythium sp. B65');
INSERT INTO synonym VALUES(1916,6,'Pythium sp. OPU797');
INSERT INTO synonym VALUES(1917,6,'Pythium sp. UZ156');
INSERT INTO synonym VALUES(1918,6,'Pythium sp. UZ164');
INSERT INTO synonym VALUES(1919,6,'Pythium sp. UZ182');
INSERT INTO synonym VALUES(1920,6,'Pythium sp. UZ190');
INSERT INTO synonym VALUES(1921,6,'Pythium sp. UZ213');
INSERT INTO synonym VALUES(1922,6,'Pythium sp. UZ230');
INSERT INTO synonym VALUES(1923,6,'Pythium sp. UZ248');
INSERT INTO synonym VALUES(1924,6,'Pythium sp. UZ249');
INSERT INTO synonym VALUES(1925,6,'Pythium sp. UZ252');
INSERT INTO synonym VALUES(1926,6,'Pythium sp. UZ253');
INSERT INTO synonym VALUES(1927,6,'Pythium sp. UZ260');
INSERT INTO synonym VALUES(1928,6,'Pythium sp. UZ263');
INSERT INTO synonym VALUES(1929,6,'Pythium sp. UZ275');
INSERT INTO synonym VALUES(1930,6,'Pythium sp. UZ277');
INSERT INTO synonym VALUES(1931,6,'Pythium sp. UZ284');
INSERT INTO synonym VALUES(1932,6,'Pythium sp. UZ285');
INSERT INTO synonym VALUES(1933,6,'Pythium sp. UZ287');
INSERT INTO synonym VALUES(1934,6,'Pythium sp. UZ290');
INSERT INTO synonym VALUES(1935,6,'Pythium sp. UZ304');
INSERT INTO synonym VALUES(1936,6,'Pythium sp. UZ318');
INSERT INTO synonym VALUES(1937,6,'Pythium sp. UZ379');
INSERT INTO synonym VALUES(1938,6,'Pythium sp. E26');
INSERT INTO synonym VALUES(1939,6,'Pythium sp. UZ392');
INSERT INTO synonym VALUES(1940,6,'Pythium sp. UZ400');
INSERT INTO synonym VALUES(1941,6,'Pythium sp. UZ416');
INSERT INTO synonym VALUES(1942,6,'Pythium sp. UZ419');
INSERT INTO synonym VALUES(1943,6,'Pythium sp. UZ594');
INSERT INTO synonym VALUES(1944,6,'Pythium sp. UZ612');
INSERT INTO synonym VALUES(1945,6,'Pythium sp. UZ636');
INSERT INTO synonym VALUES(1946,6,'Pythium sp. UZ655');
INSERT INTO synonym VALUES(1947,6,'Pythium sp. OPU1448');
INSERT INTO synonym VALUES(1948,6,'Pythium sp. OPU1449');
INSERT INTO synonym VALUES(1949,6,'Pythium sp. ZSF0011');
INSERT INTO synonym VALUES(1950,6,'Pythium sp. ZSF0030');
INSERT INTO synonym VALUES(1951,6,'Pythium sp. ZSF0056');
INSERT INTO synonym VALUES(1952,6,'Pythium sp. ZSF0069');
INSERT INTO synonym VALUES(1953,6,'Pythium sp. ZSF0093');
INSERT INTO synonym VALUES(1954,6,'Pythium sp. valencianum');
INSERT INTO synonym VALUES(1955,6,'Pythium sp. ''amazonianum''');
INSERT INTO synonym VALUES(1956,6,'Pythium sp. BP 2013a');
INSERT INTO synonym VALUES(1957,6,'Pythium sp. BP 2013b');
INSERT INTO synonym VALUES(1958,6,'Pythium sp. Py26');
INSERT INTO synonym VALUES(1959,6,'Pythium sp. BP 2013c');
INSERT INTO synonym VALUES(1960,6,'Pythium sp. BP 2013d');
INSERT INTO synonym VALUES(1961,6,'Pythium sp. BP 2013e');
INSERT INTO synonym VALUES(1962,6,'Pythium sp. BP 2013f');
INSERT INTO synonym VALUES(1963,6,'Pythium sp. BP 2013g');
INSERT INTO synonym VALUES(1964,6,'Pythium sp. BP 2013h');
INSERT INTO synonym VALUES(1965,6,'Pythium sp. BP 2013i');
INSERT INTO synonym VALUES(1966,6,'Pythium sp. BP 2013j');
INSERT INTO synonym VALUES(1967,6,'Pythium sp. BP 2013k');
INSERT INTO synonym VALUES(1968,6,'Pythium sp. BP 2013l');
INSERT INTO synonym VALUES(1969,6,'Pythium sp. BP 2013m');
INSERT INTO synonym VALUES(1970,6,'Pythium sp. WM_5');
INSERT INTO synonym VALUES(1971,6,'Pythium sp. BCC53698');
INSERT INTO synonym VALUES(1972,6,'Pythium sp. F389');
INSERT INTO synonym VALUES(1973,6,'Pythium cf. xZSF0056');
INSERT INTO synonym VALUES(1974,6,'Pythium sp. C5-1-1');
INSERT INTO synonym VALUES(1975,6,'Pythium sp. IBL//2011/30');
INSERT INTO synonym VALUES(1976,6,'Pythium sp. IBL/2011/12/1');
INSERT INTO synonym VALUES(1977,6,'Pythium sp. IBL/2011/13/1');
INSERT INTO synonym VALUES(1978,6,'Pythium sp. IBL/2011/22/2');
INSERT INTO synonym VALUES(1979,6,'Pythium sp. IBL/2011/29/1');
INSERT INTO synonym VALUES(1980,6,'Pythium sp. IBL/2011/29/2');
INSERT INTO synonym VALUES(1981,6,'Pythium sp. CHE-284');
INSERT INTO synonym VALUES(1982,6,'Pythium sp. CHE-287');
INSERT INTO synonym VALUES(1983,6,'Pythium sp. F-1309.1');
INSERT INTO synonym VALUES(1984,6,'Pythium sp. F-1374.1');
INSERT INTO synonym VALUES(1985,6,'Pythium sp. F-1308.1');
INSERT INTO synonym VALUES(1986,6,'Pythium sp. F-1318.1');
INSERT INTO synonym VALUES(1987,6,'Pythium sp. F-1476.1');
INSERT INTO synonym VALUES(1988,6,'Pythium sp. F-1253');
INSERT INTO synonym VALUES(1989,6,'Pythium sp. 11 NS-2020');
INSERT INTO synonym VALUES(1990,6,'Pythium sp. 3 NS-2020');
INSERT INTO synonym VALUES(1991,6,'Pythium sp. 5 NS-2020');
INSERT INTO synonym VALUES(1992,6,'Pythium sp. 6 NS-2020');
INSERT INTO synonym VALUES(1993,6,'Pythium sp. LY221g');
INSERT INTO synonym VALUES(1994,6,'Pythium sp. DBS323');
INSERT INTO synonym VALUES(1995,6,'Pythium sp. CBS531');
INSERT INTO synonym VALUES(1996,6,'Pythium sp. WHNS23');
INSERT INTO synonym VALUES(1997,6,'Pythium sp. SU-2014');
INSERT INTO synonym VALUES(1998,6,'Pythium sp. F-1540.4');
INSERT INTO synonym VALUES(1999,6,'Pythium sp. F-1550.16');
INSERT INTO synonym VALUES(2000,6,'Pythium sp. F-1550.7');
INSERT INTO synonym VALUES(2001,6,'Pythium sp. P16683');
INSERT INTO synonym VALUES(2002,6,'Pythium sp. 1 PV-2016');
INSERT INTO synonym VALUES(2003,6,'Pythium sp. 2 PV-2016');
INSERT INTO synonym VALUES(2004,6,'Pythium sp. EBK-2013a');
INSERT INTO synonym VALUES(2005,6,'Pythium sp. EBK-2013b');
INSERT INTO synonym VALUES(2006,6,'Pythium sp. UASWS0201');
INSERT INTO synonym VALUES(2007,6,'Pythium sp. P17-1');
INSERT INTO synonym VALUES(2008,6,'Pythium sp. P17-3');
INSERT INTO synonym VALUES(2009,6,'Pythium sp. MJY-M 2004');
INSERT INTO synonym VALUES(2010,6,'Pythium sp. CAL-2011e');
INSERT INTO synonym VALUES(2011,6,'Pythium sp. PTS-2003');
INSERT INTO synonym VALUES(2012,6,'Pythium sp. stipitatum (F-1516)');
INSERT INTO synonym VALUES(2013,6,'Pythium sp. M-2017a');
INSERT INTO synonym VALUES(2014,6,'Pythium sp. M-2017b');
INSERT INTO synonym VALUES(2015,6,'Pythium sp. M-2017c');
INSERT INTO synonym VALUES(2016,6,'Pythium sp. Py292');
INSERT INTO synonym VALUES(2017,6,'Pythium sp. Py293');
INSERT INTO synonym VALUES(2018,6,'Pythium sp. Py294');
INSERT INTO synonym VALUES(2019,6,'Pythium sp. Py37');
INSERT INTO synonym VALUES(2020,6,'Pythium sp. 1 MNS-2013');
INSERT INTO synonym VALUES(2021,6,'Pythium sp. AL-2010');
INSERT INTO synonym VALUES(2022,6,'Pythium sp. F-1231');
INSERT INTO synonym VALUES(2023,6,'Pythium sp. F-1504.2.0');
INSERT INTO synonym VALUES(2024,6,'Pythium sp. F-1511.2 (Ourika 2)');
INSERT INTO synonym VALUES(2025,6,'Pythium sp. FS-2019a');
INSERT INTO synonym VALUES(2026,6,'Pythium sp. FS-2019b');
INSERT INTO synonym VALUES(2027,6,'Pythium sp. FS-2019c');
INSERT INTO synonym VALUES(2028,6,'Pythium sp. WL-2015');
INSERT INTO synonym VALUES(2029,6,'Pythium sp. ''kamfiruzense''');
INSERT INTO synonym VALUES(2030,6,'Pythium sp. 1 HM-2017');
INSERT INTO synonym VALUES(2031,6,'Pythium sp. 2 HM-2017');
INSERT INTO synonym VALUES(2032,6,'Pythium sp. F-148');
INSERT INTO synonym VALUES(2033,6,'Pythium sp. F-147');
INSERT INTO synonym VALUES(2034,6,'Pythium sp. F-977');
INSERT INTO synonym VALUES(2035,6,'Pythium sp. F-1331');
INSERT INTO synonym VALUES(2036,6,'Pythium sp. MuShi');
INSERT INTO synonym VALUES(2037,6,'Pythium sp. F-1335');
INSERT INTO synonym VALUES(2038,6,'Pythium sp. F-1319');
INSERT INTO synonym VALUES(2039,6,'Pythium sp. F-1318');
INSERT INTO synonym VALUES(2040,6,'Pythium sp. XGL324');
INSERT INTO synonym VALUES(2041,6,'Pythium sp. CFJS-2018a');
INSERT INTO synonym VALUES(2042,6,'Pythium sp. UASWS0160');
INSERT INTO synonym VALUES(2043,6,'Pythium sp. P16681');
INSERT INTO synonym VALUES(2044,6,'Pythium sp. UASWS0162');
INSERT INTO synonym VALUES(2045,6,'Pythium sp. UASWS0163');
INSERT INTO synonym VALUES(2046,6,'Pythium sp. Bamako dog');
INSERT INTO synonym VALUES(2047,6,'Pythium sp. UASWS0164');
INSERT INTO synonym VALUES(2048,6,'Pythium sp. UASWS0165');
INSERT INTO synonym VALUES(2049,6,'Pythium sp. UASWS0166');
INSERT INTO synonym VALUES(2050,6,'Pythium sp. UASWS0167');
INSERT INTO synonym VALUES(2051,6,'Pythium sp. UASWS0168');
INSERT INTO synonym VALUES(2052,6,'Pythium sp. UASWS0169');
INSERT INTO synonym VALUES(2053,6,'Pythium sp. UASWS0170');
INSERT INTO synonym VALUES(2054,6,'Pythium sp. UASWS0171');
INSERT INTO synonym VALUES(2055,6,'Pythium sp. UASWS0172');
INSERT INTO synonym VALUES(2056,6,'Pythium sp. UASWS0173');
INSERT INTO synonym VALUES(2057,6,'Pythium sp. UASWS0174');
INSERT INTO synonym VALUES(2058,6,'Pythium sp. UASWS0175');
INSERT INTO synonym VALUES(2059,6,'Pythium sp. UASWS0176');
INSERT INTO synonym VALUES(2060,6,'Pythium sp. UASWS0177');
INSERT INTO synonym VALUES(2061,6,'Pythium sp. UASWS0178');
INSERT INTO synonym VALUES(2062,6,'Pythium sp. UASWS0185');
INSERT INTO synonym VALUES(2063,6,'Pythium sp. PI-5');
INSERT INTO synonym VALUES(2064,6,'Pythium sp. AW-C');
INSERT INTO synonym VALUES(2065,6,'Pythium sp. AW-N');
INSERT INTO synonym VALUES(2066,6,'Pythium sp. AW-D');
INSERT INTO synonym VALUES(2067,6,'Pythium sp. AW-E');
INSERT INTO synonym VALUES(2068,6,'Pythium sp. AW-F');
INSERT INTO synonym VALUES(2069,6,'Pythium sp. AW-G');
INSERT INTO synonym VALUES(2070,6,'Pythium sp. AW-H');
INSERT INTO synonym VALUES(2071,6,'Pythium sp. 286');
INSERT INTO synonym VALUES(2072,6,'Pythium sp. F-147.10');
INSERT INTO synonym VALUES(2073,6,'Pythium sp. F-1541.8');
INSERT INTO synonym VALUES(2074,6,'Pythium sp. PB-2003a');
INSERT INTO synonym VALUES(2075,6,'Pythium sp. F-74');
INSERT INTO synonym VALUES(2076,6,'Pythium sp. F-39');
INSERT INTO synonym VALUES(2077,6,'Pythium sp. F-1216');
INSERT INTO synonym VALUES(2078,6,'Pythium sp. F-1234');
INSERT INTO synonym VALUES(2079,6,'Pythium sp. F-152.2');
INSERT INTO synonym VALUES(2080,6,'Pythium sp. PB912 85');
INSERT INTO synonym VALUES(2081,6,'Pythium sp. PB912 88');
INSERT INTO synonym VALUES(2082,6,'Pythium sp. group F');
INSERT INTO synonym VALUES(2083,6,'Pythium sp. CAL-2011f');
INSERT INTO synonym VALUES(2084,6,'Pythium sp. E13106a');
INSERT INTO synonym VALUES(2085,6,'Pythium sp. E13106f');
INSERT INTO synonym VALUES(2086,6,'Pythium sp. AW-K');
INSERT INTO synonym VALUES(2087,6,'Pythium sp. AW-M');
INSERT INTO synonym VALUES(2088,6,'Pythium sp. Ten8-1');
INSERT INTO synonym VALUES(2089,6,'Pythium sp. Ten2');
INSERT INTO synonym VALUES(2090,6,'Pythium sp. ASR17');
INSERT INTO synonym VALUES(2091,6,'Pythium sp. SR33');
INSERT INTO synonym VALUES(2092,6,'Pythium sp. SR36');
INSERT INTO synonym VALUES(2093,6,'Pythium sp.');
INSERT INTO synonym VALUES(2094,6,'Pythium sp. PV Wi 36c');
INSERT INTO synonym VALUES(2095,6,'Pythium sp. MNS-2014a');
INSERT INTO synonym VALUES(2096,6,'Pythium sp. UASWS0221');
INSERT INTO synonym VALUES(2097,6,'Pythium sp. UASWS0222');
INSERT INTO synonym VALUES(2098,6,'Pythium sp. UASWS0223');
INSERT INTO synonym VALUES(2099,6,'Pythium sp. UASWS0227');
INSERT INTO synonym VALUES(2100,6,'Pythium sp. JN-7a');
INSERT INTO synonym VALUES(2101,6,'Pythium sp. JN-8');
INSERT INTO synonym VALUES(2102,6,'Pythium sp. B81');
INSERT INTO synonym VALUES(2103,6,'Pythium sp. UASWS1226');
INSERT INTO synonym VALUES(2104,6,'Pythium sp. C24');
INSERT INTO synonym VALUES(2105,6,'Pythium sp. C31');
INSERT INTO synonym VALUES(2106,6,'Pythium sp. F-1432.1');
INSERT INTO synonym VALUES(2107,6,'Pythium sp. F-1374');
INSERT INTO synonym VALUES(2108,6,'Pythium sp. F-1393');
INSERT INTO synonym VALUES(2109,6,'Pythium sp. F-1476');
INSERT INTO synonym VALUES(2110,6,'Pythium sp. F-1376');
INSERT INTO synonym VALUES(2111,6,'Pythium sp. C34');
INSERT INTO synonym VALUES(2112,6,'Pythium sp. C70');
INSERT INTO synonym VALUES(2113,6,'Pythium sp. C73');
INSERT INTO synonym VALUES(2114,6,'Pythium sp. REB326-70');
INSERT INTO synonym VALUES(2115,6,'Pythium sp. REB326-73');
INSERT INTO synonym VALUES(2116,6,'Pythium sp. REB326-74');
INSERT INTO synonym VALUES(2117,6,'Pythium sp. AP');
INSERT INTO synonym VALUES(2118,6,'Pythium sp. C88');
INSERT INTO synonym VALUES(2119,6,'Pythium sp. REB326-77');
INSERT INTO synonym VALUES(2120,6,'Pythium sp. 754B');
INSERT INTO synonym VALUES(2121,6,'Pythium sp. D02');
INSERT INTO synonym VALUES(2122,6,'Pythium sp. D21');
INSERT INTO synonym VALUES(2123,6,'Pythium sp. hordeum');
INSERT INTO synonym VALUES(2124,6,'Pythium sp. D37');
INSERT INTO synonym VALUES(2125,6,'Pythium sp. D48');
INSERT INTO synonym VALUES(2126,6,'Pythium sp. GD18D');
INSERT INTO synonym VALUES(2127,6,'Pythium sp. GD34B');
INSERT INTO synonym VALUES(2128,6,'Pythium sp. KS121');
INSERT INTO synonym VALUES(2129,6,'Pythium sp. D85');
INSERT INTO synonym VALUES(2130,6,'Pythium sp. D92');
INSERT INTO synonym VALUES(2131,6,'Pythium sp. P15703');
INSERT INTO synonym VALUES(2132,6,'Pythium sp. P16024');
INSERT INTO synonym VALUES(2133,6,'Pythium sp. P16028');
INSERT INTO synonym VALUES(2134,6,'Pythium sp. P19300/1/3');
INSERT INTO synonym VALUES(2135,6,'Pythium sp. P19305');
INSERT INTO synonym VALUES(2136,6,'Pythium sp. P19400');
INSERT INTO synonym VALUES(2137,6,'Pythium sp. P19407');
INSERT INTO synonym VALUES(2138,6,'Pythium sp. P19410');
INSERT INTO synonym VALUES(2139,6,'Pythium sp. P19421');
INSERT INTO synonym VALUES(2140,6,'Pythium sp. WD44A');
INSERT INTO synonym VALUES(2141,6,'Pythium sp. WD46A');
INSERT INTO synonym VALUES(2142,6,'Pythium sp. P19430');
INSERT INTO synonym VALUES(2143,6,'Pythium sp. P19432');
INSERT INTO synonym VALUES(2144,6,'Pythium sp. P19448');
INSERT INTO synonym VALUES(2145,6,'Pythium sp. P19450');
INSERT INTO synonym VALUES(2146,6,'Pythium sp. P19465');
INSERT INTO synonym VALUES(2147,6,'Pythium sp. P19467');
INSERT INTO synonym VALUES(2148,6,'Pythium sp. P19474');
INSERT INTO synonym VALUES(2149,6,'Pythium sp. P19477');
INSERT INTO synonym VALUES(2150,6,'Pythium sp. P19478');
INSERT INTO synonym VALUES(2151,6,'Pythium sp. P19480');
INSERT INTO synonym VALUES(2152,6,'Pythium sp. P19498');
INSERT INTO synonym VALUES(2153,6,'Pythium sp. P19501');
INSERT INTO synonym VALUES(2154,6,'Pythium sp. P19507');
INSERT INTO synonym VALUES(2155,6,'Pythium sp. P19510');
INSERT INTO synonym VALUES(2156,6,'Pythium sp. P3862');
INSERT INTO synonym VALUES(2157,6,'Pythium sp. P8201');
INSERT INTO synonym VALUES(2158,6,'Pythium sp. P8207');
INSERT INTO synonym VALUES(2159,6,'Pythium sp. P8209');
INSERT INTO synonym VALUES(2160,6,'Pythium sp. P8212');
INSERT INTO synonym VALUES(2161,6,'Pythium sp. E41');
INSERT INTO synonym VALUES(2162,6,'Pythium sp. E44');
INSERT INTO synonym VALUES(2163,6,'Pythium sp. E47');
INSERT INTO synonym VALUES(2164,6,'Pythium sp. E58');
INSERT INTO synonym VALUES(2165,6,'Pythium sp. F-1306');
INSERT INTO synonym VALUES(2166,6,'Pythium sp. F-1399');
INSERT INTO synonym VALUES(2167,6,'Pythium sp. F-940');
INSERT INTO synonym VALUES(2168,6,'Pythium sp. F-1308');
INSERT INTO synonym VALUES(2169,6,'Pythium sp. V1');
INSERT INTO synonym VALUES(2170,6,'Pythium sp. V12');
INSERT INTO synonym VALUES(2171,6,'Pythium sp. F32');
INSERT INTO synonym VALUES(2172,6,'Pythium sp. F61');
INSERT INTO synonym VALUES(2173,6,'Pythium sp. F65');
INSERT INTO synonym VALUES(2174,6,'Pythium sp. CLE-2015a');
INSERT INTO synonym VALUES(2175,6,'Pythium sp. CLE-2015b');
INSERT INTO synonym VALUES(2176,6,'Pythium sp. CLE-2015c');
INSERT INTO synonym VALUES(2177,6,'Pythium sp. CLE-2015d');
INSERT INTO synonym VALUES(2178,6,'Pythium sp. CLE-2015e');
INSERT INTO synonym VALUES(2179,6,'Pythium sp. CLE-2015f');
INSERT INTO synonym VALUES(2180,6,'Pythium sp. 66');
INSERT INTO synonym VALUES(2181,6,'Pythium sp. 173');
INSERT INTO synonym VALUES(2182,6,'Pythium sp. FL-2016a');
INSERT INTO synonym VALUES(2183,6,'Pythium sp. FL-2016b');
INSERT INTO synonym VALUES(2184,6,'Pythium sp. FL-2016c');
INSERT INTO synonym VALUES(2185,6,'Pythium sp. FL-2016d');
INSERT INTO synonym VALUES(2186,6,'Pythium sp. FL-2016e');
INSERT INTO synonym VALUES(2187,6,'Pythium sp. FL-2016f');
INSERT INTO synonym VALUES(2188,6,'Pythium sp. FL-2016g');
INSERT INTO synonym VALUES(2189,6,'Pythium sp. FL-2016h');
INSERT INTO synonym VALUES(2190,6,'Pythium sp. FL-2016i');
INSERT INTO synonym VALUES(2191,6,'Pythium sp. FL-2016j');
INSERT INTO synonym VALUES(2192,6,'Pythium sp. FL-2016k');
INSERT INTO synonym VALUES(2193,6,'Pythium sp. FL-2016l');
INSERT INTO synonym VALUES(2194,6,'Pythium sp. 824b');
INSERT INTO synonym VALUES(2195,6,'Pythium sp. GD29c');
INSERT INTO synonym VALUES(2196,6,'Pythium sp. GD33b');
INSERT INTO synonym VALUES(2197,6,'Pythium sp. GD4e');
INSERT INTO synonym VALUES(2198,6,'Pythium sp. 1 LAC-2014');
INSERT INTO synonym VALUES(2199,6,'Pythium sp. 2 LAC-2014');
INSERT INTO synonym VALUES(2200,6,'Pythium sp. 3 LAC-2014');
INSERT INTO synonym VALUES(2201,6,'Pythium sp. 8206 PARP');
INSERT INTO synonym VALUES(2202,6,'Pythium sp. WD2D');
INSERT INTO synonym VALUES(2203,6,'Pythium sp. WD2E');
INSERT INTO synonym VALUES(2204,6,'Pythium sp. WD2J');
INSERT INTO synonym VALUES(2205,6,'Pythium sp. 1 NS-2019');
INSERT INTO synonym VALUES(2206,6,'Pythium sp. 10 NS-2019');
INSERT INTO synonym VALUES(2207,6,'Pythium sp. 11 NS-2019');
INSERT INTO synonym VALUES(2208,6,'Pythium sp. 12 NS-2019');
INSERT INTO synonym VALUES(2209,6,'Pythium sp. 13 NS-2019');
INSERT INTO synonym VALUES(2210,6,'Pythium sp. 14 NS-2019');
INSERT INTO synonym VALUES(2211,6,'Pythium sp. 2 NS-2019');
INSERT INTO synonym VALUES(2212,6,'Pythium sp. 3 NS-2019');
INSERT INTO synonym VALUES(2213,6,'Pythium sp. 4 NS-2019');
INSERT INTO synonym VALUES(2214,6,'Pythium sp. 5 NS-2019');
INSERT INTO synonym VALUES(2215,6,'Pythium sp. 6 NS-2019');
INSERT INTO synonym VALUES(2216,6,'Pythium sp. 7 NS-2019');
INSERT INTO synonym VALUES(2217,6,'Pythium sp. 8 NS-2019');
INSERT INTO synonym VALUES(2218,6,'Pythium sp. 13 eu');
INSERT INTO synonym VALUES(2219,6,'Pythium sp. 14 eu');
INSERT INTO synonym VALUES(2220,6,'Pythium sp. 22 us-1');
INSERT INTO synonym VALUES(2221,6,'Pythium sp. 241 us-1');
INSERT INTO synonym VALUES(2222,6,'Pythium sp. 26 us-2');
INSERT INTO synonym VALUES(2223,6,'Pythium sp. 280 A eu');
INSERT INTO synonym VALUES(2224,6,'Pythium sp. 29 us');
INSERT INTO synonym VALUES(2225,6,'Pythium sp. 30b us-1');
INSERT INTO synonym VALUES(2226,6,'Pythium sp. 4 eu');
INSERT INTO synonym VALUES(2227,6,'Pythium sp. 6 eu');
INSERT INTO synonym VALUES(2228,6,'Pythium sp. 7b eu');
INSERT INTO synonym VALUES(2229,6,'Pythium sp. 802 us-2');
INSERT INTO synonym VALUES(2230,6,'Pythium sp. 803-2 us');
INSERT INTO synonym VALUES(2231,6,'Pythium sp. 805 us');
INSERT INTO synonym VALUES(2232,6,'Pythium sp. 806 us');
INSERT INTO synonym VALUES(2233,6,'Pythium sp. 814 us-2');
INSERT INTO synonym VALUES(2234,6,'Pythium sp. 840b us');
INSERT INTO synonym VALUES(2235,6,'Pythium sp. 845 us-2');
INSERT INTO synonym VALUES(2236,6,'Pythium sp. 870 us');
INSERT INTO synonym VALUES(2237,6,'Pythium sp. 881 us-1');
INSERT INTO synonym VALUES(2238,6,'Pythium sp. 884 us-2');
INSERT INTO synonym VALUES(2239,6,'Pythium sp. 914 us');
INSERT INTO synonym VALUES(2240,6,'Pythium sp. 916 us');
INSERT INTO synonym VALUES(2241,6,'Pythium sp. 978 eu B');
INSERT INTO synonym VALUES(2242,6,'Pythium sp. 987 B eu');
INSERT INTO synonym VALUES(2243,6,'Pythium sp. 987-A eu');
INSERT INTO synonym VALUES(2244,6,'Pythium sp. PA53');
INSERT INTO synonym VALUES(2245,6,'Pythium sp. PA54');
INSERT INTO synonym VALUES(2246,6,'Pythium sp. PA55');
INSERT INTO synonym VALUES(2247,6,'Pythium sp. PA56');
INSERT INTO synonym VALUES(2248,6,'Pythium sp. PE154');
INSERT INTO synonym VALUES(2249,6,'Pythium sp. PE155');
INSERT INTO synonym VALUES(2250,6,'Pythium sp. PE156');
INSERT INTO synonym VALUES(2251,6,'Pythium sp. PE157');
INSERT INTO synonym VALUES(2252,6,'Pythium sp. PE158');
INSERT INTO synonym VALUES(2253,6,'Pythium sp. PE159');
INSERT INTO synonym VALUES(2254,6,'Pythium sp. PE160');
INSERT INTO synonym VALUES(2255,6,'Pythium sp. 1 HW-2013');
INSERT INTO synonym VALUES(2256,6,'Pythium sp. kashmirense');
INSERT INTO synonym VALUES(2257,6,'Pythium sp. FFM-2010');
INSERT INTO synonym VALUES(2258,6,'Pythium sp. 1 SC-2020');
INSERT INTO synonym VALUES(2259,6,'Pythium sp. 2 SC-2020');
INSERT INTO synonym VALUES(2260,6,'Pythium sp. 3 SC-2020');
INSERT INTO synonym VALUES(2261,6,'Pythium sp. 4 SC-2020');
INSERT INTO synonym VALUES(2262,6,'Pythium sp. P8204');
INSERT INTO synonym VALUES(2263,6,'Pythium sp. AR_100');
INSERT INTO synonym VALUES(2264,6,'Pythium sp. PV So7');
INSERT INTO synonym VALUES(2265,6,'Pythium sp. F-1292');
INSERT INTO synonym VALUES(2266,6,'Pythium sp. YJC-2014');
INSERT INTO synonym VALUES(2267,6,'Pythium sp. BG01');
INSERT INTO synonym VALUES(2268,6,'Pythium sp. BG12');
INSERT INTO synonym VALUES(2269,6,'Pythium sp. PE101');
INSERT INTO synonym VALUES(2270,6,'Pythium sp. UASWS0186');
INSERT INTO synonym VALUES(2271,6,'Pythium sp. UASWS0187');
INSERT INTO synonym VALUES(2272,6,'Pythium sp. UASWS188');
INSERT INTO synonym VALUES(2273,6,'Pythium sp. OAK');
INSERT INTO synonym VALUES(2274,6,'Pythium sp. unique1');
INSERT INTO synonym VALUES(2275,6,'Pythium sp. unique1sub2');
INSERT INTO synonym VALUES(2276,6,'Pythium sp. unique1sub3');
INSERT INTO synonym VALUES(2277,6,'Pythium sp. unique2');
INSERT INTO synonym VALUES(2278,6,'Pythium sp. unique3');
INSERT INTO synonym VALUES(2279,6,'Pythium sp. GY-1938');
INSERT INTO synonym VALUES(2280,6,'Pythium sp. JN-12');
INSERT INTO synonym VALUES(2281,6,'Pythium sp. JN-13');
INSERT INTO synonym VALUES(2282,6,'Pythium sp. JN-14');
INSERT INTO synonym VALUES(2283,6,'Pythium sp. OPU810');
INSERT INTO synonym VALUES(2284,6,'Pythium sp. P056');
INSERT INTO synonym VALUES(2285,6,'Pythium sp. OPU811');
INSERT INTO synonym VALUES(2286,6,'Pythium sp. OPU812');
INSERT INTO synonym VALUES(2287,6,'Pythium sp. 9 NS-2019');
INSERT INTO synonym VALUES(2288,6,'Pythium sp. WD35B');
INSERT INTO synonym VALUES(2289,6,'Pythium sp. LVP A');
INSERT INTO synonym VALUES(2290,6,'Pythium sp. LVP B');
INSERT INTO synonym VALUES(2291,6,'Pythium sp. LVP D');
INSERT INTO synonym VALUES(2292,6,'Pythium sp. LVP F');
INSERT INTO synonym VALUES(2293,6,'Pythium sp. BP-2008a');
INSERT INTO synonym VALUES(2294,6,'Pythium sp. BP-2008b');
INSERT INTO synonym VALUES(2295,6,'Pythium sp. Py55');
INSERT INTO synonym VALUES(2296,6,'Pythium sp. UASWS0020');
INSERT INTO synonym VALUES(2297,6,'Pythium sp. AW-A');
INSERT INTO synonym VALUES(2298,6,'Pythium sp. AW-B');
INSERT INTO synonym VALUES(2299,6,'Pythium sp. PB-2007');
INSERT INTO synonym VALUES(2300,7,'Lagenidium sp. PWL-2011a');
INSERT INTO synonym VALUES(2301,7,'Lagenidium sp. LM-2012b');
INSERT INTO synonym VALUES(2302,7,'Lagenidium sp. ''vilelae''');
INSERT INTO synonym VALUES(2303,7,'Lagenidium sp. PWL-2010a');
INSERT INTO synonym VALUES(2304,7,'Lagenidium sp. PWL-2010b');
INSERT INTO synonym VALUES(2305,7,'Lagenidium sp. SLG-2014d');
INSERT INTO synonym VALUES(2306,7,'Lagenidium sp. PWL-2010d');
INSERT INTO synonym VALUES(2307,7,'Lagenidium sp. PWL-2010e');
INSERT INTO synonym VALUES(2308,7,'Lagenidium sp. PWL-2010f');
INSERT INTO synonym VALUES(2309,7,'Lagenidium sp. PWL-2010g');
INSERT INTO synonym VALUES(2310,7,'Lagenidium sp. PWL-2010h');
INSERT INTO synonym VALUES(2311,7,'Lagenidium sp. PWL-2010i');
INSERT INTO synonym VALUES(2312,7,'Lagenidium sp. YJC-2014');
INSERT INTO synonym VALUES(2313,7,'Lagenidium sp. CICR-Hop');
INSERT INTO synonym VALUES(2314,7,'Lagenidium sp.');
INSERT INTO synonym VALUES(2315,7,'Lagenidium sp. strain LEV5863');
INSERT INTO synonym VALUES(2316,7,'Lagenidium sp. strain LEV5848');
INSERT INTO synonym VALUES(2317,7,'Lagenidium sp. SL23');
INSERT INTO synonym VALUES(2318,7,'Lagenidium sp. DAOM 242348');
INSERT INTO synonym VALUES(2319,7,'Lagenidium sp. IMI395810');
INSERT INTO synonym VALUES(2320,7,'Lagenidium sp. SL10');
INSERT INTO synonym VALUES(2321,7,'Lagenidium sp. MTLA-01');
INSERT INTO synonym VALUES(2322,7,'Lagenidium sp. MTLA-03');
INSERT INTO synonym VALUES(2323,7,'Lagenidium sp. MTLA-04');
INSERT INTO synonym VALUES(2324,7,'Lagenidium sp. MTLA-05');
INSERT INTO synonym VALUES(2325,7,'Lagenidium sp. LC1');
INSERT INTO synonym VALUES(2326,7,'Lagenidium sp. SLG-2014a');
INSERT INTO synonym VALUES(2327,7,'Lagenidium sp. SLG-2014b');
INSERT INTO synonym VALUES(2328,8,'Albugo sp. YJC-2010a');
INSERT INTO synonym VALUES(2329,8,'Albugo sp. SMK13752');
INSERT INTO synonym VALUES(2330,8,'Albugo sp. SMK15670');
INSERT INTO synonym VALUES(2331,8,'Albugo sp. YJC-2014');
INSERT INTO synonym VALUES(2332,8,'Albugo sp. 28A');
INSERT INTO synonym VALUES(2333,8,'Albugo sp. 22A');
INSERT INTO synonym VALUES(2334,8,'Albugo sp. 34A');
INSERT INTO synonym VALUES(2335,8,'Albugo sp. 14A');
INSERT INTO synonym VALUES(2336,8,'Albugo sp. FR0046008');
INSERT INTO synonym VALUES(2337,8,'Albugo sp. FR0046009');
INSERT INTO synonym VALUES(2338,8,'Albugo sp. FR0046010');
INSERT INTO synonym VALUES(2339,8,'Albugo sp. FR0046011');
INSERT INTO synonym VALUES(2340,8,'Albugo sp. FR0046012');
INSERT INTO synonym VALUES(2341,8,'Albugo sp. FR0046013');
INSERT INTO synonym VALUES(2342,8,'Albugo sp. FR0046014');
INSERT INTO synonym VALUES(2343,8,'Albugo sp. FR0046017');
INSERT INTO synonym VALUES(2344,8,'Albugo sp. FR0046018');
INSERT INTO synonym VALUES(2345,8,'Albugo sp. FR0046019');
INSERT INTO synonym VALUES(2346,8,'Albugo sp. FR0046020');
INSERT INTO synonym VALUES(2347,8,'Albugo sp. FR0046021');
INSERT INTO synonym VALUES(2348,8,'Albugo sp. FR0046022');
INSERT INTO synonym VALUES(2349,8,'Albugo sp. FR0046023');
INSERT INTO synonym VALUES(2350,8,'Albugo sp. BPI877752');
INSERT INTO synonym VALUES(2351,8,'Albugo sp. BPI877753');
INSERT INTO synonym VALUES(2352,8,'Albugo sp. BPI877754');
INSERT INTO synonym VALUES(2353,8,'Albugo sp. SAU80');
INSERT INTO synonym VALUES(2354,8,'Albugo sp. SSP-2010');
INSERT INTO synonym VALUES(2355,9,'Peronospora sp. AM-2006');
INSERT INTO synonym VALUES(2356,9,'Peronospora sp. Aquilegia');
INSERT INTO synonym VALUES(2357,9,'Peronospora sp. S4');
INSERT INTO synonym VALUES(2358,9,'Peronospora sp. S6');
INSERT INTO synonym VALUES(2359,9,'Peronospora sp. S6-2');
INSERT INTO synonym VALUES(2360,9,'Peronospora sp. S7');
INSERT INTO synonym VALUES(2361,9,'Peronospora sp. S7-2');
INSERT INTO synonym VALUES(2362,9,'Peronospora sp. DML84');
INSERT INTO synonym VALUES(2363,9,'Peronospora sp. HV-2015');
INSERT INTO synonym VALUES(2364,9,'Peronospora sp. 1031');
INSERT INTO synonym VALUES(2365,9,'Peronospora sp. 1035');
INSERT INTO synonym VALUES(2366,9,'Peronospora sp. UPS F-119987');
INSERT INTO synonym VALUES(2367,9,'Peronospora sp. UPS F-119986');
INSERT INTO synonym VALUES(2368,9,'Peronospora sp. 1023');
INSERT INTO synonym VALUES(2369,9,'Peronospora sp. 1025');
INSERT INTO synonym VALUES(2370,9,'Peronospora sp. 1029');
INSERT INTO synonym VALUES(2371,9,'Peronospora sp. GG133');
INSERT INTO synonym VALUES(2372,9,'Peronospora sp. GG56');
INSERT INTO synonym VALUES(2373,9,'Peronospora sp. GG99');
INSERT INTO synonym VALUES(2374,9,'Peronospora sp. HV22.3F');
INSERT INTO synonym VALUES(2375,9,'Peronospora sp. HV27.1F-27.3');
INSERT INTO synonym VALUES(2376,9,'Peronospora sp. HV48.3F');
INSERT INTO synonym VALUES(2377,9,'Peronospora sp. HV938');
INSERT INTO synonym VALUES(2378,9,'Peronospora sp. HV956');
INSERT INTO synonym VALUES(2379,9,'Peronospora sp. MA-Fungi27993');
INSERT INTO synonym VALUES(2380,9,'Peronospora sp. MG1796');
INSERT INTO synonym VALUES(2381,9,'Peronospora sp. MG1797');
INSERT INTO synonym VALUES(2382,9,'Peronospora sp. 1041');
INSERT INTO synonym VALUES(2383,9,'Peronospora sp. 1042');
INSERT INTO synonym VALUES(2384,9,'Peronospora sp. 1044');
INSERT INTO synonym VALUES(2385,9,'Peronospora sp. 1046');
INSERT INTO synonym VALUES(2386,9,'Peronospora sp. 1164');
INSERT INTO synonym VALUES(2387,9,'Peronospora sp. 1165');
INSERT INTO synonym VALUES(2388,9,'Peronospora sp. 2558');
INSERT INTO synonym VALUES(2389,9,'Peronospora sp. 2559');
INSERT INTO synonym VALUES(2390,9,'Peronospora sp. 2709');
INSERT INTO synonym VALUES(2391,9,'Peronospora sp. 2710');
INSERT INTO synonym VALUES(2392,9,'Peronospora sp. AT-2013');
INSERT INTO synonym VALUES(2393,9,'Peronospora sp. BP124');
INSERT INTO synonym VALUES(2394,9,'Peronospora sp. HV1019');
INSERT INTO synonym VALUES(2395,9,'Peronospora sp. HV2117');
INSERT INTO synonym VALUES(2396,9,'Peronospora sp. HV2617');
INSERT INTO synonym VALUES(2397,9,'Peronospora sp. HV2657');
INSERT INTO synonym VALUES(2398,9,'Peronospora sp. HV2908');
INSERT INTO synonym VALUES(2399,9,'Peronospora sp. HV2939');
INSERT INTO synonym VALUES(2400,9,'Peronospora sp. HV312');
INSERT INTO synonym VALUES(2401,9,'Peronospora sp. HV507');
INSERT INTO synonym VALUES(2402,9,'Peronospora sp. HV852');
INSERT INTO synonym VALUES(2403,9,'Peronospora sp. S25');
INSERT INTO synonym VALUES(2404,9,'Peronospora sp. S27');
INSERT INTO synonym VALUES(2405,9,'Peronospora sp. 2859');
INSERT INTO synonym VALUES(2406,9,'Peronospora sp. CSS-2020a');
INSERT INTO synonym VALUES(2407,9,'Peronospora sp. KUS-F23241');
INSERT INTO synonym VALUES(2408,9,'Peronospora sp. DK02');
INSERT INTO synonym VALUES(2409,9,'Peronospora sp. DK03');
INSERT INTO synonym VALUES(2410,9,'Peronospora sp. DK05');
INSERT INTO synonym VALUES(2411,9,'Peronospora sp. DK06');
INSERT INTO synonym VALUES(2412,9,'Peronospora sp. DK07');
INSERT INTO synonym VALUES(2413,9,'Peronospora sp. DK08');
INSERT INTO synonym VALUES(2414,9,'Peronospora sp. DK10');
INSERT INTO synonym VALUES(2415,9,'Peronospora sp. DK11');
INSERT INTO synonym VALUES(2416,9,'Peronospora sp. DK12');
INSERT INTO synonym VALUES(2417,9,'Peronospora sp. DK13');
INSERT INTO synonym VALUES(2418,9,'Peronospora sp. DK14');
INSERT INTO synonym VALUES(2419,9,'Peronospora sp. DK16');
INSERT INTO synonym VALUES(2420,9,'Peronospora sp. DK18');
INSERT INTO synonym VALUES(2421,9,'Peronospora sp. DK19');
INSERT INTO synonym VALUES(2422,9,'Peronospora sp. DK20');
INSERT INTO synonym VALUES(2423,9,'Peronospora sp. DK21');
INSERT INTO synonym VALUES(2424,9,'Peronospora sp. DK22');
INSERT INTO synonym VALUES(2425,9,'Peronospora sp. DK24');
INSERT INTO synonym VALUES(2426,9,'Peronospora sp. DK25');
INSERT INTO synonym VALUES(2427,9,'Peronospora sp. EC05');
INSERT INTO synonym VALUES(2428,9,'Peronospora sp. EC06');
INSERT INTO synonym VALUES(2429,9,'Peronospora sp. EC07');
INSERT INTO synonym VALUES(2430,9,'Peronospora sp. EC09');
INSERT INTO synonym VALUES(2431,9,'Peronospora sp. EC10');
INSERT INTO synonym VALUES(2432,9,'Peronospora sp. PE01');
INSERT INTO synonym VALUES(2433,9,'Peronospora sp. PE03');
INSERT INTO synonym VALUES(2434,9,'Peronospora sp. PE05');
INSERT INTO synonym VALUES(2435,9,'Peronospora sp. UASWS0007');
INSERT INTO synonym VALUES(2436,9,'Peronospora sp. UASWS0008');
INSERT INTO synonym VALUES(2437,9,'Peronospora sp. UASWS0009');
INSERT INTO synonym VALUES(2438,9,'Peronospora sp. UASWS0010');
INSERT INTO synonym VALUES(2439,9,'Peronospora sp. WD-2020a');
INSERT INTO synonym VALUES(2440,9,'Peronospora sp. UASWS0196');
INSERT INTO synonym VALUES(2441,9,'Peronospora sp. YJC-2009a');
INSERT INTO synonym VALUES(2442,9,'Peronospora sp. 1217402');
INSERT INTO synonym VALUES(2443,9,'Peronospora sp.');
INSERT INTO synonym VALUES(2444,9,'Peronospora sp. UASWS0242');
INSERT INTO synonym VALUES(2445,9,'Peronospora sp. UASWS0243');
INSERT INTO synonym VALUES(2446,9,'Peronospora sp. UASWS0244');
INSERT INTO synonym VALUES(2447,9,'Peronospora sp. UASWS0245');
INSERT INTO synonym VALUES(2448,9,'Peronospora sp. UASWS0246');
INSERT INTO synonym VALUES(2449,9,'Peronospora sp. UASWS0247');
INSERT INTO synonym VALUES(2450,9,'Peronospora sp. UASWS0248');
INSERT INTO synonym VALUES(2451,9,'Peronospora sp. UASWS0249');
INSERT INTO synonym VALUES(2452,9,'Peronospora sp. UASWS0250');
INSERT INTO synonym VALUES(2453,9,'Peronospora sp. UASWS0251');
INSERT INTO synonym VALUES(2454,9,'Peronospora sp. UASWS0252');
INSERT INTO synonym VALUES(2455,9,'Peronospora sp. UASWS0253');
INSERT INTO synonym VALUES(2456,9,'Peronospora sp. UASWS0254');
INSERT INTO synonym VALUES(2457,9,'Peronospora sp. UASWS0255');
INSERT INTO synonym VALUES(2458,9,'Peronospora sp. UASWS0256');
INSERT INTO synonym VALUES(2459,9,'Peronospora sp. UASWS0257');
INSERT INTO synonym VALUES(2460,9,'Peronospora sp. UASWS0258');
INSERT INTO synonym VALUES(2461,9,'Peronospora sp. UF0651');
INSERT INTO synonym VALUES(2462,9,'Peronospora sp. DAR45530');
INSERT INTO synonym VALUES(2463,9,'Peronospora sp. SMK20063');
INSERT INTO synonym VALUES(2464,9,'Peronospora sp. KUS-F26431');
INSERT INTO synonym VALUES(2465,9,'Peronospora sp. WJD-2019a');
INSERT INTO synonym VALUES(2466,9,'Peronospora sp. A1');
INSERT INTO synonym VALUES(2467,9,'Peronospora sp. A2');
INSERT INTO synonym VALUES(2468,9,'Peronospora sp. B1');
INSERT INTO synonym VALUES(2469,9,'Peronospora sp. B2');
INSERT INTO synonym VALUES(2470,9,'Peronospora sp. C1');
INSERT INTO synonym VALUES(2471,9,'Peronospora sp. C2');
INSERT INTO synonym VALUES(2472,9,'Peronospora sp. D1');
INSERT INTO synonym VALUES(2473,9,'Peronospora sp. D2');
INSERT INTO synonym VALUES(2474,9,'Peronospora sp. E1');
INSERT INTO synonym VALUES(2475,9,'Peronospora sp. E3');
INSERT INTO synonym VALUES(2476,9,'Peronospora sp. F1');
INSERT INTO synonym VALUES(2477,9,'Peronospora sp. F2');
INSERT INTO synonym VALUES(2478,9,'Peronospora sp. G1');
INSERT INTO synonym VALUES(2479,9,'Peronospora sp. G2');
INSERT INTO synonym VALUES(2480,9,'Peronospora sp. H1');
INSERT INTO synonym VALUES(2481,9,'Peronospora sp. BPI893224');
INSERT INTO synonym VALUES(2482,9,'Peronospora sp. UASWS0229');
INSERT INTO synonym VALUES(2483,9,'Peronospora sp. FLDM-1');
INSERT INTO synonym VALUES(2484,9,'Peronospora sp. HOH HUH961');
INSERT INTO synonym VALUES(2485,9,'Peronospora sp. UASWS0037');
INSERT INTO synonym VALUES(2486,9,'Peronospora sp. isolate 079401,55 (BR)');
INSERT INTO synonym VALUES(2487,9,'Peronospora sp. isolate 079403,57 (BR)');
INSERT INTO synonym VALUES(2488,9,'Peronospora sp. isolate 079405,59 (BR)');
INSERT INTO synonym VALUES(2489,9,'Peronospora sp. isolate 079409,63 (BR)');
INSERT INTO synonym VALUES(2490,9,'Peronospora sp. isolate 079413,67 (BR)');
INSERT INTO synonym VALUES(2491,9,'Peronospora sp. isolate UASWS0236');
INSERT INTO synonym VALUES(2492,9,'Peronospora sp. isolate UASWS0237');
INSERT INTO synonym VALUES(2493,9,'Peronospora sp. isolate UASWS0238');
INSERT INTO synonym VALUES(2494,9,'Peronospora sp. isolate UASWS0239');
INSERT INTO synonym VALUES(2495,9,'Peronospora sp. isolate UASWS0240');
INSERT INTO synonym VALUES(2496,9,'Peronospora sp. isolate UASWS0241');
INSERT INTO synonym VALUES(2497,9,'Peronospora sp. UASWS0033');
INSERT INTO synonym VALUES(2498,9,'Peronospora sp. UASWS0034');
INSERT INTO synonym VALUES(2499,9,'Peronospora sp. UASWS0035');
INSERT INTO synonym VALUES(2500,9,'Peronospora sp. UASWS0036');
INSERT INTO synonym VALUES(2501,9,'Peronospora sp. SMK 17388');
INSERT INTO synonym VALUES(2502,9,'Peronospora sp. SMK 19551');
INSERT INTO synonym VALUES(2503,9,'Peronospora sp. SMK 20438');
INSERT INTO synonym VALUES(2504,9,'Peronospora sp. Ng2011');
INSERT INTO synonym VALUES(2505,9,'Peronospora sp. YGC-2019');
INSERT INTO synonym VALUES(2506,9,'Peronospora sp. MA-Fungi 27841');
INSERT INTO synonym VALUES(2507,10,'Thraustotheca sp. Argentina 3.8');
INSERT INTO synonym VALUES(2508,11,'Dictyuchus sp. JVS-2012');
INSERT INTO synonym VALUES(2509,11,'Dictyuchus sp. 1 HM-2018');
INSERT INTO synonym VALUES(2510,11,'Dictyuchus sp. 2 HM-2018');
INSERT INTO synonym VALUES(2511,11,'Dictyuchus sp. 3 HM-2018');
INSERT INTO synonym VALUES(2512,11,'Dictyuchus sp. 4 HM-2018');
INSERT INTO synonym VALUES(2513,11,'Dictyuchus sp. 5 HM-2018');
INSERT INTO synonym VALUES(2514,11,'Dictyuchus sp. 6 HM-2018');
INSERT INTO synonym VALUES(2515,11,'Dictyuchus sp. 7 HM-2018');
INSERT INTO synonym VALUES(2516,11,'Dictyuchus sp. 8 HM-2018');
INSERT INTO synonym VALUES(2517,11,'Dictyuchus sp.');
INSERT INTO synonym VALUES(2518,11,'Dictyuchus sp. Petersen-4.2');
INSERT INTO synonym VALUES(2519,11,'Dictyuchus sp. Petersen-5.6');
INSERT INTO synonym VALUES(2520,11,'Dictyuchus sp. MA-2014');
INSERT INTO synonym VALUES(2521,11,'Dictyuchus sp. 10 HM-2018');
INSERT INTO synonym VALUES(2522,11,'Dictyuchus sp. 11 HM-2018');
INSERT INTO synonym VALUES(2523,11,'Dictyuchus sp. 12 HM-2018');
INSERT INTO synonym VALUES(2524,11,'Dictyuchus sp. 13 HM-2018');
INSERT INTO synonym VALUES(2525,11,'Dictyuchus sp. 14 HM-2018');
INSERT INTO synonym VALUES(2526,11,'Dictyuchus sp. 9 HM-2018');
INSERT INTO synonym VALUES(2527,11,'Dictyuchus sp. BP-S2');
INSERT INTO synonym VALUES(2528,11,'Dictyuchus sp. AR_29');
INSERT INTO synonym VALUES(2529,12,'Pythiopsis sp. JVS-2018a');
INSERT INTO synonym VALUES(2530,14,'Leptolegnia sp. JVS-2012');
INSERT INTO synonym VALUES(2531,14,'Leptolegnia sp. SAP0772');
INSERT INTO synonym VALUES(2532,14,'Leptolegnia sp. SAP248');
INSERT INTO synonym VALUES(2533,14,'Leptolegnia sp. VI04813');
INSERT INTO synonym VALUES(2534,14,'Leptolegnia sp. BS1');
INSERT INTO synonym VALUES(2535,14,'Leptolegnia sp. BS11');
INSERT INTO synonym VALUES(2536,14,'Leptolegnia sp. BS13');
INSERT INTO synonym VALUES(2537,14,'Leptolegnia sp. BS14');
INSERT INTO synonym VALUES(2538,14,'Leptolegnia sp. PSCR0503');
INSERT INTO synonym VALUES(2539,14,'Leptolegnia sp. BS16');
INSERT INTO synonym VALUES(2540,14,'Leptolegnia sp. BS6');
INSERT INTO synonym VALUES(2541,14,'Leptolegnia sp. BS8');
INSERT INTO synonym VALUES(2542,14,'Leptolegnia sp. Soerensen-1.6');
INSERT INTO synonym VALUES(2543,14,'Leptolegnia sp. Soerensen-3.1');
INSERT INTO synonym VALUES(2544,14,'Leptolegnia sp. EM32A');
INSERT INTO synonym VALUES(2545,14,'Leptolegnia sp. NT');
INSERT INTO synonym VALUES(2546,14,'Leptolegnia sp. SP');
INSERT INTO synonym VALUES(2547,14,'Leptolegnia sp.');
INSERT INTO synonym VALUES(2548,14,'Leptolegnia sp. BOLD:AAX5717');
INSERT INTO synonym VALUES(2549,14,'Leptolegnia sp. K08');
INSERT INTO synonym VALUES(2550,14,'Leptolegnia sp. MNS-2014a');
INSERT INTO synonym VALUES(2551,14,'Leptolegnia sp. LB-2015');
INSERT INTO synonym VALUES(2552,14,'Leptolegnia sp. WLL-2012');
INSERT INTO synonym VALUES(2553,14,'Leptolegnia sp. CBS 582.85');
INSERT INTO synonym VALUES(2554,14,'Leptolegnia sp. CBS 392.81');
INSERT INTO synonym VALUES(2555,14,'Leptolegnia sp. SR-2014');
INSERT INTO synonym VALUES(2556,14,'Leptolegnia sp. CBS 177.86');
INSERT INTO synonym VALUES(2557,16,'Aphanomyces sp. NJM 0703');
INSERT INTO synonym VALUES(2558,16,'Aphanomyces sp. NJM 0704');
INSERT INTO synonym VALUES(2559,16,'Aphanomyces sp. NJM 0714');
INSERT INTO synonym VALUES(2560,16,'Aphanomyces sp. NJM 0705');
INSERT INTO synonym VALUES(2561,16,'Aphanomyces sp. NJM 0706');
INSERT INTO synonym VALUES(2562,16,'Aphanomyces sp. NJM 0707');
INSERT INTO synonym VALUES(2563,16,'Aphanomyces sp. NJM 0908');
INSERT INTO synonym VALUES(2564,16,'Aphanomyces sp. NJM 0909');
INSERT INTO synonym VALUES(2565,16,'Aphanomyces sp. NJM 0910');
INSERT INTO synonym VALUES(2566,16,'Aphanomyces sp. NJM 0912');
INSERT INTO synonym VALUES(2567,16,'Aphanomyces sp. NJM 0914');
INSERT INTO synonym VALUES(2568,16,'Aphanomyces sp. NJM 0915');
INSERT INTO synonym VALUES(2569,16,'Aphanomyces sp. NJM 0916');
INSERT INTO synonym VALUES(2570,16,'Aphanomyces sp. NJM 0917');
INSERT INTO synonym VALUES(2571,16,'Aphanomyces sp. NJM 0911');
INSERT INTO synonym VALUES(2572,16,'Aphanomyces sp. NJM 0913');
INSERT INTO synonym VALUES(2573,16,'Aphanomyces sp. NJM 0918');
INSERT INTO synonym VALUES(2574,16,'Aphanomyces sp. NJM 0919');
INSERT INTO synonym VALUES(2575,16,'Aphanomyces sp. NJM 0903');
INSERT INTO synonym VALUES(2576,16,'Aphanomyces sp. NJM 0904');
INSERT INTO synonym VALUES(2577,16,'Aphanomyces sp. NJM 0905');
INSERT INTO synonym VALUES(2578,16,'Aphanomyces sp. JN-9');
INSERT INTO synonym VALUES(2579,16,'Aphanomyces sp. TF33');
INSERT INTO synonym VALUES(2580,16,'Aphanomyces sp. TF5');
INSERT INTO synonym VALUES(2581,16,'Aphanomyces sp. NJM 0906');
INSERT INTO synonym VALUES(2582,16,'Aphanomyces sp. NJM 0907');
INSERT INTO synonym VALUES(2583,16,'Aphanomyces sp. PWL-2010');
INSERT INTO synonym VALUES(2584,16,'Aphanomyces sp. NVA');
INSERT INTO synonym VALUES(2585,16,'Aphanomyces sp. AW-L');
INSERT INTO synonym VALUES(2586,16,'Aphanomyces sp. AW-I');
INSERT INTO synonym VALUES(2587,16,'Aphanomyces sp. AW-J');
INSERT INTO synonym VALUES(2588,16,'Aphanomyces sp. NJM 0708');
INSERT INTO synonym VALUES(2589,16,'Aphanomyces sp. AR_11');
INSERT INTO synonym VALUES(2590,16,'Aphanomyces sp. APH1');
INSERT INTO synonym VALUES(2591,16,'Aphanomyces sp. APH2');
INSERT INTO synonym VALUES(2592,16,'Aphanomyces sp. APH3');
INSERT INTO synonym VALUES(2593,16,'Aphanomyces sp.');
INSERT INTO synonym VALUES(2594,16,'Aphanomyces sp. BOLD:AAO9952');
INSERT INTO synonym VALUES(2595,16,'Aphanomyces sp. WLL-2012');
INSERT INTO synonym VALUES(2596,16,'Aphanomyces sp. 84-1240');
INSERT INTO synonym VALUES(2597,16,'Aphanomyces sp. ''trifolii''');
INSERT INTO synonym VALUES(2598,16,'Aphanomyces sp. LIT7');
INSERT INTO synonym VALUES(2599,16,'Aphanomyces sp. F-1293');
INSERT INTO synonym VALUES(2600,16,'Aphanomyces sp. CBS 583.85');
INSERT INTO synonym VALUES(2601,16,'Aphanomyces sp. MCA 3058');
INSERT INTO synonym VALUES(2602,16,'Aphanomyces sp. NJM 9510');
INSERT INTO synonym VALUES(2603,16,'Aphanomyces sp. 65');
INSERT INTO synonym VALUES(2604,16,'Aphanomyces sp. EBK-2013');
INSERT INTO synonym VALUES(2605,20,'Brevilegnia sp.');
INSERT INTO synonym VALUES(2606,25,'Halophytophthora sp. EMTS22');
INSERT INTO synonym VALUES(2607,25,'Halophytophthora sp. EMTS23');
INSERT INTO synonym VALUES(2608,25,'Halophytophthora sp. EMTS4');
INSERT INTO synonym VALUES(2609,25,'Halophytophthora sp. EMTS6');
INSERT INTO synonym VALUES(2610,25,'Halophytophthora sp. EMTS7');
INSERT INTO synonym VALUES(2611,25,'Halophytophthora sp. EMTS8');
INSERT INTO synonym VALUES(2612,25,'Halophytophthora sp. YJC-2014');
INSERT INTO synonym VALUES(2613,25,'Halophytophthora sp. GHJ-2017a');
INSERT INTO synonym VALUES(2614,25,'Halophytophthora sp. GHJ-2017b');
INSERT INTO synonym VALUES(2615,25,'Halophytophthora sp.');
INSERT INTO synonym VALUES(2616,25,'Halophytophthora sp. P7666');
INSERT INTO synonym VALUES(2617,25,'Halophytophthora sp. P7667');
INSERT INTO synonym VALUES(2618,25,'Halophytophthora sp. P7892');
INSERT INTO synonym VALUES(2619,25,'Halophytophthora sp. P7893');
INSERT INTO synonym VALUES(2620,25,'Halophytophthora sp. 1 KC-2014');
INSERT INTO synonym VALUES(2621,25,'Halophytophthora sp. 2 KC-2014');
INSERT INTO synonym VALUES(2622,25,'Halophytophthora sp. 3 KC-2014');
INSERT INTO synonym VALUES(2623,25,'Halophytophthora sp. WA26-091603');
INSERT INTO synonym VALUES(2624,25,'Halophytophthora sp. P15740');
INSERT INTO synonym VALUES(2625,25,'Halophytophthora sp. P15746');
INSERT INTO synonym VALUES(2626,25,'Halophytophthora sp. P7846');
INSERT INTO synonym VALUES(2627,25,'Halophytophthora sp. LT6430');
INSERT INTO synonym VALUES(2628,25,'Halophytophthora sp. LT6465');
INSERT INTO synonym VALUES(2629,25,'Halophytophthora sp. P7166');
INSERT INTO synonym VALUES(2630,25,'Halophytophthora sp. NBRC 32444');
INSERT INTO synonym VALUES(2631,25,'Halophytophthora sp. NBRC 32445');
INSERT INTO synonym VALUES(2632,25,'Halophytophthora sp. Zostera');
INSERT INTO synonym VALUES(2633,25,'Halophytophthora sp. EMTD10');
INSERT INTO synonym VALUES(2634,25,'Halophytophthora sp. EMTD11');
INSERT INTO synonym VALUES(2635,25,'Halophytophthora sp. EMTD12');
INSERT INTO synonym VALUES(2636,25,'Halophytophthora sp. EMTD7');
INSERT INTO synonym VALUES(2637,25,'Halophytophthora sp. EMTS10');
INSERT INTO synonym VALUES(2638,25,'Halophytophthora sp. EMTS12');
INSERT INTO synonym VALUES(2639,25,'Halophytophthora sp. EMTS19');
INSERT INTO synonym VALUES(2640,25,'Halophytophthora sp. EMTS2');
INSERT INTO synonym VALUES(2641,25,'Halophytophthora sp. EMTS20');
INSERT INTO synonym VALUES(2642,25,'Halophytophthora sp. EMTS21');
INSERT INTO synonym VALUES(2643,25,'uncultured Halophytophthora');
INSERT INTO synonym VALUES(2644,27,'Haliphthoros sp. NJM 0034');
INSERT INTO synonym VALUES(2645,27,'Haliphthoros sp. NJM 0449');
INSERT INTO synonym VALUES(2646,27,'Haliphthoros sp.');
INSERT INTO synonym VALUES(2647,27,'Haliphthoros sp. NJM 0443');
INSERT INTO synonym VALUES(2648,27,'Haliphthoros sp. IPMB 1402');
INSERT INTO synonym VALUES(2649,27,'Haliphthoros sp. NJM 0143');
INSERT INTO synonym VALUES(2650,27,'Haliphthoros sp. NJM 0440');
INSERT INTO synonym VALUES(2651,27,'Haliphthoros sp. NJM 0535');
INSERT INTO synonym VALUES(2652,30,'Pseudoperonospora sp. D149');
INSERT INTO synonym VALUES(2653,30,'Pseudoperonospora sp. D190');
INSERT INTO synonym VALUES(2654,30,'Pseudoperonospora sp. D232');
INSERT INTO synonym VALUES(2655,30,'Pseudoperonospora sp. D265');
INSERT INTO synonym VALUES(2656,30,'Pseudoperonospora sp. NY425');
INSERT INTO synonym VALUES(2657,30,'Pseudoperonospora sp. NY440');
INSERT INTO synonym VALUES(2658,30,'Pseudoperonospora sp. NY461');
INSERT INTO synonym VALUES(2659,30,'Pseudoperonospora sp. U196');
INSERT INTO synonym VALUES(2660,30,'Pseudoperonospora sp. U201');
INSERT INTO synonym VALUES(2661,30,'Pseudoperonospora sp.');
INSERT INTO synonym VALUES(2662,30,'Pseudoperonospora sp. 21226');
INSERT INTO synonym VALUES(2663,30,'Pseudoperonospora sp. 22238');
INSERT INTO synonym VALUES(2664,30,'Pseudoperonospora sp. 23231');
INSERT INTO synonym VALUES(2665,30,'Pseudoperonospora sp. 24230');
INSERT INTO synonym VALUES(2666,32,'Basidiophora sp. 1 AS-2015');
INSERT INTO synonym VALUES(2667,32,'Basidiophora sp. 2 AS-2015');
INSERT INTO synonym VALUES(2668,32,'Basidiophora sp. 3 AS-2015');
INSERT INTO synonym VALUES(2669,32,'Basidiophora sp. 4 AS-2015');
INSERT INTO synonym VALUES(2670,32,'Basidiophora sp. 5 AS-2015');
INSERT INTO synonym VALUES(2671,32,'Basidiophora sp.');
INSERT INTO synonym VALUES(2672,35,'uncultured Hyaloperonospora');
INSERT INTO synonym VALUES(2673,35,'Hyaloperonospora sp. KUS-F25091');
INSERT INTO synonym VALUES(2674,35,'Hyaloperonospora sp. KUS-F24009');
INSERT INTO synonym VALUES(2675,35,'Hyaloperonospora sp.');
INSERT INTO synonym VALUES(2676,36,'Perofascia sp.');
INSERT INTO synonym VALUES(2677,37,'Peronosclerospora sp. YJC-2014');
INSERT INTO synonym VALUES(2678,37,'Peronosclerospora sp. YJC-2015');
INSERT INTO synonym VALUES(2679,37,'Peronosclerospora sp. ST-2011');
INSERT INTO synonym VALUES(2680,37,'Peronosclerospora sp. BRIP 46698A');
INSERT INTO synonym VALUES(2681,43,'Protoachlya sp. Argentina 3.1');
INSERT INTO synonym VALUES(2682,44,'Haptoglossa sp. SZ03');
INSERT INTO synonym VALUES(2683,44,'Haptoglossa sp. IMI#395179');
INSERT INTO synonym VALUES(2684,44,'Haptoglossa sp. UK');
INSERT INTO synonym VALUES(2685,44,'Haptoglossa sp. DM2 4/12');
INSERT INTO synonym VALUES(2686,44,'Haptoglossa sp. SL20');
INSERT INTO synonym VALUES(2687,44,'Haptoglossa sp. SL32');
INSERT INTO synonym VALUES(2688,44,'Haptoglossa sp. TK01');
INSERT INTO synonym VALUES(2689,44,'Haptoglossa sp. NI01');
INSERT INTO synonym VALUES(2690,44,'Haptoglossa sp. SZ01');
INSERT INTO synonym VALUES(2691,44,'Haptoglossa sp. KG01');
INSERT INTO synonym VALUES(2692,44,'Haptoglossa sp. KG02');
INSERT INTO synonym VALUES(2693,46,'Olpidiopsis sp. 4439');
INSERT INTO synonym VALUES(2694,47,'Diasporangium sp. CCD-2007');
INSERT INTO synonym VALUES(2695,48,'Myzocytiopsis sp. GPR-2013');
INSERT INTO synonym VALUES(2696,48,'Myzocytiopsis sp. venatrix');
INSERT INTO synonym VALUES(2697,50,'Sclerophthora sp.');
INSERT INTO synonym VALUES(2698,51,'Chlamydomyzium sp. SL02');
INSERT INTO synonym VALUES(2699,53,'Pustula sp. CU13');
INSERT INTO synonym VALUES(2700,53,'Pustula sp. CU24');
INSERT INTO synonym VALUES(2701,53,'Pustula sp. A76');
INSERT INTO synonym VALUES(2702,53,'Pustula sp. A72');
INSERT INTO synonym VALUES(2703,53,'Pustula sp. A19');
INSERT INTO synonym VALUES(2704,53,'Pustula sp. D158');
INSERT INTO synonym VALUES(2705,53,'Pustula sp. A69');
INSERT INTO synonym VALUES(2706,53,'Pustula sp. A91');
INSERT INTO synonym VALUES(2707,53,'Pustula sp. D178');
INSERT INTO synonym VALUES(2708,53,'Pustula sp. CU4');
INSERT INTO synonym VALUES(2709,53,'Pustula sp. HOH-HUH 880a');
INSERT INTO synonym VALUES(2710,53,'Pustula sp. HOH-HUH 880b');
INSERT INTO synonym VALUES(2711,53,'Pustula sp. HOH-HUH 936');
INSERT INTO synonym VALUES(2712,53,'Pustula sp. D179');
INSERT INTO synonym VALUES(2713,53,'Pustula sp. A71');
INSERT INTO synonym VALUES(2714,53,'Pustula sp. A73');
INSERT INTO synonym VALUES(2715,53,'Pustula sp. D150');
INSERT INTO synonym VALUES(2716,53,'Pustula sp. D147');
INSERT INTO synonym VALUES(2717,53,'Pustula sp. A59');
INSERT INTO synonym VALUES(2718,53,'Pustula sp. D153');
INSERT INTO synonym VALUES(2719,53,'Pustula sp. D181');
INSERT INTO synonym VALUES(2720,53,'Pustula sp. D149');
INSERT INTO synonym VALUES(2721,53,'Pustula sp. A75');
INSERT INTO synonym VALUES(2722,53,'Pustula sp. D157');
INSERT INTO synonym VALUES(2723,53,'Pustula sp. A163b');
INSERT INTO synonym VALUES(2724,53,'Pustula sp. D177');
INSERT INTO synonym VALUES(2725,53,'Pustula sp. D155');
INSERT INTO synonym VALUES(2726,53,'Pustula sp. A60');
INSERT INTO synonym VALUES(2727,53,'Pustula sp. A50');
INSERT INTO synonym VALUES(2728,53,'Pustula sp. D146');
INSERT INTO synonym VALUES(2729,53,'Pustula sp. HOH-HUH 679');
INSERT INTO synonym VALUES(2730,53,'Pustula sp. A30-1');
INSERT INTO synonym VALUES(2731,53,'Pustula sp. D180');
INSERT INTO synonym VALUES(2732,53,'Pustula sp. A81');
INSERT INTO synonym VALUES(2733,53,'Pustula sp. LdT-2014');
INSERT INTO synonym VALUES(2734,55,'Phytopythium sp. 1 ROH-2015');
INSERT INTO synonym VALUES(2735,55,'Phytopythium sp. CAL-2011b');
INSERT INTO synonym VALUES(2736,55,'Phytopythium sp.');
INSERT INTO synonym VALUES(2737,55,'Phytopythium sp. 2 NS-2020');
INSERT INTO synonym VALUES(2738,55,'Phytopythium sp. 3 NS-2020');
INSERT INTO synonym VALUES(2739,55,'Phytopythium sp. B57');
INSERT INTO synonym VALUES(2740,55,'Phytopythium sp. D37');
INSERT INTO synonym VALUES(2741,55,'Phytopythium sp. F65');
INSERT INTO synonym VALUES(2742,55,'Phytopythium sp. AQ-2017a');
INSERT INTO synonym VALUES(2743,55,'Phytopythium sp. BOLD:AAO6860');
INSERT INTO synonym VALUES(2744,55,'Phytopythium sp. 1 PB-2013');
INSERT INTO synonym VALUES(2745,55,'Phytopythium sp. 2 PB-2013');
INSERT INTO synonym VALUES(2746,55,'Phytopythium sp. 3 PB-2013');
INSERT INTO synonym VALUES(2747,55,'Phytopythium sp. MNS-2014a');
INSERT INTO synonym VALUES(2748,55,'Phytopythium sp. ''sterile''');
INSERT INTO synonym VALUES(2749,55,'Phytopythium sp. MAB-2014');
INSERT INTO synonym VALUES(2750,55,'Phytopythium sp. 1 JJC-2018');
INSERT INTO synonym VALUES(2751,55,'Phytopythium sp. HSR-2011');
INSERT INTO synonym VALUES(2752,55,'Phytopythium sp. ConDao');
INSERT INTO synonym VALUES(2753,55,'Phytopythium sp. UZ248');
INSERT INTO synonym VALUES(2754,55,'Phytopythium sp. SL-2017a');
INSERT INTO synonym VALUES(2755,55,'Phytopythium sp. UZ612');
INSERT INTO synonym VALUES(2756,55,'Phytopythium sp. EVC-2015');
INSERT INTO synonym VALUES(2757,55,'Phytopythium sp. EBK-2013');
INSERT INTO synonym VALUES(2758,56,'Pythiogeton sp.');
INSERT INTO synonym VALUES(2759,56,'Pythiogeton sp. BV1');
INSERT INTO synonym VALUES(2760,57,'Salisapilia sp. LT6471');
INSERT INTO synonym VALUES(2761,57,'Salisapilia sp. LT6460');
INSERT INTO synonym VALUES(2762,57,'Salisapilia sp. LT6466');
INSERT INTO synonym VALUES(2763,60,'Paralagenidium sp.');
INSERT INTO synonym VALUES(2764,60,'Paralagenidium sp. C06-TW60');
INSERT INTO synonym VALUES(2765,60,'Paralagenidium sp. C09-TL95');
INSERT INTO synonym VALUES(2766,60,'Paralagenidium sp. 1391');
INSERT INTO synonym VALUES(2767,60,'Paralagenidium sp. MTLA-26');
INSERT INTO synonym VALUES(2768,61,'Elongisporangium sp. Hoang Lien');
INSERT INTO synonym VALUES(2769,62,'Globisporangium sp. MA-2018a');
INSERT INTO synonym VALUES(2770,62,'Globisporangium sp. MA-2018b');
INSERT INTO synonym VALUES(2771,62,'Globisporangium sp. MA-2018c');
INSERT INTO synonym VALUES(2772,62,'Globisporangium sp. KC-2014');
INSERT INTO synonym VALUES(2773,62,'Globisporangium sp.');
INSERT INTO synonym VALUES(2774,63,'Ovatisporangium sp. KC-2014');
INSERT INTO synonym VALUES(2775,63,'Ovatisporangium sp. 1 KC-2014');
INSERT INTO synonym VALUES(2776,63,'Ovatisporangium sp. 2 KC-2014');
INSERT INTO synonym VALUES(2777,67,'Pilasporangium sp.');
INSERT INTO synonym VALUES(2778,74,'Salispina sp.');
INSERT INTO synonym VALUES(2779,75,'Nothophytophthora sp. Chile5');
INSERT INTO synonym VALUES(2780,80,'[Olpidiopsis] porphyrae var. koreanae (nom. inval.)');
INSERT INTO synonym VALUES(2781,80,'[Olpidiopsis] porphyrae var. scotiae (nom. inval.)');
CREATE TABLE its1_source (
	id INTEGER NOT NULL, 
	source_accession VARCHAR, 
	source_id INTEGER, 
	its1_id INTEGER, 
	current_taxonomy_id INTEGER, 
	PRIMARY KEY (id), 
	FOREIGN KEY(source_id) REFERENCES data_source (id), 
	FOREIGN KEY(its1_id) REFERENCES its1_sequence (id), 
	FOREIGN KEY(current_taxonomy_id) REFERENCES taxonomy (id)
);
INSERT INTO its1_source VALUES(1,'Control_05',1,1,1192);
INSERT INTO its1_source VALUES(2,'Control_14',1,2,1193);
INSERT INTO its1_source VALUES(3,'Control_22',1,3,1194);
INSERT INTO its1_source VALUES(4,'Control_42',1,4,1195);
INSERT INTO its1_source VALUES(5,'88531412fbe9f8496ee2e80d1cbfa17d_19845',2,5,162);
INSERT INTO its1_source VALUES(6,'29c57fb8bb431163a028917e552a1259_44253',3,6,961);
INSERT INTO its1_source VALUES(7,'f48331c6566caa6da14adda9329f1d9a_8001',3,7,961);
INSERT INTO its1_source VALUES(8,'dd7e2a61f258d6befab1d2a55242e5e0_7159',3,8,961);
INSERT INTO its1_source VALUES(9,'d9bc3879fdab3b4184c04bfbb5cf6afb_47087',4,9,330);
INSERT INTO its1_source VALUES(10,'d9bc3879fdab3b4184c04bfbb5cf6afb_53370',5,9,330);
INSERT INTO its1_source VALUES(11,'688ca1f52e3ffeb2417adceff1011655_42963',6,10,292);
INSERT INTO its1_source VALUES(12,'259d50fc8098473b48ceacb48eb3ed99_27802',7,11,348);
INSERT INTO its1_source VALUES(13,'3d3fa2fd6fe0f183cad80771f5950b27_51849',8,12,342);
INSERT INTO its1_source VALUES(14,'f1d4c0432c89f005ec2b4e467839f5cc_53023',9,13,346);
INSERT INTO its1_source VALUES(15,'86faa3e6c55cb63348af05c3272a51ed_1360',9,14,346);
INSERT INTO its1_source VALUES(16,'f696591f997895f8ae62d4b9c44f4ccd_54499',10,15,241);
INSERT INTO its1_source VALUES(17,'8c593016c6c188d66817d7c0ada433d5_40764',11,16,827);
INSERT INTO its1_source VALUES(18,'ab082031f945cad0319dffaf35beade5_2154',12,17,75);
INSERT INTO its1_source VALUES(19,'04f98d2bf3f9dd49f7102ea1db7a128f_1409',12,18,75);
INSERT INTO its1_source VALUES(20,'ed44806393cfa394e5056fca15b45a5c_1208',12,19,75);
INSERT INTO its1_source VALUES(21,'d9bc3879fdab3b4184c04bfbb5cf6afb_3272',13,9,330);
INSERT INTO its1_source VALUES(22,'d9bc3879fdab3b4184c04bfbb5cf6afb_48944',14,9,330);
INSERT INTO its1_source VALUES(23,'d9bc3879fdab3b4184c04bfbb5cf6afb_3816',15,9,330);
INSERT INTO its1_source VALUES(24,'d9bc3879fdab3b4184c04bfbb5cf6afb_59358',16,9,330);
INSERT INTO its1_source VALUES(25,'d9bc3879fdab3b4184c04bfbb5cf6afb_48335',17,9,330);
INSERT INTO its1_source VALUES(26,'d9bc3879fdab3b4184c04bfbb5cf6afb_38102',18,9,330);
INSERT INTO its1_source VALUES(27,'d9bc3879fdab3b4184c04bfbb5cf6afb_3895',19,9,330);
INSERT INTO its1_source VALUES(28,'d9bc3879fdab3b4184c04bfbb5cf6afb_67258',20,9,330);
INSERT INTO its1_source VALUES(29,'ed15fefb7a3655147115fc28a8d6d671_29441',21,20,289);
INSERT INTO its1_source VALUES(30,'af46526f85cbf2d345d419a0f30e854a_4935',21,21,289);
INSERT INTO its1_source VALUES(31,'f65d8c80202d42fc17e32da2bb7f2858_2859',21,22,289);
INSERT INTO its1_source VALUES(32,'10ba08ab269b69142b6f83328e3e7099_2403',21,23,289);
INSERT INTO its1_source VALUES(33,'a012903e04863a4c2f904dee8dabc5cb_52929',22,24,331);
INSERT INTO its1_source VALUES(34,'a012903e04863a4c2f904dee8dabc5cb_57914',23,24,331);
INSERT INTO its1_source VALUES(35,'b1199a1082e563c9954dee14b4150557_29741',24,25,350);
INSERT INTO its1_source VALUES(36,'2e4f0ed53888ed39a2aee6d6d8e02206_45573',25,26,258);
INSERT INTO its1_source VALUES(37,'2e4f0ed53888ed39a2aee6d6d8e02206_35237',26,26,258);
INSERT INTO its1_source VALUES(38,'2e4f0ed53888ed39a2aee6d6d8e02206_71661',27,26,258);
INSERT INTO its1_source VALUES(39,'2e4f0ed53888ed39a2aee6d6d8e02206_71737',28,26,258);
INSERT INTO its1_source VALUES(40,'2e4f0ed53888ed39a2aee6d6d8e02206_52942',29,26,258);
INSERT INTO its1_source VALUES(41,'2e4f0ed53888ed39a2aee6d6d8e02206_61177',30,26,258);
INSERT INTO its1_source VALUES(42,'2e4f0ed53888ed39a2aee6d6d8e02206_66444',31,26,258);
INSERT INTO its1_source VALUES(43,'2e4f0ed53888ed39a2aee6d6d8e02206_47050',32,26,258);
INSERT INTO its1_source VALUES(44,'b3b684fc69437b76cc7921e2ed287dae_38271',33,27,279);
INSERT INTO its1_source VALUES(45,'12dc63e906f613f17219530896e88839_1716',33,28,279);
INSERT INTO its1_source VALUES(46,'c50b7fc6de0f1405b4388e95bdb01b4c_31373',34,29,345);
INSERT INTO its1_source VALUES(47,'18ab920ad62eb511ae7b88fdccec0e36_6832',34,30,345);
INSERT INTO its1_source VALUES(48,'d9bc3879fdab3b4184c04bfbb5cf6afb_70843',35,9,330);
INSERT INTO its1_source VALUES(49,'6bcdcba67f36c711c34f3a5ec368babb_29348',36,31,330);
INSERT INTO its1_source VALUES(50,'d343fb37b0b42e3533546d8cbae33048_27182',36,32,330);
INSERT INTO its1_source VALUES(51,'ed15fefb7a3655147115fc28a8d6d671_16943',37,20,289);
INSERT INTO its1_source VALUES(52,'10ba08ab269b69142b6f83328e3e7099_2581',37,23,289);
INSERT INTO its1_source VALUES(53,'af46526f85cbf2d345d419a0f30e854a_1784',37,21,289);
INSERT INTO its1_source VALUES(54,'ed15fefb7a3655147115fc28a8d6d671_8918',38,20,289);
INSERT INTO its1_source VALUES(55,'10ba08ab269b69142b6f83328e3e7099_5239',38,23,289);
INSERT INTO its1_source VALUES(56,'af46526f85cbf2d345d419a0f30e854a_2912',38,21,289);
INSERT INTO its1_source VALUES(57,'e827e3de506c4ff02217fde4a95bfa70_2100',38,33,289);
INSERT INTO its1_source VALUES(58,'602d96b1f4128367c10946522fe33269_2011',38,34,289);
INSERT INTO its1_source VALUES(59,'f65d8c80202d42fc17e32da2bb7f2858_1463',38,22,289);
INSERT INTO its1_source VALUES(60,'ed15fefb7a3655147115fc28a8d6d671_25259',39,20,289);
INSERT INTO its1_source VALUES(61,'af46526f85cbf2d345d419a0f30e854a_5453',39,21,289);
INSERT INTO its1_source VALUES(62,'e827e3de506c4ff02217fde4a95bfa70_1470',39,33,289);
INSERT INTO its1_source VALUES(63,'602d96b1f4128367c10946522fe33269_1253',39,34,289);
INSERT INTO its1_source VALUES(64,'2e4f0ed53888ed39a2aee6d6d8e02206_31423',40,26,258);
INSERT INTO its1_source VALUES(65,'2e4f0ed53888ed39a2aee6d6d8e02206_34919',41,26,258);
INSERT INTO its1_source VALUES(66,'88c30cd5198b5c00764cb64ead1ea822_2124',42,35,358);
INSERT INTO its1_source VALUES(67,'783143261c94eddc7a13630cd5ba33ee_21599',43,36,352);
INSERT INTO its1_source VALUES(68,'ed32541ef8addf4b146847ac02646b28_4248',43,37,352);
INSERT INTO its1_source VALUES(69,'681a00ee195ffe65ef3f2dfd47598653_1725',43,38,352);
INSERT INTO its1_source VALUES(70,'28c639a1150d8b7e4c6fba0e424e0271_1404',43,39,352);
INSERT INTO its1_source VALUES(71,'3c94d5e2cb0abf95075ee1a12aa129c8_1080',43,40,352);
INSERT INTO its1_source VALUES(72,'e6371979623484f3c17cb4805b8a3940_56868',44,41,347);
INSERT INTO its1_source VALUES(73,'7ac50609279c89c7fc3d88ffed426dac_60039',45,42,334);
INSERT INTO its1_source VALUES(74,'4b5e99f8fcd8d04270c10da2bf59020b_39296',46,43,249);
INSERT INTO its1_source VALUES(75,'a2ac9d97f7118c5cd7fa12880050a74a_2371',46,44,249);
INSERT INTO its1_source VALUES(76,'d8613e80b8803b13f7ea5d097f8fe46f_50581',47,45,264);
INSERT INTO its1_source VALUES(77,'f27df8e8755049e831b1ea4521ad6eb3_18661',48,46,427);
INSERT INTO its1_source VALUES(78,'f27df8e8755049e831b1ea4521ad6eb3_82968',49,46,427);
INSERT INTO its1_source VALUES(79,'fe1bd3a42e730f95c9fde798e32f8478_17520',50,47,360);
INSERT INTO its1_source VALUES(80,'fe1bd3a42e730f95c9fde798e32f8478_51270',51,47,360);
INSERT INTO its1_source VALUES(81,'8950417251c8298320f60deda691b35b_59649',52,48,432);
INSERT INTO its1_source VALUES(82,'a59091bd29e998d270db901e842e9bef_8567',53,49,210);
INSERT INTO its1_source VALUES(83,'29de890989becddc5e0b10ecbbc11b1a_48993',54,50,514);
INSERT INTO its1_source VALUES(84,'36ad9a45fa33397a67d7f6be02a39964_22242',55,51,255);
INSERT INTO its1_source VALUES(85,'24be91088cd4734b066a717bd2de041c_1741',55,52,255);
INSERT INTO its1_source VALUES(86,'7f3b213656cc5541bdcdf4692a3ed5bb_34240',56,53,349);
INSERT INTO its1_source VALUES(87,'d48d9e6e3548bfd92a88d1b46d19bde1_8304',56,54,349);
INSERT INTO its1_source VALUES(88,'7f3b213656cc5541bdcdf4692a3ed5bb_33739',57,53,349);
INSERT INTO its1_source VALUES(89,'d48d9e6e3548bfd92a88d1b46d19bde1_2857',57,54,349);
INSERT INTO its1_source VALUES(90,'8b835ab53506bff14285df6262625455_2854',57,55,349);
INSERT INTO its1_source VALUES(91,'76ca49ebff534e95634d75561c06cf23_1799',57,56,349);
INSERT INTO its1_source VALUES(92,'c971cc015791eec087271765b2b19cc3_32824',58,57,426);
INSERT INTO its1_source VALUES(93,'c79d286595a487be4d76cd8dd3bd384d_5940',58,58,426);
INSERT INTO its1_source VALUES(94,'5661d8e6ef0f1cc4e6cf61e4d7500fcb_1338',58,59,426);
INSERT INTO its1_source VALUES(95,'a7471bc623c89cef2d91a9d43df99579_65718',59,60,355);
INSERT INTO its1_source VALUES(96,'a7471bc623c89cef2d91a9d43df99579_50572',60,60,355);
INSERT INTO its1_source VALUES(97,'f27df8e8755049e831b1ea4521ad6eb3_39917',61,46,427);
INSERT INTO its1_source VALUES(98,'07874837d1d9a8477337081d921a38d4_134940',62,61,508);
INSERT INTO its1_source VALUES(99,'91bf0a26b1eb21d6e54ac6a814c62775_24316',62,62,508);
INSERT INTO its1_source VALUES(100,'0a61e6d1bd2525462225d081bea9c3ce_1055',62,63,508);
INSERT INTO its1_source VALUES(101,'ac00bb7b4811bcc240d374d8bf03cd72_34111',63,64,287);
INSERT INTO its1_source VALUES(102,'3efd1e21521baf83a4751ccd90d39421_5896',63,65,287);
INSERT INTO its1_source VALUES(103,'32159de6cbb6df37d084e31c37c30e7b_54273',64,66,212);
INSERT INTO its1_source VALUES(104,'32159de6cbb6df37d084e31c37c30e7b_28259',65,66,212);
INSERT INTO its1_source VALUES(105,'972db44c016a166de86a2bacab3f4226_11681',66,67,357);
INSERT INTO its1_source VALUES(106,'21d6308d89d74b8ed493d73a2cb4adb5_7364',66,68,357);
INSERT INTO its1_source VALUES(107,'99977bef41e2f50048e6c730637dc941_6189',66,69,357);
INSERT INTO its1_source VALUES(108,'301acf5db567b162de87ca69423a8440_4977',66,70,357);
INSERT INTO its1_source VALUES(109,'4ae6aaf0acd68944c1274608a7211df3_4387',66,71,357);
INSERT INTO its1_source VALUES(110,'366a3b698343fa24129a272f807ccf94_2548',66,72,357);
INSERT INTO its1_source VALUES(111,'d9e6de1308a8ac1448de351747d023c0_1674',66,73,357);
INSERT INTO its1_source VALUES(112,'f502b76965836568a0a113e2074879c8_1353',66,74,357);
INSERT INTO its1_source VALUES(113,'2843e160cc0859ffa1b6ac4f6ec7c508_1248',66,75,357);
INSERT INTO its1_source VALUES(114,'3d3f43d07f2d4dd63fe88aa3d6df9b52_31170',67,76,484);
INSERT INTO its1_source VALUES(115,'2e4f0ed53888ed39a2aee6d6d8e02206_64275',68,26,258);
INSERT INTO its1_source VALUES(116,'951ac00b20e25e3e1664a5edef2acb6c_37204',69,77,211);
INSERT INTO its1_source VALUES(117,'66abcf5b8d99d1570bd815e67442f666_23333',69,78,211);
INSERT INTO its1_source VALUES(118,'b3b684fc69437b76cc7921e2ed287dae_42327',70,27,279);
INSERT INTO its1_source VALUES(119,'12dc63e906f613f17219530896e88839_2218',70,28,279);
INSERT INTO its1_source VALUES(120,'ed15fefb7a3655147115fc28a8d6d671_13032',71,20,289);
INSERT INTO its1_source VALUES(121,'10ba08ab269b69142b6f83328e3e7099_6865',71,23,289);
INSERT INTO its1_source VALUES(122,'e827e3de506c4ff02217fde4a95bfa70_3750',71,33,289);
INSERT INTO its1_source VALUES(123,'af46526f85cbf2d345d419a0f30e854a_3594',71,21,289);
INSERT INTO its1_source VALUES(124,'602d96b1f4128367c10946522fe33269_2428',71,34,289);
INSERT INTO its1_source VALUES(125,'f65d8c80202d42fc17e32da2bb7f2858_2086',71,22,289);
INSERT INTO its1_source VALUES(126,'8b82f3e8bc9c3b11d34027df788ab8b9_1048',71,79,289);
INSERT INTO its1_source VALUES(127,'259d50fc8098473b48ceacb48eb3ed99_30485',72,11,348);
INSERT INTO its1_source VALUES(128,'4b639550662bfcf27f9face76af10d6b_6465',72,80,348);
INSERT INTO its1_source VALUES(129,'b88010d58905d035f845a320e18e00c3_1623',72,81,348);
INSERT INTO its1_source VALUES(130,'259d50fc8098473b48ceacb48eb3ed99_2164',73,11,348);
INSERT INTO its1_source VALUES(131,'259d50fc8098473b48ceacb48eb3ed99_37480',74,11,348);
INSERT INTO its1_source VALUES(132,'4b639550662bfcf27f9face76af10d6b_7494',74,80,348);
INSERT INTO its1_source VALUES(133,'b88010d58905d035f845a320e18e00c3_1863',74,81,348);
INSERT INTO its1_source VALUES(134,'259d50fc8098473b48ceacb48eb3ed99_38509',75,11,348);
INSERT INTO its1_source VALUES(135,'4b639550662bfcf27f9face76af10d6b_6206',75,80,348);
INSERT INTO its1_source VALUES(136,'b88010d58905d035f845a320e18e00c3_1575',75,81,348);
INSERT INTO its1_source VALUES(137,'259d50fc8098473b48ceacb48eb3ed99_42261',76,11,348);
INSERT INTO its1_source VALUES(138,'4b639550662bfcf27f9face76af10d6b_8442',76,80,348);
INSERT INTO its1_source VALUES(139,'b88010d58905d035f845a320e18e00c3_2055',76,81,348);
INSERT INTO its1_source VALUES(140,'259d50fc8098473b48ceacb48eb3ed99_45802',77,11,348);
INSERT INTO its1_source VALUES(141,'4b639550662bfcf27f9face76af10d6b_9102',77,80,348);
INSERT INTO its1_source VALUES(142,'b88010d58905d035f845a320e18e00c3_2213',77,81,348);
INSERT INTO its1_source VALUES(143,'259d50fc8098473b48ceacb48eb3ed99_22928',78,11,348);
INSERT INTO its1_source VALUES(144,'4b639550662bfcf27f9face76af10d6b_3800',78,80,348);
INSERT INTO its1_source VALUES(145,'259d50fc8098473b48ceacb48eb3ed99_42871',79,11,348);
INSERT INTO its1_source VALUES(146,'4b639550662bfcf27f9face76af10d6b_8628',79,80,348);
INSERT INTO its1_source VALUES(147,'b88010d58905d035f845a320e18e00c3_2141',79,81,348);
INSERT INTO its1_source VALUES(148,'259d50fc8098473b48ceacb48eb3ed99_52030',80,11,348);
INSERT INTO its1_source VALUES(149,'4b639550662bfcf27f9face76af10d6b_10261',80,80,348);
INSERT INTO its1_source VALUES(150,'b88010d58905d035f845a320e18e00c3_2544',80,81,348);
INSERT INTO its1_source VALUES(151,'ed15fefb7a3655147115fc28a8d6d671_15291',81,20,289);
INSERT INTO its1_source VALUES(152,'af46526f85cbf2d345d419a0f30e854a_3811',81,21,289);
INSERT INTO its1_source VALUES(153,'10ba08ab269b69142b6f83328e3e7099_1681',81,23,289);
INSERT INTO its1_source VALUES(154,'32159de6cbb6df37d084e31c37c30e7b_25991',82,66,212);
INSERT INTO its1_source VALUES(155,'AB217683.1',83,82,5);
INSERT INTO its1_source VALUES(156,'AB305060.1',83,83,5);
INSERT INTO its1_source VALUES(157,'AB305061.1',83,83,5);
INSERT INTO its1_source VALUES(158,'AB305062.1',83,83,5);
INSERT INTO its1_source VALUES(159,'AB305063.1',83,83,5);
INSERT INTO its1_source VALUES(160,'AB305064.1',83,83,5);
INSERT INTO its1_source VALUES(161,'AB305065.1',83,83,5);
INSERT INTO its1_source VALUES(162,'AB305066.1',83,46,5);
INSERT INTO its1_source VALUES(163,'AB355596.1',83,84,62);
INSERT INTO its1_source VALUES(164,'AB627346.1',83,85,55);
INSERT INTO its1_source VALUES(165,'AB627347.1',83,86,55);
INSERT INTO its1_source VALUES(166,'AB669142.1',83,60,5);
INSERT INTO its1_source VALUES(167,'AB688354.1',83,87,5);
INSERT INTO its1_source VALUES(168,'AB898680.1',83,88,35);
INSERT INTO its1_source VALUES(169,'AF087471.1',83,89,5);
INSERT INTO its1_source VALUES(170,'AF087472.1',83,90,5);
INSERT INTO its1_source VALUES(171,'AF087473.1',83,91,5);
INSERT INTO its1_source VALUES(172,'AF087474.1',83,92,5);
INSERT INTO its1_source VALUES(173,'AF087475.1',83,93,5);
INSERT INTO its1_source VALUES(174,'AF087476.1',83,89,5);
INSERT INTO its1_source VALUES(175,'AF087477.1',83,94,5);
INSERT INTO its1_source VALUES(176,'AF087478.1',83,95,5);
INSERT INTO its1_source VALUES(177,'AF087479.1',83,96,5);
INSERT INTO its1_source VALUES(178,'AF087480.1',83,97,5);
INSERT INTO its1_source VALUES(179,'AF241740.1',83,98,35);
INSERT INTO its1_source VALUES(180,'AF241741.1',83,98,35);
INSERT INTO its1_source VALUES(181,'AF241742.1',83,98,35);
INSERT INTO its1_source VALUES(182,'AF241743.1',83,98,35);
INSERT INTO its1_source VALUES(183,'AF241744.1',83,98,35);
INSERT INTO its1_source VALUES(184,'AF241745.1',83,98,35);
INSERT INTO its1_source VALUES(185,'AF241746.1',83,98,35);
INSERT INTO its1_source VALUES(186,'AF241747.1',83,98,35);
INSERT INTO its1_source VALUES(187,'AF241748.1',83,98,35);
INSERT INTO its1_source VALUES(188,'AF241749.1',83,98,35);
INSERT INTO its1_source VALUES(189,'AF241750.1',83,98,35);
INSERT INTO its1_source VALUES(190,'AF241751.1',83,98,35);
INSERT INTO its1_source VALUES(191,'AF241752.1',83,98,35);
INSERT INTO its1_source VALUES(192,'AF241753.1',83,99,35);
INSERT INTO its1_source VALUES(193,'AF241754.1',83,99,35);
INSERT INTO its1_source VALUES(194,'AF241755.1',83,99,35);
INSERT INTO its1_source VALUES(195,'AF241756.1',83,99,35);
INSERT INTO its1_source VALUES(196,'AF241757.1',83,99,35);
INSERT INTO its1_source VALUES(197,'AF241758.1',83,99,35);
INSERT INTO its1_source VALUES(198,'AF241759.1',83,99,35);
INSERT INTO its1_source VALUES(199,'AF241760.1',83,99,35);
INSERT INTO its1_source VALUES(200,'AF241761.1',83,99,35);
INSERT INTO its1_source VALUES(201,'AF241762.1',83,99,35);
INSERT INTO its1_source VALUES(202,'AF241763.1',83,99,35);
INSERT INTO its1_source VALUES(203,'AF241764.1',83,99,35);
INSERT INTO its1_source VALUES(204,'AF241770.1',83,5,3);
INSERT INTO its1_source VALUES(205,'AF528556.1',83,100,9);
INSERT INTO its1_source VALUES(206,'AF528557.1',83,100,9);
INSERT INTO its1_source VALUES(207,'AF528558.1',83,101,9);
INSERT INTO its1_source VALUES(208,'AF528559.1',83,102,9);
INSERT INTO its1_source VALUES(209,'AF528560.1',83,103,9);
INSERT INTO its1_source VALUES(210,'AF528561.1',83,104,9);
INSERT INTO its1_source VALUES(211,'AF528562.1',83,104,9);
INSERT INTO its1_source VALUES(212,'AF528563.1',83,104,9);
INSERT INTO its1_source VALUES(213,'AF528564.1',83,105,9);
INSERT INTO its1_source VALUES(214,'AJ007040.1',83,106,5);
INSERT INTO its1_source VALUES(215,'AJ007368.1',83,107,5);
INSERT INTO its1_source VALUES(216,'AJ007369.1',83,108,5);
INSERT INTO its1_source VALUES(217,'AJ007370.1',83,109,5);
INSERT INTO its1_source VALUES(218,'AJ299733.1',83,110,5);
INSERT INTO its1_source VALUES(219,'AJ299734.1',83,111,5);
INSERT INTO its1_source VALUES(220,'AJ555612.1',83,29,5);
INSERT INTO its1_source VALUES(221,'AJ628985.1',83,112,62);
INSERT INTO its1_source VALUES(222,'AJ628986.1',83,113,62);
INSERT INTO its1_source VALUES(223,'AJ854284.1',83,29,5);
INSERT INTO its1_source VALUES(224,'AJ854285.1',83,29,5);
INSERT INTO its1_source VALUES(225,'AJ854288.1',83,46,5);
INSERT INTO its1_source VALUES(226,'AJ854289.1',83,46,5);
INSERT INTO its1_source VALUES(227,'AJ854290.1',83,46,5);
INSERT INTO its1_source VALUES(228,'AJ854291.1',83,11,5);
INSERT INTO its1_source VALUES(229,'AJ854292.1',83,11,5);
INSERT INTO its1_source VALUES(230,'AJ854293.1',83,11,5);
INSERT INTO its1_source VALUES(231,'AJ854295.1',83,114,5);
INSERT INTO its1_source VALUES(232,'AJ854297.1',83,66,5);
INSERT INTO its1_source VALUES(233,'AJ854298.1',83,66,5);
INSERT INTO its1_source VALUES(234,'AJ854300.1',83,13,5);
INSERT INTO its1_source VALUES(235,'AJ854301.1',83,115,5);
INSERT INTO its1_source VALUES(236,'AJ854302.1',83,116,5);
INSERT INTO its1_source VALUES(237,'AM235209.1',83,117,5);
INSERT INTO its1_source VALUES(238,'AM422703.1',83,118,5);
INSERT INTO its1_source VALUES(239,'AM422704.1',83,60,5);
INSERT INTO its1_source VALUES(240,'AY191003.1',83,119,55);
INSERT INTO its1_source VALUES(241,'AY198240.3',83,120,9);
INSERT INTO its1_source VALUES(242,'AY198246.3',83,121,9);
INSERT INTO its1_source VALUES(243,'AY198250.3',83,122,35);
INSERT INTO its1_source VALUES(244,'AY198253.3',83,123,35);
INSERT INTO its1_source VALUES(245,'AY198293.3',83,124,9);
INSERT INTO its1_source VALUES(246,'AY198296.3',83,125,9);
INSERT INTO its1_source VALUES(247,'AY198298.3',83,126,9);
INSERT INTO its1_source VALUES(248,'AY198300.3',83,127,9);
INSERT INTO its1_source VALUES(249,'AY198301.3',83,128,9);
INSERT INTO its1_source VALUES(250,'AY198306.3',83,129,30);
INSERT INTO its1_source VALUES(251,'AY210983.1',83,130,35);
INSERT INTO its1_source VALUES(252,'AY210984.1',83,131,35);
INSERT INTO its1_source VALUES(253,'AY210985.1',83,132,35);
INSERT INTO its1_source VALUES(254,'AY210986.1',83,133,35);
INSERT INTO its1_source VALUES(255,'AY210987.1',83,134,35);
INSERT INTO its1_source VALUES(256,'AY210988.1',83,135,35);
INSERT INTO its1_source VALUES(257,'AY210989.1',83,136,35);
INSERT INTO its1_source VALUES(258,'AY210990.1',83,137,35);
INSERT INTO its1_source VALUES(259,'AY210991.1',83,137,35);
INSERT INTO its1_source VALUES(260,'AY210992.1',83,137,35);
INSERT INTO its1_source VALUES(261,'AY210993.1',83,137,35);
INSERT INTO its1_source VALUES(262,'AY210994.1',83,138,35);
INSERT INTO its1_source VALUES(263,'AY210995.1',83,139,35);
INSERT INTO its1_source VALUES(264,'AY210996.1',83,139,35);
INSERT INTO its1_source VALUES(265,'AY210997.1',83,140,35);
INSERT INTO its1_source VALUES(266,'AY210998.1',83,141,35);
INSERT INTO its1_source VALUES(267,'AY210999.1',83,142,35);
INSERT INTO its1_source VALUES(268,'AY211000.1',83,143,35);
INSERT INTO its1_source VALUES(269,'AY211001.1',83,144,35);
INSERT INTO its1_source VALUES(270,'AY211002.1',83,145,35);
INSERT INTO its1_source VALUES(271,'AY211003.1',83,146,35);
INSERT INTO its1_source VALUES(272,'AY211004.1',83,147,35);
INSERT INTO its1_source VALUES(273,'AY211005.1',83,147,35);
INSERT INTO its1_source VALUES(274,'AY211006.1',83,148,35);
INSERT INTO its1_source VALUES(275,'AY211007.1',83,149,35);
INSERT INTO its1_source VALUES(276,'AY211008.1',83,150,35);
INSERT INTO its1_source VALUES(277,'AY211009.1',83,151,35);
INSERT INTO its1_source VALUES(278,'AY211010.1',83,152,35);
INSERT INTO its1_source VALUES(279,'AY211011.1',83,153,36);
INSERT INTO its1_source VALUES(280,'AY211012.1',83,154,36);
INSERT INTO its1_source VALUES(281,'AY211013.1',83,155,36);
INSERT INTO its1_source VALUES(282,'AY211014.1',83,156,36);
INSERT INTO its1_source VALUES(283,'AY211015.1',83,104,9);
INSERT INTO its1_source VALUES(284,'AY211016.1',83,104,9);
INSERT INTO its1_source VALUES(285,'AY211017.1',83,100,9);
INSERT INTO its1_source VALUES(286,'AY211018.1',83,101,9);
INSERT INTO its1_source VALUES(287,'AY211019.1',83,157,9);
INSERT INTO its1_source VALUES(288,'AY256844.1',83,158,5);
INSERT INTO its1_source VALUES(289,'AY277278.1',83,159,5);
INSERT INTO its1_source VALUES(290,'AY302142.1',83,13,5);
INSERT INTO its1_source VALUES(291,'AY302143.1',83,13,5);
INSERT INTO its1_source VALUES(292,'AY302144.1',83,13,5);
INSERT INTO its1_source VALUES(293,'AY302145.1',83,13,5);
INSERT INTO its1_source VALUES(294,'AY302146.1',83,13,5);
INSERT INTO its1_source VALUES(295,'AY302147.1',83,13,5);
INSERT INTO its1_source VALUES(296,'AY302150.1',83,95,5);
INSERT INTO its1_source VALUES(297,'AY302152.1',83,13,5);
INSERT INTO its1_source VALUES(298,'AY302153.1',83,13,5);
INSERT INTO its1_source VALUES(299,'AY302157.1',83,13,5);
INSERT INTO its1_source VALUES(300,'AY302161.1',83,13,5);
INSERT INTO its1_source VALUES(301,'AY302163.1',83,13,5);
INSERT INTO its1_source VALUES(302,'AY302166.1',83,13,5);
INSERT INTO its1_source VALUES(303,'AY302167.1',83,13,5);
INSERT INTO its1_source VALUES(304,'AY302168.1',83,13,5);
INSERT INTO its1_source VALUES(305,'AY302169.1',83,13,5);
INSERT INTO its1_source VALUES(306,'AY302170.1',83,13,5);
INSERT INTO its1_source VALUES(307,'AY302172.1',83,13,5);
INSERT INTO its1_source VALUES(308,'AY302173.1',83,13,5);
INSERT INTO its1_source VALUES(309,'AY302174.1',83,160,5);
INSERT INTO its1_source VALUES(310,'AY302175.1',83,13,5);
INSERT INTO its1_source VALUES(311,'AY302176.1',83,13,5);
INSERT INTO its1_source VALUES(312,'AY302178.1',83,13,5);
INSERT INTO its1_source VALUES(313,'AY302179.1',83,13,5);
INSERT INTO its1_source VALUES(314,'AY302180.1',83,13,5);
INSERT INTO its1_source VALUES(315,'AY302181.1',83,13,5);
INSERT INTO its1_source VALUES(316,'AY302182.1',83,13,5);
INSERT INTO its1_source VALUES(317,'AY310438.1',83,161,6);
INSERT INTO its1_source VALUES(318,'AY310440.1',83,112,62);
INSERT INTO its1_source VALUES(319,'AY332651.1',83,162,5);
INSERT INTO its1_source VALUES(320,'AY332652.1',83,162,5);
INSERT INTO its1_source VALUES(321,'AY332653.1',83,162,5);
INSERT INTO its1_source VALUES(322,'AY332654.1',83,162,5);
INSERT INTO its1_source VALUES(323,'AY366462.1',83,163,5);
INSERT INTO its1_source VALUES(324,'AY366463.1',83,163,5);
INSERT INTO its1_source VALUES(325,'AY375242.1',83,164,62);
INSERT INTO its1_source VALUES(326,'AY436638.1',83,165,5);
INSERT INTO its1_source VALUES(327,'AY525786.1',83,109,5);
INSERT INTO its1_source VALUES(328,'AY590267.1',83,78,5);
INSERT INTO its1_source VALUES(329,'AY590268.1',83,78,5);
INSERT INTO its1_source VALUES(330,'AY590270.1',83,77,5);
INSERT INTO its1_source VALUES(331,'AY590271.1',83,78,5);
INSERT INTO its1_source VALUES(332,'AY590272.1',83,77,5);
INSERT INTO its1_source VALUES(333,'AY590273.1',83,77,5);
INSERT INTO its1_source VALUES(334,'AY590274.1',83,78,5);
INSERT INTO its1_source VALUES(335,'AY590275.1',83,166,5);
INSERT INTO its1_source VALUES(336,'AY590276.1',83,78,5);
INSERT INTO its1_source VALUES(337,'AY590277.1',83,78,5);
INSERT INTO its1_source VALUES(338,'AY594197.1',83,167,5);
INSERT INTO its1_source VALUES(339,'AY594198.1',83,167,5);
INSERT INTO its1_source VALUES(340,'AY598639.2',83,168,62);
INSERT INTO its1_source VALUES(341,'AY598641.2',83,169,62);
INSERT INTO its1_source VALUES(342,'AY598642.2',83,170,62);
INSERT INTO its1_source VALUES(343,'AY598650.3',83,171,6);
INSERT INTO its1_source VALUES(344,'AY598652.2',83,172,6);
INSERT INTO its1_source VALUES(345,'AY598653.2',83,173,6);
INSERT INTO its1_source VALUES(346,'AY598655.2',83,174,62);
INSERT INTO its1_source VALUES(347,'AY598657.2',83,84,62);
INSERT INTO its1_source VALUES(348,'AY598658.2',83,175,62);
INSERT INTO its1_source VALUES(349,'AY598659.2',83,176,62);
INSERT INTO its1_source VALUES(350,'AY598660.2',83,177,62);
INSERT INTO its1_source VALUES(351,'AY598661.2',83,178,62);
INSERT INTO its1_source VALUES(352,'AY598662.2',83,179,55);
INSERT INTO its1_source VALUES(353,'AY598663.2',83,180,55);
INSERT INTO its1_source VALUES(354,'AY598664.2',83,181,55);
INSERT INTO its1_source VALUES(355,'AY598665.2',83,182,55);
INSERT INTO its1_source VALUES(356,'AY598666.2',83,183,55);
INSERT INTO its1_source VALUES(357,'AY598696.2',83,184,62);
INSERT INTO its1_source VALUES(358,'AY598697.2',83,185,62);
INSERT INTO its1_source VALUES(359,'AY598708.2',83,165,5);
INSERT INTO its1_source VALUES(360,'AY598709.2',83,186,62);
INSERT INTO its1_source VALUES(361,'AY598711.2',83,187,62);
INSERT INTO its1_source VALUES(362,'AY598712.2',83,188,6);
INSERT INTO its1_source VALUES(363,'AY684914.1',83,189,5);
INSERT INTO its1_source VALUES(364,'AY684915.1',83,190,5);
INSERT INTO its1_source VALUES(365,'AY684925.1',83,191,6);
INSERT INTO its1_source VALUES(366,'AY695806.1',83,192,9);
INSERT INTO its1_source VALUES(367,'AY695807.1',83,192,9);
INSERT INTO its1_source VALUES(368,'AY739021.1',83,193,5);
INSERT INTO its1_source VALUES(369,'AY745749.1',83,194,5);
INSERT INTO its1_source VALUES(370,'AY745750.1',83,60,5);
INSERT INTO its1_source VALUES(371,'AY745751.1',83,60,5);
INSERT INTO its1_source VALUES(372,'AY745752.1',83,195,5);
INSERT INTO its1_source VALUES(373,'AY753572.1',83,196,6);
INSERT INTO its1_source VALUES(374,'AY753573.1',83,197,62);
INSERT INTO its1_source VALUES(375,'AY753574.1',83,198,6);
INSERT INTO its1_source VALUES(376,'AY753575.1',83,199,6);
INSERT INTO its1_source VALUES(377,'AY964101.1',83,95,5);
INSERT INTO its1_source VALUES(378,'AY964102.1',83,200,5);
INSERT INTO its1_source VALUES(379,'AY987037.1',83,201,6);
INSERT INTO its1_source VALUES(380,'AY987038.1',83,202,62);
INSERT INTO its1_source VALUES(381,'AY995339.1',83,203,5);
INSERT INTO its1_source VALUES(382,'AY995341.1',83,204,5);
INSERT INTO its1_source VALUES(383,'AY995342.1',83,205,5);
INSERT INTO its1_source VALUES(384,'AY995343.1',83,206,5);
INSERT INTO its1_source VALUES(385,'AY995351.1',83,46,5);
INSERT INTO its1_source VALUES(386,'AY995355.1',83,207,5);
INSERT INTO its1_source VALUES(387,'AY995356.1',83,208,5);
INSERT INTO its1_source VALUES(388,'AY995360.1',83,209,5);
INSERT INTO its1_source VALUES(389,'AY995366.1',83,210,5);
INSERT INTO its1_source VALUES(390,'AY995367.1',83,211,5);
INSERT INTO its1_source VALUES(391,'AY995373.1',83,212,5);
INSERT INTO its1_source VALUES(392,'AY995376.1',83,46,5);
INSERT INTO its1_source VALUES(393,'AY995377.1',83,209,5);
INSERT INTO its1_source VALUES(394,'AY995378.1',83,46,5);
INSERT INTO its1_source VALUES(395,'AY995380.1',83,213,5);
INSERT INTO its1_source VALUES(396,'AY995385.1',83,214,5);
INSERT INTO its1_source VALUES(397,'AY995386.1',83,215,5);
INSERT INTO its1_source VALUES(398,'AY995389.1',83,214,5);
INSERT INTO its1_source VALUES(399,'AY995390.1',83,204,5);
INSERT INTO its1_source VALUES(400,'AY995391.1',83,214,5);
INSERT INTO its1_source VALUES(401,'AY995392.1',83,216,5);
INSERT INTO its1_source VALUES(402,'AY995395.1',83,212,5);
INSERT INTO its1_source VALUES(403,'AY995396.1',83,53,5);
INSERT INTO its1_source VALUES(404,'AY995399.1',83,217,5);
INSERT INTO its1_source VALUES(405,'AY995403.1',83,204,5);
INSERT INTO its1_source VALUES(406,'AY995405.1',83,218,5);
INSERT INTO its1_source VALUES(407,'AY995406.1',83,53,5);
INSERT INTO its1_source VALUES(408,'D86515.1',83,112,62);
INSERT INTO its1_source VALUES(409,'DQ067896.1',83,219,9);
INSERT INTO its1_source VALUES(410,'DQ067897.1',83,219,9);
INSERT INTO its1_source VALUES(411,'DQ168873.1',83,220,5);
INSERT INTO its1_source VALUES(412,'DQ173082.1',83,221,5);
INSERT INTO its1_source VALUES(413,'DQ202400.1',83,222,9);
INSERT INTO its1_source VALUES(414,'DQ235793.1',83,223,3);
INSERT INTO its1_source VALUES(415,'DQ235794.1',83,223,3);
INSERT INTO its1_source VALUES(416,'DQ235795.1',83,5,3);
INSERT INTO its1_source VALUES(417,'DQ235796.1',83,5,3);
INSERT INTO its1_source VALUES(418,'DQ235799.1',83,224,3);
INSERT INTO its1_source VALUES(419,'DQ235800.1',83,225,3);
INSERT INTO its1_source VALUES(420,'DQ995184.1',83,31,5);
INSERT INTO its1_source VALUES(421,'DQ995185.1',83,31,5);
INSERT INTO its1_source VALUES(422,'EF027353.1',83,226,5);
INSERT INTO its1_source VALUES(423,'EF055294.1',83,227,62);
INSERT INTO its1_source VALUES(424,'EF055298.1',83,228,62);
INSERT INTO its1_source VALUES(425,'EF064137.1',83,53,5);
INSERT INTO its1_source VALUES(426,'EF064138.1',83,41,5);
INSERT INTO its1_source VALUES(427,'EF126351.1',83,229,5);
INSERT INTO its1_source VALUES(428,'EF150860.1',83,13,5);
INSERT INTO its1_source VALUES(429,'EF150861.1',83,13,5);
INSERT INTO its1_source VALUES(430,'EF150862.1',83,230,5);
INSERT INTO its1_source VALUES(431,'EF150863.1',83,231,5);
INSERT INTO its1_source VALUES(432,'EF150865.1',83,13,5);
INSERT INTO its1_source VALUES(433,'EF150870.1',83,13,5);
INSERT INTO its1_source VALUES(434,'EF150871.1',83,13,5);
INSERT INTO its1_source VALUES(435,'EF150872.1',83,13,5);
INSERT INTO its1_source VALUES(436,'EF150874.1',83,160,5);
INSERT INTO its1_source VALUES(437,'EF150876.1',83,13,5);
INSERT INTO its1_source VALUES(438,'EF152508.1',83,232,6);
INSERT INTO its1_source VALUES(439,'EF152512.1',83,233,5);
INSERT INTO its1_source VALUES(440,'EF152514.1',83,234,5);
INSERT INTO its1_source VALUES(441,'EF152519.1',83,235,5);
INSERT INTO its1_source VALUES(442,'EF153666.1',83,236,9);
INSERT INTO its1_source VALUES(443,'EF153667.1',83,236,9);
INSERT INTO its1_source VALUES(444,'EF153668.1',83,236,9);
INSERT INTO its1_source VALUES(445,'EF153669.1',83,236,9);
INSERT INTO its1_source VALUES(446,'EF153670.1',83,236,9);
INSERT INTO its1_source VALUES(447,'EF153672.1',83,237,5);
INSERT INTO its1_source VALUES(448,'EF153673.1',83,237,5);
INSERT INTO its1_source VALUES(449,'EF153674.1',83,117,5);
INSERT INTO its1_source VALUES(450,'EF153677.1',83,238,6);
INSERT INTO its1_source VALUES(451,'EF174435.1',83,239,5);
INSERT INTO its1_source VALUES(452,'EF187913.1',83,190,5);
INSERT INTO its1_source VALUES(453,'EF187915.1',83,112,62);
INSERT INTO its1_source VALUES(454,'EF193212.1',83,235,5);
INSERT INTO its1_source VALUES(455,'EF193213.1',83,235,5);
INSERT INTO its1_source VALUES(456,'EF193214.1',83,235,5);
INSERT INTO its1_source VALUES(457,'EF193215.1',83,36,5);
INSERT INTO its1_source VALUES(458,'EF193216.1',83,235,5);
INSERT INTO its1_source VALUES(459,'EF193217.1',83,235,5);
INSERT INTO its1_source VALUES(460,'EF193218.1',83,235,5);
INSERT INTO its1_source VALUES(461,'EF193219.1',83,235,5);
INSERT INTO its1_source VALUES(462,'EF193220.1',83,235,5);
INSERT INTO its1_source VALUES(463,'EF193221.1',83,235,5);
INSERT INTO its1_source VALUES(464,'EF193222.1',83,235,5);
INSERT INTO its1_source VALUES(465,'EF193223.1',83,206,5);
INSERT INTO its1_source VALUES(466,'EF193224.1',83,235,5);
INSERT INTO its1_source VALUES(467,'EF193225.1',83,235,5);
INSERT INTO its1_source VALUES(468,'EF193226.1',83,97,5);
INSERT INTO its1_source VALUES(469,'EF193230.1',83,117,5);
INSERT INTO its1_source VALUES(470,'EF193231.1',83,240,5);
INSERT INTO its1_source VALUES(471,'EF193232.1',83,46,5);
INSERT INTO its1_source VALUES(472,'EF193234.1',83,235,5);
INSERT INTO its1_source VALUES(473,'EF193235.1',83,46,5);
INSERT INTO its1_source VALUES(474,'EF193236.1',83,240,5);
INSERT INTO its1_source VALUES(475,'EF193238.1',83,240,5);
INSERT INTO its1_source VALUES(476,'EF193239.1',83,235,5);
INSERT INTO its1_source VALUES(477,'EF213590.1',83,241,5);
INSERT INTO its1_source VALUES(478,'EF213591.1',83,53,5);
INSERT INTO its1_source VALUES(479,'EF213592.1',83,53,5);
INSERT INTO its1_source VALUES(480,'EF213593.1',83,242,5);
INSERT INTO its1_source VALUES(481,'EF213594.1',83,53,5);
INSERT INTO its1_source VALUES(482,'EF213595.1',83,20,5);
INSERT INTO its1_source VALUES(483,'EF213596.1',83,46,5);
INSERT INTO its1_source VALUES(484,'EF213597.1',83,46,5);
INSERT INTO its1_source VALUES(485,'EF213598.1',83,53,5);
INSERT INTO its1_source VALUES(486,'EF213599.1',83,20,5);
INSERT INTO its1_source VALUES(487,'EF213600.1',83,53,5);
INSERT INTO its1_source VALUES(488,'EF213601.1',83,20,5);
INSERT INTO its1_source VALUES(489,'EF213602.1',83,46,5);
INSERT INTO its1_source VALUES(490,'EF213604.1',83,243,5);
INSERT INTO its1_source VALUES(491,'EF213605.1',83,46,5);
INSERT INTO its1_source VALUES(492,'EF213606.1',83,46,5);
INSERT INTO its1_source VALUES(493,'EF213607.1',83,41,5);
INSERT INTO its1_source VALUES(494,'EF213608.1',83,36,5);
INSERT INTO its1_source VALUES(495,'EF213609.1',83,46,5);
INSERT INTO its1_source VALUES(496,'EF213610.1',83,46,5);
INSERT INTO its1_source VALUES(497,'EF213611.1',83,46,5);
INSERT INTO its1_source VALUES(498,'EF213612.1',83,53,5);
INSERT INTO its1_source VALUES(499,'EF213613.1',83,20,5);
INSERT INTO its1_source VALUES(500,'EF213614.1',83,46,5);
INSERT INTO its1_source VALUES(501,'EF213615.1',83,46,5);
INSERT INTO its1_source VALUES(502,'EF213616.1',83,66,5);
INSERT INTO its1_source VALUES(503,'EF213617.1',83,46,5);
INSERT INTO its1_source VALUES(504,'EF213618.1',83,46,5);
INSERT INTO its1_source VALUES(505,'EF213621.1',83,235,5);
INSERT INTO its1_source VALUES(506,'EF213622.1',83,244,5);
INSERT INTO its1_source VALUES(507,'EF213623.1',83,245,5);
INSERT INTO its1_source VALUES(508,'EF406101.1',83,165,5);
INSERT INTO its1_source VALUES(509,'EF406102.1',83,165,5);
INSERT INTO its1_source VALUES(510,'EF406103.1',83,165,5);
INSERT INTO its1_source VALUES(511,'EF418938.1',83,46,5);
INSERT INTO its1_source VALUES(512,'EF418939.1',83,46,5);
INSERT INTO its1_source VALUES(513,'EF418940.1',83,41,5);
INSERT INTO its1_source VALUES(514,'EF418941.1',83,46,5);
INSERT INTO its1_source VALUES(515,'EF418942.1',83,46,5);
INSERT INTO its1_source VALUES(516,'EF418944.1',83,246,5);
INSERT INTO its1_source VALUES(517,'EF418945.1',83,235,5);
INSERT INTO its1_source VALUES(518,'EF418946.1',83,235,5);
INSERT INTO its1_source VALUES(519,'EF418949.1',83,235,5);
INSERT INTO its1_source VALUES(520,'EF418950.1',83,235,5);
INSERT INTO its1_source VALUES(521,'EF418951.1',83,247,5);
INSERT INTO its1_source VALUES(522,'EF418952.1',83,46,5);
INSERT INTO its1_source VALUES(523,'EF452178.1',83,248,5);
INSERT INTO its1_source VALUES(524,'EF452179.1',83,249,5);
INSERT INTO its1_source VALUES(525,'EF452180.1',83,249,5);
INSERT INTO its1_source VALUES(526,'EF486691.1',83,67,5);
INSERT INTO its1_source VALUES(527,'EF486692.1',83,67,5);
INSERT INTO its1_source VALUES(528,'EF486693.1',83,67,5);
INSERT INTO its1_source VALUES(529,'EF490382.1',83,26,5);
INSERT INTO its1_source VALUES(530,'EF490383.1',83,235,5);
INSERT INTO its1_source VALUES(531,'EF490682.1',83,250,5);
INSERT INTO its1_source VALUES(532,'EF490683.1',83,250,5);
INSERT INTO its1_source VALUES(533,'EF490684.1',83,250,5);
INSERT INTO its1_source VALUES(534,'EF523386.1',83,250,5);
INSERT INTO its1_source VALUES(535,'EF523387.1',83,250,5);
INSERT INTO its1_source VALUES(536,'EF553487.2',83,251,32);
INSERT INTO its1_source VALUES(537,'EF553488.1',83,252,39);
INSERT INTO its1_source VALUES(538,'EF553489.1',83,252,39);
INSERT INTO its1_source VALUES(539,'EF553490.1',83,253,34);
INSERT INTO its1_source VALUES(540,'EF553491.1',83,254,34);
INSERT INTO its1_source VALUES(541,'EF553492.1',83,254,34);
INSERT INTO its1_source VALUES(542,'EF553493.1',83,254,34);
INSERT INTO its1_source VALUES(543,'EF553494.1',83,255,49);
INSERT INTO its1_source VALUES(544,'EF553495.1',83,5,3);
INSERT INTO its1_source VALUES(545,'EF553496.1',83,256,3);
INSERT INTO its1_source VALUES(546,'EF553497.1',83,257,3);
INSERT INTO its1_source VALUES(547,'EF553498.1',83,258,3);
INSERT INTO its1_source VALUES(548,'EF553499.1',83,259,3);
INSERT INTO its1_source VALUES(549,'EF553500.1',83,260,3);
INSERT INTO its1_source VALUES(550,'EF553501.1',83,261,3);
INSERT INTO its1_source VALUES(551,'EF553502.1',83,259,3);
INSERT INTO its1_source VALUES(552,'EF553503.1',83,262,3);
INSERT INTO its1_source VALUES(553,'EF553504.1',83,263,3);
INSERT INTO its1_source VALUES(554,'EF553505.1',83,264,3);
INSERT INTO its1_source VALUES(555,'EF553506.1',83,265,4);
INSERT INTO its1_source VALUES(556,'EF553507.1',83,266,4);
INSERT INTO its1_source VALUES(557,'EF553508.1',83,266,4);
INSERT INTO its1_source VALUES(558,'EF553509.1',83,267,4);
INSERT INTO its1_source VALUES(559,'EF553510.1',83,268,4);
INSERT INTO its1_source VALUES(560,'EF553511.1',83,269,4);
INSERT INTO its1_source VALUES(561,'EF553512.1',83,270,4);
INSERT INTO its1_source VALUES(562,'EF553513.1',83,270,4);
INSERT INTO its1_source VALUES(563,'EF553514.1',83,270,4);
INSERT INTO its1_source VALUES(564,'EF583438.1',83,271,62);
INSERT INTO its1_source VALUES(565,'EF583445.1',83,272,6);
INSERT INTO its1_source VALUES(566,'EU000062.1',83,53,5);
INSERT INTO its1_source VALUES(567,'EU000064.1',83,46,5);
INSERT INTO its1_source VALUES(568,'EU000066.1',83,46,5);
INSERT INTO its1_source VALUES(569,'EU000068.1',83,36,5);
INSERT INTO its1_source VALUES(570,'EU000069.1',83,46,5);
INSERT INTO its1_source VALUES(571,'EU000070.1',83,46,5);
INSERT INTO its1_source VALUES(572,'EU000071.1',83,41,5);
INSERT INTO its1_source VALUES(573,'EU000072.1',83,273,5);
INSERT INTO its1_source VALUES(574,'EU000073.1',83,274,5);
INSERT INTO its1_source VALUES(575,'EU000074.1',83,275,5);
INSERT INTO its1_source VALUES(576,'EU000080.1',83,276,5);
INSERT INTO its1_source VALUES(577,'EU000081.1',83,209,5);
INSERT INTO its1_source VALUES(578,'EU000082.1',83,277,5);
INSERT INTO its1_source VALUES(579,'EU000083.1',83,117,5);
INSERT INTO its1_source VALUES(580,'EU000085.1',83,53,5);
INSERT INTO its1_source VALUES(581,'EU000086.1',83,53,5);
INSERT INTO its1_source VALUES(582,'EU000087.1',83,278,5);
INSERT INTO its1_source VALUES(583,'EU000088.1',83,279,5);
INSERT INTO its1_source VALUES(584,'EU000091.1',83,280,5);
INSERT INTO its1_source VALUES(585,'EU000093.1',83,46,5);
INSERT INTO its1_source VALUES(586,'EU000095.1',83,46,5);
INSERT INTO its1_source VALUES(587,'EU000097.1',83,235,5);
INSERT INTO its1_source VALUES(588,'EU000098.1',83,64,5);
INSERT INTO its1_source VALUES(589,'EU000099.1',83,281,5);
INSERT INTO its1_source VALUES(590,'EU000100.1',83,209,5);
INSERT INTO its1_source VALUES(591,'EU000101.1',83,66,5);
INSERT INTO its1_source VALUES(592,'EU000104.1',83,46,5);
INSERT INTO its1_source VALUES(593,'EU000106.1',83,282,5);
INSERT INTO its1_source VALUES(594,'EU000107.1',83,20,5);
INSERT INTO its1_source VALUES(595,'EU000109.1',83,53,5);
INSERT INTO its1_source VALUES(596,'EU000110.1',83,20,5);
INSERT INTO its1_source VALUES(597,'EU000111.1',83,20,5);
INSERT INTO its1_source VALUES(598,'EU000112.1',83,46,5);
INSERT INTO its1_source VALUES(599,'EU000113.1',83,36,5);
INSERT INTO its1_source VALUES(600,'EU000114.1',83,235,5);
INSERT INTO its1_source VALUES(601,'EU000115.1',83,53,5);
INSERT INTO its1_source VALUES(602,'EU000116.1',83,53,5);
INSERT INTO its1_source VALUES(603,'EU000117.1',83,66,5);
INSERT INTO its1_source VALUES(604,'EU000118.1',83,235,5);
INSERT INTO its1_source VALUES(605,'EU000119.1',83,235,5);
INSERT INTO its1_source VALUES(606,'EU000120.1',83,41,5);
INSERT INTO its1_source VALUES(607,'EU000122.1',83,41,5);
INSERT INTO its1_source VALUES(608,'EU000123.1',83,41,5);
INSERT INTO its1_source VALUES(609,'EU000124.1',83,283,5);
INSERT INTO its1_source VALUES(610,'EU000125.1',83,245,5);
INSERT INTO its1_source VALUES(611,'EU000128.1',83,235,5);
INSERT INTO its1_source VALUES(612,'EU000129.1',83,235,5);
INSERT INTO its1_source VALUES(613,'EU000130.1',83,284,5);
INSERT INTO its1_source VALUES(614,'EU000131.1',83,284,5);
INSERT INTO its1_source VALUES(615,'EU000132.1',83,20,5);
INSERT INTO its1_source VALUES(616,'EU000133.1',83,285,5);
INSERT INTO its1_source VALUES(617,'EU000134.1',83,53,5);
INSERT INTO its1_source VALUES(618,'EU000135.1',83,235,5);
INSERT INTO its1_source VALUES(619,'EU000136.1',83,235,5);
INSERT INTO its1_source VALUES(620,'EU000137.1',83,53,5);
INSERT INTO its1_source VALUES(621,'EU000138.1',83,286,5);
INSERT INTO its1_source VALUES(622,'EU000139.1',83,194,5);
INSERT INTO its1_source VALUES(623,'EU000141.1',83,235,5);
INSERT INTO its1_source VALUES(624,'EU000142.1',83,235,5);
INSERT INTO its1_source VALUES(625,'EU000146.1',83,235,5);
INSERT INTO its1_source VALUES(626,'EU000148.1',83,53,5);
INSERT INTO its1_source VALUES(627,'EU000149.1',83,20,5);
INSERT INTO its1_source VALUES(628,'EU000150.1',83,53,5);
INSERT INTO its1_source VALUES(629,'EU000152.1',83,274,5);
INSERT INTO its1_source VALUES(630,'EU000153.1',83,53,5);
INSERT INTO its1_source VALUES(631,'EU000155.1',83,235,5);
INSERT INTO its1_source VALUES(632,'EU000159.1',83,235,5);
INSERT INTO its1_source VALUES(633,'EU000160.1',83,13,5);
INSERT INTO its1_source VALUES(634,'EU000161.1',83,53,5);
INSERT INTO its1_source VALUES(635,'EU000162.1',83,287,5);
INSERT INTO its1_source VALUES(636,'EU000163.1',83,235,5);
INSERT INTO its1_source VALUES(637,'EU000164.1',83,235,5);
INSERT INTO its1_source VALUES(638,'EU098125.1',83,53,5);
INSERT INTO its1_source VALUES(639,'EU106582.1',83,46,5);
INSERT INTO its1_source VALUES(640,'EU106583.1',83,46,5);
INSERT INTO its1_source VALUES(641,'EU106584.1',83,288,5);
INSERT INTO its1_source VALUES(642,'EU106585.1',83,235,5);
INSERT INTO its1_source VALUES(643,'EU106586.1',83,46,5);
INSERT INTO its1_source VALUES(644,'EU106587.1',83,53,5);
INSERT INTO its1_source VALUES(645,'EU106588.1',83,46,5);
INSERT INTO its1_source VALUES(646,'EU106589.1',83,46,5);
INSERT INTO its1_source VALUES(647,'EU106590.1',83,289,5);
INSERT INTO its1_source VALUES(648,'EU106592.1',83,235,5);
INSERT INTO its1_source VALUES(649,'EU109566.1',83,46,5);
INSERT INTO its1_source VALUES(650,'EU109567.1',83,46,5);
INSERT INTO its1_source VALUES(651,'EU109568.1',83,46,5);
INSERT INTO its1_source VALUES(652,'EU162760.1',83,290,62);
INSERT INTO its1_source VALUES(653,'EU162765.1',83,291,5);
INSERT INTO its1_source VALUES(654,'EU162767.1',83,292,62);
INSERT INTO its1_source VALUES(655,'EU169130.1',83,84,62);
INSERT INTO its1_source VALUES(656,'EU169133.1',83,293,5);
INSERT INTO its1_source VALUES(657,'EU169134.1',83,294,62);
INSERT INTO its1_source VALUES(658,'EU169136.1',83,295,5);
INSERT INTO its1_source VALUES(659,'EU194378.1',83,296,5);
INSERT INTO its1_source VALUES(660,'EU194379.1',83,20,5);
INSERT INTO its1_source VALUES(661,'EU194380.1',83,241,5);
INSERT INTO its1_source VALUES(662,'EU194381.1',83,53,5);
INSERT INTO its1_source VALUES(663,'EU194382.1',83,46,5);
INSERT INTO its1_source VALUES(664,'EU194383.1',83,53,5);
INSERT INTO its1_source VALUES(665,'EU194384.1',83,240,5);
INSERT INTO its1_source VALUES(666,'EU194385.1',83,53,5);
INSERT INTO its1_source VALUES(667,'EU194388.1',83,297,5);
INSERT INTO its1_source VALUES(668,'EU194389.1',83,24,5);
INSERT INTO its1_source VALUES(669,'EU194390.1',83,53,5);
INSERT INTO its1_source VALUES(670,'EU194392.1',83,46,5);
INSERT INTO its1_source VALUES(671,'EU194393.1',83,298,5);
INSERT INTO its1_source VALUES(672,'EU194394.1',83,41,5);
INSERT INTO its1_source VALUES(673,'EU194395.1',83,46,5);
INSERT INTO its1_source VALUES(674,'EU194396.1',83,235,5);
INSERT INTO its1_source VALUES(675,'EU194397.1',83,235,5);
INSERT INTO its1_source VALUES(676,'EU194398.1',83,299,5);
INSERT INTO its1_source VALUES(677,'EU194399.1',83,300,5);
INSERT INTO its1_source VALUES(678,'EU194400.1',83,300,5);
INSERT INTO its1_source VALUES(679,'EU194401.1',83,46,5);
INSERT INTO its1_source VALUES(680,'EU194402.1',83,245,5);
INSERT INTO its1_source VALUES(681,'EU194403.1',83,46,5);
INSERT INTO its1_source VALUES(682,'EU194404.1',83,46,5);
INSERT INTO its1_source VALUES(683,'EU194406.1',83,46,5);
INSERT INTO its1_source VALUES(684,'EU194407.1',83,46,5);
INSERT INTO its1_source VALUES(685,'EU194408.1',83,301,5);
INSERT INTO its1_source VALUES(686,'EU194409.1',83,235,5);
INSERT INTO its1_source VALUES(687,'EU194410.1',83,302,5);
INSERT INTO its1_source VALUES(688,'EU194411.1',83,286,5);
INSERT INTO its1_source VALUES(689,'EU194412.1',83,20,5);
INSERT INTO its1_source VALUES(690,'EU194413.1',83,235,5);
INSERT INTO its1_source VALUES(691,'EU194414.1',83,46,5);
INSERT INTO its1_source VALUES(692,'EU194415.1',83,303,5);
INSERT INTO its1_source VALUES(693,'EU194417.1',83,20,5);
INSERT INTO its1_source VALUES(694,'EU194418.1',83,235,5);
INSERT INTO its1_source VALUES(695,'EU194419.1',83,41,5);
INSERT INTO its1_source VALUES(696,'EU194420.1',83,46,5);
INSERT INTO its1_source VALUES(697,'EU194421.1',83,46,5);
INSERT INTO its1_source VALUES(698,'EU194422.1',83,46,5);
INSERT INTO its1_source VALUES(699,'EU194423.1',83,235,5);
INSERT INTO its1_source VALUES(700,'EU194425.1',83,117,5);
INSERT INTO its1_source VALUES(701,'EU194428.1',83,304,5);
INSERT INTO its1_source VALUES(702,'EU194429.1',83,305,5);
INSERT INTO its1_source VALUES(703,'EU194438.1',83,60,5);
INSERT INTO its1_source VALUES(704,'EU194439.1',83,66,5);
INSERT INTO its1_source VALUES(705,'EU194440.1',83,66,5);
INSERT INTO its1_source VALUES(706,'EU200238.1',83,11,5);
INSERT INTO its1_source VALUES(707,'EU200239.1',83,306,5);
INSERT INTO its1_source VALUES(708,'EU200240.1',83,307,5);
INSERT INTO its1_source VALUES(709,'EU200241.1',83,11,5);
INSERT INTO its1_source VALUES(710,'EU200242.1',83,308,5);
INSERT INTO its1_source VALUES(711,'EU200244.1',83,309,5);
INSERT INTO its1_source VALUES(712,'EU200245.1',83,310,5);
INSERT INTO its1_source VALUES(713,'EU200246.1',83,11,5);
INSERT INTO its1_source VALUES(714,'EU200247.1',83,11,5);
INSERT INTO its1_source VALUES(715,'EU200248.1',83,306,5);
INSERT INTO its1_source VALUES(716,'EU200249.1',83,311,5);
INSERT INTO its1_source VALUES(717,'EU200250.1',83,312,5);
INSERT INTO its1_source VALUES(718,'EU200251.1',83,313,5);
INSERT INTO its1_source VALUES(719,'EU200252.1',83,309,5);
INSERT INTO its1_source VALUES(720,'EU200253.1',83,314,5);
INSERT INTO its1_source VALUES(721,'EU200257.1',83,315,5);
INSERT INTO its1_source VALUES(722,'EU200261.1',83,315,5);
INSERT INTO its1_source VALUES(723,'EU200262.1',83,315,5);
INSERT INTO its1_source VALUES(724,'EU200264.1',83,11,5);
INSERT INTO its1_source VALUES(725,'EU200268.1',83,309,5);
INSERT INTO its1_source VALUES(726,'EU200269.1',83,11,5);
INSERT INTO its1_source VALUES(727,'EU200270.1',83,316,5);
INSERT INTO its1_source VALUES(728,'EU200272.1',83,315,5);
INSERT INTO its1_source VALUES(729,'EU200274.1',83,317,5);
INSERT INTO its1_source VALUES(730,'EU200276.1',83,313,5);
INSERT INTO its1_source VALUES(731,'EU200278.1',83,306,5);
INSERT INTO its1_source VALUES(732,'EU200280.1',83,309,5);
INSERT INTO its1_source VALUES(733,'EU200282.1',83,318,5);
INSERT INTO its1_source VALUES(734,'EU200284.1',83,319,5);
INSERT INTO its1_source VALUES(735,'EU200288.1',83,312,5);
INSERT INTO its1_source VALUES(736,'EU200289.1',83,320,5);
INSERT INTO its1_source VALUES(737,'EU200292.1',83,11,5);
INSERT INTO its1_source VALUES(738,'EU200293.1',83,317,5);
INSERT INTO its1_source VALUES(739,'EU200294.1',83,321,5);
INSERT INTO its1_source VALUES(740,'EU200296.1',83,11,5);
INSERT INTO its1_source VALUES(741,'EU200301.1',83,306,5);
INSERT INTO its1_source VALUES(742,'EU200302.1',83,317,5);
INSERT INTO its1_source VALUES(743,'EU200304.1',83,309,5);
INSERT INTO its1_source VALUES(744,'EU200307.1',83,306,5);
INSERT INTO its1_source VALUES(745,'EU200310.1',83,309,5);
INSERT INTO its1_source VALUES(746,'EU200316.1',83,322,5);
INSERT INTO its1_source VALUES(747,'EU200317.1',83,309,5);
INSERT INTO its1_source VALUES(748,'EU200318.1',83,322,5);
INSERT INTO its1_source VALUES(749,'EU200320.1',83,323,5);
INSERT INTO its1_source VALUES(750,'EU216567.1',83,309,5);
INSERT INTO its1_source VALUES(751,'EU216568.1',83,11,5);
INSERT INTO its1_source VALUES(752,'EU216569.1',83,315,5);
INSERT INTO its1_source VALUES(753,'EU216570.1',83,315,5);
INSERT INTO its1_source VALUES(754,'EU240049.1',83,165,5);
INSERT INTO its1_source VALUES(755,'EU240052.1',83,235,5);
INSERT INTO its1_source VALUES(756,'EU240059.1',83,235,5);
INSERT INTO its1_source VALUES(757,'EU240138.1',83,237,5);
INSERT INTO its1_source VALUES(758,'EU240177.1',83,237,5);
INSERT INTO its1_source VALUES(759,'EU240188.1',83,235,5);
INSERT INTO its1_source VALUES(760,'EU240189.1',83,235,5);
INSERT INTO its1_source VALUES(761,'EU240193.1',83,235,5);
INSERT INTO its1_source VALUES(762,'EU240194.1',83,235,5);
INSERT INTO its1_source VALUES(763,'EU244850.1',83,324,5);
INSERT INTO its1_source VALUES(764,'EU244851.1',83,66,5);
INSERT INTO its1_source VALUES(765,'EU244852.1',83,303,5);
INSERT INTO its1_source VALUES(766,'EU253560.1',83,325,62);
INSERT INTO its1_source VALUES(767,'EU257523.1',83,11,5);
INSERT INTO its1_source VALUES(768,'EU263905.1',83,235,5);
INSERT INTO its1_source VALUES(769,'EU263906.1',83,209,5);
INSERT INTO its1_source VALUES(770,'EU295529.1',83,192,9);
INSERT INTO its1_source VALUES(771,'EU334634.2',83,326,5);
INSERT INTO its1_source VALUES(772,'EU391654.1',83,327,9);
INSERT INTO its1_source VALUES(773,'EU419613.1',83,328,5);
INSERT INTO its1_source VALUES(774,'EU515167.1',83,329,5);
INSERT INTO its1_source VALUES(775,'EU515171.1',83,330,5);
INSERT INTO its1_source VALUES(776,'EU515173.1',83,60,5);
INSERT INTO its1_source VALUES(777,'EU644715.1',83,331,5);
INSERT INTO its1_source VALUES(778,'EU644720.1',83,332,5);
INSERT INTO its1_source VALUES(779,'EU644721.1',83,333,5);
INSERT INTO its1_source VALUES(780,'EU660054.1',83,129,30);
INSERT INTO its1_source VALUES(781,'EU662221.1',83,334,5);
INSERT INTO its1_source VALUES(782,'EU877748.1',83,240,5);
INSERT INTO its1_source VALUES(783,'EU915283.1',83,335,5);
INSERT INTO its1_source VALUES(784,'EU925375.1',83,204,5);
INSERT INTO its1_source VALUES(785,'EU925376.1',83,336,5);
INSERT INTO its1_source VALUES(786,'FJ215687.1',83,337,5);
INSERT INTO its1_source VALUES(787,'FJ361036.1',83,13,5);
INSERT INTO its1_source VALUES(788,'FJ361037.1',83,13,5);
INSERT INTO its1_source VALUES(789,'FJ384778.1',83,338,9);
INSERT INTO its1_source VALUES(790,'FJ595479.1',83,339,5);
INSERT INTO its1_source VALUES(791,'FJ842111.1',83,340,5);
INSERT INTO its1_source VALUES(792,'FJ849839.1',83,341,5);
INSERT INTO its1_source VALUES(793,'FJ873179.1',83,342,62);
INSERT INTO its1_source VALUES(794,'FN257934.1',83,343,5);
INSERT INTO its1_source VALUES(795,'FN257935.1',83,329,5);
INSERT INTO its1_source VALUES(796,'FN257936.1',83,343,5);
INSERT INTO its1_source VALUES(797,'FN257937.1',83,343,5);
INSERT INTO its1_source VALUES(798,'FN257938.1',83,343,5);
INSERT INTO its1_source VALUES(799,'FN257939.1',83,344,5);
INSERT INTO its1_source VALUES(800,'FN257940.1',83,343,5);
INSERT INTO its1_source VALUES(801,'FN547052.1',83,235,5);
INSERT INTO its1_source VALUES(802,'FN547055.1',83,235,5);
INSERT INTO its1_source VALUES(803,'GQ131800.1',83,60,5);
INSERT INTO its1_source VALUES(805,'GQ165531.1',83,346,6);
INSERT INTO its1_source VALUES(806,'GQ398157.1',83,347,5);
INSERT INTO its1_source VALUES(807,'GQ421459.1',83,348,9);
INSERT INTO its1_source VALUES(808,'GQ848201.1',83,349,5);
INSERT INTO its1_source VALUES(809,'GQ853880.1',83,204,5);
INSERT INTO its1_source VALUES(810,'GQ924478.1',83,60,5);
INSERT INTO its1_source VALUES(811,'GQ980052.1',83,350,6);
INSERT INTO its1_source VALUES(812,'GU011684.1',83,29,5);
INSERT INTO its1_source VALUES(813,'GU073387.1',83,351,5);
INSERT INTO its1_source VALUES(814,'GU073388.1',83,352,5);
INSERT INTO its1_source VALUES(815,'GU073389.1',83,353,5);
INSERT INTO its1_source VALUES(816,'GU073392.1',83,354,5);
INSERT INTO its1_source VALUES(817,'GU111584.1',83,355,5);
INSERT INTO its1_source VALUES(818,'GU111585.1',83,355,5);
INSERT INTO its1_source VALUES(819,'GU111586.1',83,60,5);
INSERT INTO its1_source VALUES(820,'GU111587.1',83,46,5);
INSERT INTO its1_source VALUES(821,'GU111588.1',83,240,5);
INSERT INTO its1_source VALUES(822,'GU111590.1',83,13,5);
INSERT INTO its1_source VALUES(823,'GU111591.1',83,13,5);
INSERT INTO its1_source VALUES(824,'GU111592.1',83,356,5);
INSERT INTO its1_source VALUES(825,'GU111593.1',83,13,5);
INSERT INTO its1_source VALUES(826,'GU111594.1',83,13,5);
INSERT INTO its1_source VALUES(827,'GU111595.1',83,13,5);
INSERT INTO its1_source VALUES(828,'GU111596.1',83,209,5);
INSERT INTO its1_source VALUES(829,'GU111598.1',83,357,5);
INSERT INTO its1_source VALUES(830,'GU111599.1',83,208,5);
INSERT INTO its1_source VALUES(831,'GU111600.1',83,358,5);
INSERT INTO its1_source VALUES(832,'GU111601.1',83,358,5);
INSERT INTO its1_source VALUES(833,'GU111602.1',83,358,5);
INSERT INTO its1_source VALUES(834,'GU111603.1',83,359,5);
INSERT INTO its1_source VALUES(835,'GU111604.1',83,360,5);
INSERT INTO its1_source VALUES(836,'GU111605.1',83,361,5);
INSERT INTO its1_source VALUES(837,'GU111606.1',83,362,5);
INSERT INTO its1_source VALUES(838,'GU111607.1',83,362,5);
INSERT INTO its1_source VALUES(839,'GU111608.1',83,363,5);
INSERT INTO its1_source VALUES(840,'GU111609.1',83,363,5);
INSERT INTO its1_source VALUES(841,'GU111610.1',83,364,5);
INSERT INTO its1_source VALUES(842,'GU111611.1',83,365,5);
INSERT INTO its1_source VALUES(843,'GU111612.1',83,366,5);
INSERT INTO its1_source VALUES(844,'GU111613.1',83,367,5);
INSERT INTO its1_source VALUES(845,'GU111614.1',83,367,5);
INSERT INTO its1_source VALUES(846,'GU111615.1',83,367,5);
INSERT INTO its1_source VALUES(847,'GU111616.1',83,368,5);
INSERT INTO its1_source VALUES(848,'GU111617.1',83,324,5);
INSERT INTO its1_source VALUES(849,'GU111618.1',83,368,5);
INSERT INTO its1_source VALUES(850,'GU111619.1',83,118,5);
INSERT INTO its1_source VALUES(851,'GU111620.1',83,118,5);
INSERT INTO its1_source VALUES(852,'GU111621.1',83,118,5);
INSERT INTO its1_source VALUES(853,'GU111622.1',83,118,5);
INSERT INTO its1_source VALUES(854,'GU111623.1',83,118,5);
INSERT INTO its1_source VALUES(855,'GU111624.1',83,369,5);
INSERT INTO its1_source VALUES(856,'GU111625.1',83,370,5);
INSERT INTO its1_source VALUES(857,'GU111626.1',83,371,5);
INSERT INTO its1_source VALUES(858,'GU111627.1',83,304,5);
INSERT INTO its1_source VALUES(859,'GU111628.1',83,304,5);
INSERT INTO its1_source VALUES(860,'GU111629.1',83,304,5);
INSERT INTO its1_source VALUES(861,'GU111630.1',83,304,5);
INSERT INTO its1_source VALUES(862,'GU111631.1',83,372,5);
INSERT INTO its1_source VALUES(863,'GU111632.1',83,304,5);
INSERT INTO its1_source VALUES(864,'GU111633.1',83,304,5);
INSERT INTO its1_source VALUES(865,'GU111634.1',83,29,5);
INSERT INTO its1_source VALUES(866,'GU111635.1',83,29,5);
INSERT INTO its1_source VALUES(867,'GU111636.1',83,29,5);
INSERT INTO its1_source VALUES(868,'GU111637.1',83,373,5);
INSERT INTO its1_source VALUES(869,'GU111638.1',83,29,5);
INSERT INTO its1_source VALUES(870,'GU111639.1',83,29,5);
INSERT INTO its1_source VALUES(871,'GU111640.1',83,29,5);
INSERT INTO its1_source VALUES(872,'GU111641.1',83,29,5);
INSERT INTO its1_source VALUES(873,'GU111642.1',83,374,5);
INSERT INTO its1_source VALUES(874,'GU111643.1',83,29,5);
INSERT INTO its1_source VALUES(875,'GU111644.1',83,375,5);
INSERT INTO its1_source VALUES(876,'GU111645.1',83,343,5);
INSERT INTO its1_source VALUES(877,'GU111646.1',83,60,5);
INSERT INTO its1_source VALUES(878,'GU111647.1',83,376,5);
INSERT INTO its1_source VALUES(879,'GU111648.1',83,60,5);
INSERT INTO its1_source VALUES(880,'GU111649.1',83,60,5);
INSERT INTO its1_source VALUES(881,'GU111650.1',83,60,5);
INSERT INTO its1_source VALUES(882,'GU111651.1',83,60,5);
INSERT INTO its1_source VALUES(883,'GU111652.1',83,60,5);
INSERT INTO its1_source VALUES(884,'GU111653.1',83,60,5);
INSERT INTO its1_source VALUES(885,'GU111654.1',83,377,5);
INSERT INTO its1_source VALUES(886,'GU111655.1',83,60,5);
INSERT INTO its1_source VALUES(887,'GU111656.1',83,60,5);
INSERT INTO its1_source VALUES(888,'GU111657.1',83,60,5);
INSERT INTO its1_source VALUES(889,'GU111658.1',83,60,5);
INSERT INTO its1_source VALUES(890,'GU111659.1',83,60,5);
INSERT INTO its1_source VALUES(891,'GU111660.1',83,60,5);
INSERT INTO its1_source VALUES(892,'GU111661.1',83,60,5);
INSERT INTO its1_source VALUES(893,'GU111662.1',83,60,5);
INSERT INTO its1_source VALUES(894,'GU111663.1',83,60,5);
INSERT INTO its1_source VALUES(895,'GU111664.1',83,60,5);
INSERT INTO its1_source VALUES(896,'GU111665.1',83,378,5);
INSERT INTO its1_source VALUES(897,'GU111666.1',83,25,5);
INSERT INTO its1_source VALUES(898,'GU111667.1',83,25,5);
INSERT INTO its1_source VALUES(899,'GU111668.1',83,25,5);
INSERT INTO its1_source VALUES(900,'GU111670.1',83,379,5);
INSERT INTO its1_source VALUES(901,'GU111671.1',83,25,5);
INSERT INTO its1_source VALUES(902,'GU111672.1',83,25,5);
INSERT INTO its1_source VALUES(903,'GU111673.1',83,25,5);
INSERT INTO its1_source VALUES(904,'GU111674.1',83,25,5);
INSERT INTO its1_source VALUES(905,'GU111675.1',83,25,5);
INSERT INTO its1_source VALUES(906,'GU111677.1',83,25,5);
INSERT INTO its1_source VALUES(907,'GU111678.1',83,25,5);
INSERT INTO its1_source VALUES(908,'GU111679.1',83,25,5);
INSERT INTO its1_source VALUES(909,'GU111680.1',83,25,5);
INSERT INTO its1_source VALUES(910,'GU111681.1',83,25,5);
INSERT INTO its1_source VALUES(911,'GU111682.1',83,25,5);
INSERT INTO its1_source VALUES(912,'GU111683.1',83,60,5);
INSERT INTO its1_source VALUES(913,'GU133065.1',83,37,5);
INSERT INTO its1_source VALUES(914,'GU133066.1',83,380,5);
INSERT INTO its1_source VALUES(915,'GU133067.1',83,381,5);
INSERT INTO its1_source VALUES(916,'GU133068.1',83,39,5);
INSERT INTO its1_source VALUES(917,'GU223372.1',83,382,5);
INSERT INTO its1_source VALUES(918,'GU233297.1',83,84,62);
INSERT INTO its1_source VALUES(919,'GU233300.1',83,383,62);
INSERT INTO its1_source VALUES(920,'GU564664.1',83,384,5);
INSERT INTO its1_source VALUES(921,'GU564665.1',83,118,5);
INSERT INTO its1_source VALUES(922,'GU564666.1',83,385,5);
INSERT INTO its1_source VALUES(923,'GU564667.1',83,118,5);
INSERT INTO its1_source VALUES(924,'GU583835.1',83,386,35);
INSERT INTO its1_source VALUES(925,'GU583836.1',83,386,35);
INSERT INTO its1_source VALUES(926,'GU583837.1',83,387,35);
INSERT INTO its1_source VALUES(927,'GU583838.1',83,388,35);
INSERT INTO its1_source VALUES(928,'GU583839.1',83,388,35);
INSERT INTO its1_source VALUES(929,'GU799635.1',83,13,5);
INSERT INTO its1_source VALUES(930,'GU799636.1',83,13,5);
INSERT INTO its1_source VALUES(931,'GU799637.1',83,13,5);
INSERT INTO its1_source VALUES(932,'GU799638.1',83,13,5);
INSERT INTO its1_source VALUES(933,'GU799639.1',83,389,5);
INSERT INTO its1_source VALUES(934,'GU799640.1',83,389,5);
INSERT INTO its1_source VALUES(935,'GU799641.1',83,390,5);
INSERT INTO its1_source VALUES(936,'GU799642.1',83,389,5);
INSERT INTO its1_source VALUES(937,'GU799643.1',83,391,5);
INSERT INTO its1_source VALUES(938,'GU799644.1',83,392,5);
INSERT INTO its1_source VALUES(939,'GU799645.1',83,393,5);
INSERT INTO its1_source VALUES(940,'GU799646.1',83,393,5);
INSERT INTO its1_source VALUES(941,'GU799647.1',83,394,5);
INSERT INTO its1_source VALUES(942,'GU799648.1',83,395,5);
INSERT INTO its1_source VALUES(943,'GU799649.1',83,396,5);
INSERT INTO its1_source VALUES(944,'GU931701.1',83,397,55);
INSERT INTO its1_source VALUES(945,'GU931702.1',83,25,5);
INSERT INTO its1_source VALUES(946,'GU992938.1',83,398,5);
INSERT INTO its1_source VALUES(947,'HE580280.1',83,399,5);
INSERT INTO its1_source VALUES(948,'HG007960.1',83,25,5);
INSERT INTO its1_source VALUES(949,'HM004217.1',83,400,5);
INSERT INTO its1_source VALUES(950,'HM004218.1',83,401,25);
INSERT INTO its1_source VALUES(951,'HM004219.1',83,237,5);
INSERT INTO its1_source VALUES(952,'HM004220.1',83,67,5);
INSERT INTO its1_source VALUES(953,'HM004221.1',83,402,5);
INSERT INTO its1_source VALUES(954,'HM004222.1',83,403,5);
INSERT INTO its1_source VALUES(955,'HM004223.1',83,404,5);
INSERT INTO its1_source VALUES(956,'HM004224.1',83,405,5);
INSERT INTO its1_source VALUES(957,'HM004225.1',83,406,5);
INSERT INTO its1_source VALUES(958,'HM004226.1',83,407,5);
INSERT INTO its1_source VALUES(959,'HM004227.1',83,245,5);
INSERT INTO its1_source VALUES(960,'HM004228.1',83,26,5);
INSERT INTO its1_source VALUES(961,'HM004229.1',83,66,5);
INSERT INTO its1_source VALUES(962,'HM004230.1',83,274,5);
INSERT INTO its1_source VALUES(963,'HM004231.1',83,20,5);
INSERT INTO its1_source VALUES(964,'HM004232.1',83,408,5);
INSERT INTO its1_source VALUES(965,'HM004233.1',83,46,5);
INSERT INTO its1_source VALUES(966,'HM004234.1',83,234,5);
INSERT INTO its1_source VALUES(967,'HM004511.1',83,409,41);
INSERT INTO its1_source VALUES(968,'HM004512.1',83,410,4);
INSERT INTO its1_source VALUES(969,'HM004513.1',83,266,4);
INSERT INTO its1_source VALUES(970,'HM134862.1',83,411,62);
INSERT INTO its1_source VALUES(971,'HM357616.1',83,412,5);
INSERT INTO its1_source VALUES(972,'HM357617.1',83,412,5);
INSERT INTO its1_source VALUES(973,'HM357618.1',83,412,5);
INSERT INTO its1_source VALUES(974,'HM357619.1',83,412,5);
INSERT INTO its1_source VALUES(975,'HM357620.1',83,413,5);
INSERT INTO its1_source VALUES(976,'HM357621.1',83,414,5);
INSERT INTO its1_source VALUES(977,'HM357622.1',83,415,5);
INSERT INTO its1_source VALUES(978,'HM357623.1',83,416,5);
INSERT INTO its1_source VALUES(979,'HM357624.1',83,417,5);
INSERT INTO its1_source VALUES(980,'HM357625.1',83,417,5);
INSERT INTO its1_source VALUES(981,'HM585360.1',83,418,5);
INSERT INTO its1_source VALUES(982,'HM585361.1',83,418,5);
INSERT INTO its1_source VALUES(983,'HM585362.1',83,418,5);
INSERT INTO its1_source VALUES(984,'HM585363.1',83,418,5);
INSERT INTO its1_source VALUES(985,'HM585364.1',83,418,5);
INSERT INTO its1_source VALUES(986,'HM585365.1',83,418,5);
INSERT INTO its1_source VALUES(987,'HM585366.1',83,418,5);
INSERT INTO its1_source VALUES(988,'HM585367.1',83,418,5);
INSERT INTO its1_source VALUES(989,'HM627524.1',83,419,5);
INSERT INTO its1_source VALUES(990,'HQ191483.1',83,11,5);
INSERT INTO its1_source VALUES(991,'HQ191485.1',83,420,5);
INSERT INTO its1_source VALUES(992,'HQ191487.1',83,421,5);
INSERT INTO its1_source VALUES(993,'HQ191488.1',83,11,5);
INSERT INTO its1_source VALUES(994,'HQ191489.1',83,11,5);
INSERT INTO its1_source VALUES(995,'HQ237477.1',83,399,5);
INSERT INTO its1_source VALUES(996,'HQ237478.1',83,399,5);
INSERT INTO its1_source VALUES(997,'HQ237479.1',83,422,5);
INSERT INTO its1_source VALUES(998,'HQ237480.1',83,399,5);
INSERT INTO its1_source VALUES(999,'HQ237481.1',83,399,5);
INSERT INTO its1_source VALUES(1000,'HQ237482.1',83,423,6);
INSERT INTO its1_source VALUES(1002,'HQ237484.1',83,425,55);
INSERT INTO its1_source VALUES(1003,'HQ237485.1',83,426,55);
INSERT INTO its1_source VALUES(1004,'HQ237486.1',83,427,62);
INSERT INTO its1_source VALUES(1005,'HQ446241.1',83,117,5);
INSERT INTO its1_source VALUES(1006,'HQ446242.1',83,428,5);
INSERT INTO its1_source VALUES(1007,'HQ446243.1',83,429,5);
INSERT INTO its1_source VALUES(1008,'HQ446244.1',83,117,5);
INSERT INTO its1_source VALUES(1009,'HQ446245.1',83,430,5);
INSERT INTO its1_source VALUES(1010,'HQ446246.1',83,429,5);
INSERT INTO its1_source VALUES(1011,'HQ636491.1',83,129,30);
INSERT INTO its1_source VALUES(1012,'HQ636492.1',83,129,30);
INSERT INTO its1_source VALUES(1013,'HQ636493.1',83,129,30);
INSERT INTO its1_source VALUES(1014,'HQ636494.1',83,431,30);
INSERT INTO its1_source VALUES(1015,'HQ636495.1',83,129,30);
INSERT INTO its1_source VALUES(1016,'HQ636496.1',83,129,30);
INSERT INTO its1_source VALUES(1017,'HQ636497.1',83,129,30);
INSERT INTO its1_source VALUES(1018,'HQ636498.1',83,432,30);
INSERT INTO its1_source VALUES(1019,'HQ636499.1',83,433,30);
INSERT INTO its1_source VALUES(1020,'HQ636500.1',83,434,30);
INSERT INTO its1_source VALUES(1021,'HQ636501.1',83,129,30);
INSERT INTO its1_source VALUES(1022,'HQ636502.1',83,435,30);
INSERT INTO its1_source VALUES(1023,'HQ636503.1',83,435,30);
INSERT INTO its1_source VALUES(1024,'HQ636504.1',83,436,30);
INSERT INTO its1_source VALUES(1025,'HQ636505.1',83,129,30);
INSERT INTO its1_source VALUES(1026,'HQ636506.1',83,129,30);
INSERT INTO its1_source VALUES(1027,'HQ636507.1',83,129,30);
INSERT INTO its1_source VALUES(1028,'HQ636508.1',83,437,30);
INSERT INTO its1_source VALUES(1029,'HQ636509.1',83,438,30);
INSERT INTO its1_source VALUES(1030,'HQ643373.2',83,439,55);
INSERT INTO its1_source VALUES(1031,'HQ643386.2',83,440,55);
INSERT INTO its1_source VALUES(1032,'HQ643388.2',83,179,55);
INSERT INTO its1_source VALUES(1033,'HQ643389.2',83,441,55);
INSERT INTO its1_source VALUES(1034,'HQ643396.2',83,442,55);
INSERT INTO its1_source VALUES(1035,'HQ643400.2',83,397,55);
INSERT INTO its1_source VALUES(1036,'HQ643443.2',83,443,6);
INSERT INTO its1_source VALUES(1037,'HQ643518.2',83,444,62);
INSERT INTO its1_source VALUES(1038,'HQ643721.2',83,168,62);
INSERT INTO its1_source VALUES(1039,'HQ643761.2',83,445,62);
INSERT INTO its1_source VALUES(1040,'HQ643772.2',83,446,62);
INSERT INTO its1_source VALUES(1041,'HQ643773.2',83,447,6);
INSERT INTO its1_source VALUES(1042,'HQ643778.2',83,448,6);
INSERT INTO its1_source VALUES(1043,'HQ643854.2',83,449,6);
INSERT INTO its1_source VALUES(1044,'HQ659668.1',83,60,5);
INSERT INTO its1_source VALUES(1045,'HQ681250.1',83,450,5);
INSERT INTO its1_source VALUES(1046,'HQ681251.1',83,451,5);
INSERT INTO its1_source VALUES(1047,'HQ730979.1',83,236,9);
INSERT INTO its1_source VALUES(1048,'HQ853456.1',83,452,55);
INSERT INTO its1_source VALUES(1049,'HQ853457.1',83,453,55);
INSERT INTO its1_source VALUES(1050,'HQ853458.1',83,452,55);
INSERT INTO its1_source VALUES(1051,'HQ853459.1',83,452,55);
INSERT INTO its1_source VALUES(1052,'HQ853461.1',83,454,55);
INSERT INTO its1_source VALUES(1053,'HQ853462.1',83,454,55);
INSERT INTO its1_source VALUES(1054,'HQ853463.1',83,453,55);
INSERT INTO its1_source VALUES(1055,'HQ875382.1',83,51,5);
INSERT INTO its1_source VALUES(1056,'HQ875383.1',83,51,5);
INSERT INTO its1_source VALUES(1057,'HQ875384.1',83,51,5);
INSERT INTO its1_source VALUES(1058,'HQ875386.1',83,455,5);
INSERT INTO its1_source VALUES(1059,'HQ875387.1',83,51,5);
INSERT INTO its1_source VALUES(1060,'HQ875388.1',83,51,5);
INSERT INTO its1_source VALUES(1061,'HQ875389.1',83,51,5);
INSERT INTO its1_source VALUES(1062,'HQ875390.1',83,51,5);
INSERT INTO its1_source VALUES(1063,'JF792536.1',83,456,5);
INSERT INTO its1_source VALUES(1064,'JF792538.1',83,457,5);
INSERT INTO its1_source VALUES(1065,'JF792539.1',83,458,5);
INSERT INTO its1_source VALUES(1066,'JF792540.1',83,25,5);
INSERT INTO its1_source VALUES(1067,'JF792541.1',83,25,5);
INSERT INTO its1_source VALUES(1068,'JF833941.1',83,13,5);
INSERT INTO its1_source VALUES(1069,'JF833942.1',83,13,5);
INSERT INTO its1_source VALUES(1070,'JF833943.1',83,13,5);
INSERT INTO its1_source VALUES(1071,'JF833944.1',83,13,5);
INSERT INTO its1_source VALUES(1072,'JF833945.1',83,13,5);
INSERT INTO its1_source VALUES(1073,'JF833946.1',83,13,5);
INSERT INTO its1_source VALUES(1074,'JF833947.1',83,13,5);
INSERT INTO its1_source VALUES(1075,'JF833948.1',83,13,5);
INSERT INTO its1_source VALUES(1076,'JF833949.1',83,13,5);
INSERT INTO its1_source VALUES(1077,'JF833954.1',83,67,5);
INSERT INTO its1_source VALUES(1079,'JF975613.1',83,459,35);
INSERT INTO its1_source VALUES(1080,'JF975614.1',83,460,35);
INSERT INTO its1_source VALUES(1081,'JN120097.1',83,461,5);
INSERT INTO its1_source VALUES(1082,'JN120134.1',83,462,5);
INSERT INTO its1_source VALUES(1083,'JN120148.1',83,463,5);
INSERT INTO its1_source VALUES(1084,'JN676898.1',83,464,5);
INSERT INTO its1_source VALUES(1085,'JN676899.1',83,464,5);
INSERT INTO its1_source VALUES(1086,'JN676900.1',83,464,5);
INSERT INTO its1_source VALUES(1087,'JN676901.1',83,235,5);
INSERT INTO its1_source VALUES(1088,'JN676902.1',83,464,5);
INSERT INTO its1_source VALUES(1089,'JN676903.1',83,464,5);
INSERT INTO its1_source VALUES(1090,'JN676904.1',83,235,5);
INSERT INTO its1_source VALUES(1091,'JN676906.1',83,464,5);
INSERT INTO its1_source VALUES(1092,'JN676907.1',83,46,5);
INSERT INTO its1_source VALUES(1093,'JN676908.1',83,46,5);
INSERT INTO its1_source VALUES(1094,'JN676910.1',83,465,5);
INSERT INTO its1_source VALUES(1095,'JN676911.1',83,466,5);
INSERT INTO its1_source VALUES(1096,'JN676912.1',83,467,5);
INSERT INTO its1_source VALUES(1097,'JN676914.1',83,467,5);
INSERT INTO its1_source VALUES(1098,'JN676915.1',83,467,5);
INSERT INTO its1_source VALUES(1099,'JN695787.1',83,468,62);
INSERT INTO its1_source VALUES(1100,'JN695789.1',83,469,62);
INSERT INTO its1_source VALUES(1101,'JN710016.1',83,235,5);
INSERT INTO its1_source VALUES(1102,'JN710017.1',83,13,5);
INSERT INTO its1_source VALUES(1103,'JN710018.1',83,66,5);
INSERT INTO its1_source VALUES(1104,'JN710019.1',83,67,5);
INSERT INTO its1_source VALUES(1105,'JN710020.1',83,26,5);
INSERT INTO its1_source VALUES(1106,'JN710021.1',83,470,55);
INSERT INTO its1_source VALUES(1107,'JN710022.1',83,402,5);
INSERT INTO its1_source VALUES(1108,'JN710023.1',83,240,5);
INSERT INTO its1_source VALUES(1109,'JN710024.1',83,20,5);
INSERT INTO its1_source VALUES(1110,'JN882274.1',83,471,9);
INSERT INTO its1_source VALUES(1111,'JQ354936.1',83,472,5);
INSERT INTO its1_source VALUES(1112,'JQ626594.1',83,406,5);
INSERT INTO its1_source VALUES(1113,'JQ626595.1',83,406,5);
INSERT INTO its1_source VALUES(1114,'JQ626596.1',83,408,5);
INSERT INTO its1_source VALUES(1115,'JQ626597.1',83,408,5);
INSERT INTO its1_source VALUES(1116,'JQ626598.1',83,408,5);
INSERT INTO its1_source VALUES(1117,'JQ626599.1',83,473,5);
INSERT INTO its1_source VALUES(1118,'JQ626600.1',83,406,5);
INSERT INTO its1_source VALUES(1119,'JQ626601.1',83,408,5);
INSERT INTO its1_source VALUES(1120,'JQ626602.1',83,474,5);
INSERT INTO its1_source VALUES(1121,'JQ626603.1',83,475,5);
INSERT INTO its1_source VALUES(1122,'JQ626604.1',83,406,5);
INSERT INTO its1_source VALUES(1123,'JQ626605.1',83,476,5);
INSERT INTO its1_source VALUES(1124,'JQ653034.1',83,402,5);
INSERT INTO its1_source VALUES(1125,'JQ745261.1',83,477,5);
INSERT INTO its1_source VALUES(1126,'JQ757060.1',83,478,5);
INSERT INTO its1_source VALUES(1127,'JQ898452.1',83,187,62);
INSERT INTO its1_source VALUES(1128,'JQ898453.1',83,479,62);
INSERT INTO its1_source VALUES(1129,'JQ898462.1',83,479,62);
INSERT INTO its1_source VALUES(1130,'JQ898465.1',83,480,55);
INSERT INTO its1_source VALUES(1131,'JQ898466.1',83,271,62);
INSERT INTO its1_source VALUES(1132,'JQ898468.1',83,481,62);
INSERT INTO its1_source VALUES(1133,'JQ898470.1',83,482,62);
INSERT INTO its1_source VALUES(1134,'JQ898471.1',83,175,62);
INSERT INTO its1_source VALUES(1135,'JQ898474.1',83,483,6);
INSERT INTO its1_source VALUES(1136,'JQ898477.1',83,484,62);
INSERT INTO its1_source VALUES(1137,'JQ898478.1',83,294,62);
INSERT INTO its1_source VALUES(1138,'JQ898479.1',83,485,55);
INSERT INTO its1_source VALUES(1139,'JQ917064.1',83,467,5);
INSERT INTO its1_source VALUES(1140,'JX049151.1',83,465,5);
INSERT INTO its1_source VALUES(1141,'JX094353.1',83,11,5);
INSERT INTO its1_source VALUES(1142,'JX134648.1',83,486,5);
INSERT INTO its1_source VALUES(1143,'JX155790.1',83,487,5);
INSERT INTO its1_source VALUES(1144,'JX155795.1',83,488,5);
INSERT INTO its1_source VALUES(1145,'JX315267.1',83,60,5);
INSERT INTO its1_source VALUES(1146,'JX315268.1',83,60,5);
INSERT INTO its1_source VALUES(1147,'JX315269.1',83,60,5);
INSERT INTO its1_source VALUES(1148,'JX315270.1',83,60,5);
INSERT INTO its1_source VALUES(1149,'JX315271.1',83,60,5);
INSERT INTO its1_source VALUES(1150,'JX458086.1',83,489,5);
INSERT INTO its1_source VALUES(1151,'JX535811.1',83,490,5);
INSERT INTO its1_source VALUES(1152,'JX683127.1',83,11,5);
INSERT INTO its1_source VALUES(1153,'JX978446.1',83,25,5);
INSERT INTO its1_source VALUES(1154,'JX978447.1',83,491,5);
INSERT INTO its1_source VALUES(1155,'JX996044.1',83,492,5);
INSERT INTO its1_source VALUES(1156,'JX996045.1',83,493,5);
INSERT INTO its1_source VALUES(1157,'JX996046.1',83,494,5);
INSERT INTO its1_source VALUES(1158,'JX996047.1',83,283,5);
INSERT INTO its1_source VALUES(1159,'JX996048.1',83,495,5);
INSERT INTO its1_source VALUES(1160,'JX996050.1',83,496,5);
INSERT INTO its1_source VALUES(1161,'KC136208.1',83,497,6);
INSERT INTO its1_source VALUES(1162,'KC146363.1',83,11,5);
INSERT INTO its1_source VALUES(1163,'KC146365.1',83,309,5);
INSERT INTO its1_source VALUES(1164,'KC184900.1',83,13,5);
INSERT INTO its1_source VALUES(1165,'KC184901.1',83,13,5);
INSERT INTO its1_source VALUES(1166,'KC184902.1',83,13,5);
INSERT INTO its1_source VALUES(1167,'KC184903.1',83,13,5);
INSERT INTO its1_source VALUES(1168,'KC184904.1',83,13,5);
INSERT INTO its1_source VALUES(1169,'KC248201.1',83,498,5);
INSERT INTO its1_source VALUES(1170,'KC248202.1',83,499,5);
INSERT INTO its1_source VALUES(1171,'KC311832.1',83,500,5);
INSERT INTO its1_source VALUES(1172,'KC311833.1',83,501,5);
INSERT INTO its1_source VALUES(1173,'KC311835.1',83,502,5);
INSERT INTO its1_source VALUES(1174,'KC311837.1',83,503,5);
INSERT INTO its1_source VALUES(1175,'KC311838.1',83,504,5);
INSERT INTO its1_source VALUES(1176,'KC335544.1',83,505,5);
INSERT INTO its1_source VALUES(1177,'KC335545.1',83,506,5);
INSERT INTO its1_source VALUES(1178,'KC335546.1',83,507,5);
INSERT INTO its1_source VALUES(1179,'KC335548.1',83,508,5);
INSERT INTO its1_source VALUES(1180,'KC335549.1',83,29,5);
INSERT INTO its1_source VALUES(1181,'KC335550.1',83,509,5);
INSERT INTO its1_source VALUES(1182,'KC335551.1',83,510,5);
INSERT INTO its1_source VALUES(1183,'KC347531.1',83,510,5);
INSERT INTO its1_source VALUES(1184,'KC414198.1',83,511,35);
INSERT INTO its1_source VALUES(1185,'KC415918.1',83,512,5);
INSERT INTO its1_source VALUES(1186,'KC415920.1',83,512,5);
INSERT INTO its1_source VALUES(1187,'KC438374.1',83,29,5);
INSERT INTO its1_source VALUES(1188,'KC438376.1',83,502,5);
INSERT INTO its1_source VALUES(1189,'KC438377.1',83,510,5);
INSERT INTO its1_source VALUES(1190,'KC529657.1',83,400,5);
INSERT INTO its1_source VALUES(1191,'KC594037.1',83,513,5);
INSERT INTO its1_source VALUES(1192,'KC602466.1',83,235,5);
INSERT INTO its1_source VALUES(1193,'KC602476.1',83,514,5);
INSERT INTO its1_source VALUES(1194,'KC602477.1',83,514,5);
INSERT INTO its1_source VALUES(1195,'KC602485.1',83,515,55);
INSERT INTO its1_source VALUES(1196,'KC602486.1',83,516,55);
INSERT INTO its1_source VALUES(1197,'KC602488.1',83,517,55);
INSERT INTO its1_source VALUES(1198,'KC602489.1',83,171,6);
INSERT INTO its1_source VALUES(1199,'KC602493.1',83,518,55);
INSERT INTO its1_source VALUES(1200,'KC602494.1',83,519,55);
INSERT INTO its1_source VALUES(1201,'KC602496.1',83,165,5);
INSERT INTO its1_source VALUES(1202,'KC677731.1',83,513,5);
INSERT INTO its1_source VALUES(1203,'KC677774.1',83,11,5);
INSERT INTO its1_source VALUES(1204,'KC677776.1',83,11,5);
INSERT INTO its1_source VALUES(1205,'KC677778.1',83,520,5);
INSERT INTO its1_source VALUES(1206,'KC677779.1',83,521,5);
INSERT INTO its1_source VALUES(1207,'KC677782.1',83,522,5);
INSERT INTO its1_source VALUES(1208,'KC677784.1',83,523,5);
INSERT INTO its1_source VALUES(1209,'KC677785.1',83,524,5);
INSERT INTO its1_source VALUES(1210,'KC677786.1',83,525,5);
INSERT INTO its1_source VALUES(1211,'KC677788.1',83,526,5);
INSERT INTO its1_source VALUES(1212,'KC677791.1',83,527,5);
INSERT INTO its1_source VALUES(1213,'KC677793.1',83,528,5);
INSERT INTO its1_source VALUES(1214,'KC677797.1',83,529,5);
INSERT INTO its1_source VALUES(1215,'KC677798.1',83,530,5);
INSERT INTO its1_source VALUES(1216,'KC677799.1',83,531,5);
INSERT INTO its1_source VALUES(1217,'KC677800.1',83,11,5);
INSERT INTO its1_source VALUES(1218,'KC677801.1',83,532,5);
INSERT INTO its1_source VALUES(1219,'KC677804.1',83,513,5);
INSERT INTO its1_source VALUES(1220,'KC677805.1',83,513,5);
INSERT INTO its1_source VALUES(1221,'KC677806.1',83,533,5);
INSERT INTO its1_source VALUES(1222,'KC677807.1',83,534,5);
INSERT INTO its1_source VALUES(1223,'KC677808.1',83,535,5);
INSERT INTO its1_source VALUES(1224,'KC677809.1',83,536,5);
INSERT INTO its1_source VALUES(1225,'KC677810.1',83,537,5);
INSERT INTO its1_source VALUES(1226,'KC677811.1',83,538,5);
INSERT INTO its1_source VALUES(1227,'KC677812.1',83,538,5);
INSERT INTO its1_source VALUES(1228,'KC677813.1',83,538,5);
INSERT INTO its1_source VALUES(1229,'KC677814.1',83,538,5);
INSERT INTO its1_source VALUES(1230,'KC677815.1',83,539,5);
INSERT INTO its1_source VALUES(1231,'KC677816.1',83,513,5);
INSERT INTO its1_source VALUES(1232,'KC677817.1',83,540,5);
INSERT INTO its1_source VALUES(1233,'KC677818.1',83,541,5);
INSERT INTO its1_source VALUES(1234,'KC677819.1',83,538,5);
INSERT INTO its1_source VALUES(1235,'KC677820.1',83,542,5);
INSERT INTO its1_source VALUES(1236,'KC677822.1',83,543,5);
INSERT INTO its1_source VALUES(1237,'KC677823.1',83,544,5);
INSERT INTO its1_source VALUES(1238,'KC677824.1',83,533,5);
INSERT INTO its1_source VALUES(1239,'KC677825.1',83,545,5);
INSERT INTO its1_source VALUES(1240,'KC677826.1',83,546,5);
INSERT INTO its1_source VALUES(1241,'KC677827.1',83,538,5);
INSERT INTO its1_source VALUES(1242,'KC677828.1',83,547,5);
INSERT INTO its1_source VALUES(1243,'KC677829.1',83,548,5);
INSERT INTO its1_source VALUES(1244,'KC677830.1',83,549,5);
INSERT INTO its1_source VALUES(1245,'KC677831.1',83,550,5);
INSERT INTO its1_source VALUES(1246,'KC677835.1',83,551,5);
INSERT INTO its1_source VALUES(1247,'KC677836.1',83,552,5);
INSERT INTO its1_source VALUES(1248,'KC677837.1',83,553,5);
INSERT INTO its1_source VALUES(1249,'KC677838.1',83,547,5);
INSERT INTO its1_source VALUES(1250,'KC677840.1',83,554,5);
INSERT INTO its1_source VALUES(1251,'KC677841.1',83,555,5);
INSERT INTO its1_source VALUES(1252,'KC677842.1',83,548,5);
INSERT INTO its1_source VALUES(1253,'KC677843.1',83,556,5);
INSERT INTO its1_source VALUES(1254,'KC677844.1',83,557,5);
INSERT INTO its1_source VALUES(1255,'KC677845.1',83,538,5);
INSERT INTO its1_source VALUES(1256,'KC677847.1',83,558,5);
INSERT INTO its1_source VALUES(1257,'KC677848.1',83,559,5);
INSERT INTO its1_source VALUES(1258,'KC677849.1',83,560,5);
INSERT INTO its1_source VALUES(1259,'KC677850.1',83,561,5);
INSERT INTO its1_source VALUES(1260,'KC677851.1',83,562,5);
INSERT INTO its1_source VALUES(1261,'KC677852.1',83,547,5);
INSERT INTO its1_source VALUES(1262,'KC695722.1',83,563,5);
INSERT INTO its1_source VALUES(1263,'KC695724.1',83,564,5);
INSERT INTO its1_source VALUES(1264,'KC768775.1',83,190,5);
INSERT INTO its1_source VALUES(1265,'KF010299.1',83,60,5);
INSERT INTO its1_source VALUES(1266,'KF010300.1',83,565,5);
INSERT INTO its1_source VALUES(1267,'KF010301.1',83,566,5);
INSERT INTO its1_source VALUES(1268,'KF010302.1',83,42,5);
INSERT INTO its1_source VALUES(1269,'KF010303.1',83,25,5);
INSERT INTO its1_source VALUES(1270,'KF010304.1',83,42,5);
INSERT INTO its1_source VALUES(1271,'KF010305.1',83,42,5);
INSERT INTO its1_source VALUES(1272,'KF010306.1',83,60,5);
INSERT INTO its1_source VALUES(1273,'KF010307.1',83,60,5);
INSERT INTO its1_source VALUES(1274,'KF010308.1',83,60,5);
INSERT INTO its1_source VALUES(1275,'KF010309.1',83,60,5);
INSERT INTO its1_source VALUES(1276,'KF110980.1',83,567,5);
INSERT INTO its1_source VALUES(1277,'KF147897.1',83,568,5);
INSERT INTO its1_source VALUES(1278,'KF147900.1',83,25,5);
INSERT INTO its1_source VALUES(1279,'KF147901.1',83,499,5);
INSERT INTO its1_source VALUES(1280,'KF181447.1',83,569,5);
INSERT INTO its1_source VALUES(1281,'KF181448.1',83,570,62);
INSERT INTO its1_source VALUES(1282,'KF181449.1',83,84,62);
INSERT INTO its1_source VALUES(1283,'KF181450.1',83,571,6);
INSERT INTO its1_source VALUES(1284,'KF181451.1',83,84,62);
INSERT INTO its1_source VALUES(1285,'KF181452.1',83,572,62);
INSERT INTO its1_source VALUES(1286,'KF181453.1',83,573,62);
INSERT INTO its1_source VALUES(1287,'KF181454.1',83,84,62);
INSERT INTO its1_source VALUES(1288,'KF181455.1',83,574,62);
INSERT INTO its1_source VALUES(1289,'KF234654.1',83,245,5);
INSERT INTO its1_source VALUES(1290,'KF234655.1',83,245,5);
INSERT INTO its1_source VALUES(1291,'KF234656.1',83,245,5);
INSERT INTO its1_source VALUES(1292,'KF234657.1',83,245,5);
INSERT INTO its1_source VALUES(1293,'KF234658.1',83,245,5);
INSERT INTO its1_source VALUES(1294,'KF234659.1',83,245,5);
INSERT INTO its1_source VALUES(1295,'KF234660.1',83,245,5);
INSERT INTO its1_source VALUES(1296,'KF234661.1',83,235,5);
INSERT INTO its1_source VALUES(1297,'KF234662.1',83,235,5);
INSERT INTO its1_source VALUES(1298,'KF234663.1',83,235,5);
INSERT INTO its1_source VALUES(1299,'KF234664.1',83,235,5);
INSERT INTO its1_source VALUES(1300,'KF234665.1',83,235,5);
INSERT INTO its1_source VALUES(1301,'KF234666.1',83,235,5);
INSERT INTO its1_source VALUES(1302,'KF234667.1',83,235,5);
INSERT INTO its1_source VALUES(1303,'KF234668.1',83,235,5);
INSERT INTO its1_source VALUES(1304,'KF234669.1',83,235,5);
INSERT INTO its1_source VALUES(1305,'KF234670.1',83,235,5);
INSERT INTO its1_source VALUES(1306,'KF234671.1',83,235,5);
INSERT INTO its1_source VALUES(1307,'KF234672.1',83,235,5);
INSERT INTO its1_source VALUES(1308,'KF234673.1',83,235,5);
INSERT INTO its1_source VALUES(1309,'KF234674.1',83,235,5);
INSERT INTO its1_source VALUES(1310,'KF234675.1',83,235,5);
INSERT INTO its1_source VALUES(1311,'KF234676.1',83,235,5);
INSERT INTO its1_source VALUES(1312,'KF234677.1',83,235,5);
INSERT INTO its1_source VALUES(1313,'KF234678.1',83,235,5);
INSERT INTO its1_source VALUES(1314,'KF234679.1',83,235,5);
INSERT INTO its1_source VALUES(1315,'KF234680.1',83,235,5);
INSERT INTO its1_source VALUES(1316,'KF234681.1',83,235,5);
INSERT INTO its1_source VALUES(1317,'KF234682.1',83,235,5);
INSERT INTO its1_source VALUES(1318,'KF234683.1',83,235,5);
INSERT INTO its1_source VALUES(1319,'KF234684.1',83,235,5);
INSERT INTO its1_source VALUES(1320,'KF234685.1',83,235,5);
INSERT INTO its1_source VALUES(1321,'KF234686.1',83,235,5);
INSERT INTO its1_source VALUES(1322,'KF234687.1',83,235,5);
INSERT INTO its1_source VALUES(1323,'KF234688.1',83,235,5);
INSERT INTO its1_source VALUES(1324,'KF234689.1',83,235,5);
INSERT INTO its1_source VALUES(1325,'KF234690.1',83,235,5);
INSERT INTO its1_source VALUES(1326,'KF234691.1',83,235,5);
INSERT INTO its1_source VALUES(1327,'KF234692.1',83,235,5);
INSERT INTO its1_source VALUES(1328,'KF234693.1',83,235,5);
INSERT INTO its1_source VALUES(1329,'KF234694.1',83,235,5);
INSERT INTO its1_source VALUES(1330,'KF234695.1',83,235,5);
INSERT INTO its1_source VALUES(1331,'KF234696.1',83,235,5);
INSERT INTO its1_source VALUES(1332,'KF234697.1',83,235,5);
INSERT INTO its1_source VALUES(1333,'KF234698.1',83,235,5);
INSERT INTO its1_source VALUES(1334,'KF234699.1',83,235,5);
INSERT INTO its1_source VALUES(1335,'KF234700.1',83,235,5);
INSERT INTO its1_source VALUES(1336,'KF234701.1',83,235,5);
INSERT INTO its1_source VALUES(1337,'KF234702.1',83,235,5);
INSERT INTO its1_source VALUES(1338,'KF234703.1',83,235,5);
INSERT INTO its1_source VALUES(1339,'KF234704.1',83,235,5);
INSERT INTO its1_source VALUES(1340,'KF234705.1',83,235,5);
INSERT INTO its1_source VALUES(1341,'KF234706.1',83,235,5);
INSERT INTO its1_source VALUES(1342,'KF234707.1',83,235,5);
INSERT INTO its1_source VALUES(1343,'KF234708.1',83,235,5);
INSERT INTO its1_source VALUES(1344,'KF234709.1',83,235,5);
INSERT INTO its1_source VALUES(1345,'KF234710.1',83,235,5);
INSERT INTO its1_source VALUES(1346,'KF234711.1',83,235,5);
INSERT INTO its1_source VALUES(1347,'KF234712.1',83,235,5);
INSERT INTO its1_source VALUES(1348,'KF234713.1',83,235,5);
INSERT INTO its1_source VALUES(1349,'KF234714.1',83,235,5);
INSERT INTO its1_source VALUES(1350,'KF234715.1',83,235,5);
INSERT INTO its1_source VALUES(1351,'KF234716.1',83,235,5);
INSERT INTO its1_source VALUES(1352,'KF234717.1',83,235,5);
INSERT INTO its1_source VALUES(1353,'KF234718.1',83,235,5);
INSERT INTO its1_source VALUES(1354,'KF234719.1',83,235,5);
INSERT INTO its1_source VALUES(1355,'KF234720.1',83,235,5);
INSERT INTO its1_source VALUES(1356,'KF234721.1',83,235,5);
INSERT INTO its1_source VALUES(1357,'KF234722.1',83,235,5);
INSERT INTO its1_source VALUES(1358,'KF234723.1',83,235,5);
INSERT INTO its1_source VALUES(1359,'KF234724.1',83,235,5);
INSERT INTO its1_source VALUES(1360,'KF234725.1',83,235,5);
INSERT INTO its1_source VALUES(1361,'KF234726.1',83,235,5);
INSERT INTO its1_source VALUES(1362,'KF234727.1',83,235,5);
INSERT INTO its1_source VALUES(1363,'KF234728.1',83,235,5);
INSERT INTO its1_source VALUES(1364,'KF234729.1',83,235,5);
INSERT INTO its1_source VALUES(1365,'KF234730.1',83,235,5);
INSERT INTO its1_source VALUES(1366,'KF234731.1',83,235,5);
INSERT INTO its1_source VALUES(1367,'KF234732.1',83,235,5);
INSERT INTO its1_source VALUES(1368,'KF234733.1',83,235,5);
INSERT INTO its1_source VALUES(1369,'KF234734.1',83,235,5);
INSERT INTO its1_source VALUES(1370,'KF234735.1',83,235,5);
INSERT INTO its1_source VALUES(1371,'KF234736.1',83,235,5);
INSERT INTO its1_source VALUES(1372,'KF234737.1',83,235,5);
INSERT INTO its1_source VALUES(1373,'KF234738.1',83,235,5);
INSERT INTO its1_source VALUES(1374,'KF234739.1',83,235,5);
INSERT INTO its1_source VALUES(1375,'KF234740.1',83,235,5);
INSERT INTO its1_source VALUES(1376,'KF234741.1',83,235,5);
INSERT INTO its1_source VALUES(1377,'KF234742.1',83,235,5);
INSERT INTO its1_source VALUES(1378,'KF234743.1',83,235,5);
INSERT INTO its1_source VALUES(1379,'KF234744.1',83,235,5);
INSERT INTO its1_source VALUES(1380,'KF234745.1',83,235,5);
INSERT INTO its1_source VALUES(1381,'KF234746.1',83,235,5);
INSERT INTO its1_source VALUES(1382,'KF234747.1',83,235,5);
INSERT INTO its1_source VALUES(1383,'KF234748.1',83,235,5);
INSERT INTO its1_source VALUES(1384,'KF234749.1',83,235,5);
INSERT INTO its1_source VALUES(1385,'KF234750.1',83,237,5);
INSERT INTO its1_source VALUES(1386,'KF234751.1',83,237,5);
INSERT INTO its1_source VALUES(1387,'KF234752.1',83,237,5);
INSERT INTO its1_source VALUES(1388,'KF234753.1',83,237,5);
INSERT INTO its1_source VALUES(1389,'KF234754.1',83,237,5);
INSERT INTO its1_source VALUES(1390,'KF234755.1',83,237,5);
INSERT INTO its1_source VALUES(1391,'KF234756.1',83,237,5);
INSERT INTO its1_source VALUES(1392,'KF234757.1',83,237,5);
INSERT INTO its1_source VALUES(1393,'KF234758.1',83,237,5);
INSERT INTO its1_source VALUES(1394,'KF234759.1',83,575,5);
INSERT INTO its1_source VALUES(1395,'KF234760.1',83,576,5);
INSERT INTO its1_source VALUES(1396,'KF234761.1',83,576,5);
INSERT INTO its1_source VALUES(1397,'KF234762.1',83,576,5);
INSERT INTO its1_source VALUES(1398,'KF234763.1',83,577,5);
INSERT INTO its1_source VALUES(1399,'KF234764.1',83,577,5);
INSERT INTO its1_source VALUES(1400,'KF234765.1',83,41,5);
INSERT INTO its1_source VALUES(1401,'KF263691.1',83,60,5);
INSERT INTO its1_source VALUES(1402,'KF271785.1',83,578,5);
INSERT INTO its1_source VALUES(1403,'KF271786.1',83,579,5);
INSERT INTO its1_source VALUES(1404,'KF271787.1',83,580,5);
INSERT INTO its1_source VALUES(1405,'KF271788.1',83,581,5);
INSERT INTO its1_source VALUES(1406,'KF271790.1',83,582,5);
INSERT INTO its1_source VALUES(1407,'KF271791.1',83,286,5);
INSERT INTO its1_source VALUES(1408,'KF278458.1',83,11,5);
INSERT INTO its1_source VALUES(1409,'KF286843.1',83,235,5);
INSERT INTO its1_source VALUES(1410,'KF286844.1',83,235,5);
INSERT INTO its1_source VALUES(1411,'KF286845.1',83,235,5);
INSERT INTO its1_source VALUES(1412,'KF286846.1',83,235,5);
INSERT INTO its1_source VALUES(1413,'KF286847.1',83,235,5);
INSERT INTO its1_source VALUES(1414,'KF286848.1',83,235,5);
INSERT INTO its1_source VALUES(1415,'KF286849.1',83,235,5);
INSERT INTO its1_source VALUES(1416,'KF286850.1',83,235,5);
INSERT INTO its1_source VALUES(1417,'KF286851.1',83,235,5);
INSERT INTO its1_source VALUES(1418,'KF286852.1',83,235,5);
INSERT INTO its1_source VALUES(1419,'KF286853.1',83,235,5);
INSERT INTO its1_source VALUES(1420,'KF286854.1',83,235,5);
INSERT INTO its1_source VALUES(1421,'KF286855.1',83,235,5);
INSERT INTO its1_source VALUES(1422,'KF286856.1',83,235,5);
INSERT INTO its1_source VALUES(1423,'KF286857.1',83,235,5);
INSERT INTO its1_source VALUES(1424,'KF286858.1',83,235,5);
INSERT INTO its1_source VALUES(1425,'KF286859.1',83,235,5);
INSERT INTO its1_source VALUES(1426,'KF286860.1',83,235,5);
INSERT INTO its1_source VALUES(1427,'KF286861.1',83,583,5);
INSERT INTO its1_source VALUES(1428,'KF286862.1',83,583,5);
INSERT INTO its1_source VALUES(1429,'KF286863.1',83,583,5);
INSERT INTO its1_source VALUES(1430,'KF286864.1',83,583,5);
INSERT INTO its1_source VALUES(1431,'KF286865.1',83,583,5);
INSERT INTO its1_source VALUES(1432,'KF286866.1',83,583,5);
INSERT INTO its1_source VALUES(1433,'KF286867.1',83,583,5);
INSERT INTO its1_source VALUES(1434,'KF286868.1',83,583,5);
INSERT INTO its1_source VALUES(1435,'KF286869.1',83,583,5);
INSERT INTO its1_source VALUES(1436,'KF286870.1',83,583,5);
INSERT INTO its1_source VALUES(1437,'KF286871.1',83,583,5);
INSERT INTO its1_source VALUES(1438,'KF286872.1',83,583,5);
INSERT INTO its1_source VALUES(1439,'KF286873.1',83,583,5);
INSERT INTO its1_source VALUES(1440,'KF286874.1',83,583,5);
INSERT INTO its1_source VALUES(1441,'KF286875.1',83,233,5);
INSERT INTO its1_source VALUES(1442,'KF286876.1',83,237,5);
INSERT INTO its1_source VALUES(1443,'KF286877.1',83,237,5);
INSERT INTO its1_source VALUES(1444,'KF286878.1',83,237,5);
INSERT INTO its1_source VALUES(1445,'KF286879.1',83,237,5);
INSERT INTO its1_source VALUES(1446,'KF286880.1',83,237,5);
INSERT INTO its1_source VALUES(1447,'KF286881.1',83,237,5);
INSERT INTO its1_source VALUES(1448,'KF286882.1',83,237,5);
INSERT INTO its1_source VALUES(1449,'KF286883.1',83,237,5);
INSERT INTO its1_source VALUES(1450,'KF286884.1',83,237,5);
INSERT INTO its1_source VALUES(1451,'KF286885.1',83,237,5);
INSERT INTO its1_source VALUES(1452,'KF286886.1',83,237,5);
INSERT INTO its1_source VALUES(1453,'KF286887.1',83,237,5);
INSERT INTO its1_source VALUES(1454,'KF286888.1',83,237,5);
INSERT INTO its1_source VALUES(1455,'KF286889.1',83,237,5);
INSERT INTO its1_source VALUES(1456,'KF286890.1',83,584,5);
INSERT INTO its1_source VALUES(1457,'KF286891.1',83,584,5);
INSERT INTO its1_source VALUES(1458,'KF286892.1',83,584,5);
INSERT INTO its1_source VALUES(1459,'KF286893.1',83,584,5);
INSERT INTO its1_source VALUES(1460,'KF286894.1',83,584,5);
INSERT INTO its1_source VALUES(1461,'KF356393.1',83,585,5);
INSERT INTO its1_source VALUES(1462,'KF366378.1',83,586,4);
INSERT INTO its1_source VALUES(1463,'KF366379.1',83,586,4);
INSERT INTO its1_source VALUES(1464,'KF366380.1',83,586,4);
INSERT INTO its1_source VALUES(1465,'KF444064.1',83,587,5);
INSERT INTO its1_source VALUES(1466,'KF444065.1',83,20,5);
INSERT INTO its1_source VALUES(1467,'KF444067.1',83,588,5);
INSERT INTO its1_source VALUES(1468,'KF444070.1',83,333,5);
INSERT INTO its1_source VALUES(1469,'KF494895.1',83,589,62);
INSERT INTO its1_source VALUES(1470,'KF501392.1',83,590,5);
INSERT INTO its1_source VALUES(1471,'KF611668.1',83,399,5);
INSERT INTO its1_source VALUES(1472,'KF611669.1',83,591,5);
INSERT INTO its1_source VALUES(1473,'KF611670.1',83,592,5);
INSERT INTO its1_source VALUES(1474,'KF611671.1',83,593,5);
INSERT INTO its1_source VALUES(1475,'KF611672.1',83,594,5);
INSERT INTO its1_source VALUES(1476,'KF611673.1',83,513,5);
INSERT INTO its1_source VALUES(1477,'KF611674.1',83,595,5);
INSERT INTO its1_source VALUES(1478,'KF611675.1',83,513,5);
INSERT INTO its1_source VALUES(1479,'KF700086.1',83,596,5);
INSERT INTO its1_source VALUES(1480,'KF700087.1',83,506,5);
INSERT INTO its1_source VALUES(1481,'KF700088.1',83,510,5);
INSERT INTO its1_source VALUES(1482,'KF700089.1',83,29,5);
INSERT INTO its1_source VALUES(1483,'KF700090.1',83,29,5);
INSERT INTO its1_source VALUES(1484,'KF700091.1',83,508,5);
INSERT INTO its1_source VALUES(1485,'KF723832.1',83,597,5);
INSERT INTO its1_source VALUES(1486,'KF723833.1',83,598,5);
INSERT INTO its1_source VALUES(1487,'KF723835.1',83,598,5);
INSERT INTO its1_source VALUES(1488,'KF723836.1',83,598,5);
INSERT INTO its1_source VALUES(1489,'KF724686.1',83,599,5);
INSERT INTO its1_source VALUES(1490,'KF750595.1',83,303,5);
INSERT INTO its1_source VALUES(1491,'KF761214.1',83,112,62);
INSERT INTO its1_source VALUES(1492,'KF761215.1',83,112,62);
INSERT INTO its1_source VALUES(1493,'KF761216.1',83,600,62);
INSERT INTO its1_source VALUES(1494,'KF761217.1',83,112,62);
INSERT INTO its1_source VALUES(1495,'KF831193.1',83,598,5);
INSERT INTO its1_source VALUES(1496,'KF831194.1',83,598,5);
INSERT INTO its1_source VALUES(1497,'KF831195.1',83,598,5);
INSERT INTO its1_source VALUES(1498,'KF888585.1',83,103,9);
INSERT INTO its1_source VALUES(1499,'KF888586.1',83,103,9);
INSERT INTO its1_source VALUES(1500,'KF888587.1',83,103,9);
INSERT INTO its1_source VALUES(1501,'KF888588.1',83,103,9);
INSERT INTO its1_source VALUES(1502,'KF888589.1',83,103,9);
INSERT INTO its1_source VALUES(1503,'KF888590.1',83,103,9);
INSERT INTO its1_source VALUES(1504,'KF888591.1',83,103,9);
INSERT INTO its1_source VALUES(1505,'KF888592.1',83,103,9);
INSERT INTO its1_source VALUES(1506,'KF888593.1',83,103,9);
INSERT INTO its1_source VALUES(1507,'KF888594.1',83,103,9);
INSERT INTO its1_source VALUES(1508,'KF888595.1',83,103,9);
INSERT INTO its1_source VALUES(1509,'KF888596.1',83,103,9);
INSERT INTO its1_source VALUES(1510,'KF888597.1',83,103,9);
INSERT INTO its1_source VALUES(1511,'KF888598.1',83,103,9);
INSERT INTO its1_source VALUES(1512,'KF888599.1',83,103,9);
INSERT INTO its1_source VALUES(1513,'KF888600.1',83,103,9);
INSERT INTO its1_source VALUES(1514,'KF888601.1',83,103,9);
INSERT INTO its1_source VALUES(1515,'KF888602.1',83,103,9);
INSERT INTO its1_source VALUES(1516,'KF888603.1',83,103,9);
INSERT INTO its1_source VALUES(1517,'KF888604.1',83,103,9);
INSERT INTO its1_source VALUES(1518,'KF963049.1',83,235,5);
INSERT INTO its1_source VALUES(1519,'KF963050.1',83,235,5);
INSERT INTO its1_source VALUES(1520,'KF990557.1',83,235,5);
INSERT INTO its1_source VALUES(1521,'KJ002561.1',83,601,9);
INSERT INTO its1_source VALUES(1522,'KJ128038.1',83,602,76);
INSERT INTO its1_source VALUES(1523,'KJ144772.1',83,603,5);
INSERT INTO its1_source VALUES(1524,'KJ494889.1',83,190,5);
INSERT INTO its1_source VALUES(1525,'KJ494890.1',83,604,5);
INSERT INTO its1_source VALUES(1526,'KJ494891.1',83,605,5);
INSERT INTO its1_source VALUES(1527,'KJ494892.1',83,190,5);
INSERT INTO its1_source VALUES(1528,'KJ494893.1',83,190,5);
INSERT INTO its1_source VALUES(1529,'KJ494894.1',83,190,5);
INSERT INTO its1_source VALUES(1530,'KJ494895.1',83,190,5);
INSERT INTO its1_source VALUES(1531,'KJ494896.1',83,190,5);
INSERT INTO its1_source VALUES(1532,'KJ494897.1',83,190,5);
INSERT INTO its1_source VALUES(1533,'KJ494898.1',83,190,5);
INSERT INTO its1_source VALUES(1534,'KJ494899.1',83,190,5);
INSERT INTO its1_source VALUES(1535,'KJ494900.1',83,190,5);
INSERT INTO its1_source VALUES(1536,'KJ494901.1',83,190,5);
INSERT INTO its1_source VALUES(1537,'KJ494902.1',83,190,5);
INSERT INTO its1_source VALUES(1538,'KJ494903.1',83,190,5);
INSERT INTO its1_source VALUES(1539,'KJ494904.1',83,606,5);
INSERT INTO its1_source VALUES(1540,'KJ494905.1',83,607,5);
INSERT INTO its1_source VALUES(1541,'KJ494906.1',83,190,5);
INSERT INTO its1_source VALUES(1542,'KJ494907.1',83,190,5);
INSERT INTO its1_source VALUES(1543,'KJ494908.1',83,190,5);
INSERT INTO its1_source VALUES(1544,'KJ494909.1',83,606,5);
INSERT INTO its1_source VALUES(1545,'KJ494910.1',83,190,5);
INSERT INTO its1_source VALUES(1546,'KJ494911.1',83,190,5);
INSERT INTO its1_source VALUES(1547,'KJ494912.1',83,608,5);
INSERT INTO its1_source VALUES(1548,'KJ494913.1',83,609,5);
INSERT INTO its1_source VALUES(1549,'KJ494914.1',83,190,5);
INSERT INTO its1_source VALUES(1550,'KJ494915.1',83,190,5);
INSERT INTO its1_source VALUES(1551,'KJ494916.1',83,608,5);
INSERT INTO its1_source VALUES(1552,'KJ494917.1',83,190,5);
INSERT INTO its1_source VALUES(1553,'KJ494918.1',83,190,5);
INSERT INTO its1_source VALUES(1554,'KJ494919.1',83,190,5);
INSERT INTO its1_source VALUES(1555,'KJ494920.1',83,190,5);
INSERT INTO its1_source VALUES(1556,'KJ507656.1',83,610,5);
INSERT INTO its1_source VALUES(1557,'KJ507657.1',83,304,5);
INSERT INTO its1_source VALUES(1558,'KJ549640.1',83,611,5);
INSERT INTO its1_source VALUES(1559,'KJ549641.1',83,612,5);
INSERT INTO its1_source VALUES(1560,'KJ562359.1',83,25,5);
INSERT INTO its1_source VALUES(1561,'KJ572971.1',83,613,5);
INSERT INTO its1_source VALUES(1562,'KJ576799.1',83,513,5);
INSERT INTO its1_source VALUES(1563,'KJ664801.1',83,95,5);
INSERT INTO its1_source VALUES(1564,'KJ754387.1',83,614,5);
INSERT INTO its1_source VALUES(1565,'KJ755087.1',83,84,62);
INSERT INTO its1_source VALUES(1566,'KJ755089.1',83,442,55);
INSERT INTO its1_source VALUES(1567,'KJ755090.1',83,13,5);
INSERT INTO its1_source VALUES(1568,'KJ755091.1',83,615,5);
INSERT INTO its1_source VALUES(1569,'KJ755092.1',83,12,5);
INSERT INTO its1_source VALUES(1570,'KJ755093.1',83,616,5);
INSERT INTO its1_source VALUES(1571,'KJ755094.1',83,45,5);
INSERT INTO its1_source VALUES(1572,'KJ755095.1',83,67,5);
INSERT INTO its1_source VALUES(1573,'KJ755096.1',83,617,5);
INSERT INTO its1_source VALUES(1574,'KJ755097.1',83,618,5);
INSERT INTO its1_source VALUES(1575,'KJ755098.1',83,407,5);
INSERT INTO its1_source VALUES(1576,'KJ755101.1',83,324,5);
INSERT INTO its1_source VALUES(1577,'KJ755102.1',83,619,5);
INSERT INTO its1_source VALUES(1578,'KJ755103.1',83,37,5);
INSERT INTO its1_source VALUES(1579,'KJ755104.1',83,29,5);
INSERT INTO its1_source VALUES(1580,'KJ755108.1',83,162,5);
INSERT INTO its1_source VALUES(1581,'KJ755109.1',83,620,5);
INSERT INTO its1_source VALUES(1582,'KJ755110.1',83,46,5);
INSERT INTO its1_source VALUES(1583,'KJ755111.1',83,60,5);
INSERT INTO its1_source VALUES(1584,'KJ755112.1',83,585,5);
INSERT INTO its1_source VALUES(1585,'KJ755113.1',83,20,5);
INSERT INTO its1_source VALUES(1586,'KJ755114.1',83,621,5);
INSERT INTO its1_source VALUES(1587,'KJ755115.1',83,64,5);
INSERT INTO its1_source VALUES(1588,'KJ755116.1',83,622,5);
INSERT INTO its1_source VALUES(1589,'KJ755117.1',83,623,5);
INSERT INTO its1_source VALUES(1590,'KJ755118.1',83,624,5);
INSERT INTO its1_source VALUES(1591,'KJ755119.1',83,24,5);
INSERT INTO its1_source VALUES(1592,'KJ755120.1',83,625,5);
INSERT INTO its1_source VALUES(1593,'KJ755121.1',83,402,5);
INSERT INTO its1_source VALUES(1594,'KJ755122.1',83,402,5);
INSERT INTO its1_source VALUES(1595,'KJ755123.1',83,402,5);
INSERT INTO its1_source VALUES(1596,'KJ755124.1',83,402,5);
INSERT INTO its1_source VALUES(1597,'KJ755125.1',83,402,5);
INSERT INTO its1_source VALUES(1598,'KJ755127.1',83,455,5);
INSERT INTO its1_source VALUES(1599,'KJ755128.1',83,305,5);
INSERT INTO its1_source VALUES(1600,'KJ755130.1',83,66,5);
INSERT INTO its1_source VALUES(1601,'KJ755131.1',83,10,5);
INSERT INTO its1_source VALUES(1602,'KJ755134.1',83,76,5);
INSERT INTO its1_source VALUES(1603,'KJ755193.1',83,303,5);
INSERT INTO its1_source VALUES(1604,'KJ755194.1',83,303,5);
INSERT INTO its1_source VALUES(1605,'KJ755195.1',83,303,5);
INSERT INTO its1_source VALUES(1606,'KJ831613.1',83,626,55);
INSERT INTO its1_source VALUES(1607,'KJ855323.1',83,237,5);
INSERT INTO its1_source VALUES(1608,'KJ855324.1',83,333,5);
INSERT INTO its1_source VALUES(1609,'KJ855325.1',83,194,5);
INSERT INTO its1_source VALUES(1610,'KJ855326.1',83,29,5);
INSERT INTO its1_source VALUES(1611,'KJ855327.1',83,245,5);
INSERT INTO its1_source VALUES(1612,'KJ865226.1',83,627,5);
INSERT INTO its1_source VALUES(1613,'KJ865227.1',83,282,5);
INSERT INTO its1_source VALUES(1614,'KJ865230.1',83,25,5);
INSERT INTO its1_source VALUES(1615,'KJ865238.1',83,628,55);
INSERT INTO its1_source VALUES(1616,'KJ960193.1',83,236,9);
INSERT INTO its1_source VALUES(1617,'KM052583.1',83,235,5);
INSERT INTO its1_source VALUES(1618,'KM058095.1',83,629,9);
INSERT INTO its1_source VALUES(1619,'KM058096.1',83,630,9);
INSERT INTO its1_source VALUES(1620,'KM058097.1',83,631,9);
INSERT INTO its1_source VALUES(1621,'KM058101.1',83,632,9);
INSERT INTO its1_source VALUES(1622,'KM061707.1',83,165,5);
INSERT INTO its1_source VALUES(1623,'KM061711.1',83,633,5);
INSERT INTO its1_source VALUES(1624,'KM087089.1',83,634,5);
INSERT INTO its1_source VALUES(1625,'KM279674.1',83,635,5);
INSERT INTO its1_source VALUES(1626,'KM279676.1',83,636,5);
INSERT INTO its1_source VALUES(1627,'KM369965.1',83,637,5);
INSERT INTO its1_source VALUES(1628,'KM387400.1',83,638,5);
INSERT INTO its1_source VALUES(1629,'KM519189.1',83,639,5);
INSERT INTO its1_source VALUES(1630,'KM979514.1',83,376,5);
INSERT INTO its1_source VALUES(1631,'KP050543.1',83,376,5);
INSERT INTO its1_source VALUES(1632,'KP050544.1',83,60,5);
INSERT INTO its1_source VALUES(1633,'KP050545.1',83,399,5);
INSERT INTO its1_source VALUES(1634,'KP050546.1',83,399,5);
INSERT INTO its1_source VALUES(1635,'KP063125.1',83,640,62);
INSERT INTO its1_source VALUES(1636,'KP159287.1',83,13,5);
INSERT INTO its1_source VALUES(1637,'KP164987.1',83,236,9);
INSERT INTO its1_source VALUES(1638,'KP183929.1',83,641,6);
INSERT INTO its1_source VALUES(1639,'KP183932.1',83,642,55);
INSERT INTO its1_source VALUES(1640,'KP183936.1',83,643,5);
INSERT INTO its1_source VALUES(1641,'KP183937.1',83,644,6);
INSERT INTO its1_source VALUES(1642,'KP183939.1',83,643,5);
INSERT INTO its1_source VALUES(1643,'KP183940.1',83,645,55);
INSERT INTO its1_source VALUES(1644,'KP183941.1',83,646,55);
INSERT INTO its1_source VALUES(1645,'KP183942.1',83,647,55);
INSERT INTO its1_source VALUES(1646,'KP183944.1',83,648,55);
INSERT INTO its1_source VALUES(1647,'KP183946.1',83,649,6);
INSERT INTO its1_source VALUES(1648,'KP183952.1',83,650,55);
INSERT INTO its1_source VALUES(1649,'KP183954.1',83,651,6);
INSERT INTO its1_source VALUES(1650,'KP183955.1',83,652,6);
INSERT INTO its1_source VALUES(1651,'KP183957.1',83,653,6);
INSERT INTO its1_source VALUES(1653,'KP183960.1',83,655,55);
INSERT INTO its1_source VALUES(1654,'KP183961.1',83,656,55);
INSERT INTO its1_source VALUES(1655,'KP183962.1',83,656,55);
INSERT INTO its1_source VALUES(1656,'KP183963.1',83,60,5);
INSERT INTO its1_source VALUES(1657,'KP271924.1',83,657,9);
INSERT INTO its1_source VALUES(1658,'KP670200.1',83,658,5);
INSERT INTO its1_source VALUES(1659,'KP780453.1',83,659,5);
INSERT INTO its1_source VALUES(1660,'KR827692.1',83,25,5);
INSERT INTO its1_source VALUES(1661,'KT175508.1',83,25,5);
INSERT INTO its1_source VALUES(1662,'KT223573.1',83,660,55);
INSERT INTO its1_source VALUES(1663,'KT248949.1',83,264,3);
INSERT INTO its1_source VALUES(1664,'KT248950.1',83,264,3);
INSERT INTO its1_source VALUES(1665,'KT248951.1',83,264,3);
INSERT INTO its1_source VALUES(1666,'KT248952.1',83,264,3);
INSERT INTO its1_source VALUES(1667,'KT248953.1',83,264,3);
INSERT INTO its1_source VALUES(1668,'KT248954.1',83,264,3);
INSERT INTO its1_source VALUES(1669,'KT248955.1',83,264,3);
INSERT INTO its1_source VALUES(1670,'KT248956.1',83,264,3);
INSERT INTO its1_source VALUES(1671,'KT248957.1',83,264,3);
INSERT INTO its1_source VALUES(1672,'KT248958.1',83,264,3);
INSERT INTO its1_source VALUES(1673,'KT248959.1',83,264,3);
INSERT INTO its1_source VALUES(1674,'KT248960.1',83,264,3);
INSERT INTO its1_source VALUES(1675,'KT248961.1',83,661,3);
INSERT INTO its1_source VALUES(1676,'KT248962.1',83,661,3);
INSERT INTO its1_source VALUES(1677,'KT248963.1',83,661,3);
INSERT INTO its1_source VALUES(1678,'KT248964.1',83,661,3);
INSERT INTO its1_source VALUES(1679,'KT248965.1',83,661,3);
INSERT INTO its1_source VALUES(1680,'KT248966.1',83,662,3);
INSERT INTO its1_source VALUES(1681,'KT248967.1',83,662,3);
INSERT INTO its1_source VALUES(1682,'KT248968.1',83,662,3);
INSERT INTO its1_source VALUES(1683,'KT248969.1',83,662,3);
INSERT INTO its1_source VALUES(1684,'KT248970.1',83,662,3);
INSERT INTO its1_source VALUES(1685,'KT248971.1',83,662,3);
INSERT INTO its1_source VALUES(1686,'KT248972.1',83,264,3);
INSERT INTO its1_source VALUES(1687,'KT248973.1',83,661,3);
INSERT INTO its1_source VALUES(1688,'KT248974.1',83,264,3);
INSERT INTO its1_source VALUES(1689,'KT248975.1',83,263,3);
INSERT INTO its1_source VALUES(1690,'KT248976.1',83,263,3);
INSERT INTO its1_source VALUES(1691,'KT248977.1',83,263,3);
INSERT INTO its1_source VALUES(1692,'KT248978.1',83,263,3);
INSERT INTO its1_source VALUES(1693,'KT248979.1',83,264,3);
INSERT INTO its1_source VALUES(1694,'KT248980.1',83,264,3);
INSERT INTO its1_source VALUES(1695,'KT248981.1',83,264,3);
INSERT INTO its1_source VALUES(1696,'KT248982.1',83,264,3);
INSERT INTO its1_source VALUES(1697,'KT248983.1',83,264,3);
INSERT INTO its1_source VALUES(1698,'KT248984.1',83,264,3);
INSERT INTO its1_source VALUES(1699,'KT248985.1',83,256,3);
INSERT INTO its1_source VALUES(1700,'KT248986.1',83,256,3);
INSERT INTO its1_source VALUES(1701,'KT248987.1',83,256,3);
INSERT INTO its1_source VALUES(1702,'KT248988.1',83,256,3);
INSERT INTO its1_source VALUES(1703,'KT248989.1',83,256,3);
INSERT INTO its1_source VALUES(1704,'KT248990.1',83,256,3);
INSERT INTO its1_source VALUES(1705,'KT248991.1',83,256,3);
INSERT INTO its1_source VALUES(1706,'KT248992.1',83,256,3);
INSERT INTO its1_source VALUES(1707,'KT248993.1',83,256,3);
INSERT INTO its1_source VALUES(1708,'KT248994.1',83,256,3);
INSERT INTO its1_source VALUES(1709,'KT248995.1',83,256,3);
INSERT INTO its1_source VALUES(1710,'KT248996.1',83,256,3);
INSERT INTO its1_source VALUES(1711,'KT248997.1',83,256,3);
INSERT INTO its1_source VALUES(1712,'KT248998.1',83,256,3);
INSERT INTO its1_source VALUES(1713,'KT248999.1',83,256,3);
INSERT INTO its1_source VALUES(1714,'KT249000.1',83,256,3);
INSERT INTO its1_source VALUES(1715,'KT249001.1',83,256,3);
INSERT INTO its1_source VALUES(1716,'KT249002.1',83,256,3);
INSERT INTO its1_source VALUES(1717,'KT249003.1',83,663,3);
INSERT INTO its1_source VALUES(1718,'KT249004.1',83,663,3);
INSERT INTO its1_source VALUES(1719,'KT249005.1',83,663,3);
INSERT INTO its1_source VALUES(1720,'KT249006.1',83,663,3);
INSERT INTO its1_source VALUES(1721,'KT249007.1',83,663,3);
INSERT INTO its1_source VALUES(1722,'KT249008.1',83,663,3);
INSERT INTO its1_source VALUES(1723,'KT249009.1',83,663,3);
INSERT INTO its1_source VALUES(1724,'KT249010.1',83,664,3);
INSERT INTO its1_source VALUES(1725,'KT249011.1',83,664,3);
INSERT INTO its1_source VALUES(1726,'KT249012.1',83,664,3);
INSERT INTO its1_source VALUES(1727,'KT249013.1',83,665,3);
INSERT INTO its1_source VALUES(1728,'KT249014.1',83,665,3);
INSERT INTO its1_source VALUES(1729,'KT249015.1',83,665,3);
INSERT INTO its1_source VALUES(1730,'KT249016.1',83,666,3);
INSERT INTO its1_source VALUES(1731,'KT249017.1',83,264,3);
INSERT INTO its1_source VALUES(1732,'KT249018.1',83,667,3);
INSERT INTO its1_source VALUES(1733,'KT249019.1',83,667,3);
INSERT INTO its1_source VALUES(1734,'KT249020.1',83,264,3);
INSERT INTO its1_source VALUES(1735,'KT249021.1',83,5,3);
INSERT INTO its1_source VALUES(1736,'KT249022.1',83,5,3);
INSERT INTO its1_source VALUES(1737,'KT249023.1',83,5,3);
INSERT INTO its1_source VALUES(1738,'KT249024.1',83,5,3);
INSERT INTO its1_source VALUES(1739,'KT249025.1',83,5,3);
INSERT INTO its1_source VALUES(1740,'KT249026.1',83,5,3);
INSERT INTO its1_source VALUES(1741,'KT249027.1',83,5,3);
INSERT INTO its1_source VALUES(1742,'KT249028.1',83,5,3);
INSERT INTO its1_source VALUES(1743,'KT249029.1',83,5,3);
INSERT INTO its1_source VALUES(1744,'KT249030.1',83,5,3);
INSERT INTO its1_source VALUES(1745,'KT249031.1',83,5,3);
INSERT INTO its1_source VALUES(1746,'KT249032.1',83,5,3);
INSERT INTO its1_source VALUES(1747,'KT249033.1',83,5,3);
INSERT INTO its1_source VALUES(1748,'KT249034.1',83,5,3);
INSERT INTO its1_source VALUES(1749,'KT249035.1',83,5,3);
INSERT INTO its1_source VALUES(1750,'KT249036.1',83,668,3);
INSERT INTO its1_source VALUES(1751,'KT249037.1',83,668,3);
INSERT INTO its1_source VALUES(1752,'KT249038.1',83,668,3);
INSERT INTO its1_source VALUES(1753,'KT249039.1',83,668,3);
INSERT INTO its1_source VALUES(1754,'KT249040.1',83,668,3);
INSERT INTO its1_source VALUES(1755,'KT249041.1',83,669,3);
INSERT INTO its1_source VALUES(1756,'KT249042.1',83,669,3);
INSERT INTO its1_source VALUES(1757,'KT249043.1',83,669,3);
INSERT INTO its1_source VALUES(1758,'KT249044.1',83,264,3);
INSERT INTO its1_source VALUES(1759,'KT249045.1',83,264,3);
INSERT INTO its1_source VALUES(1760,'KT249046.1',83,264,3);
INSERT INTO its1_source VALUES(1761,'KT249047.1',83,264,3);
INSERT INTO its1_source VALUES(1762,'KT249048.1',83,670,3);
INSERT INTO its1_source VALUES(1763,'KT249049.1',83,670,3);
INSERT INTO its1_source VALUES(1764,'KT249050.1',83,670,3);
INSERT INTO its1_source VALUES(1765,'KT249051.1',83,670,3);
INSERT INTO its1_source VALUES(1766,'KT249052.1',83,670,3);
INSERT INTO its1_source VALUES(1767,'KT249053.1',83,670,3);
INSERT INTO its1_source VALUES(1768,'KT249054.1',83,670,3);
INSERT INTO its1_source VALUES(1769,'KT249055.1',83,670,3);
INSERT INTO its1_source VALUES(1770,'KT249056.1',83,670,3);
INSERT INTO its1_source VALUES(1771,'KT249057.1',83,670,3);
INSERT INTO its1_source VALUES(1772,'KT249058.1',83,670,3);
INSERT INTO its1_source VALUES(1773,'KT249059.1',83,670,3);
INSERT INTO its1_source VALUES(1774,'KT249060.1',83,667,3);
INSERT INTO its1_source VALUES(1775,'KT249061.1',83,667,3);
INSERT INTO its1_source VALUES(1776,'KT249062.1',83,667,3);
INSERT INTO its1_source VALUES(1777,'KT249063.1',83,667,3);
INSERT INTO its1_source VALUES(1778,'KT249064.1',83,667,3);
INSERT INTO its1_source VALUES(1779,'KT249065.1',83,264,3);
INSERT INTO its1_source VALUES(1780,'KT249066.1',83,264,3);
INSERT INTO its1_source VALUES(1781,'KT249067.1',83,264,3);
INSERT INTO its1_source VALUES(1782,'KT249068.1',83,264,3);
INSERT INTO its1_source VALUES(1783,'KT249069.1',83,264,3);
INSERT INTO its1_source VALUES(1784,'KT249070.1',83,264,3);
INSERT INTO its1_source VALUES(1785,'KT249071.1',83,264,3);
INSERT INTO its1_source VALUES(1786,'KT249072.1',83,671,3);
INSERT INTO its1_source VALUES(1787,'KT249073.1',83,5,3);
INSERT INTO its1_source VALUES(1788,'KT249074.1',83,671,3);
INSERT INTO its1_source VALUES(1789,'KT249075.1',83,671,3);
INSERT INTO its1_source VALUES(1790,'KT249076.1',83,672,3);
INSERT INTO its1_source VALUES(1791,'KT249077.1',83,672,3);
INSERT INTO its1_source VALUES(1792,'KT249078.1',83,671,3);
INSERT INTO its1_source VALUES(1793,'KT249079.1',83,672,3);
INSERT INTO its1_source VALUES(1794,'KT249080.1',83,672,3);
INSERT INTO its1_source VALUES(1795,'KT249081.1',83,672,3);
INSERT INTO its1_source VALUES(1796,'KT249082.1',83,672,3);
INSERT INTO its1_source VALUES(1797,'KT249083.1',83,671,3);
INSERT INTO its1_source VALUES(1798,'KT249084.1',83,671,3);
INSERT INTO its1_source VALUES(1799,'KT249085.1',83,671,3);
INSERT INTO its1_source VALUES(1800,'KT249086.1',83,671,3);
INSERT INTO its1_source VALUES(1801,'KT249087.1',83,671,3);
INSERT INTO its1_source VALUES(1802,'KT249088.1',83,671,3);
INSERT INTO its1_source VALUES(1803,'KT249089.1',83,671,3);
INSERT INTO its1_source VALUES(1804,'KT249090.1',83,671,3);
INSERT INTO its1_source VALUES(1805,'KT249091.1',83,671,3);
INSERT INTO its1_source VALUES(1806,'KT249092.1',83,671,3);
INSERT INTO its1_source VALUES(1807,'KT249093.1',83,671,3);
INSERT INTO its1_source VALUES(1808,'KT249094.1',83,671,3);
INSERT INTO its1_source VALUES(1809,'KT249095.1',83,671,3);
INSERT INTO its1_source VALUES(1810,'KT249096.1',83,671,3);
INSERT INTO its1_source VALUES(1811,'KT249097.1',83,671,3);
INSERT INTO its1_source VALUES(1812,'KT249098.1',83,671,3);
INSERT INTO its1_source VALUES(1813,'KT249099.1',83,5,3);
INSERT INTO its1_source VALUES(1814,'KT249100.1',83,257,3);
INSERT INTO its1_source VALUES(1815,'KT249101.1',83,668,3);
INSERT INTO its1_source VALUES(1816,'KT249102.1',83,5,3);
INSERT INTO its1_source VALUES(1817,'KT249103.1',83,673,3);
INSERT INTO its1_source VALUES(1818,'KT249104.1',83,673,3);
INSERT INTO its1_source VALUES(1819,'KT249105.1',83,254,34);
INSERT INTO its1_source VALUES(1820,'KT249106.1',83,5,3);
INSERT INTO its1_source VALUES(1821,'KT249107.1',83,5,3);
INSERT INTO its1_source VALUES(1822,'KT249108.1',83,5,3);
INSERT INTO its1_source VALUES(1823,'KT249109.1',83,674,3);
INSERT INTO its1_source VALUES(1824,'KT249110.1',83,675,3);
INSERT INTO its1_source VALUES(1825,'KT249111.1',83,676,3);
INSERT INTO its1_source VALUES(1826,'KT249112.1',83,676,3);
INSERT INTO its1_source VALUES(1827,'KT249113.1',83,675,3);
INSERT INTO its1_source VALUES(1828,'KT249114.1',83,675,3);
INSERT INTO its1_source VALUES(1829,'KT249115.1',83,224,3);
INSERT INTO its1_source VALUES(1830,'KT249116.1',83,224,3);
INSERT INTO its1_source VALUES(1831,'KT249117.1',83,677,3);
INSERT INTO its1_source VALUES(1832,'KT249118.1',83,677,3);
INSERT INTO its1_source VALUES(1833,'KT249119.1',83,677,3);
INSERT INTO its1_source VALUES(1834,'KT249120.1',83,678,3);
INSERT INTO its1_source VALUES(1835,'KT249121.1',83,678,3);
INSERT INTO its1_source VALUES(1836,'KT249122.1',83,223,3);
INSERT INTO its1_source VALUES(1837,'KT249123.1',83,223,3);
INSERT INTO its1_source VALUES(1838,'KT249124.1',83,223,3);
INSERT INTO its1_source VALUES(1839,'KT249125.1',83,671,3);
INSERT INTO its1_source VALUES(1840,'KT249126.1',83,671,3);
INSERT INTO its1_source VALUES(1841,'KT249127.1',83,679,3);
INSERT INTO its1_source VALUES(1842,'KT249128.1',83,661,3);
INSERT INTO its1_source VALUES(1843,'KT249129.1',83,264,3);
INSERT INTO its1_source VALUES(1844,'KT249130.1',83,264,3);
INSERT INTO its1_source VALUES(1845,'KT249131.1',83,264,3);
INSERT INTO its1_source VALUES(1846,'KT249132.1',83,663,3);
INSERT INTO its1_source VALUES(1847,'KT249133.1',83,663,3);
INSERT INTO its1_source VALUES(1848,'KT249134.1',83,667,3);
INSERT INTO its1_source VALUES(1849,'KT249135.1',83,670,3);
INSERT INTO its1_source VALUES(1850,'KT249136.1',83,264,3);
INSERT INTO its1_source VALUES(1851,'KT249137.1',83,264,3);
INSERT INTO its1_source VALUES(1852,'KT249138.1',83,264,3);
INSERT INTO its1_source VALUES(1853,'KT249139.1',83,680,3);
INSERT INTO its1_source VALUES(1854,'KT249140.1',83,5,3);
INSERT INTO its1_source VALUES(1855,'KT249141.1',83,264,3);
INSERT INTO its1_source VALUES(1856,'KT249142.1',83,255,49);
INSERT INTO its1_source VALUES(1857,'KT249143.1',83,252,39);
INSERT INTO its1_source VALUES(1858,'KT250631.1',83,681,5);
INSERT INTO its1_source VALUES(1859,'KT265813.1',83,13,5);
INSERT INTO its1_source VALUES(1860,'KT265814.1',83,13,5);
INSERT INTO its1_source VALUES(1861,'KT265815.1',83,13,5);
INSERT INTO its1_source VALUES(1862,'KT285842.1',83,682,9);
INSERT INTO its1_source VALUES(1863,'KT285843.1',83,682,9);
INSERT INTO its1_source VALUES(1864,'KT306841.1',83,303,5);
INSERT INTO its1_source VALUES(1865,'KT306842.1',83,109,5);
INSERT INTO its1_source VALUES(1866,'KT306851.1',83,109,5);
INSERT INTO its1_source VALUES(1867,'KT306860.1',83,208,5);
INSERT INTO its1_source VALUES(1868,'KT306862.1',83,208,5);
INSERT INTO its1_source VALUES(1869,'KT306869.1',83,235,5);
INSERT INTO its1_source VALUES(1870,'KT306871.1',83,208,5);
INSERT INTO its1_source VALUES(1871,'KT306874.1',83,208,5);
INSERT INTO its1_source VALUES(1872,'KT306876.1',83,208,5);
INSERT INTO its1_source VALUES(1873,'KT306877.1',83,235,5);
INSERT INTO its1_source VALUES(1874,'KT306878.1',83,208,5);
INSERT INTO its1_source VALUES(1875,'KT306879.1',83,208,5);
INSERT INTO its1_source VALUES(1876,'KT306881.1',83,208,5);
INSERT INTO its1_source VALUES(1877,'KT306888.1',83,235,5);
INSERT INTO its1_source VALUES(1878,'KT306889.1',83,208,5);
INSERT INTO its1_source VALUES(1879,'KT306890.1',83,208,5);
INSERT INTO its1_source VALUES(1880,'KT306891.1',83,235,5);
INSERT INTO its1_source VALUES(1881,'KT306892.1',83,208,5);
INSERT INTO its1_source VALUES(1882,'KT306894.1',83,235,5);
INSERT INTO its1_source VALUES(1883,'KT306900.1',83,208,5);
INSERT INTO its1_source VALUES(1884,'KT306901.1',83,235,5);
INSERT INTO its1_source VALUES(1885,'KT350498.1',83,235,5);
INSERT INTO its1_source VALUES(1886,'KT350499.1',83,683,5);
INSERT INTO its1_source VALUES(1887,'KT350500.2',83,41,5);
INSERT INTO its1_source VALUES(1888,'KT361201.1',83,206,5);
INSERT INTO its1_source VALUES(1889,'KT361202.1',83,206,5);
INSERT INTO its1_source VALUES(1890,'KT363855.1',83,684,5);
INSERT INTO its1_source VALUES(1891,'KT363858.1',83,11,5);
INSERT INTO its1_source VALUES(1892,'KT363859.1',83,306,5);
INSERT INTO its1_source VALUES(1893,'KT363860.1',83,11,5);
INSERT INTO its1_source VALUES(1894,'KT363862.1',83,11,5);
INSERT INTO its1_source VALUES(1895,'KT363863.1',83,11,5);
INSERT INTO its1_source VALUES(1896,'KT363865.1',83,11,5);
INSERT INTO its1_source VALUES(1897,'KT383038.2',83,20,5);
INSERT INTO its1_source VALUES(1898,'KT383039.1',83,685,5);
INSERT INTO its1_source VALUES(1899,'KT383040.2',83,686,5);
INSERT INTO its1_source VALUES(1900,'KT383041.2',83,687,5);
INSERT INTO its1_source VALUES(1901,'KT383042.1',83,20,5);
INSERT INTO its1_source VALUES(1902,'KT383043.2',83,20,5);
INSERT INTO its1_source VALUES(1903,'KT383044.2',83,20,5);
INSERT INTO its1_source VALUES(1904,'KT383045.1',83,20,5);
INSERT INTO its1_source VALUES(1905,'KT383046.1',83,20,5);
INSERT INTO its1_source VALUES(1906,'KT383047.2',83,20,5);
INSERT INTO its1_source VALUES(1907,'KT383048.1',83,237,5);
INSERT INTO its1_source VALUES(1908,'KT383049.2',83,237,5);
INSERT INTO its1_source VALUES(1909,'KT383050.1',83,237,5);
INSERT INTO its1_source VALUES(1910,'KT383051.1',83,237,5);
INSERT INTO its1_source VALUES(1911,'KT383052.1',83,237,5);
INSERT INTO its1_source VALUES(1912,'KT383053.2',83,53,5);
INSERT INTO its1_source VALUES(1913,'KT383054.2',83,53,5);
INSERT INTO its1_source VALUES(1914,'KT383055.1',83,235,5);
INSERT INTO its1_source VALUES(1915,'KT383056.1',83,235,5);
INSERT INTO its1_source VALUES(1916,'KT383057.2',83,235,5);
INSERT INTO its1_source VALUES(1917,'KT383058.1',83,235,5);
INSERT INTO its1_source VALUES(1918,'KT383059.2',83,235,5);
INSERT INTO its1_source VALUES(1919,'KT595686.1',83,688,55);
INSERT INTO its1_source VALUES(1920,'KT722768.1',83,195,5);
INSERT INTO its1_source VALUES(1921,'KT750954.1',83,182,55);
INSERT INTO its1_source VALUES(1922,'KT826759.1',83,614,5);
INSERT INTO its1_source VALUES(1923,'KT884525.1',83,689,5);
INSERT INTO its1_source VALUES(1924,'KU161589.1',83,690,9);
INSERT INTO its1_source VALUES(1925,'KU209127.1',83,691,55);
INSERT INTO its1_source VALUES(1926,'KU210448.1',83,84,62);
INSERT INTO its1_source VALUES(1927,'KU210450.1',83,78,5);
INSERT INTO its1_source VALUES(1928,'KU210451.1',83,78,5);
INSERT INTO its1_source VALUES(1929,'KU210452.1',83,78,5);
INSERT INTO its1_source VALUES(1930,'KU210453.1',83,78,5);
INSERT INTO its1_source VALUES(1931,'KU210454.1',83,692,6);
INSERT INTO its1_source VALUES(1932,'KU210477.1',83,693,62);
INSERT INTO its1_source VALUES(1933,'KU210544.1',83,694,62);
INSERT INTO its1_source VALUES(1934,'KU210555.1',83,695,5);
INSERT INTO its1_source VALUES(1935,'KU210688.1',83,84,62);
INSERT INTO its1_source VALUES(1936,'KU210725.1',83,696,62);
INSERT INTO its1_source VALUES(1937,'KU210728.1',83,697,62);
INSERT INTO its1_source VALUES(1938,'KU210729.1',83,698,6);
INSERT INTO its1_source VALUES(1939,'KU210947.1',83,78,5);
INSERT INTO its1_source VALUES(1940,'KU210948.1',83,78,5);
INSERT INTO its1_source VALUES(1941,'KU210973.1',83,699,62);
INSERT INTO its1_source VALUES(1942,'KU210974.1',83,77,5);
INSERT INTO its1_source VALUES(1943,'KU210981.1',83,175,62);
INSERT INTO its1_source VALUES(1944,'KU210983.1',83,700,62);
INSERT INTO its1_source VALUES(1945,'KU210998.1',83,699,62);
INSERT INTO its1_source VALUES(1946,'KU210999.1',83,77,5);
INSERT INTO its1_source VALUES(1947,'KU211000.1',83,78,5);
INSERT INTO its1_source VALUES(1948,'KU211001.1',83,697,62);
INSERT INTO its1_source VALUES(1949,'KU211003.1',83,699,62);
INSERT INTO its1_source VALUES(1950,'KU211004.1',83,175,62);
INSERT INTO its1_source VALUES(1951,'KU211006.1',83,701,62);
INSERT INTO its1_source VALUES(1952,'KU211008.1',83,702,62);
INSERT INTO its1_source VALUES(1953,'KU211080.1',83,703,5);
INSERT INTO its1_source VALUES(1954,'KU211081.1',83,704,62);
INSERT INTO its1_source VALUES(1955,'KU211093.1',83,175,62);
INSERT INTO its1_source VALUES(1956,'KU211242.1',83,705,5);
INSERT INTO its1_source VALUES(1957,'KU211243.1',83,77,5);
INSERT INTO its1_source VALUES(1958,'KU211245.1',83,706,62);
INSERT INTO its1_source VALUES(1959,'KU211246.1',83,707,62);
INSERT INTO its1_source VALUES(1960,'KU211247.1',83,708,62);
INSERT INTO its1_source VALUES(1961,'KU211248.1',83,77,5);
INSERT INTO its1_source VALUES(1962,'KU211253.1',83,709,55);
INSERT INTO its1_source VALUES(1963,'KU211259.1',83,710,5);
INSERT INTO its1_source VALUES(1964,'KU211297.1',83,204,5);
INSERT INTO its1_source VALUES(1965,'KU211304.1',83,204,5);
INSERT INTO its1_source VALUES(1966,'KU211310.1',83,78,5);
INSERT INTO its1_source VALUES(1967,'KU211312.1',83,78,5);
INSERT INTO its1_source VALUES(1968,'KU211313.1',83,78,5);
INSERT INTO its1_source VALUES(1969,'KU211314.1',83,78,5);
INSERT INTO its1_source VALUES(1970,'KU211315.1',83,78,5);
INSERT INTO its1_source VALUES(1971,'KU211316.1',83,77,5);
INSERT INTO its1_source VALUES(1972,'KU211317.1',83,78,5);
INSERT INTO its1_source VALUES(1973,'KU211318.1',83,78,5);
INSERT INTO its1_source VALUES(1974,'KU211319.1',83,78,5);
INSERT INTO its1_source VALUES(1975,'KU211320.1',83,78,5);
INSERT INTO its1_source VALUES(1976,'KU211321.1',83,78,5);
INSERT INTO its1_source VALUES(1977,'KU211322.1',83,78,5);
INSERT INTO its1_source VALUES(1978,'KU211323.1',83,78,5);
INSERT INTO its1_source VALUES(1979,'KU211324.1',83,78,5);
INSERT INTO its1_source VALUES(1980,'KU211325.1',83,78,5);
INSERT INTO its1_source VALUES(1981,'KU211326.1',83,78,5);
INSERT INTO its1_source VALUES(1982,'KU211327.1',83,78,5);
INSERT INTO its1_source VALUES(1983,'KU211328.1',83,78,5);
INSERT INTO its1_source VALUES(1984,'KU211329.1',83,78,5);
INSERT INTO its1_source VALUES(1985,'KU211330.1',83,78,5);
INSERT INTO its1_source VALUES(1986,'KU211331.1',83,77,5);
INSERT INTO its1_source VALUES(1987,'KU211332.1',83,78,5);
INSERT INTO its1_source VALUES(1988,'KU211334.1',83,78,5);
INSERT INTO its1_source VALUES(1989,'KU211335.1',83,78,5);
INSERT INTO its1_source VALUES(1990,'KU211336.1',83,78,5);
INSERT INTO its1_source VALUES(1991,'KU211337.1',83,78,5);
INSERT INTO its1_source VALUES(1992,'KU211339.1',83,78,5);
INSERT INTO its1_source VALUES(1993,'KU211340.1',83,78,5);
INSERT INTO its1_source VALUES(1994,'KU211341.1',83,78,5);
INSERT INTO its1_source VALUES(1995,'KU211342.1',83,78,5);
INSERT INTO its1_source VALUES(1996,'KU211343.1',83,711,5);
INSERT INTO its1_source VALUES(1997,'KU211344.1',83,78,5);
INSERT INTO its1_source VALUES(1998,'KU211345.1',83,78,5);
INSERT INTO its1_source VALUES(1999,'KU211346.1',83,78,5);
INSERT INTO its1_source VALUES(2000,'KU211347.1',83,78,5);
INSERT INTO its1_source VALUES(2001,'KU211348.1',83,78,5);
INSERT INTO its1_source VALUES(2002,'KU211351.1',83,712,5);
INSERT INTO its1_source VALUES(2003,'KU211353.1',83,77,5);
INSERT INTO its1_source VALUES(2004,'KU211355.1',83,77,5);
INSERT INTO its1_source VALUES(2005,'KU211356.1',83,78,5);
INSERT INTO its1_source VALUES(2006,'KU211357.1',83,709,55);
INSERT INTO its1_source VALUES(2007,'KU211358.1',83,713,62);
INSERT INTO its1_source VALUES(2008,'KU211362.1',83,714,5);
INSERT INTO its1_source VALUES(2009,'KU211363.1',83,702,62);
INSERT INTO its1_source VALUES(2010,'KU211374.1',83,715,62);
INSERT INTO its1_source VALUES(2011,'KU211402.1',83,716,62);
INSERT INTO its1_source VALUES(2012,'KU211403.1',83,77,5);
INSERT INTO its1_source VALUES(2013,'KU211404.1',83,78,5);
INSERT INTO its1_source VALUES(2014,'KU211405.1',83,77,5);
INSERT INTO its1_source VALUES(2015,'KU211406.1',83,77,5);
INSERT INTO its1_source VALUES(2016,'KU211407.1',83,77,5);
INSERT INTO its1_source VALUES(2017,'KU211408.1',83,77,5);
INSERT INTO its1_source VALUES(2018,'KU211409.1',83,77,5);
INSERT INTO its1_source VALUES(2019,'KU211410.1',83,699,62);
INSERT INTO its1_source VALUES(2020,'KU211411.1',83,77,5);
INSERT INTO its1_source VALUES(2021,'KU211412.1',83,78,5);
INSERT INTO its1_source VALUES(2022,'KU211415.1',83,640,62);
INSERT INTO its1_source VALUES(2023,'KU211417.1',83,186,62);
INSERT INTO its1_source VALUES(2024,'KU211419.1',83,717,62);
INSERT INTO its1_source VALUES(2025,'KU211421.1',83,175,62);
INSERT INTO its1_source VALUES(2026,'KU211423.1',83,718,62);
INSERT INTO its1_source VALUES(2027,'KU211424.1',83,175,62);
INSERT INTO its1_source VALUES(2028,'KU211425.1',83,175,62);
INSERT INTO its1_source VALUES(2029,'KU211427.1',83,175,62);
INSERT INTO its1_source VALUES(2030,'KU211429.1',83,719,62);
INSERT INTO its1_source VALUES(2031,'KU211430.1',83,720,62);
INSERT INTO its1_source VALUES(2032,'KU211431.1',83,445,62);
INSERT INTO its1_source VALUES(2033,'KU211433.1',83,721,62);
INSERT INTO its1_source VALUES(2034,'KU211434.1',83,702,62);
INSERT INTO its1_source VALUES(2035,'KU211435.1',83,722,62);
INSERT INTO its1_source VALUES(2036,'KU211436.1',83,702,62);
INSERT INTO its1_source VALUES(2037,'KU211437.1',83,702,62);
INSERT INTO its1_source VALUES(2038,'KU211438.1',83,445,62);
INSERT INTO its1_source VALUES(2039,'KU211465.1',83,84,62);
INSERT INTO its1_source VALUES(2040,'KU211466.1',83,64,5);
INSERT INTO its1_source VALUES(2041,'KU211468.1',83,723,62);
INSERT INTO its1_source VALUES(2042,'KU211469.1',83,64,5);
INSERT INTO its1_source VALUES(2043,'KU211474.1',83,699,62);
INSERT INTO its1_source VALUES(2044,'KU211475.1',83,699,62);
INSERT INTO its1_source VALUES(2045,'KU211476.1',83,724,62);
INSERT INTO its1_source VALUES(2046,'KU211478.1',83,725,62);
INSERT INTO its1_source VALUES(2047,'KU211479.1',83,726,62);
INSERT INTO its1_source VALUES(2048,'KU211481.1',83,693,62);
INSERT INTO its1_source VALUES(2049,'KU211483.1',83,727,62);
INSERT INTO its1_source VALUES(2050,'KU211484.1',83,728,62);
INSERT INTO its1_source VALUES(2051,'KU211485.1',83,175,62);
INSERT INTO its1_source VALUES(2052,'KU211489.1',83,729,62);
INSERT INTO its1_source VALUES(2053,'KU211490.1',83,730,62);
INSERT INTO its1_source VALUES(2054,'KU211492.1',83,707,62);
INSERT INTO its1_source VALUES(2055,'KU211493.1',83,731,62);
INSERT INTO its1_source VALUES(2056,'KU211494.1',83,702,62);
INSERT INTO its1_source VALUES(2057,'KU211500.1',83,77,5);
INSERT INTO its1_source VALUES(2058,'KU211501.1',83,732,62);
INSERT INTO its1_source VALUES(2059,'KU221328.1',83,235,5);
INSERT INTO its1_source VALUES(2060,'KU310651.1',83,585,5);
INSERT INTO its1_source VALUES(2061,'KU310652.1',83,585,5);
INSERT INTO its1_source VALUES(2062,'KU310653.1',83,585,5);
INSERT INTO its1_source VALUES(2063,'KU518776.1',83,513,5);
INSERT INTO its1_source VALUES(2064,'KU518777.1',83,513,5);
INSERT INTO its1_source VALUES(2065,'KU518778.1',83,513,5);
INSERT INTO its1_source VALUES(2066,'KU518779.1',83,540,5);
INSERT INTO its1_source VALUES(2067,'KU518780.1',83,541,5);
INSERT INTO its1_source VALUES(2068,'KU518781.1',83,513,5);
INSERT INTO its1_source VALUES(2069,'KU518782.1',83,513,5);
INSERT INTO its1_source VALUES(2070,'KU518783.1',83,513,5);
INSERT INTO its1_source VALUES(2071,'KU518784.1',83,540,5);
INSERT INTO its1_source VALUES(2072,'KU518785.1',83,541,5);
INSERT INTO its1_source VALUES(2073,'KU518786.1',83,533,5);
INSERT INTO its1_source VALUES(2074,'KU518787.1',83,534,5);
INSERT INTO its1_source VALUES(2075,'KU518788.1',83,733,5);
INSERT INTO its1_source VALUES(2076,'KU518789.1',83,537,5);
INSERT INTO its1_source VALUES(2077,'KU518790.1',83,538,5);
INSERT INTO its1_source VALUES(2078,'KU518791.1',83,538,5);
INSERT INTO its1_source VALUES(2079,'KU518792.1',83,538,5);
INSERT INTO its1_source VALUES(2080,'KU518793.1',83,538,5);
INSERT INTO its1_source VALUES(2081,'KU518794.1',83,538,5);
INSERT INTO its1_source VALUES(2082,'KU518795.1',83,542,5);
INSERT INTO its1_source VALUES(2083,'KU518797.1',83,734,5);
INSERT INTO its1_source VALUES(2084,'KU518798.1',83,546,5);
INSERT INTO its1_source VALUES(2085,'KU518799.1',83,538,5);
INSERT INTO its1_source VALUES(2086,'KU518800.1',83,547,5);
INSERT INTO its1_source VALUES(2087,'KU518801.1',83,548,5);
INSERT INTO its1_source VALUES(2088,'KU518802.1',83,735,5);
INSERT INTO its1_source VALUES(2089,'KU518805.1',83,551,5);
INSERT INTO its1_source VALUES(2090,'KU518806.1',83,552,5);
INSERT INTO its1_source VALUES(2091,'KU645759.1',83,195,5);
INSERT INTO its1_source VALUES(2092,'KU682560.1',83,50,5);
INSERT INTO its1_source VALUES(2093,'KU682562.1',83,736,5);
INSERT INTO its1_source VALUES(2094,'KU682567.1',83,13,5);
INSERT INTO its1_source VALUES(2095,'KU682568.1',83,13,5);
INSERT INTO its1_source VALUES(2096,'KU682569.1',83,230,5);
INSERT INTO its1_source VALUES(2097,'KU682571.1',83,160,5);
INSERT INTO its1_source VALUES(2098,'KU682577.1',83,598,5);
INSERT INTO its1_source VALUES(2099,'KU682578.1',83,737,5);
INSERT INTO its1_source VALUES(2100,'KU682579.1',83,738,5);
INSERT INTO its1_source VALUES(2101,'KU682580.1',83,195,5);
INSERT INTO its1_source VALUES(2102,'KU682582.1',83,118,5);
INSERT INTO its1_source VALUES(2103,'KU682584.1',83,739,5);
INSERT INTO its1_source VALUES(2104,'KU682603.1',83,740,5);
INSERT INTO its1_source VALUES(2105,'KU682604.1',83,741,5);
INSERT INTO its1_source VALUES(2106,'KU682605.1',83,742,5);
INSERT INTO its1_source VALUES(2107,'KU682609.1',83,743,5);
INSERT INTO its1_source VALUES(2109,'KU715059.1',83,744,6);
INSERT INTO its1_source VALUES(2110,'KU715060.1',83,745,6);
INSERT INTO its1_source VALUES(2111,'KU715062.1',83,745,6);
INSERT INTO its1_source VALUES(2112,'KU715063.1',83,745,6);
INSERT INTO its1_source VALUES(2113,'KU948930.1',83,746,9);
INSERT INTO its1_source VALUES(2114,'KU961895.1',83,747,55);
INSERT INTO its1_source VALUES(2115,'KU961897.1',83,13,5);
INSERT INTO its1_source VALUES(2116,'KU961898.1',83,13,5);
INSERT INTO its1_source VALUES(2117,'KU961899.1',83,470,55);
INSERT INTO its1_source VALUES(2118,'KU961900.1',83,470,55);
INSERT INTO its1_source VALUES(2119,'KU961902.1',83,230,5);
INSERT INTO its1_source VALUES(2120,'KU961903.1',83,470,55);
INSERT INTO its1_source VALUES(2121,'KU961904.1',83,230,5);
INSERT INTO its1_source VALUES(2122,'KU961905.1',83,747,55);
INSERT INTO its1_source VALUES(2123,'KU961906.1',83,13,5);
INSERT INTO its1_source VALUES(2124,'KU961907.1',83,13,5);
INSERT INTO its1_source VALUES(2125,'KU961908.1',83,64,5);
INSERT INTO its1_source VALUES(2126,'KX090410.1',83,469,62);
INSERT INTO its1_source VALUES(2127,'KX118438.1',83,748,9);
INSERT INTO its1_source VALUES(2128,'KX231682.1',83,749,35);
INSERT INTO its1_source VALUES(2129,'KX257260.1',83,206,5);
INSERT INTO its1_source VALUES(2130,'KX371899.1',83,190,5);
INSERT INTO its1_source VALUES(2131,'KX371900.1',83,750,5);
INSERT INTO its1_source VALUES(2132,'KX423736.1',83,240,5);
INSERT INTO its1_source VALUES(2133,'KX423737.1',83,240,5);
INSERT INTO its1_source VALUES(2134,'KX423738.1',83,240,5);
INSERT INTO its1_source VALUES(2135,'KX618503.1',83,235,5);
INSERT INTO its1_source VALUES(2136,'KX618504.1',83,235,5);
INSERT INTO its1_source VALUES(2137,'KX683285.1',83,305,5);
INSERT INTO its1_source VALUES(2138,'KX822120.1',83,338,9);
INSERT INTO its1_source VALUES(2139,'KX844996.1',83,20,5);
INSERT INTO its1_source VALUES(2140,'KX844997.1',83,235,5);
INSERT INTO its1_source VALUES(2141,'KX844998.1',83,46,5);
INSERT INTO its1_source VALUES(2142,'KX844999.1',83,67,5);
INSERT INTO its1_source VALUES(2143,'KX845000.1',83,13,5);
INSERT INTO its1_source VALUES(2144,'KX845001.1',83,26,5);
INSERT INTO its1_source VALUES(2145,'KX845002.1',83,585,5);
INSERT INTO its1_source VALUES(2146,'KX845003.1',83,751,62);
INSERT INTO its1_source VALUES(2147,'KX845004.1',83,165,5);
INSERT INTO its1_source VALUES(2148,'KX906603.1',83,46,5);
INSERT INTO its1_source VALUES(2149,'KX925551.1',83,752,5);
INSERT INTO its1_source VALUES(2150,'KX925552.1',83,117,5);
INSERT INTO its1_source VALUES(2151,'KY197718.1',83,753,5);
INSERT INTO its1_source VALUES(2152,'KY197719.1',83,754,5);
INSERT INTO its1_source VALUES(2153,'KY197720.1',83,755,5);
INSERT INTO its1_source VALUES(2154,'KY197721.1',83,399,5);
INSERT INTO its1_source VALUES(2155,'KY197722.1',83,399,5);
INSERT INTO its1_source VALUES(2156,'KY197723.1',83,756,5);
INSERT INTO its1_source VALUES(2157,'KY322141.1',83,757,5);
INSERT INTO its1_source VALUES(2158,'KY322142.1',83,758,5);
INSERT INTO its1_source VALUES(2159,'KY447326.1',83,347,5);
INSERT INTO its1_source VALUES(2160,'KY475615.1',83,399,5);
INSERT INTO its1_source VALUES(2161,'KY475616.1',83,399,5);
INSERT INTO its1_source VALUES(2162,'KY475617.1',83,399,5);
INSERT INTO its1_source VALUES(2163,'KY475618.1',83,399,5);
INSERT INTO its1_source VALUES(2164,'KY475619.1',83,399,5);
INSERT INTO its1_source VALUES(2165,'KY475620.1',83,399,5);
INSERT INTO its1_source VALUES(2166,'KY475621.1',83,399,5);
INSERT INTO its1_source VALUES(2167,'KY475622.1',83,759,5);
INSERT INTO its1_source VALUES(2168,'KY475623.1',83,760,5);
INSERT INTO its1_source VALUES(2169,'KY475624.1',83,761,5);
INSERT INTO its1_source VALUES(2170,'KY475625.1',83,399,5);
INSERT INTO its1_source VALUES(2171,'KY475626.1',83,762,5);
INSERT INTO its1_source VALUES(2172,'KY475627.1',83,399,5);
INSERT INTO its1_source VALUES(2173,'KY475628.1',83,399,5);
INSERT INTO its1_source VALUES(2174,'KY475629.1',83,399,5);
INSERT INTO its1_source VALUES(2175,'KY475630.1',83,399,5);
INSERT INTO its1_source VALUES(2176,'KY475631.1',83,399,5);
INSERT INTO its1_source VALUES(2177,'KY475632.1',83,399,5);
INSERT INTO its1_source VALUES(2178,'KY475633.1',83,399,5);
INSERT INTO its1_source VALUES(2179,'KY475634.1',83,756,5);
INSERT INTO its1_source VALUES(2180,'KY490699.1',83,763,5);
INSERT INTO its1_source VALUES(2181,'KY575676.1',83,764,5);
INSERT INTO its1_source VALUES(2182,'KY747521.1',83,709,55);
INSERT INTO its1_source VALUES(2183,'KY751715.1',83,765,5);
INSERT INTO its1_source VALUES(2184,'KY751716.1',83,765,5);
INSERT INTO its1_source VALUES(2185,'KY785379.1',83,766,6);
INSERT INTO its1_source VALUES(2188,'KY785385.1',83,767,6);
INSERT INTO its1_source VALUES(2189,'KY785395.1',83,768,6);
INSERT INTO its1_source VALUES(2190,'KY930644.1',83,499,5);
INSERT INTO its1_source VALUES(2191,'LC076471.1',83,769,5);
INSERT INTO its1_source VALUES(2192,'LM650992.1',83,60,5);
INSERT INTO its1_source VALUES(2193,'LM650997.1',83,117,5);
INSERT INTO its1_source VALUES(2194,'LM650998.1',83,117,5);
INSERT INTO its1_source VALUES(2195,'LM650999.1',83,117,5);
INSERT INTO its1_source VALUES(2196,'LM651001.1',83,117,5);
INSERT INTO its1_source VALUES(2197,'LM651003.1',83,117,5);
INSERT INTO its1_source VALUES(2198,'LM651011.1',83,397,55);
INSERT INTO its1_source VALUES(2199,'LM651012.1',83,470,55);
INSERT INTO its1_source VALUES(2200,'LR535923.1',83,399,5);
INSERT INTO its1_source VALUES(2201,'LS479175.1',83,770,5);
INSERT INTO its1_source VALUES(2202,'LS479896.1',83,770,5);
INSERT INTO its1_source VALUES(2203,'LS999935.1',83,771,5);
INSERT INTO its1_source VALUES(2204,'LT628537.1',83,772,5);
INSERT INTO its1_source VALUES(2205,'LT628538.1',83,773,5);
INSERT INTO its1_source VALUES(2206,'LT628539.1',83,773,5);
INSERT INTO its1_source VALUES(2207,'LT670911.1',83,468,62);
INSERT INTO its1_source VALUES(2208,'LT670914.1',83,774,5);
INSERT INTO its1_source VALUES(2209,'LT707525.1',83,118,5);
INSERT INTO its1_source VALUES(2210,'LT707526.1',83,118,5);
INSERT INTO its1_source VALUES(2211,'LT707527.1',83,636,5);
INSERT INTO its1_source VALUES(2212,'LT707528.1',83,775,5);
INSERT INTO its1_source VALUES(2213,'LT707529.1',83,775,5);
INSERT INTO its1_source VALUES(2214,'LT707530.1',83,776,5);
INSERT INTO its1_source VALUES(2215,'LT707531.1',83,777,5);
INSERT INTO its1_source VALUES(2216,'LT707535.1',83,29,5);
INSERT INTO its1_source VALUES(2217,'LT707536.1',83,29,5);
INSERT INTO its1_source VALUES(2218,'LT707537.1',83,29,5);
INSERT INTO its1_source VALUES(2219,'LT707538.1',83,339,5);
INSERT INTO its1_source VALUES(2220,'LT707539.1',83,775,5);
INSERT INTO its1_source VALUES(2221,'LT707540.1',83,29,5);
INSERT INTO its1_source VALUES(2222,'MF034088.1',83,778,5);
INSERT INTO its1_source VALUES(2223,'MF034089.1',83,779,5);
INSERT INTO its1_source VALUES(2224,'MF034090.1',83,780,5);
INSERT INTO its1_source VALUES(2225,'MF034091.1',83,781,5);
INSERT INTO its1_source VALUES(2226,'MF034092.1',83,782,5);
INSERT INTO its1_source VALUES(2227,'MF034093.1',83,782,5);
INSERT INTO its1_source VALUES(2228,'MF034094.1',83,782,5);
INSERT INTO its1_source VALUES(2229,'MF034095.1',83,782,5);
INSERT INTO its1_source VALUES(2230,'MF034096.1',83,783,5);
INSERT INTO its1_source VALUES(2231,'MF094304.1',83,340,5);
INSERT INTO its1_source VALUES(2232,'MF138883.1',83,784,5);
INSERT INTO its1_source VALUES(2233,'MF138884.1',83,784,5);
INSERT INTO its1_source VALUES(2234,'MF149917.1',83,204,5);
INSERT INTO its1_source VALUES(2235,'MF155576.1',83,36,5);
INSERT INTO its1_source VALUES(2236,'MF319537.1',83,785,9);
INSERT INTO its1_source VALUES(2237,'MF356294.1',83,96,5);
INSERT INTO its1_source VALUES(2238,'MF356295.1',83,96,5);
INSERT INTO its1_source VALUES(2239,'MF356296.1',83,96,5);
INSERT INTO its1_source VALUES(2240,'MF356297.1',83,96,5);
INSERT INTO its1_source VALUES(2241,'MF356678.1',83,786,6);
INSERT INTO its1_source VALUES(2242,'MF370566.1',83,60,5);
INSERT INTO its1_source VALUES(2243,'MF370567.1',83,60,5);
INSERT INTO its1_source VALUES(2244,'MF370572.1',83,611,5);
INSERT INTO its1_source VALUES(2245,'MF370574.1',83,773,5);
INSERT INTO its1_source VALUES(2246,'MF370575.1',83,773,5);
INSERT INTO its1_source VALUES(2247,'MF372422.1',83,787,9);
INSERT INTO its1_source VALUES(2248,'MF372507.1',83,788,9);
INSERT INTO its1_source VALUES(2249,'MF372740.1',83,789,4);
INSERT INTO its1_source VALUES(2250,'MF372741.1',83,790,4);
INSERT INTO its1_source VALUES(2251,'MF372742.1',83,586,4);
INSERT INTO its1_source VALUES(2252,'MF372743.1',83,790,4);
INSERT INTO its1_source VALUES(2253,'MF372744.1',83,790,4);
INSERT INTO its1_source VALUES(2254,'MF372745.1',83,790,4);
INSERT INTO its1_source VALUES(2255,'MF372746.1',83,790,4);
INSERT INTO its1_source VALUES(2256,'MF372747.1',83,791,4);
INSERT INTO its1_source VALUES(2257,'MF372748.1',83,790,4);
INSERT INTO its1_source VALUES(2258,'MF372749.1',83,790,4);
INSERT INTO its1_source VALUES(2259,'MF372750.1',83,792,4);
INSERT INTO its1_source VALUES(2260,'MF459634.1',83,793,55);
INSERT INTO its1_source VALUES(2261,'MF459635.1',83,793,55);
INSERT INTO its1_source VALUES(2262,'MF459636.1',83,793,55);
INSERT INTO its1_source VALUES(2263,'MF680412.1',83,794,5);
INSERT INTO its1_source VALUES(2264,'MF680415.1',83,773,5);
INSERT INTO its1_source VALUES(2265,'MF693893.1',83,795,5);
INSERT INTO its1_source VALUES(2266,'MF693894.1',83,103,9);
INSERT INTO its1_source VALUES(2267,'MF693895.1',83,103,9);
INSERT INTO its1_source VALUES(2268,'MF693896.1',83,796,9);
INSERT INTO its1_source VALUES(2269,'MF693898.1',83,797,9);
INSERT INTO its1_source VALUES(2270,'MF693899.1',83,5,3);
INSERT INTO its1_source VALUES(2271,'MF693900.1',83,671,3);
INSERT INTO its1_source VALUES(2272,'MF959532.1',83,326,5);
INSERT INTO its1_source VALUES(2273,'MF980709.1',83,798,5);
INSERT INTO its1_source VALUES(2274,'MF980710.1',83,799,5);
INSERT INTO its1_source VALUES(2275,'MF984192.1',83,183,55);
INSERT INTO its1_source VALUES(2276,'MF984193.1',83,183,55);
INSERT INTO its1_source VALUES(2277,'MG434772.1',83,60,5);
INSERT INTO its1_source VALUES(2278,'MG523188.1',83,237,5);
INSERT INTO its1_source VALUES(2279,'MG543911.1',83,800,5);
INSERT INTO its1_source VALUES(2280,'MG543912.1',83,801,5);
INSERT INTO its1_source VALUES(2281,'MG547776.1',83,237,5);
INSERT INTO its1_source VALUES(2282,'MG547777.1',83,802,5);
INSERT INTO its1_source VALUES(2283,'MG547778.1',83,237,5);
INSERT INTO its1_source VALUES(2284,'MG547779.1',83,801,5);
INSERT INTO its1_source VALUES(2285,'MG547780.1',83,237,5);
INSERT INTO its1_source VALUES(2286,'MG547781.1',83,237,5);
INSERT INTO its1_source VALUES(2287,'MG547784.1',83,237,5);
INSERT INTO its1_source VALUES(2288,'MG547786.1',83,237,5);
INSERT INTO its1_source VALUES(2289,'MG547787.1',83,237,5);
INSERT INTO its1_source VALUES(2290,'MG547788.1',83,800,5);
INSERT INTO its1_source VALUES(2291,'MG547789.1',83,803,5);
INSERT INTO its1_source VALUES(2292,'MG547790.1',83,237,5);
INSERT INTO its1_source VALUES(2293,'MG547792.1',83,237,5);
INSERT INTO its1_source VALUES(2294,'MG547793.1',83,803,5);
INSERT INTO its1_source VALUES(2295,'MG547794.1',83,782,5);
INSERT INTO its1_source VALUES(2296,'MG547795.1',83,800,5);
INSERT INTO its1_source VALUES(2297,'MG547796.1',83,237,5);
INSERT INTO its1_source VALUES(2298,'MG547797.1',83,237,5);
INSERT INTO its1_source VALUES(2299,'MG547798.1',83,237,5);
INSERT INTO its1_source VALUES(2300,'MG547799.1',83,237,5);
INSERT INTO its1_source VALUES(2301,'MG547800.1',83,237,5);
INSERT INTO its1_source VALUES(2302,'MG547801.1',83,237,5);
INSERT INTO its1_source VALUES(2303,'MG547802.1',83,237,5);
INSERT INTO its1_source VALUES(2304,'MG547803.1',83,237,5);
INSERT INTO its1_source VALUES(2305,'MG547804.1',83,237,5);
INSERT INTO its1_source VALUES(2306,'MG547805.1',83,237,5);
INSERT INTO its1_source VALUES(2307,'MG547806.1',83,237,5);
INSERT INTO its1_source VALUES(2308,'MG547807.1',83,800,5);
INSERT INTO its1_source VALUES(2309,'MG547808.1',83,237,5);
INSERT INTO its1_source VALUES(2310,'MG547811.1',83,237,5);
INSERT INTO its1_source VALUES(2311,'MG547813.1',83,782,5);
INSERT INTO its1_source VALUES(2312,'MG547814.1',83,782,5);
INSERT INTO its1_source VALUES(2313,'MG547815.1',83,237,5);
INSERT INTO its1_source VALUES(2314,'MG547816.1',83,237,5);
INSERT INTO its1_source VALUES(2315,'MG547817.1',83,804,5);
INSERT INTO its1_source VALUES(2316,'MG547818.1',83,804,5);
INSERT INTO its1_source VALUES(2317,'MG547819.1',83,804,5);
INSERT INTO its1_source VALUES(2318,'MG547820.1',83,801,5);
INSERT INTO its1_source VALUES(2319,'MG547821.1',83,237,5);
INSERT INTO its1_source VALUES(2320,'MG547822.1',83,237,5);
INSERT INTO its1_source VALUES(2321,'MG547824.1',83,804,5);
INSERT INTO its1_source VALUES(2322,'MG547825.1',83,804,5);
INSERT INTO its1_source VALUES(2323,'MG547826.1',83,801,5);
INSERT INTO its1_source VALUES(2324,'MG547828.1',83,804,5);
INSERT INTO its1_source VALUES(2325,'MG547829.1',83,804,5);
INSERT INTO its1_source VALUES(2326,'MG547830.1',83,801,5);
INSERT INTO its1_source VALUES(2327,'MG547834.1',83,805,5);
INSERT INTO its1_source VALUES(2328,'MG547835.1',83,804,5);
INSERT INTO its1_source VALUES(2329,'MG547836.1',83,237,5);
INSERT INTO its1_source VALUES(2330,'MG547837.1',83,804,5);
INSERT INTO its1_source VALUES(2331,'MG547838.1',83,804,5);
INSERT INTO its1_source VALUES(2332,'MG547840.1',83,237,5);
INSERT INTO its1_source VALUES(2333,'MG547841.1',83,782,5);
INSERT INTO its1_source VALUES(2334,'MG547845.1',83,804,5);
INSERT INTO its1_source VALUES(2335,'MG547846.1',83,782,5);
INSERT INTO its1_source VALUES(2336,'MG547847.1',83,804,5);
INSERT INTO its1_source VALUES(2337,'MG547848.1',83,801,5);
INSERT INTO its1_source VALUES(2338,'MG547850.1',83,237,5);
INSERT INTO its1_source VALUES(2339,'MG547851.1',83,803,5);
INSERT INTO its1_source VALUES(2340,'MG547853.1',83,801,5);
INSERT INTO its1_source VALUES(2341,'MG547856.1',83,806,5);
INSERT INTO its1_source VALUES(2342,'MG547857.1',83,803,5);
INSERT INTO its1_source VALUES(2343,'MG547859.1',83,803,5);
INSERT INTO its1_source VALUES(2344,'MG547860.1',83,804,5);
INSERT INTO its1_source VALUES(2345,'MG547861.1',83,237,5);
INSERT INTO its1_source VALUES(2346,'MG547862.1',83,803,5);
INSERT INTO its1_source VALUES(2347,'MG547863.1',83,804,5);
INSERT INTO its1_source VALUES(2348,'MG547864.1',83,804,5);
INSERT INTO its1_source VALUES(2349,'MG547865.1',83,807,5);
INSERT INTO its1_source VALUES(2350,'MG549036.1',83,782,5);
INSERT INTO its1_source VALUES(2351,'MG549037.1',83,237,5);
INSERT INTO its1_source VALUES(2352,'MG549038.1',83,237,5);
INSERT INTO its1_source VALUES(2353,'MG549039.1',83,782,5);
INSERT INTO its1_source VALUES(2354,'MG549040.1',83,804,5);
INSERT INTO its1_source VALUES(2355,'MG549041.1',83,800,5);
INSERT INTO its1_source VALUES(2356,'MG549043.1',83,801,5);
INSERT INTO its1_source VALUES(2357,'MG549044.1',83,803,5);
INSERT INTO its1_source VALUES(2358,'MG549045.1',83,237,5);
INSERT INTO its1_source VALUES(2359,'MG549046.1',83,782,5);
INSERT INTO its1_source VALUES(2360,'MG549047.1',83,801,5);
INSERT INTO its1_source VALUES(2361,'MG549048.1',83,804,5);
INSERT INTO its1_source VALUES(2362,'MG549049.1',83,804,5);
INSERT INTO its1_source VALUES(2363,'MG549050.1',83,237,5);
INSERT INTO its1_source VALUES(2364,'MG549051.1',83,237,5);
INSERT INTO its1_source VALUES(2365,'MG549052.1',83,800,5);
INSERT INTO its1_source VALUES(2366,'MG549053.1',83,237,5);
INSERT INTO its1_source VALUES(2367,'MG549054.1',83,237,5);
INSERT INTO its1_source VALUES(2368,'MG549055.1',83,237,5);
INSERT INTO its1_source VALUES(2369,'MG549056.1',83,237,5);
INSERT INTO its1_source VALUES(2370,'MG549057.1',83,808,5);
INSERT INTO its1_source VALUES(2371,'MG549059.1',83,803,5);
INSERT INTO its1_source VALUES(2372,'MG549061.1',83,804,5);
INSERT INTO its1_source VALUES(2373,'MG549062.1',83,804,5);
INSERT INTO its1_source VALUES(2374,'MG549064.1',83,782,5);
INSERT INTO its1_source VALUES(2375,'MG549065.1',83,237,5);
INSERT INTO its1_source VALUES(2376,'MG549066.1',83,237,5);
INSERT INTO its1_source VALUES(2377,'MG549067.1',83,237,5);
INSERT INTO its1_source VALUES(2378,'MG549068.1',83,237,5);
INSERT INTO its1_source VALUES(2379,'MG549069.1',83,237,5);
INSERT INTO its1_source VALUES(2380,'MG549070.1',83,237,5);
INSERT INTO its1_source VALUES(2381,'MG549071.1',83,237,5);
INSERT INTO its1_source VALUES(2382,'MG549072.1',83,782,5);
INSERT INTO its1_source VALUES(2383,'MG549073.1',83,237,5);
INSERT INTO its1_source VALUES(2384,'MG549074.1',83,237,5);
INSERT INTO its1_source VALUES(2385,'MG549075.1',83,801,5);
INSERT INTO its1_source VALUES(2386,'MG550122.1',83,809,5);
INSERT INTO its1_source VALUES(2387,'MG550123.1',83,810,5);
INSERT INTO its1_source VALUES(2388,'MG550124.1',83,237,5);
INSERT INTO its1_source VALUES(2389,'MG550125.1',83,802,5);
INSERT INTO its1_source VALUES(2390,'MG550126.1',83,237,5);
INSERT INTO its1_source VALUES(2391,'MG550128.1',83,237,5);
INSERT INTO its1_source VALUES(2392,'MG550129.1',83,237,5);
INSERT INTO its1_source VALUES(2393,'MG550130.1',83,237,5);
INSERT INTO its1_source VALUES(2394,'MG550131.1',83,237,5);
INSERT INTO its1_source VALUES(2395,'MG550132.1',83,237,5);
INSERT INTO its1_source VALUES(2396,'MG550133.1',83,237,5);
INSERT INTO its1_source VALUES(2397,'MG550134.1',83,782,5);
INSERT INTO its1_source VALUES(2398,'MG550135.1',83,237,5);
INSERT INTO its1_source VALUES(2399,'MG550136.1',83,237,5);
INSERT INTO its1_source VALUES(2400,'MG550137.1',83,803,5);
INSERT INTO its1_source VALUES(2401,'MG550138.1',83,811,5);
INSERT INTO its1_source VALUES(2402,'MG550139.1',83,803,5);
INSERT INTO its1_source VALUES(2403,'MG550140.1',83,803,5);
INSERT INTO its1_source VALUES(2404,'MG550141.1',83,237,5);
INSERT INTO its1_source VALUES(2405,'MG550142.1',83,237,5);
INSERT INTO its1_source VALUES(2406,'MG550143.1',83,800,5);
INSERT INTO its1_source VALUES(2407,'MG550145.1',83,804,5);
INSERT INTO its1_source VALUES(2408,'MG551856.1',83,37,5);
INSERT INTO its1_source VALUES(2409,'MG551857.1',83,812,5);
INSERT INTO its1_source VALUES(2410,'MG551881.1',83,37,5);
INSERT INTO its1_source VALUES(2411,'MG551882.1',83,37,5);
INSERT INTO its1_source VALUES(2412,'MG551883.1',83,37,5);
INSERT INTO its1_source VALUES(2413,'MG551884.1',83,37,5);
INSERT INTO its1_source VALUES(2414,'MG552076.1',83,813,5);
INSERT INTO its1_source VALUES(2415,'MG552077.1',83,20,5);
INSERT INTO its1_source VALUES(2416,'MG552078.1',83,814,5);
INSERT INTO its1_source VALUES(2417,'MG552079.1',83,20,5);
INSERT INTO its1_source VALUES(2418,'MG552080.1',83,815,5);
INSERT INTO its1_source VALUES(2419,'MG552081.1',83,816,5);
INSERT INTO its1_source VALUES(2420,'MG552082.1',83,817,5);
INSERT INTO its1_source VALUES(2421,'MG552083.1',83,818,5);
INSERT INTO its1_source VALUES(2422,'MG552085.1',83,819,5);
INSERT INTO its1_source VALUES(2423,'MG552086.1',83,20,5);
INSERT INTO its1_source VALUES(2424,'MG552087.1',83,34,5);
INSERT INTO its1_source VALUES(2425,'MG552088.1',83,820,5);
INSERT INTO its1_source VALUES(2426,'MG552089.1',83,821,5);
INSERT INTO its1_source VALUES(2427,'MG553201.1',83,822,5);
INSERT INTO its1_source VALUES(2428,'MG553203.1',83,823,5);
INSERT INTO its1_source VALUES(2429,'MG553204.1',83,824,5);
INSERT INTO its1_source VALUES(2430,'MG553205.1',83,23,5);
INSERT INTO its1_source VALUES(2431,'MG553207.1',83,20,5);
INSERT INTO its1_source VALUES(2432,'MG553208.1',83,825,5);
INSERT INTO its1_source VALUES(2433,'MG554683.1',83,627,5);
INSERT INTO its1_source VALUES(2434,'MG554684.1',83,826,5);
INSERT INTO its1_source VALUES(2435,'MG554685.1',83,827,5);
INSERT INTO its1_source VALUES(2436,'MG554691.1',83,53,5);
INSERT INTO its1_source VALUES(2437,'MG554738.1',83,54,5);
INSERT INTO its1_source VALUES(2438,'MG554739.1',83,828,5);
INSERT INTO its1_source VALUES(2439,'MG554741.1',83,54,5);
INSERT INTO its1_source VALUES(2440,'MG557699.1',83,117,5);
INSERT INTO its1_source VALUES(2441,'MG557701.1',83,117,5);
INSERT INTO its1_source VALUES(2442,'MG557901.1',83,235,5);
INSERT INTO its1_source VALUES(2443,'MG557902.1',83,235,5);
INSERT INTO its1_source VALUES(2444,'MG561726.1',83,109,5);
INSERT INTO its1_source VALUES(2445,'MG561727.1',83,235,5);
INSERT INTO its1_source VALUES(2446,'MG561728.1',83,235,5);
INSERT INTO its1_source VALUES(2447,'MG561729.1',83,235,5);
INSERT INTO its1_source VALUES(2448,'MG561730.1',83,235,5);
INSERT INTO its1_source VALUES(2449,'MG561731.1',83,235,5);
INSERT INTO its1_source VALUES(2450,'MG561732.1',83,235,5);
INSERT INTO its1_source VALUES(2451,'MG561733.1',83,235,5);
INSERT INTO its1_source VALUES(2452,'MG561734.1',83,235,5);
INSERT INTO its1_source VALUES(2453,'MG561735.1',83,235,5);
INSERT INTO its1_source VALUES(2454,'MG561736.1',83,235,5);
INSERT INTO its1_source VALUES(2455,'MG561737.1',83,235,5);
INSERT INTO its1_source VALUES(2456,'MG561738.1',83,235,5);
INSERT INTO its1_source VALUES(2457,'MG561739.1',83,235,5);
INSERT INTO its1_source VALUES(2458,'MG561740.1',83,235,5);
INSERT INTO its1_source VALUES(2459,'MG561741.1',83,235,5);
INSERT INTO its1_source VALUES(2460,'MG561742.1',83,235,5);
INSERT INTO its1_source VALUES(2461,'MG561743.1',83,235,5);
INSERT INTO its1_source VALUES(2462,'MG561744.1',83,235,5);
INSERT INTO its1_source VALUES(2463,'MG561745.1',83,235,5);
INSERT INTO its1_source VALUES(2464,'MG561747.1',83,109,5);
INSERT INTO its1_source VALUES(2465,'MG561748.1',83,235,5);
INSERT INTO its1_source VALUES(2466,'MG561749.1',83,208,5);
INSERT INTO its1_source VALUES(2467,'MG561750.1',83,235,5);
INSERT INTO its1_source VALUES(2468,'MG561944.1',83,829,5);
INSERT INTO its1_source VALUES(2469,'MG561945.1',83,829,5);
INSERT INTO its1_source VALUES(2470,'MG561946.1',83,829,5);
INSERT INTO its1_source VALUES(2471,'MG561947.1',83,829,5);
INSERT INTO its1_source VALUES(2472,'MG587712.1',83,830,5);
INSERT INTO its1_source VALUES(2473,'MG587713.1',83,194,5);
INSERT INTO its1_source VALUES(2474,'MG587714.1',83,194,5);
INSERT INTO its1_source VALUES(2475,'MG587715.1',83,419,5);
INSERT INTO its1_source VALUES(2476,'MG587716.1',83,419,5);
INSERT INTO its1_source VALUES(2477,'MG587717.1',83,419,5);
INSERT INTO its1_source VALUES(2478,'MG587718.1',83,194,5);
INSERT INTO its1_source VALUES(2479,'MG587719.1',83,831,5);
INSERT INTO its1_source VALUES(2480,'MG587720.1',83,831,5);
INSERT INTO its1_source VALUES(2481,'MG587721.1',83,194,5);
INSERT INTO its1_source VALUES(2482,'MG587722.1',83,419,5);
INSERT INTO its1_source VALUES(2483,'MG587723.1',83,194,5);
INSERT INTO its1_source VALUES(2484,'MG587724.1',83,194,5);
INSERT INTO its1_source VALUES(2485,'MG587725.1',83,419,5);
INSERT INTO its1_source VALUES(2486,'MG587726.1',83,831,5);
INSERT INTO its1_source VALUES(2487,'MG589424.1',83,832,5);
INSERT INTO its1_source VALUES(2488,'MG589425.1',83,833,5);
INSERT INTO its1_source VALUES(2489,'MG589426.1',83,93,5);
INSERT INTO its1_source VALUES(2490,'MG589427.1',83,419,5);
INSERT INTO its1_source VALUES(2491,'MG589428.1',83,419,5);
INSERT INTO its1_source VALUES(2492,'MG589429.1',83,194,5);
INSERT INTO its1_source VALUES(2493,'MG589430.1',83,830,5);
INSERT INTO its1_source VALUES(2494,'MG589431.1',83,830,5);
INSERT INTO its1_source VALUES(2495,'MG589432.1',83,194,5);
INSERT INTO its1_source VALUES(2496,'MG589433.1',83,93,5);
INSERT INTO its1_source VALUES(2497,'MG589434.1',83,93,5);
INSERT INTO its1_source VALUES(2498,'MG589435.1',83,832,5);
INSERT INTO its1_source VALUES(2499,'MG589436.1',83,830,5);
INSERT INTO its1_source VALUES(2500,'MG589437.1',83,93,5);
INSERT INTO its1_source VALUES(2501,'MG589438.1',83,419,5);
INSERT INTO its1_source VALUES(2502,'MG589439.1',83,194,5);
INSERT INTO its1_source VALUES(2503,'MG589440.1',83,830,5);
INSERT INTO its1_source VALUES(2504,'MG589441.1',83,419,5);
INSERT INTO its1_source VALUES(2505,'MG589442.1',83,194,5);
INSERT INTO its1_source VALUES(2506,'MG589443.1',83,194,5);
INSERT INTO its1_source VALUES(2507,'MG589444.1',83,419,5);
INSERT INTO its1_source VALUES(2508,'MG589445.1',83,194,5);
INSERT INTO its1_source VALUES(2509,'MG589446.1',83,419,5);
INSERT INTO its1_source VALUES(2510,'MG589447.1',83,194,5);
INSERT INTO its1_source VALUES(2511,'MG589448.1',83,419,5);
INSERT INTO its1_source VALUES(2512,'MG589449.1',83,419,5);
INSERT INTO its1_source VALUES(2513,'MG589450.1',83,831,5);
INSERT INTO its1_source VALUES(2514,'MG589451.1',83,830,5);
INSERT INTO its1_source VALUES(2515,'MG594643.1',83,46,5);
INSERT INTO its1_source VALUES(2516,'MG594644.1',83,240,5);
INSERT INTO its1_source VALUES(2517,'MG594645.1',83,46,5);
INSERT INTO its1_source VALUES(2518,'MG594646.1',83,46,5);
INSERT INTO its1_source VALUES(2519,'MG594856.1',83,286,5);
INSERT INTO its1_source VALUES(2520,'MG595272.1',83,286,5);
INSERT INTO its1_source VALUES(2521,'MG595666.1',83,585,5);
INSERT INTO its1_source VALUES(2522,'MG595667.1',83,585,5);
INSERT INTO its1_source VALUES(2523,'MG670447.1',83,29,5);
INSERT INTO its1_source VALUES(2524,'MG674700.1',83,46,5);
INSERT INTO its1_source VALUES(2525,'MG685779.1',83,46,5);
INSERT INTO its1_source VALUES(2526,'MG685781.1',83,46,5);
INSERT INTO its1_source VALUES(2527,'MG685782.1',83,46,5);
INSERT INTO its1_source VALUES(2528,'MG685783.1',83,46,5);
INSERT INTO its1_source VALUES(2529,'MG685784.1',83,46,5);
INSERT INTO its1_source VALUES(2530,'MG685785.1',83,46,5);
INSERT INTO its1_source VALUES(2531,'MG685786.1',83,46,5);
INSERT INTO its1_source VALUES(2532,'MG685787.1',83,46,5);
INSERT INTO its1_source VALUES(2533,'MG685788.1',83,46,5);
INSERT INTO its1_source VALUES(2534,'MG696314.1',83,834,5);
INSERT INTO its1_source VALUES(2535,'MG696326.1',83,403,5);
INSERT INTO its1_source VALUES(2536,'MG696327.1',83,400,5);
INSERT INTO its1_source VALUES(2537,'MG696330.1',83,26,5);
INSERT INTO its1_source VALUES(2538,'MG696335.1',83,835,5);
INSERT INTO its1_source VALUES(2539,'MG696415.1',83,46,5);
INSERT INTO its1_source VALUES(2540,'MG696441.1',83,46,5);
INSERT INTO its1_source VALUES(2541,'MG696442.1',83,66,5);
INSERT INTO its1_source VALUES(2542,'MG696443.1',83,46,5);
INSERT INTO its1_source VALUES(2543,'MG696444.1',83,836,5);
INSERT INTO its1_source VALUES(2544,'MG696445.1',83,66,5);
INSERT INTO its1_source VALUES(2545,'MG696446.1',83,66,5);
INSERT INTO its1_source VALUES(2546,'MG696447.1',83,400,5);
INSERT INTO its1_source VALUES(2547,'MG696448.1',83,403,5);
INSERT INTO its1_source VALUES(2548,'MG696449.1',83,26,5);
INSERT INTO its1_source VALUES(2549,'MG696450.1',83,26,5);
INSERT INTO its1_source VALUES(2550,'MG696451.1',83,46,5);
INSERT INTO its1_source VALUES(2551,'MG696452.1',83,403,5);
INSERT INTO its1_source VALUES(2552,'MG696453.1',83,400,5);
INSERT INTO its1_source VALUES(2553,'MG696454.1',83,837,5);
INSERT INTO its1_source VALUES(2554,'MG696455.1',83,400,5);
INSERT INTO its1_source VALUES(2555,'MG696456.1',83,66,5);
INSERT INTO its1_source VALUES(2556,'MG696457.1',83,46,5);
INSERT INTO its1_source VALUES(2557,'MG696458.1',83,303,5);
INSERT INTO its1_source VALUES(2558,'MG696459.1',83,403,5);
INSERT INTO its1_source VALUES(2559,'MG696461.1',83,303,5);
INSERT INTO its1_source VALUES(2560,'MG696462.1',83,838,5);
INSERT INTO its1_source VALUES(2561,'MG696463.1',83,66,5);
INSERT INTO its1_source VALUES(2562,'MG696464.1',83,839,5);
INSERT INTO its1_source VALUES(2563,'MG696466.1',83,46,5);
INSERT INTO its1_source VALUES(2564,'MG696467.1',83,840,5);
INSERT INTO its1_source VALUES(2565,'MG696468.1',83,303,5);
INSERT INTO its1_source VALUES(2566,'MG696471.1',83,303,5);
INSERT INTO its1_source VALUES(2567,'MG696472.1',83,20,5);
INSERT INTO its1_source VALUES(2568,'MG696473.1',83,303,5);
INSERT INTO its1_source VALUES(2569,'MG696477.1',83,20,5);
INSERT INTO its1_source VALUES(2570,'MG696478.1',83,839,5);
INSERT INTO its1_source VALUES(2571,'MG696479.1',83,400,5);
INSERT INTO its1_source VALUES(2572,'MG696480.1',83,400,5);
INSERT INTO its1_source VALUES(2573,'MG696481.1',83,400,5);
INSERT INTO its1_source VALUES(2574,'MG696483.1',83,403,5);
INSERT INTO its1_source VALUES(2575,'MG696484.1',83,403,5);
INSERT INTO its1_source VALUES(2576,'MG696485.1',83,400,5);
INSERT INTO its1_source VALUES(2577,'MG696488.1',83,405,5);
INSERT INTO its1_source VALUES(2578,'MG696490.1',83,403,5);
INSERT INTO its1_source VALUES(2579,'MG696493.1',83,303,5);
INSERT INTO its1_source VALUES(2580,'MG696494.1',83,303,5);
INSERT INTO its1_source VALUES(2581,'MG696497.1',83,403,5);
INSERT INTO its1_source VALUES(2582,'MG696498.1',83,303,5);
INSERT INTO its1_source VALUES(2583,'MG696499.1',83,250,5);
INSERT INTO its1_source VALUES(2584,'MG696500.1',83,250,5);
INSERT INTO its1_source VALUES(2585,'MG696505.1',83,403,5);
INSERT INTO its1_source VALUES(2586,'MG696506.1',83,237,5);
INSERT INTO its1_source VALUES(2587,'MG696507.1',83,303,5);
INSERT INTO its1_source VALUES(2588,'MG696508.1',83,403,5);
INSERT INTO its1_source VALUES(2589,'MG696511.1',83,405,5);
INSERT INTO its1_source VALUES(2590,'MG696512.1',83,66,5);
INSERT INTO its1_source VALUES(2591,'MG696514.1',83,20,5);
INSERT INTO its1_source VALUES(2592,'MG696515.1',83,20,5);
INSERT INTO its1_source VALUES(2593,'MG696516.1',83,46,5);
INSERT INTO its1_source VALUES(2594,'MG696517.1',83,46,5);
INSERT INTO its1_source VALUES(2595,'MG696519.1',83,117,5);
INSERT INTO its1_source VALUES(2596,'MG696521.1',83,405,5);
INSERT INTO its1_source VALUES(2597,'MG696522.1',83,405,5);
INSERT INTO its1_source VALUES(2598,'MG696525.1',83,26,5);
INSERT INTO its1_source VALUES(2599,'MG696526.1',83,824,5);
INSERT INTO its1_source VALUES(2600,'MG696527.1',83,20,5);
INSERT INTO its1_source VALUES(2601,'MG696529.1',83,66,5);
INSERT INTO its1_source VALUES(2602,'MG696530.1',83,406,5);
INSERT INTO its1_source VALUES(2603,'MG696533.1',83,841,5);
INSERT INTO its1_source VALUES(2604,'MG696534.1',83,234,5);
INSERT INTO its1_source VALUES(2605,'MG696535.1',83,20,5);
INSERT INTO its1_source VALUES(2606,'MG696536.1',83,842,5);
INSERT INTO its1_source VALUES(2607,'MG696537.1',83,400,5);
INSERT INTO its1_source VALUES(2608,'MG696541.1',83,400,5);
INSERT INTO its1_source VALUES(2609,'MG696543.1',83,237,5);
INSERT INTO its1_source VALUES(2610,'MG696544.1',83,400,5);
INSERT INTO its1_source VALUES(2611,'MG696547.1',83,403,5);
INSERT INTO its1_source VALUES(2612,'MG696550.1',83,403,5);
INSERT INTO its1_source VALUES(2613,'MG707787.1',83,46,5);
INSERT INTO its1_source VALUES(2614,'MG707788.1',83,46,5);
INSERT INTO its1_source VALUES(2615,'MG707790.1',83,240,5);
INSERT INTO its1_source VALUES(2616,'MG707791.1',83,245,5);
INSERT INTO its1_source VALUES(2617,'MG707804.1',83,843,5);
INSERT INTO its1_source VALUES(2618,'MG757758.1',83,844,35);
INSERT INTO its1_source VALUES(2619,'MG757759.1',83,844,35);
INSERT INTO its1_source VALUES(2620,'MG757760.1',83,845,35);
INSERT INTO its1_source VALUES(2621,'MG757761.1',83,846,35);
INSERT INTO its1_source VALUES(2622,'MG757762.1',83,460,35);
INSERT INTO its1_source VALUES(2623,'MG757765.1',83,846,35);
INSERT INTO its1_source VALUES(2624,'MG757766.1',83,460,35);
INSERT INTO its1_source VALUES(2625,'MG757767.1',83,846,35);
INSERT INTO its1_source VALUES(2626,'MG757768.1',83,846,35);
INSERT INTO its1_source VALUES(2627,'MG757769.1',83,460,35);
INSERT INTO its1_source VALUES(2628,'MG757770.1',83,846,35);
INSERT INTO its1_source VALUES(2629,'MG757772.1',83,847,35);
INSERT INTO its1_source VALUES(2630,'MG757773.1',83,848,35);
INSERT INTO its1_source VALUES(2631,'MG757774.1',83,846,35);
INSERT INTO its1_source VALUES(2632,'MG757775.1',83,846,35);
INSERT INTO its1_source VALUES(2633,'MG757776.1',83,844,35);
INSERT INTO its1_source VALUES(2634,'MG757777.1',83,846,35);
INSERT INTO its1_source VALUES(2635,'MG757778.1',83,849,35);
INSERT INTO its1_source VALUES(2636,'MG757779.1',83,846,35);
INSERT INTO its1_source VALUES(2637,'MG757780.1',83,844,35);
INSERT INTO its1_source VALUES(2638,'MG757781.1',83,846,35);
INSERT INTO its1_source VALUES(2639,'MG757782.1',83,459,35);
INSERT INTO its1_source VALUES(2640,'MG757783.1',83,459,35);
INSERT INTO its1_source VALUES(2641,'MG757784.1',83,459,35);
INSERT INTO its1_source VALUES(2642,'MG757785.1',83,460,35);
INSERT INTO its1_source VALUES(2643,'MG757786.1',83,460,35);
INSERT INTO its1_source VALUES(2644,'MG757787.1',83,460,35);
INSERT INTO its1_source VALUES(2645,'MG757788.1',83,460,35);
INSERT INTO its1_source VALUES(2646,'MG757789.1',83,850,35);
INSERT INTO its1_source VALUES(2647,'MG757790.1',83,846,35);
INSERT INTO its1_source VALUES(2648,'MG757791.1',83,851,35);
INSERT INTO its1_source VALUES(2649,'MG757792.1',83,852,35);
INSERT INTO its1_source VALUES(2650,'MG761692.1',83,590,5);
INSERT INTO its1_source VALUES(2651,'MG765402.1',83,853,5);
INSERT INTO its1_source VALUES(2652,'MG765403.1',83,853,5);
INSERT INTO its1_source VALUES(2653,'MG765404.1',83,853,5);
INSERT INTO its1_source VALUES(2654,'MG765405.1',83,853,5);
INSERT INTO its1_source VALUES(2655,'MG782843.1',83,854,9);
INSERT INTO its1_source VALUES(2656,'MG823261.1',83,322,5);
INSERT INTO its1_source VALUES(2657,'MG823262.1',83,309,5);
INSERT INTO its1_source VALUES(2658,'MG823263.1',83,322,5);
INSERT INTO its1_source VALUES(2659,'MG823269.1',83,11,5);
INSERT INTO its1_source VALUES(2660,'MG823270.1',83,321,5);
INSERT INTO its1_source VALUES(2661,'MG823271.1',83,317,5);
INSERT INTO its1_source VALUES(2662,'MG823336.1',83,855,5);
INSERT INTO its1_source VALUES(2663,'MG823337.1',83,856,5);
INSERT INTO its1_source VALUES(2664,'MG823355.1',83,857,5);
INSERT INTO its1_source VALUES(2665,'MG910455.1',83,858,62);
INSERT INTO its1_source VALUES(2666,'MG938494.1',83,859,6);
INSERT INTO its1_source VALUES(2667,'MG956799.1',83,60,5);
INSERT INTO its1_source VALUES(2668,'MH036001.1',83,860,62);
INSERT INTO its1_source VALUES(2669,'MH037150.1',83,235,5);
INSERT INTO its1_source VALUES(2670,'MH043608.1',83,861,62);
INSERT INTO its1_source VALUES(2671,'MH059526.1',83,748,9);
INSERT INTO its1_source VALUES(2672,'MH141414.1',83,862,5);
INSERT INTO its1_source VALUES(2673,'MH141415.1',83,843,5);
INSERT INTO its1_source VALUES(2674,'MH171627.1',83,46,5);
INSERT INTO its1_source VALUES(2675,'MH171628.1',83,46,5);
INSERT INTO its1_source VALUES(2676,'MH171629.1',83,46,5);
INSERT INTO its1_source VALUES(2677,'MH171630.1',83,46,5);
INSERT INTO its1_source VALUES(2678,'MH171631.1',83,46,5);
INSERT INTO its1_source VALUES(2679,'MH171632.1',83,46,5);
INSERT INTO its1_source VALUES(2680,'MH171633.1',83,240,5);
INSERT INTO its1_source VALUES(2681,'MH171634.1',83,863,5);
INSERT INTO its1_source VALUES(2682,'MH171635.1',83,117,5);
INSERT INTO its1_source VALUES(2683,'MH171636.1',83,117,5);
INSERT INTO its1_source VALUES(2684,'MH171637.1',83,117,5);
INSERT INTO its1_source VALUES(2685,'MH171638.1',83,843,5);
INSERT INTO its1_source VALUES(2686,'MH171639.1',83,117,5);
INSERT INTO its1_source VALUES(2687,'MH171640.1',83,245,5);
INSERT INTO its1_source VALUES(2688,'MH171641.1',83,53,5);
INSERT INTO its1_source VALUES(2689,'MH171642.1',83,864,5);
INSERT INTO its1_source VALUES(2690,'MH171643.1',83,829,5);
INSERT INTO its1_source VALUES(2691,'MH171644.1',83,865,5);
INSERT INTO its1_source VALUES(2692,'MH171645.1',83,866,5);
INSERT INTO its1_source VALUES(2693,'MH171646.1',83,866,5);
INSERT INTO its1_source VALUES(2694,'MH171647.1',83,194,5);
INSERT INTO its1_source VALUES(2695,'MH171648.1',83,867,5);
INSERT INTO its1_source VALUES(2696,'MH171649.1',83,194,5);
INSERT INTO its1_source VALUES(2697,'MH171650.1',83,286,5);
INSERT INTO its1_source VALUES(2698,'MH171651.1',83,868,5);
INSERT INTO its1_source VALUES(2699,'MH178328.1',83,869,5);
INSERT INTO its1_source VALUES(2700,'MH178329.1',83,870,5);
INSERT INTO its1_source VALUES(2701,'MH178331.1',83,41,5);
INSERT INTO its1_source VALUES(2702,'MH178332.1',83,12,5);
INSERT INTO its1_source VALUES(2703,'MH178333.1',83,616,5);
INSERT INTO its1_source VALUES(2704,'MH178334.1',83,33,5);
INSERT INTO its1_source VALUES(2705,'MH178335.1',83,51,5);
INSERT INTO its1_source VALUES(2706,'MH178336.1',83,25,5);
INSERT INTO its1_source VALUES(2707,'MH178341.1',83,402,5);
INSERT INTO its1_source VALUES(2708,'MH178342.1',83,78,5);
INSERT INTO its1_source VALUES(2709,'MH178344.1',83,871,5);
INSERT INTO its1_source VALUES(2710,'MH178345.1',83,495,5);
INSERT INTO its1_source VALUES(2711,'MH178350.1',83,11,5);
INSERT INTO its1_source VALUES(2712,'MH196529.1',83,29,5);
INSERT INTO its1_source VALUES(2713,'MH196530.1',83,872,5);
INSERT INTO its1_source VALUES(2714,'MH219822.1',83,64,5);
INSERT INTO its1_source VALUES(2715,'MH219826.1',83,60,5);
INSERT INTO its1_source VALUES(2716,'MH219829.1',83,60,5);
INSERT INTO its1_source VALUES(2717,'MH219833.1',83,324,5);
INSERT INTO its1_source VALUES(2718,'MH219839.1',83,873,5);
INSERT INTO its1_source VALUES(2719,'MH219844.1',83,60,5);
INSERT INTO its1_source VALUES(2720,'MH219849.1',83,60,5);
INSERT INTO its1_source VALUES(2721,'MH219859.1',83,773,5);
INSERT INTO its1_source VALUES(2722,'MH219866.1',83,60,5);
INSERT INTO its1_source VALUES(2723,'MH219882.1',83,64,5);
INSERT INTO its1_source VALUES(2724,'MH219886.1',83,25,5);
INSERT INTO its1_source VALUES(2725,'MH219887.1',83,874,5);
INSERT INTO its1_source VALUES(2726,'MH219902.1',83,64,5);
INSERT INTO its1_source VALUES(2727,'MH219904.1',83,60,5);
INSERT INTO its1_source VALUES(2728,'MH219918.1',83,13,5);
INSERT INTO its1_source VALUES(2729,'MH236137.1',83,875,5);
INSERT INTO its1_source VALUES(2730,'MH236139.1',83,876,5);
INSERT INTO its1_source VALUES(2731,'MH236141.1',83,877,5);
INSERT INTO its1_source VALUES(2732,'MH236241.1',83,470,55);
INSERT INTO its1_source VALUES(2733,'MH236250.1',83,95,5);
INSERT INTO its1_source VALUES(2734,'MH243441.1',83,878,6);
INSERT INTO its1_source VALUES(2735,'MH321577.1',83,879,5);
INSERT INTO its1_source VALUES(2736,'MH341612.1',83,880,5);
INSERT INTO its1_source VALUES(2737,'MH341616.1',83,25,5);
INSERT INTO its1_source VALUES(2738,'MH341621.1',83,25,5);
INSERT INTO its1_source VALUES(2739,'MH352420.1',83,324,5);
INSERT INTO its1_source VALUES(2740,'MH393373.1',83,881,62);
INSERT INTO its1_source VALUES(2741,'MH393378.1',83,882,62);
INSERT INTO its1_source VALUES(2742,'MH397235.1',83,883,5);
INSERT INTO its1_source VALUES(2743,'MH397236.1',83,884,5);
INSERT INTO its1_source VALUES(2744,'MH401198.1',83,885,5);
INSERT INTO its1_source VALUES(2745,'MH401199.1',83,399,5);
INSERT INTO its1_source VALUES(2746,'MH401200.1',83,886,5);
INSERT INTO its1_source VALUES(2747,'MH401201.1',83,887,5);
INSERT INTO its1_source VALUES(2748,'MH401202.1',83,888,5);
INSERT INTO its1_source VALUES(2749,'MH401203.1',83,889,5);
INSERT INTO its1_source VALUES(2750,'MH401204.1',83,888,5);
INSERT INTO its1_source VALUES(2751,'MH401205.1',83,832,5);
INSERT INTO its1_source VALUES(2752,'MH401206.1',83,309,5);
INSERT INTO its1_source VALUES(2753,'MH401207.1',83,309,5);
INSERT INTO its1_source VALUES(2754,'MH401208.1',83,190,5);
INSERT INTO its1_source VALUES(2755,'MH401209.1',83,890,5);
INSERT INTO its1_source VALUES(2756,'MH401210.1',83,891,5);
INSERT INTO its1_source VALUES(2757,'MH401211.1',83,892,5);
INSERT INTO its1_source VALUES(2758,'MH443074.1',83,864,5);
INSERT INTO its1_source VALUES(2759,'MH443075.1',83,864,5);
INSERT INTO its1_source VALUES(2760,'MH443076.1',83,53,5);
INSERT INTO its1_source VALUES(2761,'MH443077.1',83,53,5);
INSERT INTO its1_source VALUES(2762,'MH443078.1',83,53,5);
INSERT INTO its1_source VALUES(2763,'MH443079.1',83,53,5);
INSERT INTO its1_source VALUES(2764,'MH443080.1',83,53,5);
INSERT INTO its1_source VALUES(2765,'MH443081.1',83,53,5);
INSERT INTO its1_source VALUES(2766,'MH443083.1',83,893,5);
INSERT INTO its1_source VALUES(2767,'MH443084.1',83,864,5);
INSERT INTO its1_source VALUES(2768,'MH443085.1',83,864,5);
INSERT INTO its1_source VALUES(2769,'MH443087.1',83,53,5);
INSERT INTO its1_source VALUES(2770,'MH443088.1',83,53,5);
INSERT INTO its1_source VALUES(2771,'MH588088.1',83,894,5);
INSERT INTO its1_source VALUES(2772,'MH593844.1',83,894,5);
INSERT INTO its1_source VALUES(2773,'MH620351.1',83,895,9);
INSERT INTO its1_source VALUES(2774,'MH665654.1',83,678,3);
INSERT INTO its1_source VALUES(2775,'MH671329.1',83,896,55);
INSERT INTO its1_source VALUES(2776,'MH730799.1',83,897,9);
INSERT INTO its1_source VALUES(2777,'MH730800.1',83,898,9);
INSERT INTO its1_source VALUES(2778,'MH730801.1',83,192,9);
INSERT INTO its1_source VALUES(2779,'MH730802.1',83,899,9);
INSERT INTO its1_source VALUES(2780,'MH730803.1',83,900,9);
INSERT INTO its1_source VALUES(2781,'MH730804.1',83,629,9);
INSERT INTO its1_source VALUES(2782,'MH730805.1',83,901,9);
INSERT INTO its1_source VALUES(2783,'MH730806.1',83,902,9);
INSERT INTO its1_source VALUES(2784,'MH730807.1',83,129,30);
INSERT INTO its1_source VALUES(2785,'MH730808.1',83,903,9);
INSERT INTO its1_source VALUES(2786,'MH730809.1',83,746,9);
INSERT INTO its1_source VALUES(2787,'MH730810.1',83,338,9);
INSERT INTO its1_source VALUES(2788,'MH730811.1',83,338,9);
INSERT INTO its1_source VALUES(2789,'MH730817.1',83,904,9);
INSERT INTO its1_source VALUES(2790,'MH730818.1',83,905,9);
INSERT INTO its1_source VALUES(2791,'MH782048.1',83,906,6);
INSERT INTO its1_source VALUES(2792,'MH806381.1',83,100,9);
INSERT INTO its1_source VALUES(2793,'MH807778.1',83,60,5);
INSERT INTO its1_source VALUES(2794,'MH842154.1',83,29,5);
INSERT INTO its1_source VALUES(2795,'MH842155.1',83,29,5);
INSERT INTO its1_source VALUES(2796,'MH842156.1',83,29,5);
INSERT INTO its1_source VALUES(2797,'MH842157.1',83,29,5);
INSERT INTO its1_source VALUES(2798,'MH842158.1',83,29,5);
INSERT INTO its1_source VALUES(2799,'MH842159.1',83,764,5);
INSERT INTO its1_source VALUES(2800,'MH842160.1',83,29,5);
INSERT INTO its1_source VALUES(2801,'MH842161.1',83,29,5);
INSERT INTO its1_source VALUES(2802,'MH842162.1',83,29,5);
INSERT INTO its1_source VALUES(2803,'MH842163.1',83,907,5);
INSERT INTO its1_source VALUES(2804,'MH865074.1',83,117,5);
INSERT INTO its1_source VALUES(2805,'MH923447.1',83,470,55);
INSERT INTO its1_source VALUES(2806,'MH999837.1',83,100,9);
INSERT INTO its1_source VALUES(2807,'MK011110.1',83,485,55);
INSERT INTO its1_source VALUES(2808,'MK011111.1',83,485,55);
INSERT INTO its1_source VALUES(2809,'MK011112.1',83,485,55);
INSERT INTO its1_source VALUES(2810,'MK011113.1',83,485,55);
INSERT INTO its1_source VALUES(2811,'MK011114.1',83,485,55);
INSERT INTO its1_source VALUES(2812,'MK011115.1',83,485,55);
INSERT INTO its1_source VALUES(2813,'MK011116.1',83,485,55);
INSERT INTO its1_source VALUES(2814,'MK011117.1',83,485,55);
INSERT INTO its1_source VALUES(2815,'MK011118.1',83,485,55);
INSERT INTO its1_source VALUES(2816,'MK011119.1',83,485,55);
INSERT INTO its1_source VALUES(2817,'MK011120.1',83,485,55);
INSERT INTO its1_source VALUES(2818,'MK011121.1',83,485,55);
INSERT INTO its1_source VALUES(2819,'MK015670.1',83,908,6);
INSERT INTO its1_source VALUES(2820,'MK015672.1',83,909,6);
INSERT INTO its1_source VALUES(2821,'MK015673.1',83,910,62);
INSERT INTO its1_source VALUES(2822,'MK015675.1',83,911,55);
INSERT INTO its1_source VALUES(2823,'MK015677.1',83,912,55);
INSERT INTO its1_source VALUES(2824,'MK015679.1',83,913,6);
INSERT INTO its1_source VALUES(2825,'MK067077.1',83,790,4);
INSERT INTO its1_source VALUES(2826,'MK163944.1',83,914,5);
INSERT INTO its1_source VALUES(2827,'MK216324.1',83,915,6);
INSERT INTO its1_source VALUES(2828,'MK299414.1',83,379,5);
INSERT INTO its1_source VALUES(2829,'MK326541.1',83,699,62);
INSERT INTO its1_source VALUES(2830,'MK326550.1',83,916,62);
INSERT INTO its1_source VALUES(2831,'MK500842.1',83,60,5);
INSERT INTO its1_source VALUES(2832,'MK524730.1',83,5,3);
INSERT INTO its1_source VALUES(2833,'MK524731.1',83,917,3);
INSERT INTO its1_source VALUES(2834,'MK524732.1',83,918,3);
INSERT INTO its1_source VALUES(2835,'MK524733.1',83,671,3);
INSERT INTO its1_source VALUES(2836,'MK524734.1',83,5,3);
INSERT INTO its1_source VALUES(2837,'MK524735.1',83,919,39);
INSERT INTO its1_source VALUES(2838,'MK524736.1',83,920,3);
INSERT INTO its1_source VALUES(2839,'MK524737.1',83,252,39);
INSERT INTO its1_source VALUES(2840,'MK524738.1',83,921,3);
INSERT INTO its1_source VALUES(2841,'MK524739.1',83,922,3);
INSERT INTO its1_source VALUES(2842,'MK524740.1',83,923,3);
INSERT INTO its1_source VALUES(2843,'MK524741.1',83,5,3);
INSERT INTO its1_source VALUES(2844,'MK524742.1',83,924,3);
INSERT INTO its1_source VALUES(2845,'MK524743.1',83,925,3);
INSERT INTO its1_source VALUES(2846,'MK524744.1',83,926,3);
INSERT INTO its1_source VALUES(2847,'MK524745.1',83,927,3);
INSERT INTO its1_source VALUES(2848,'MK524746.1',83,264,3);
INSERT INTO its1_source VALUES(2849,'MK524747.1',83,264,3);
INSERT INTO its1_source VALUES(2850,'MK524748.1',83,928,3);
INSERT INTO its1_source VALUES(2851,'MK524749.1',83,663,3);
INSERT INTO its1_source VALUES(2852,'MK524750.1',83,667,3);
INSERT INTO its1_source VALUES(2853,'MK524751.1',83,667,3);
INSERT INTO its1_source VALUES(2854,'MK524752.1',83,929,3);
INSERT INTO its1_source VALUES(2855,'MK524753.1',83,930,3);
INSERT INTO its1_source VALUES(2856,'MK524754.1',83,931,3);
INSERT INTO its1_source VALUES(2857,'MK524755.1',83,264,3);
INSERT INTO its1_source VALUES(2858,'MK524756.1',83,921,3);
INSERT INTO its1_source VALUES(2859,'MK524757.1',83,932,3);
INSERT INTO its1_source VALUES(2860,'MK524758.1',83,933,3);
INSERT INTO its1_source VALUES(2861,'MK524759.1',83,5,3);
INSERT INTO its1_source VALUES(2862,'MK524760.1',83,921,3);
INSERT INTO its1_source VALUES(2863,'MK524761.1',83,934,3);
INSERT INTO its1_source VALUES(2864,'MK524762.1',83,921,3);
INSERT INTO its1_source VALUES(2865,'MK524763.1',83,935,3);
INSERT INTO its1_source VALUES(2866,'MK524764.1',83,5,3);
INSERT INTO its1_source VALUES(2867,'MK524765.1',83,5,3);
INSERT INTO its1_source VALUES(2868,'MK524766.1',83,936,3);
INSERT INTO its1_source VALUES(2869,'MK524767.1',83,5,3);
INSERT INTO its1_source VALUES(2870,'MK524768.1',83,937,3);
INSERT INTO its1_source VALUES(2871,'MK524769.1',83,5,3);
INSERT INTO its1_source VALUES(2872,'MK524770.1',83,5,3);
INSERT INTO its1_source VALUES(2873,'MK524771.1',83,5,3);
INSERT INTO its1_source VALUES(2874,'MK524772.1',83,5,3);
INSERT INTO its1_source VALUES(2875,'MK524773.1',83,5,3);
INSERT INTO its1_source VALUES(2876,'MK524774.1',83,938,3);
INSERT INTO its1_source VALUES(2877,'MK524775.1',83,5,3);
INSERT INTO its1_source VALUES(2878,'MK524776.1',83,5,3);
INSERT INTO its1_source VALUES(2879,'MK524777.1',83,5,3);
INSERT INTO its1_source VALUES(2880,'MK524778.1',83,939,3);
INSERT INTO its1_source VALUES(2881,'MK524779.1',83,940,3);
INSERT INTO its1_source VALUES(2882,'MK524780.1',83,941,3);
INSERT INTO its1_source VALUES(2883,'MK524781.1',83,5,3);
INSERT INTO its1_source VALUES(2884,'MK524782.1',83,5,3);
INSERT INTO its1_source VALUES(2885,'MK524783.1',83,5,3);
INSERT INTO its1_source VALUES(2886,'MK524784.1',83,5,3);
INSERT INTO its1_source VALUES(2887,'MK524785.1',83,5,3);
INSERT INTO its1_source VALUES(2888,'MK524786.1',83,5,3);
INSERT INTO its1_source VALUES(2889,'MK524787.1',83,5,3);
INSERT INTO its1_source VALUES(2890,'MK524788.1',83,942,3);
INSERT INTO its1_source VALUES(2891,'MK524789.1',83,943,3);
INSERT INTO its1_source VALUES(2892,'MK524790.1',83,5,3);
INSERT INTO its1_source VALUES(2893,'MK524791.1',83,5,3);
INSERT INTO its1_source VALUES(2894,'MK524792.1',83,5,3);
INSERT INTO its1_source VALUES(2895,'MK524793.1',83,5,3);
INSERT INTO its1_source VALUES(2896,'MK524794.1',83,944,3);
INSERT INTO its1_source VALUES(2897,'MK524795.1',83,945,3);
INSERT INTO its1_source VALUES(2898,'MK583656.1',83,84,62);
INSERT INTO its1_source VALUES(2899,'MK583657.1',83,84,62);
INSERT INTO its1_source VALUES(2900,'MK742802.1',83,13,5);
INSERT INTO its1_source VALUES(2901,'MK742806.1',83,13,5);
INSERT INTO its1_source VALUES(2902,'MK794626.1',83,946,62);
INSERT INTO its1_source VALUES(2903,'MK794627.1',83,84,62);
INSERT INTO its1_source VALUES(2904,'MK794632.1',83,947,62);
INSERT INTO its1_source VALUES(2905,'MK794636.1',83,948,62);
INSERT INTO its1_source VALUES(2906,'MK794638.1',83,949,62);
INSERT INTO its1_source VALUES(2907,'MK794641.1',83,950,62);
INSERT INTO its1_source VALUES(2908,'MK794642.1',83,84,62);
INSERT INTO its1_source VALUES(2909,'MK794645.1',83,951,62);
INSERT INTO its1_source VALUES(2910,'MK794646.1',83,112,62);
INSERT INTO its1_source VALUES(2911,'MK794649.1',83,952,62);
INSERT INTO its1_source VALUES(2912,'MK794650.1',83,953,62);
INSERT INTO its1_source VALUES(2913,'MK794654.1',83,702,62);
INSERT INTO its1_source VALUES(2914,'MK794656.1',83,84,62);
INSERT INTO its1_source VALUES(2915,'MK794662.1',83,84,62);
INSERT INTO its1_source VALUES(2916,'MK794663.1',83,84,62);
INSERT INTO its1_source VALUES(2917,'MK794666.1',83,954,62);
INSERT INTO its1_source VALUES(2918,'MK794668.1',83,702,62);
INSERT INTO its1_source VALUES(2919,'MK794669.1',83,84,62);
INSERT INTO its1_source VALUES(2920,'MK794678.1',83,955,62);
INSERT INTO its1_source VALUES(2921,'MK794679.1',83,702,62);
INSERT INTO its1_source VALUES(2922,'MK794682.1',83,956,62);
INSERT INTO its1_source VALUES(2923,'MK794683.1',83,957,62);
INSERT INTO its1_source VALUES(2924,'MK794687.1',83,702,62);
INSERT INTO its1_source VALUES(2925,'MK794690.1',83,702,62);
INSERT INTO its1_source VALUES(2926,'MK794702.1',83,958,62);
INSERT INTO its1_source VALUES(2927,'MK794705.1',83,697,62);
INSERT INTO its1_source VALUES(2928,'MK794706.1',83,959,6);
INSERT INTO its1_source VALUES(2929,'MK794708.1',83,204,5);
INSERT INTO its1_source VALUES(2930,'MK794709.1',83,697,62);
INSERT INTO its1_source VALUES(2931,'MK794718.1',83,960,6);
INSERT INTO its1_source VALUES(2932,'MK794719.1',83,961,6);
INSERT INTO its1_source VALUES(2933,'MK794721.1',83,916,62);
INSERT INTO its1_source VALUES(2934,'MK794725.1',83,962,6);
INSERT INTO its1_source VALUES(2935,'MK794726.1',83,962,6);
INSERT INTO its1_source VALUES(2936,'MK794727.1',83,697,62);
INSERT INTO its1_source VALUES(2937,'MK794731.1',83,963,62);
INSERT INTO its1_source VALUES(2938,'MK794735.1',83,964,62);
INSERT INTO its1_source VALUES(2939,'MK794736.1',83,965,62);
INSERT INTO its1_source VALUES(2940,'MK794740.1',83,966,6);
INSERT INTO its1_source VALUES(2941,'MK794744.1',83,697,62);
INSERT INTO its1_source VALUES(2942,'MK794746.1',83,966,6);
INSERT INTO its1_source VALUES(2943,'MK794747.1',83,967,5);
INSERT INTO its1_source VALUES(2944,'MK794749.1',83,960,6);
INSERT INTO its1_source VALUES(2945,'MK794763.1',83,916,62);
INSERT INTO its1_source VALUES(2946,'MK794764.1',83,916,62);
INSERT INTO its1_source VALUES(2947,'MK794771.1',83,968,62);
INSERT INTO its1_source VALUES(2948,'MK794772.1',83,969,62);
INSERT INTO its1_source VALUES(2949,'MK794778.1',83,84,62);
INSERT INTO its1_source VALUES(2950,'MK794782.1',83,84,62);
INSERT INTO its1_source VALUES(2951,'MK794789.1',83,970,62);
INSERT INTO its1_source VALUES(2952,'MK794790.1',83,84,62);
INSERT INTO its1_source VALUES(2953,'MK794823.1',83,971,6);
INSERT INTO its1_source VALUES(2956,'MK794865.1',83,972,62);
INSERT INTO its1_source VALUES(2957,'MK794868.1',83,84,62);
INSERT INTO its1_source VALUES(2958,'MK794885.1',83,973,6);
INSERT INTO its1_source VALUES(2959,'MK794892.1',83,974,6);
INSERT INTO its1_source VALUES(2960,'MK794898.1',83,84,62);
INSERT INTO its1_source VALUES(2961,'MK795010.1',83,697,62);
INSERT INTO its1_source VALUES(2962,'MK795013.1',83,170,62);
INSERT INTO its1_source VALUES(2963,'MK795019.1',83,715,62);
INSERT INTO its1_source VALUES(2964,'MK795024.1',83,975,62);
INSERT INTO its1_source VALUES(2965,'MK795044.1',83,976,6);
INSERT INTO its1_source VALUES(2966,'MK795046.1',83,697,62);
INSERT INTO its1_source VALUES(2968,'MK795055.1',83,916,62);
INSERT INTO its1_source VALUES(2969,'MK910124.1',83,977,62);
INSERT INTO its1_source VALUES(2970,'MK910135.1',83,978,55);
INSERT INTO its1_source VALUES(2971,'MK910138.1',83,979,55);
INSERT INTO its1_source VALUES(2972,'MK995626.1',83,834,5);
INSERT INTO its1_source VALUES(2973,'MK995627.1',83,26,5);
INSERT INTO its1_source VALUES(2974,'MN128431.1',83,195,5);
INSERT INTO its1_source VALUES(2975,'MN128432.1',83,980,5);
INSERT INTO its1_source VALUES(2976,'MN128442.1',83,981,55);
INSERT INTO its1_source VALUES(2977,'MN128443.1',83,654,55);
INSERT INTO its1_source VALUES(2978,'MN128444.1',83,981,55);
INSERT INTO its1_source VALUES(2979,'MN128445.1',83,982,55);
INSERT INTO its1_source VALUES(2980,'MN128446.1',83,981,55);
INSERT INTO its1_source VALUES(2982,'MN134587.1',83,983,5);
INSERT INTO its1_source VALUES(2983,'MN135945.1',83,13,5);
INSERT INTO its1_source VALUES(2984,'MN228692.1',83,10,5);
INSERT INTO its1_source VALUES(2985,'MN298737.1',83,984,5);
INSERT INTO its1_source VALUES(2986,'MN308034.1',83,985,9);
INSERT INTO its1_source VALUES(2987,'MN308035.1',83,985,9);
INSERT INTO its1_source VALUES(2988,'MN308036.1',83,985,9);
INSERT INTO its1_source VALUES(2989,'MN308037.1',83,985,9);
INSERT INTO its1_source VALUES(2990,'MN308038.1',83,985,9);
INSERT INTO its1_source VALUES(2991,'MN308039.1',83,985,9);
INSERT INTO its1_source VALUES(2992,'MN308040.1',83,985,9);
INSERT INTO its1_source VALUES(2993,'MN308041.1',83,985,9);
INSERT INTO its1_source VALUES(2994,'MN308042.1',83,986,9);
INSERT INTO its1_source VALUES(2995,'MN308043.1',83,985,9);
INSERT INTO its1_source VALUES(2996,'MN308044.1',83,985,9);
INSERT INTO its1_source VALUES(2997,'MN308045.1',83,985,9);
INSERT INTO its1_source VALUES(2998,'MN308046.1',83,985,9);
INSERT INTO its1_source VALUES(2999,'MN308047.1',83,985,9);
INSERT INTO its1_source VALUES(3000,'MN308048.1',83,985,9);
INSERT INTO its1_source VALUES(3001,'MN308049.1',83,985,9);
INSERT INTO its1_source VALUES(3002,'MN308050.1',83,985,9);
INSERT INTO its1_source VALUES(3003,'MN308051.1',83,797,9);
INSERT INTO its1_source VALUES(3004,'MN308052.1',83,236,9);
INSERT INTO its1_source VALUES(3005,'MN308053.1',83,236,9);
INSERT INTO its1_source VALUES(3006,'MN331558.1',83,987,5);
INSERT INTO its1_source VALUES(3007,'MN331559.1',83,987,5);
INSERT INTO its1_source VALUES(3008,'MN331560.1',83,987,5);
INSERT INTO its1_source VALUES(3009,'MN382351.1',83,13,5);
INSERT INTO its1_source VALUES(3010,'MN382352.1',83,13,5);
INSERT INTO its1_source VALUES(3011,'MN382353.1',83,13,5);
INSERT INTO its1_source VALUES(3012,'MN382354.1',83,13,5);
INSERT INTO its1_source VALUES(3013,'MN382355.1',83,13,5);
INSERT INTO its1_source VALUES(3014,'MN382356.1',83,13,5);
INSERT INTO its1_source VALUES(3015,'MN398593.1',83,84,62);
INSERT INTO its1_source VALUES(3016,'MN450312.1',83,985,9);
INSERT INTO its1_source VALUES(3017,'MN450313.1',83,236,9);
INSERT INTO its1_source VALUES(3018,'MN450314.1',83,236,9);
INSERT INTO its1_source VALUES(3019,'MN450315.1',83,988,9);
INSERT INTO its1_source VALUES(3020,'MN450316.1',83,989,9);
INSERT INTO its1_source VALUES(3021,'MN450317.1',83,989,9);
INSERT INTO its1_source VALUES(3022,'MN450318.1',83,985,9);
INSERT INTO its1_source VALUES(3023,'MN450319.1',83,236,9);
INSERT INTO its1_source VALUES(3024,'MN450320.1',83,236,9);
INSERT INTO its1_source VALUES(3025,'MN450321.1',83,990,9);
INSERT INTO its1_source VALUES(3026,'MN450322.1',83,991,9);
INSERT INTO its1_source VALUES(3027,'MN450323.1',83,236,9);
INSERT INTO its1_source VALUES(3028,'MN450324.1',83,992,9);
INSERT INTO its1_source VALUES(3029,'MN450325.1',83,992,9);
INSERT INTO its1_source VALUES(3030,'MN450326.1',83,236,9);
INSERT INTO its1_source VALUES(3031,'MN450327.1',83,236,9);
INSERT INTO its1_source VALUES(3032,'MN450328.1',83,236,9);
INSERT INTO its1_source VALUES(3033,'MN450329.1',83,236,9);
INSERT INTO its1_source VALUES(3034,'MN450330.1',83,236,9);
INSERT INTO its1_source VALUES(3035,'MN450331.1',83,236,9);
INSERT INTO its1_source VALUES(3036,'MN450332.1',83,236,9);
INSERT INTO its1_source VALUES(3037,'MN450333.1',83,236,9);
INSERT INTO its1_source VALUES(3038,'MN450334.1',83,236,9);
INSERT INTO its1_source VALUES(3039,'MN453584.1',83,209,5);
INSERT INTO its1_source VALUES(3040,'MN453585.1',83,993,5);
INSERT INTO its1_source VALUES(3041,'MN454778.1',83,84,62);
INSERT INTO its1_source VALUES(3042,'MN519500.1',83,994,5);
INSERT INTO its1_source VALUES(3043,'MN519502.1',83,995,5);
INSERT INTO its1_source VALUES(3044,'MN519503.1',83,996,5);
INSERT INTO its1_source VALUES(3045,'MN519504.1',83,997,5);
INSERT INTO its1_source VALUES(3046,'MN519505.1',83,367,5);
INSERT INTO its1_source VALUES(3047,'MN519506.1',83,367,5);
INSERT INTO its1_source VALUES(3048,'MN519507.1',83,367,5);
INSERT INTO its1_source VALUES(3049,'MN519508.1',83,996,5);
INSERT INTO its1_source VALUES(3050,'MN539989.1',83,998,5);
INSERT INTO its1_source VALUES(3051,'MN539990.1',83,999,5);
INSERT INTO its1_source VALUES(3052,'MN539991.1',83,13,5);
INSERT INTO its1_source VALUES(3053,'MN539992.1',83,1000,5);
INSERT INTO its1_source VALUES(3054,'MN539993.1',83,1001,5);
INSERT INTO its1_source VALUES(3055,'MN539996.1',83,13,5);
INSERT INTO its1_source VALUES(3056,'MN539997.1',83,13,5);
INSERT INTO its1_source VALUES(3057,'MN539998.1',83,998,5);
INSERT INTO its1_source VALUES(3058,'MN540639.1',83,402,5);
INSERT INTO its1_source VALUES(3059,'MN540640.1',83,402,5);
INSERT INTO its1_source VALUES(3060,'MN545892.1',83,288,5);
INSERT INTO its1_source VALUES(3061,'MN545893.1',83,1002,5);
INSERT INTO its1_source VALUES(3062,'MN545894.1',83,1003,5);
INSERT INTO its1_source VALUES(3063,'MN545895.1',83,1004,5);
INSERT INTO its1_source VALUES(3064,'MN545896.1',83,1002,5);
INSERT INTO its1_source VALUES(3065,'MN545897.1',83,41,5);
INSERT INTO its1_source VALUES(3066,'MN545898.1',83,1005,5);
INSERT INTO its1_source VALUES(3067,'MN549026.1',83,983,5);
INSERT INTO its1_source VALUES(3068,'MN590528.1',83,66,5);
INSERT INTO its1_source VALUES(3069,'MN590529.1',83,66,5);
INSERT INTO its1_source VALUES(3070,'MN590530.1',83,419,5);
INSERT INTO its1_source VALUES(3071,'MN755661.1',83,1006,5);
INSERT INTO its1_source VALUES(3072,'MN755672.1',83,1007,5);
INSERT INTO its1_source VALUES(3073,'MN755673.1',83,230,5);
INSERT INTO its1_source VALUES(3074,'MN755702.1',83,230,5);
INSERT INTO its1_source VALUES(3075,'MN755706.1',83,13,5);
INSERT INTO its1_source VALUES(3076,'MN755714.1',83,230,5);
INSERT INTO its1_source VALUES(3077,'MN755715.1',83,1008,5);
INSERT INTO its1_source VALUES(3078,'MN755719.1',83,95,5);
INSERT INTO its1_source VALUES(3079,'MN755723.1',83,230,5);
INSERT INTO its1_source VALUES(3080,'MN755730.1',83,230,5);
INSERT INTO its1_source VALUES(3081,'MN755735.1',83,230,5);
INSERT INTO its1_source VALUES(3082,'MN755743.1',83,230,5);
INSERT INTO its1_source VALUES(3083,'MN755747.1',83,230,5);
INSERT INTO its1_source VALUES(3084,'MN755753.1',83,230,5);
INSERT INTO its1_source VALUES(3085,'MN755756.1',83,230,5);
INSERT INTO its1_source VALUES(3086,'MN755761.1',83,1009,5);
INSERT INTO its1_source VALUES(3087,'MN833032.1',83,160,5);
INSERT INTO its1_source VALUES(3088,'MN857706.1',83,1010,55);
INSERT INTO its1_source VALUES(3089,'MN857707.1',83,1011,55);
INSERT INTO its1_source VALUES(3090,'MN900848.1',83,1012,62);
INSERT INTO its1_source VALUES(3091,'MN901121.1',83,1013,6);
INSERT INTO its1_source VALUES(3092,'MN901122.1',83,1013,6);
INSERT INTO its1_source VALUES(3093,'MN901149.1',83,1014,6);
INSERT INTO its1_source VALUES(3094,'MN901163.1',83,1015,6);
INSERT INTO its1_source VALUES(3095,'MN901169.1',83,1016,62);
INSERT INTO its1_source VALUES(3096,'MN901170.1',83,1017,62);
INSERT INTO its1_source VALUES(3097,'MN901171.1',83,1016,62);
INSERT INTO its1_source VALUES(3098,'MN901221.1',83,1017,62);
INSERT INTO its1_source VALUES(3099,'MN904906.1',83,1018,62);
INSERT INTO its1_source VALUES(3100,'MN904908.1',83,1019,62);
INSERT INTO its1_source VALUES(3101,'MN907432.1',83,1020,62);
INSERT INTO its1_source VALUES(3102,'MN907433.1',83,1021,62);
INSERT INTO its1_source VALUES(3103,'MN907434.1',83,1022,62);
INSERT INTO its1_source VALUES(3104,'MN907435.1',83,640,62);
INSERT INTO its1_source VALUES(3105,'MN922782.1',83,1023,62);
INSERT INTO its1_source VALUES(3106,'MN960436.1',83,13,5);
INSERT INTO its1_source VALUES(3107,'MN960437.1',83,1024,5);
INSERT INTO its1_source VALUES(3108,'MN960453.1',83,13,5);
INSERT INTO its1_source VALUES(3109,'MN960456.1',83,1024,5);
INSERT INTO its1_source VALUES(3110,'MN960458.1',83,1024,5);
INSERT INTO its1_source VALUES(3111,'MT036256.1',83,1025,5);
INSERT INTO its1_source VALUES(3112,'MT052675.1',83,60,5);
INSERT INTO its1_source VALUES(3113,'MT065831.1',83,1026,5);
INSERT INTO its1_source VALUES(3114,'MT065834.1',83,1027,5);
INSERT INTO its1_source VALUES(3115,'MT065835.1',83,1028,5);
INSERT INTO its1_source VALUES(3116,'MT065838.1',83,1029,5);
INSERT INTO its1_source VALUES(3117,'MT065839.1',83,1030,5);
INSERT INTO its1_source VALUES(3118,'MT065840.1',83,1031,5);
INSERT INTO its1_source VALUES(3119,'MT065844.1',83,1032,5);
INSERT INTO its1_source VALUES(3120,'MT065853.1',83,1033,5);
INSERT INTO its1_source VALUES(3121,'MT065861.1',83,1034,5);
INSERT INTO its1_source VALUES(3122,'MT065864.1',83,1035,5);
INSERT INTO its1_source VALUES(3123,'MT065867.1',83,352,5);
INSERT INTO its1_source VALUES(3124,'MT065873.1',83,620,5);
INSERT INTO its1_source VALUES(3125,'MT074263.1',83,1036,5);
INSERT INTO its1_source VALUES(3126,'MT074264.1',83,1036,5);
INSERT INTO its1_source VALUES(3127,'MT074265.1',83,1036,5);
INSERT INTO its1_source VALUES(3128,'MT074266.1',83,1036,5);
INSERT INTO its1_source VALUES(3129,'MT074267.1',83,60,5);
INSERT INTO its1_source VALUES(3130,'MT074268.1',83,60,5);
INSERT INTO its1_source VALUES(3131,'MT074269.1',83,60,5);
INSERT INTO its1_source VALUES(3132,'MT074270.1',83,60,5);
INSERT INTO its1_source VALUES(3133,'MT103546.1',83,234,5);
INSERT INTO its1_source VALUES(3134,'MT137342.1',83,1037,9);
INSERT INTO its1_source VALUES(3135,'MT137343.1',83,103,9);
INSERT INTO its1_source VALUES(3136,'MT193301.1',83,1038,55);
INSERT INTO its1_source VALUES(3137,'MT193302.1',83,1039,55);
INSERT INTO its1_source VALUES(3138,'MT193303.1',83,1040,55);
INSERT INTO its1_source VALUES(3139,'MT193304.1',83,1041,55);
INSERT INTO its1_source VALUES(3140,'MT193305.1',83,1041,55);
INSERT INTO its1_source VALUES(3141,'MT193306.1',83,1042,55);
INSERT INTO its1_source VALUES(3142,'MT193307.1',83,1043,6);
INSERT INTO its1_source VALUES(3143,'MT193308.1',83,1044,6);
INSERT INTO its1_source VALUES(3144,'MT193309.1',83,1045,55);
INSERT INTO its1_source VALUES(3145,'MT193310.1',83,1045,55);
INSERT INTO its1_source VALUES(3146,'MT193403.1',83,1046,6);
INSERT INTO its1_source VALUES(3147,'MT193404.1',83,1046,6);
INSERT INTO its1_source VALUES(3148,'MT232873.1',83,182,55);
INSERT INTO its1_source VALUES(3149,'MT248335.1',83,402,5);
INSERT INTO its1_source VALUES(3150,'MT248336.1',83,402,5);
INSERT INTO its1_source VALUES(3151,'MT248337.1',83,402,5);
INSERT INTO its1_source VALUES(3152,'MT248338.1',83,402,5);
INSERT INTO its1_source VALUES(3153,'MT248339.1',83,402,5);
INSERT INTO its1_source VALUES(3154,'MT248340.1',83,402,5);
INSERT INTO its1_source VALUES(3155,'MT339042.1',83,1047,5);
INSERT INTO its1_source VALUES(3156,'MT355380.1',83,1048,5);
INSERT INTO its1_source VALUES(3157,'MT355382.1',83,1049,5);
INSERT INTO its1_source VALUES(3158,'MT355389.1',83,1050,5);
INSERT INTO its1_source VALUES(3159,'MT355393.1',83,117,5);
INSERT INTO its1_source VALUES(3160,'MT355394.1',83,357,5);
INSERT INTO its1_source VALUES(3161,'MT420380.1',83,1051,5);
INSERT INTO its1_source VALUES(3162,'MT420381.1',83,1052,5);
INSERT INTO its1_source VALUES(3163,'MT420398.1',83,1053,5);
INSERT INTO its1_source VALUES(3164,'MT420410.1',83,1054,5);
INSERT INTO its1_source VALUES(3165,'MT436814.1',83,1055,9);
INSERT INTO its1_source VALUES(3166,'MT451937.1',83,234,5);
INSERT INTO its1_source VALUES(3167,'MT451938.1',83,234,5);
INSERT INTO its1_source VALUES(3168,'MT457753.1',83,1056,62);
INSERT INTO its1_source VALUES(3169,'MT457757.1',83,84,62);
INSERT INTO its1_source VALUES(3170,'MT457758.1',83,1057,62);
INSERT INTO its1_source VALUES(3171,'MT457759.1',83,1058,6);
INSERT INTO its1_source VALUES(3172,'MT457766.1',83,1056,62);
INSERT INTO its1_source VALUES(3173,'MT457767.1',83,1056,62);
INSERT INTO its1_source VALUES(3174,'MT457768.1',83,84,62);
INSERT INTO its1_source VALUES(3175,'MT457775.1',83,1059,55);
INSERT INTO its1_source VALUES(3176,'MT478125.1',83,234,5);
INSERT INTO its1_source VALUES(3177,'MT478128.1',83,234,5);
INSERT INTO its1_source VALUES(3178,'MT512877.1',83,746,9);
INSERT INTO its1_source VALUES(3179,'MT647272.1',83,1010,55);
INSERT INTO its1_source VALUES(3180,'MT647273.1',83,1060,55);
INSERT INTO its1_source VALUES(3181,'MT663314.1',83,1061,5);
INSERT INTO its1_source VALUES(3182,'MT666070.1',83,100,9);
INSERT INTO its1_source VALUES(3183,'MT666087.1',83,234,5);
INSERT INTO its1_source VALUES(3184,'MT666088.1',83,234,5);
INSERT INTO its1_source VALUES(3185,'MT666089.1',83,234,5);
INSERT INTO its1_source VALUES(3186,'MT666090.1',83,234,5);
INSERT INTO its1_source VALUES(3187,'MT666091.1',83,234,5);
INSERT INTO its1_source VALUES(3188,'MT666092.1',83,234,5);
INSERT INTO its1_source VALUES(3189,'MT678666.1',83,1062,5);
INSERT INTO its1_source VALUES(3190,'MT678667.1',83,1063,5);
INSERT INTO its1_source VALUES(3191,'MT678668.1',83,1064,5);
INSERT INTO its1_source VALUES(3192,'MT678669.1',83,1062,5);
INSERT INTO its1_source VALUES(3193,'MT678670.1',83,1062,5);
INSERT INTO its1_source VALUES(3194,'MT678671.1',83,1065,5);
INSERT INTO its1_source VALUES(3195,'MT678672.1',83,1062,5);
INSERT INTO its1_source VALUES(3196,'MT678673.1',83,1062,5);
INSERT INTO its1_source VALUES(3197,'MT678674.1',83,1066,5);
INSERT INTO its1_source VALUES(3198,'MT678675.1',83,1062,5);
INSERT INTO its1_source VALUES(3199,'MT678676.1',83,1064,5);
INSERT INTO its1_source VALUES(3200,'MT678677.1',83,1067,5);
INSERT INTO its1_source VALUES(3201,'MT678678.1',83,1068,5);
INSERT INTO its1_source VALUES(3202,'MT678679.1',83,1069,5);
INSERT INTO its1_source VALUES(3203,'MT678680.1',83,1062,5);
INSERT INTO its1_source VALUES(3204,'MT678681.1',83,1070,5);
INSERT INTO its1_source VALUES(3205,'MT678682.1',83,1062,5);
INSERT INTO its1_source VALUES(3206,'MT680628.1',83,1071,4);
INSERT INTO its1_source VALUES(3207,'MT683125.1',83,1033,5);
INSERT INTO its1_source VALUES(3208,'MT740810.1',83,1072,5);
INSERT INTO its1_source VALUES(3209,'MT740815.1',83,1073,5);
INSERT INTO its1_source VALUES(3210,'MT758164.1',83,1074,62);
INSERT INTO its1_source VALUES(3211,'MT758165.1',83,397,55);
INSERT INTO its1_source VALUES(3212,'MT758171.1',83,1075,6);
INSERT INTO its1_source VALUES(3213,'MT758172.1',83,1076,55);
INSERT INTO its1_source VALUES(3214,'MT758178.1',83,1077,55);
INSERT INTO its1_source VALUES(3215,'MT758180.1',83,1078,55);
INSERT INTO its1_source VALUES(3216,'MT880222.1',83,1072,5);
INSERT INTO its1_source VALUES(3217,'MT990562.1',83,235,5);
INSERT INTO its1_source VALUES(3218,'MT990563.1',83,235,5);
INSERT INTO its1_source VALUES(3219,'MT990564.1',83,419,5);
INSERT INTO its1_source VALUES(3220,'MW008871.1',83,343,5);
INSERT INTO its1_source VALUES(3221,'MW192278.1',83,1079,5);
INSERT INTO its1_source VALUES(3222,'MW192279.1',83,1079,5);
INSERT INTO its1_source VALUES(3223,'MW192280.1',83,1079,5);
INSERT INTO its1_source VALUES(3224,'MW192281.1',83,1079,5);
INSERT INTO its1_source VALUES(3225,'MW192282.1',83,1079,5);
INSERT INTO its1_source VALUES(3226,'MW192283.1',83,1079,5);
INSERT INTO its1_source VALUES(3227,'MW192284.1',83,1079,5);
INSERT INTO its1_source VALUES(3228,'MW192285.1',83,1079,5);
INSERT INTO its1_source VALUES(3229,'MW192286.1',83,1079,5);
INSERT INTO its1_source VALUES(3230,'MW192287.1',83,1079,5);
INSERT INTO its1_source VALUES(3231,'MW192288.1',83,1079,5);
INSERT INTO its1_source VALUES(3232,'MW192289.1',83,1079,5);
INSERT INTO its1_source VALUES(3233,'MW193095.1',83,1080,5);
INSERT INTO its1_source VALUES(3234,'MW234464.1',83,1081,5);
INSERT INTO its1_source VALUES(3235,'MW275968.1',83,1082,55);
INSERT INTO its1_source VALUES(3236,'MW275969.1',83,117,5);
INSERT INTO its1_source VALUES(3237,'MW306664.1',83,1083,4);
INSERT INTO its1_source VALUES(3238,'MW361335.1',83,601,9);
INSERT INTO its1_source VALUES(3239,'MW369641.1',83,1084,62);
INSERT INTO its1_source VALUES(3241,'MW426381.1',83,1085,55);
INSERT INTO its1_source VALUES(3242,'MW426382.1',83,1086,55);
INSERT INTO its1_source VALUES(3244,'MW486624.1',83,773,5);
INSERT INTO its1_source VALUES(3245,'MW644645.1',83,1087,5);
INSERT INTO its1_source VALUES(3246,'MW647582.1',83,1088,55);
INSERT INTO its1_source VALUES(3247,'MW689257.1',83,1055,9);
INSERT INTO its1_source VALUES(3248,'MW703485.1',83,1089,30);
INSERT INTO its1_source VALUES(3249,'MW703486.1',83,129,30);
INSERT INTO its1_source VALUES(3250,'MW769778.1',83,13,5);
INSERT INTO its1_source VALUES(3251,'MW769784.1',83,13,5);
INSERT INTO its1_source VALUES(3252,'MW769927.1',83,13,5);
INSERT INTO its1_source VALUES(3253,'MW772238.1',83,13,5);
INSERT INTO its1_source VALUES(3254,'MW772252.1',83,13,5);
INSERT INTO its1_source VALUES(3255,'MW772365.1',83,13,5);
INSERT INTO its1_source VALUES(3256,'MW772384.1',83,13,5);
INSERT INTO its1_source VALUES(3257,'MW882101.1',83,1090,5);
INSERT INTO its1_source VALUES(3258,'MW882102.1',83,46,5);
INSERT INTO its1_source VALUES(3259,'MW882106.1',83,1091,5);
INSERT INTO its1_source VALUES(3260,'MW882108.1',83,13,5);
INSERT INTO its1_source VALUES(3261,'MW882112.1',83,1092,5);
INSERT INTO its1_source VALUES(3262,'MW882114.1',83,1093,5);
INSERT INTO its1_source VALUES(3263,'MW882115.1',83,326,5);
INSERT INTO its1_source VALUES(3264,'MW882116.1',83,1094,5);
INSERT INTO its1_source VALUES(3265,'MW882120.1',83,26,5);
INSERT INTO its1_source VALUES(3266,'MW882123.1',83,784,5);
INSERT INTO its1_source VALUES(3267,'MW882124.1',83,1095,5);
INSERT INTO its1_source VALUES(3268,'MW991429.1',83,129,30);
INSERT INTO its1_source VALUES(3269,'KY788418.X',84,1096,1173);
INSERT INTO its1_source VALUES(3270,'KY788382.X',84,1097,1169);
INSERT INTO its1_source VALUES(3271,'KY788384.X',84,1098,1169);
INSERT INTO its1_source VALUES(3272,'KP208466.1',84,1099,75);
INSERT INTO its1_source VALUES(3273,'KY788412.X',84,1100,1172);
INSERT INTO its1_source VALUES(3274,'KY788413.X',84,1100,1172);
INSERT INTO its1_source VALUES(3275,'KY788420.X',84,1101,1174);
INSERT INTO its1_source VALUES(3276,'KY788421.X',84,1101,1174);
INSERT INTO its1_source VALUES(3277,'KY788404.X',84,1102,1171);
INSERT INTO its1_source VALUES(3278,'AJ131990.X',85,1103,432);
INSERT INTO its1_source VALUES(3279,'EU925376.1',85,336,295);
INSERT INTO its1_source VALUES(3280,'HQ012957.X',85,1104,504);
INSERT INTO its1_source VALUES(3281,'KP863496.X',85,1105,246);
INSERT INTO its1_source VALUES(3282,'AY241924.X',85,983,459);
INSERT INTO its1_source VALUES(3283,'AY228564.X',85,39,352);
INSERT INTO its1_source VALUES(3284,'KP208401.1',85,1106,5);
INSERT INTO its1_source VALUES(3285,'DQ335646.X',85,1107,276);
INSERT INTO its1_source VALUES(3286,'AF449495.X',85,407,344);
INSERT INTO its1_source VALUES(3287,'MG542976.X',85,993,479);
INSERT INTO its1_source VALUES(3288,'HQ643236.X',85,23,289);
INSERT INTO its1_source VALUES(3289,'MG553207.1',85,20,289);
INSERT INTO its1_source VALUES(3290,'MG696477.1',85,20,289);
INSERT INTO its1_source VALUES(3291,'JF912516.X',85,20,289);
INSERT INTO its1_source VALUES(3292,'MG552087.1',85,34,289);
INSERT INTO its1_source VALUES(3293,'JN547636.X',85,514,505);
INSERT INTO its1_source VALUES(3294,'KJ372267.X',85,1108,506);
INSERT INTO its1_source VALUES(3295,'KU647272.X',85,303,314);
INSERT INTO its1_source VALUES(3296,'KJ705086.X',85,303,5);
INSERT INTO its1_source VALUES(3297,'KF112852.X',85,1109,463);
INSERT INTO its1_source VALUES(3298,'HQ012933.X',85,687,469);
INSERT INTO its1_source VALUES(3299,'HQ012953.X',85,1110,5);
INSERT INTO its1_source VALUES(3300,'JQ029956.X',85,1002,327);
INSERT INTO its1_source VALUES(3301,'JX113301.X',85,1111,486);
INSERT INTO its1_source VALUES(3302,'FJ237521.X',85,1112,221);
INSERT INTO its1_source VALUES(3303,'MF036196.X',85,1113,339);
INSERT INTO its1_source VALUES(3304,'GU111585.1',85,355,456);
INSERT INTO its1_source VALUES(3305,'EF523386.1',85,250,489);
INSERT INTO its1_source VALUES(3306,'JX978167.X',85,1114,418);
INSERT INTO its1_source VALUES(3307,'JX978155.X',85,843,417);
INSERT INTO its1_source VALUES(3308,'JF701436.X',85,1115,400);
INSERT INTO its1_source VALUES(3309,'AF266766.X',85,1116,213);
INSERT INTO its1_source VALUES(3310,'AJ131986.X',85,585,288);
INSERT INTO its1_source VALUES(3311,'KX011279.X',85,585,383);
INSERT INTO its1_source VALUES(3312,'MF036182.X',85,585,338);
INSERT INTO its1_source VALUES(3313,'AF266776.X',85,1117,350);
INSERT INTO its1_source VALUES(3314,'AF449494.X',85,1118,343);
INSERT INTO its1_source VALUES(3315,'HM752789.X',85,1119,303);
INSERT INTO its1_source VALUES(3316,'KC122237.X',85,245,380);
INSERT INTO its1_source VALUES(3317,'FJ392322.X',85,245,401);
INSERT INTO its1_source VALUES(3318,'HQ013223.X',85,61,508);
INSERT INTO its1_source VALUES(3319,'HQ261559.X',85,62,508);
INSERT INTO its1_source VALUES(3320,'HQ261569.X',85,1120,476);
INSERT INTO its1_source VALUES(3321,'KX094871.X',85,1121,457);
INSERT INTO its1_source VALUES(3322,'AB305060.1',85,83,457);
INSERT INTO its1_source VALUES(3323,'AB688356.X',85,1122,510);
INSERT INTO its1_source VALUES(3324,'AF266804.X',85,1123,255);
INSERT INTO its1_source VALUES(3325,'AF266798.X',85,1124,353);
INSERT INTO its1_source VALUES(3326,'KC478773.X',85,1125,433);
INSERT INTO its1_source VALUES(3327,'AF403505.X',85,1126,312);
INSERT INTO its1_source VALUES(3328,'KU682559.X',85,50,514);
INSERT INTO its1_source VALUES(3329,'KP295308.X',85,50,512);
INSERT INTO its1_source VALUES(3330,'KP295304.X',85,1127,513);
INSERT INTO its1_source VALUES(3331,'HQ643238.X',85,362,251);
INSERT INTO its1_source VALUES(3332,'HQ643263.X',85,51,255);
INSERT INTO its1_source VALUES(3333,'JQ653034.1',85,402,311);
INSERT INTO its1_source VALUES(3334,'HQ917910.X',85,10,292);
INSERT INTO its1_source VALUES(3335,'KJ755130.1',85,66,212);
INSERT INTO its1_source VALUES(3336,'DQ995184.1',85,31,330);
INSERT INTO its1_source VALUES(3337,'KU954009.X',85,9,330);
INSERT INTO its1_source VALUES(3338,'HQ013214.X',85,1128,444);
INSERT INTO its1_source VALUES(3339,'HQ013219.X',85,1128,474);
INSERT INTO its1_source VALUES(3340,'EF539174.X',85,578,405);
INSERT INTO its1_source VALUES(3341,'AB538397.X',85,1129,428);
INSERT INTO its1_source VALUES(3342,'AF266765.X',85,43,249);
INSERT INTO its1_source VALUES(3343,'AF266767.X',85,57,426);
INSERT INTO its1_source VALUES(3344,'AY550915.X',85,324,407);
INSERT INTO its1_source VALUES(3345,'KU211500.1',85,77,211);
INSERT INTO its1_source VALUES(3346,'KU211412.1',85,78,211);
INSERT INTO its1_source VALUES(3347,'MG865567.X',85,1130,376);
INSERT INTO its1_source VALUES(3348,'EF120469.XXX',85,15,241);
INSERT INTO its1_source VALUES(3349,'KF192695.X',85,1131,296);
INSERT INTO its1_source VALUES(3350,'HQ643194.X',85,13,346);
INSERT INTO its1_source VALUES(3351,'EF185089.X',85,288,329);
INSERT INTO its1_source VALUES(3352,'AF139368.X',85,1132,281);
INSERT INTO its1_source VALUES(3353,'AF266761.X',85,616,264);
INSERT INTO its1_source VALUES(3354,'AF266762.X',85,616,359);
INSERT INTO its1_source VALUES(3355,'KU899163.X',85,67,357);
INSERT INTO its1_source VALUES(3356,'KU899179.X',85,67,356);
INSERT INTO its1_source VALUES(3357,'AF139367.X',85,27,279);
INSERT INTO its1_source VALUES(3358,'KU517154.X',85,1133,234);
INSERT INTO its1_source VALUES(3359,'KU517153.X',85,1134,374);
INSERT INTO its1_source VALUES(3360,'MF036209.X',85,1135,341);
INSERT INTO its1_source VALUES(3361,'KU517155.X',85,1136,239);
INSERT INTO its1_source VALUES(3362,'AF449493.X',85,12,342);
INSERT INTO its1_source VALUES(3363,'KU517152.X',85,12,238);
INSERT INTO its1_source VALUES(3364,'KU899188.X',85,12,340);
INSERT INTO its1_source VALUES(3365,'AF266793.X',85,237,335);
INSERT INTO its1_source VALUES(3366,'HM004225.1',85,406,465);
INSERT INTO its1_source VALUES(3367,'MG865471.X',85,283,314);
INSERT INTO its1_source VALUES(3368,'JQ626599.1',85,473,466);
INSERT INTO its1_source VALUES(3369,'KJ705084.X',85,1137,5);
INSERT INTO its1_source VALUES(3370,'AF541899.X',85,274,349);
INSERT INTO its1_source VALUES(3371,'EU725805.X',85,621,507);
INSERT INTO its1_source VALUES(3372,'KP863493.X',85,53,294);
INSERT INTO its1_source VALUES(3373,'AF541895.X',85,1138,349);
INSERT INTO its1_source VALUES(3374,'KJ705085.X',85,1139,5);
INSERT INTO its1_source VALUES(3375,'AF266791.X',85,64,287);
INSERT INTO its1_source VALUES(3376,'MK496519.X',85,64,252);
INSERT INTO its1_source VALUES(3377,'JQ256377.X',85,234,462);
INSERT INTO its1_source VALUES(3378,'AF266790.X',85,1140,257);
INSERT INTO its1_source VALUES(3379,'HQ643155.X',85,1141,447);
INSERT INTO its1_source VALUES(3380,'KC478768.X',85,1142,435);
INSERT INTO its1_source VALUES(3381,'MG865573.X',85,1142,332);
INSERT INTO its1_source VALUES(3382,'EU301152.X',85,829,472);
INSERT INTO its1_source VALUES(3383,'HQ012948.X',85,1143,378);
INSERT INTO its1_source VALUES(3384,'HQ643240.X',85,305,425);
INSERT INTO its1_source VALUES(3385,'GU191231.X',85,1005,320);
INSERT INTO its1_source VALUES(3386,'KC855330.X',85,1144,286);
INSERT INTO its1_source VALUES(3387,'FJ237526.X',85,35,358);
INSERT INTO its1_source VALUES(3388,'KY819081.X',85,29,345);
INSERT INTO its1_source VALUES(3389,'AF266787.X',85,29,345);
INSERT INTO its1_source VALUES(3390,'AF279124.X',85,29,455);
INSERT INTO its1_source VALUES(3391,'FJ801320.X',85,1145,316);
INSERT INTO its1_source VALUES(3392,'HQ261620.X',85,1146,404);
INSERT INTO its1_source VALUES(3393,'EU748545.X',85,1147,402);
INSERT INTO its1_source VALUES(3394,'GU993903.X',85,358,299);
INSERT INTO its1_source VALUES(3395,'JN618819.X',85,361,250);
INSERT INTO its1_source VALUES(3396,'AF266784.X',85,1148,248);
INSERT INTO its1_source VALUES(3397,'AF266785.X',85,1149,352);
INSERT INTO its1_source VALUES(3398,'KJ372256.X',85,1150,394);
INSERT INTO its1_source VALUES(3399,'FJ746644.X',85,1151,430);
INSERT INTO its1_source VALUES(3400,'FJ801480.X',85,1152,429);
INSERT INTO its1_source VALUES(3401,'KY212008.X',85,194,321);
INSERT INTO its1_source VALUES(3402,'AY659421.X',85,1153,347);
INSERT INTO its1_source VALUES(3403,'AY659433.X',85,1154,347);
INSERT INTO its1_source VALUES(3404,'AF266797.X',85,24,331);
INSERT INTO its1_source VALUES(3405,'EU925375.1',85,204,290);
INSERT INTO its1_source VALUES(3406,'AF266796.X',85,41,347);
INSERT INTO its1_source VALUES(3407,'AY659438.X',85,41,347);
INSERT INTO its1_source VALUES(3408,'KT163268.X',85,1155,382);
INSERT INTO its1_source VALUES(3409,'KF286894.1',85,584,387);
INSERT INTO its1_source VALUES(3410,'DQ286726.X',85,584,387);
INSERT INTO its1_source VALUES(3411,'AY940661.X',85,76,484);
INSERT INTO its1_source VALUES(3412,'FJ469147.X',85,1156,460);
INSERT INTO its1_source VALUES(3413,'FJ801955.X',85,1157,334);
INSERT INTO its1_source VALUES(3414,'HQ643149.X',85,42,334);
INSERT INTO its1_source VALUES(3415,'GU111615.1',85,367,318);
INSERT INTO its1_source VALUES(3416,'MF036185.X',85,1158,338);
INSERT INTO its1_source VALUES(3417,'KJ494916.X',85,491,350);
INSERT INTO its1_source VALUES(3418,'AY332654.X',85,403,265);
INSERT INTO its1_source VALUES(3419,'KC529657.1',85,400,423);
INSERT INTO its1_source VALUES(3420,'AY230190.X',85,26,258);
INSERT INTO its1_source VALUES(3421,'AF266788.X',85,209,399);
INSERT INTO its1_source VALUES(3422,'JX951285.X',85,209,379);
INSERT INTO its1_source VALUES(3423,'FJ665225.X',85,235,214);
INSERT INTO its1_source VALUES(3424,'MG865523.X',85,87,333);
INSERT INTO its1_source VALUES(3425,'HQ643255.X',85,1159,514);
INSERT INTO its1_source VALUES(3426,'HQ894399.X',85,1160,376);
INSERT INTO its1_source VALUES(3427,'KP208450.1',85,1161,5);
INSERT INTO its1_source VALUES(3428,'AF266775.X',85,1162,263);
INSERT INTO its1_source VALUES(3429,'KY707117.X',85,1163,424);
INSERT INTO its1_source VALUES(3430,'DQ396409.X',85,576,446);
INSERT INTO its1_source VALUES(3431,'KY707115.X',85,1164,424);
INSERT INTO its1_source VALUES(3432,'KP208400.1',85,1165,5);
INSERT INTO its1_source VALUES(3433,'KC478752.X',85,1166,261);
INSERT INTO its1_source VALUES(3434,'GU111659.1',85,60,355);
INSERT INTO its1_source VALUES(3435,'KP208447.1',85,1167,5);
INSERT INTO its1_source VALUES(3436,'KP208457.1',85,1168,5);
INSERT INTO its1_source VALUES(3437,'KU726740.X',85,1169,346);
INSERT INTO its1_source VALUES(3438,'KP208412.1',85,1170,5);
INSERT INTO its1_source VALUES(3439,'KP208419.1',85,1171,5);
INSERT INTO its1_source VALUES(3440,'KP208462.1',85,1171,5);
INSERT INTO its1_source VALUES(3441,'KP208429.1',85,1172,5);
INSERT INTO its1_source VALUES(3442,'GU258796.X',85,55,349);
INSERT INTO its1_source VALUES(3443,'MG707826.X',85,1173,503);
INSERT INTO its1_source VALUES(3444,'FJ217679.X',85,1174,482);
INSERT INTO its1_source VALUES(3445,'KP208458.1',85,1175,5);
INSERT INTO its1_source VALUES(3446,'KC478761.X',85,1176,434);
INSERT INTO its1_source VALUES(3447,'KP208449.1',85,1177,5);
INSERT INTO its1_source VALUES(3448,'KP208421.1',85,1178,5);
INSERT INTO its1_source VALUES(3449,'KP208463.1',85,1178,5);
INSERT INTO its1_source VALUES(3450,'KP208416.1',85,1179,5);
INSERT INTO its1_source VALUES(3451,'KP208439.1',85,1180,5);
INSERT INTO its1_source VALUES(3452,'MF115290.X',85,1181,352);
INSERT INTO its1_source VALUES(3453,'AF266782.X',85,1182,354);
INSERT INTO its1_source VALUES(3454,'KP208441.1',85,1183,5);
INSERT INTO its1_source VALUES(3455,'KP208423.1',85,1184,5);
INSERT INTO its1_source VALUES(3456,'DQ297406.X',85,1185,334);
INSERT INTO its1_source VALUES(3457,'AY707987.X',85,240,328);
INSERT INTO its1_source VALUES(3458,'JX276054.X',85,240,375);
INSERT INTO its1_source VALUES(3459,'AF266772.X',85,46,427);
INSERT INTO its1_source VALUES(3460,'MK282205.X',85,46,458);
INSERT INTO its1_source VALUES(3461,'AF266773.X',85,47,360);
INSERT INTO its1_source VALUES(3462,'HQ643246.X',85,47,360);
INSERT INTO its1_source VALUES(3463,'AF266774.X',85,1186,361);
INSERT INTO its1_source VALUES(3464,'AF266777.X',85,1187,256);
INSERT INTO its1_source VALUES(3465,'EU216567.X',85,11,348);
INSERT INTO its1_source VALUES(3466,'KF777191.X',85,11,280);
INSERT INTO its1_source VALUES(3467,'AY770741.X',85,11,277);
INSERT INTO its1_source VALUES(3468,'AF266778.X',85,1188,259);
INSERT INTO its1_source VALUES(3469,'JF792528.X',85,1189,350);
INSERT INTO its1_source VALUES(3470,'KJ458953.X',85,48,432);
INSERT INTO its1_source VALUES(3471,'HQ261583.X',85,1190,432);
INSERT INTO its1_source VALUES(3472,'AB437135.X',85,1191,515);
INSERT INTO its1_source VALUES(3473,'KJ855324.1',85,333,215);
INSERT INTO its1_source VALUES(3474,'MG865520.X',85,326,215);
INSERT INTO its1_source VALUES(3475,'AY659739.X',85,1192,222);
INSERT INTO its1_source VALUES(3476,'AY659737.X',85,1193,222);
INSERT INTO its1_source VALUES(3477,'KC295544.X',85,1194,317);
INSERT INTO its1_source VALUES(3478,'AY659736.X',85,627,222);
INSERT INTO its1_source VALUES(3479,'FJ666127.X',85,1195,448);
INSERT INTO its1_source VALUES(3480,'KF192700.X',85,1196,298);
INSERT INTO its1_source VALUES(3481,'KC478749.X',85,1197,260);
INSERT INTO its1_source VALUES(3482,'KC478667.X',85,1198,443);
INSERT INTO its1_source VALUES(3483,'AJ131989.X',85,1199,431);
INSERT INTO its1_source VALUES(3484,'KX172090.X',85,1200,464);
INSERT INTO its1_source VALUES(3485,'KJ372258.X',85,1201,502);
INSERT INTO its1_source VALUES(3486,'HQ261661.X',85,1202,436);
INSERT INTO its1_source VALUES(3487,'EU660831.X',85,1203,315);
INSERT INTO its1_source VALUES(3488,'KP070720.X',85,1204,209);
INSERT INTO its1_source VALUES(3489,'AJ131987.X',85,49,210);
INSERT INTO its1_source VALUES(3490,'AF271221.X',85,1205,301);
INSERT INTO its1_source VALUES(3491,'KP208460.1',85,1206,5);
INSERT INTO its1_source VALUES(3492,'HQ013225.X',85,1207,471);
INSERT INTO its1_source VALUES(3493,'DQ297402.X',85,1208,509);
INSERT INTO its1_source VALUES(3494,'DQ297391.X',85,1209,508);
INSERT INTO its1_source VALUES(3495,'MG542998.X',85,1210,480);
INSERT INTO its1_source VALUES(3496,'KP208464.1',85,1211,5);
INSERT INTO its1_source VALUES(3497,'KY982930.X',85,1212,485);
INSERT INTO its1_source VALUES(3498,'KY982934.X',85,1213,485);
CREATE UNIQUE INDEX genus_species ON taxonomy (genus, species);
CREATE UNIQUE INDEX taxid_genus_species ON taxonomy (ncbi_taxid, genus, species);
COMMIT;
