cmake_minimum_required(VERSION 3.12.4)

#Look for an executable called sphinx-build
unset(SPHINX_EXECUTABLE)
unset(SPHINX_EXECUTABLE CACHE)
find_program(SPHINX_EXECUTABLE
             NAMES sphinx-build
             DOC "Path to sphinx-build executable"
             CMAKE_FIND_ROOT_PATH_BOTH)

include(FindPackageHandleStandardArgs)

#Handle standard arguments to find_package like REQUIRED and QUIET
find_package_handle_standard_args(Sphinx
                                  "Failed to find sphinx-build executable"
                                  SPHINX_EXECUTABLE)
