import numpy as np
import pinocchio as pin
from . import core as jiminy
from _typeshed import Incomplete
from dataclasses import dataclass
from typing import Callable, Sequence

LOGGER: Incomplete
TRAJ_INTERP_TOL: float

def SE3ToXYZRPY(M: pin.SE3) -> np.ndarray: ...
def XYZRPYToSE3(xyzrpy: np.ndarray) -> np.ndarray: ...
def XYZRPYToXYZQuat(xyzrpy: np.ndarray) -> np.ndarray: ...
def XYZQuatToXYZRPY(xyzquat: np.ndarray) -> np.ndarray: ...
def velocityXYZRPYToXYZQuat(xyzrpy: np.ndarray, dxyzrpy: np.ndarray) -> np.ndarray: ...
def velocityXYZQuatToXYZRPY(xyzquat: np.ndarray, v: np.ndarray) -> np.ndarray: ...

@dataclass
class State:
    t: float
    q: np.ndarray
    v: np.ndarray | None = ...
    a: np.ndarray | None = ...
    u: np.ndarray | None = ...
    command: np.ndarray | None = ...
    f_external: np.ndarray | None = ...
    lambda_c: np.ndarray | None = ...

TrajectoryTimeMode: Incomplete

@dataclass
class Trajectory:
    states: tuple[State, ...]
    robot: jiminy.Robot
    use_theoretical_model: bool
    def __init__(self, states: Sequence[State], robot: jiminy.Robot, use_theoretical_model: bool) -> None: ...
    @property
    def has_data(self) -> bool: ...
    @property
    def has_velocity(self) -> bool: ...
    @property
    def has_acceleration(self) -> bool: ...
    @property
    def has_effort(self) -> bool: ...
    @property
    def has_command(self) -> bool: ...
    @property
    def has_external_forces(self) -> bool: ...
    @property
    def has_constraints(self) -> bool: ...
    @property
    def optional_fields(self) -> tuple[str, ...]: ...
    @property
    def time_interval(self) -> tuple[float, float]: ...
    def get(self, t: float, mode: TrajectoryTimeMode = 'raise') -> State: ...

def update_quantities(robot: jiminy.Model, position: np.ndarray, velocity: np.ndarray | None = None, acceleration: np.ndarray | None = None, f_external: list[np.ndarray] | pin.StdVec_Force | None = None, update_dynamics: bool = True, update_centroidal: bool = True, update_energy: bool = True, update_jacobian: bool = False, update_collisions: bool = False, use_theoretical_model: bool = True) -> None: ...
def get_body_world_transform(robot: jiminy.Model, body_name: str, use_theoretical_model: bool = True, copy: bool = True) -> pin.SE3: ...
def get_body_world_velocity(robot: jiminy.Model, body_name: str, use_theoretical_model: bool = True) -> pin.SE3: ...
def get_body_world_acceleration(robot: jiminy.Model, body_name: str, use_theoretical_model: bool = True) -> pin.SE3: ...
def compute_transform_contact(robot: jiminy.Model, ground_profile: Callable[[np.ndarray], tuple[float, np.ndarray]] | None = None) -> pin.SE3: ...
def compute_freeflyer_state_from_fixed_body(robot: jiminy.Model, position: np.ndarray, velocity: np.ndarray | None = None, acceleration: np.ndarray | None = None, fixed_body_name: str | None = None, ground_profile: Callable[[np.ndarray], tuple[float, np.ndarray]] | None = None, use_theoretical_model: bool | None = None) -> None: ...
def compute_efforts_from_fixed_body(robot: jiminy.Model, position: np.ndarray, velocity: np.ndarray, acceleration: np.ndarray, fixed_body_name: str, use_theoretical_model: bool = True) -> tuple[np.ndarray, pin.Force]: ...
def compute_inverse_dynamics(robot: jiminy.Model, position: np.ndarray, velocity: np.ndarray, acceleration: np.ndarray, use_theoretical_model: bool = False) -> np.ndarray: ...
