"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .url import URL, URLTypedDict
from enum import Enum
from mollie import utils
from mollie.types import BaseModel
from mollie.utils import validate_open_enum
import pydantic
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EntityOnboardingStatusStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""The current status of the organization's onboarding process."""

    NEEDS_DATA = "needs-data"
    IN_REVIEW = "in-review"
    COMPLETED = "completed"


class EntityOnboardingStatusLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    organization: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityOnboardingStatusLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[URL], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    organization: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityOnboardingStatusTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains an onboarding status object. Will always contain the string `onboarding` for this
    resource type.
    """
    name: str
    r"""The name of the organization."""
    status: EntityOnboardingStatusStatus
    can_receive_payments: bool
    r"""Whether the organization can receive payments."""
    can_receive_settlements: bool
    r"""Whether the organization can receive settlements to their external bank account."""
    signed_up_at: str
    r"""The sign up date time of the organization in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: EntityOnboardingStatusLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class EntityOnboardingStatus(BaseModel):
    resource: str
    r"""Indicates the response contains an onboarding status object. Will always contain the string `onboarding` for this
    resource type.
    """

    name: str
    r"""The name of the organization."""

    status: Annotated[
        EntityOnboardingStatusStatus, PlainValidator(validate_open_enum(False))
    ]

    can_receive_payments: Annotated[bool, pydantic.Field(alias="canReceivePayments")]
    r"""Whether the organization can receive payments."""

    can_receive_settlements: Annotated[
        bool, pydantic.Field(alias="canReceiveSettlements")
    ]
    r"""Whether the organization can receive settlements to their external bank account."""

    signed_up_at: Annotated[str, pydantic.Field(alias="signedUpAt")]
    r"""The sign up date time of the organization in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[EntityOnboardingStatusLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
