# coding: utf-8

"""
    Amber Electric Public API

    Amber is an Australian-based electricity retailer that pass through the real-time wholesale price of energy.  Because of Amber's wholesale power prices, you can save hundreds of dollars a year by automating high power devices like air-conditioners, heat pumps and pool pumps.  This Python library provides an interface to the API, allowing you to react to current and forecast prices, as well as download your historic usage.

    The version of the OpenAPI document: 2.0.0
    Contact: dev@amber.com.au
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


try:

    from pydantic.v1 import BaseModel, Field, StrictStr
except ImportError:

    from pydantic import BaseModel, Field, StrictStr
from amberelectric.models.channel_type import ChannelType


class Channel(BaseModel):
    """
    Describes a power meter channel.  The General channel provides continuous power - it's the channel all of your appliances and lights are attached to.  Controlled loads are only on for a limited time during the day (usually when the load on the network is low, or generation is high) - you may have your hot water system attached to this channel.  The feed in channel sends power back to the grid - you will have these types of channels if you have solar or batteries.  # noqa: E501
    """

    identifier: StrictStr = Field(default=..., description="Identifier of the channel")
    type: ChannelType = Field(...)
    tariff: StrictStr = Field(default=..., description="The tariff code of the channel")
    __properties = ["identifier", "type", "tariff"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Channel:
        """Create an instance of Channel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Channel:
        """Create an instance of Channel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Channel.parse_obj(obj)

        _obj = Channel.parse_obj(
            {
                "identifier": obj.get("identifier"),
                "type": obj.get("type"),
                "tariff": obj.get("tariff"),
            }
        )
        return _obj
