// @license
// Copyright The Closure Library Authors.
// SPDX-License-Identifier: Apache-2.0

/**
 * @fileoverview List formatting symbols for all locales.
 *
 * This file is autogenerated by a script.
 * File generated from CLDR ver. 42
 *
 * To reduce the file size (which may cause issues in some JS
 * developing environments), this file will only contain locales
 * that are usually supported by Google products. It is a super
 * set of 40 languages. The rest of the data can be found in another file
 * named "listsymbolsext.js", which will be generated at the same
 * time as this file.
 *
 */

// clang-format off

goog.module('goog.i18n.ListFormatSymbolsExt');

const ListSymbols = goog.require('goog.i18n.ListFormatSymbols');

/**
 * @type {!ListSymbols.ListFormatSymbols}
 */
let defaultSymbols = ListSymbols.ListFormatSymbols_en;



/**
 * List formatting symbols for locale af_NA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_af_NA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} en {1}', '{0} en {1}', '{0} en {1}'],
  AND_END: ['{0} en {1}', '{0} en {1}', '{0}, {1}'],
  OR_TWO: ['{0} of {1}', '{0} of {1}', '{0} of {1}'],
  OR_END: ['{0} of {1}', '{0} of {1}', '{0} of {1}'],
  UNIT_END: ['{0} en {1}', '{0} en {1}', '{0} en {1}']
};

/**
 * List formatting symbols for locale af_ZA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_af_ZA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} en {1}', '{0} en {1}', '{0} en {1}'],
  AND_END: ['{0} en {1}', '{0} en {1}', '{0}, {1}'],
  OR_TWO: ['{0} of {1}', '{0} of {1}', '{0} of {1}'],
  OR_END: ['{0} of {1}', '{0} of {1}', '{0} of {1}'],
  UNIT_END: ['{0} en {1}', '{0} en {1}', '{0} en {1}']
};

/**
 * List formatting symbols for locale agq.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_agq = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale agq_CM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_agq_CM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ak.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ak = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ak_GH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ak_GH = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale am_ET.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_am_ET = {
  AND_START: ['{0}፣ {1}', '{0}፣ {1}', '{0}, {1}'],
  AND_TWO: ['{0} እና {1}', '{0} እና {1}', '{0} እና {1}'],
  AND_MIDDLE: ['{0}፣ {1}', '{0}፣ {1}', '{0}፣ {1}'],
  AND_END: ['{0}, እና {1}', '{0}, እና {1}', '{0}, እና {1}'],
  OR_START: ['{0}፣ {1}', '{0}፣ {1}', '{0}፣ {1}'],
  OR_TWO: ['{0} ወይም {1}﻿', '{0} ወይም {1}﻿', '{0} ወይም {1}﻿'],
  OR_MIDDLE: ['{0}፣ {1}', '{0}፣ {1}', '{0}፣ {1}'],
  OR_END: ['{0}፣ ወይም {1}', '{0}፣ ወይም {1}', '{0}፣ ወይም {1}'],
  UNIT_START: ['{0}፣ {1}', '{0}፣ {1}', '{0}፣ {1}'],
  UNIT_MIDDLE: ['{0}፣ {1}', '{0}፣ {1}', '{0}፣ {1}'],
  UNIT_END: ['{0}፣ {1}', '{0}፣ {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ar_001.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_001 = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_AE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_AE = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_BH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_BH = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_DJ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_DJ = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_EH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_EH = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_ER.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_ER = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_IL.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_IL = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_IQ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_IQ = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_JO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_JO = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_KM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_KM = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_KW.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_KW = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_LB.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_LB = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_LY.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_LY = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_MA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_MA = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_MR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_MR = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_OM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_OM = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_PS.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_PS = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_QA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_QA = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_SA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_SA = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_SD.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_SD = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_SO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_SO = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_SS.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_SS = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_SY.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_SY = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_TD.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_TD = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_TN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_TN = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_XB.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_XB = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0} و{1}'],
  AND_TWO: ['{0} ؜‮and‬؜ {1}', '{0} & {1}', '{0} و{1}'],
  AND_END: ['{0}, ؜‮and‬؜ {1}', '{0}, & {1}', '{0} و{1}'],
  OR_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} ؜‮or‬؜ {1}', '{0} ؜‮or‬؜ {1}', '{0} ؜‮or‬؜ {1}'],
  OR_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, ؜‮or‬؜ {1}', '{0}, ؜‮or‬؜ {1}', '{0}, ؜‮or‬؜ {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_YE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_YE = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale as.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_as = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} আৰু {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0} বা {1}', '{0} বা {1}', '{0} বা {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale as_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_as_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} আৰু {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0} বা {1}', '{0} বা {1}', '{0} বা {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale asa.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_asa = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale asa_TZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_asa_TZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ast.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ast = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_END: ['{0} y {1}', '{0} y {1}', '{0} y {1}']
};

/**
 * List formatting symbols for locale ast_ES.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ast_ES = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_END: ['{0} y {1}', '{0} y {1}', '{0} y {1}']
};

/**
 * List formatting symbols for locale az_Cyrl.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_az_Cyrl = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale az_Cyrl_AZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_az_Cyrl_AZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale az_Latn.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_az_Latn = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} və {1}', '{0} və {1}', '{0}, {1}'],
  OR_END: ['{0}, yaxud {1}', '{0}, yaxud {1}', '{0}, yaxud {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale az_Latn_AZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_az_Latn_AZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} və {1}', '{0} və {1}', '{0}, {1}'],
  OR_END: ['{0}, yaxud {1}', '{0}, yaxud {1}', '{0}, yaxud {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bas.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bas = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bas_CM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bas_CM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale be_BY.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_be_BY = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} і {1}', '{0} і {1}', '{0}, {1}'],
  OR_END: ['{0} ці {1}', '{0} ці {1}', '{0} ці {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale bem.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bem = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bem_ZM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bem_ZM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bez.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bez = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bez_TZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bez_TZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bg_BG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bg_BG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} и {1}', '{0} и {1}', '{0}, {1}'],
  AND_END: ['{0} и {1}', '{0} и {1}', '{0} и {1}'],
  OR_TWO: ['{0} или {1}', '{0} или {1}', '{0} или {1}'],
  OR_END: ['{0} или {1}', '{0} или {1}', '{0} или {1}'],
  UNIT_TWO: ['{0} и {1}', '{0} и {1}', '{0} и {1}'],
  UNIT_END: ['{0} и {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bgc.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bgc = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bgc_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bgc_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bho.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bho = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bho_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bho_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bm.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bm = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bm_ML.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bm_ML = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bn_BD.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bn_BD = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} এবং {1}', '{0} এবং {1}', '{0}, {1}'],
  OR_END: ['{0}, বা {1}', '{0}, বা {1}', '{0}, বা {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bn_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bn_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} এবং {1}', '{0} এবং {1}', '{0}, {1}'],
  OR_END: ['{0}, বা {1}', '{0}, বা {1}', '{0}, বা {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bo.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bo = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bo_CN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bo_CN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bo_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bo_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale br_FR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_br_FR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ha {1}', '{0} & {1}', '{0}, {1}'],
  OR_END: ['{0} pe {1}', '{0} pe {1}', '{0} pe {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale brx.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_brx = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} आरो {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, आरो {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale brx_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_brx_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} आरो {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, आरो {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bs_Cyrl.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bs_Cyrl = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} и {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bs_Cyrl_BA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bs_Cyrl_BA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} и {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bs_Latn.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bs_Latn = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} i {1}', '{0} i {1}', '{0}, {1}'],
  OR_END: ['{0} ili {1}', '{0} ili {1}', '{0} ili {1}'],
  UNIT_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}']
};

/**
 * List formatting symbols for locale bs_Latn_BA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bs_Latn_BA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} i {1}', '{0} i {1}', '{0}, {1}'],
  OR_END: ['{0} ili {1}', '{0} ili {1}', '{0} ili {1}'],
  UNIT_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}']
};

/**
 * List formatting symbols for locale ca_AD.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ca_AD = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}']
};

/**
 * List formatting symbols for locale ca_ES.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ca_ES = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}']
};

/**
 * List formatting symbols for locale ca_FR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ca_FR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}']
};

/**
 * List formatting symbols for locale ca_IT.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ca_IT = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}']
};

/**
 * List formatting symbols for locale ccp.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ccp = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} 𑄃𑄳𑄃 {1}', '{0} 𑄃𑄳𑄃 {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ccp_BD.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ccp_BD = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} 𑄃𑄳𑄃 {1}', '{0} 𑄃𑄳𑄃 {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ccp_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ccp_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} 𑄃𑄳𑄃 {1}', '{0} 𑄃𑄳𑄃 {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ce.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ce = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ce_RU.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ce_RU = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ceb.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ceb = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} ug {1}', '{0} ug {1}', '{0}, {1}'],
  AND_END: ['{0}, ug {1}', '{0}, ug {1}', '{0}, {1}'],
  OR_TWO: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  OR_END: ['{0}, o {1}', '{0}, o {1}', '{0}, o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ceb_PH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ceb_PH = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} ug {1}', '{0} ug {1}', '{0}, {1}'],
  AND_END: ['{0}, ug {1}', '{0}, ug {1}', '{0}, {1}'],
  OR_TWO: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  OR_END: ['{0}, o {1}', '{0}, o {1}', '{0}, o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale cgg.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_cgg = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale cgg_UG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_cgg_UG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale chr_US.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_chr_US = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} ᎠᎴ {1}', '{0} & {1}', '{0}, {1}'],
  AND_END: ['{0}, ᎠᎴ {1}', '{0}, & {1}', '{0}, & {1}'],
  OR_TWO: ['{0} ᎠᎴᏱᎩ {1}', '{0} ᎠᎴᏱᎩ {1}', '{0} ᎠᎴᏱᎩ {1}'],
  OR_END: ['{0}, ᎠᎴᏱᎩ {1}', '{0}, ᎠᎴᏱᎩ {1}', '{0}, ᎠᎴᏱᎩ {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ckb.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ckb = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ckb_Arab.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ckb_Arab = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ckb_Arab_IQ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ckb_Arab_IQ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ckb_Arab_IR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ckb_Arab_IR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ckb_IQ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ckb_IQ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ckb_IR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ckb_IR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale cs_CZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_cs_CZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} a {1}', '{0} a {1}', '{0}, {1}'],
  OR_END: ['{0} nebo {1}', '{0} nebo {1}', '{0} nebo {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} a {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} a {1}', '{0} a {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale cv.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_cv = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} тата {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0} е {1}', '{0} е {1}', '{0} е {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale cv_RU.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_cv_RU = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} тата {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0} е {1}', '{0} е {1}', '{0} е {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale cy_GB.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_cy_GB = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} a(c) {1}', '{0} a(c) {1}', '{0}, {1}'],
  AND_END: ['{0}, a(c) {1}', '{0}, a(c) {1}', '{0}, {1}'],
  OR_TWO: ['{0} neu {1}', '{0} neu {1}', '{0} neu {1}'],
  OR_END: ['{0} neu {1}', '{0} neu {1}', '{0} neu {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale da_DK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_da_DK = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} og {1}', '{0} og {1}', '{0}, {1}'],
  OR_END: ['{0} eller {1}', '{0} eller {1}', '{0} eller {1}'],
  UNIT_END: ['{0} og {1}', '{0} og {1}', '{0} og {1}']
};

/**
 * List formatting symbols for locale da_GL.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_da_GL = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} og {1}', '{0} og {1}', '{0}, {1}'],
  OR_END: ['{0} eller {1}', '{0} eller {1}', '{0} eller {1}'],
  UNIT_END: ['{0} og {1}', '{0} og {1}', '{0} og {1}']
};

/**
 * List formatting symbols for locale dav.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_dav = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale dav_KE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_dav_KE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale de_BE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_de_BE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} und {1}', '{0} und {1}', '{0}, {1}'],
  OR_END: ['{0} oder {1}', '{0} oder {1}', '{0} oder {1}'],
  UNIT_TWO: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0} und {1}', '{0} und {1}', '{0} und {1}']
};

/**
 * List formatting symbols for locale de_DE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_de_DE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} und {1}', '{0} und {1}', '{0}, {1}'],
  OR_END: ['{0} oder {1}', '{0} oder {1}', '{0} oder {1}'],
  UNIT_TWO: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0} und {1}', '{0} und {1}', '{0} und {1}']
};

/**
 * List formatting symbols for locale de_IT.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_de_IT = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} und {1}', '{0} und {1}', '{0}, {1}'],
  OR_END: ['{0} oder {1}', '{0} oder {1}', '{0} oder {1}'],
  UNIT_TWO: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0} und {1}', '{0} und {1}', '{0} und {1}']
};

/**
 * List formatting symbols for locale de_LI.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_de_LI = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} und {1}', '{0} und {1}', '{0}, {1}'],
  OR_END: ['{0} oder {1}', '{0} oder {1}', '{0} oder {1}'],
  UNIT_TWO: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0} und {1}', '{0} und {1}', '{0} und {1}']
};

/**
 * List formatting symbols for locale de_LU.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_de_LU = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} und {1}', '{0} und {1}', '{0}, {1}'],
  OR_END: ['{0} oder {1}', '{0} oder {1}', '{0} oder {1}'],
  UNIT_TWO: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0} und {1}', '{0} und {1}', '{0} und {1}']
};

/**
 * List formatting symbols for locale dje.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_dje = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale dje_NE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_dje_NE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale doi.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_doi = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} ते {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, ते {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale doi_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_doi_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} ते {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, ते {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale dsb.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_dsb = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} a {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0} abo {1}', '{0} abo {1}', '{0} abo {1}'],
  UNIT_TWO: ['{0} a {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0} a {1}', '{0} a {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale dsb_DE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_dsb_DE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} a {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0} abo {1}', '{0} abo {1}', '{0} abo {1}'],
  UNIT_TWO: ['{0} a {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0} a {1}', '{0} a {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale dua.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_dua = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale dua_CM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_dua_CM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale dyo.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_dyo = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale dyo_SN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_dyo_SN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale dz.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_dz = {
  AND_START: ['{0} དང་ {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} དང་ {1}', '{0}, {1}', '{0}, {1}'],
  OR_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale dz_BT.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_dz_BT = {
  AND_START: ['{0} དང་ {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} དང་ {1}', '{0}, {1}', '{0}, {1}'],
  OR_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ebu.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ebu = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ebu_KE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ebu_KE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ee.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ee = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} kple {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, kple {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_TWO: ['{0} kple {1}', '{0} kple {1}', '{0} kple {1}'],
  UNIT_END: ['{0}, kple {1}', '{0}, kple {1}', '{0}, kple {1}']
};

/**
 * List formatting symbols for locale ee_GH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ee_GH = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} kple {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, kple {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_TWO: ['{0} kple {1}', '{0} kple {1}', '{0} kple {1}'],
  UNIT_END: ['{0}, kple {1}', '{0}, kple {1}', '{0}, kple {1}']
};

/**
 * List formatting symbols for locale ee_TG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ee_TG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} kple {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, kple {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_TWO: ['{0} kple {1}', '{0} kple {1}', '{0} kple {1}'],
  UNIT_END: ['{0}, kple {1}', '{0}, kple {1}', '{0}, kple {1}']
};

/**
 * List formatting symbols for locale el_CY.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_el_CY = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} και {1}', '{0} και {1}', '{0}, {1}'],
  OR_END: ['{0} ή {1}', '{0} ή {1}', '{0} ή {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale el_GR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_el_GR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} και {1}', '{0} και {1}', '{0}, {1}'],
  OR_END: ['{0} ή {1}', '{0} ή {1}', '{0} ή {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_001.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_001 = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_150.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_150 = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_AE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_AE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} and {1}', '{0} & {1}', '{0}, {1}'],
  AND_END: ['{0}, and {1}', '{0}, & {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_AG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_AG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_AI.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_AI = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_AS.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_AS = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} and {1}', '{0} & {1}', '{0}, {1}'],
  AND_END: ['{0}, and {1}', '{0}, & {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_AT.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_AT = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_BB.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_BB = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_BE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_BE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_BI.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_BI = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} and {1}', '{0} & {1}', '{0}, {1}'],
  AND_END: ['{0}, and {1}', '{0}, & {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_BM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_BM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_BS.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_BS = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_BW.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_BW = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_BZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_BZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_CC.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_CC = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_CH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_CH = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_CK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_CK = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_CM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_CM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_CX.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_CX = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_CY.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_CY = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_DE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_DE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_DG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_DG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_DK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_DK = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_DM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_DM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_ER.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_ER = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_FI.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_FI = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_FJ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_FJ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_FK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_FK = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_FM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_FM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_GD.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_GD = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_GG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_GG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_GH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_GH = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_GI.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_GI = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_GM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_GM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_GU.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_GU = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} and {1}', '{0} & {1}', '{0}, {1}'],
  AND_END: ['{0}, and {1}', '{0}, & {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_GY.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_GY = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_HK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_HK = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_IL.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_IL = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_IM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_IM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_IO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_IO = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_JE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_JE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_JM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_JM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_KE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_KE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_KI.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_KI = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_KN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_KN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_KY.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_KY = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_LC.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_LC = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_LR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_LR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_LS.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_LS = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_MG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_MG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_MH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_MH = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} and {1}', '{0} & {1}', '{0}, {1}'],
  AND_END: ['{0}, and {1}', '{0}, & {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_MO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_MO = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_MP.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_MP = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} and {1}', '{0} & {1}', '{0}, {1}'],
  AND_END: ['{0}, and {1}', '{0}, & {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_MS.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_MS = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_MT.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_MT = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_MU.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_MU = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_MV.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_MV = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_MW.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_MW = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_MY.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_MY = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_NA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_NA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_NF.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_NF = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_NG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_NG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_NL.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_NL = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_NR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_NR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_NU.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_NU = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_NZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_NZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_PG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_PG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_PH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_PH = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} and {1}', '{0} & {1}', '{0}, {1}'],
  AND_END: ['{0}, and {1}', '{0}, & {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_PK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_PK = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_PN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_PN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_PR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_PR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} and {1}', '{0} & {1}', '{0}, {1}'],
  AND_END: ['{0}, and {1}', '{0}, & {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_PW.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_PW = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_RW.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_RW = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_SB.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_SB = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_SC.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_SC = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_SD.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_SD = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_SE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_SE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_SH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_SH = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_SI.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_SI = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_SL.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_SL = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_SS.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_SS = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_SX.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_SX = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_SZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_SZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_TC.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_TC = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_TK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_TK = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_TO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_TO = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_TT.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_TT = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_TV.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_TV = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_TZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_TZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_UG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_UG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_UM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_UM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} and {1}', '{0} & {1}', '{0}, {1}'],
  AND_END: ['{0}, and {1}', '{0}, & {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_US_POSIX.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_US_POSIX = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} and {1}', '{0} & {1}', '{0}, {1}'],
  AND_END: ['{0}, and {1}', '{0}, & {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_VC.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_VC = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_VG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_VG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_VI.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_VI = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} and {1}', '{0} & {1}', '{0}, {1}'],
  AND_END: ['{0}, and {1}', '{0}, & {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_VU.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_VU = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_WS.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_WS = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_XA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_XA = {
  AND_START: ['[{0}، {1} one two]', '[{0}، {1} one two]', '{0}, {1}'],
  AND_TWO: ['[{0} åñð {1} one two]', '[{0} ⅋ {1} one two]', '{0}, {1}'],
  AND_END: ['[{0}، åñð {1} one two]', '[{0}، ⅋ {1} one two]', '{0}, {1}'],
  OR_START: ['[{0}، {1} one two]', '[{0}، {1} one two]', '[{0}، {1} one two]'],
  OR_TWO: ['[{0} öŕ {1} one two]', '[{0} öŕ {1} one two]', '[{0} öŕ {1} one two]'],
  OR_MIDDLE: ['[{0}، {1} one two]', '[{0}، {1} one two]', '[{0}، {1} one two]'],
  OR_END: ['[{0}، öŕ {1} one two]', '[{0}، öŕ {1} one two]', '[{0}، öŕ {1} one two]'],
  UNIT_START: ['[{0}، {1} one two]', '[{0}، {1} one two]', '{0} {1}'],
  UNIT_MIDDLE: ['[{0}، {1} one two]', '[{0}، {1} one two]', '{0} {1}'],
  UNIT_END: ['[{0}، {1} one two]', '[{0}، {1} one two]', '{0} {1}']
};

/**
 * List formatting symbols for locale en_ZM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_ZM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_ZW.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_ZW = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale eo.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_eo = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale eo_001.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_eo_001 = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale es_AR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_AR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_BO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_BO = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_BR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_BR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_BZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_BZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_CL.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_CL = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_CO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_CO = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_CR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_CR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_CU.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_CU = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_DO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_DO = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0} y {1}', '{0} y {1}']
};

/**
 * List formatting symbols for locale es_EA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_EA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_EC.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_EC = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_GQ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_GQ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_GT.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_GT = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_HN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_HN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_IC.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_IC = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_NI.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_NI = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_PA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_PA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_PE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_PE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_PH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_PH = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_PR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_PR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_PY.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_PY = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0} y {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_SV.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_SV = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_UY.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_UY = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_VE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_VE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale et_EE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_et_EE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ja {1}', '{0} ja {1}', '{0}, {1}'],
  OR_END: ['{0} või {1}', '{0} või {1}', '{0} või {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale eu_ES.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_eu_ES = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} eta {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0} edo {1}', '{0} edo {1}', '{0} edo {1}'],
  UNIT_END: ['{0} eta {1}', '{0} eta {1}', '{0} eta {1}']
};

/**
 * List formatting symbols for locale ewo.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ewo = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ewo_CM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ewo_CM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale fa_AF.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fa_AF = {
  AND_START: ['{0}،‏ {1}', '{0}،‏ {1}', '{0}،‏ {1}'],
  AND_TWO: ['{0} و {1}', '{0} و {1}', '{0}،‏ {1}'],
  AND_END: ['{0}، و {1}', '{0}، و {1}', '{0}،‏ {1}'],
  OR_TWO: ['{0} یا {1}', '{0} یا {1}', '{0} یا {1}'],
  OR_END: ['{0}، یا {1}', '{0}، یا {1}', '{0}، یا {1}'],
  UNIT_START: ['{0}،‏ {1}', '{0}،‏ {1}', '{0} {1}'],
  UNIT_TWO: ['{0} و {1}', '{0}،‏ {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}،‏ {1}', '{0}،‏ {1}', '{0} {1}'],
  UNIT_END: ['{0}، و {1}', '{0}، و {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fa_IR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fa_IR = {
  AND_START: ['{0}،‏ {1}', '{0}،‏ {1}', '{0}،‏ {1}'],
  AND_TWO: ['{0} و {1}', '{0} و {1}', '{0}،‏ {1}'],
  AND_END: ['{0}، و {1}', '{0}، و {1}', '{0}،‏ {1}'],
  OR_TWO: ['{0} یا {1}', '{0} یا {1}', '{0} یا {1}'],
  OR_END: ['{0}، یا {1}', '{0}، یا {1}', '{0}، یا {1}'],
  UNIT_START: ['{0}،‏ {1}', '{0}،‏ {1}', '{0} {1}'],
  UNIT_TWO: ['{0} و {1}', '{0}،‏ {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}،‏ {1}', '{0}،‏ {1}', '{0} {1}'],
  UNIT_END: ['{0}، و {1}', '{0}، و {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ff.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ff_Adlm.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Adlm = {
  AND_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0}⹁ {1}'],
  AND_TWO: ['{0} 𞤫 {1}', '{0} & {1}', '{0}⹁ {1}'],
  AND_END: ['{0}⹁ 𞤫 {1}', '{0}⹁ & {1}', '{0}⹁ {1}'],
  OR_TWO: ['{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  OR_END: ['{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  UNIT_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0} {1}'],
  UNIT_TWO: ['{0} 𞤫 {1}', '{0} 𞤫 {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} 𞤫 {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ff_Adlm_BF.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Adlm_BF = {
  AND_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0}⹁ {1}'],
  AND_TWO: ['{0} 𞤫 {1}', '{0} & {1}', '{0}⹁ {1}'],
  AND_END: ['{0}⹁ 𞤫 {1}', '{0}⹁ & {1}', '{0}⹁ {1}'],
  OR_TWO: ['{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  OR_END: ['{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  UNIT_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0} {1}'],
  UNIT_TWO: ['{0} 𞤫 {1}', '{0} 𞤫 {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} 𞤫 {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ff_Adlm_CM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Adlm_CM = {
  AND_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0}⹁ {1}'],
  AND_TWO: ['{0} 𞤫 {1}', '{0} & {1}', '{0}⹁ {1}'],
  AND_END: ['{0}⹁ 𞤫 {1}', '{0}⹁ & {1}', '{0}⹁ {1}'],
  OR_TWO: ['{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  OR_END: ['{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  UNIT_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0} {1}'],
  UNIT_TWO: ['{0} 𞤫 {1}', '{0} 𞤫 {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} 𞤫 {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ff_Adlm_GH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Adlm_GH = {
  AND_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0}⹁ {1}'],
  AND_TWO: ['{0} 𞤫 {1}', '{0} & {1}', '{0}⹁ {1}'],
  AND_END: ['{0}⹁ 𞤫 {1}', '{0}⹁ & {1}', '{0}⹁ {1}'],
  OR_TWO: ['{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  OR_END: ['{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  UNIT_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0} {1}'],
  UNIT_TWO: ['{0} 𞤫 {1}', '{0} 𞤫 {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} 𞤫 {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ff_Adlm_GM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Adlm_GM = {
  AND_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0}⹁ {1}'],
  AND_TWO: ['{0} 𞤫 {1}', '{0} & {1}', '{0}⹁ {1}'],
  AND_END: ['{0}⹁ 𞤫 {1}', '{0}⹁ & {1}', '{0}⹁ {1}'],
  OR_TWO: ['{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  OR_END: ['{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  UNIT_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0} {1}'],
  UNIT_TWO: ['{0} 𞤫 {1}', '{0} 𞤫 {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} 𞤫 {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ff_Adlm_GN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Adlm_GN = {
  AND_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0}⹁ {1}'],
  AND_TWO: ['{0} 𞤫 {1}', '{0} & {1}', '{0}⹁ {1}'],
  AND_END: ['{0}⹁ 𞤫 {1}', '{0}⹁ & {1}', '{0}⹁ {1}'],
  OR_TWO: ['{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  OR_END: ['{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  UNIT_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0} {1}'],
  UNIT_TWO: ['{0} 𞤫 {1}', '{0} 𞤫 {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} 𞤫 {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ff_Adlm_GW.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Adlm_GW = {
  AND_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0}⹁ {1}'],
  AND_TWO: ['{0} 𞤫 {1}', '{0} & {1}', '{0}⹁ {1}'],
  AND_END: ['{0}⹁ 𞤫 {1}', '{0}⹁ & {1}', '{0}⹁ {1}'],
  OR_TWO: ['{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  OR_END: ['{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  UNIT_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0} {1}'],
  UNIT_TWO: ['{0} 𞤫 {1}', '{0} 𞤫 {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} 𞤫 {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ff_Adlm_LR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Adlm_LR = {
  AND_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0}⹁ {1}'],
  AND_TWO: ['{0} 𞤫 {1}', '{0} & {1}', '{0}⹁ {1}'],
  AND_END: ['{0}⹁ 𞤫 {1}', '{0}⹁ & {1}', '{0}⹁ {1}'],
  OR_TWO: ['{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  OR_END: ['{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  UNIT_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0} {1}'],
  UNIT_TWO: ['{0} 𞤫 {1}', '{0} 𞤫 {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} 𞤫 {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ff_Adlm_MR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Adlm_MR = {
  AND_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0}⹁ {1}'],
  AND_TWO: ['{0} 𞤫 {1}', '{0} & {1}', '{0}⹁ {1}'],
  AND_END: ['{0}⹁ 𞤫 {1}', '{0}⹁ & {1}', '{0}⹁ {1}'],
  OR_TWO: ['{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  OR_END: ['{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  UNIT_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0} {1}'],
  UNIT_TWO: ['{0} 𞤫 {1}', '{0} 𞤫 {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} 𞤫 {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ff_Adlm_NE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Adlm_NE = {
  AND_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0}⹁ {1}'],
  AND_TWO: ['{0} 𞤫 {1}', '{0} & {1}', '{0}⹁ {1}'],
  AND_END: ['{0}⹁ 𞤫 {1}', '{0}⹁ & {1}', '{0}⹁ {1}'],
  OR_TWO: ['{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  OR_END: ['{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  UNIT_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0} {1}'],
  UNIT_TWO: ['{0} 𞤫 {1}', '{0} 𞤫 {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} 𞤫 {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ff_Adlm_NG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Adlm_NG = {
  AND_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0}⹁ {1}'],
  AND_TWO: ['{0} 𞤫 {1}', '{0} & {1}', '{0}⹁ {1}'],
  AND_END: ['{0}⹁ 𞤫 {1}', '{0}⹁ & {1}', '{0}⹁ {1}'],
  OR_TWO: ['{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  OR_END: ['{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  UNIT_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0} {1}'],
  UNIT_TWO: ['{0} 𞤫 {1}', '{0} 𞤫 {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} 𞤫 {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ff_Adlm_SL.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Adlm_SL = {
  AND_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0}⹁ {1}'],
  AND_TWO: ['{0} 𞤫 {1}', '{0} & {1}', '{0}⹁ {1}'],
  AND_END: ['{0}⹁ 𞤫 {1}', '{0}⹁ & {1}', '{0}⹁ {1}'],
  OR_TWO: ['{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  OR_END: ['{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  UNIT_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0} {1}'],
  UNIT_TWO: ['{0} 𞤫 {1}', '{0} 𞤫 {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} 𞤫 {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ff_Adlm_SN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Adlm_SN = {
  AND_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0}⹁ {1}'],
  AND_TWO: ['{0} 𞤫 {1}', '{0} & {1}', '{0}⹁ {1}'],
  AND_END: ['{0}⹁ 𞤫 {1}', '{0}⹁ & {1}', '{0}⹁ {1}'],
  OR_TWO: ['{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0} 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  OR_END: ['{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}', '{0}⹁ 𞤥𞤢𞥄𞤯𞤵𞤲 {1}'],
  UNIT_START: ['{0}⹁ {1}', '{0}⹁ {1}', '{0} {1}'],
  UNIT_TWO: ['{0} 𞤫 {1}', '{0} 𞤫 {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} 𞤫 {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ff_Latn.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Latn = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ff_Latn_BF.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Latn_BF = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ff_Latn_CM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Latn_CM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ff_Latn_GH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Latn_GH = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ff_Latn_GM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Latn_GM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ff_Latn_GN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Latn_GN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ff_Latn_GW.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Latn_GW = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ff_Latn_LR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Latn_LR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ff_Latn_MR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Latn_MR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ff_Latn_NE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Latn_NE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ff_Latn_NG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Latn_NG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ff_Latn_SL.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Latn_SL = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ff_Latn_SN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ff_Latn_SN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale fi_FI.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fi_FI = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ja {1}', '{0} ja {1}', '{0}, {1}'],
  OR_END: ['{0} tai {1}', '{0} tai {1}', '{0} tai {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} ja {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fil_PH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fil_PH = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} at {1}', '{0} at {1}', '{0}, {1}'],
  AND_END: ['{0}, at {1}', '{0}, at {1}', '{0}, {1}'],
  OR_TWO: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  OR_END: ['{0}, o {1}', '{0}, o {1}', '{0}, o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fo.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fo = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} og {1}', '{0} og {1}', '{0}, {1}'],
  OR_END: ['{0}, ella {1}', '{0}, ella {1}', '{0}, ella {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} og {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fo_DK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fo_DK = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} og {1}', '{0} og {1}', '{0}, {1}'],
  OR_END: ['{0}, ella {1}', '{0}, ella {1}', '{0}, ella {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} og {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fo_FO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fo_FO = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} og {1}', '{0} og {1}', '{0}, {1}'],
  OR_END: ['{0}, ella {1}', '{0}, ella {1}', '{0}, ella {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} og {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_BE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_BE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_BF.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_BF = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_BI.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_BI = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_BJ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_BJ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_BL.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_BL = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_CD.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_CD = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_CF.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_CF = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_CG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_CG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_CH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_CH = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_CI.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_CI = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_CM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_CM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_DJ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_DJ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_DZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_DZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_FR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_FR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_GA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_GA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_GF.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_GF = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_GN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_GN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_GP.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_GP = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_GQ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_GQ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_HT.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_HT = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_KM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_KM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_LU.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_LU = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_MA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_MA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_MC.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_MC = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_MF.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_MF = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_MG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_MG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_ML.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_ML = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_MQ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_MQ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_MR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_MR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_MU.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_MU = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_NC.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_NC = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_NE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_NE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_PF.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_PF = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_PM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_PM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_RE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_RE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_RW.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_RW = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_SC.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_SC = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_SN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_SN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_SY.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_SY = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_TD.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_TD = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_TG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_TG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_TN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_TN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_VU.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_VU = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_WF.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_WF = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_YT.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_YT = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fur.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fur = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale fur_IT.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fur_IT = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale fy.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fy = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} en {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_TWO: ['{0} en {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale fy_NL.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fy_NL = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} en {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_TWO: ['{0} en {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ga_GB.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ga_GB = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} agus {1}', '{0} agus {1}', '{0}, {1}'],
  OR_END: ['{0} nó {1}', '{0} nó {1}', '{0} nó {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} agus {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ga_IE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ga_IE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} agus {1}', '{0} agus {1}', '{0}, {1}'],
  OR_END: ['{0} nó {1}', '{0} nó {1}', '{0} nó {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} agus {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale gd.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_gd = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} agus {1}', '{0} ⁊ {1}', '{0}, {1}'],
  OR_END: ['{0} no {1}', '{0} no {1}', '{0} no {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} agus {1}', '{0} ’s {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale gd_GB.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_gd_GB = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} agus {1}', '{0} ⁊ {1}', '{0}, {1}'],
  OR_END: ['{0} no {1}', '{0} no {1}', '{0} no {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} agus {1}', '{0} ’s {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale gl_ES.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_gl_ES = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0} e {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_END: ['{0} e {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale gsw_CH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_gsw_CH = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} und {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale gsw_FR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_gsw_FR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} und {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale gsw_LI.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_gsw_LI = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} und {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale gu_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_gu_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} અને {1}', '{0} અને {1}', '{0}, {1}'],
  OR_END: ['{0}, અથવા {1}', '{0}, અથવા {1}', '{0}, અથવા {1}'],
  UNIT_TWO: ['{0} અને {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale guz.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_guz = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale guz_KE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_guz_KE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale gv.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_gv = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale gv_IM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_gv_IM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ha.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ha = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} da {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, da {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} ko {1}', '{0} ko {1}', '{0} ko {1}'],
  OR_END: ['{0} ko {1}', '{0} ko {1}', '{0} ko {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ha_GH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ha_GH = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} da {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, da {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} ko {1}', '{0} ko {1}', '{0} ko {1}'],
  OR_END: ['{0} ko {1}', '{0} ko {1}', '{0} ko {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ha_NE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ha_NE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} da {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, da {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} ko {1}', '{0} ko {1}', '{0} ko {1}'],
  OR_END: ['{0} ko {1}', '{0} ko {1}', '{0} ko {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ha_NG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ha_NG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} da {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, da {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} ko {1}', '{0} ko {1}', '{0} ko {1}'],
  OR_END: ['{0} ko {1}', '{0} ko {1}', '{0} ko {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale haw_US.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_haw_US = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale he_IL.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_he_IL = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ו{1}', '{0} ו{1}', '{0}, {1}'],
  OR_END: ['{0} או {1}', '{0} או {1}', '{0} או {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} ו-{1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale hi_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_hi_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} और {1}', '{0} और {1}', '{0}, {1}'],
  AND_END: ['{0}, और {1}', '{0} और {1}', '{0}, {1}'],
  OR_TWO: ['{0} या {1}', '{0} या {1}', '{0} या {1}'],
  OR_END: ['{0} या {1}', '{0} या {1}', '{0} या {1}'],
  UNIT_TWO: ['{0} और {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, और {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale hi_Latn.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_hi_Latn = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} aur {1}', '{0} aur {1}', '{0} aur {1}'],
  AND_END: ['{0}, aur {1}', '{0}, aur {1}', '{0}, {1}'],
  OR_TWO: ['{0} yaa {1}', '{0} yaa {1}', '{0} yaa {1}'],
  OR_END: ['{0} yaa {1}', '{0} yaa {1}', '{0} yaa {1}'],
  UNIT_TWO: ['{0} aur {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, aur {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale hi_Latn_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_hi_Latn_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} aur {1}', '{0} aur {1}', '{0} aur {1}'],
  AND_END: ['{0}, aur {1}', '{0}, aur {1}', '{0}, {1}'],
  OR_TWO: ['{0} yaa {1}', '{0} yaa {1}', '{0} yaa {1}'],
  OR_END: ['{0} yaa {1}', '{0} yaa {1}', '{0} yaa {1}'],
  UNIT_TWO: ['{0} aur {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, aur {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale hr_BA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_hr_BA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} i {1}', '{0} i {1}', '{0}, {1}'],
  OR_END: ['{0} ili {1}', '{0} ili {1}', '{0} ili {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} i {1}', '{0} i {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale hr_HR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_hr_HR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} i {1}', '{0} i {1}', '{0}, {1}'],
  OR_END: ['{0} ili {1}', '{0} ili {1}', '{0} ili {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} i {1}', '{0} i {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale hsb.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_hsb = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} a {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0} abo {1}', '{0} abo {1}', '{0} abo {1}'],
  UNIT_TWO: ['{0} a {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0} a {1}', '{0} a {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale hsb_DE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_hsb_DE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} a {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0} abo {1}', '{0} abo {1}', '{0} abo {1}'],
  UNIT_TWO: ['{0} a {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0} a {1}', '{0} a {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale hu_HU.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_hu_HU = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} és {1}', '{0} és {1}', '{0}, {1}'],
  OR_END: ['{0} vagy {1}', '{0} vagy {1}', '{0} vagy {1}'],
  UNIT_END: ['{0} és {1}', '{0} és {1}', '{0} és {1}']
};

/**
 * List formatting symbols for locale hy_AM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_hy_AM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} և {1}', '{0} և {1}', '{0}, {1}'],
  OR_END: ['{0} կամ {1}', '{0} կամ {1}', '{0} կամ {1}'],
  UNIT_START: ['{0}, {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} և {1}', '{0} և {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ia.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ia = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ia_001.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ia_001 = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale id_ID.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_id_ID = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} dan {1}', '{0} dan {1}', '{0}, {1}'],
  AND_END: ['{0}, dan {1}', '{0}, dan {1}', '{0}, {1}'],
  OR_TWO: ['{0} atau {1}', '{0} atau {1}', '{0} atau {1}'],
  OR_END: ['{0}, atau {1}', '{0}, atau {1}', '{0}, atau {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ig.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ig = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} na {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, na {1}', '{0}, {1}', '{0}, na {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ig_NG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ig_NG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} na {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, na {1}', '{0}, {1}', '{0}, na {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ii.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ii = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ii_CN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ii_CN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale is_IS.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_is_IS = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} og {1}', '{0} og {1}', '{0}, {1}'],
  OR_END: ['{0} eða {1}', '{0} eða {1}', '{0} eða {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} og {1}', '{0} og {1}', '{0} og {1}']
};

/**
 * List formatting symbols for locale it_CH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_it_CH = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale it_IT.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_it_IT = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale it_SM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_it_SM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale it_VA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_it_VA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ja_JP.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ja_JP = {
  AND_START: ['{0}、{1}', '{0}、{1}', '{0}, {1}'],
  AND_END: ['{0}、{1}', '{0}、{1}', '{0}, {1}'],
  OR_START: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  OR_MIDDLE: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  OR_END: ['{0}、または{1}', '{0}、または{1}', '{0}、または{1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0}{1}']
};

/**
 * List formatting symbols for locale jgo.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_jgo = {
  AND_START: ['{0}, ŋ́gɛ {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} pɔp {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, ḿbɛn ŋ́gɛ {1}', '{0}, {1}', '{0}, {1}'],
  OR_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale jgo_CM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_jgo_CM = {
  AND_START: ['{0}, ŋ́gɛ {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} pɔp {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, ḿbɛn ŋ́gɛ {1}', '{0}, {1}', '{0}, {1}'],
  OR_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale jmc.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_jmc = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale jmc_TZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_jmc_TZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale jv.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_jv = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} lan {1}', '{0} lan {1}', '{0}, {1}'],
  AND_END: ['{0}, lan {1}', '{0}, lan {1}', '{0}, {1}'],
  OR_TWO: ['{0} utowo {1}', '{0} utowo {1}', '{0} utowo {1}'],
  OR_END: ['{0}, utowo {1}', '{0}, utowo {1}', '{0}, utowo {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale jv_ID.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_jv_ID = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} lan {1}', '{0} lan {1}', '{0}, {1}'],
  AND_END: ['{0}, lan {1}', '{0}, lan {1}', '{0}, {1}'],
  OR_TWO: ['{0} utowo {1}', '{0} utowo {1}', '{0} utowo {1}'],
  OR_END: ['{0}, utowo {1}', '{0}, utowo {1}', '{0}, utowo {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ka_GE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ka_GE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} და {1}', '{0} და {1}', '{0}, {1}'],
  OR_END: ['{0} ან {1}', '{0} ან {1}', '{0} ან {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale kab.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kab = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale kab_DZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kab_DZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale kam.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kam = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale kam_KE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kam_KE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale kde.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kde = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale kde_TZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kde_TZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale kea.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kea = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} i {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_END: ['{0} i {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale kea_CV.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kea_CV = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} i {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_END: ['{0} i {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale kgp.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kgp = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} kar {1}', '{0} kar {1}', '{0}, {1}'],
  OR_END: ['{0} ketũmỹr {1}', '{0} ketũmỹr {1}', '{0} ketũmỹr {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} kar {1}', '{0} kar {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale kgp_BR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kgp_BR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} kar {1}', '{0} kar {1}', '{0}, {1}'],
  OR_END: ['{0} ketũmỹr {1}', '{0} ketũmỹr {1}', '{0} ketũmỹr {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} kar {1}', '{0} kar {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale khq.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_khq = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale khq_ML.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_khq_ML = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ki.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ki = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ki_KE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ki_KE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale kk_KZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kk_KZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} және {1}', '{0} және {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} не {1}', '{0} не {1}', '{0} не {1}'],
  OR_END: ['{0}, не болмаса {1}', '{0}, не болмаса {1}', '{0}, не болмаса {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale kkj.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kkj = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale kkj_CM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kkj_CM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale kl.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kl = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale kl_GL.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kl_GL = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale kln.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kln = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale kln_KE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kln_KE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale km_KH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_km_KH = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} និង​{1}', '{0} និង {1}', '{0}, {1}'],
  AND_END: ['{0} និង {1}', '{0} និង {1}', '{0}, {1}'],
  OR_TWO: ['{0} ឬ {1}', '{0} ឬ {1}', '{0} ឬ {1}'],
  OR_END: ['{0} ឬ {1}', '{0} ឬ {1}', '{0} ឬ {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale kn_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kn_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} ಮತ್ತು {1}', '{0} ಮತ್ತು {1}', '{0}, {1}'],
  AND_END: ['{0}, ಮತ್ತು {1}', '{0}, ಮತ್ತು {1}', '{0}, {1}'],
  OR_TWO: ['{0} ಅಥವಾ {1}', '{0} ಅಥವಾ {1}', '{0} ಅಥವಾ {1}'],
  OR_END: ['{0}, ಅಥವಾ {1}', '{0}, ಅಥವಾ {1}', '{0}, ಅಥವಾ {1}'],
  UNIT_TWO: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ko_KP.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ko_KP = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} 및 {1}', '{0} 및 {1}', '{0}, {1}'],
  OR_END: ['{0} 또는 {1}', '{0} 또는 {1}', '{0} 또는 {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ko_KR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ko_KR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} 및 {1}', '{0} 및 {1}', '{0}, {1}'],
  OR_END: ['{0} 또는 {1}', '{0} 또는 {1}', '{0} 또는 {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale kok.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kok = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0}, {1}', '{0} & {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, & {1}', '{0}, {1}'],
  OR_TWO: ['{0} वा {1}', '{0} वा {1}', '{0} वा {1}'],
  OR_END: ['{0}, वा {1}', '{0}, वा {1}', '{0}, वा {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale kok_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kok_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0}, {1}', '{0} & {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, & {1}', '{0}, {1}'],
  OR_TWO: ['{0} वा {1}', '{0} वा {1}', '{0} वा {1}'],
  OR_END: ['{0}, वा {1}', '{0}, वा {1}', '{0}, वा {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ks.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ks = {
  AND_START: ['{0}، {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} تٕہ {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}، تٕہ {1}', '{0}, {1}', '{0}, {1}'],
  OR_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ks_Arab.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ks_Arab = {
  AND_START: ['{0}، {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} تٕہ {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}، تٕہ {1}', '{0}, {1}', '{0}, {1}'],
  OR_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ks_Arab_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ks_Arab_IN = {
  AND_START: ['{0}، {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} تٕہ {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}، تٕہ {1}', '{0}, {1}', '{0}, {1}'],
  OR_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ks_Deva.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ks_Deva = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} ति {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, ति {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ks_Deva_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ks_Deva_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} ति {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, ति {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ksb.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ksb = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ksb_TZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ksb_TZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ksf.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ksf = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ksf_CM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ksf_CM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ksh.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ksh = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} un {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ksh_DE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ksh_DE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} un {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ku.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ku = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} û {1}', '{0} û {1}', '{0}, {1}'],
  OR_END: ['{0} an {1}', '{0} an {1}', '{0} an {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} û {1}', '{0} û {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ku_TR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ku_TR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} û {1}', '{0} û {1}', '{0}, {1}'],
  OR_END: ['{0} an {1}', '{0} an {1}', '{0} an {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} û {1}', '{0} û {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale kw.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kw = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale kw_GB.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kw_GB = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ky_KG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ky_KG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} жана {1}', '{0} жана {1}', '{0}, {1}'],
  OR_END: ['{0} же {1}', '{0} же {1}', '{0} же {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale lag.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_lag = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale lag_TZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_lag_TZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale lb.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_lb = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} a(n) {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale lb_LU.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_lb_LU = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} a(n) {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale lg.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_lg = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale lg_UG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_lg_UG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale lkt.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_lkt = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale lkt_US.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_lkt_US = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ln_AO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ln_AO = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ln_CD.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ln_CD = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ln_CF.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ln_CF = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ln_CG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ln_CG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale lo_LA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_lo_LA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} ແລະ {1}', '{0} ແລະ {1}', '{0} ແລະ {1}'],
  AND_END: ['{0}, {1}', '{0} ແລະ {1}', '{0}, {1}'],
  OR_TWO: ['{0} ຫຼື {1}', '{0} ຫຼື {1}', '{0} ຫຼື {1}'],
  OR_END: ['{0} ຫຼື {1}', '{0} ຫຼື {1}', '{0} ຫຼື {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale lrc.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_lrc = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale lrc_IQ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_lrc_IQ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale lrc_IR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_lrc_IR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale lt_LT.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_lt_LT = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ir {1}', '{0} ir {1}', '{0}, {1}'],
  OR_END: ['{0} ar {1}', '{0} ar {1}', '{0} ar {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} ir {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale lu.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_lu = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale lu_CD.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_lu_CD = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale luo.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_luo = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale luo_KE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_luo_KE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale luy.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_luy = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale luy_KE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_luy_KE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale lv_LV.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_lv_LV = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} un {1}', '{0} un {1}', '{0}, {1}'],
  OR_END: ['{0} vai {1}', '{0} vai {1}', '{0} vai {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} un {1}', '{0} un {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale mai.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mai = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} और {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, और {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mai_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mai_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} और {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, और {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mas.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mas = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mas_KE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mas_KE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mas_TZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mas_TZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mer.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mer = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mer_KE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mer_KE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mfe.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mfe = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mfe_MU.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mfe_MU = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mg.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mg = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mg_MG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mg_MG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mgh.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mgh = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mgh_MZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mgh_MZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mgo.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mgo = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mgo_CM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mgo_CM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mi.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mi = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mi_NZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mi_NZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mk_MK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mk_MK = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} и {1}', '{0} и {1}', '{0} и {1}'],
  OR_END: ['{0} или {1}', '{0} или {1}', '{0} или {1}'],
  UNIT_END: ['{0} и {1}', '{0} и {1}', '{0} и {1}']
};

/**
 * List formatting symbols for locale ml_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ml_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} കൂടാതെ {1}', '{0} കൂടാതെ {1}', '{0}, {1} എന്നിവ'],
  AND_END: ['{0}, {1} എന്നിവ', '{0}, {1} എന്നിവ', '{0}, {1} എന്നിവ'],
  OR_TWO: ['{0} അല്ലെങ്കിൽ {1}', '{0} അല്ലെങ്കിൽ {1}', '{0} അല്ലെങ്കിൽ {1}'],
  OR_END: ['{0}, അല്ലെങ്കിൽ {1}', '{0}, അല്ലെങ്കിൽ {1}', '{0}, അല്ലെങ്കിൽ {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} കൂടാതെ {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale mn_MN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mn_MN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, {1} зэргийн аль нэг', '{0}, {1} зэргийн аль нэг', '{0}, {1} зэргийн аль нэг'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale mni.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mni = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} অমসুং {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mni_Beng.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mni_Beng = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} অমসুং {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mni_Beng_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mni_Beng_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} অমসুং {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mr_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mr_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} आणि {1}', '{0} आणि {1}', '{0}, {1}'],
  OR_END: ['{0}, किंवा {1}', '{0}, किंवा {1}', '{0}, किंवा {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ms_BN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ms_BN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} dan {1}', '{0} dan {1}', '{0}, {1}'],
  OR_END: ['{0}, atau {1}', '{0}, atau {1}', '{0}, atau {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0} dan {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ms_ID.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ms_ID = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} dan {1}', '{0} dan {1}', '{0}, {1}'],
  OR_END: ['{0}, atau {1}', '{0}, atau {1}', '{0}, atau {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0} dan {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ms_MY.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ms_MY = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} dan {1}', '{0} dan {1}', '{0}, {1}'],
  OR_END: ['{0}, atau {1}', '{0}, atau {1}', '{0}, atau {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0} dan {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ms_SG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ms_SG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} dan {1}', '{0} dan {1}', '{0}, {1}'],
  OR_END: ['{0}, atau {1}', '{0}, atau {1}', '{0}, atau {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0} dan {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale mt_MT.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mt_MT = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} u {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, u {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_TWO: ['{0} u {1}', '{0} u {1}', '{0}, {1}'],
  UNIT_END: ['{0}, u {1}', '{0}, u {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mua.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mua = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mua_CM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mua_CM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale my_MM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_my_MM = {
  AND_START: ['{0} - {1}', '{0} - {1}', '{0} - {1}'],
  AND_END: ['{0}နှင့် {1}', '{0}နှင့် {1}', '{0}နှင့် {1}'],
  OR_END: ['{0} သို့မဟုတ် {1}', '{0} သို့မဟုတ် {1}', '{0} သို့မဟုတ် {1}'],
  UNIT_START: ['{0}- {1}', '{0}- {1}', '{0} {1}'],
  UNIT_TWO: ['{0}နှင့်{1}', '{0}နှင့် {1}', '{0}နှင့် {1}'],
  UNIT_MIDDLE: ['{0}- {1}', '{0}- {1}', '{0} {1}'],
  UNIT_END: ['{0}နှင့် {1}', '{0}နှင့် {1}', '{0}နှင့် {1}']
};

/**
 * List formatting symbols for locale mzn.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mzn = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mzn_IR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mzn_IR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale naq.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_naq = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale naq_NA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_naq_NA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale nb_NO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nb_NO = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} og {1}', '{0} og {1}', '{0}, {1}'],
  OR_END: ['{0} eller {1}', '{0} eller {1}', '{0} eller {1}'],
  UNIT_END: ['{0} og {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale nb_SJ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nb_SJ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} og {1}', '{0} og {1}', '{0}, {1}'],
  OR_END: ['{0} eller {1}', '{0} eller {1}', '{0} eller {1}'],
  UNIT_END: ['{0} og {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale nd.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nd = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale nd_ZW.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nd_ZW = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ne_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ne_IN = {
  AND_START: ['{0},{1}', '{0},{1}', '{0},{1}'],
  AND_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} र {1}', '{0} र {1}', '{0}, {1}'],
  OR_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, वा {1}', '{0}, वा {1}', '{0}, वा {1}'],
  UNIT_START: ['{0},{1}', '{0},{1}', '{0} {1}'],
  UNIT_TWO: ['{0},{1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}{1}'],
  UNIT_END: ['{0},{1}', '{0},{1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ne_NP.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ne_NP = {
  AND_START: ['{0},{1}', '{0},{1}', '{0},{1}'],
  AND_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} र {1}', '{0} र {1}', '{0}, {1}'],
  OR_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, वा {1}', '{0}, वा {1}', '{0}, वा {1}'],
  UNIT_START: ['{0},{1}', '{0},{1}', '{0} {1}'],
  UNIT_TWO: ['{0},{1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}{1}'],
  UNIT_END: ['{0},{1}', '{0},{1}', '{0} {1}']
};

/**
 * List formatting symbols for locale nl_AW.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nl_AW = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} en {1}', '{0} en {1}', '{0}, {1}'],
  OR_END: ['{0} of {1}', '{0} of {1}', '{0} of {1}'],
  UNIT_END: ['{0} en {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale nl_BE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nl_BE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} en {1}', '{0} en {1}', '{0}, {1}'],
  OR_END: ['{0} of {1}', '{0} of {1}', '{0} of {1}'],
  UNIT_END: ['{0} en {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale nl_BQ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nl_BQ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} en {1}', '{0} en {1}', '{0}, {1}'],
  OR_END: ['{0} of {1}', '{0} of {1}', '{0} of {1}'],
  UNIT_END: ['{0} en {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale nl_CW.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nl_CW = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} en {1}', '{0} en {1}', '{0}, {1}'],
  OR_END: ['{0} of {1}', '{0} of {1}', '{0} of {1}'],
  UNIT_END: ['{0} en {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale nl_NL.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nl_NL = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} en {1}', '{0} en {1}', '{0}, {1}'],
  OR_END: ['{0} of {1}', '{0} of {1}', '{0} of {1}'],
  UNIT_END: ['{0} en {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale nl_SR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nl_SR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} en {1}', '{0} en {1}', '{0}, {1}'],
  OR_END: ['{0} of {1}', '{0} of {1}', '{0} of {1}'],
  UNIT_END: ['{0} en {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale nl_SX.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nl_SX = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} en {1}', '{0} en {1}', '{0}, {1}'],
  OR_END: ['{0} of {1}', '{0} of {1}', '{0} of {1}'],
  UNIT_END: ['{0} en {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale nmg.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nmg = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale nmg_CM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nmg_CM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale nn.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nn = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} og {1}', '{0} og {1}', '{0}, {1}'],
  OR_END: ['{0} eller {1}', '{0} eller {1}', '{0} eller {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale nn_NO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nn_NO = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} og {1}', '{0} og {1}', '{0}, {1}'],
  OR_END: ['{0} eller {1}', '{0} eller {1}', '{0} eller {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale nnh.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nnh = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale nnh_CM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nnh_CM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale nus.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nus = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale nus_SS.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nus_SS = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale nyn.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nyn = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale nyn_UG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nyn_UG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale om.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_om = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale om_ET.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_om_ET = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale om_KE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_om_KE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale or_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_or_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} ଓ {1}', '{0} ଓ {1}', '{0}, {1}'],
  AND_END: ['{0}, ଓ {1}', '{0}, ଓ {1}', '{0}, {1}'],
  OR_TWO: ['{0} କିମ୍ବା {1}', '{0} କିମ୍ବା {1}', '{0} କିମ୍ବା {1}'],
  OR_END: ['{0} କିମ୍ବା {1}', '{0} କିମ୍ବା {1}', '{0} କିମ୍ବା {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale os.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_os = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ӕмӕ {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale os_GE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_os_GE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ӕмӕ {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale os_RU.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_os_RU = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ӕмӕ {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale pa_Arab.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pa_Arab = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale pa_Arab_PK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pa_Arab_PK = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale pa_Guru.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pa_Guru = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ਅਤੇ {1}', '{0} ਅਤੇ {1}', '{0}, {1}'],
  OR_END: ['{0} ਜਾਂ {1}', '{0} ਜਾਂ {1}', '{0} ਜਾਂ {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale pa_Guru_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pa_Guru_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ਅਤੇ {1}', '{0} ਅਤੇ {1}', '{0}, {1}'],
  OR_END: ['{0} ਜਾਂ {1}', '{0} ਜਾਂ {1}', '{0} ਜਾਂ {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale pcm.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pcm = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} an {1}', '{0} & {1}', '{0}, {1}'],
  AND_END: ['{0}, an {1}', '{0}, & {1}', '{0}, ọ {1}'],
  OR_TWO: ['{0} ọ {1}', '{0} ọ {1}', '{0} ọ {1}'],
  OR_END: ['{0} ọ {1}', '{0} ọ {1}', '{0} ọ {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale pcm_NG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pcm_NG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} an {1}', '{0} & {1}', '{0}, {1}'],
  AND_END: ['{0}, an {1}', '{0}, & {1}', '{0}, ọ {1}'],
  OR_TWO: ['{0} ọ {1}', '{0} ọ {1}', '{0} ọ {1}'],
  OR_END: ['{0} ọ {1}', '{0} ọ {1}', '{0} ọ {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale pl_PL.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pl_PL = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}'],
  OR_END: ['{0} lub {1}', '{0} lub {1}', '{0} lub {1}'],
  UNIT_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}']
};

/**
 * List formatting symbols for locale ps.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ps = {
  AND_START: ['{0}، {1}', '{0}, {1}', '{0}، {1}'],
  AND_TWO: ['{0} او {1}', '{0}, {1}', '{0}، {1}'],
  AND_END: ['{0}، او {1}', '{0}, {1}', '{0}، او {1}'],
  OR_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, یا {1}', '{0}, یا {1}', '{0}, یا {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} او {1}', '{0} و {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ps_AF.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ps_AF = {
  AND_START: ['{0}، {1}', '{0}, {1}', '{0}، {1}'],
  AND_TWO: ['{0} او {1}', '{0}, {1}', '{0}، {1}'],
  AND_END: ['{0}، او {1}', '{0}, {1}', '{0}، او {1}'],
  OR_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, یا {1}', '{0}, یا {1}', '{0}, یا {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} او {1}', '{0} و {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ps_PK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ps_PK = {
  AND_START: ['{0}، {1}', '{0}, {1}', '{0}، {1}'],
  AND_TWO: ['{0} او {1}', '{0}, {1}', '{0}، {1}'],
  AND_END: ['{0}، او {1}', '{0}, {1}', '{0}، او {1}'],
  OR_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, یا {1}', '{0}, یا {1}', '{0}, یا {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} او {1}', '{0} و {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale pt_AO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pt_AO = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} e {1}']
};

/**
 * List formatting symbols for locale pt_CH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pt_CH = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} e {1}']
};

/**
 * List formatting symbols for locale pt_CV.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pt_CV = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} e {1}']
};

/**
 * List formatting symbols for locale pt_GQ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pt_GQ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} e {1}']
};

/**
 * List formatting symbols for locale pt_GW.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pt_GW = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} e {1}']
};

/**
 * List formatting symbols for locale pt_LU.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pt_LU = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} e {1}']
};

/**
 * List formatting symbols for locale pt_MO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pt_MO = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} e {1}']
};

/**
 * List formatting symbols for locale pt_MZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pt_MZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} e {1}']
};

/**
 * List formatting symbols for locale pt_ST.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pt_ST = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} e {1}']
};

/**
 * List formatting symbols for locale pt_TL.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pt_TL = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} e {1}']
};

/**
 * List formatting symbols for locale qu.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_qu = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, utaq {1}', '{0}, utaq {1}', '{0}, utaq {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale qu_BO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_qu_BO = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, utaq {1}', '{0}, utaq {1}', '{0}, utaq {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale qu_EC.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_qu_EC = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, utaq {1}', '{0}, utaq {1}', '{0}, utaq {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale qu_PE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_qu_PE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, utaq {1}', '{0}, utaq {1}', '{0}, utaq {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale raj.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_raj = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale raj_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_raj_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale rm.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_rm = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0} u {1}', '{0} u {1}', '{0} u {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale rm_CH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_rm_CH = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0} u {1}', '{0} u {1}', '{0} u {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale rn.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_rn = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale rn_BI.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_rn_BI = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ro_MD.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ro_MD = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} și {1}', '{0} și {1}', '{0}, {1}'],
  OR_END: ['{0} sau {1}', '{0} sau {1}', '{0} sau {1}'],
  UNIT_TWO: ['{0} și {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ro_RO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ro_RO = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} și {1}', '{0} și {1}', '{0}, {1}'],
  OR_END: ['{0} sau {1}', '{0} sau {1}', '{0} sau {1}'],
  UNIT_TWO: ['{0} și {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale rof.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_rof = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale rof_TZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_rof_TZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ru_BY.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ru_BY = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} и {1}', '{0} и {1}', '{0}, {1}'],
  OR_END: ['{0} или {1}', '{0} или {1}', '{0} или {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ru_KG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ru_KG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} и {1}', '{0} и {1}', '{0}, {1}'],
  OR_END: ['{0} или {1}', '{0} или {1}', '{0} или {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ru_KZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ru_KZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} и {1}', '{0} и {1}', '{0}, {1}'],
  OR_END: ['{0} или {1}', '{0} или {1}', '{0} или {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ru_MD.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ru_MD = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} и {1}', '{0} и {1}', '{0}, {1}'],
  OR_END: ['{0} или {1}', '{0} или {1}', '{0} или {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ru_RU.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ru_RU = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} и {1}', '{0} и {1}', '{0}, {1}'],
  OR_END: ['{0} или {1}', '{0} или {1}', '{0} или {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ru_UA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ru_UA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} и {1}', '{0} и {1}', '{0}, {1}'],
  OR_END: ['{0} или {1}', '{0} или {1}', '{0} или {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale rw.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_rw = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale rw_RW.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_rw_RW = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale rwk.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_rwk = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale rwk_TZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_rwk_TZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale sa.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sa = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} तथा {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, तथा {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale sa_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sa_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} तथा {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, तथा {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale sah.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sah = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} уонна {1}', '{0} уонна {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0} уонна {1}', '{0} уонна {1}', '{0} уонна {1}']
};

/**
 * List formatting symbols for locale sah_RU.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sah_RU = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} уонна {1}', '{0} уонна {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0} уонна {1}', '{0} уонна {1}', '{0} уонна {1}']
};

/**
 * List formatting symbols for locale saq.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_saq = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale saq_KE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_saq_KE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale sat.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sat = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale sat_Olck.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sat_Olck = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale sat_Olck_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sat_Olck_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale sbp.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sbp = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale sbp_TZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sbp_TZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale sc.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sc = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0} e {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale sc_IT.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sc_IT = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0} e {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale sd.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sd = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} ۽ {1}', '{0} ۽ {1}', '{0}, {1}'],
  AND_END: ['{0}، ۽ {1}', '{0}، ۽ {1}', '{0}, {1}'],
  OR_TWO: ['{0} يا {1}', '{0} يا {1}', '{0} يا {1}'],
  OR_END: ['{0}, يا {1}', '{0}, يا {1}', '{0}, يا {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale sd_Arab.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sd_Arab = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} ۽ {1}', '{0} ۽ {1}', '{0}, {1}'],
  AND_END: ['{0}، ۽ {1}', '{0}، ۽ {1}', '{0}, {1}'],
  OR_TWO: ['{0} يا {1}', '{0} يا {1}', '{0} يا {1}'],
  OR_END: ['{0}, يا {1}', '{0}, يا {1}', '{0}, يا {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale sd_Arab_PK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sd_Arab_PK = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} ۽ {1}', '{0} ۽ {1}', '{0}, {1}'],
  AND_END: ['{0}، ۽ {1}', '{0}، ۽ {1}', '{0}, {1}'],
  OR_TWO: ['{0} يا {1}', '{0} يا {1}', '{0} يا {1}'],
  OR_END: ['{0}, يا {1}', '{0}, يا {1}', '{0}, يا {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale sd_Deva.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sd_Deva = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale sd_Deva_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sd_Deva_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale se.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_se = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ja {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale se_FI.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_se_FI = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ja {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale se_NO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_se_NO = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ja {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale se_SE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_se_SE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ja {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale seh.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_seh = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale seh_MZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_seh_MZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ses.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ses = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ses_ML.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ses_ML = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale sg.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sg = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale sg_CF.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sg_CF = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale shi.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_shi = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale shi_Latn.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_shi_Latn = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale shi_Latn_MA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_shi_Latn_MA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale shi_Tfng.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_shi_Tfng = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale shi_Tfng_MA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_shi_Tfng_MA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale si_LK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_si_LK = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} සහ {1}', '{0} සහ {1}', '{0}, {1}'],
  AND_END: ['{0}, සහ {1}', '{0}, සහ {1}', '{0}, {1}'],
  OR_TWO: ['{0} හෝ {1}', '{0} හෝ {1}', '{0} හෝ {1}'],
  OR_END: ['{0}, හෝ {1}', '{0}, හෝ {1}', '{0}, හෝ {1}'],
  UNIT_TWO: ['{0} සහ {1}', '{0} සහ {1}', '{0} සහ {1}'],
  UNIT_END: ['{0}, සහ {1}', '{0}, සහ {1}', '{0}, සහ {1}']
};

/**
 * List formatting symbols for locale sk_SK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sk_SK = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} a {1}', '{0} a {1}', '{0}, {1}'],
  AND_END: ['{0} a {1}', '{0} a {1}', '{0}, {1}'],
  OR_TWO: ['{0} alebo {1}', '{0} alebo {1}', '{0} alebo {1}'],
  OR_END: ['{0} alebo {1}', '{0} alebo {1}', '{0} alebo {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale sl_SI.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sl_SI = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} in {1}', '{0} in {1}', '{0}, {1}'],
  OR_END: ['{0} ali {1}', '{0} ali {1}', '{0} ali {1}'],
  UNIT_END: ['{0} in {1}', '{0} in {1}', '{0} in {1}']
};

/**
 * List formatting symbols for locale smn.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_smn = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale smn_FI.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_smn_FI = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale sn.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sn = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale sn_ZW.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sn_ZW = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale so.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_so = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} iyo {1}', '{0} & {1}', '{0}, {1}'],
  OR_END: ['{0} ama {1}', '{0} ama {1}', '{0} ama {1}'],
  UNIT_TWO: ['{0} iyo {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale so_DJ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_so_DJ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} iyo {1}', '{0} & {1}', '{0}, {1}'],
  OR_END: ['{0} ama {1}', '{0} ama {1}', '{0} ama {1}'],
  UNIT_TWO: ['{0} iyo {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale so_ET.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_so_ET = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} iyo {1}', '{0} & {1}', '{0}, {1}'],
  OR_END: ['{0} ama {1}', '{0} ama {1}', '{0} ama {1}'],
  UNIT_TWO: ['{0} iyo {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale so_KE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_so_KE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} iyo {1}', '{0} & {1}', '{0}, {1}'],
  OR_END: ['{0} ama {1}', '{0} ama {1}', '{0} ama {1}'],
  UNIT_TWO: ['{0} iyo {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale so_SO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_so_SO = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} iyo {1}', '{0} & {1}', '{0}, {1}'],
  OR_END: ['{0} ama {1}', '{0} ama {1}', '{0} ama {1}'],
  UNIT_TWO: ['{0} iyo {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale sq_AL.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sq_AL = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} dhe {1}', '{0} dhe {1}', '{0}, {1}'],
  OR_END: ['{0} ose {1}', '{0} ose {1}', '{0} ose {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} e {1}']
};

/**
 * List formatting symbols for locale sq_MK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sq_MK = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} dhe {1}', '{0} dhe {1}', '{0}, {1}'],
  OR_END: ['{0} ose {1}', '{0} ose {1}', '{0} ose {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} e {1}']
};

/**
 * List formatting symbols for locale sq_XK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sq_XK = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} dhe {1}', '{0} dhe {1}', '{0}, {1}'],
  OR_END: ['{0} ose {1}', '{0} ose {1}', '{0} ose {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} e {1}']
};

/**
 * List formatting symbols for locale sr_Cyrl.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sr_Cyrl = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} и {1}', '{0} и {1}', '{0}, {1}'],
  OR_END: ['{0} или {1}', '{0} или {1}', '{0} или {1}'],
  UNIT_END: ['{0} и {1}', '{0} и {1}', '{0} и {1}']
};

/**
 * List formatting symbols for locale sr_Cyrl_BA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sr_Cyrl_BA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} и {1}', '{0} и {1}', '{0}, {1}'],
  OR_END: ['{0} или {1}', '{0} или {1}', '{0} или {1}'],
  UNIT_END: ['{0} и {1}', '{0} и {1}', '{0} и {1}']
};

/**
 * List formatting symbols for locale sr_Cyrl_ME.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sr_Cyrl_ME = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} и {1}', '{0} и {1}', '{0}, {1}'],
  OR_END: ['{0} или {1}', '{0} или {1}', '{0} или {1}'],
  UNIT_END: ['{0} и {1}', '{0} и {1}', '{0} и {1}']
};

/**
 * List formatting symbols for locale sr_Cyrl_RS.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sr_Cyrl_RS = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} и {1}', '{0} и {1}', '{0}, {1}'],
  OR_END: ['{0} или {1}', '{0} или {1}', '{0} или {1}'],
  UNIT_END: ['{0} и {1}', '{0} и {1}', '{0} и {1}']
};

/**
 * List formatting symbols for locale sr_Cyrl_XK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sr_Cyrl_XK = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} и {1}', '{0} и {1}', '{0}, {1}'],
  OR_END: ['{0} или {1}', '{0} или {1}', '{0} или {1}'],
  UNIT_END: ['{0} и {1}', '{0} и {1}', '{0} и {1}']
};

/**
 * List formatting symbols for locale sr_Latn_BA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sr_Latn_BA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} i {1}', '{0} i {1}', '{0}, {1}'],
  OR_END: ['{0} ili {1}', '{0} ili {1}', '{0} ili {1}'],
  UNIT_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}']
};

/**
 * List formatting symbols for locale sr_Latn_ME.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sr_Latn_ME = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} i {1}', '{0} i {1}', '{0}, {1}'],
  OR_END: ['{0} ili {1}', '{0} ili {1}', '{0} ili {1}'],
  UNIT_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}']
};

/**
 * List formatting symbols for locale sr_Latn_RS.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sr_Latn_RS = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} i {1}', '{0} i {1}', '{0}, {1}'],
  OR_END: ['{0} ili {1}', '{0} ili {1}', '{0} ili {1}'],
  UNIT_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}']
};

/**
 * List formatting symbols for locale sr_Latn_XK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sr_Latn_XK = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} i {1}', '{0} i {1}', '{0}, {1}'],
  OR_END: ['{0} ili {1}', '{0} ili {1}', '{0} ili {1}'],
  UNIT_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}']
};

/**
 * List formatting symbols for locale su.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_su = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} sareng {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, sareng {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale su_Latn.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_su_Latn = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} sareng {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, sareng {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale su_Latn_ID.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_su_Latn_ID = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} sareng {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, sareng {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale sv_AX.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sv_AX = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} och {1}', '{0} och {1}', '{0}, {1}'],
  OR_END: ['{0} eller {1}', '{0} eller {1}', '{0} eller {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale sv_FI.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sv_FI = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} och {1}', '{0} och {1}', '{0}, {1}'],
  OR_END: ['{0} eller {1}', '{0} eller {1}', '{0} eller {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale sv_SE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sv_SE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} och {1}', '{0} och {1}', '{0}, {1}'],
  OR_END: ['{0} eller {1}', '{0} eller {1}', '{0} eller {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale sw_CD.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sw_CD = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} na {1}', '{0} na {1}', '{0}, {1}'],
  AND_END: ['{0} na {1}', '{0} na {1}', '{0} na {1}'],
  OR_TWO: ['{0} au {1}', '{0} au {1}', '{0} au {1}'],
  OR_END: ['{0} au {1}', '{0} au {1}', '{0} au {1}'],
  UNIT_END: ['{0} na {1}', '{0} na {1}', '{0} na {1}']
};

/**
 * List formatting symbols for locale sw_KE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sw_KE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} na {1}', '{0} na {1}', '{0}, {1}'],
  AND_END: ['{0} na {1}', '{0} na {1}', '{0} na {1}'],
  OR_TWO: ['{0} au {1}', '{0} au {1}', '{0} au {1}'],
  OR_END: ['{0} au {1}', '{0} au {1}', '{0} au {1}'],
  UNIT_END: ['{0} na {1}', '{0} na {1}', '{0} na {1}']
};

/**
 * List formatting symbols for locale sw_TZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sw_TZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} na {1}', '{0} na {1}', '{0}, {1}'],
  AND_END: ['{0} na {1}', '{0} na {1}', '{0} na {1}'],
  OR_TWO: ['{0} au {1}', '{0} au {1}', '{0} au {1}'],
  OR_END: ['{0} au {1}', '{0} au {1}', '{0} au {1}'],
  UNIT_END: ['{0} na {1}', '{0} na {1}', '{0} na {1}']
};

/**
 * List formatting symbols for locale sw_UG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sw_UG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} na {1}', '{0} na {1}', '{0}, {1}'],
  AND_END: ['{0} na {1}', '{0} na {1}', '{0} na {1}'],
  OR_TWO: ['{0} au {1}', '{0} au {1}', '{0} au {1}'],
  OR_END: ['{0} au {1}', '{0} au {1}', '{0} au {1}'],
  UNIT_END: ['{0} na {1}', '{0} na {1}', '{0} na {1}']
};

/**
 * List formatting symbols for locale ta_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ta_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} மற்றும் {1}', '{0} மற்றும் {1}', '{0} மற்றும் {1}'],
  OR_END: ['{0} அல்லது {1}', '{0} அல்லது {1}', '{0} அல்லது {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ta_LK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ta_LK = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} மற்றும் {1}', '{0} மற்றும் {1}', '{0} மற்றும் {1}'],
  OR_END: ['{0} அல்லது {1}', '{0} அல்லது {1}', '{0} அல்லது {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ta_MY.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ta_MY = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} மற்றும் {1}', '{0} மற்றும் {1}', '{0} மற்றும் {1}'],
  OR_END: ['{0} அல்லது {1}', '{0} அல்லது {1}', '{0} அல்லது {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ta_SG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ta_SG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} மற்றும் {1}', '{0} மற்றும் {1}', '{0} மற்றும் {1}'],
  OR_END: ['{0} அல்லது {1}', '{0} அல்லது {1}', '{0} அல்லது {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale te_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_te_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} మరియు {1}', '{0} మరియు {1}', '{0}, {1}'],
  OR_END: ['{0} లేదా {1}', '{0} లేదా {1}', '{0} లేదా {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale teo.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_teo = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale teo_KE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_teo_KE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale teo_UG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_teo_UG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale tg.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_tg = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale tg_TJ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_tg_TJ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale th_TH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_th_TH = {
  AND_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  AND_TWO: ['{0}และ{1}', '{0}และ{1}', '{0}และ{1}'],
  AND_END: ['{0} และ{1}', '{0} และ{1}', '{0} และ{1}'],
  OR_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} หรือ {1}', '{0} หรือ {1}', '{0} หรือ {1}'],
  OR_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0} หรือ {1}', '{0} หรือ {1}', '{0} หรือ {1}'],
  UNIT_TWO: ['{0} และ {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} และ {1}', '{0} และ {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ti.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ti = {
  AND_START: ['{0}፣ {1}', '{0}፣ {1}', '{0}, {1}'],
  AND_END: ['{0}ን {1}ን', '{0}ን {1}ን', '{0}, {1}'],
  OR_START: ['{0}፣ {1}', '{0}፣ {1}', '{0}፣ {1}'],
  OR_MIDDLE: ['{0}፣ {1}', '{0}፣ {1}', '{0}፣ {1}'],
  OR_END: ['{0} ወይ {1}', '{0} ወይ {1}', '{0} ወይ {1}'],
  UNIT_START: ['{0}፣ {1}', '{0}፣ {1}', '{0} {1}'],
  UNIT_TWO: ['{0}ን {1}ን', '{0}ን {1}ን', '{0} {1}'],
  UNIT_MIDDLE: ['{0}፣ {1}', '{0}፣ {1}', '{0} {1}'],
  UNIT_END: ['{0}ን {1}ን', '{0}፣ {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ti_ER.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ti_ER = {
  AND_START: ['{0}፣ {1}', '{0}፣ {1}', '{0}, {1}'],
  AND_END: ['{0}ን {1}ን', '{0}ን {1}ን', '{0}, {1}'],
  OR_START: ['{0}፣ {1}', '{0}፣ {1}', '{0}፣ {1}'],
  OR_MIDDLE: ['{0}፣ {1}', '{0}፣ {1}', '{0}፣ {1}'],
  OR_END: ['{0} ወይ {1}', '{0} ወይ {1}', '{0} ወይ {1}'],
  UNIT_START: ['{0}፣ {1}', '{0}፣ {1}', '{0} {1}'],
  UNIT_TWO: ['{0}ን {1}ን', '{0}ን {1}ን', '{0} {1}'],
  UNIT_MIDDLE: ['{0}፣ {1}', '{0}፣ {1}', '{0} {1}'],
  UNIT_END: ['{0}ን {1}ን', '{0}፣ {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ti_ET.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ti_ET = {
  AND_START: ['{0}፣ {1}', '{0}፣ {1}', '{0}, {1}'],
  AND_END: ['{0}ን {1}ን', '{0}ን {1}ን', '{0}, {1}'],
  OR_START: ['{0}፣ {1}', '{0}፣ {1}', '{0}፣ {1}'],
  OR_MIDDLE: ['{0}፣ {1}', '{0}፣ {1}', '{0}፣ {1}'],
  OR_END: ['{0} ወይ {1}', '{0} ወይ {1}', '{0} ወይ {1}'],
  UNIT_START: ['{0}፣ {1}', '{0}፣ {1}', '{0} {1}'],
  UNIT_TWO: ['{0}ን {1}ን', '{0}ን {1}ን', '{0} {1}'],
  UNIT_MIDDLE: ['{0}፣ {1}', '{0}፣ {1}', '{0} {1}'],
  UNIT_END: ['{0}ን {1}ን', '{0}፣ {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale tk.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_tk = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} we {1}', '{0} we {1}', '{0}, {1}'],
  OR_END: ['{0} ýa-da {1}', '{0} ýa-da {1}', '{0} ýa-da {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale tk_TM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_tk_TM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} we {1}', '{0} we {1}', '{0}, {1}'],
  OR_END: ['{0} ýa-da {1}', '{0} ýa-da {1}', '{0} ýa-da {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale to.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_to = {
  AND_START: ['{0} mo {1}', '{0} mo {1}', '{0}, {1}'],
  AND_END: ['{0} mo {1}', '{0} mo {1}', '{0}, {1}'],
  OR_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, pē {1}', '{0}, pē {1}', '{0}, pē {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} mo e {1}', '{0} mo e {1}', '{0} mo e {1}']
};

/**
 * List formatting symbols for locale to_TO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_to_TO = {
  AND_START: ['{0} mo {1}', '{0} mo {1}', '{0}, {1}'],
  AND_END: ['{0} mo {1}', '{0} mo {1}', '{0}, {1}'],
  OR_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, pē {1}', '{0}, pē {1}', '{0}, pē {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} mo e {1}', '{0} mo e {1}', '{0} mo e {1}']
};

/**
 * List formatting symbols for locale tr_CY.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_tr_CY = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ve {1}', '{0} ve {1}', '{0}, {1}'],
  OR_END: ['{0} veya {1}', '{0} veya {1}', '{0} veya {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale tr_TR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_tr_TR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ve {1}', '{0} ve {1}', '{0}, {1}'],
  OR_END: ['{0} veya {1}', '{0} veya {1}', '{0} veya {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale tt.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_tt = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} һәм {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale tt_RU.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_tt_RU = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} һәм {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale twq.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_twq = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale twq_NE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_twq_NE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale tzm.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_tzm = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale tzm_MA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_tzm_MA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ug.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ug = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} and {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, and {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ug_CN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ug_CN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} and {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, and {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale uk_UA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_uk_UA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} і {1}', '{0} і {1}', '{0}, {1}'],
  OR_END: ['{0} або {1}', '{0} або {1}', '{0} або {1}'],
  UNIT_END: ['{0} і {1}', '{0} і {1}', '{0} і {1}']
};

/**
 * List formatting symbols for locale ur_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ur_IN = {
  AND_START: ['{0}، {1}', '{0}، {1}', '{0}، {1}'],
  AND_TWO: ['{0} اور {1}', '{0} اور {1}', '{0}، {1}'],
  AND_END: ['{0}، اور {1}', '{0}، اور {1}', '{0}، {1}'],
  OR_TWO: ['{0} یا {1}', '{0} یا {1}', '{0} یا {1}'],
  OR_END: ['{0}، یا {1}', '{0}، یا {1}', '{0}، یا {1}'],
  UNIT_START: ['{0}, {1}', '{0}، {1}', '{0}، {1}'],
  UNIT_TWO: ['{0}، {1}', '{0} اور {1}', '{0} اور {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}، {1}', '{0}، {1}'],
  UNIT_END: ['{0}، اور {1}', '{0}، اور {1}', '{0}، اور {1}']
};

/**
 * List formatting symbols for locale ur_PK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ur_PK = {
  AND_START: ['{0}، {1}', '{0}، {1}', '{0}، {1}'],
  AND_TWO: ['{0} اور {1}', '{0} اور {1}', '{0}، {1}'],
  AND_END: ['{0}، اور {1}', '{0}، اور {1}', '{0}، {1}'],
  OR_TWO: ['{0} یا {1}', '{0} یا {1}', '{0} یا {1}'],
  OR_END: ['{0}، یا {1}', '{0}، یا {1}', '{0}، یا {1}'],
  UNIT_START: ['{0}, {1}', '{0}، {1}', '{0}، {1}'],
  UNIT_TWO: ['{0}، {1}', '{0} اور {1}', '{0} اور {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}، {1}', '{0}، {1}'],
  UNIT_END: ['{0}، اور {1}', '{0}، اور {1}', '{0}، اور {1}']
};

/**
 * List formatting symbols for locale uz_Arab.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_uz_Arab = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale uz_Arab_AF.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_uz_Arab_AF = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale uz_Cyrl.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_uz_Cyrl = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale uz_Cyrl_UZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_uz_Cyrl_UZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale uz_Latn.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_uz_Latn = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} va {1}', '{0} va {1}', '{0}, {1}'],
  OR_END: ['{0} yoki {1}', '{0} yoki {1}', '{0} yoki {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale uz_Latn_UZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_uz_Latn_UZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} va {1}', '{0} va {1}', '{0}, {1}'],
  OR_END: ['{0} yoki {1}', '{0} yoki {1}', '{0} yoki {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale vai.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_vai = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale vai_Latn.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_vai_Latn = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale vai_Latn_LR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_vai_Latn_LR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale vai_Vaii.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_vai_Vaii = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale vai_Vaii_LR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_vai_Vaii_LR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale vi_VN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_vi_VN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} và {1}', '{0} và {1}', '{0}, {1}'],
  OR_END: ['{0} hoặc {1}', '{0} hoặc {1}', '{0} hoặc {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale vun.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_vun = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale vun_TZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_vun_TZ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale wae.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_wae = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} und {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale wae_CH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_wae_CH = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} und {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale wo.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_wo = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale wo_SN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_wo_SN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale xh.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_xh = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale xh_ZA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_xh_ZA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale xog.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_xog = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale xog_UG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_xog_UG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale yav.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_yav = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale yav_CM.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_yav_CM = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale yi.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_yi = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} און {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale yi_001.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_yi_001 = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} און {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale yo.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_yo = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_START: ['{0} pẹ̀lú {1}', '{0} pẹ̀lú {1}', '{0} pẹ̀lú {1}'],
  OR_END: ['{0}, tabi {1}', '{0}, tabi {1}', '{0}, tabi {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale yo_BJ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_yo_BJ = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_START: ['{0} pɛ̀lú {1}', '{0} pɛ̀lú {1}', '{0} pɛ̀lú {1}'],
  OR_END: ['{0}, tabi {1}', '{0}, tabi {1}', '{0}, tabi {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale yo_NG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_yo_NG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_START: ['{0} pẹ̀lú {1}', '{0} pẹ̀lú {1}', '{0} pẹ̀lú {1}'],
  OR_END: ['{0}, tabi {1}', '{0}, tabi {1}', '{0}, tabi {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale yrl.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_yrl = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} asuí {1}', '{0} asuí {1}', '{0}, {1}'],
  OR_END: ['{0} u {1}', '{0} u {1}', '{0} u {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} asuí {1}', '{0} asuí {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale yrl_BR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_yrl_BR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} asuí {1}', '{0} asuí {1}', '{0}, {1}'],
  OR_END: ['{0} u {1}', '{0} u {1}', '{0} u {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} asuí {1}', '{0} asuí {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale yrl_CO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_yrl_CO = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} asuí {1}', '{0} asuí {1}', '{0}, {1}'],
  OR_END: ['{0} u {1}', '{0} u {1}', '{0} u {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} asuí {1}', '{0} asuí {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale yrl_VE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_yrl_VE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} asuí {1}', '{0} asuí {1}', '{0}, {1}'],
  OR_END: ['{0} u {1}', '{0} u {1}', '{0} u {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} asuí {1}', '{0} asuí {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale yue.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_yue = {
  AND_START: ['{0}、{1}', '{0}、{1}', '{0}, {1}'],
  AND_END: ['{0}同{1}', '{0}同{1}', '{0}, {1}'],
  OR_START: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  OR_MIDDLE: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  OR_END: ['{0} 或 {1}', '{0} 或 {1}', '{0} 或 {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0}{1}']
};

/**
 * List formatting symbols for locale yue_Hans.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_yue_Hans = {
  AND_START: ['{0}、{1}', '{0}、{1}', '{0}, {1}'],
  AND_END: ['{0}同{1}', '{0}同{1}', '{0}, {1}'],
  OR_START: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  OR_MIDDLE: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  OR_END: ['{0} 或 {1}', '{0} 或 {1}', '{0} 或 {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0}{1}']
};

/**
 * List formatting symbols for locale yue_Hans_CN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_yue_Hans_CN = {
  AND_START: ['{0}、{1}', '{0}、{1}', '{0}, {1}'],
  AND_END: ['{0}同{1}', '{0}同{1}', '{0}, {1}'],
  OR_START: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  OR_MIDDLE: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  OR_END: ['{0} 或 {1}', '{0} 或 {1}', '{0} 或 {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0}{1}']
};

/**
 * List formatting symbols for locale yue_Hant.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_yue_Hant = {
  AND_START: ['{0}、{1}', '{0}、{1}', '{0}, {1}'],
  AND_END: ['{0}同{1}', '{0}同{1}', '{0}, {1}'],
  OR_START: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  OR_MIDDLE: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  OR_END: ['{0} 或 {1}', '{0} 或 {1}', '{0} 或 {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0}{1}']
};

/**
 * List formatting symbols for locale yue_Hant_HK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_yue_Hant_HK = {
  AND_START: ['{0}、{1}', '{0}、{1}', '{0}, {1}'],
  AND_END: ['{0}同{1}', '{0}同{1}', '{0}, {1}'],
  OR_START: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  OR_MIDDLE: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  OR_END: ['{0} 或 {1}', '{0} 或 {1}', '{0} 或 {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0}{1}']
};

/**
 * List formatting symbols for locale zgh.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_zgh = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale zgh_MA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_zgh_MA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale zh_Hans.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_zh_Hans = {
  AND_START: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  AND_END: ['{0}和{1}', '{0}和{1}', '{0}、{1}'],
  OR_END: ['{0}或{1}', '{0}或{1}', '{0}或{1}'],
  UNIT_START: ['{0}{1}', '{0}{1}', '{0}{1}'],
  UNIT_MIDDLE: ['{0}{1}', '{0}{1}', '{0}{1}'],
  UNIT_END: ['{0}{1}', '{0}{1}', '{0}{1}']
};

/**
 * List formatting symbols for locale zh_Hans_CN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_zh_Hans_CN = {
  AND_START: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  AND_END: ['{0}和{1}', '{0}和{1}', '{0}、{1}'],
  OR_END: ['{0}或{1}', '{0}或{1}', '{0}或{1}'],
  UNIT_START: ['{0}{1}', '{0}{1}', '{0}{1}'],
  UNIT_MIDDLE: ['{0}{1}', '{0}{1}', '{0}{1}'],
  UNIT_END: ['{0}{1}', '{0}{1}', '{0}{1}']
};

/**
 * List formatting symbols for locale zh_Hans_HK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_zh_Hans_HK = {
  AND_START: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  AND_END: ['{0}和{1}', '{0}和{1}', '{0}、{1}'],
  OR_END: ['{0}或{1}', '{0}或{1}', '{0}或{1}'],
  UNIT_START: ['{0}{1}', '{0}{1}', '{0}{1}'],
  UNIT_MIDDLE: ['{0}{1}', '{0}{1}', '{0}{1}'],
  UNIT_END: ['{0}{1}', '{0}{1}', '{0}{1}']
};

/**
 * List formatting symbols for locale zh_Hans_MO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_zh_Hans_MO = {
  AND_START: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  AND_END: ['{0}和{1}', '{0}和{1}', '{0}、{1}'],
  OR_END: ['{0}或{1}', '{0}或{1}', '{0}或{1}'],
  UNIT_START: ['{0}{1}', '{0}{1}', '{0}{1}'],
  UNIT_MIDDLE: ['{0}{1}', '{0}{1}', '{0}{1}'],
  UNIT_END: ['{0}{1}', '{0}{1}', '{0}{1}']
};

/**
 * List formatting symbols for locale zh_Hans_SG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_zh_Hans_SG = {
  AND_START: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  AND_END: ['{0}和{1}', '{0}和{1}', '{0}、{1}'],
  OR_END: ['{0}或{1}', '{0}或{1}', '{0}或{1}'],
  UNIT_START: ['{0}{1}', '{0}{1}', '{0}{1}'],
  UNIT_MIDDLE: ['{0}{1}', '{0}{1}', '{0}{1}'],
  UNIT_END: ['{0}{1}', '{0}{1}', '{0}{1}']
};

/**
 * List formatting symbols for locale zh_Hant.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_zh_Hant = {
  AND_START: ['{0}、{1}', '{0}、{1}', '{0}, {1}'],
  AND_END: ['{0}和{1}', '{0}和{1}', '{0}, {1}'],
  OR_START: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  OR_MIDDLE: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  OR_END: ['{0}或{1}', '{0}或{1}', '{0}或{1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0}{1}']
};

/**
 * List formatting symbols for locale zh_Hant_HK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_zh_Hant_HK = {
  AND_START: ['{0}、{1}', '{0}、{1}', '{0}, {1}'],
  AND_END: ['{0}及{1}', '{0}及{1}', '{0}, {1}'],
  OR_START: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  OR_MIDDLE: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  OR_END: ['{0}或{1}', '{0}或{1}', '{0}或{1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0}{1}']
};

/**
 * List formatting symbols for locale zh_Hant_MO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_zh_Hant_MO = {
  AND_START: ['{0}、{1}', '{0}、{1}', '{0}, {1}'],
  AND_END: ['{0}及{1}', '{0}及{1}', '{0}, {1}'],
  OR_START: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  OR_MIDDLE: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  OR_END: ['{0}或{1}', '{0}或{1}', '{0}或{1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0}{1}']
};

/**
 * List formatting symbols for locale zh_Hant_TW.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_zh_Hant_TW = {
  AND_START: ['{0}、{1}', '{0}、{1}', '{0}, {1}'],
  AND_END: ['{0}和{1}', '{0}和{1}', '{0}, {1}'],
  OR_START: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  OR_MIDDLE: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  OR_END: ['{0}或{1}', '{0}或{1}', '{0}或{1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0}{1}']
};

/**
 * List formatting symbols for locale zu_ZA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_zu_ZA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} ne-{1}', '{0} ne-{1}', '{0}, {1}'],
  AND_END: ['{0}, ne-{1}', '{0}, ne-{1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_TWO: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * Selecting symbols by locale.
 */
switch (goog.LOCALE) {
  case 'af_NA':
  case 'af-NA':
    defaultSymbols = exports.ListFormatSymbols_af_NA;
    break;
  case 'af_ZA':
  case 'af-ZA':
    defaultSymbols = exports.ListFormatSymbols_af_ZA;
    break;
  case 'agq':
    defaultSymbols = exports.ListFormatSymbols_agq;
    break;
  case 'agq_CM':
  case 'agq-CM':
    defaultSymbols = exports.ListFormatSymbols_agq_CM;
    break;
  case 'ak':
    defaultSymbols = exports.ListFormatSymbols_ak;
    break;
  case 'ak_GH':
  case 'ak-GH':
    defaultSymbols = exports.ListFormatSymbols_ak_GH;
    break;
  case 'am_ET':
  case 'am-ET':
    defaultSymbols = exports.ListFormatSymbols_am_ET;
    break;
  case 'ar_001':
  case 'ar-001':
    defaultSymbols = exports.ListFormatSymbols_ar_001;
    break;
  case 'ar_AE':
  case 'ar-AE':
    defaultSymbols = exports.ListFormatSymbols_ar_AE;
    break;
  case 'ar_BH':
  case 'ar-BH':
    defaultSymbols = exports.ListFormatSymbols_ar_BH;
    break;
  case 'ar_DJ':
  case 'ar-DJ':
    defaultSymbols = exports.ListFormatSymbols_ar_DJ;
    break;
  case 'ar_EH':
  case 'ar-EH':
    defaultSymbols = exports.ListFormatSymbols_ar_EH;
    break;
  case 'ar_ER':
  case 'ar-ER':
    defaultSymbols = exports.ListFormatSymbols_ar_ER;
    break;
  case 'ar_IL':
  case 'ar-IL':
    defaultSymbols = exports.ListFormatSymbols_ar_IL;
    break;
  case 'ar_IQ':
  case 'ar-IQ':
    defaultSymbols = exports.ListFormatSymbols_ar_IQ;
    break;
  case 'ar_JO':
  case 'ar-JO':
    defaultSymbols = exports.ListFormatSymbols_ar_JO;
    break;
  case 'ar_KM':
  case 'ar-KM':
    defaultSymbols = exports.ListFormatSymbols_ar_KM;
    break;
  case 'ar_KW':
  case 'ar-KW':
    defaultSymbols = exports.ListFormatSymbols_ar_KW;
    break;
  case 'ar_LB':
  case 'ar-LB':
    defaultSymbols = exports.ListFormatSymbols_ar_LB;
    break;
  case 'ar_LY':
  case 'ar-LY':
    defaultSymbols = exports.ListFormatSymbols_ar_LY;
    break;
  case 'ar_MA':
  case 'ar-MA':
    defaultSymbols = exports.ListFormatSymbols_ar_MA;
    break;
  case 'ar_MR':
  case 'ar-MR':
    defaultSymbols = exports.ListFormatSymbols_ar_MR;
    break;
  case 'ar_OM':
  case 'ar-OM':
    defaultSymbols = exports.ListFormatSymbols_ar_OM;
    break;
  case 'ar_PS':
  case 'ar-PS':
    defaultSymbols = exports.ListFormatSymbols_ar_PS;
    break;
  case 'ar_QA':
  case 'ar-QA':
    defaultSymbols = exports.ListFormatSymbols_ar_QA;
    break;
  case 'ar_SA':
  case 'ar-SA':
    defaultSymbols = exports.ListFormatSymbols_ar_SA;
    break;
  case 'ar_SD':
  case 'ar-SD':
    defaultSymbols = exports.ListFormatSymbols_ar_SD;
    break;
  case 'ar_SO':
  case 'ar-SO':
    defaultSymbols = exports.ListFormatSymbols_ar_SO;
    break;
  case 'ar_SS':
  case 'ar-SS':
    defaultSymbols = exports.ListFormatSymbols_ar_SS;
    break;
  case 'ar_SY':
  case 'ar-SY':
    defaultSymbols = exports.ListFormatSymbols_ar_SY;
    break;
  case 'ar_TD':
  case 'ar-TD':
    defaultSymbols = exports.ListFormatSymbols_ar_TD;
    break;
  case 'ar_TN':
  case 'ar-TN':
    defaultSymbols = exports.ListFormatSymbols_ar_TN;
    break;
  case 'ar_XB':
  case 'ar-XB':
    defaultSymbols = exports.ListFormatSymbols_ar_XB;
    break;
  case 'ar_YE':
  case 'ar-YE':
    defaultSymbols = exports.ListFormatSymbols_ar_YE;
    break;
  case 'as':
    defaultSymbols = exports.ListFormatSymbols_as;
    break;
  case 'as_IN':
  case 'as-IN':
    defaultSymbols = exports.ListFormatSymbols_as_IN;
    break;
  case 'asa':
    defaultSymbols = exports.ListFormatSymbols_asa;
    break;
  case 'asa_TZ':
  case 'asa-TZ':
    defaultSymbols = exports.ListFormatSymbols_asa_TZ;
    break;
  case 'ast':
    defaultSymbols = exports.ListFormatSymbols_ast;
    break;
  case 'ast_ES':
  case 'ast-ES':
    defaultSymbols = exports.ListFormatSymbols_ast_ES;
    break;
  case 'az_Cyrl':
  case 'az-Cyrl':
    defaultSymbols = exports.ListFormatSymbols_az_Cyrl;
    break;
  case 'az_Cyrl_AZ':
  case 'az-Cyrl-AZ':
    defaultSymbols = exports.ListFormatSymbols_az_Cyrl_AZ;
    break;
  case 'az_Latn':
  case 'az-Latn':
    defaultSymbols = exports.ListFormatSymbols_az_Latn;
    break;
  case 'az_Latn_AZ':
  case 'az-Latn-AZ':
    defaultSymbols = exports.ListFormatSymbols_az_Latn_AZ;
    break;
  case 'bas':
    defaultSymbols = exports.ListFormatSymbols_bas;
    break;
  case 'bas_CM':
  case 'bas-CM':
    defaultSymbols = exports.ListFormatSymbols_bas_CM;
    break;
  case 'be_BY':
  case 'be-BY':
    defaultSymbols = exports.ListFormatSymbols_be_BY;
    break;
  case 'bem':
    defaultSymbols = exports.ListFormatSymbols_bem;
    break;
  case 'bem_ZM':
  case 'bem-ZM':
    defaultSymbols = exports.ListFormatSymbols_bem_ZM;
    break;
  case 'bez':
    defaultSymbols = exports.ListFormatSymbols_bez;
    break;
  case 'bez_TZ':
  case 'bez-TZ':
    defaultSymbols = exports.ListFormatSymbols_bez_TZ;
    break;
  case 'bg_BG':
  case 'bg-BG':
    defaultSymbols = exports.ListFormatSymbols_bg_BG;
    break;
  case 'bgc':
    defaultSymbols = exports.ListFormatSymbols_bgc;
    break;
  case 'bgc_IN':
  case 'bgc-IN':
    defaultSymbols = exports.ListFormatSymbols_bgc_IN;
    break;
  case 'bho':
    defaultSymbols = exports.ListFormatSymbols_bho;
    break;
  case 'bho_IN':
  case 'bho-IN':
    defaultSymbols = exports.ListFormatSymbols_bho_IN;
    break;
  case 'bm':
    defaultSymbols = exports.ListFormatSymbols_bm;
    break;
  case 'bm_ML':
  case 'bm-ML':
    defaultSymbols = exports.ListFormatSymbols_bm_ML;
    break;
  case 'bn_BD':
  case 'bn-BD':
    defaultSymbols = exports.ListFormatSymbols_bn_BD;
    break;
  case 'bn_IN':
  case 'bn-IN':
    defaultSymbols = exports.ListFormatSymbols_bn_IN;
    break;
  case 'bo':
    defaultSymbols = exports.ListFormatSymbols_bo;
    break;
  case 'bo_CN':
  case 'bo-CN':
    defaultSymbols = exports.ListFormatSymbols_bo_CN;
    break;
  case 'bo_IN':
  case 'bo-IN':
    defaultSymbols = exports.ListFormatSymbols_bo_IN;
    break;
  case 'br_FR':
  case 'br-FR':
    defaultSymbols = exports.ListFormatSymbols_br_FR;
    break;
  case 'brx':
    defaultSymbols = exports.ListFormatSymbols_brx;
    break;
  case 'brx_IN':
  case 'brx-IN':
    defaultSymbols = exports.ListFormatSymbols_brx_IN;
    break;
  case 'bs_Cyrl':
  case 'bs-Cyrl':
    defaultSymbols = exports.ListFormatSymbols_bs_Cyrl;
    break;
  case 'bs_Cyrl_BA':
  case 'bs-Cyrl-BA':
    defaultSymbols = exports.ListFormatSymbols_bs_Cyrl_BA;
    break;
  case 'bs_Latn':
  case 'bs-Latn':
    defaultSymbols = exports.ListFormatSymbols_bs_Latn;
    break;
  case 'bs_Latn_BA':
  case 'bs-Latn-BA':
    defaultSymbols = exports.ListFormatSymbols_bs_Latn_BA;
    break;
  case 'ca_AD':
  case 'ca-AD':
    defaultSymbols = exports.ListFormatSymbols_ca_AD;
    break;
  case 'ca_ES':
  case 'ca-ES':
    defaultSymbols = exports.ListFormatSymbols_ca_ES;
    break;
  case 'ca_FR':
  case 'ca-FR':
    defaultSymbols = exports.ListFormatSymbols_ca_FR;
    break;
  case 'ca_IT':
  case 'ca-IT':
    defaultSymbols = exports.ListFormatSymbols_ca_IT;
    break;
  case 'ccp':
    defaultSymbols = exports.ListFormatSymbols_ccp;
    break;
  case 'ccp_BD':
  case 'ccp-BD':
    defaultSymbols = exports.ListFormatSymbols_ccp_BD;
    break;
  case 'ccp_IN':
  case 'ccp-IN':
    defaultSymbols = exports.ListFormatSymbols_ccp_IN;
    break;
  case 'ce':
    defaultSymbols = exports.ListFormatSymbols_ce;
    break;
  case 'ce_RU':
  case 'ce-RU':
    defaultSymbols = exports.ListFormatSymbols_ce_RU;
    break;
  case 'ceb':
    defaultSymbols = exports.ListFormatSymbols_ceb;
    break;
  case 'ceb_PH':
  case 'ceb-PH':
    defaultSymbols = exports.ListFormatSymbols_ceb_PH;
    break;
  case 'cgg':
    defaultSymbols = exports.ListFormatSymbols_cgg;
    break;
  case 'cgg_UG':
  case 'cgg-UG':
    defaultSymbols = exports.ListFormatSymbols_cgg_UG;
    break;
  case 'chr_US':
  case 'chr-US':
    defaultSymbols = exports.ListFormatSymbols_chr_US;
    break;
  case 'ckb':
    defaultSymbols = exports.ListFormatSymbols_ckb;
    break;
  case 'ckb_Arab':
  case 'ckb-Arab':
    defaultSymbols = exports.ListFormatSymbols_ckb_Arab;
    break;
  case 'ckb_Arab_IQ':
  case 'ckb-Arab-IQ':
    defaultSymbols = exports.ListFormatSymbols_ckb_Arab_IQ;
    break;
  case 'ckb_Arab_IR':
  case 'ckb-Arab-IR':
    defaultSymbols = exports.ListFormatSymbols_ckb_Arab_IR;
    break;
  case 'ckb_IQ':
  case 'ckb-IQ':
    defaultSymbols = exports.ListFormatSymbols_ckb_IQ;
    break;
  case 'ckb_IR':
  case 'ckb-IR':
    defaultSymbols = exports.ListFormatSymbols_ckb_IR;
    break;
  case 'cs_CZ':
  case 'cs-CZ':
    defaultSymbols = exports.ListFormatSymbols_cs_CZ;
    break;
  case 'cv':
    defaultSymbols = exports.ListFormatSymbols_cv;
    break;
  case 'cv_RU':
  case 'cv-RU':
    defaultSymbols = exports.ListFormatSymbols_cv_RU;
    break;
  case 'cy_GB':
  case 'cy-GB':
    defaultSymbols = exports.ListFormatSymbols_cy_GB;
    break;
  case 'da_DK':
  case 'da-DK':
    defaultSymbols = exports.ListFormatSymbols_da_DK;
    break;
  case 'da_GL':
  case 'da-GL':
    defaultSymbols = exports.ListFormatSymbols_da_GL;
    break;
  case 'dav':
    defaultSymbols = exports.ListFormatSymbols_dav;
    break;
  case 'dav_KE':
  case 'dav-KE':
    defaultSymbols = exports.ListFormatSymbols_dav_KE;
    break;
  case 'de_BE':
  case 'de-BE':
    defaultSymbols = exports.ListFormatSymbols_de_BE;
    break;
  case 'de_DE':
  case 'de-DE':
    defaultSymbols = exports.ListFormatSymbols_de_DE;
    break;
  case 'de_IT':
  case 'de-IT':
    defaultSymbols = exports.ListFormatSymbols_de_IT;
    break;
  case 'de_LI':
  case 'de-LI':
    defaultSymbols = exports.ListFormatSymbols_de_LI;
    break;
  case 'de_LU':
  case 'de-LU':
    defaultSymbols = exports.ListFormatSymbols_de_LU;
    break;
  case 'dje':
    defaultSymbols = exports.ListFormatSymbols_dje;
    break;
  case 'dje_NE':
  case 'dje-NE':
    defaultSymbols = exports.ListFormatSymbols_dje_NE;
    break;
  case 'doi':
    defaultSymbols = exports.ListFormatSymbols_doi;
    break;
  case 'doi_IN':
  case 'doi-IN':
    defaultSymbols = exports.ListFormatSymbols_doi_IN;
    break;
  case 'dsb':
    defaultSymbols = exports.ListFormatSymbols_dsb;
    break;
  case 'dsb_DE':
  case 'dsb-DE':
    defaultSymbols = exports.ListFormatSymbols_dsb_DE;
    break;
  case 'dua':
    defaultSymbols = exports.ListFormatSymbols_dua;
    break;
  case 'dua_CM':
  case 'dua-CM':
    defaultSymbols = exports.ListFormatSymbols_dua_CM;
    break;
  case 'dyo':
    defaultSymbols = exports.ListFormatSymbols_dyo;
    break;
  case 'dyo_SN':
  case 'dyo-SN':
    defaultSymbols = exports.ListFormatSymbols_dyo_SN;
    break;
  case 'dz':
    defaultSymbols = exports.ListFormatSymbols_dz;
    break;
  case 'dz_BT':
  case 'dz-BT':
    defaultSymbols = exports.ListFormatSymbols_dz_BT;
    break;
  case 'ebu':
    defaultSymbols = exports.ListFormatSymbols_ebu;
    break;
  case 'ebu_KE':
  case 'ebu-KE':
    defaultSymbols = exports.ListFormatSymbols_ebu_KE;
    break;
  case 'ee':
    defaultSymbols = exports.ListFormatSymbols_ee;
    break;
  case 'ee_GH':
  case 'ee-GH':
    defaultSymbols = exports.ListFormatSymbols_ee_GH;
    break;
  case 'ee_TG':
  case 'ee-TG':
    defaultSymbols = exports.ListFormatSymbols_ee_TG;
    break;
  case 'el_CY':
  case 'el-CY':
    defaultSymbols = exports.ListFormatSymbols_el_CY;
    break;
  case 'el_GR':
  case 'el-GR':
    defaultSymbols = exports.ListFormatSymbols_el_GR;
    break;
  case 'en_001':
  case 'en-001':
    defaultSymbols = exports.ListFormatSymbols_en_001;
    break;
  case 'en_150':
  case 'en-150':
    defaultSymbols = exports.ListFormatSymbols_en_150;
    break;
  case 'en_AE':
  case 'en-AE':
    defaultSymbols = exports.ListFormatSymbols_en_AE;
    break;
  case 'en_AG':
  case 'en-AG':
    defaultSymbols = exports.ListFormatSymbols_en_AG;
    break;
  case 'en_AI':
  case 'en-AI':
    defaultSymbols = exports.ListFormatSymbols_en_AI;
    break;
  case 'en_AS':
  case 'en-AS':
    defaultSymbols = exports.ListFormatSymbols_en_AS;
    break;
  case 'en_AT':
  case 'en-AT':
    defaultSymbols = exports.ListFormatSymbols_en_AT;
    break;
  case 'en_BB':
  case 'en-BB':
    defaultSymbols = exports.ListFormatSymbols_en_BB;
    break;
  case 'en_BE':
  case 'en-BE':
    defaultSymbols = exports.ListFormatSymbols_en_BE;
    break;
  case 'en_BI':
  case 'en-BI':
    defaultSymbols = exports.ListFormatSymbols_en_BI;
    break;
  case 'en_BM':
  case 'en-BM':
    defaultSymbols = exports.ListFormatSymbols_en_BM;
    break;
  case 'en_BS':
  case 'en-BS':
    defaultSymbols = exports.ListFormatSymbols_en_BS;
    break;
  case 'en_BW':
  case 'en-BW':
    defaultSymbols = exports.ListFormatSymbols_en_BW;
    break;
  case 'en_BZ':
  case 'en-BZ':
    defaultSymbols = exports.ListFormatSymbols_en_BZ;
    break;
  case 'en_CC':
  case 'en-CC':
    defaultSymbols = exports.ListFormatSymbols_en_CC;
    break;
  case 'en_CH':
  case 'en-CH':
    defaultSymbols = exports.ListFormatSymbols_en_CH;
    break;
  case 'en_CK':
  case 'en-CK':
    defaultSymbols = exports.ListFormatSymbols_en_CK;
    break;
  case 'en_CM':
  case 'en-CM':
    defaultSymbols = exports.ListFormatSymbols_en_CM;
    break;
  case 'en_CX':
  case 'en-CX':
    defaultSymbols = exports.ListFormatSymbols_en_CX;
    break;
  case 'en_CY':
  case 'en-CY':
    defaultSymbols = exports.ListFormatSymbols_en_CY;
    break;
  case 'en_DE':
  case 'en-DE':
    defaultSymbols = exports.ListFormatSymbols_en_DE;
    break;
  case 'en_DG':
  case 'en-DG':
    defaultSymbols = exports.ListFormatSymbols_en_DG;
    break;
  case 'en_DK':
  case 'en-DK':
    defaultSymbols = exports.ListFormatSymbols_en_DK;
    break;
  case 'en_DM':
  case 'en-DM':
    defaultSymbols = exports.ListFormatSymbols_en_DM;
    break;
  case 'en_ER':
  case 'en-ER':
    defaultSymbols = exports.ListFormatSymbols_en_ER;
    break;
  case 'en_FI':
  case 'en-FI':
    defaultSymbols = exports.ListFormatSymbols_en_FI;
    break;
  case 'en_FJ':
  case 'en-FJ':
    defaultSymbols = exports.ListFormatSymbols_en_FJ;
    break;
  case 'en_FK':
  case 'en-FK':
    defaultSymbols = exports.ListFormatSymbols_en_FK;
    break;
  case 'en_FM':
  case 'en-FM':
    defaultSymbols = exports.ListFormatSymbols_en_FM;
    break;
  case 'en_GD':
  case 'en-GD':
    defaultSymbols = exports.ListFormatSymbols_en_GD;
    break;
  case 'en_GG':
  case 'en-GG':
    defaultSymbols = exports.ListFormatSymbols_en_GG;
    break;
  case 'en_GH':
  case 'en-GH':
    defaultSymbols = exports.ListFormatSymbols_en_GH;
    break;
  case 'en_GI':
  case 'en-GI':
    defaultSymbols = exports.ListFormatSymbols_en_GI;
    break;
  case 'en_GM':
  case 'en-GM':
    defaultSymbols = exports.ListFormatSymbols_en_GM;
    break;
  case 'en_GU':
  case 'en-GU':
    defaultSymbols = exports.ListFormatSymbols_en_GU;
    break;
  case 'en_GY':
  case 'en-GY':
    defaultSymbols = exports.ListFormatSymbols_en_GY;
    break;
  case 'en_HK':
  case 'en-HK':
    defaultSymbols = exports.ListFormatSymbols_en_HK;
    break;
  case 'en_IL':
  case 'en-IL':
    defaultSymbols = exports.ListFormatSymbols_en_IL;
    break;
  case 'en_IM':
  case 'en-IM':
    defaultSymbols = exports.ListFormatSymbols_en_IM;
    break;
  case 'en_IO':
  case 'en-IO':
    defaultSymbols = exports.ListFormatSymbols_en_IO;
    break;
  case 'en_JE':
  case 'en-JE':
    defaultSymbols = exports.ListFormatSymbols_en_JE;
    break;
  case 'en_JM':
  case 'en-JM':
    defaultSymbols = exports.ListFormatSymbols_en_JM;
    break;
  case 'en_KE':
  case 'en-KE':
    defaultSymbols = exports.ListFormatSymbols_en_KE;
    break;
  case 'en_KI':
  case 'en-KI':
    defaultSymbols = exports.ListFormatSymbols_en_KI;
    break;
  case 'en_KN':
  case 'en-KN':
    defaultSymbols = exports.ListFormatSymbols_en_KN;
    break;
  case 'en_KY':
  case 'en-KY':
    defaultSymbols = exports.ListFormatSymbols_en_KY;
    break;
  case 'en_LC':
  case 'en-LC':
    defaultSymbols = exports.ListFormatSymbols_en_LC;
    break;
  case 'en_LR':
  case 'en-LR':
    defaultSymbols = exports.ListFormatSymbols_en_LR;
    break;
  case 'en_LS':
  case 'en-LS':
    defaultSymbols = exports.ListFormatSymbols_en_LS;
    break;
  case 'en_MG':
  case 'en-MG':
    defaultSymbols = exports.ListFormatSymbols_en_MG;
    break;
  case 'en_MH':
  case 'en-MH':
    defaultSymbols = exports.ListFormatSymbols_en_MH;
    break;
  case 'en_MO':
  case 'en-MO':
    defaultSymbols = exports.ListFormatSymbols_en_MO;
    break;
  case 'en_MP':
  case 'en-MP':
    defaultSymbols = exports.ListFormatSymbols_en_MP;
    break;
  case 'en_MS':
  case 'en-MS':
    defaultSymbols = exports.ListFormatSymbols_en_MS;
    break;
  case 'en_MT':
  case 'en-MT':
    defaultSymbols = exports.ListFormatSymbols_en_MT;
    break;
  case 'en_MU':
  case 'en-MU':
    defaultSymbols = exports.ListFormatSymbols_en_MU;
    break;
  case 'en_MV':
  case 'en-MV':
    defaultSymbols = exports.ListFormatSymbols_en_MV;
    break;
  case 'en_MW':
  case 'en-MW':
    defaultSymbols = exports.ListFormatSymbols_en_MW;
    break;
  case 'en_MY':
  case 'en-MY':
    defaultSymbols = exports.ListFormatSymbols_en_MY;
    break;
  case 'en_NA':
  case 'en-NA':
    defaultSymbols = exports.ListFormatSymbols_en_NA;
    break;
  case 'en_NF':
  case 'en-NF':
    defaultSymbols = exports.ListFormatSymbols_en_NF;
    break;
  case 'en_NG':
  case 'en-NG':
    defaultSymbols = exports.ListFormatSymbols_en_NG;
    break;
  case 'en_NL':
  case 'en-NL':
    defaultSymbols = exports.ListFormatSymbols_en_NL;
    break;
  case 'en_NR':
  case 'en-NR':
    defaultSymbols = exports.ListFormatSymbols_en_NR;
    break;
  case 'en_NU':
  case 'en-NU':
    defaultSymbols = exports.ListFormatSymbols_en_NU;
    break;
  case 'en_NZ':
  case 'en-NZ':
    defaultSymbols = exports.ListFormatSymbols_en_NZ;
    break;
  case 'en_PG':
  case 'en-PG':
    defaultSymbols = exports.ListFormatSymbols_en_PG;
    break;
  case 'en_PH':
  case 'en-PH':
    defaultSymbols = exports.ListFormatSymbols_en_PH;
    break;
  case 'en_PK':
  case 'en-PK':
    defaultSymbols = exports.ListFormatSymbols_en_PK;
    break;
  case 'en_PN':
  case 'en-PN':
    defaultSymbols = exports.ListFormatSymbols_en_PN;
    break;
  case 'en_PR':
  case 'en-PR':
    defaultSymbols = exports.ListFormatSymbols_en_PR;
    break;
  case 'en_PW':
  case 'en-PW':
    defaultSymbols = exports.ListFormatSymbols_en_PW;
    break;
  case 'en_RW':
  case 'en-RW':
    defaultSymbols = exports.ListFormatSymbols_en_RW;
    break;
  case 'en_SB':
  case 'en-SB':
    defaultSymbols = exports.ListFormatSymbols_en_SB;
    break;
  case 'en_SC':
  case 'en-SC':
    defaultSymbols = exports.ListFormatSymbols_en_SC;
    break;
  case 'en_SD':
  case 'en-SD':
    defaultSymbols = exports.ListFormatSymbols_en_SD;
    break;
  case 'en_SE':
  case 'en-SE':
    defaultSymbols = exports.ListFormatSymbols_en_SE;
    break;
  case 'en_SH':
  case 'en-SH':
    defaultSymbols = exports.ListFormatSymbols_en_SH;
    break;
  case 'en_SI':
  case 'en-SI':
    defaultSymbols = exports.ListFormatSymbols_en_SI;
    break;
  case 'en_SL':
  case 'en-SL':
    defaultSymbols = exports.ListFormatSymbols_en_SL;
    break;
  case 'en_SS':
  case 'en-SS':
    defaultSymbols = exports.ListFormatSymbols_en_SS;
    break;
  case 'en_SX':
  case 'en-SX':
    defaultSymbols = exports.ListFormatSymbols_en_SX;
    break;
  case 'en_SZ':
  case 'en-SZ':
    defaultSymbols = exports.ListFormatSymbols_en_SZ;
    break;
  case 'en_TC':
  case 'en-TC':
    defaultSymbols = exports.ListFormatSymbols_en_TC;
    break;
  case 'en_TK':
  case 'en-TK':
    defaultSymbols = exports.ListFormatSymbols_en_TK;
    break;
  case 'en_TO':
  case 'en-TO':
    defaultSymbols = exports.ListFormatSymbols_en_TO;
    break;
  case 'en_TT':
  case 'en-TT':
    defaultSymbols = exports.ListFormatSymbols_en_TT;
    break;
  case 'en_TV':
  case 'en-TV':
    defaultSymbols = exports.ListFormatSymbols_en_TV;
    break;
  case 'en_TZ':
  case 'en-TZ':
    defaultSymbols = exports.ListFormatSymbols_en_TZ;
    break;
  case 'en_UG':
  case 'en-UG':
    defaultSymbols = exports.ListFormatSymbols_en_UG;
    break;
  case 'en_UM':
  case 'en-UM':
    defaultSymbols = exports.ListFormatSymbols_en_UM;
    break;
  case 'en_US_POSIX':
  case 'en-US-POSIX':
    defaultSymbols = exports.ListFormatSymbols_en_US_POSIX;
    break;
  case 'en_VC':
  case 'en-VC':
    defaultSymbols = exports.ListFormatSymbols_en_VC;
    break;
  case 'en_VG':
  case 'en-VG':
    defaultSymbols = exports.ListFormatSymbols_en_VG;
    break;
  case 'en_VI':
  case 'en-VI':
    defaultSymbols = exports.ListFormatSymbols_en_VI;
    break;
  case 'en_VU':
  case 'en-VU':
    defaultSymbols = exports.ListFormatSymbols_en_VU;
    break;
  case 'en_WS':
  case 'en-WS':
    defaultSymbols = exports.ListFormatSymbols_en_WS;
    break;
  case 'en_XA':
  case 'en-XA':
    defaultSymbols = exports.ListFormatSymbols_en_XA;
    break;
  case 'en_ZM':
  case 'en-ZM':
    defaultSymbols = exports.ListFormatSymbols_en_ZM;
    break;
  case 'en_ZW':
  case 'en-ZW':
    defaultSymbols = exports.ListFormatSymbols_en_ZW;
    break;
  case 'eo':
    defaultSymbols = exports.ListFormatSymbols_eo;
    break;
  case 'eo_001':
  case 'eo-001':
    defaultSymbols = exports.ListFormatSymbols_eo_001;
    break;
  case 'es_AR':
  case 'es-AR':
    defaultSymbols = exports.ListFormatSymbols_es_AR;
    break;
  case 'es_BO':
  case 'es-BO':
    defaultSymbols = exports.ListFormatSymbols_es_BO;
    break;
  case 'es_BR':
  case 'es-BR':
    defaultSymbols = exports.ListFormatSymbols_es_BR;
    break;
  case 'es_BZ':
  case 'es-BZ':
    defaultSymbols = exports.ListFormatSymbols_es_BZ;
    break;
  case 'es_CL':
  case 'es-CL':
    defaultSymbols = exports.ListFormatSymbols_es_CL;
    break;
  case 'es_CO':
  case 'es-CO':
    defaultSymbols = exports.ListFormatSymbols_es_CO;
    break;
  case 'es_CR':
  case 'es-CR':
    defaultSymbols = exports.ListFormatSymbols_es_CR;
    break;
  case 'es_CU':
  case 'es-CU':
    defaultSymbols = exports.ListFormatSymbols_es_CU;
    break;
  case 'es_DO':
  case 'es-DO':
    defaultSymbols = exports.ListFormatSymbols_es_DO;
    break;
  case 'es_EA':
  case 'es-EA':
    defaultSymbols = exports.ListFormatSymbols_es_EA;
    break;
  case 'es_EC':
  case 'es-EC':
    defaultSymbols = exports.ListFormatSymbols_es_EC;
    break;
  case 'es_GQ':
  case 'es-GQ':
    defaultSymbols = exports.ListFormatSymbols_es_GQ;
    break;
  case 'es_GT':
  case 'es-GT':
    defaultSymbols = exports.ListFormatSymbols_es_GT;
    break;
  case 'es_HN':
  case 'es-HN':
    defaultSymbols = exports.ListFormatSymbols_es_HN;
    break;
  case 'es_IC':
  case 'es-IC':
    defaultSymbols = exports.ListFormatSymbols_es_IC;
    break;
  case 'es_NI':
  case 'es-NI':
    defaultSymbols = exports.ListFormatSymbols_es_NI;
    break;
  case 'es_PA':
  case 'es-PA':
    defaultSymbols = exports.ListFormatSymbols_es_PA;
    break;
  case 'es_PE':
  case 'es-PE':
    defaultSymbols = exports.ListFormatSymbols_es_PE;
    break;
  case 'es_PH':
  case 'es-PH':
    defaultSymbols = exports.ListFormatSymbols_es_PH;
    break;
  case 'es_PR':
  case 'es-PR':
    defaultSymbols = exports.ListFormatSymbols_es_PR;
    break;
  case 'es_PY':
  case 'es-PY':
    defaultSymbols = exports.ListFormatSymbols_es_PY;
    break;
  case 'es_SV':
  case 'es-SV':
    defaultSymbols = exports.ListFormatSymbols_es_SV;
    break;
  case 'es_UY':
  case 'es-UY':
    defaultSymbols = exports.ListFormatSymbols_es_UY;
    break;
  case 'es_VE':
  case 'es-VE':
    defaultSymbols = exports.ListFormatSymbols_es_VE;
    break;
  case 'et_EE':
  case 'et-EE':
    defaultSymbols = exports.ListFormatSymbols_et_EE;
    break;
  case 'eu_ES':
  case 'eu-ES':
    defaultSymbols = exports.ListFormatSymbols_eu_ES;
    break;
  case 'ewo':
    defaultSymbols = exports.ListFormatSymbols_ewo;
    break;
  case 'ewo_CM':
  case 'ewo-CM':
    defaultSymbols = exports.ListFormatSymbols_ewo_CM;
    break;
  case 'fa_AF':
  case 'fa-AF':
    defaultSymbols = exports.ListFormatSymbols_fa_AF;
    break;
  case 'fa_IR':
  case 'fa-IR':
    defaultSymbols = exports.ListFormatSymbols_fa_IR;
    break;
  case 'ff':
    defaultSymbols = exports.ListFormatSymbols_ff;
    break;
  case 'ff_Adlm':
  case 'ff-Adlm':
    defaultSymbols = exports.ListFormatSymbols_ff_Adlm;
    break;
  case 'ff_Adlm_BF':
  case 'ff-Adlm-BF':
    defaultSymbols = exports.ListFormatSymbols_ff_Adlm_BF;
    break;
  case 'ff_Adlm_CM':
  case 'ff-Adlm-CM':
    defaultSymbols = exports.ListFormatSymbols_ff_Adlm_CM;
    break;
  case 'ff_Adlm_GH':
  case 'ff-Adlm-GH':
    defaultSymbols = exports.ListFormatSymbols_ff_Adlm_GH;
    break;
  case 'ff_Adlm_GM':
  case 'ff-Adlm-GM':
    defaultSymbols = exports.ListFormatSymbols_ff_Adlm_GM;
    break;
  case 'ff_Adlm_GN':
  case 'ff-Adlm-GN':
    defaultSymbols = exports.ListFormatSymbols_ff_Adlm_GN;
    break;
  case 'ff_Adlm_GW':
  case 'ff-Adlm-GW':
    defaultSymbols = exports.ListFormatSymbols_ff_Adlm_GW;
    break;
  case 'ff_Adlm_LR':
  case 'ff-Adlm-LR':
    defaultSymbols = exports.ListFormatSymbols_ff_Adlm_LR;
    break;
  case 'ff_Adlm_MR':
  case 'ff-Adlm-MR':
    defaultSymbols = exports.ListFormatSymbols_ff_Adlm_MR;
    break;
  case 'ff_Adlm_NE':
  case 'ff-Adlm-NE':
    defaultSymbols = exports.ListFormatSymbols_ff_Adlm_NE;
    break;
  case 'ff_Adlm_NG':
  case 'ff-Adlm-NG':
    defaultSymbols = exports.ListFormatSymbols_ff_Adlm_NG;
    break;
  case 'ff_Adlm_SL':
  case 'ff-Adlm-SL':
    defaultSymbols = exports.ListFormatSymbols_ff_Adlm_SL;
    break;
  case 'ff_Adlm_SN':
  case 'ff-Adlm-SN':
    defaultSymbols = exports.ListFormatSymbols_ff_Adlm_SN;
    break;
  case 'ff_Latn':
  case 'ff-Latn':
    defaultSymbols = exports.ListFormatSymbols_ff_Latn;
    break;
  case 'ff_Latn_BF':
  case 'ff-Latn-BF':
    defaultSymbols = exports.ListFormatSymbols_ff_Latn_BF;
    break;
  case 'ff_Latn_CM':
  case 'ff-Latn-CM':
    defaultSymbols = exports.ListFormatSymbols_ff_Latn_CM;
    break;
  case 'ff_Latn_GH':
  case 'ff-Latn-GH':
    defaultSymbols = exports.ListFormatSymbols_ff_Latn_GH;
    break;
  case 'ff_Latn_GM':
  case 'ff-Latn-GM':
    defaultSymbols = exports.ListFormatSymbols_ff_Latn_GM;
    break;
  case 'ff_Latn_GN':
  case 'ff-Latn-GN':
    defaultSymbols = exports.ListFormatSymbols_ff_Latn_GN;
    break;
  case 'ff_Latn_GW':
  case 'ff-Latn-GW':
    defaultSymbols = exports.ListFormatSymbols_ff_Latn_GW;
    break;
  case 'ff_Latn_LR':
  case 'ff-Latn-LR':
    defaultSymbols = exports.ListFormatSymbols_ff_Latn_LR;
    break;
  case 'ff_Latn_MR':
  case 'ff-Latn-MR':
    defaultSymbols = exports.ListFormatSymbols_ff_Latn_MR;
    break;
  case 'ff_Latn_NE':
  case 'ff-Latn-NE':
    defaultSymbols = exports.ListFormatSymbols_ff_Latn_NE;
    break;
  case 'ff_Latn_NG':
  case 'ff-Latn-NG':
    defaultSymbols = exports.ListFormatSymbols_ff_Latn_NG;
    break;
  case 'ff_Latn_SL':
  case 'ff-Latn-SL':
    defaultSymbols = exports.ListFormatSymbols_ff_Latn_SL;
    break;
  case 'ff_Latn_SN':
  case 'ff-Latn-SN':
    defaultSymbols = exports.ListFormatSymbols_ff_Latn_SN;
    break;
  case 'fi_FI':
  case 'fi-FI':
    defaultSymbols = exports.ListFormatSymbols_fi_FI;
    break;
  case 'fil_PH':
  case 'fil-PH':
    defaultSymbols = exports.ListFormatSymbols_fil_PH;
    break;
  case 'fo':
    defaultSymbols = exports.ListFormatSymbols_fo;
    break;
  case 'fo_DK':
  case 'fo-DK':
    defaultSymbols = exports.ListFormatSymbols_fo_DK;
    break;
  case 'fo_FO':
  case 'fo-FO':
    defaultSymbols = exports.ListFormatSymbols_fo_FO;
    break;
  case 'fr_BE':
  case 'fr-BE':
    defaultSymbols = exports.ListFormatSymbols_fr_BE;
    break;
  case 'fr_BF':
  case 'fr-BF':
    defaultSymbols = exports.ListFormatSymbols_fr_BF;
    break;
  case 'fr_BI':
  case 'fr-BI':
    defaultSymbols = exports.ListFormatSymbols_fr_BI;
    break;
  case 'fr_BJ':
  case 'fr-BJ':
    defaultSymbols = exports.ListFormatSymbols_fr_BJ;
    break;
  case 'fr_BL':
  case 'fr-BL':
    defaultSymbols = exports.ListFormatSymbols_fr_BL;
    break;
  case 'fr_CD':
  case 'fr-CD':
    defaultSymbols = exports.ListFormatSymbols_fr_CD;
    break;
  case 'fr_CF':
  case 'fr-CF':
    defaultSymbols = exports.ListFormatSymbols_fr_CF;
    break;
  case 'fr_CG':
  case 'fr-CG':
    defaultSymbols = exports.ListFormatSymbols_fr_CG;
    break;
  case 'fr_CH':
  case 'fr-CH':
    defaultSymbols = exports.ListFormatSymbols_fr_CH;
    break;
  case 'fr_CI':
  case 'fr-CI':
    defaultSymbols = exports.ListFormatSymbols_fr_CI;
    break;
  case 'fr_CM':
  case 'fr-CM':
    defaultSymbols = exports.ListFormatSymbols_fr_CM;
    break;
  case 'fr_DJ':
  case 'fr-DJ':
    defaultSymbols = exports.ListFormatSymbols_fr_DJ;
    break;
  case 'fr_DZ':
  case 'fr-DZ':
    defaultSymbols = exports.ListFormatSymbols_fr_DZ;
    break;
  case 'fr_FR':
  case 'fr-FR':
    defaultSymbols = exports.ListFormatSymbols_fr_FR;
    break;
  case 'fr_GA':
  case 'fr-GA':
    defaultSymbols = exports.ListFormatSymbols_fr_GA;
    break;
  case 'fr_GF':
  case 'fr-GF':
    defaultSymbols = exports.ListFormatSymbols_fr_GF;
    break;
  case 'fr_GN':
  case 'fr-GN':
    defaultSymbols = exports.ListFormatSymbols_fr_GN;
    break;
  case 'fr_GP':
  case 'fr-GP':
    defaultSymbols = exports.ListFormatSymbols_fr_GP;
    break;
  case 'fr_GQ':
  case 'fr-GQ':
    defaultSymbols = exports.ListFormatSymbols_fr_GQ;
    break;
  case 'fr_HT':
  case 'fr-HT':
    defaultSymbols = exports.ListFormatSymbols_fr_HT;
    break;
  case 'fr_KM':
  case 'fr-KM':
    defaultSymbols = exports.ListFormatSymbols_fr_KM;
    break;
  case 'fr_LU':
  case 'fr-LU':
    defaultSymbols = exports.ListFormatSymbols_fr_LU;
    break;
  case 'fr_MA':
  case 'fr-MA':
    defaultSymbols = exports.ListFormatSymbols_fr_MA;
    break;
  case 'fr_MC':
  case 'fr-MC':
    defaultSymbols = exports.ListFormatSymbols_fr_MC;
    break;
  case 'fr_MF':
  case 'fr-MF':
    defaultSymbols = exports.ListFormatSymbols_fr_MF;
    break;
  case 'fr_MG':
  case 'fr-MG':
    defaultSymbols = exports.ListFormatSymbols_fr_MG;
    break;
  case 'fr_ML':
  case 'fr-ML':
    defaultSymbols = exports.ListFormatSymbols_fr_ML;
    break;
  case 'fr_MQ':
  case 'fr-MQ':
    defaultSymbols = exports.ListFormatSymbols_fr_MQ;
    break;
  case 'fr_MR':
  case 'fr-MR':
    defaultSymbols = exports.ListFormatSymbols_fr_MR;
    break;
  case 'fr_MU':
  case 'fr-MU':
    defaultSymbols = exports.ListFormatSymbols_fr_MU;
    break;
  case 'fr_NC':
  case 'fr-NC':
    defaultSymbols = exports.ListFormatSymbols_fr_NC;
    break;
  case 'fr_NE':
  case 'fr-NE':
    defaultSymbols = exports.ListFormatSymbols_fr_NE;
    break;
  case 'fr_PF':
  case 'fr-PF':
    defaultSymbols = exports.ListFormatSymbols_fr_PF;
    break;
  case 'fr_PM':
  case 'fr-PM':
    defaultSymbols = exports.ListFormatSymbols_fr_PM;
    break;
  case 'fr_RE':
  case 'fr-RE':
    defaultSymbols = exports.ListFormatSymbols_fr_RE;
    break;
  case 'fr_RW':
  case 'fr-RW':
    defaultSymbols = exports.ListFormatSymbols_fr_RW;
    break;
  case 'fr_SC':
  case 'fr-SC':
    defaultSymbols = exports.ListFormatSymbols_fr_SC;
    break;
  case 'fr_SN':
  case 'fr-SN':
    defaultSymbols = exports.ListFormatSymbols_fr_SN;
    break;
  case 'fr_SY':
  case 'fr-SY':
    defaultSymbols = exports.ListFormatSymbols_fr_SY;
    break;
  case 'fr_TD':
  case 'fr-TD':
    defaultSymbols = exports.ListFormatSymbols_fr_TD;
    break;
  case 'fr_TG':
  case 'fr-TG':
    defaultSymbols = exports.ListFormatSymbols_fr_TG;
    break;
  case 'fr_TN':
  case 'fr-TN':
    defaultSymbols = exports.ListFormatSymbols_fr_TN;
    break;
  case 'fr_VU':
  case 'fr-VU':
    defaultSymbols = exports.ListFormatSymbols_fr_VU;
    break;
  case 'fr_WF':
  case 'fr-WF':
    defaultSymbols = exports.ListFormatSymbols_fr_WF;
    break;
  case 'fr_YT':
  case 'fr-YT':
    defaultSymbols = exports.ListFormatSymbols_fr_YT;
    break;
  case 'fur':
    defaultSymbols = exports.ListFormatSymbols_fur;
    break;
  case 'fur_IT':
  case 'fur-IT':
    defaultSymbols = exports.ListFormatSymbols_fur_IT;
    break;
  case 'fy':
    defaultSymbols = exports.ListFormatSymbols_fy;
    break;
  case 'fy_NL':
  case 'fy-NL':
    defaultSymbols = exports.ListFormatSymbols_fy_NL;
    break;
  case 'ga_GB':
  case 'ga-GB':
    defaultSymbols = exports.ListFormatSymbols_ga_GB;
    break;
  case 'ga_IE':
  case 'ga-IE':
    defaultSymbols = exports.ListFormatSymbols_ga_IE;
    break;
  case 'gd':
    defaultSymbols = exports.ListFormatSymbols_gd;
    break;
  case 'gd_GB':
  case 'gd-GB':
    defaultSymbols = exports.ListFormatSymbols_gd_GB;
    break;
  case 'gl_ES':
  case 'gl-ES':
    defaultSymbols = exports.ListFormatSymbols_gl_ES;
    break;
  case 'gsw_CH':
  case 'gsw-CH':
    defaultSymbols = exports.ListFormatSymbols_gsw_CH;
    break;
  case 'gsw_FR':
  case 'gsw-FR':
    defaultSymbols = exports.ListFormatSymbols_gsw_FR;
    break;
  case 'gsw_LI':
  case 'gsw-LI':
    defaultSymbols = exports.ListFormatSymbols_gsw_LI;
    break;
  case 'gu_IN':
  case 'gu-IN':
    defaultSymbols = exports.ListFormatSymbols_gu_IN;
    break;
  case 'guz':
    defaultSymbols = exports.ListFormatSymbols_guz;
    break;
  case 'guz_KE':
  case 'guz-KE':
    defaultSymbols = exports.ListFormatSymbols_guz_KE;
    break;
  case 'gv':
    defaultSymbols = exports.ListFormatSymbols_gv;
    break;
  case 'gv_IM':
  case 'gv-IM':
    defaultSymbols = exports.ListFormatSymbols_gv_IM;
    break;
  case 'ha':
    defaultSymbols = exports.ListFormatSymbols_ha;
    break;
  case 'ha_GH':
  case 'ha-GH':
    defaultSymbols = exports.ListFormatSymbols_ha_GH;
    break;
  case 'ha_NE':
  case 'ha-NE':
    defaultSymbols = exports.ListFormatSymbols_ha_NE;
    break;
  case 'ha_NG':
  case 'ha-NG':
    defaultSymbols = exports.ListFormatSymbols_ha_NG;
    break;
  case 'haw_US':
  case 'haw-US':
    defaultSymbols = exports.ListFormatSymbols_haw_US;
    break;
  case 'he_IL':
  case 'he-IL':
    defaultSymbols = exports.ListFormatSymbols_he_IL;
    break;
  case 'hi_IN':
  case 'hi-IN':
    defaultSymbols = exports.ListFormatSymbols_hi_IN;
    break;
  case 'hi_Latn':
  case 'hi-Latn':
    defaultSymbols = exports.ListFormatSymbols_hi_Latn;
    break;
  case 'hi_Latn_IN':
  case 'hi-Latn-IN':
    defaultSymbols = exports.ListFormatSymbols_hi_Latn_IN;
    break;
  case 'hr_BA':
  case 'hr-BA':
    defaultSymbols = exports.ListFormatSymbols_hr_BA;
    break;
  case 'hr_HR':
  case 'hr-HR':
    defaultSymbols = exports.ListFormatSymbols_hr_HR;
    break;
  case 'hsb':
    defaultSymbols = exports.ListFormatSymbols_hsb;
    break;
  case 'hsb_DE':
  case 'hsb-DE':
    defaultSymbols = exports.ListFormatSymbols_hsb_DE;
    break;
  case 'hu_HU':
  case 'hu-HU':
    defaultSymbols = exports.ListFormatSymbols_hu_HU;
    break;
  case 'hy_AM':
  case 'hy-AM':
    defaultSymbols = exports.ListFormatSymbols_hy_AM;
    break;
  case 'ia':
    defaultSymbols = exports.ListFormatSymbols_ia;
    break;
  case 'ia_001':
  case 'ia-001':
    defaultSymbols = exports.ListFormatSymbols_ia_001;
    break;
  case 'id_ID':
  case 'id-ID':
    defaultSymbols = exports.ListFormatSymbols_id_ID;
    break;
  case 'ig':
    defaultSymbols = exports.ListFormatSymbols_ig;
    break;
  case 'ig_NG':
  case 'ig-NG':
    defaultSymbols = exports.ListFormatSymbols_ig_NG;
    break;
  case 'ii':
    defaultSymbols = exports.ListFormatSymbols_ii;
    break;
  case 'ii_CN':
  case 'ii-CN':
    defaultSymbols = exports.ListFormatSymbols_ii_CN;
    break;
  case 'is_IS':
  case 'is-IS':
    defaultSymbols = exports.ListFormatSymbols_is_IS;
    break;
  case 'it_CH':
  case 'it-CH':
    defaultSymbols = exports.ListFormatSymbols_it_CH;
    break;
  case 'it_IT':
  case 'it-IT':
    defaultSymbols = exports.ListFormatSymbols_it_IT;
    break;
  case 'it_SM':
  case 'it-SM':
    defaultSymbols = exports.ListFormatSymbols_it_SM;
    break;
  case 'it_VA':
  case 'it-VA':
    defaultSymbols = exports.ListFormatSymbols_it_VA;
    break;
  case 'ja_JP':
  case 'ja-JP':
    defaultSymbols = exports.ListFormatSymbols_ja_JP;
    break;
  case 'jgo':
    defaultSymbols = exports.ListFormatSymbols_jgo;
    break;
  case 'jgo_CM':
  case 'jgo-CM':
    defaultSymbols = exports.ListFormatSymbols_jgo_CM;
    break;
  case 'jmc':
    defaultSymbols = exports.ListFormatSymbols_jmc;
    break;
  case 'jmc_TZ':
  case 'jmc-TZ':
    defaultSymbols = exports.ListFormatSymbols_jmc_TZ;
    break;
  case 'jv':
    defaultSymbols = exports.ListFormatSymbols_jv;
    break;
  case 'jv_ID':
  case 'jv-ID':
    defaultSymbols = exports.ListFormatSymbols_jv_ID;
    break;
  case 'ka_GE':
  case 'ka-GE':
    defaultSymbols = exports.ListFormatSymbols_ka_GE;
    break;
  case 'kab':
    defaultSymbols = exports.ListFormatSymbols_kab;
    break;
  case 'kab_DZ':
  case 'kab-DZ':
    defaultSymbols = exports.ListFormatSymbols_kab_DZ;
    break;
  case 'kam':
    defaultSymbols = exports.ListFormatSymbols_kam;
    break;
  case 'kam_KE':
  case 'kam-KE':
    defaultSymbols = exports.ListFormatSymbols_kam_KE;
    break;
  case 'kde':
    defaultSymbols = exports.ListFormatSymbols_kde;
    break;
  case 'kde_TZ':
  case 'kde-TZ':
    defaultSymbols = exports.ListFormatSymbols_kde_TZ;
    break;
  case 'kea':
    defaultSymbols = exports.ListFormatSymbols_kea;
    break;
  case 'kea_CV':
  case 'kea-CV':
    defaultSymbols = exports.ListFormatSymbols_kea_CV;
    break;
  case 'kgp':
    defaultSymbols = exports.ListFormatSymbols_kgp;
    break;
  case 'kgp_BR':
  case 'kgp-BR':
    defaultSymbols = exports.ListFormatSymbols_kgp_BR;
    break;
  case 'khq':
    defaultSymbols = exports.ListFormatSymbols_khq;
    break;
  case 'khq_ML':
  case 'khq-ML':
    defaultSymbols = exports.ListFormatSymbols_khq_ML;
    break;
  case 'ki':
    defaultSymbols = exports.ListFormatSymbols_ki;
    break;
  case 'ki_KE':
  case 'ki-KE':
    defaultSymbols = exports.ListFormatSymbols_ki_KE;
    break;
  case 'kk_KZ':
  case 'kk-KZ':
    defaultSymbols = exports.ListFormatSymbols_kk_KZ;
    break;
  case 'kkj':
    defaultSymbols = exports.ListFormatSymbols_kkj;
    break;
  case 'kkj_CM':
  case 'kkj-CM':
    defaultSymbols = exports.ListFormatSymbols_kkj_CM;
    break;
  case 'kl':
    defaultSymbols = exports.ListFormatSymbols_kl;
    break;
  case 'kl_GL':
  case 'kl-GL':
    defaultSymbols = exports.ListFormatSymbols_kl_GL;
    break;
  case 'kln':
    defaultSymbols = exports.ListFormatSymbols_kln;
    break;
  case 'kln_KE':
  case 'kln-KE':
    defaultSymbols = exports.ListFormatSymbols_kln_KE;
    break;
  case 'km_KH':
  case 'km-KH':
    defaultSymbols = exports.ListFormatSymbols_km_KH;
    break;
  case 'kn_IN':
  case 'kn-IN':
    defaultSymbols = exports.ListFormatSymbols_kn_IN;
    break;
  case 'ko_KP':
  case 'ko-KP':
    defaultSymbols = exports.ListFormatSymbols_ko_KP;
    break;
  case 'ko_KR':
  case 'ko-KR':
    defaultSymbols = exports.ListFormatSymbols_ko_KR;
    break;
  case 'kok':
    defaultSymbols = exports.ListFormatSymbols_kok;
    break;
  case 'kok_IN':
  case 'kok-IN':
    defaultSymbols = exports.ListFormatSymbols_kok_IN;
    break;
  case 'ks':
    defaultSymbols = exports.ListFormatSymbols_ks;
    break;
  case 'ks_Arab':
  case 'ks-Arab':
    defaultSymbols = exports.ListFormatSymbols_ks_Arab;
    break;
  case 'ks_Arab_IN':
  case 'ks-Arab-IN':
    defaultSymbols = exports.ListFormatSymbols_ks_Arab_IN;
    break;
  case 'ks_Deva':
  case 'ks-Deva':
    defaultSymbols = exports.ListFormatSymbols_ks_Deva;
    break;
  case 'ks_Deva_IN':
  case 'ks-Deva-IN':
    defaultSymbols = exports.ListFormatSymbols_ks_Deva_IN;
    break;
  case 'ksb':
    defaultSymbols = exports.ListFormatSymbols_ksb;
    break;
  case 'ksb_TZ':
  case 'ksb-TZ':
    defaultSymbols = exports.ListFormatSymbols_ksb_TZ;
    break;
  case 'ksf':
    defaultSymbols = exports.ListFormatSymbols_ksf;
    break;
  case 'ksf_CM':
  case 'ksf-CM':
    defaultSymbols = exports.ListFormatSymbols_ksf_CM;
    break;
  case 'ksh':
    defaultSymbols = exports.ListFormatSymbols_ksh;
    break;
  case 'ksh_DE':
  case 'ksh-DE':
    defaultSymbols = exports.ListFormatSymbols_ksh_DE;
    break;
  case 'ku':
    defaultSymbols = exports.ListFormatSymbols_ku;
    break;
  case 'ku_TR':
  case 'ku-TR':
    defaultSymbols = exports.ListFormatSymbols_ku_TR;
    break;
  case 'kw':
    defaultSymbols = exports.ListFormatSymbols_kw;
    break;
  case 'kw_GB':
  case 'kw-GB':
    defaultSymbols = exports.ListFormatSymbols_kw_GB;
    break;
  case 'ky_KG':
  case 'ky-KG':
    defaultSymbols = exports.ListFormatSymbols_ky_KG;
    break;
  case 'lag':
    defaultSymbols = exports.ListFormatSymbols_lag;
    break;
  case 'lag_TZ':
  case 'lag-TZ':
    defaultSymbols = exports.ListFormatSymbols_lag_TZ;
    break;
  case 'lb':
    defaultSymbols = exports.ListFormatSymbols_lb;
    break;
  case 'lb_LU':
  case 'lb-LU':
    defaultSymbols = exports.ListFormatSymbols_lb_LU;
    break;
  case 'lg':
    defaultSymbols = exports.ListFormatSymbols_lg;
    break;
  case 'lg_UG':
  case 'lg-UG':
    defaultSymbols = exports.ListFormatSymbols_lg_UG;
    break;
  case 'lkt':
    defaultSymbols = exports.ListFormatSymbols_lkt;
    break;
  case 'lkt_US':
  case 'lkt-US':
    defaultSymbols = exports.ListFormatSymbols_lkt_US;
    break;
  case 'ln_AO':
  case 'ln-AO':
    defaultSymbols = exports.ListFormatSymbols_ln_AO;
    break;
  case 'ln_CD':
  case 'ln-CD':
    defaultSymbols = exports.ListFormatSymbols_ln_CD;
    break;
  case 'ln_CF':
  case 'ln-CF':
    defaultSymbols = exports.ListFormatSymbols_ln_CF;
    break;
  case 'ln_CG':
  case 'ln-CG':
    defaultSymbols = exports.ListFormatSymbols_ln_CG;
    break;
  case 'lo_LA':
  case 'lo-LA':
    defaultSymbols = exports.ListFormatSymbols_lo_LA;
    break;
  case 'lrc':
    defaultSymbols = exports.ListFormatSymbols_lrc;
    break;
  case 'lrc_IQ':
  case 'lrc-IQ':
    defaultSymbols = exports.ListFormatSymbols_lrc_IQ;
    break;
  case 'lrc_IR':
  case 'lrc-IR':
    defaultSymbols = exports.ListFormatSymbols_lrc_IR;
    break;
  case 'lt_LT':
  case 'lt-LT':
    defaultSymbols = exports.ListFormatSymbols_lt_LT;
    break;
  case 'lu':
    defaultSymbols = exports.ListFormatSymbols_lu;
    break;
  case 'lu_CD':
  case 'lu-CD':
    defaultSymbols = exports.ListFormatSymbols_lu_CD;
    break;
  case 'luo':
    defaultSymbols = exports.ListFormatSymbols_luo;
    break;
  case 'luo_KE':
  case 'luo-KE':
    defaultSymbols = exports.ListFormatSymbols_luo_KE;
    break;
  case 'luy':
    defaultSymbols = exports.ListFormatSymbols_luy;
    break;
  case 'luy_KE':
  case 'luy-KE':
    defaultSymbols = exports.ListFormatSymbols_luy_KE;
    break;
  case 'lv_LV':
  case 'lv-LV':
    defaultSymbols = exports.ListFormatSymbols_lv_LV;
    break;
  case 'mai':
    defaultSymbols = exports.ListFormatSymbols_mai;
    break;
  case 'mai_IN':
  case 'mai-IN':
    defaultSymbols = exports.ListFormatSymbols_mai_IN;
    break;
  case 'mas':
    defaultSymbols = exports.ListFormatSymbols_mas;
    break;
  case 'mas_KE':
  case 'mas-KE':
    defaultSymbols = exports.ListFormatSymbols_mas_KE;
    break;
  case 'mas_TZ':
  case 'mas-TZ':
    defaultSymbols = exports.ListFormatSymbols_mas_TZ;
    break;
  case 'mer':
    defaultSymbols = exports.ListFormatSymbols_mer;
    break;
  case 'mer_KE':
  case 'mer-KE':
    defaultSymbols = exports.ListFormatSymbols_mer_KE;
    break;
  case 'mfe':
    defaultSymbols = exports.ListFormatSymbols_mfe;
    break;
  case 'mfe_MU':
  case 'mfe-MU':
    defaultSymbols = exports.ListFormatSymbols_mfe_MU;
    break;
  case 'mg':
    defaultSymbols = exports.ListFormatSymbols_mg;
    break;
  case 'mg_MG':
  case 'mg-MG':
    defaultSymbols = exports.ListFormatSymbols_mg_MG;
    break;
  case 'mgh':
    defaultSymbols = exports.ListFormatSymbols_mgh;
    break;
  case 'mgh_MZ':
  case 'mgh-MZ':
    defaultSymbols = exports.ListFormatSymbols_mgh_MZ;
    break;
  case 'mgo':
    defaultSymbols = exports.ListFormatSymbols_mgo;
    break;
  case 'mgo_CM':
  case 'mgo-CM':
    defaultSymbols = exports.ListFormatSymbols_mgo_CM;
    break;
  case 'mi':
    defaultSymbols = exports.ListFormatSymbols_mi;
    break;
  case 'mi_NZ':
  case 'mi-NZ':
    defaultSymbols = exports.ListFormatSymbols_mi_NZ;
    break;
  case 'mk_MK':
  case 'mk-MK':
    defaultSymbols = exports.ListFormatSymbols_mk_MK;
    break;
  case 'ml_IN':
  case 'ml-IN':
    defaultSymbols = exports.ListFormatSymbols_ml_IN;
    break;
  case 'mn_MN':
  case 'mn-MN':
    defaultSymbols = exports.ListFormatSymbols_mn_MN;
    break;
  case 'mni':
    defaultSymbols = exports.ListFormatSymbols_mni;
    break;
  case 'mni_Beng':
  case 'mni-Beng':
    defaultSymbols = exports.ListFormatSymbols_mni_Beng;
    break;
  case 'mni_Beng_IN':
  case 'mni-Beng-IN':
    defaultSymbols = exports.ListFormatSymbols_mni_Beng_IN;
    break;
  case 'mr_IN':
  case 'mr-IN':
    defaultSymbols = exports.ListFormatSymbols_mr_IN;
    break;
  case 'ms_BN':
  case 'ms-BN':
    defaultSymbols = exports.ListFormatSymbols_ms_BN;
    break;
  case 'ms_ID':
  case 'ms-ID':
    defaultSymbols = exports.ListFormatSymbols_ms_ID;
    break;
  case 'ms_MY':
  case 'ms-MY':
    defaultSymbols = exports.ListFormatSymbols_ms_MY;
    break;
  case 'ms_SG':
  case 'ms-SG':
    defaultSymbols = exports.ListFormatSymbols_ms_SG;
    break;
  case 'mt_MT':
  case 'mt-MT':
    defaultSymbols = exports.ListFormatSymbols_mt_MT;
    break;
  case 'mua':
    defaultSymbols = exports.ListFormatSymbols_mua;
    break;
  case 'mua_CM':
  case 'mua-CM':
    defaultSymbols = exports.ListFormatSymbols_mua_CM;
    break;
  case 'my_MM':
  case 'my-MM':
    defaultSymbols = exports.ListFormatSymbols_my_MM;
    break;
  case 'mzn':
    defaultSymbols = exports.ListFormatSymbols_mzn;
    break;
  case 'mzn_IR':
  case 'mzn-IR':
    defaultSymbols = exports.ListFormatSymbols_mzn_IR;
    break;
  case 'naq':
    defaultSymbols = exports.ListFormatSymbols_naq;
    break;
  case 'naq_NA':
  case 'naq-NA':
    defaultSymbols = exports.ListFormatSymbols_naq_NA;
    break;
  case 'nb_NO':
  case 'nb-NO':
    defaultSymbols = exports.ListFormatSymbols_nb_NO;
    break;
  case 'nb_SJ':
  case 'nb-SJ':
    defaultSymbols = exports.ListFormatSymbols_nb_SJ;
    break;
  case 'nd':
    defaultSymbols = exports.ListFormatSymbols_nd;
    break;
  case 'nd_ZW':
  case 'nd-ZW':
    defaultSymbols = exports.ListFormatSymbols_nd_ZW;
    break;
  case 'ne_IN':
  case 'ne-IN':
    defaultSymbols = exports.ListFormatSymbols_ne_IN;
    break;
  case 'ne_NP':
  case 'ne-NP':
    defaultSymbols = exports.ListFormatSymbols_ne_NP;
    break;
  case 'nl_AW':
  case 'nl-AW':
    defaultSymbols = exports.ListFormatSymbols_nl_AW;
    break;
  case 'nl_BE':
  case 'nl-BE':
    defaultSymbols = exports.ListFormatSymbols_nl_BE;
    break;
  case 'nl_BQ':
  case 'nl-BQ':
    defaultSymbols = exports.ListFormatSymbols_nl_BQ;
    break;
  case 'nl_CW':
  case 'nl-CW':
    defaultSymbols = exports.ListFormatSymbols_nl_CW;
    break;
  case 'nl_NL':
  case 'nl-NL':
    defaultSymbols = exports.ListFormatSymbols_nl_NL;
    break;
  case 'nl_SR':
  case 'nl-SR':
    defaultSymbols = exports.ListFormatSymbols_nl_SR;
    break;
  case 'nl_SX':
  case 'nl-SX':
    defaultSymbols = exports.ListFormatSymbols_nl_SX;
    break;
  case 'nmg':
    defaultSymbols = exports.ListFormatSymbols_nmg;
    break;
  case 'nmg_CM':
  case 'nmg-CM':
    defaultSymbols = exports.ListFormatSymbols_nmg_CM;
    break;
  case 'nn':
    defaultSymbols = exports.ListFormatSymbols_nn;
    break;
  case 'nn_NO':
  case 'nn-NO':
    defaultSymbols = exports.ListFormatSymbols_nn_NO;
    break;
  case 'nnh':
    defaultSymbols = exports.ListFormatSymbols_nnh;
    break;
  case 'nnh_CM':
  case 'nnh-CM':
    defaultSymbols = exports.ListFormatSymbols_nnh_CM;
    break;
  case 'nus':
    defaultSymbols = exports.ListFormatSymbols_nus;
    break;
  case 'nus_SS':
  case 'nus-SS':
    defaultSymbols = exports.ListFormatSymbols_nus_SS;
    break;
  case 'nyn':
    defaultSymbols = exports.ListFormatSymbols_nyn;
    break;
  case 'nyn_UG':
  case 'nyn-UG':
    defaultSymbols = exports.ListFormatSymbols_nyn_UG;
    break;
  case 'om':
    defaultSymbols = exports.ListFormatSymbols_om;
    break;
  case 'om_ET':
  case 'om-ET':
    defaultSymbols = exports.ListFormatSymbols_om_ET;
    break;
  case 'om_KE':
  case 'om-KE':
    defaultSymbols = exports.ListFormatSymbols_om_KE;
    break;
  case 'or_IN':
  case 'or-IN':
    defaultSymbols = exports.ListFormatSymbols_or_IN;
    break;
  case 'os':
    defaultSymbols = exports.ListFormatSymbols_os;
    break;
  case 'os_GE':
  case 'os-GE':
    defaultSymbols = exports.ListFormatSymbols_os_GE;
    break;
  case 'os_RU':
  case 'os-RU':
    defaultSymbols = exports.ListFormatSymbols_os_RU;
    break;
  case 'pa_Arab':
  case 'pa-Arab':
    defaultSymbols = exports.ListFormatSymbols_pa_Arab;
    break;
  case 'pa_Arab_PK':
  case 'pa-Arab-PK':
    defaultSymbols = exports.ListFormatSymbols_pa_Arab_PK;
    break;
  case 'pa_Guru':
  case 'pa-Guru':
    defaultSymbols = exports.ListFormatSymbols_pa_Guru;
    break;
  case 'pa_Guru_IN':
  case 'pa-Guru-IN':
    defaultSymbols = exports.ListFormatSymbols_pa_Guru_IN;
    break;
  case 'pcm':
    defaultSymbols = exports.ListFormatSymbols_pcm;
    break;
  case 'pcm_NG':
  case 'pcm-NG':
    defaultSymbols = exports.ListFormatSymbols_pcm_NG;
    break;
  case 'pl_PL':
  case 'pl-PL':
    defaultSymbols = exports.ListFormatSymbols_pl_PL;
    break;
  case 'ps':
    defaultSymbols = exports.ListFormatSymbols_ps;
    break;
  case 'ps_AF':
  case 'ps-AF':
    defaultSymbols = exports.ListFormatSymbols_ps_AF;
    break;
  case 'ps_PK':
  case 'ps-PK':
    defaultSymbols = exports.ListFormatSymbols_ps_PK;
    break;
  case 'pt_AO':
  case 'pt-AO':
    defaultSymbols = exports.ListFormatSymbols_pt_AO;
    break;
  case 'pt_CH':
  case 'pt-CH':
    defaultSymbols = exports.ListFormatSymbols_pt_CH;
    break;
  case 'pt_CV':
  case 'pt-CV':
    defaultSymbols = exports.ListFormatSymbols_pt_CV;
    break;
  case 'pt_GQ':
  case 'pt-GQ':
    defaultSymbols = exports.ListFormatSymbols_pt_GQ;
    break;
  case 'pt_GW':
  case 'pt-GW':
    defaultSymbols = exports.ListFormatSymbols_pt_GW;
    break;
  case 'pt_LU':
  case 'pt-LU':
    defaultSymbols = exports.ListFormatSymbols_pt_LU;
    break;
  case 'pt_MO':
  case 'pt-MO':
    defaultSymbols = exports.ListFormatSymbols_pt_MO;
    break;
  case 'pt_MZ':
  case 'pt-MZ':
    defaultSymbols = exports.ListFormatSymbols_pt_MZ;
    break;
  case 'pt_ST':
  case 'pt-ST':
    defaultSymbols = exports.ListFormatSymbols_pt_ST;
    break;
  case 'pt_TL':
  case 'pt-TL':
    defaultSymbols = exports.ListFormatSymbols_pt_TL;
    break;
  case 'qu':
    defaultSymbols = exports.ListFormatSymbols_qu;
    break;
  case 'qu_BO':
  case 'qu-BO':
    defaultSymbols = exports.ListFormatSymbols_qu_BO;
    break;
  case 'qu_EC':
  case 'qu-EC':
    defaultSymbols = exports.ListFormatSymbols_qu_EC;
    break;
  case 'qu_PE':
  case 'qu-PE':
    defaultSymbols = exports.ListFormatSymbols_qu_PE;
    break;
  case 'raj':
    defaultSymbols = exports.ListFormatSymbols_raj;
    break;
  case 'raj_IN':
  case 'raj-IN':
    defaultSymbols = exports.ListFormatSymbols_raj_IN;
    break;
  case 'rm':
    defaultSymbols = exports.ListFormatSymbols_rm;
    break;
  case 'rm_CH':
  case 'rm-CH':
    defaultSymbols = exports.ListFormatSymbols_rm_CH;
    break;
  case 'rn':
    defaultSymbols = exports.ListFormatSymbols_rn;
    break;
  case 'rn_BI':
  case 'rn-BI':
    defaultSymbols = exports.ListFormatSymbols_rn_BI;
    break;
  case 'ro_MD':
  case 'ro-MD':
    defaultSymbols = exports.ListFormatSymbols_ro_MD;
    break;
  case 'ro_RO':
  case 'ro-RO':
    defaultSymbols = exports.ListFormatSymbols_ro_RO;
    break;
  case 'rof':
    defaultSymbols = exports.ListFormatSymbols_rof;
    break;
  case 'rof_TZ':
  case 'rof-TZ':
    defaultSymbols = exports.ListFormatSymbols_rof_TZ;
    break;
  case 'ru_BY':
  case 'ru-BY':
    defaultSymbols = exports.ListFormatSymbols_ru_BY;
    break;
  case 'ru_KG':
  case 'ru-KG':
    defaultSymbols = exports.ListFormatSymbols_ru_KG;
    break;
  case 'ru_KZ':
  case 'ru-KZ':
    defaultSymbols = exports.ListFormatSymbols_ru_KZ;
    break;
  case 'ru_MD':
  case 'ru-MD':
    defaultSymbols = exports.ListFormatSymbols_ru_MD;
    break;
  case 'ru_RU':
  case 'ru-RU':
    defaultSymbols = exports.ListFormatSymbols_ru_RU;
    break;
  case 'ru_UA':
  case 'ru-UA':
    defaultSymbols = exports.ListFormatSymbols_ru_UA;
    break;
  case 'rw':
    defaultSymbols = exports.ListFormatSymbols_rw;
    break;
  case 'rw_RW':
  case 'rw-RW':
    defaultSymbols = exports.ListFormatSymbols_rw_RW;
    break;
  case 'rwk':
    defaultSymbols = exports.ListFormatSymbols_rwk;
    break;
  case 'rwk_TZ':
  case 'rwk-TZ':
    defaultSymbols = exports.ListFormatSymbols_rwk_TZ;
    break;
  case 'sa':
    defaultSymbols = exports.ListFormatSymbols_sa;
    break;
  case 'sa_IN':
  case 'sa-IN':
    defaultSymbols = exports.ListFormatSymbols_sa_IN;
    break;
  case 'sah':
    defaultSymbols = exports.ListFormatSymbols_sah;
    break;
  case 'sah_RU':
  case 'sah-RU':
    defaultSymbols = exports.ListFormatSymbols_sah_RU;
    break;
  case 'saq':
    defaultSymbols = exports.ListFormatSymbols_saq;
    break;
  case 'saq_KE':
  case 'saq-KE':
    defaultSymbols = exports.ListFormatSymbols_saq_KE;
    break;
  case 'sat':
    defaultSymbols = exports.ListFormatSymbols_sat;
    break;
  case 'sat_Olck':
  case 'sat-Olck':
    defaultSymbols = exports.ListFormatSymbols_sat_Olck;
    break;
  case 'sat_Olck_IN':
  case 'sat-Olck-IN':
    defaultSymbols = exports.ListFormatSymbols_sat_Olck_IN;
    break;
  case 'sbp':
    defaultSymbols = exports.ListFormatSymbols_sbp;
    break;
  case 'sbp_TZ':
  case 'sbp-TZ':
    defaultSymbols = exports.ListFormatSymbols_sbp_TZ;
    break;
  case 'sc':
    defaultSymbols = exports.ListFormatSymbols_sc;
    break;
  case 'sc_IT':
  case 'sc-IT':
    defaultSymbols = exports.ListFormatSymbols_sc_IT;
    break;
  case 'sd':
    defaultSymbols = exports.ListFormatSymbols_sd;
    break;
  case 'sd_Arab':
  case 'sd-Arab':
    defaultSymbols = exports.ListFormatSymbols_sd_Arab;
    break;
  case 'sd_Arab_PK':
  case 'sd-Arab-PK':
    defaultSymbols = exports.ListFormatSymbols_sd_Arab_PK;
    break;
  case 'sd_Deva':
  case 'sd-Deva':
    defaultSymbols = exports.ListFormatSymbols_sd_Deva;
    break;
  case 'sd_Deva_IN':
  case 'sd-Deva-IN':
    defaultSymbols = exports.ListFormatSymbols_sd_Deva_IN;
    break;
  case 'se':
    defaultSymbols = exports.ListFormatSymbols_se;
    break;
  case 'se_FI':
  case 'se-FI':
    defaultSymbols = exports.ListFormatSymbols_se_FI;
    break;
  case 'se_NO':
  case 'se-NO':
    defaultSymbols = exports.ListFormatSymbols_se_NO;
    break;
  case 'se_SE':
  case 'se-SE':
    defaultSymbols = exports.ListFormatSymbols_se_SE;
    break;
  case 'seh':
    defaultSymbols = exports.ListFormatSymbols_seh;
    break;
  case 'seh_MZ':
  case 'seh-MZ':
    defaultSymbols = exports.ListFormatSymbols_seh_MZ;
    break;
  case 'ses':
    defaultSymbols = exports.ListFormatSymbols_ses;
    break;
  case 'ses_ML':
  case 'ses-ML':
    defaultSymbols = exports.ListFormatSymbols_ses_ML;
    break;
  case 'sg':
    defaultSymbols = exports.ListFormatSymbols_sg;
    break;
  case 'sg_CF':
  case 'sg-CF':
    defaultSymbols = exports.ListFormatSymbols_sg_CF;
    break;
  case 'shi':
    defaultSymbols = exports.ListFormatSymbols_shi;
    break;
  case 'shi_Latn':
  case 'shi-Latn':
    defaultSymbols = exports.ListFormatSymbols_shi_Latn;
    break;
  case 'shi_Latn_MA':
  case 'shi-Latn-MA':
    defaultSymbols = exports.ListFormatSymbols_shi_Latn_MA;
    break;
  case 'shi_Tfng':
  case 'shi-Tfng':
    defaultSymbols = exports.ListFormatSymbols_shi_Tfng;
    break;
  case 'shi_Tfng_MA':
  case 'shi-Tfng-MA':
    defaultSymbols = exports.ListFormatSymbols_shi_Tfng_MA;
    break;
  case 'si_LK':
  case 'si-LK':
    defaultSymbols = exports.ListFormatSymbols_si_LK;
    break;
  case 'sk_SK':
  case 'sk-SK':
    defaultSymbols = exports.ListFormatSymbols_sk_SK;
    break;
  case 'sl_SI':
  case 'sl-SI':
    defaultSymbols = exports.ListFormatSymbols_sl_SI;
    break;
  case 'smn':
    defaultSymbols = exports.ListFormatSymbols_smn;
    break;
  case 'smn_FI':
  case 'smn-FI':
    defaultSymbols = exports.ListFormatSymbols_smn_FI;
    break;
  case 'sn':
    defaultSymbols = exports.ListFormatSymbols_sn;
    break;
  case 'sn_ZW':
  case 'sn-ZW':
    defaultSymbols = exports.ListFormatSymbols_sn_ZW;
    break;
  case 'so':
    defaultSymbols = exports.ListFormatSymbols_so;
    break;
  case 'so_DJ':
  case 'so-DJ':
    defaultSymbols = exports.ListFormatSymbols_so_DJ;
    break;
  case 'so_ET':
  case 'so-ET':
    defaultSymbols = exports.ListFormatSymbols_so_ET;
    break;
  case 'so_KE':
  case 'so-KE':
    defaultSymbols = exports.ListFormatSymbols_so_KE;
    break;
  case 'so_SO':
  case 'so-SO':
    defaultSymbols = exports.ListFormatSymbols_so_SO;
    break;
  case 'sq_AL':
  case 'sq-AL':
    defaultSymbols = exports.ListFormatSymbols_sq_AL;
    break;
  case 'sq_MK':
  case 'sq-MK':
    defaultSymbols = exports.ListFormatSymbols_sq_MK;
    break;
  case 'sq_XK':
  case 'sq-XK':
    defaultSymbols = exports.ListFormatSymbols_sq_XK;
    break;
  case 'sr_Cyrl':
  case 'sr-Cyrl':
    defaultSymbols = exports.ListFormatSymbols_sr_Cyrl;
    break;
  case 'sr_Cyrl_BA':
  case 'sr-Cyrl-BA':
    defaultSymbols = exports.ListFormatSymbols_sr_Cyrl_BA;
    break;
  case 'sr_Cyrl_ME':
  case 'sr-Cyrl-ME':
    defaultSymbols = exports.ListFormatSymbols_sr_Cyrl_ME;
    break;
  case 'sr_Cyrl_RS':
  case 'sr-Cyrl-RS':
    defaultSymbols = exports.ListFormatSymbols_sr_Cyrl_RS;
    break;
  case 'sr_Cyrl_XK':
  case 'sr-Cyrl-XK':
    defaultSymbols = exports.ListFormatSymbols_sr_Cyrl_XK;
    break;
  case 'sr_Latn_BA':
  case 'sr-Latn-BA':
    defaultSymbols = exports.ListFormatSymbols_sr_Latn_BA;
    break;
  case 'sr_Latn_ME':
  case 'sr-Latn-ME':
    defaultSymbols = exports.ListFormatSymbols_sr_Latn_ME;
    break;
  case 'sr_Latn_RS':
  case 'sr-Latn-RS':
    defaultSymbols = exports.ListFormatSymbols_sr_Latn_RS;
    break;
  case 'sr_Latn_XK':
  case 'sr-Latn-XK':
    defaultSymbols = exports.ListFormatSymbols_sr_Latn_XK;
    break;
  case 'su':
    defaultSymbols = exports.ListFormatSymbols_su;
    break;
  case 'su_Latn':
  case 'su-Latn':
    defaultSymbols = exports.ListFormatSymbols_su_Latn;
    break;
  case 'su_Latn_ID':
  case 'su-Latn-ID':
    defaultSymbols = exports.ListFormatSymbols_su_Latn_ID;
    break;
  case 'sv_AX':
  case 'sv-AX':
    defaultSymbols = exports.ListFormatSymbols_sv_AX;
    break;
  case 'sv_FI':
  case 'sv-FI':
    defaultSymbols = exports.ListFormatSymbols_sv_FI;
    break;
  case 'sv_SE':
  case 'sv-SE':
    defaultSymbols = exports.ListFormatSymbols_sv_SE;
    break;
  case 'sw_CD':
  case 'sw-CD':
    defaultSymbols = exports.ListFormatSymbols_sw_CD;
    break;
  case 'sw_KE':
  case 'sw-KE':
    defaultSymbols = exports.ListFormatSymbols_sw_KE;
    break;
  case 'sw_TZ':
  case 'sw-TZ':
    defaultSymbols = exports.ListFormatSymbols_sw_TZ;
    break;
  case 'sw_UG':
  case 'sw-UG':
    defaultSymbols = exports.ListFormatSymbols_sw_UG;
    break;
  case 'ta_IN':
  case 'ta-IN':
    defaultSymbols = exports.ListFormatSymbols_ta_IN;
    break;
  case 'ta_LK':
  case 'ta-LK':
    defaultSymbols = exports.ListFormatSymbols_ta_LK;
    break;
  case 'ta_MY':
  case 'ta-MY':
    defaultSymbols = exports.ListFormatSymbols_ta_MY;
    break;
  case 'ta_SG':
  case 'ta-SG':
    defaultSymbols = exports.ListFormatSymbols_ta_SG;
    break;
  case 'te_IN':
  case 'te-IN':
    defaultSymbols = exports.ListFormatSymbols_te_IN;
    break;
  case 'teo':
    defaultSymbols = exports.ListFormatSymbols_teo;
    break;
  case 'teo_KE':
  case 'teo-KE':
    defaultSymbols = exports.ListFormatSymbols_teo_KE;
    break;
  case 'teo_UG':
  case 'teo-UG':
    defaultSymbols = exports.ListFormatSymbols_teo_UG;
    break;
  case 'tg':
    defaultSymbols = exports.ListFormatSymbols_tg;
    break;
  case 'tg_TJ':
  case 'tg-TJ':
    defaultSymbols = exports.ListFormatSymbols_tg_TJ;
    break;
  case 'th_TH':
  case 'th-TH':
    defaultSymbols = exports.ListFormatSymbols_th_TH;
    break;
  case 'ti':
    defaultSymbols = exports.ListFormatSymbols_ti;
    break;
  case 'ti_ER':
  case 'ti-ER':
    defaultSymbols = exports.ListFormatSymbols_ti_ER;
    break;
  case 'ti_ET':
  case 'ti-ET':
    defaultSymbols = exports.ListFormatSymbols_ti_ET;
    break;
  case 'tk':
    defaultSymbols = exports.ListFormatSymbols_tk;
    break;
  case 'tk_TM':
  case 'tk-TM':
    defaultSymbols = exports.ListFormatSymbols_tk_TM;
    break;
  case 'to':
    defaultSymbols = exports.ListFormatSymbols_to;
    break;
  case 'to_TO':
  case 'to-TO':
    defaultSymbols = exports.ListFormatSymbols_to_TO;
    break;
  case 'tr_CY':
  case 'tr-CY':
    defaultSymbols = exports.ListFormatSymbols_tr_CY;
    break;
  case 'tr_TR':
  case 'tr-TR':
    defaultSymbols = exports.ListFormatSymbols_tr_TR;
    break;
  case 'tt':
    defaultSymbols = exports.ListFormatSymbols_tt;
    break;
  case 'tt_RU':
  case 'tt-RU':
    defaultSymbols = exports.ListFormatSymbols_tt_RU;
    break;
  case 'twq':
    defaultSymbols = exports.ListFormatSymbols_twq;
    break;
  case 'twq_NE':
  case 'twq-NE':
    defaultSymbols = exports.ListFormatSymbols_twq_NE;
    break;
  case 'tzm':
    defaultSymbols = exports.ListFormatSymbols_tzm;
    break;
  case 'tzm_MA':
  case 'tzm-MA':
    defaultSymbols = exports.ListFormatSymbols_tzm_MA;
    break;
  case 'ug':
    defaultSymbols = exports.ListFormatSymbols_ug;
    break;
  case 'ug_CN':
  case 'ug-CN':
    defaultSymbols = exports.ListFormatSymbols_ug_CN;
    break;
  case 'uk_UA':
  case 'uk-UA':
    defaultSymbols = exports.ListFormatSymbols_uk_UA;
    break;
  case 'ur_IN':
  case 'ur-IN':
    defaultSymbols = exports.ListFormatSymbols_ur_IN;
    break;
  case 'ur_PK':
  case 'ur-PK':
    defaultSymbols = exports.ListFormatSymbols_ur_PK;
    break;
  case 'uz_Arab':
  case 'uz-Arab':
    defaultSymbols = exports.ListFormatSymbols_uz_Arab;
    break;
  case 'uz_Arab_AF':
  case 'uz-Arab-AF':
    defaultSymbols = exports.ListFormatSymbols_uz_Arab_AF;
    break;
  case 'uz_Cyrl':
  case 'uz-Cyrl':
    defaultSymbols = exports.ListFormatSymbols_uz_Cyrl;
    break;
  case 'uz_Cyrl_UZ':
  case 'uz-Cyrl-UZ':
    defaultSymbols = exports.ListFormatSymbols_uz_Cyrl_UZ;
    break;
  case 'uz_Latn':
  case 'uz-Latn':
    defaultSymbols = exports.ListFormatSymbols_uz_Latn;
    break;
  case 'uz_Latn_UZ':
  case 'uz-Latn-UZ':
    defaultSymbols = exports.ListFormatSymbols_uz_Latn_UZ;
    break;
  case 'vai':
    defaultSymbols = exports.ListFormatSymbols_vai;
    break;
  case 'vai_Latn':
  case 'vai-Latn':
    defaultSymbols = exports.ListFormatSymbols_vai_Latn;
    break;
  case 'vai_Latn_LR':
  case 'vai-Latn-LR':
    defaultSymbols = exports.ListFormatSymbols_vai_Latn_LR;
    break;
  case 'vai_Vaii':
  case 'vai-Vaii':
    defaultSymbols = exports.ListFormatSymbols_vai_Vaii;
    break;
  case 'vai_Vaii_LR':
  case 'vai-Vaii-LR':
    defaultSymbols = exports.ListFormatSymbols_vai_Vaii_LR;
    break;
  case 'vi_VN':
  case 'vi-VN':
    defaultSymbols = exports.ListFormatSymbols_vi_VN;
    break;
  case 'vun':
    defaultSymbols = exports.ListFormatSymbols_vun;
    break;
  case 'vun_TZ':
  case 'vun-TZ':
    defaultSymbols = exports.ListFormatSymbols_vun_TZ;
    break;
  case 'wae':
    defaultSymbols = exports.ListFormatSymbols_wae;
    break;
  case 'wae_CH':
  case 'wae-CH':
    defaultSymbols = exports.ListFormatSymbols_wae_CH;
    break;
  case 'wo':
    defaultSymbols = exports.ListFormatSymbols_wo;
    break;
  case 'wo_SN':
  case 'wo-SN':
    defaultSymbols = exports.ListFormatSymbols_wo_SN;
    break;
  case 'xh':
    defaultSymbols = exports.ListFormatSymbols_xh;
    break;
  case 'xh_ZA':
  case 'xh-ZA':
    defaultSymbols = exports.ListFormatSymbols_xh_ZA;
    break;
  case 'xog':
    defaultSymbols = exports.ListFormatSymbols_xog;
    break;
  case 'xog_UG':
  case 'xog-UG':
    defaultSymbols = exports.ListFormatSymbols_xog_UG;
    break;
  case 'yav':
    defaultSymbols = exports.ListFormatSymbols_yav;
    break;
  case 'yav_CM':
  case 'yav-CM':
    defaultSymbols = exports.ListFormatSymbols_yav_CM;
    break;
  case 'yi':
    defaultSymbols = exports.ListFormatSymbols_yi;
    break;
  case 'yi_001':
  case 'yi-001':
    defaultSymbols = exports.ListFormatSymbols_yi_001;
    break;
  case 'yo':
    defaultSymbols = exports.ListFormatSymbols_yo;
    break;
  case 'yo_BJ':
  case 'yo-BJ':
    defaultSymbols = exports.ListFormatSymbols_yo_BJ;
    break;
  case 'yo_NG':
  case 'yo-NG':
    defaultSymbols = exports.ListFormatSymbols_yo_NG;
    break;
  case 'yrl':
    defaultSymbols = exports.ListFormatSymbols_yrl;
    break;
  case 'yrl_BR':
  case 'yrl-BR':
    defaultSymbols = exports.ListFormatSymbols_yrl_BR;
    break;
  case 'yrl_CO':
  case 'yrl-CO':
    defaultSymbols = exports.ListFormatSymbols_yrl_CO;
    break;
  case 'yrl_VE':
  case 'yrl-VE':
    defaultSymbols = exports.ListFormatSymbols_yrl_VE;
    break;
  case 'yue':
    defaultSymbols = exports.ListFormatSymbols_yue;
    break;
  case 'yue_Hans':
  case 'yue-Hans':
    defaultSymbols = exports.ListFormatSymbols_yue_Hans;
    break;
  case 'yue_Hans_CN':
  case 'yue-Hans-CN':
    defaultSymbols = exports.ListFormatSymbols_yue_Hans_CN;
    break;
  case 'yue_Hant':
  case 'yue-Hant':
    defaultSymbols = exports.ListFormatSymbols_yue_Hant;
    break;
  case 'yue_Hant_HK':
  case 'yue-Hant-HK':
    defaultSymbols = exports.ListFormatSymbols_yue_Hant_HK;
    break;
  case 'zgh':
    defaultSymbols = exports.ListFormatSymbols_zgh;
    break;
  case 'zgh_MA':
  case 'zgh-MA':
    defaultSymbols = exports.ListFormatSymbols_zgh_MA;
    break;
  case 'zh_Hans':
  case 'zh-Hans':
    defaultSymbols = exports.ListFormatSymbols_zh_Hans;
    break;
  case 'zh_Hans_CN':
  case 'zh-Hans-CN':
    defaultSymbols = exports.ListFormatSymbols_zh_Hans_CN;
    break;
  case 'zh_Hans_HK':
  case 'zh-Hans-HK':
    defaultSymbols = exports.ListFormatSymbols_zh_Hans_HK;
    break;
  case 'zh_Hans_MO':
  case 'zh-Hans-MO':
    defaultSymbols = exports.ListFormatSymbols_zh_Hans_MO;
    break;
  case 'zh_Hans_SG':
  case 'zh-Hans-SG':
    defaultSymbols = exports.ListFormatSymbols_zh_Hans_SG;
    break;
  case 'zh_Hant':
  case 'zh-Hant':
    defaultSymbols = exports.ListFormatSymbols_zh_Hant;
    break;
  case 'zh_Hant_HK':
  case 'zh-Hant-HK':
    defaultSymbols = exports.ListFormatSymbols_zh_Hant_HK;
    break;
  case 'zh_Hant_MO':
  case 'zh-Hant-MO':
    defaultSymbols = exports.ListFormatSymbols_zh_Hant_MO;
    break;
  case 'zh_Hant_TW':
  case 'zh-Hant-TW':
    defaultSymbols = exports.ListFormatSymbols_zh_Hant_TW;
    break;
  case 'zu_ZA':
  case 'zu-ZA':
    defaultSymbols = exports.ListFormatSymbols_zu_ZA;
    break;
}

if (defaultSymbols != null) {
  ListSymbols.setListFormatSymbols(defaultSymbols);
}
