from typing import Protocol


class Snap7CliProtocol(Protocol):
    # Client
    def Cli_Create(self): ...
    def Cli_Destroy(self, pointer): ...
    def Cli_PlcStop(self, pointer): ...
    def Cli_PlcColdStart(self, pointer): ...
    def Cli_PlcHotStart(self, pointer): ...
    def Cli_GetPlcStatus(self, pointer, state): ...
    def Cli_GetCpuInfo(self, pointer, info): ...
    def Cli_Disconnect(self, pointer): ...
    def Cli_Connect(self, pointer): ...
    def Cli_ConnectTo(self, pointer, address, rack, slot): ...
    def Cli_DBRead(self, pointer, db_number, start, size, data): ...
    def Cli_DBWrite(self, pointer, db_number, start, size, data): ...
    def Cli_Delete(self, pointer, blocktype, block_num): ...
    def Cli_FullUpload(self, pointer, blocktype, block_num, data, size): ...
    def Cli_Upload(self, pointer, block_type, block_num, data, size): ...
    def Cli_Download(self, pointer, block_num, data, size): ...
    def Cli_DBGet(self, pointer, db_number, data, size): ...
    def Cli_ReadArea(self, pointer, area, dbnumber, start, size, wordlen, data): ...
    def Cli_WriteArea(self, pointer, area, dbnumber, start, size, wordlen, data): ...
    def Cli_ReadMultiVars(self, pointer, items, items_count32): ...
    def Cli_ListBlocks(self, pointer, blocksList): ...
    def Cli_ListBlocksOfType(self, pointer, blocktype, data, count): ...
    def Cli_GetAgBlockInfo(self, pointer, blocktype, db_number, data): ...
    def Cli_SetSessionPassword(self, pointer, password): ...
    def Cli_ClearSessionPassword(self, pointer): ...
    def Cli_SetConnectionParams(self, pointer, address, local_tsap, remote_tsap): ...
    def Cli_SetConnectionType(self, pointer, connection_type): ...
    def Cli_GetConnected(self, pointer, connected): ...
    def Cli_ABRead(self, pointer, start, size, data): ...
    def Cli_ABWrite(self, pointer, start, size, cdata): ...
    def Cli_AsABRead(self, pointer, start, size, data): ...
    def Cli_AsABWrite(self, pointer, start, size, cdata): ...
    def Cli_AsCompress(self, pointer, time): ...
    def Cli_AsCopyRamToRom(self, pointer, time): ...
    def Cli_AsCTRead(self, pointer, start, amount, data): ...
    def Cli_AsCTWrite(self, pointer, start, amount, cdata): ...
    def Cli_AsDBFill(self, pointer, db_number, filler): ...
    def Cli_AsDBGet(self, pointer, db_number, _buffer, size): ...
    def Cli_AsDBRead(self, pointer, db_number, start, size, data): ...
    def Cli_AsDBWrite(self, pointer, db_number, start, size, data): ...
    def Cli_AsDownload(self, pointer, block_num, cdata, size): ...
    def Cli_Compress(self, pointer, time): ...
    def Cli_SetParam(self, pointer, number, value): ...
    def Cli_GetParam(self, pointer, number, value): ...
    def Cli_GetPduLength(self, pointer, requested_, negotiated_): ...
    def Cli_GetPlcDateTime(self, pointer, buffer): ...
    def Cli_SetPlcDateTime(self, pointer, buffer): ...
    def Cli_SetAsCallback(self, pointer, pfn_clicompletion, p_usr): ...
    def Cli_WaitAsCompletion(self, pointer, timeout): ...
    def Cli_AsReadArea(self, pointer, area, dbnumber, start, size, wordlen, data): ...
    def Cli_AsWriteArea(self, pointer, area, dbnumber, start, size, wordlen, data): ...
    def Cli_AsEBRead(self, pointer, start, size, data): ...
    def Cli_AsEBWrite(self, pointer, start, size, cdata): ...
    def Cli_AsFullUpload(self, pointer, block_type, block_num, _buffer, size): ...
    def Cli_AsListBlocksOfType(self, pointer, _blocktype, data, count): ...
    def Cli_AsMBRead(self, pointer, start, size, data): ...
    def Cli_AsMBWrite(self, pointer, start, size, data): ...
    def Cli_AsReadSZL(self, pointer, ssl_id, index, s7_szl, size): ...
    def Cli_AsReadSZLList(self, pointer, szl_list, items_count): ...
    def Cli_AsTMRead(self, pointer, start, amount, data): ...
    def Cli_AsTMWrite(self, pointer, start, amount, data): ...
    def Cli_AsUpload(self, pointer, block_type, block_num, _buffer, size): ...
    def Cli_CopyRamToRom(self, pointer, timeout): ...
    def Cli_CTRead(self, pointer, start, amount, data): ...
    def Cli_CTWrite(self, pointer, start, amount, cdata): ...
    def Cli_DBFill(self, pointer, db_number, filler): ...
    def Cli_EBRead(self, pointer, start, size, data): ...
    def Cli_EBWrite(self, pointer, start, size, cdata): ...
    def Cli_ErrorText(self, error_code32, text, text_length): ...
    def Cli_GetCpInfo(self, pointer, cp_info): ...
    def Cli_GetExecTime(self, pointer, time): ...
    def Cli_GetLastError(self, pointer, last_error): ...
    def Cli_GetOrderCode(self, pointer, order_code): ...
    def Cli_GetPgBlockInfo(self, pointer, buffer, block_info, size): ...
    def Cli_GetProtection(self, pointer, s7_protection): ...
    def Cli_IsoExchangeBuffer(self, pointer, cdata, size): ...
    def Cli_MBRead(self, pointer, start, size, data): ...
    def Cli_MBWrite(self, pointer, start, size, cdata): ...
    def Cli_ReadSZL(self, pointer, ssl_id, index, s7_szl, size): ...
    def Cli_ReadSZLList(self, pointer, szl_list, items_count): ...
    def Cli_SetPlcSystemDateTime(self, pointer): ...
    def Cli_TMRead(self, pointer, start, amount, data): ...
    def Cli_TMWrite(self, pointer, start, amount, cdata): ...
    def Cli_WriteMultiVars(self, pointer, cdata, items_count32): ...
    def Cli_CheckAsCompletion(self, pointer, p_value): ...
    # Server
    def Srv_Create(self): ...
    def Srv_Start(self, pointer): ...
    def Srv_Stop(self, pointer): ...
    def Srv_Destroy(self, pointer): ...
    def Srv_EventText(self, event, text, len_): ...
    def Srv_RegisterArea(self, pointer, area_code, index, userdata, size): ...
    def Srv_SetEventsCallback(self, pointer, callback, usrPtr): ...
    def Srv_SetReadEventsCallback(self, pointer, read_callback): ...
    def Srv_GetStatus(self, pointer, server_status, cpu_status, clients_count): ...
    def Srv_UnregisterArea(self, pointer, area_code, index): ...
    def Srv_UnlockArea(self, pointer, code, index): ...
    def Srv_LockArea(self, pointer, code, index): ...
    def Srv_StartTo(self, pointer, ip): ...
    def Srv_SetParam(self, pointer, number, value): ...
    def Srv_SetMask(self, pointer, kind, mask): ...
    def Srv_SetCpuStatus(self, pointer, status): ...
    def Srv_PickEvent(self, pointer, event, ready): ...
    def Srv_GetParam(self, pointer, number, value): ...
    def Srv_GetMask(self, pointer, kind, mask): ...
    def Srv_ClearEvents(self, pointer): ...
    def Srv_ErrorText(self, error_code32, text, text_length): ...
    # Partner
    def Par_Create(self, active): ...
    def Par_AsBSend(self, pointer): ...
    def Par_BRecv(self, pointer): ...
    def Par_BSend(self, pointer): ...
    def Par_CheckAsBRecvCompletion(self, pointer): ...
    def Par_CheckAsBSendCompletion(self, pointer, result): ...
    def Par_Destroy(self, pointer): ...
    def Par_GetLastError(self, pointer, last_error): ...
    def Par_GetStats(
        self,
        pointer,
        bytes_sent,
        bytes_recv,
        send_errors,
        recv_errors,
    ): ...
    def Par_GetStatus(self, pointer, status): ...
    def Par_SetParam(self, pointer, number, value): ...
    def Par_GetParam(self, pointer, number, value): ...
    def Par_SetRecvCallback(self, pointer): ...
    def Par_SetSendCallback(self, pointer): ...
    def Par_Start(self, pointer): ...
    def Par_StartTo(self, pointer, local_address, remote_address, local_tsap, remote_tsap): ...
    def Par_Stop(self, pointer): ...
    def Par_WaitAsBSendCompletion(self, pointer, timeout): ...
    def Par_ErrorText(self, error_code32, text, text_length): ...
    def Par_GetTimes(self, pointer, send_time, recv_time): ...
