from typing import Type

from ctypes import Array, c_char, c_char_p, c_int, c_int32, c_uint16, c_ulong, c_void_p
from _ctypes import CFuncPtr, _CArgObject

class Snap7CliProtocol:
    # Client
    def Cli_Create(self) -> int: ...
    def Cli_Destroy(self, pointer: _CArgObject) -> int: ...
    def Cli_PlcStop(self, pointer: c_void_p) -> int: ...
    def Cli_PlcColdStart(self, pointer: c_void_p) -> int: ...
    def Cli_PlcHotStart(self, pointer: c_void_p) -> int: ...
    def Cli_GetPlcStatus(self, pointer: c_void_p, state: _CArgObject) -> int: ...
    def Cli_GetCpuInfo(self, pointer: c_void_p, info: _CArgObject) -> int: ...
    def Cli_Disconnect(self, pointer: c_void_p) -> int: ...
    def Cli_Connect(self, pointer: c_void_p) -> int: ...
    def Cli_ConnectTo(self, pointer: c_void_p, address: c_char_p, rack: c_int, slot: c_int) -> int: ...
    def Cli_DBRead(self, pointer: c_void_p, db_number: int, start: int, size: int, data: _CArgObject) -> int: ...
    def Cli_DBWrite(self, pointer: c_void_p, db_number: int, start: int, size: int, data: _CArgObject) -> int: ...
    def Cli_Delete(self, pointer: c_void_p, blocktype: c_int, block_num: int) -> int: ...
    def Cli_FullUpload(
        self, pointer: c_void_p, blocktype: c_int, block_num: int, data: _CArgObject, size: _CArgObject
    ) -> int: ...
    def Cli_Upload(self, pointer: c_void_p, block_type: c_int, block_num: int, data: _CArgObject, size: _CArgObject) -> int: ...
    def Cli_Download(self, pointer: c_void_p, block_num: int, data: _CArgObject, size: int) -> int: ...
    def Cli_DBGet(self, pointer: c_void_p, db_number: int, data: _CArgObject, size: _CArgObject) -> int: ...
    def Cli_ReadArea(
        self, pointer: c_void_p, area: int, dbnumber: int, start: int, size: int, wordlen: int, data: _CArgObject
    ) -> int: ...
    def Cli_WriteArea(
        self, pointer: c_void_p, area: int, dbnumber: int, start: int, size: int, wordlen: int, data: _CArgObject
    ) -> int: ...
    def Cli_ReadMultiVars(self, pointer: c_void_p, items: _CArgObject, items_count: c_int32) -> int: ...
    def Cli_ListBlocks(self, pointer: c_void_p, blocksList: _CArgObject) -> int: ...
    def Cli_ListBlocksOfType(self, pointer: c_void_p, blocktype: c_int, data: _CArgObject, count: _CArgObject) -> int: ...
    def Cli_GetAgBlockInfo(self, pointer: c_void_p, blocktype: c_int, db_number: int, data: _CArgObject) -> int: ...
    def Cli_SetSessionPassword(self, pointer: c_void_p, password: c_char_p) -> int: ...
    def Cli_ClearSessionPassword(self, pointer: c_void_p) -> int: ...
    def Cli_SetConnectionParams(self, pointer: c_void_p, address: bytes, local_tsap: c_uint16, remote_tsap: c_uint16) -> int: ...
    def Cli_SetConnectionType(self, pointer: c_void_p, connection_type: c_uint16) -> int: ...
    def Cli_GetConnected(self, pointer: c_void_p, connected: _CArgObject) -> int: ...
    def Cli_ABRead(self, pointer: c_void_p, start: int, size: int, data: _CArgObject) -> int: ...
    def Cli_ABWrite(self, pointer: c_void_p, start: int, size: int, cdata: _CArgObject) -> int: ...
    def Cli_AsABRead(self, pointer: c_void_p, start: int, size: int, data: _CArgObject) -> int: ...
    def Cli_AsABWrite(self, pointer: c_void_p, start: int, size: int, cdata: _CArgObject) -> int: ...
    def Cli_AsCompress(self, pointer: c_void_p, time: int) -> int: ...
    def Cli_AsCopyRamToRom(self, pointer: c_void_p, time: int) -> int: ...
    def Cli_AsCTRead(self, pointer: c_void_p, start: int, amount: int, data: _CArgObject) -> int: ...
    def Cli_AsCTWrite(self, pointer: c_void_p, start: int, amount: int, cdata: _CArgObject) -> int: ...
    def Cli_AsDBFill(self, pointer: c_void_p, db_number: int, filler: int) -> int: ...
    def Cli_AsDBGet(self, pointer: c_void_p, db_number: int, _buffer: _CArgObject, size: _CArgObject) -> int: ...
    def Cli_AsDBRead(self, pointer: c_void_p, db_number: int, start: int, size: int, data: _CArgObject) -> int: ...
    def Cli_AsDBWrite(self, pointer: c_void_p, db_number: int, start: int, size: int, data: _CArgObject) -> int: ...
    def Cli_AsDownload(self, pointer: c_void_p, block_num: int, cdata: _CArgObject, size: int) -> int: ...
    def Cli_Compress(self, pointer: c_void_p, time: int) -> int: ...
    def Cli_SetParam(self, pointer: c_void_p, number: int, value: _CArgObject) -> int: ...
    def Cli_GetParam(self, pointer: c_void_p, number: c_int, value: _CArgObject) -> int: ...
    def Cli_GetPduLength(self, pointer: c_void_p, requested_: _CArgObject, negotiated_: _CArgObject) -> int: ...
    def Cli_GetPlcDateTime(self, pointer: c_void_p, buffer: _CArgObject) -> int: ...
    def Cli_SetPlcDateTime(self, pointer: c_void_p, buffer: _CArgObject) -> int: ...
    def Cli_SetAsCallback(self, pointer: c_void_p, pfn_clicompletion: CFuncPtr, p_usr: c_void_p) -> int: ...
    def Cli_WaitAsCompletion(self, pointer: c_void_p, timeout: c_ulong) -> int: ...
    def Cli_AsReadArea(
        self, pointer: c_void_p, area: int, dbnumber: int, start: int, size: int, wordlen: int, data: _CArgObject
    ) -> int: ...
    def Cli_AsWriteArea(
        self, pointer: c_void_p, area: int, dbnumber: int, start: int, size: int, wordlen: int, data: _CArgObject
    ) -> int: ...
    def Cli_AsEBRead(self, pointer: c_void_p, start: int, size: int, data: _CArgObject) -> int: ...
    def Cli_AsEBWrite(self, pointer: c_void_p, start: int, size: int, cdata: _CArgObject) -> int: ...
    def Cli_AsFullUpload(
        self, pointer: c_void_p, block_type: c_int, block_num: int, _buffer: _CArgObject, size: _CArgObject
    ) -> int: ...
    def Cli_AsListBlocksOfType(self, pointer: c_void_p, _blocktype: c_int, data: _CArgObject, count: _CArgObject) -> int: ...
    def Cli_AsMBRead(self, pointer: c_void_p, start: int, size: int, data: _CArgObject) -> int: ...
    def Cli_AsMBWrite(self, pointer: c_void_p, start: int, size: int, data: _CArgObject) -> int: ...
    def Cli_AsReadSZL(self, pointer: c_void_p, ssl_id: int, index: int, s7_szl: _CArgObject, size: _CArgObject) -> int: ...
    def Cli_AsReadSZLList(self, pointer: c_void_p, szl_list: _CArgObject, items_count: _CArgObject) -> int: ...
    def Cli_AsTMRead(self, pointer: c_void_p, start: int, amount: int, data: _CArgObject) -> int: ...
    def Cli_AsTMWrite(self, pointer: c_void_p, start: int, amount: int, data: _CArgObject) -> int: ...
    def Cli_AsUpload(
        self, pointer: c_void_p, block_type: c_int, block_num: int, _buffer: _CArgObject, size: _CArgObject
    ) -> int: ...
    def Cli_CopyRamToRom(self, pointer: c_void_p, timeout: int) -> int: ...
    def Cli_CTRead(self, pointer: c_void_p, start: int, amount: int, data: _CArgObject) -> int: ...
    def Cli_CTWrite(self, pointer: c_void_p, start: int, amount: int, cdata: _CArgObject) -> int: ...
    def Cli_DBFill(self, pointer: c_void_p, db_number: int, filler: int) -> int: ...
    def Cli_EBRead(self, pointer: c_void_p, start: int, size: int, data: _CArgObject) -> int: ...
    def Cli_EBWrite(self, pointer: c_void_p, start: int, size: int, cdata: _CArgObject) -> int: ...
    def Cli_ErrorText(self, error_code: c_int32, text: Array[c_char], text_length: c_int) -> int: ...
    def Cli_GetCpInfo(self, pointer: c_void_p, cp_info: _CArgObject) -> int: ...
    def Cli_GetExecTime(self, pointer: c_void_p, time: _CArgObject) -> int: ...
    def Cli_GetLastError(self, pointer: c_void_p, last_error: _CArgObject) -> int: ...
    def Cli_GetOrderCode(self, pointer: c_void_p, order_code: _CArgObject) -> int: ...
    def Cli_GetPgBlockInfo(self, pointer: c_void_p, buffer: _CArgObject, block_info: _CArgObject, size: c_int) -> int: ...
    def Cli_GetProtection(self, pointer: c_void_p, s7_protection: _CArgObject) -> int: ...
    def Cli_IsoExchangeBuffer(self, pointer: c_void_p, cdata: _CArgObject, size: _CArgObject) -> int: ...
    def Cli_MBRead(self, pointer: c_void_p, start: int, size: int, data: _CArgObject) -> int: ...
    def Cli_MBWrite(self, pointer: c_void_p, start: int, size: int, cdata: _CArgObject) -> int: ...
    def Cli_ReadSZL(self, pointer: c_void_p, ssl_id: int, index: int, s7_szl: _CArgObject, size: _CArgObject) -> int: ...
    def Cli_ReadSZLList(self, pointer: c_void_p, szl_list: _CArgObject, items_count: _CArgObject) -> int: ...
    def Cli_SetPlcSystemDateTime(self, pointer: c_void_p) -> int: ...
    def Cli_TMRead(self, pointer: c_void_p, start: int, amount: int, data: _CArgObject) -> int: ...
    def Cli_TMWrite(self, pointer: c_void_p, start: int, amount: int, cdata: _CArgObject) -> int: ...
    def Cli_WriteMultiVars(self, pointer: c_void_p, cdata: _CArgObject, items_count: c_int32) -> int: ...
    def Cli_CheckAsCompletion(self, pointer: c_void_p, p_value: _CArgObject) -> int: ...
    # Server
    def Srv_Create(self) -> int: ...
    def Srv_Start(self, pointer: c_void_p) -> int: ...
    def Srv_Stop(self, pointer: c_void_p) -> int: ...
    def Srv_Destroy(self, pointer: _CArgObject) -> None: ...
    def Srv_EventText(self, event: _CArgObject, text: _CArgObject, len_: int) -> int: ...
    def Srv_RegisterArea(self, pointer: c_void_p, area_code: int, index: int, userdata: _CArgObject, size: int) -> int: ...
    def Srv_SetEventsCallback(self, pointer: c_void_p, callback: Type[CFuncPtr], usrPtr: c_void_p) -> int: ...
    def Srv_SetReadEventsCallback(self, pointer: c_void_p, read_callback: CFuncPtr) -> int: ...
    def Srv_GetStatus(
        self, pointer: c_void_p, server_status: _CArgObject, cpu_status: _CArgObject, clients_count: _CArgObject
    ) -> int: ...
    def Srv_UnregisterArea(self, pointer: c_void_p, area_code: int, index: int) -> int: ...
    def Srv_UnlockArea(self, pointer: c_void_p, code: int, index: int) -> int: ...
    def Srv_LockArea(self, pointer: c_void_p, code: int, index: int) -> int: ...
    def Srv_StartTo(self, pointer: c_void_p, ip: bytes) -> int: ...
    def Srv_SetParam(self, pointer: c_void_p, number: int, value: _CArgObject) -> int: ...
    def Srv_SetMask(self, pointer: c_void_p, kind: int, mask: int) -> int: ...
    def Srv_SetCpuStatus(self, pointer: c_void_p, status: int) -> int: ...
    def Srv_PickEvent(self, pointer: c_void_p, event: _CArgObject, ready: _CArgObject) -> int: ...
    def Srv_GetParam(self, pointer: c_void_p, number: int, value: _CArgObject) -> int: ...
    def Srv_GetMask(self, pointer: c_void_p, kind: int, mask: _CArgObject) -> int: ...
    def Srv_ClearEvents(self, pointer: c_void_p) -> int: ...
    def Srv_ErrorText(self, error_code: c_int32, text: Array[c_char], text_length: c_int) -> int: ...
    # Partner
    def Par_Create(self, active: int) -> int: ...
    def Par_AsBSend(self, pointer: c_void_p) -> int: ...
    def Par_BRecv(self, pointer: c_void_p) -> int: ...
    def Par_BSend(self, pointer: c_void_p) -> int: ...
    def Par_CheckAsBRecvCompletion(self, pointer: c_void_p) -> int: ...
    def Par_CheckAsBSendCompletion(self, pointer: c_void_p, result: _CArgObject) -> int: ...
    def Par_Destroy(self, pointer: _CArgObject) -> int: ...
    def Par_GetLastError(self, pointer: c_void_p, last_error: _CArgObject) -> int: ...
    def Par_GetStats(
        self,
        pointer: c_void_p,
        bytes_sent: _CArgObject,
        bytes_recv: _CArgObject,
        send_errors: _CArgObject,
        recv_errors: _CArgObject,
    ) -> int: ...
    def Par_GetStatus(self, pointer: c_void_p, status: _CArgObject) -> int: ...
    def Par_SetParam(self, pointer: c_void_p, number: c_int, value: _CArgObject) -> int: ...
    def Par_GetParam(self, pointer: c_void_p, number: c_int, value: _CArgObject) -> int: ...
    def Par_SetRecvCallback(self, pointer: c_void_p) -> int: ...
    def Par_SetSendCallback(self, pointer: c_void_p) -> int: ...
    def Par_Start(self, pointer: c_void_p) -> int: ...
    def Par_StartTo(
        self, pointer: c_void_p, local_address: bytes, remote_address: bytes, local_tsap: c_uint16, remote_tsap: c_uint16
    ) -> int: ...
    def Par_Stop(self, pointer: c_void_p) -> int: ...
    def Par_WaitAsBSendCompletion(self, pointer: c_void_p, timeout: int) -> int: ...
    def Par_ErrorText(self, error_code: c_int32, text: Array[c_char], text_length: c_int) -> int: ...
    def Par_GetTimes(self, pointer: c_void_p, send_time: _CArgObject, recv_time: _CArgObject) -> int: ...
