# fit_tscan Intermediate Example

Intermediate usage example for fit_tscan utility.
Yon can find example file from [TRXASprefitpack-example](https://github.com/pistack/TRXASprefitpack-example/tree/v0.6.1) fit_tscan subdirectory.

1. Go to `osc` sub directory of `fit_tscan` directory.
2. In `osc` sub directory,  you can find ``example_osc_1.txt``, ``example_osc_2.txt``, ``example_osc_3.txt``, ``example_osc_4.txt`` files.
These examples are generated from Library example, fitting with time delay scan (model: sum of exponential decay and damped oscillation).

## Finding oscillation component

1. Before fitting with oscillation, first find oscillation component.
2. Type ``fit_tscan -h`` Then it prints help message. You can find detailed description of arguments in the utility section of this document.
3. Type ``fit_tscan example_osc --num_file 4 --mode decay --irf g --fwhm_G 0.1 -t0 0 0 0 0 --tau 0.5 20 2000 --no_base -o decay --method_glb ampgo`` 
4. After fitting process is finished, you can see both fitting result plot and report for fitting result in the console. Upper part of plot shows fitting curve and experimental data. Lower part of plot shows residual of fit (data-fit).
5. You can find oscillation feature in residual panel of time scan 1. 

![png](fit_tscan_example_file/example_osc_1.png) ![png](fit_tscan_example_file/example_osc_2.png)
![png](fit_tscan_example_file/example_osc_3.png) ![png](fit_tscan_example_file/example_osc_4.png)

## Fitting with oscillation Feature

1. Guessing initial lifetime and period for oscillation feature. 
2. Type ``fit_tscan example_osc --num_file 4 --mode both --irf g --fwhm_G 0.1 -t0 0 0 0 0 --tau 0.5 10 1000 --tau_osc 1.5 --period_osc 0.5 --no_base -o osc --method_glb ampgo``.
In this example, we change fitting mode to `both` that is add convolution of damped oscillation and instrumental response function component.
Moreover we set initial lifetime `--tau_osc` and period ``--period_osc`` for such component.
3. After fitting process is finished, you can see oscillation feature is well fited in residual panel of time scan 1.

![png](fit_tscan_example_file/example_osc_1_osc.png)

## Description for additional Output file in osc directory.

* ``phase_example_osc.txt`` contains phase factor of each oscillation component in each time delay scan

* ``fit_decay_example_osc.txt`` contains decay part of fitting curve of time delay scan

* ``fit_osc_example_osc.txt`` contains oscillation part of fitting curve of time delay scan