/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.lib;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class CountUpDownLatch {
    private final Sync sync;

    public CountUpDownLatch() {
        this(0);
    }

    public CountUpDownLatch(int initialCount) {
        if (initialCount < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        this.sync = new Sync(initialCount);
    }

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
    }

    public void countUp() {
        this.sync.releaseShared(this.sync.getCount() + 1);
    }

    public void countDown() {
        this.sync.releaseShared(this.sync.getCount() - 1);
    }

    public long getCount() {
        return this.sync.getCount();
    }

    public void setCount(int newCount) {
        this.sync.releaseShared(newCount);
    }

    public String toString() {
        return super.toString() + "[Count = " + this.sync.getCount() + "]";
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 1L;

        Sync(int count) {
            this.setState(count);
        }

        int getCount() {
            return this.getState();
        }

        @Override
        protected int tryAcquireShared(int ignored) {
            return this.getState() == 0 ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int requestedCount) {
            boolean result;
            int newCount = Math.max(0, requestedCount);
            boolean bl = result = newCount == 0;
            while (!this.compareAndSetState(this.getState(), newCount)) {
            }
            return result;
        }
    }
}

