# B2_VISUAL: Визуализация изменений параметров модели с регуляризацией

Этот репозиторий предоставляет Python-скрипт для визуализации изменений параметров модели во время градиентного спуска с учетом L1 и L2 регуляризаций.

---

## Возможности

1. **Визуализация траектории параметров**:Построение траектории параметров $b_1, b_2$ во время оптимизации.
2. **Изолинии L1-регуляризации**:Отображение штрафа L1 $\lambda_1 \cdot (|b_1| + |b_2|$ с градиентной цветовой заливкой.
3. **Изолинии L2-регуляризации**:Отображение штрафа L2 $\lambda_2 \cdot (b_1^2 + b_2^2)$ с градиентной цветовой заливкой.
4. **Настраиваемые параметры**:

   - Масштаб графика (`k`).
   - Количество точек для вычисления изолиний (`num_points`).
   - Интенсивность регуляризации (`lamb_l1` и `lamb_l2`).

---

## Установка

Убедитесь, что у вас установлен Python и следующие библиотеки:

- `numpy`
- `pandas`
- `matplotlib`

Установить их можно с помощью команды:

```bash
pip install numpy pandas matplotlib
```

---

## Использование

### Импорт скрипта

```python
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
from matplobblib.ml import B2_VISUAL
```

### Вызов функции `B2_VISUAL`

```python
from sklearn.preprocessing import StandardScaler

X, y = make_regression(n_samples=30, n_features=2, noise=1, random_state=42, effective_rank=None)

X = StandardScaler().fit_transform(X)
y = StandardScaler().fit_transform(y.reshape((-1, 1)))
X, y = pd.DataFrame(X), pd.DataFrame(y)

model = LinearRegressionL1()
b_arr = model.fit(X, y, lambd=0.1, a=0.1, n=1000)

model.plot(X,y)
model.score(y, model.predict(X))
```

![1734194365323](image/README/1734194365323.png)

0.9939198763974456

```python
B2_VISUAL(b_arr, k=1, lamb_l1=0.1, num_points=30)
```

![1734194403305](image/README/1734194403305.png)

---

## Аргументы

| Параметр | Тип               | Описание                                                                     | Значение по умолчанию |
| ---------------- | -------------------- | ------------------------------------------------------------------------------------ | ---------------------------------------- |
| `b`            | `pandas.DataFrame` | Таблица с траекторией параметров (`b[0]`и `b[1]`). | -                                        |
| `k`            | `int`              | Масштаб осей графика.                                              | 1                                        |
| `lamb_l1`      | `float`            | Коэффициент L1 регуляризации (λ1\lambda_1).                 | 0                                        |
| `lamb_l2`      | `float`            | Коэффициент L2 регуляризации (λ2\lambda_2).                 | 0                                        |
| `num_points`   | `int`              | Количество точек для вычисления изолиний.        | 100                                      |

---

## Примеры результатов

1. **Без регуляризации**

   Отображается только траектория параметров.
2. **С L1-регуляризацией**

   Показываются изолинии штрафа для L1-регуляризации.
3. **С L2-регуляризацией**

   Показываются изолинии штрафа для L2-регуляризации.

---

## Заметки

* Функция может отображать изолинии как L1, так и L2 регуляризаций, в зависимости от значений `lamb_l1` и `lamb_l2`.
* Сетка для построения изолиний динамически настраивается на основе траектории параметров (`b`).
