# Описание

Если вы открыли этот модуль библиотеки `matplobblib` и не знаете, что делать, то вот маленькая инструкция:

- `description()` выведет список тем и для каждой темы будет список функций, решающих определенную задачу по теме
- `description([key])`, где  `key` - название темы в формате **str**, выведет список функций с соответсвующими описаниями задач
- `description([key, func])`, где  `key` - название темы в формате **str**, a `func` - название функции в формате **str**, выведет код этой самой функции

Также в данный момент доступно использование всех функций модуля без интеграции кода в ваш проект - иными словами, **вы можете решать задачи так же, подставляя аргументы в функции**, но внутреннюю часть этих функций вы видеть не будете. Разве это не замечательно?

## Полезные ссылки

* [Карта разных распределений](https://www.math.wm.edu/~leemis/chart/UDR/UDR.html)

# Реализованы решения задач по темам:

- [ТЕОРЕТИЧЕСКИЕ МАТЕРИАЛЫ](https://github.com/Ackrome/matplobblib/tree/master/matplobblib/tvims/theory#readme)
- [Формулы полной вероятности и Байеса](https://github.com/Ackrome/matplobblib/tree/master/matplobblib/tvims/fpb#readme)
- [Специальные дискретные случайные величины](https://github.com/Ackrome/matplobblib/tree/master/matplobblib/tvims/sdrv#readme)
- [Непрерывные случайные величины](https://github.com/Ackrome/matplobblib/tree/master/matplobblib/tvims/crv#readme)
- [Нормальные случайные векторы](https://github.com/Ackrome/matplobblib/tree/master/matplobblib/tvims/nrv#readme)
- [Нормальные случайные векторы [дополнительный пакет функций]](https://github.com/Ackrome/matplobblib/tree/master/matplobblib/tvims/anrv#readme)
- [Условные характеристики относительно группы событий](https://github.com/Ackrome/matplobblib/tree/master/matplobblib/tvims/cce#readme)
- [Приближенное вычисление вероятности методом Монте-Карло](https://github.com/Ackrome/matplobblib/tree/master/matplobblib/tvims/acmk#readme)
- [Портфельный анализ с невырожденной ковариационной матрицей](https://github.com/Ackrome/matplobblib/tree/master/matplobblib/tvims/pan#readme)
- [Описательная статистика](https://github.com/Ackrome/matplobblib/tree/master/matplobblib/tvims/dt#readme)
- [Эмперические характеристики](https://github.com/Ackrome/matplobblib/tree/master/matplobblib/tvims/ec#readme)
- [Выборки из конечной совокупности](https://github.com/Ackrome/matplobblib/tree/master/matplobblib/tvims/sffp#readme)
- [Метод максимального правдоподобия](https://github.com/Ackrome/matplobblib/tree/master/matplobblib/tvims/mlm#readme)
- [Проверка гипотез о значении среднего](https://github.com/Ackrome/matplobblib/tree/master/matplobblib/tvims/tmh#readme)
- [Проверка гипотез о значении дисперсии](https://github.com/Ackrome/matplobblib/tree/master/matplobblib/tvims/tvh#readme)
- [Проверка гипотезы о состоянии двух и трёх средних](https://github.com/Ackrome/matplobblib/tree/master/matplobblib/tvims/tsm#readme)
- [Доверительный интервал для коэффициента корреляции](https://github.com/Ackrome/matplobblib/tree/master/matplobblib/tvims/cicc#readme)
