# Приближённое вычисление вероятностей методом Монте-Карло

Этот проект содержит реализацию методов приближённого вычисления вероятностей с использованием метода Монте-Карло.

Функции определяют вероятности и условные вероятности для различных событий в заданных областях. Основная идея заключается в генерации случайных точек или объектов в ограниченной области, проверке выполнения условий для событий и вычислении вероятностей на основе эмпирических данных.

---

## Описание функций

### 1. `ACMK_1(a, b, le1, le2)`

В прямоугольной области (\|x\| ≤ `a` и \|y\| ≤ `b`) случайным образом выбираются пары точек:

- Событие **A**: расстояние между точками меньше `le1`.
- Событие **B**: разность координат \|x1 - x2\| меньше `le2`.

Функция вычисляет:

- Вероятность **P(A)**.
- Условную вероятность **P(A|B)**.

### 2. `ACMK_2(a, b, le, sign)`

В области, ограниченной эллипсом \((u/a)^2 + (v/b)^2 = 1\), случайным образом выбираются пары точек:

- Событие **A**: расстояние между точками меньше `le`.
- Событие **B**: все координаты обеих точек удовлетворяют условию `sign` (больше или меньше 0).

Функция вычисляет:

- Вероятность **P(A)**.
- Условную вероятность **P(A|B)**.

### 3. `ACMK_3(a, b, le)`

В области, ограниченной эллипсом \((u/a)^2 + (v/b)^2 = 1\), случайным образом выбираются пары точек:

- Событие **A**: расстояние между точками меньше `le`.
- Событие **B**: координаты первой точки больше 0, а координаты второй точки меньше 0.

Функция вычисляет:

- Вероятность **P(A)**.
- Условную вероятность **P(A|B)**.

### 4. `ACMK_4(cond1, r, cond2, s)`

В кубе объёма **V** случайным образом выбираются три точки (A, B, C):

- Событие **R**: угол в треугольнике ABC по условию `cond1` меньше `r` градусов.
- Событие **S**: угол в треугольнике ABC по условию `cond2` меньше `s` градусов.
- Событие **T**: треугольник ABC остроугольный.

Функция вычисляет:

- Условную вероятность **P(R|T)**.
- Условную вероятность **P(S|T)**.

---

## Использование

Каждая функция принимает соответствующие аргументы и возвращает кортеж значений вероятностей. Пример использования:

```python
result = ACMK_1(a=5, b=5, le1=3, le2=2)
print(result)  # Выводит вероятности P(A) и P(A|B)
```

---

## Зависимости

Для работы функций необходимы следующие библиотеки:

* `scipy`
* `numpy`
* Пользовательская функция `rrstr` для форматирования чисел (замена точки на запятую).

---

## Лицензия

Этот проект предоставляется «как есть». Автор не несёт ответственности за возможные ошибки или неточности.
