# Непрерывные случайные величины

## Описание

Модуль содержит функции для работы с непрерывными случайными величинами, которые описываются заданными плотностями распределения. Эти функции решают задачи вычисления:

1. Константы нормировки плотности вероятности.
2. Математического ожидания, стандартного отклонения, квантиля, а также других характеристик распределения.

---

## Список функций

### 1. **`CRV_1`**

Моделирует абсолютно непрерывную случайную величину $ X $, принимающую значения на отрезке $[a, b]$ с плотностью распределения:

$$
f(x) = C \cdot \left( 1 + \sum \text{(betas[i] * x**powers[i])} \right)^{\text{all\_power}},
$$

где $ C $ – положительная нормировочная константа.

#### Аргументы:

| Параметр | Тип           | Описание                                                          |
| ---------------- | ---------------- | ------------------------------------------------------------------------- |
| `a`            | `число`   | Начало отрезка распределения.                   |
| `b`            | `число`   | Конец отрезка распределения.                     |
| `betas`        | `список` | Коэффициенты при степенях$x$.                    |
| `powers`       | `список` | Степени при$x$.                                               |
| `all_power`    | `число`   | Общая степень выражения.                             |
| `q_l`          | `число`   | Уровень квантиля (по умолчанию$ q_l = 0.9 $). |

#### Возвращает:

Кортеж из следующих характеристик:

1. $ C $ – нормировочная константа.
2. $ E(X) $ – математическое ожидание.
3. $ \sigma_X $ – стандартное отклонение.
4. $ q $ – квантиль уровня $ q_l $.

---

### 2. **`CRV_2`**

Рассматривает случай, когда $ X $ равномерно распределена на отрезке $[a, b]$, а новая случайная величина $ Y $ выражается через $ X $ по формуле:

$$
Y = C \cdot \left( 1 + \sum \text{(betas[i] * x**powers[i])} \right)^{\text{all\_power}}.
$$

#### Аргументы:

| Параметр | Тип           | Описание                                                          |
| ---------------- | ---------------- | ------------------------------------------------------------------------- |
| `a`            | `число`   | Начало отрезка распределения.                   |
| `b`            | `число`   | Конец отрезка распределения.                     |
| `betas`        | `список` | Коэффициенты при степенях$x$.                    |
| `powers`       | `список` | Степени при$x$.                                               |
| `all_power`    | `число`   | Общая степень выражения.                             |
| `q_l`          | `число`   | Уровень квантиля (по умолчанию$ q_l = 0.9 $). |

#### Возвращает:

Кортеж из следующих характеристик:

1. $ E(Y) $ – математическое ожидание.
2. $ \sigma_Y $ – стандартное отклонение.
3. $ As(Y) $ – асимметрия распределения.
4. $ q $ – квантиль уровня $ q_l $.

---

## Пример использования

```python
# Пример для CRV_1
a, b = 0, 1
betas = [1, 2]
powers = [1, 2]
all_power = 2
q_l = 0.95

result = CRV_1(a, b, betas, powers, all_power, q_l)
# Вывод:
# C = 3.56789
# E = 0.678
# sigma = 0.234
# q = 0.946

# Пример для CRV_2
a, b = 0, 1
betas = [1, 1]
powers = [1, 2]
all_power = 3
q_l = 0.8

result = CRV_2(a, b, betas, powers, all_power, q_l)
# Вывод:
# EY = 4.5
# Qy = 1.23
# AsY = 0.3456
# q = 5.678
```

---

## Зависимости

- **SymPy** – для символьных вычислений.
- **NumPy** – для численных вычислений.
- **SciPy** – для интегрирования, работы с распределениями и расчёта статистик.
- **Math** – для базовых математических функций.

---

## Ограничения

- Функции предполагают, что плотность распределения корректно задана на отрезке $[a, b]$.
- Коэффициенты $ \text{betas} $ и $ \text{powers} $ должны иметь одинаковую длину.
