# `describe_text` – Функция анализа выборки данных

## Описание

Функция **`describe_text`** предназначена для статистического анализа выборки, представленной в текстовом формате. Она вычисляет основные параметры выборки, включая доверительные интервалы, моды, медианы, размах, квантили, а также графически отображает данные (по желанию).

### Основные возможности:

1. **Анализ структуры выборки**: размер, количество пропущенных данных (NA), размах.
2. **Оценка ключевых статистик**: среднее значение, медиана, квартили, стандартное отклонение, дисперсия.
3. **Оценка распределения**: асимметрия, эксцесс, квантиль.
4. **Выбросы**: вычисление границ нормы, подсчёт выбросов.
5. **Доверительные интервалы**: для математического ожидания и дисперсии.

## Аргументы:

- **`data` (str)**: Исходные данные выборки, представленные одной строкой без переносов.
- **`splitter` (str)**: Разделитель между значениями выборки.
- **`g` (float, опционально)**: Коэффициент доверия для расчёта доверительных интервалов. По умолчанию `g=0.9`.
- **`draw_boxes` (bool, опционально)**: Визуализация данных в виде "ящиков с усами". По умолчанию – `False`.
- **`q_l` (float, опционально)**: Процент квантиля, стандартно `q_l=63`.

## Возвращаемое значение:

**`pandas.DataFrame`** – таблица с результатами статистического анализа.

### Вычисляемые параметры:

1. Объём выборки (до и после очистки от NA).
2. Количество пропущенных данных.
3. Минимум, максимум, размах выборки.
4. Квартильные значения (Q1, медиана Q2, Q3).
5. Среднее значение и стандартное отклонение.
6. Исправленная дисперсия.
7. Эксцесс и коэффициент асимметрии.
8. Значение заданного квантиля и мода.
9. Частота встречаемости моды.
10. Границы нормы и количество выбросов.
11. Доверительные интервалы для математического ожидания и дисперсии.

### Визуализация:

Если параметр `draw_boxes=True`, функция построит два графика:

- Ящик с усами для всей выборки.
- Ящик с усами для очищенной выборки (без NA и выбросов).

## Пример использования:

```python
data = "1.2,3.4,2.1,5.6,3.3,NA,4.2,5.5"
splitter = ","
g = 0.95
draw_boxes = True
q_l = 75

result = describe_text(data, splitter, g, draw_boxes, q_l)
print(result)
```

## Примечания:

1. **Отсутствующие данные** (NA) автоматически удаляются из анализа.
2. **Выбросы** определяются на основе границ нормы, вычисляемых как 1.5 × IQR (квартильный размах).
3. Функция подходит для работы с текстовыми данными, разделёнными заданным символом.

## Требования:

- **Python 3.6+**
- Библиотеки: `pandas`, `numpy`, `scipy.stats`, `matplotlib`.
