# Эмпирические характеристики

Этот модуль предоставляет набор функций для вычисления различных эмпирических характеристик данных, включая средние значения, дисперсии, ковариации, коэффициенты корреляции и другие статистические показатели. Каждая функция предназначена для решения специфической задачи, описанной ниже.

---

## Описание функций

### `EC_1(marks_text)`

Вычисление характеристик оценок студентов (в диапазоне от 0 до 100 баллов).

#### Аргументы:

- `marks_text` (str): Строка оценок, разделенных запятыми (например, `"80, 90, 0, 75"`).

#### Результаты:

1. Средняя положительная оценка (A).
2. Медиана положительных оценок (M).
3. Среднее гармоническое оценок, не меньших M (H).
4. Среднее геометрическое оценок, не меньших M (G).
5. Медианная оценка среди студентов с оценками не менее M (Q).
6. Количество студентов с оценками в диапазоне от H до Q включительно (N).

---

### `EC_2(text)`

Анализ дневных логарифмических доходностей акций компании.

#### Аргументы:

- `text` (str): Строка преобразованных доходностей, разделенных запятыми (например, `"12345, 67890, 54321"`).

#### Результаты:

1. Среднее арифметическое преобразованных доходностей.
2. Эмпирическое стандартное отклонение.
3. Нижний квартиль (L).
4. Верхний квартиль (H).
5. Количество доходностей в интервале от L до H.
6. Расстояние между эмпирической и теоретической функциями распределения (d).

---

### `EC_3(text)`

Вычисление условных характеристик ковариации и корреляции оценок.

#### Аргументы:

- `text` (str): Строка вида `"x1=80, y1=85, x2=90, y2=88"`, представляющая оценки по двум дисциплинам.

#### Результаты:

1. Ковариация между оценками (X и Y) для студентов, набравших не менее 50 баллов по каждой дисциплине.
2. Коэффициент корреляции между оценками при том же условии.

---

### `EC_4(text)`

Анализ оценок студентов в нескольких группах.

#### Аргументы:

- `text` (str): Текст вида `"n1=30, x¯1=75, σ1=10, n2=40, x¯2=80, σ2=12, n3=50, x¯3=85, σ3=8"`.

#### Результаты:

1. Среднее значение оценок на потоке.
2. Эмпирическое стандартное отклонение оценок на потоке.

---

## Использование

Все функции доступны через список `EC`:

```python
EC = [EC_1, EC_2, EC_3, EC_4]
```

### Пример:

```python
marks = "80, 90, 0, 75"
result = EC[0](marks)
# Вывод:
# A = 81,7
# M = 80
# H = 83,3
# G = 82,5
# Q = 85
# N = 2
```

### Особенности:

- Все числовые результаты выводятся с запятой вместо точки.
- Результаты округляются до нужного количества знаков с помощью функции `rrstr()`.

---

## Зависимости

- `numpy` для численных вычислений.
- `scipy.stats` для статистических расчетов.
- `matplotlib` для построения графиков.
- `statsmodels` для работы с эмпирической функцией распределения (ECDF).
