# Формулы полной вероятности и Байеса

## Описание

Этот модуль содержит функции для решения задач, связанных с формулами полной вероятности и теоремой Байеса. Функции предназначены для вычисления вероятностей событий, а также условных вероятностей, основанных на различных предположениях и условиях.

### Основные функции:

1. **FPB\_1**: Задача с монетами (бракованные монеты и их поведение при броске).
2. **FPB\_2**: Задача с корзинами и шарами (различные вероятности размещения и извлечения).
3. **FPB\_3**: Задача с биномиальным распределением шаров в корзинах.
4. **FPB\_4**: Задача с извлечением шаров без возвращения из двух корзин.

---

### FPB\_1: Задача с монетами

**Описание**:
Имеется `N` монет, из которых `n` бракованные (на обеих сторонах изображен герб). Выбранная монета бросается `m` раз.

**Вопросы**:

1. Какова вероятность, что монета при всех `m` бросках ляжет гербом вверх?
2. Какова вероятность, что выбрана монета с двумя гербами, если при `m` бросках монета легла гербом вверх?

**Аргументы**:

- `N` (число): Общее количество монет.
- `n` (число): Количество бракованных монет.
- `m` (число): Число бросков.

**Возвращаемые значения**:

- Кортеж вероятностей: `(P1, P2)`.

---

### FPB\_2: Задача с корзинами и шарами

**Описание**:
В первой корзине имеется `first` шаров, количество белых шаров равно либо `first1`, либо `first2` (равновероятно). Во второй корзине находится `second` шаров, количество белых шаров равно `second1`, `second2` или `second3` (равновероятно). Все шары перекладываются в третью корзину.

**Вопросы**:

1. Какова вероятность, что случайно выбранный из третьей корзины шар окажется белым (событие A)?
2. Какова условная вероятность, что белый шар из третьей корзины был из первой корзины (событие H | A)?

**Аргументы**:

- `first` (число): Шаров в первой корзине.
- `first1`/`first2` (числа): Возможные количества белых шаров в первой корзине.
- `second` (число): Шаров во второй корзине.
- `second1`/`second2`/`second3` (числа): Возможные количества белых шаров во второй корзине.

**Возвращаемые значения**:

- Кортеж вероятностей: `(P(A), P(H|A))`.

---

### FPB\_3: Задача с биномиальным распределением

**Описание**:
Имеется две корзины с белыми и черными шарами. В первой корзине количество белых шаров распределено по биномиальному закону с параметрами `n1` и `p1`. Во второй корзине аналогичное распределение с параметрами `n2` и `p2`. Все шары перекладываются в третью корзину.

**Вопросы**:

1. Какова вероятность, что случайно выбранный из третьей корзины шар окажется белым (событие A)?
2. Какова условная вероятность, что белый шар из третьей корзины был из первой корзины (событие H | A)?

**Аргументы**:

- `s1`/`s2` (числа): Общее количество шаров в корзинах.
- `n1`/`n2` (числа): Параметры биномиального распределения.
- `p1`/`p2` (числа): Вероятности успеха (доля белых шаров).

**Возвращаемые значения**:

- Кортеж вероятностей: `(P(A), P(H|A))`.

---

### FPB\_4: Задача с извлечением шаров

**Описание**:
Имеются две корзины с белыми и черными шарами. Из первой корзины извлекаются `take1` шаров, из второй корзины – `take2` шаров. Извлеченные шары перекладываются в третью корзину.

**Вопросы**:

1. Какова вероятность, что случайно выбранный из третьей корзины шар окажется белым (событие A)?
2. Какова условная вероятность, что белый шар из третьей корзины был из первой корзины (событие H | A)?

**Аргументы**:

- `wt1`/`bl1` (числа): Количество белых и черных шаров в первой корзине.
- `wt2`/`bl2` (числа): Количество белых и черных шаров во второй корзине.
- `take1`/`take2` (числа): Количество извлекаемых шаров из корзин.

**Возвращаемые значения**:

- Кортеж вероятностей: `(P(A), P(H|A))`.

---

## Общие инструкции

### Формат вывода

Каждая функция выводит результаты на экран с заменой точки на запятую и округлением до 3 знаков после запятой. Пример:

```
Вероятность P(A)            = 0,725
Условная вероятность P(H|A) = 0,512
```

### Требования

- Python версии 3.6 или выше.
- Необходимые библиотеки: `itertools`.
