# Специальные дискретные случайные величины

Этот модуль содержит функции для работы с дискретными случайными величинами, моделирующими различные статистические и вероятностные процессы. Эти функции используются для анализа кредитов, подбрасывания монет и выборки шаров.

## Описание Функций

### `SDRV_1(na, nb, pa, pb)`

**Описание:**

Функция моделирует процесс возврата кредитов заемщиками из двух групп. В каждой группе есть определенное количество заемщиков, и вероятность возврата кредита для каждого заемщика в группе известна. Функция вычисляет два статистических значения для суммарного количества возвращенных кредитов:

* **Стандартное отклонение (σX)** для суммарного количества возвращенных кредитов.
* **Асимметрию (AsX)** распределения количества возвращенных кредитов.

**Аргументы:**

* `na` (int): Количество заемщиков в первой группе.
* `nb` (int): Количество заемщиков во второй группе.
* `pa` (float): Вероятность того, что заемщик из первой группы вернет кредит.
* `pb` (float): Вероятность того, что заемщик из второй группы вернет кредит.

**Возвращаемое значение:**

Кортеж с двумя значениями:

* Стандартное отклонение для X.
* Асимметрия для X.

**Примечание:**

Результаты выводятся с точностью до одного знака для стандартного отклонения и трех знаков для асимметрии, с заменой точки на запятую.

---

### `SDRV_2(sigmaX, sigmaY, sigmaZ, s)`

**Описание:**

Функция анализирует сумму трех независимых пуассоновских случайных величин. Каждая из величин имеет свое стандартное отклонение, и на основе этих данных функция вычисляет следующие значения для суммы `S = X + Y + Z`:

* **Вероятность P(S = s)** для конкретного значения суммы `s`.
* **Наиболее вероятное значение суммы S** .
* **Стандартное отклонение σS** для суммы.
* **Асимметрию As(S)** для распределения суммы.
* **Эксцесс Ex(S)** для распределения суммы.

**Аргументы:**

* `sigmaX` (float): Стандартное отклонение для случайной величины X.
* `sigmaY` (float): Стандартное отклонение для случайной величины Y.
* `sigmaZ` (float): Стандартное отклонение для случайной величины Z.
* `s` (int): Значение суммы S, для которого нужно вычислить вероятность.

**Возвращаемое значение:**

Кортеж с пятью значениями:

* Вероятность P(S = s).
* Наиболее вероятное значение суммы S.
* Стандартное отклонение для суммы S.
* Асимметрия для суммы S.
* Эксцесс для суммы S.

**Примечание:**

Результаты выводятся с точностью до трех знаков после запятой.

---

### `SDRV_3(N, n, G)`

**Описание:**

Функция моделирует процесс подбрасывания монет до тех пор, пока не выпадет `n` раз герб `G`. Она анализирует два случайных процесса:

* **X** : количество бросков до первого появления `G` гербов.
* **Y** : общее количество бросков, необходимое для получения всех `n` гербов.

Функция вычисляет следующие статистические значения:

* **Математическое ожидание для X** .
* **Стандартное отклонение для X** .
* **Коэффициент корреляции между X и Y** .
* **Математическое ожидание для произведения XY** .

**Аргументы:**

* `N` (int): Общее количество монет.
* `n` (int): Количество необходимых выпадений герба.
* `G` (int): Количество гербов, которое должно выпасть.

**Возвращаемое значение:**

Кортеж с четырьмя значениями:

* Математическое ожидание для X.
* Стандартное отклонение для X.
* Коэффициент корреляции между X и Y.
* Математическое ожидание для произведения XY.

**Примечание:**

Результаты выводятся с точностью до трех знаков для математического ожидания и стандартного отклонения, а также до одного знака для математического ожидания произведения XY.

---

### `SDRV_4(N, r, b, n)`

**Описание:**

Функция моделирует процесс извлечения шаров из корзины. В корзине есть `N` шаров, из которых `r` — красные, а `b` — синие. Из корзины случайным образом без возвращения извлекаются `n` шаров. Функция вычисляет **ковариацию** между количеством красных и синих шаров среди извлеченных:

* **Ковариация Cov(X, Y)** между количеством красных и синих шаров.

**Аргументы:**

* `N` (int): Общее количество шаров в корзине.
* `r` (int): Количество красных шаров.
* `b` (int): Количество синих шаров.
* `n` (int): Количество извлекаемых шаров.

**Возвращаемое значение:**

Кортеж с одним значением:

* Ковариация между количеством красных и синих шаров.

**Примечание:**

Результат выводится с точностью до двух знаков после запятой.

---

## Общие замечания

* Все результаты выводятся в виде строк с использованием запятой вместо точки и округлением до соответствующего количества знаков после запятой.
* Для округления чисел используется функция `rrstr()`, которая также заменяет точку на запятую в выводе.

---

Этот модуль предоставляет мощные инструменты для анализа дискретных случайных величин и вероятностных процессов, таких как анализ кредитов, подбрасывание монет и выборки шаров.
