# Проверка гипотезы о состоянии двух и трёх средних

## Описание

Данный модуль содержит функции для проверки статистических гипотез, связанных с генеральными средними и межгрупповыми дисперсиями. Функции реализуют подходы на основе Z-критерия для двух групп данных и F-критерия Фишера для трёх групп данных.

## Функции

### `TSTwoM_1`

Функция проверяет гипотезу о равенстве двух генеральных средних при известной дисперсии.

#### Описание гипотезы

* **H0** : μ_x = μ_y
* **H1** : μ_x > μ_y

#### Входные параметры

* `text_x` (str): Строка с числовыми значениями выборки X, разделёнными символом-разделителем.
* `text_y` (str): Строка с числовыми значениями выборки Y, разделёнными символом-разделителем.
* `sigma_x` (float): Известное стандартное отклонение X.
* `sigma_y` (float): Известное стандартное отклонение Y.
* `alpha` (float): Уровень значимости.
* `delta` (float): Разница между математическими ожиданиями для расчёта мощности критерия.
* `splitter` (str, optional): Символ-разделитель в строках данных. По умолчанию `';'`.
* `locale` (str, optional): Локализация для числовых данных. Если числа используют точку как разделитель дробной части, задайте любое значение, кроме `'rus'`. По умолчанию `'rus'`.

#### Возвращаемые значения

Функция возвращает кортеж:

1. Значение статистики Z.
2. P-значение.
3. Критическое значение A.
4. Мощность критерия.

#### Пример использования

```python
result = TSTwoM_1("1,2;2,3;3,4", "2,1;1,9;2,8", sigma_x=1.5, sigma_y=1.2, alpha=0.05, delta=0.5)
```

### `TSThreeM_1`

Функция проверяет гипотезу о равенстве средних значений для трёх групп данных на основе F-критерия Фишера.

#### Описание гипотезы

* **H0** : μ_x = μ_y = μ_z
* **H1** : μ_x, μ_y, μ_z не равны.

#### Входные параметры

* `A` (str): Строка с числовыми значениями группы A, разделёнными символом-разделителем.
* `B` (str): Строка с числовыми значениями группы B, разделёнными символом-разделителем.
* `C` (str): Строка с числовыми значениями группы C, разделёнными символом-разделителем.
* `alpha` (float): Уровень значимости.
* `splitter` (str, optional): Символ-разделитель в строках данных. По умолчанию `';'`.
* `locale` (str, optional): Локализация для числовых данных. Если числа используют точку как разделитель дробной части, задайте любое значение, кроме `'rus'`. По умолчанию `'rus'`.

#### Возвращаемые значения

Функция возвращает кортеж:

1. Межгрупповая дисперсия.
2. Средняя групповая дисперсия.
3. Значение статистики F.
4. P-значение.

#### Пример использования

```python
result = TSThreeM_1("1,2;3,4;5,6", "2,3;4,5;6,7", "1,1;2,2;3,3", alpha=0.05)
```

## Примечания

1. Для корректной работы функции ожидают числовые строки с использованием разделителя дробной части, соответствующего локализации.
2. Для работы с русской локализацией дробной части задаётся запятая.
3. Результаты округляются до 3 знаков после запятой и выводятся с запятыми вместо точек.
