# Проверка гипотез о значении дисперсии

## Описание

Данный проект содержит функции для проверки гипотез о значении дисперсии случайной выборки из нормального распределения. Включены две основные функции:

1. `TVH_1`: проверка гипотезы о дисперсии при известном математическом ожидании.
2. `TVH_2`: проверка гипотезы о дисперсии при неизвестном математическом ожидании.

Каждая функция возвращает значения статистики критерия, границы критического множества, P-значение и вероятность ошибки второго рода.

## Функции

### 1. TVH_1

Проверяет гипотезу H0: σ=σ0 против альтернативной гипотезы H1: σ≠σ0, если математическое ожидание известно.

#### Аргументы

* `text` (str): строка с числовыми данными выборки.
* `mu0` (float): математическое ожидание распределения.
* `sigma_0` (float): стандартное отклонение для гипотезы H0.
* `sigma_1` (float): стандартное отклонение для вычисления вероятности ошибки второго рода.
* `alpha` (float): уровень значимости.
* `splitter` (str, optional): разделитель чисел в строке (по умолчанию `;`).
* `locale` (str, optional): локализация чисел (по умолчанию `rus` для чисел с запятой как разделителем десятичных долей).

#### Возвращаемое значение

Кортеж:

* значение статистики критерия,
* границы критического множества (A и B),
* P-значение,
* вероятность ошибки второго рода (β).

### 2. TVH_2

Проверяет гипотезу H0: σ=σ0 против альтернативной гипотезы H1: σ≠σ0, если математическое ожидание неизвестно.

#### Аргументы

* `text` (str): строка с числовыми данными выборки.
* `sigma_0` (float): стандартное отклонение для гипотезы H0.
* `sigma_1` (float): стандартное отклонение для вычисления вероятности ошибки второго рода.
* `alpha` (float): уровень значимости.
* `splitter` (str, optional): разделитель чисел в строке (по умолчанию `;`).
* `locale` (str, optional): локализация чисел (по умолчанию `rus` для чисел с запятой как разделителем десятичных долей).

#### Возвращаемое значение

Кортеж:

* значение статистики критерия,
* границы критического множества (A и B),
* P-значение,
* вероятность ошибки второго рода (β\).

## Установка

Для выполнения кода требуется Python 3.7+ и следующие библиотеки:

* `scipy`
* `numpy`

## Вывод

Функции выводят значения статистики, границы критического множества, P-значение и вероятность ошибки второго рода, а также текстовые сообщения о принятии или отклонении гипотезы H0.
