# KFold Разбиение

Этот проект реализует функцию `Kfold_split` для выполнения KFold-разбиения данных. KFold — это метод кросс-валидации, при котором данные разбиваются на `k` фолдов (частей), и обучение модели происходит на `k-1` фолдах, а валидация — на оставшемся фолде. Этот процесс повторяется `k` раз, каждый раз с новым фолдом в качестве тестового.

---

## Описание

Функция `Kfold_split` выполняет разбиение данных на обучающую и тестовую выборки для кросс-валидации. Она поддерживает перемешивание индексов перед разбиением и позволяет задавать зерно генератора случайных чисел для воспроизводимости результатов.

---

## Параметры

- **`n_samples`**: Общее число образцов в данных.
- **`n_splits`**: Число фолдов (по умолчанию 5).
- **`shuffle`**: Перемешивать ли индексы перед разбиением (по умолчанию `True`).
- **`random_state`**: Зерно генератора случайных чисел для воспроизводимости результатов (по умолчанию `None`).

---

## Возвращаемое значение

Функция возвращает генератор кортежей `(train_indices, test_indices)`, где:

- `train_indices`: Индексы обучающей выборки.
- `test_indices`: Индексы тестовой выборки.

---

[Укажите лицензию, если применимо]
