# Линейная Регрессия с Градиентным Спуском и Модификациями

Этот проект представляет несколько реализаций линейной регрессии, включая стандартную версию с градиентным спуском, стохастический градиентный спуск, а также версии с регуляризациями L1 и L2, и использование ошибки MAE. Ниже описаны основные классы и методы, включенные в проект.

## Классы

### 1. **LinearRegression**

Класс для реализации линейной регрессии с обычным градиентным спуском.

#### Методы:

* ****init**** : Инициализация объекта линейной регрессии.
* **predict** : Предсказание значений зависимой переменной (Y) на основе матрицы признаков (X).
* **error** : Вычисление ошибки модели с использованием средней квадратичной ошибки (MSE).
* **fit** : Обучение модели с использованием градиентного спуска. Параметры: `X`, `y`, скорость обучения `a`, количество итераций `n`.
* **score** : Вычисление коэффициента детерминации R² для оценки качества модели.
* **plot** : Построение графика предсказанных и реальных значений Y.
* **study_plot** : Построение графика изменения ошибки во время обучения.

### 2. **LinearRegressionStoh**

Класс для реализации линейной регрессии с использованием стохастического градиентного спуска.

#### Методы:

* ****init**** : Инициализация объекта.
* **predict** : Предсказание значений зависимой переменной (Y) на основе матрицы признаков (X).
* **error** : Вычисление ошибки MSE для стохастического градиентного спуска.
* **fit** : Обучение модели с использованием стохастического градиентного спуска. Параметры: `X`, `y`, размер подвыборки `B`, количество эпох `E`, скорость обучения `a`, количество итераций `n`.
* **score** : Вычисление коэффициента детерминации R².
* **plot** : Построение графика.
* **study_plot** : Построение графика ошибок.

### 3. **LinearRegressionL2**

Класс для реализации линейной регрессии с L2-регуляризацией.

#### Методы:

* ****init**** : Инициализация объекта.
* **predict** : Предсказание значений зависимой переменной (Y).
* **error** : Вычисление ошибки MSE с добавлением L2-регуляризации.
* **fit** : Обучение модели с использованием L2-регуляризации. Параметры: `X`, `y`, коэффициент регуляризации `lambd`, скорость обучения `a`, количество итераций `n`.
* **score** : Вычисление R².
* **plot** : Построение графика.

### 4. **LinearRegressionMAE**

Класс для реализации линейной регрессии с использованием ошибки MAE (средняя абсолютная ошибка).

#### Методы:

* ****init**** : Инициализация объекта.
* **predict** : Предсказание значений зависимой переменной (Y).
* **error** : Вычисление ошибки MAE.
* **fit** : Обучение модели с использованием ошибки MAE. Параметры: `X`, `y`, скорость обучения `a`, количество итераций `n`.
* **score** : Вычисление R².
* **plot** : Построение графика.

### 5. **LinearRegressionL1**

Класс для реализации линейной регрессии с L1-регуляризацией.

#### Методы:

* ****init**** : Инициализация объекта.
* **predict** : Предсказание значений зависимой переменной (Y).
* **error** : Вычисление ошибки MSE с добавлением L1-регуляризации.
* **fit** : Обучение модели с использованием L1-регуляризации. Параметры: `X`, `y`, коэффициент регуляризации `lambd`, скорость обучения `a`, количество итераций `n`.
* **score** : Вычисление R².
* **plot** : Построение графика.

### 6. **Модели**

Список доступных моделей для обучения:

```python
RM = [LinearRegression, LinearRegressionStoh, LinearRegressionMAE, LinearRegressionL1, LinearRegressionL2]
```

## Зависимости

* **numpy** : для численных расчетов.
* **pandas** : для работы с данными.
* **matplotlib** : для визуализации графиков.

## Пример использования

### 1. Обучение модели

Пример обучения модели линейной регрессии с градиентным спуском:

```python
# Инициализация модели
model = LinearRegression()

# Обучение модели
errors = model.fit(X_train, y_train, a=0.01, n=1000)

# Вывод ошибок за каждую итерацию
print(errors)
```

### 2. Оценка модели

```python
# Оценка точности модели
r2_score = model.score(y_test, model.predict(X_test))
print(f'R²: {r2_score}')
```

### 3. Визуализация результатов

```python
# График ошибок
model.study_plot(errors)

# График предсказаний
model.plot(X_test, y_test)
```

## Лицензия

Этот проект является открытым и распространяется по лицензии MIT.
