# Доверительный интервал для коэффициента корреляции

## Описание

Функция `CICC_1` предназначена для расчёта выборочного коэффициента корреляции и асимптотического доверительного интервала для коэффициента корреляции $\rho$, основанного на заданных выборках $X$ и $Y$. Она применима для выборок, предполагаемых из двумерного нормального распределения $N(\mu_x; \mu_y; \sigma_x^2; \sigma_y^2; \rho)$.

### Функциональность:

1. Расчёт выборочного коэффициента корреляции $\hat{\rho}$.
2. Построение асимптотического доверительного интервала $(\hat{\theta}_1; \hat{\theta}_2)$ для коэффициента корреляции $\rho$.
3. Вывод верхней ($\hat{\theta}_2$) и нижней ($\hat{\theta}_1$) границ интервала.

---

## Аргументы

| Аргумент | Тип    | Описание                                                                                                                                                                                                                                                 |
| ---------------- | --------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `x`            | `str`   | Строка, представляющая вектор$X$, записанная в виде `(x1; x2; ...; x31)`. Все значения разделены точкой с запятой, вещественные числа через запятую. |
| `y`            | `str`   | Строка, представляющая вектор$Y$, записанная аналогично вектору $X$.                                                                                                                                    |
| `trust`        | `float` | Доверительный уровень. Значение в диапазоне от 0 до 1, например,$0.93$ для 93%-го доверительного интервала.                                                                      |

---

## Возвращаемое значение

Функция возвращает кортеж значений:

1. $\hat{\rho}$ (выборочный коэффициент корреляции),
2. $\hat{\theta}_1$ (нижняя граница доверительного интервала),
3. $\hat{\theta}_2$ (верхняя граница доверительного интервала).

---

## Пример использования

```python
x = "(2.5; 3.1; 4.0; 2.8; 3.6; 4.2; 5.1; 3.9; 2.7; 4.4)"
y = "(3.0; 3.3; 4.5; 3.2; 3.8; 4.7; 5.0; 4.2; 3.1; 4.9)"
trust = 0.93

result = CICC_1(x, y, trust)

# Результаты:
# Выборочный коэффициент корреляции:  0,879
# Верхняя граница доверительного интервала:  0,923
# Нижняя граница доверительного интервала:  0,819
```

---

## Зависимости

- **NumPy** (`numpy`) – для расчёта выборочного коэффициента корреляции и преобразования данных.
- **SciPy** (`scipy.stats.norm`) – для получения критических значений нормального распределения.

---

## Детали реализации

1. **Преобразование данных:** строки $X$ и $Y$ преобразуются в массивы NumPy для дальнейшей обработки.
2. **Расчёт коэффициента корреляции:** вычисляется выборочный коэффициент корреляции с помощью `np.corrcoef`.
3. **Fisher Z-преобразование:** применяется для оценки доверительного интервала.
4. **Обратное преобразование:** границы интервала возвращаются к исходной шкале корреляции с использованием гиперболического тангенса.

---

## Ограничения

- Данные должны быть независимыми и следовать двумерному нормальному распределению.
- Размер выборки должен быть не менее 4 (для расчёта доверительных интервалов требуется $n > 3$).
