# Метод максимального правдоподобия

## Описание

Этот скрипт реализует метод максимального правдоподобия для нахождения параметров $a$ и $b$ распределения на отрезке $[0,1]$ с плотностью:

$$
f(x; a, b) = a \cdot b \cdot x^{a - 1} \cdot (1 - x^a)^{b - 1}
$$

На основе заданного набора частот (наблюдений) программа:

1. Находит оптимальные параметры $A$ и $B$ путем максимизации функции правдоподобия.
2. Вычисляет математическое ожидание $E(X)$ случайной величины $X$, распределенной с плотностью $f(x; A, B)$.
3. Находит квантиль уровня $0,2$ ($X_{0,2}$).

Результаты интерпретируются в контексте анализа для всей популяции.

---

## Аргументы

- **`text`** *(str)*: Строка, содержащая частоты, разделенные указанным символом.
- **`splitter`** *(str)*: Символ-разделитель между значениями в `text`.
- **`bounds`** *(list, optional)*: Диапазон целых значений для параметров $a$ и $b$. По умолчанию $[1, 20]$.

---

## Возвращаемые значения

Функция возвращает кортеж из следующих значений:

1. **$A$**: Оптимальное значение параметра $a$.
2. **$B$**: Оптимальное значение параметра $b$.
3. **$E(X)$**: Математическое ожидание случайной величины $X$.
4. **$X_{0,2}$**: Квантиль уровня $0,2$.

---

## Вывод

Функция последовательно печатает:

1. Значение $A$: `Значение A = ...`
2. Значение $B$: `Значение B = ...`
3. Математическое ожидание $E(X)$: `Математическое ожидание = ...`
4. Квантиль $X_{0,2}$: `Квантиль = ...`

Все числа округлены до соответствующего количества десятичных знаков и используют запятую вместо точки.

---

## Пример использования

```python
result = mlm(
    text="10,20,30,40,50",
    splitter=",",
    bounds=[1, 20]
)
```

### Ожидаемый вывод

```
Значение A = 10
Значение B = 15
Математическое ожидание = 0,637
Квантиль = 0,284
```

---

## Требования

- **Библиотеки**: `numpy`, `sympy`, `scipy`
- Python 3.8+
