# Нормальные случайные векторы

## Описание

Модуль предоставляет функции для работы с нормальными случайными векторами, их вероятностями и характеристиками. Рассматриваются векторы (X, Y) с заданными параметрами распределения и функциями плотности.

### Основные функции:

1. **NRV_1**: Рассчитывает вероятность P((X - Px)(Y - Py) < 0).
2. **NRV_2**: Рассчитывает вероятность P((X - x1)(X - x2)(Y - y) < 0).
3. **NRV_3**: Вычисляет характеристики случайного вектора (математическое ожидание, дисперсию, ковариацию и коэффициент корреляции).

---

### NRV_1: Расчет вероятности произведения отклонений

**Описание**:
Для нормального случайного вектора (X, Y), распределенного по N(muX, muY, sigmaX2, sigmaY2, rho), функция вычисляет вероятность P((X - Px)(Y - Py) < 0).

**Аргументы**:

- `muX` (число): Математическое ожидание X.
- `muY` (число): Математическое ожидание Y.
- `sigmaX2` (число): Дисперсия X.
- `sigmaY2` (число): Дисперсия Y.
- `rho` (число): Коэффициент корреляции между X и Y.
- `Px` (число): Смещение по X.
- `Py` (число): Смещение по Y.

**Вывод**:

- Вероятность P((X - Px)(Y - Py) < 0), округленная до 4 знаков после запятой.

---

### NRV_2: Расчет вероятности произведения трех отклонений

**Описание**:
Для нормального случайного вектора (X, Y), распределенного по N(muX, muY, sigmaX2, sigmaY2, rho), функция вычисляет вероятность P((X - x1)(X - x2)(Y - y) < 0).

**Аргументы**:

- `muX` (число): Математическое ожидание X.
- `muY` (число): Математическое ожидание Y.
- `sigmaX2` (число): Дисперсия X.
- `sigmaY2` (число): Дисперсия Y.
- `rho` (число): Коэффициент корреляции между X и Y.
- `x1` (число): Первое смещение по X.
- `x2` (число): Второе смещение по X.
- `y` (число): Смещение по Y.

**Вывод**:

- Вероятность P((X - x1)(X - x2)(Y - y) < 0), округленная до 4 знаков после запятой.

---

### NRV_3: Характеристики распределения

**Описание**:
Для случайного вектора (X, Y) с плотностью распределения вида:


$$
f_{X,Y}(x, y) = (\text{коэф.}) \cdot \exp\left(-\frac{1}{2} \big(c_{x^2} x^2 + c_x x + c_{xy} xy + c_y y + c_{y^2} y^2 + \text{константа}\big)\right) \big/ \pi
$$


функция вычисляет следующие характеристики:

1. Математическое ожидание E(X), E(Y).
2. Дисперсии Var(X), Var(Y).
3. Ковариацию Cov(X, Y).
4. Коэффициент корреляции ρ(X, Y).

**Аргументы**:

- `c_x2` (число): Коэффициент при x^2.
- `c_x` (число): Коэффициент при x.
- `c_xy` (число): Коэффициент при xy.
- `c_y` (число): Коэффициент при y.
- `c_y2` (число): Коэффициент при y^2.

**Вывод**:

- Кортеж: (E(X), E(Y), Var(X), Var(Y), Cov(X, Y), ρ(X, Y)).

---

## Общие инструкции

### Формат вывода

Результаты округляются до 4 знаков после запятой с использованием запятой в качестве десятичного разделителя. Пример:

```
P((X - Px)(Y - Py) < 0) = 0,1234
```

### Требования

- Python версии 3.6 или выше.
- Необходимые библиотеки: `numpy`, `scipy`, `sympy`.

### Список функций

Модуль экспортирует список `NRV`, содержащий функции: `NRV_1`, `NRV_2`, `NRV_3`.
