# Выборки из конечной совокупности

Этот модуль предоставляет набор статистических функций для анализа выборок и распределений случайных величин. Каждая функция решает конкретную задачу из теории вероятностей и статистики.

## Описание функций

### `SFFP_1(Omega, n)`

**Описание:**

Функция вычисляет два статистических значения для выборки с возвращением. В группе студентов случайным образом выбирается `n` студентов, оценки которых известны. Функция вычисляет:

* **Дисперсия** для случайной выборки.
* **Центральный момент третьего порядка** для случайной выборки.

**Аргументы:**

* `Omega` (str): Список оценок студентов, представленных как строка, разделенная запятой (например, "85, 90, 78, 88").
* `n` (int): Размер случайной выборки.

**Возвращаемое значение:**

Кортеж с двумя значениями:

* Дисперсия для выборки.
* Центральный момент третьего порядка для выборки.

**Примечание:**

Функция выводит результаты с точностью до трех знаков после запятой и заменой точки на запятую.

---

### `SFFP_2(Omega, n)`

**Описание:**

Функция вычисляет два статистических значения для выборки без возвращения. В группе студентов случайным образом выбирается `n` студентов, но повторный выбор невозможен. Функция вычисляет:

* **Математическое ожидание** для случайной выборки.
* **Дисперсию** для случайной выборки.

**Аргументы:**

* `Omega` (str): Список оценок студентов, представленных как строка.
* `n` (int): Размер случайной выборки.

**Возвращаемое значение:**

Кортеж с двумя значениями:

* Математическое ожидание для выборки.
* Дисперсия для выборки.

**Примечание:**

Результаты выводятся с точностью до трех знаков после запятой и заменой точки на запятую.

---

### `SFFP_3(marks, works, n_prep)`

**Описание:**

Функция вычисляет два статистических значения для распределения баллов на экзамене до перепроверки. Оценки и количество работ на экзамене известны, и работы перепроверяют `n_prep` преподавателей. Функция вычисляет:

* **Математическое ожидание** среднего балла для работ, попавших к одному преподавателю.
* **Стандартное отклонение** для среднего балла.

**Аргументы:**

* `marks` (list): Список оценок студентов.
* `works` (list): Список количеств работ, полученных каждым студентом.
* `n_prep` (int): Количество преподавателей, которые перепроверяют работы.

**Возвращаемое значение:**

Кортеж с двумя значениями:

* Математическое ожидание.
* Стандартное отклонение.

**Примечание:**

Результаты выводятся с точностью до двух и трех знаков после запятой соответственно.

---

### `SFFP_4(text)`

**Описание:**

Функция моделирует подбрасывание двух игральных костей (красной и синей) до тех пор, пока не выпадет `n` различных комбинаций очков (с учетом цвета). Функция вычисляет:

* **Математическое ожидание** для среднего значения случайных величин.
* **Стандартное отклонение** для этих значений.

**Аргументы:**

* `text` (str): Текст условия задачи, в котором заданы коэффициенты для значений на костях и количество комбинаций.

**Возвращаемое значение:**

Кортеж с двумя значениями:

* Математическое ожидание.
* Стандартное отклонение.

**Примечание:**

Результаты выводятся с точностью до одного знака для математического ожидания и трех знаков для стандартного отклонения.

---

### `SFFP_5(n_coins, n_combinations)`

**Описание:**

Функция моделирует подбрасывание монет до тех пор, пока не выпадет `n_combinations` различных комбинаций (с учетом номеров монет). Функция вычисляет:

* **Математическое ожидание** числа орлов в полученных комбинациях.
* **Дисперсию** для этого значения.

**Аргументы:**

* `n_coins` (int): Количество пронумерованных монет.
* `n_combinations` (int): Количество различных комбинаций.

**Возвращаемое значение:**

Кортеж с двумя значениями:

* Математическое ожидание.
* Дисперсия.

**Примечание:**

Результаты выводятся с точностью до одного знака для математического ожидания и трех знаков для дисперсии.

---

### `SFFP_6(X, Y, n_XY, n)`

**Описание:**

Функция анализирует эмпирическое распределение признаков X и Y на генеральной совокупности. Из совокупности случайным образом без возвращения извлекаются `n` элементов. Функция вычисляет:

* **Математическое ожидание** для признака X.
* **Дисперсию** для признака Y.
* **Коэффициент корреляции** между X и Y.

**Аргументы:**

* `X` (list): Все возможные значения признака X.
* `Y` (list): Все возможные значения признака Y.
* `n_XY` (list): Таблица частот для признаков X и Y.
* `n` (int): Количество извлекаемых элементов.

**Возвращаемое значение:**

Кортеж с тремя значениями:

* Математическое ожидание для X.
* Дисперсия для Y.
* Коэффициент корреляции между X и Y.

**Примечание:**

Результаты выводятся с точностью до трех знаков после запятой.

---

### `SFFP_7(X, Y, n_XY, n)`

**Описание:**

Функция анализирует эмпирическое распределение признаков X и Y на генеральной совокупности. Из совокупности случайным образом без возвращения извлекаются `n` элементов. Функция вычисляет:

* **Математическое ожидание** для признака Y.
* **Стандартное отклонение** для признака X.
* **Ковариацию** между X и Y.

**Аргументы:**

* `X` (list): Все возможные значения признака X.
* `Y` (list): Все возможные значения признака Y.
* `n_XY` (list): Таблица частот для признаков X и Y.
* `n` (int): Количество извлекаемых элементов.

**Возвращаемое значение:**

Кортеж с тремя значениями:

* Математическое ожидание для Y.
* Стандартное отклонение для X.
* Ковариация между X и Y.

**Примечание:**

Результаты выводятся с точностью до трех знаков после запятой.

---

## Общие замечания

* Все результаты выводятся в виде строк, с использованием запятой вместо точки, и с точностью до трех знаков после запятой.
* Для округления чисел используется функция `rrstr()`, которая также заменяет точку на запятую в выводе.

---

Этот модуль является полезным инструментом для работы с выборками и распределениями случайных величин, а также для выполнения различных расчетов в задачах теории вероятностей и статистики.
