# Проверка гипотез о значении среднего

## Описание

Этот скрипт реализует два метода проверки гипотез о значении среднего выборки из нормального распределения $N(\mu; \sigma^2)$ при известных и неизвестных стандартных отклонениях ($\sigma$).

### Основные задачи:

1. Проверка гипотезы $H_0: \mu = \mu_0$ против альтернативной гипотезы $H_1: \mu \neq \mu_0$ на уровне значимости $\alpha$.
2. Вычисление:
   - Значения статистики критерия ($T_{набл.}$ или $Z_{набл.}$).
   - Границы $A$ критического множества.
   - $P$-значения критерия и вывод по гипотезе.
   - Мощности $W$ критерия для $\mu_1$.

---

## Функции

### 1. `TMH_1`

**Описание:** Проверка гипотезы при неизвестном стандартном отклонении ($\sigma$) с использованием $t$-распределения.

#### Аргументы:

- `text` *(str)*: Строка чисел (выборка), разделенных указанным символом.
- `mu_0` *(float)*: Значение среднего при гипотезе $H_0$.
- `mu_1` *(float)*: Значение среднего для расчета мощности.
- `alpha` *(float)*: Уровень значимости.
- `splitter` *(str, optional)*: Символ-разделитель. По умолчанию `;`.
- `locale` *(str, optional)*: Если числа разделены точкой, изменить на любое значение. По умолчанию `'rus'`.

#### Возвращаемые значения:

Кортеж из:

1. $T_{набл.}$ — значение статистики критерия.
2. $A$ — граница критического множества.
3. $P$-значение.
4. $W$ — мощность критерия.

---

### 2. `TMH_2`

**Описание:** Проверка гипотезы при известном стандартном отклонении ($\sigma$) с использованием нормального распределения.

#### Аргументы:

- `text` *(str)*: Строка чисел (выборка), разделенных указанным символом.
- `sigma` *(float)*: Известное стандартное отклонение.
- `mu_0` *(float)*: Значение среднего при гипотезе $H_0$.
- `mu_1` *(float)*: Значение среднего для расчета мощности.
- `alpha` *(float)*: Уровень значимости.
- `splitter` *(str, optional)*: Символ-разделитель. По умолчанию `;`.
- `locale` *(str, optional)*: Если числа разделены точкой, изменить на любое значение. По умолчанию `'rus'`.

#### Возвращаемые значения:

Кортеж из:

1. $Z_{набл.}$ — значение статистики критерия.
2. $A$ — граница критического множества.
3. $P$-значение.
4. $W$ — мощность критерия.

---

## Вывод

Функции печатают результаты в локализованном формате (с запятой вместо точки):

- Значение статистики критерия.
- Границы критического множества.
- $P$-значение и вывод по гипотезе ($H_0$ отвергается или принимается).
- Мощность критерия $W$.

---

## Пример использования

### Для неизвестного $\sigma$:

```python
result = TMH_1(
    text="5,6;5,9;6,2;5,8;6,0",
    mu_0=6,
    mu_1=5.5,
    alpha=0.05,
    splitter=";",
    locale="rus"
)
```

### Для известного $\sigma$:

```python
result = TMH_2(
    text="5.1;5.3;5.7;5.5;5.9",
    sigma=0.3,
    mu_0=5.5,
    mu_1=5.0,
    alpha=0.01,
    splitter=";",
    locale="eng"
)
```

---

## Требования

- **Библиотеки:** `numpy`, `scipy`
- Python 3.8+
