# Generated by Django 4.2.6 on 2023-10-31 05:09

import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='General',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'permissions': (('basic_access', 'Can access Secret Santa'), ('manager', 'Can Manage Secret Santa')),
                'managed': False,
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='Webhook',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, verbose_name='Name')),
                ('url', models.URLField(verbose_name='URL')),
                ('enabled', models.BooleanField(default=True)),
            ],
        ),
        migrations.CreateModel(
            name='Year',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('year', models.IntegerField(validators=[django.core.validators.MinValueValidator(2000), django.core.validators.MaxValueValidator(2050)])),
                ('open', models.BooleanField(default=True, verbose_name='Open to Applications')),
            ],
        ),
        migrations.CreateModel(
            name='SecretSantaConfiguration',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('delivery_updates', models.ManyToManyField(help_text='A Santee has marked they have received their gift', to='secretsanta.webhook', verbose_name='Delivery Updates')),
            ],
            options={
                'verbose_name': 'Secret Santa Configuration',
            },
        ),
        migrations.CreateModel(
            name='SantaPair',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('delivered', models.BooleanField(verbose_name='Delivered')),
                ('santa', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='Santa')),
                ('santee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='Santee')),
                ('year', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='secretsanta.year', verbose_name='Year')),
            ],
            options={
                'default_permissions': (),
                'unique_together': {('year', 'santee'), ('year', 'santa')},
            },
        ),
        migrations.CreateModel(
            name='Application',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User')),
                ('year', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='secretsanta.year', verbose_name='Year')),
            ],
            options={
                'default_permissions': (),
                'unique_together': {('year', 'user')},
            },
        ),
    ]
