""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.ipsecvpn.schemas import apis


class IPSecVPNClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(IPSecVPNClient, self).__init__(
            config, transport, middleware, logger
        )

    def describe_remote_vpn_gateway(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeRemoteVPNGateway - 获取客户VPN网关信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **Limit** (int) - 数据分页值, 默认为20
        - **Offset** (int) - 数据偏移量, 默认为0
        - **RemoteVPNGatewayIds** (list) - 客户VPN网关的资源ID，例如RemoteVPNGatewayIds.0代表希望获取客户VPN网关1的信息，RemoteVPNGatewayIds.1代表客户VPN网关2，如果为空，则返回当前Region中所有客户VPN网关实例的信息
        - **Tag** (str) - 业务组名称，若指定则返回业务组下所有客户VPN网关信息

        **Response**

        - **DataSet** (list) - 见 **RemoteVPNGatewayDataSet** 模型定义
        - **TotalCount** (int) - 符合条件的客户VPN网关总数

        **Response Model**

        **RemoteVPNGatewayDataSet**

        - **ActiveTunnels** (str) - 活跃的隧道id
        - **CreateTime** (int) - 创建时间
        - **Remark** (str) - 备注
        - **RemoteVPNGatewayAddr** (str) - 客户网关IP地址
        - **RemoteVPNGatewayId** (str) - 客户网关ID
        - **RemoteVPNGatewayName** (str) - 客户网关名称
        - **Tag** (str) - 用户组
        - **TunnelCount** (int) - 活跃的隧道数量

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeRemoteVPNGatewayRequestSchema().dumps(d)

        resp = self.invoke("DescribeRemoteVPNGateway", d, **kwargs)
        return apis.DescribeRemoteVPNGatewayResponseSchema().loads(resp)

    def describe_vpn_tunnel(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeVPNTunnel - 获取VPN隧道信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **Limit** (int) - 数据分页值, 默认为20
        - **Offset** (int) - 数据偏移量, 默认为0
        - **Tag** (str) - 业务组名称，若指定则返回指定的业务组下的所有VPN网关的信息
        - **VPNTunnelIds** (list) - VPN隧道的资源ID，例如VPNTunnelIds.0代表希望获取信息的VPN隧道1，VPNTunneIds.1代表VPN隧道2，如果为空，则返回当前Region中所有的VPN隧道实例

        **Response**

        - **DataSet** (list) - 见 **VPNTunnelDataSet** 模型定义
        - **TotalCount** (int) - VPN隧道总数

        **Response Model**

        **IPSecData**

        - **IPSecAuthenticationAlgorithm** (str) - IPSec通道中使用的认证算法
        - **IPSecEncryptionAlgorithm** (str) - IPSec通道中使用的加密算法
        - **IPSecLocalSubnetIds** (list) - 指定VPN连接的本地子网，用逗号分隔
        - **IPSecPFSDhGroup** (str) - 是否开启PFS功能,Disable表示关闭，数字表示DH组
        - **IPSecProtocol** (str) - 使用的安全协议，ESP或AH
        - **IPSecRemoteSubnets** (list) - 指定VPN连接的客户网段，用逗号分隔
        - **IPSecSALifetime** (str) - IPSec中SA的生存时间
        - **IPSecSALifetimeBytes** (str) - IPSec中SA的生存时间（以字节计）

        **IKEData**

        - **IKEAuthenticationAlgorithm** (str) - IKE认证算法
        - **IKEDhGroup** (str) - IKEDH组
        - **IKEEncryptionAlgorithm** (str) - IKE加密算法
        - **IKEExchangeMode** (str) - IKEv1协商模式
        - **IKELocalId** (str) - IKE本地ID标识
        - **IKEPreSharedKey** (str) - IKE预共享秘钥
        - **IKERemoteId** (str) - IKE对端ID标识
        - **IKESALifetime** (str) - IKE秘钥生存时间
        - **IKEVersion** (str) - IKE版本

        **VPNTunnelDataSet**

        - **CreateTime** (int) - 创建时间
        - **IKEData** (dict) - 见 **IKEData** 模型定义
        - **IPSecData** (dict) - 见 **IPSecData** 模型定义
        - **Remark** (str) - 备注
        - **RemoteVPNGatewayId** (str) - 对端网关Id
        - **RemoteVPNGatewayName** (str) - 对端网关名字
        - **Tag** (str) - 用户组
        - **VPCId** (str) - 所属VPCId
        - **VPCName** (str) - 所属VOC名字
        - **VPNGatewayId** (str) - 所属VPN网关id
        - **VPNGatewayName** (str) - VPN网关名字
        - **VPNTunnelId** (str) - 隧道id
        - **VPNTunnelName** (str) - 隧道名称

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeVPNTunnelRequestSchema().dumps(d)

        resp = self.invoke("DescribeVPNTunnel", d, **kwargs)
        return apis.DescribeVPNTunnelResponseSchema().loads(resp)
