"""ROM skill_table metadata extracted from const.c."""

from pathlib import Path

from mud.scripts.convert_skills_to_json import parse_skill_table


ROM_SKILL_METADATA: dict[str, dict[str, object]] = {
    "acid blast": {"levels": [28, 53, 35, 32], "ratings": [1, 1, 2, 2], "slot": 70, "min_mana": 20, "beats": 12},
    "acid breath": {"levels": [31, 32, 33, 34], "ratings": [1, 1, 2, 2], "slot": 200, "min_mana": 100, "beats": 24},
    "armor": {"levels": [7, 2, 10, 5], "ratings": [1, 1, 2, 2], "slot": 1, "min_mana": 5, "beats": 12},
    "axe": {"levels": [1, 1, 1, 1], "ratings": [6, 6, 5, 4], "slot": 0, "min_mana": 0, "beats": 0},
    "backstab": {"levels": [53, 53, 1, 53], "ratings": [0, 0, 5, 0], "slot": 0, "min_mana": 0, "beats": 24},
    "bash": {"levels": [53, 53, 53, 1], "ratings": [0, 0, 0, 4], "slot": 0, "min_mana": 0, "beats": 24},
    "berserk": {"levels": [53, 53, 53, 18], "ratings": [0, 0, 0, 5], "slot": 0, "min_mana": 0, "beats": 24},
    "bless": {"levels": [53, 7, 53, 8], "ratings": [1, 1, 2, 2], "slot": 3, "min_mana": 5, "beats": 12},
    "blindness": {"levels": [12, 8, 17, 15], "ratings": [1, 1, 2, 2], "slot": 4, "min_mana": 5, "beats": 12},
    "burning hands": {"levels": [7, 53, 10, 9], "ratings": [1, 1, 2, 2], "slot": 5, "min_mana": 15, "beats": 12},
    "call lightning": {"levels": [26, 18, 31, 22], "ratings": [1, 1, 2, 2], "slot": 6, "min_mana": 15, "beats": 12},
    "calm": {"levels": [48, 16, 50, 20], "ratings": [1, 1, 2, 2], "slot": 509, "min_mana": 30, "beats": 12},
    "cause critical": {"levels": [53, 13, 53, 19], "ratings": [1, 1, 2, 2], "slot": 63, "min_mana": 20, "beats": 12},
    "cause light": {"levels": [53, 1, 53, 3], "ratings": [1, 1, 2, 2], "slot": 62, "min_mana": 15, "beats": 12},
    "cause serious": {"levels": [53, 7, 53, 10], "ratings": [1, 1, 2, 2], "slot": 64, "min_mana": 17, "beats": 12},
    "chain lightning": {"levels": [33, 53, 39, 36], "ratings": [1, 1, 2, 2], "slot": 500, "min_mana": 25, "beats": 12},
    "change sex": {"levels": [53, 53, 53, 53], "ratings": [1, 1, 2, 2], "slot": 82, "min_mana": 15, "beats": 12},
    "charm person": {"levels": [20, 53, 25, 53], "ratings": [1, 1, 2, 2], "slot": 7, "min_mana": 5, "beats": 12},
    "chill touch": {"levels": [4, 53, 6, 6], "ratings": [1, 1, 2, 2], "slot": 8, "min_mana": 15, "beats": 12},
    "colour spray": {"levels": [16, 53, 22, 20], "ratings": [1, 1, 2, 2], "slot": 10, "min_mana": 15, "beats": 12},
    "continual light": {"levels": [6, 4, 6, 9], "ratings": [1, 1, 2, 2], "slot": 57, "min_mana": 7, "beats": 12},
    "control weather": {"levels": [15, 19, 28, 22], "ratings": [1, 1, 2, 2], "slot": 11, "min_mana": 25, "beats": 12},
    "create food": {"levels": [10, 5, 11, 12], "ratings": [1, 1, 2, 2], "slot": 12, "min_mana": 5, "beats": 12},
    "create rose": {"levels": [16, 11, 10, 24], "ratings": [1, 1, 2, 2], "slot": 511, "min_mana": 30, "beats": 12},
    "create spring": {"levels": [14, 17, 23, 20], "ratings": [1, 1, 2, 2], "slot": 80, "min_mana": 20, "beats": 12},
    "create water": {"levels": [8, 3, 12, 11], "ratings": [1, 1, 2, 2], "slot": 13, "min_mana": 5, "beats": 12},
    "cure blindness": {"levels": [53, 6, 53, 8], "ratings": [1, 1, 2, 2], "slot": 14, "min_mana": 5, "beats": 12},
    "cure critical": {"levels": [53, 13, 53, 19], "ratings": [1, 1, 2, 2], "slot": 15, "min_mana": 20, "beats": 12},
    "cure disease": {"levels": [53, 13, 53, 14], "ratings": [1, 1, 2, 2], "slot": 501, "min_mana": 20, "beats": 12},
    "cure light": {"levels": [53, 1, 53, 3], "ratings": [1, 1, 2, 2], "slot": 16, "min_mana": 10, "beats": 12},
    "cure poison": {"levels": [53, 14, 53, 16], "ratings": [1, 1, 2, 2], "slot": 43, "min_mana": 5, "beats": 12},
    "cure serious": {"levels": [53, 7, 53, 10], "ratings": [1, 1, 2, 2], "slot": 61, "min_mana": 15, "beats": 12},
    "curse": {"levels": [18, 18, 26, 22], "ratings": [1, 1, 2, 2], "slot": 17, "min_mana": 20, "beats": 12},
    "dagger": {"levels": [1, 1, 1, 1], "ratings": [2, 3, 2, 2], "slot": 0, "min_mana": 0, "beats": 0},
    "demonfire": {"levels": [53, 34, 53, 45], "ratings": [1, 1, 2, 2], "slot": 505, "min_mana": 20, "beats": 12},
    "detect evil": {"levels": [11, 4, 12, 53], "ratings": [1, 1, 2, 2], "slot": 18, "min_mana": 5, "beats": 12},
    "detect good": {"levels": [11, 4, 12, 53], "ratings": [1, 1, 2, 2], "slot": 513, "min_mana": 5, "beats": 12},
    "detect hidden": {"levels": [15, 11, 12, 53], "ratings": [1, 1, 2, 2], "slot": 44, "min_mana": 5, "beats": 12},
    "detect invis": {"levels": [3, 8, 6, 53], "ratings": [1, 1, 2, 2], "slot": 19, "min_mana": 5, "beats": 12},
    "detect magic": {"levels": [2, 6, 5, 53], "ratings": [1, 1, 2, 2], "slot": 20, "min_mana": 5, "beats": 12},
    "detect poison": {"levels": [15, 7, 9, 53], "ratings": [1, 1, 2, 2], "slot": 21, "min_mana": 5, "beats": 12},
    "dirt kicking": {"levels": [53, 53, 3, 3], "ratings": [0, 0, 4, 4], "slot": 0, "min_mana": 0, "beats": 24},
    "disarm": {"levels": [53, 53, 12, 11], "ratings": [0, 0, 6, 4], "slot": 0, "min_mana": 0, "beats": 24},
    "dispel evil": {"levels": [53, 15, 53, 21], "ratings": [1, 1, 2, 2], "slot": 22, "min_mana": 15, "beats": 12},
    "dispel good": {"levels": [53, 15, 53, 21], "ratings": [1, 1, 2, 2], "slot": 512, "min_mana": 15, "beats": 12},
    "dispel magic": {"levels": [16, 24, 30, 30], "ratings": [1, 1, 2, 2], "slot": 59, "min_mana": 15, "beats": 12},
    "dodge": {"levels": [20, 22, 1, 13], "ratings": [8, 8, 4, 6], "slot": 0, "min_mana": 0, "beats": 0},
    "earthquake": {"levels": [53, 10, 53, 14], "ratings": [1, 1, 2, 2], "slot": 23, "min_mana": 15, "beats": 12},
    "enchant armor": {"levels": [16, 53, 53, 53], "ratings": [2, 2, 4, 4], "slot": 510, "min_mana": 100, "beats": 24},
    "enchant weapon": {"levels": [17, 53, 53, 53], "ratings": [2, 2, 4, 4], "slot": 24, "min_mana": 100, "beats": 24},
    "energy drain": {"levels": [19, 22, 26, 23], "ratings": [1, 1, 2, 2], "slot": 25, "min_mana": 35, "beats": 12},
    "enhanced damage": {"levels": [45, 30, 25, 1], "ratings": [10, 9, 5, 3], "slot": 0, "min_mana": 0, "beats": 0},
    "envenom": {"levels": [53, 53, 10, 53], "ratings": [0, 0, 4, 0], "slot": 0, "min_mana": 0, "beats": 36},
    "faerie fire": {"levels": [6, 3, 5, 8], "ratings": [1, 1, 2, 2], "slot": 72, "min_mana": 5, "beats": 12},
    "faerie fog": {"levels": [14, 21, 16, 24], "ratings": [1, 1, 2, 2], "slot": 73, "min_mana": 12, "beats": 12},
    "farsight": {"levels": [14, 16, 16, 53], "ratings": [1, 1, 2, 2], "slot": 521, "min_mana": 36, "beats": 20},
    "fast healing": {"levels": [15, 9, 16, 6], "ratings": [8, 5, 6, 4], "slot": 0, "min_mana": 0, "beats": 0},
    "fire breath": {"levels": [40, 45, 50, 51], "ratings": [1, 1, 2, 2], "slot": 201, "min_mana": 200, "beats": 24},
    "fireball": {"levels": [22, 53, 30, 26], "ratings": [1, 1, 2, 2], "slot": 26, "min_mana": 15, "beats": 12},
    "fireproof": {"levels": [13, 12, 19, 18], "ratings": [1, 1, 2, 2], "slot": 523, "min_mana": 10, "beats": 12},
    "flail": {"levels": [1, 1, 1, 1], "ratings": [6, 3, 6, 4], "slot": 0, "min_mana": 0, "beats": 0},
    "flamestrike": {"levels": [53, 20, 53, 27], "ratings": [1, 1, 2, 2], "slot": 65, "min_mana": 20, "beats": 12},
    "floating disc": {"levels": [4, 10, 7, 16], "ratings": [1, 1, 2, 2], "slot": 522, "min_mana": 40, "beats": 24},
    "fly": {"levels": [10, 18, 20, 22], "ratings": [1, 1, 2, 2], "slot": 56, "min_mana": 10, "beats": 18},
    "frenzy": {"levels": [53, 24, 53, 26], "ratings": [1, 1, 2, 2], "slot": 504, "min_mana": 30, "beats": 24},
    "frost breath": {"levels": [34, 36, 38, 40], "ratings": [1, 1, 2, 2], "slot": 202, "min_mana": 125, "beats": 24},
    "gas breath": {"levels": [39, 43, 47, 50], "ratings": [1, 1, 2, 2], "slot": 203, "min_mana": 175, "beats": 24},
    "gate": {"levels": [27, 17, 32, 28], "ratings": [1, 1, 2, 2], "slot": 83, "min_mana": 80, "beats": 12},
    "general purpose": {"levels": [53, 53, 53, 53], "ratings": [0, 0, 0, 0], "slot": 401, "min_mana": 0, "beats": 12},
    "giant strength": {"levels": [11, 53, 22, 20], "ratings": [1, 1, 2, 2], "slot": 39, "min_mana": 20, "beats": 12},
    "haggle": {"levels": [7, 18, 1, 14], "ratings": [5, 8, 3, 6], "slot": 0, "min_mana": 0, "beats": 0},
    "hand to hand": {"levels": [25, 10, 15, 6], "ratings": [8, 5, 6, 4], "slot": 0, "min_mana": 0, "beats": 0},
    "haste": {"levels": [21, 53, 26, 29], "ratings": [1, 1, 2, 2], "slot": 502, "min_mana": 30, "beats": 12},
    "heal": {"levels": [53, 21, 33, 30], "ratings": [1, 1, 2, 2], "slot": 28, "min_mana": 50, "beats": 12},
    "heat metal": {"levels": [53, 16, 53, 23], "ratings": [1, 1, 2, 2], "slot": 516, "min_mana": 25, "beats": 18},
    "hide": {"levels": [53, 53, 1, 12], "ratings": [0, 0, 4, 6], "slot": 0, "min_mana": 0, "beats": 12},
    "high explosive": {"levels": [53, 53, 53, 53], "ratings": [0, 0, 0, 0], "slot": 402, "min_mana": 0, "beats": 12},
    "holy word": {"levels": [53, 36, 53, 42], "ratings": [2, 2, 4, 4], "slot": 506, "min_mana": 200, "beats": 24},
    "identify": {"levels": [15, 16, 18, 53], "ratings": [1, 1, 2, 2], "slot": 53, "min_mana": 12, "beats": 24},
    "infravision": {"levels": [9, 13, 10, 16], "ratings": [1, 1, 2, 2], "slot": 77, "min_mana": 5, "beats": 18},
    "invisibility": {"levels": [5, 53, 9, 53], "ratings": [1, 1, 2, 2], "slot": 29, "min_mana": 5, "beats": 12},
    "kick": {"levels": [53, 12, 14, 8], "ratings": [0, 4, 6, 3], "slot": 0, "min_mana": 0, "beats": 12},
    "know alignment": {"levels": [12, 9, 20, 53], "ratings": [1, 1, 2, 2], "slot": 58, "min_mana": 9, "beats": 12},
    "lightning bolt": {"levels": [13, 23, 18, 16], "ratings": [1, 1, 2, 2], "slot": 30, "min_mana": 15, "beats": 12},
    "lightning breath": {
        "levels": [37, 40, 43, 46],
        "ratings": [1, 1, 2, 2],
        "slot": 204,
        "min_mana": 150,
        "beats": 24,
    },
    "locate object": {"levels": [9, 15, 11, 53], "ratings": [1, 1, 2, 2], "slot": 31, "min_mana": 20, "beats": 18},
    "lore": {"levels": [10, 10, 6, 20], "ratings": [6, 6, 4, 8], "slot": 0, "min_mana": 0, "beats": 36},
    "mace": {"levels": [1, 1, 1, 1], "ratings": [5, 2, 3, 3], "slot": 0, "min_mana": 0, "beats": 0},
    "magic missile": {"levels": [1, 53, 2, 2], "ratings": [1, 1, 2, 2], "slot": 32, "min_mana": 15, "beats": 12},
    "mass healing": {"levels": [53, 38, 53, 46], "ratings": [2, 2, 4, 4], "slot": 508, "min_mana": 100, "beats": 36},
    "mass invis": {"levels": [22, 25, 31, 53], "ratings": [1, 1, 2, 2], "slot": 69, "min_mana": 20, "beats": 24},
    "meditation": {"levels": [6, 6, 15, 15], "ratings": [5, 5, 8, 8], "slot": 0, "min_mana": 0, "beats": 0},
    "nexus": {"levels": [40, 35, 50, 45], "ratings": [2, 2, 4, 4], "slot": 520, "min_mana": 150, "beats": 36},
    "parry": {"levels": [22, 20, 13, 1], "ratings": [8, 8, 6, 4], "slot": 0, "min_mana": 0, "beats": 0},
    "pass door": {"levels": [24, 32, 25, 37], "ratings": [1, 1, 2, 2], "slot": 74, "min_mana": 20, "beats": 12},
    "peek": {"levels": [8, 21, 1, 14], "ratings": [5, 7, 3, 6], "slot": 0, "min_mana": 0, "beats": 0},
    "pick lock": {"levels": [25, 25, 7, 25], "ratings": [8, 8, 4, 8], "slot": 0, "min_mana": 0, "beats": 12},
    "plague": {"levels": [23, 17, 36, 26], "ratings": [1, 1, 2, 2], "slot": 503, "min_mana": 20, "beats": 12},
    "poison": {"levels": [17, 12, 15, 21], "ratings": [1, 1, 2, 2], "slot": 33, "min_mana": 10, "beats": 12},
    "polearm": {"levels": [1, 1, 1, 1], "ratings": [6, 6, 6, 4], "slot": 0, "min_mana": 0, "beats": 0},
    "portal": {"levels": [35, 30, 45, 40], "ratings": [2, 2, 4, 4], "slot": 519, "min_mana": 100, "beats": 24},
    "protection evil": {"levels": [12, 9, 17, 11], "ratings": [1, 1, 2, 2], "slot": 34, "min_mana": 5, "beats": 12},
    "protection good": {"levels": [12, 9, 17, 11], "ratings": [1, 1, 2, 2], "slot": 514, "min_mana": 5, "beats": 12},
    "ray of truth": {"levels": [53, 35, 53, 47], "ratings": [1, 1, 2, 2], "slot": 518, "min_mana": 20, "beats": 12},
    "recall": {"levels": [1, 1, 1, 1], "ratings": [2, 2, 2, 2], "slot": 0, "min_mana": 0, "beats": 12},
    "recharge": {"levels": [9, 53, 53, 53], "ratings": [1, 1, 2, 2], "slot": 517, "min_mana": 60, "beats": 24},
    "refresh": {"levels": [8, 5, 12, 9], "ratings": [1, 1, 2, 2], "slot": 81, "min_mana": 12, "beats": 18},
    "remove curse": {"levels": [53, 18, 53, 22], "ratings": [1, 1, 2, 2], "slot": 35, "min_mana": 5, "beats": 12},
    "rescue": {"levels": [53, 53, 53, 1], "ratings": [0, 0, 0, 4], "slot": 0, "min_mana": 0, "beats": 12},
    "sanctuary": {"levels": [36, 20, 42, 30], "ratings": [1, 1, 2, 2], "slot": 36, "min_mana": 75, "beats": 12},
    "scrolls": {"levels": [1, 1, 1, 1], "ratings": [2, 3, 5, 8], "slot": 0, "min_mana": 0, "beats": 24},
    "second attack": {"levels": [30, 24, 12, 5], "ratings": [10, 8, 5, 3], "slot": 0, "min_mana": 0, "beats": 0},
    "shield": {"levels": [20, 35, 35, 40], "ratings": [1, 1, 2, 2], "slot": 67, "min_mana": 12, "beats": 18},
    "shield block": {"levels": [1, 1, 1, 1], "ratings": [6, 4, 6, 2], "slot": 0, "min_mana": 0, "beats": 0},
    "shocking grasp": {"levels": [10, 53, 14, 13], "ratings": [1, 1, 2, 2], "slot": 53, "min_mana": 15, "beats": 12},
    "sleep": {"levels": [10, 53, 11, 53], "ratings": [1, 1, 2, 2], "slot": 38, "min_mana": 15, "beats": 12},
    "slow": {"levels": [23, 30, 29, 32], "ratings": [1, 1, 2, 2], "slot": 515, "min_mana": 30, "beats": 12},
    "sneak": {"levels": [53, 53, 4, 10], "ratings": [0, 0, 4, 6], "slot": 0, "min_mana": 0, "beats": 12},
    "spear": {"levels": [1, 1, 1, 1], "ratings": [4, 4, 4, 3], "slot": 0, "min_mana": 0, "beats": 0},
    "staves": {"levels": [1, 1, 1, 1], "ratings": [2, 3, 5, 8], "slot": 0, "min_mana": 0, "beats": 12},
    "steal": {"levels": [53, 53, 5, 53], "ratings": [0, 0, 4, 0], "slot": 0, "min_mana": 0, "beats": 24},
    "stone skin": {"levels": [25, 40, 40, 45], "ratings": [1, 1, 2, 2], "slot": 66, "min_mana": 12, "beats": 18},
    "summon": {"levels": [24, 12, 29, 22], "ratings": [1, 1, 2, 2], "slot": 40, "min_mana": 50, "beats": 12},
    "sword": {"levels": [1, 1, 1, 1], "ratings": [5, 6, 3, 2], "slot": 0, "min_mana": 0, "beats": 0},
    "teleport": {"levels": [13, 22, 25, 36], "ratings": [1, 1, 2, 2], "slot": 2, "min_mana": 35, "beats": 12},
    "third attack": {"levels": [53, 53, 24, 12], "ratings": [0, 0, 10, 4], "slot": 0, "min_mana": 0, "beats": 0},
    "trip": {"levels": [53, 53, 1, 15], "ratings": [0, 0, 4, 8], "slot": 0, "min_mana": 0, "beats": 24},
    "ventriloquate": {"levels": [1, 53, 2, 53], "ratings": [1, 1, 2, 2], "slot": 41, "min_mana": 5, "beats": 12},
    "wands": {"levels": [1, 1, 1, 1], "ratings": [2, 3, 5, 8], "slot": 0, "min_mana": 0, "beats": 12},
    "weaken": {"levels": [11, 14, 16, 17], "ratings": [1, 1, 2, 2], "slot": 68, "min_mana": 20, "beats": 12},
    "whip": {"levels": [1, 1, 1, 1], "ratings": [6, 5, 5, 4], "slot": 0, "min_mana": 0, "beats": 0},
    "word of recall": {"levels": [32, 28, 40, 30], "ratings": [1, 1, 2, 2], "slot": 42, "min_mana": 5, "beats": 12},
}


def _load_skill_names() -> tuple[str, ...]:
    """Return ROM skill_table names indexed by skill number (including reserved slot)."""

    const_path = Path(__file__).resolve().parents[2] / "src" / "const.c"
    entries = parse_skill_table(const_path)
    names = ["reserved"]
    names.extend(entry["name"] for entry in entries)
    return tuple(names)


ROM_SKILL_NAMES_BY_INDEX = _load_skill_names()
