import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AzurermProviderConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#auxiliary_tenant_ids AzurermProvider#auxiliary_tenant_ids}
    */
    readonly auxiliaryTenantIds?: string[];
    /**
    * The password associated with the Client Certificate. For use when authenticating as a Service Principal using a Client Certificate
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#client_certificate_password AzurermProvider#client_certificate_password}
    */
    readonly clientCertificatePassword?: string;
    /**
    * The path to the Client Certificate associated with the Service Principal for use when authenticating as a Service Principal using a Client Certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#client_certificate_path AzurermProvider#client_certificate_path}
    */
    readonly clientCertificatePath?: string;
    /**
    * The Client ID which should be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#client_id AzurermProvider#client_id}
    */
    readonly clientId?: string;
    /**
    * The Client Secret which should be used. For use When authenticating as a Service Principal using a Client Secret.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#client_secret AzurermProvider#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * This will disable the x-ms-correlation-request-id header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#disable_correlation_request_id AzurermProvider#disable_correlation_request_id}
    */
    readonly disableCorrelationRequestId?: boolean | cdktf.IResolvable;
    /**
    * This will disable the Terraform Partner ID which is used if a custom `partner_id` isn't specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#disable_terraform_partner_id AzurermProvider#disable_terraform_partner_id}
    */
    readonly disableTerraformPartnerId?: boolean | cdktf.IResolvable;
    /**
    * The Cloud Environment which should be used. Possible values are public, usgovernment, and china. Defaults to public.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#environment AzurermProvider#environment}
    */
    readonly environment?: string;
    /**
    * The Hostname which should be used for the Azure Metadata Service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#metadata_host AzurermProvider#metadata_host}
    */
    readonly metadataHost?: string;
    /**
    * The path to a custom endpoint for Managed Service Identity - in most circumstances this should be detected automatically.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#msi_endpoint AzurermProvider#msi_endpoint}
    */
    readonly msiEndpoint?: string;
    /**
    * The bearer token for the request to the OIDC provider. For use When authenticating as a Service Principal using OpenID Connect.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#oidc_request_token AzurermProvider#oidc_request_token}
    */
    readonly oidcRequestToken?: string;
    /**
    * The URL for the OIDC provider from which to request an ID token. For use When authenticating as a Service Principal using OpenID Connect.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#oidc_request_url AzurermProvider#oidc_request_url}
    */
    readonly oidcRequestUrl?: string;
    /**
    * A GUID/UUID that is registered with Microsoft to facilitate partner resource usage attribution.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#partner_id AzurermProvider#partner_id}
    */
    readonly partnerId?: string;
    /**
    * Should the AzureRM Provider skip registering all of the Resource Providers that it supports, if they're not already registered?
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#skip_provider_registration AzurermProvider#skip_provider_registration}
    */
    readonly skipProviderRegistration?: boolean | cdktf.IResolvable;
    /**
    * Should the AzureRM Provider use AzureAD to access the Storage Data Plane API's?
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#storage_use_azuread AzurermProvider#storage_use_azuread}
    */
    readonly storageUseAzuread?: boolean | cdktf.IResolvable;
    /**
    * The Subscription ID which should be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#subscription_id AzurermProvider#subscription_id}
    */
    readonly subscriptionId?: string;
    /**
    * The Tenant ID which should be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#tenant_id AzurermProvider#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * Allowed Managed Service Identity be used for Authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#use_msi AzurermProvider#use_msi}
    */
    readonly useMsi?: boolean | cdktf.IResolvable;
    /**
    * Allow OpenID Connect to be used for authentication
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#use_oidc AzurermProvider#use_oidc}
    */
    readonly useOidc?: boolean | cdktf.IResolvable;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#alias AzurermProvider#alias}
    */
    readonly alias?: string;
    /**
    * features block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#features AzurermProvider#features}
    */
    readonly features: AzurermProviderFeatures;
}
export interface AzurermProviderFeaturesApiManagement {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#purge_soft_delete_on_destroy AzurermProvider#purge_soft_delete_on_destroy}
    */
    readonly purgeSoftDeleteOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#recover_soft_deleted AzurermProvider#recover_soft_deleted}
    */
    readonly recoverSoftDeleted?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesApiManagementToTerraform(struct?: AzurermProviderFeaturesApiManagement): any;
export interface AzurermProviderFeaturesApplicationInsights {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#disable_generated_rule AzurermProvider#disable_generated_rule}
    */
    readonly disableGeneratedRule?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesApplicationInsightsToTerraform(struct?: AzurermProviderFeaturesApplicationInsights): any;
export interface AzurermProviderFeaturesCognitiveAccount {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#purge_soft_delete_on_destroy AzurermProvider#purge_soft_delete_on_destroy}
    */
    readonly purgeSoftDeleteOnDestroy?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesCognitiveAccountToTerraform(struct?: AzurermProviderFeaturesCognitiveAccount): any;
export interface AzurermProviderFeaturesKeyVault {
    /**
    * When enabled soft-deleted `azurerm_key_vault` resources will be permanently deleted (e.g purged), when destroyed
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#purge_soft_delete_on_destroy AzurermProvider#purge_soft_delete_on_destroy}
    */
    readonly purgeSoftDeleteOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * When enabled soft-deleted `azurerm_key_vault_certificate` resources will be permanently deleted (e.g purged), when destroyed
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#purge_soft_deleted_certificates_on_destroy AzurermProvider#purge_soft_deleted_certificates_on_destroy}
    */
    readonly purgeSoftDeletedCertificatesOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * When enabled soft-deleted `azurerm_key_vault_managed_hardware_security_module` resources will be permanently deleted (e.g purged), when destroyed
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#purge_soft_deleted_hardware_security_modules_on_destroy AzurermProvider#purge_soft_deleted_hardware_security_modules_on_destroy}
    */
    readonly purgeSoftDeletedHardwareSecurityModulesOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * When enabled soft-deleted `azurerm_key_vault_key` resources will be permanently deleted (e.g purged), when destroyed
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#purge_soft_deleted_keys_on_destroy AzurermProvider#purge_soft_deleted_keys_on_destroy}
    */
    readonly purgeSoftDeletedKeysOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * When enabled soft-deleted `azurerm_key_vault_secret` resources will be permanently deleted (e.g purged), when destroyed
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#purge_soft_deleted_secrets_on_destroy AzurermProvider#purge_soft_deleted_secrets_on_destroy}
    */
    readonly purgeSoftDeletedSecretsOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * When enabled soft-deleted `azurerm_key_vault_certificate` resources will be restored, instead of creating new ones
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#recover_soft_deleted_certificates AzurermProvider#recover_soft_deleted_certificates}
    */
    readonly recoverSoftDeletedCertificates?: boolean | cdktf.IResolvable;
    /**
    * When enabled soft-deleted `azurerm_key_vault` resources will be restored, instead of creating new ones
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#recover_soft_deleted_key_vaults AzurermProvider#recover_soft_deleted_key_vaults}
    */
    readonly recoverSoftDeletedKeyVaults?: boolean | cdktf.IResolvable;
    /**
    * When enabled soft-deleted `azurerm_key_vault_key` resources will be restored, instead of creating new ones
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#recover_soft_deleted_keys AzurermProvider#recover_soft_deleted_keys}
    */
    readonly recoverSoftDeletedKeys?: boolean | cdktf.IResolvable;
    /**
    * When enabled soft-deleted `azurerm_key_vault_secret` resources will be restored, instead of creating new ones
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#recover_soft_deleted_secrets AzurermProvider#recover_soft_deleted_secrets}
    */
    readonly recoverSoftDeletedSecrets?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesKeyVaultToTerraform(struct?: AzurermProviderFeaturesKeyVault): any;
export interface AzurermProviderFeaturesLogAnalyticsWorkspace {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#permanently_delete_on_destroy AzurermProvider#permanently_delete_on_destroy}
    */
    readonly permanentlyDeleteOnDestroy?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform(struct?: AzurermProviderFeaturesLogAnalyticsWorkspace): any;
export interface AzurermProviderFeaturesNetwork {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#relaxed_locking AzurermProvider#relaxed_locking}
    */
    readonly relaxedLocking: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesNetworkToTerraform(struct?: AzurermProviderFeaturesNetwork): any;
export interface AzurermProviderFeaturesResourceGroup {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#prevent_deletion_if_contains_resources AzurermProvider#prevent_deletion_if_contains_resources}
    */
    readonly preventDeletionIfContainsResources?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesResourceGroupToTerraform(struct?: AzurermProviderFeaturesResourceGroup): any;
export interface AzurermProviderFeaturesTemplateDeployment {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#delete_nested_items_during_deletion AzurermProvider#delete_nested_items_during_deletion}
    */
    readonly deleteNestedItemsDuringDeletion: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesTemplateDeploymentToTerraform(struct?: AzurermProviderFeaturesTemplateDeployment): any;
export interface AzurermProviderFeaturesVirtualMachine {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#delete_os_disk_on_deletion AzurermProvider#delete_os_disk_on_deletion}
    */
    readonly deleteOsDiskOnDeletion?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#graceful_shutdown AzurermProvider#graceful_shutdown}
    */
    readonly gracefulShutdown?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#skip_shutdown_and_force_delete AzurermProvider#skip_shutdown_and_force_delete}
    */
    readonly skipShutdownAndForceDelete?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesVirtualMachineToTerraform(struct?: AzurermProviderFeaturesVirtualMachine): any;
export interface AzurermProviderFeaturesVirtualMachineScaleSet {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#force_delete AzurermProvider#force_delete}
    */
    readonly forceDelete?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#roll_instances_when_required AzurermProvider#roll_instances_when_required}
    */
    readonly rollInstancesWhenRequired: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#scale_to_zero_before_deletion AzurermProvider#scale_to_zero_before_deletion}
    */
    readonly scaleToZeroBeforeDeletion?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesVirtualMachineScaleSetToTerraform(struct?: AzurermProviderFeaturesVirtualMachineScaleSet): any;
export interface AzurermProviderFeatures {
    /**
    * api_management block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#api_management AzurermProvider#api_management}
    */
    readonly apiManagement?: AzurermProviderFeaturesApiManagement;
    /**
    * application_insights block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#application_insights AzurermProvider#application_insights}
    */
    readonly applicationInsights?: AzurermProviderFeaturesApplicationInsights;
    /**
    * cognitive_account block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#cognitive_account AzurermProvider#cognitive_account}
    */
    readonly cognitiveAccount?: AzurermProviderFeaturesCognitiveAccount;
    /**
    * key_vault block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#key_vault AzurermProvider#key_vault}
    */
    readonly keyVault?: AzurermProviderFeaturesKeyVault;
    /**
    * log_analytics_workspace block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#log_analytics_workspace AzurermProvider#log_analytics_workspace}
    */
    readonly logAnalyticsWorkspace?: AzurermProviderFeaturesLogAnalyticsWorkspace;
    /**
    * network block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#network AzurermProvider#network}
    */
    readonly network?: AzurermProviderFeaturesNetwork;
    /**
    * resource_group block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#resource_group AzurermProvider#resource_group}
    */
    readonly resourceGroup?: AzurermProviderFeaturesResourceGroup;
    /**
    * template_deployment block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#template_deployment AzurermProvider#template_deployment}
    */
    readonly templateDeployment?: AzurermProviderFeaturesTemplateDeployment;
    /**
    * virtual_machine block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#virtual_machine AzurermProvider#virtual_machine}
    */
    readonly virtualMachine?: AzurermProviderFeaturesVirtualMachine;
    /**
    * virtual_machine_scale_set block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#virtual_machine_scale_set AzurermProvider#virtual_machine_scale_set}
    */
    readonly virtualMachineScaleSet?: AzurermProviderFeaturesVirtualMachineScaleSet;
}
export declare function azurermProviderFeaturesToTerraform(struct?: AzurermProviderFeatures): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm azurerm}
*/
export declare class AzurermProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "azurerm";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm azurerm} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AzurermProviderConfig
    */
    constructor(scope: Construct, id: string, config: AzurermProviderConfig);
    private _auxiliaryTenantIds?;
    get auxiliaryTenantIds(): string[] | undefined;
    set auxiliaryTenantIds(value: string[] | undefined);
    resetAuxiliaryTenantIds(): void;
    get auxiliaryTenantIdsInput(): string[] | undefined;
    private _clientCertificatePassword?;
    get clientCertificatePassword(): string | undefined;
    set clientCertificatePassword(value: string | undefined);
    resetClientCertificatePassword(): void;
    get clientCertificatePasswordInput(): string | undefined;
    private _clientCertificatePath?;
    get clientCertificatePath(): string | undefined;
    set clientCertificatePath(value: string | undefined);
    resetClientCertificatePath(): void;
    get clientCertificatePathInput(): string | undefined;
    private _clientId?;
    get clientId(): string | undefined;
    set clientId(value: string | undefined);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string | undefined;
    set clientSecret(value: string | undefined);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _disableCorrelationRequestId?;
    get disableCorrelationRequestId(): boolean | cdktf.IResolvable | undefined;
    set disableCorrelationRequestId(value: boolean | cdktf.IResolvable | undefined);
    resetDisableCorrelationRequestId(): void;
    get disableCorrelationRequestIdInput(): boolean | cdktf.IResolvable | undefined;
    private _disableTerraformPartnerId?;
    get disableTerraformPartnerId(): boolean | cdktf.IResolvable | undefined;
    set disableTerraformPartnerId(value: boolean | cdktf.IResolvable | undefined);
    resetDisableTerraformPartnerId(): void;
    get disableTerraformPartnerIdInput(): boolean | cdktf.IResolvable | undefined;
    private _environment?;
    get environment(): string | undefined;
    set environment(value: string | undefined);
    resetEnvironment(): void;
    get environmentInput(): string | undefined;
    private _metadataHost?;
    get metadataHost(): string | undefined;
    set metadataHost(value: string | undefined);
    resetMetadataHost(): void;
    get metadataHostInput(): string | undefined;
    private _msiEndpoint?;
    get msiEndpoint(): string | undefined;
    set msiEndpoint(value: string | undefined);
    resetMsiEndpoint(): void;
    get msiEndpointInput(): string | undefined;
    private _oidcRequestToken?;
    get oidcRequestToken(): string | undefined;
    set oidcRequestToken(value: string | undefined);
    resetOidcRequestToken(): void;
    get oidcRequestTokenInput(): string | undefined;
    private _oidcRequestUrl?;
    get oidcRequestUrl(): string | undefined;
    set oidcRequestUrl(value: string | undefined);
    resetOidcRequestUrl(): void;
    get oidcRequestUrlInput(): string | undefined;
    private _partnerId?;
    get partnerId(): string | undefined;
    set partnerId(value: string | undefined);
    resetPartnerId(): void;
    get partnerIdInput(): string | undefined;
    private _skipProviderRegistration?;
    get skipProviderRegistration(): boolean | cdktf.IResolvable | undefined;
    set skipProviderRegistration(value: boolean | cdktf.IResolvable | undefined);
    resetSkipProviderRegistration(): void;
    get skipProviderRegistrationInput(): boolean | cdktf.IResolvable | undefined;
    private _storageUseAzuread?;
    get storageUseAzuread(): boolean | cdktf.IResolvable | undefined;
    set storageUseAzuread(value: boolean | cdktf.IResolvable | undefined);
    resetStorageUseAzuread(): void;
    get storageUseAzureadInput(): boolean | cdktf.IResolvable | undefined;
    private _subscriptionId?;
    get subscriptionId(): string | undefined;
    set subscriptionId(value: string | undefined);
    resetSubscriptionId(): void;
    get subscriptionIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string | undefined;
    set tenantId(value: string | undefined);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _useMsi?;
    get useMsi(): boolean | cdktf.IResolvable | undefined;
    set useMsi(value: boolean | cdktf.IResolvable | undefined);
    resetUseMsi(): void;
    get useMsiInput(): boolean | cdktf.IResolvable | undefined;
    private _useOidc?;
    get useOidc(): boolean | cdktf.IResolvable | undefined;
    set useOidc(value: boolean | cdktf.IResolvable | undefined);
    resetUseOidc(): void;
    get useOidcInput(): boolean | cdktf.IResolvable | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _features?;
    get features(): AzurermProviderFeatures | undefined;
    set features(value: AzurermProviderFeatures | undefined);
    get featuresInput(): AzurermProviderFeatures | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
