"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AzurermProvider = exports.azurermProviderFeaturesToTerraform = exports.azurermProviderFeaturesVirtualMachineScaleSetToTerraform = exports.azurermProviderFeaturesVirtualMachineToTerraform = exports.azurermProviderFeaturesTemplateDeploymentToTerraform = exports.azurermProviderFeaturesResourceGroupToTerraform = exports.azurermProviderFeaturesNetworkToTerraform = exports.azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform = exports.azurermProviderFeaturesKeyVaultToTerraform = exports.azurermProviderFeaturesCognitiveAccountToTerraform = exports.azurermProviderFeaturesApplicationInsightsToTerraform = exports.azurermProviderFeaturesApiManagementToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function azurermProviderFeaturesApiManagementToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        purge_soft_delete_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeleteOnDestroy),
        recover_soft_deleted: cdktf.booleanToTerraform(struct.recoverSoftDeleted),
    };
}
exports.azurermProviderFeaturesApiManagementToTerraform = azurermProviderFeaturesApiManagementToTerraform;
function azurermProviderFeaturesApplicationInsightsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        disable_generated_rule: cdktf.booleanToTerraform(struct.disableGeneratedRule),
    };
}
exports.azurermProviderFeaturesApplicationInsightsToTerraform = azurermProviderFeaturesApplicationInsightsToTerraform;
function azurermProviderFeaturesCognitiveAccountToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        purge_soft_delete_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeleteOnDestroy),
    };
}
exports.azurermProviderFeaturesCognitiveAccountToTerraform = azurermProviderFeaturesCognitiveAccountToTerraform;
function azurermProviderFeaturesKeyVaultToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        purge_soft_delete_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeleteOnDestroy),
        purge_soft_deleted_certificates_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeletedCertificatesOnDestroy),
        purge_soft_deleted_hardware_security_modules_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeletedHardwareSecurityModulesOnDestroy),
        purge_soft_deleted_keys_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeletedKeysOnDestroy),
        purge_soft_deleted_secrets_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeletedSecretsOnDestroy),
        recover_soft_deleted_certificates: cdktf.booleanToTerraform(struct.recoverSoftDeletedCertificates),
        recover_soft_deleted_key_vaults: cdktf.booleanToTerraform(struct.recoverSoftDeletedKeyVaults),
        recover_soft_deleted_keys: cdktf.booleanToTerraform(struct.recoverSoftDeletedKeys),
        recover_soft_deleted_secrets: cdktf.booleanToTerraform(struct.recoverSoftDeletedSecrets),
    };
}
exports.azurermProviderFeaturesKeyVaultToTerraform = azurermProviderFeaturesKeyVaultToTerraform;
function azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        permanently_delete_on_destroy: cdktf.booleanToTerraform(struct.permanentlyDeleteOnDestroy),
    };
}
exports.azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform = azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform;
function azurermProviderFeaturesNetworkToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        relaxed_locking: cdktf.booleanToTerraform(struct.relaxedLocking),
    };
}
exports.azurermProviderFeaturesNetworkToTerraform = azurermProviderFeaturesNetworkToTerraform;
function azurermProviderFeaturesResourceGroupToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        prevent_deletion_if_contains_resources: cdktf.booleanToTerraform(struct.preventDeletionIfContainsResources),
    };
}
exports.azurermProviderFeaturesResourceGroupToTerraform = azurermProviderFeaturesResourceGroupToTerraform;
function azurermProviderFeaturesTemplateDeploymentToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        delete_nested_items_during_deletion: cdktf.booleanToTerraform(struct.deleteNestedItemsDuringDeletion),
    };
}
exports.azurermProviderFeaturesTemplateDeploymentToTerraform = azurermProviderFeaturesTemplateDeploymentToTerraform;
function azurermProviderFeaturesVirtualMachineToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        delete_os_disk_on_deletion: cdktf.booleanToTerraform(struct.deleteOsDiskOnDeletion),
        graceful_shutdown: cdktf.booleanToTerraform(struct.gracefulShutdown),
        skip_shutdown_and_force_delete: cdktf.booleanToTerraform(struct.skipShutdownAndForceDelete),
    };
}
exports.azurermProviderFeaturesVirtualMachineToTerraform = azurermProviderFeaturesVirtualMachineToTerraform;
function azurermProviderFeaturesVirtualMachineScaleSetToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        force_delete: cdktf.booleanToTerraform(struct.forceDelete),
        roll_instances_when_required: cdktf.booleanToTerraform(struct.rollInstancesWhenRequired),
        scale_to_zero_before_deletion: cdktf.booleanToTerraform(struct.scaleToZeroBeforeDeletion),
    };
}
exports.azurermProviderFeaturesVirtualMachineScaleSetToTerraform = azurermProviderFeaturesVirtualMachineScaleSetToTerraform;
function azurermProviderFeaturesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        api_management: azurermProviderFeaturesApiManagementToTerraform(struct.apiManagement),
        application_insights: azurermProviderFeaturesApplicationInsightsToTerraform(struct.applicationInsights),
        cognitive_account: azurermProviderFeaturesCognitiveAccountToTerraform(struct.cognitiveAccount),
        key_vault: azurermProviderFeaturesKeyVaultToTerraform(struct.keyVault),
        log_analytics_workspace: azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform(struct.logAnalyticsWorkspace),
        network: azurermProviderFeaturesNetworkToTerraform(struct.network),
        resource_group: azurermProviderFeaturesResourceGroupToTerraform(struct.resourceGroup),
        template_deployment: azurermProviderFeaturesTemplateDeploymentToTerraform(struct.templateDeployment),
        virtual_machine: azurermProviderFeaturesVirtualMachineToTerraform(struct.virtualMachine),
        virtual_machine_scale_set: azurermProviderFeaturesVirtualMachineScaleSetToTerraform(struct.virtualMachineScaleSet),
    };
}
exports.azurermProviderFeaturesToTerraform = azurermProviderFeaturesToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm azurerm}
*/
class AzurermProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm azurerm} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AzurermProviderConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm',
            terraformGeneratorMetadata: {
                providerName: 'azurerm',
                providerVersion: '3.16.0',
                providerVersionConstraint: '~> 3.10'
            },
            terraformProviderSource: 'azurerm'
        });
        this._auxiliaryTenantIds = config.auxiliaryTenantIds;
        this._clientCertificatePassword = config.clientCertificatePassword;
        this._clientCertificatePath = config.clientCertificatePath;
        this._clientId = config.clientId;
        this._clientSecret = config.clientSecret;
        this._disableCorrelationRequestId = config.disableCorrelationRequestId;
        this._disableTerraformPartnerId = config.disableTerraformPartnerId;
        this._environment = config.environment;
        this._metadataHost = config.metadataHost;
        this._msiEndpoint = config.msiEndpoint;
        this._oidcRequestToken = config.oidcRequestToken;
        this._oidcRequestUrl = config.oidcRequestUrl;
        this._partnerId = config.partnerId;
        this._skipProviderRegistration = config.skipProviderRegistration;
        this._storageUseAzuread = config.storageUseAzuread;
        this._subscriptionId = config.subscriptionId;
        this._tenantId = config.tenantId;
        this._useMsi = config.useMsi;
        this._useOidc = config.useOidc;
        this._alias = config.alias;
        this._features = config.features;
    }
    get auxiliaryTenantIds() {
        return this._auxiliaryTenantIds;
    }
    set auxiliaryTenantIds(value) {
        this._auxiliaryTenantIds = value;
    }
    resetAuxiliaryTenantIds() {
        this._auxiliaryTenantIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get auxiliaryTenantIdsInput() {
        return this._auxiliaryTenantIds;
    }
    get clientCertificatePassword() {
        return this._clientCertificatePassword;
    }
    set clientCertificatePassword(value) {
        this._clientCertificatePassword = value;
    }
    resetClientCertificatePassword() {
        this._clientCertificatePassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientCertificatePasswordInput() {
        return this._clientCertificatePassword;
    }
    get clientCertificatePath() {
        return this._clientCertificatePath;
    }
    set clientCertificatePath(value) {
        this._clientCertificatePath = value;
    }
    resetClientCertificatePath() {
        this._clientCertificatePath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientCertificatePathInput() {
        return this._clientCertificatePath;
    }
    get clientId() {
        return this._clientId;
    }
    set clientId(value) {
        this._clientId = value;
    }
    resetClientId() {
        this._clientId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientIdInput() {
        return this._clientId;
    }
    get clientSecret() {
        return this._clientSecret;
    }
    set clientSecret(value) {
        this._clientSecret = value;
    }
    resetClientSecret() {
        this._clientSecret = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientSecretInput() {
        return this._clientSecret;
    }
    get disableCorrelationRequestId() {
        return this._disableCorrelationRequestId;
    }
    set disableCorrelationRequestId(value) {
        this._disableCorrelationRequestId = value;
    }
    resetDisableCorrelationRequestId() {
        this._disableCorrelationRequestId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableCorrelationRequestIdInput() {
        return this._disableCorrelationRequestId;
    }
    get disableTerraformPartnerId() {
        return this._disableTerraformPartnerId;
    }
    set disableTerraformPartnerId(value) {
        this._disableTerraformPartnerId = value;
    }
    resetDisableTerraformPartnerId() {
        this._disableTerraformPartnerId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableTerraformPartnerIdInput() {
        return this._disableTerraformPartnerId;
    }
    get environment() {
        return this._environment;
    }
    set environment(value) {
        this._environment = value;
    }
    resetEnvironment() {
        this._environment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get environmentInput() {
        return this._environment;
    }
    get metadataHost() {
        return this._metadataHost;
    }
    set metadataHost(value) {
        this._metadataHost = value;
    }
    resetMetadataHost() {
        this._metadataHost = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get metadataHostInput() {
        return this._metadataHost;
    }
    get msiEndpoint() {
        return this._msiEndpoint;
    }
    set msiEndpoint(value) {
        this._msiEndpoint = value;
    }
    resetMsiEndpoint() {
        this._msiEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get msiEndpointInput() {
        return this._msiEndpoint;
    }
    get oidcRequestToken() {
        return this._oidcRequestToken;
    }
    set oidcRequestToken(value) {
        this._oidcRequestToken = value;
    }
    resetOidcRequestToken() {
        this._oidcRequestToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcRequestTokenInput() {
        return this._oidcRequestToken;
    }
    get oidcRequestUrl() {
        return this._oidcRequestUrl;
    }
    set oidcRequestUrl(value) {
        this._oidcRequestUrl = value;
    }
    resetOidcRequestUrl() {
        this._oidcRequestUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcRequestUrlInput() {
        return this._oidcRequestUrl;
    }
    get partnerId() {
        return this._partnerId;
    }
    set partnerId(value) {
        this._partnerId = value;
    }
    resetPartnerId() {
        this._partnerId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get partnerIdInput() {
        return this._partnerId;
    }
    get skipProviderRegistration() {
        return this._skipProviderRegistration;
    }
    set skipProviderRegistration(value) {
        this._skipProviderRegistration = value;
    }
    resetSkipProviderRegistration() {
        this._skipProviderRegistration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipProviderRegistrationInput() {
        return this._skipProviderRegistration;
    }
    get storageUseAzuread() {
        return this._storageUseAzuread;
    }
    set storageUseAzuread(value) {
        this._storageUseAzuread = value;
    }
    resetStorageUseAzuread() {
        this._storageUseAzuread = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageUseAzureadInput() {
        return this._storageUseAzuread;
    }
    get subscriptionId() {
        return this._subscriptionId;
    }
    set subscriptionId(value) {
        this._subscriptionId = value;
    }
    resetSubscriptionId() {
        this._subscriptionId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get subscriptionIdInput() {
        return this._subscriptionId;
    }
    get tenantId() {
        return this._tenantId;
    }
    set tenantId(value) {
        this._tenantId = value;
    }
    resetTenantId() {
        this._tenantId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tenantIdInput() {
        return this._tenantId;
    }
    get useMsi() {
        return this._useMsi;
    }
    set useMsi(value) {
        this._useMsi = value;
    }
    resetUseMsi() {
        this._useMsi = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useMsiInput() {
        return this._useMsi;
    }
    get useOidc() {
        return this._useOidc;
    }
    set useOidc(value) {
        this._useOidc = value;
    }
    resetUseOidc() {
        this._useOidc = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useOidcInput() {
        return this._useOidc;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    get features() {
        return this._features;
    }
    set features(value) {
        this._features = value;
    }
    // Temporarily expose input value. Use with caution.
    get featuresInput() {
        return this._features;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            auxiliary_tenant_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._auxiliaryTenantIds),
            client_certificate_password: cdktf.stringToTerraform(this._clientCertificatePassword),
            client_certificate_path: cdktf.stringToTerraform(this._clientCertificatePath),
            client_id: cdktf.stringToTerraform(this._clientId),
            client_secret: cdktf.stringToTerraform(this._clientSecret),
            disable_correlation_request_id: cdktf.booleanToTerraform(this._disableCorrelationRequestId),
            disable_terraform_partner_id: cdktf.booleanToTerraform(this._disableTerraformPartnerId),
            environment: cdktf.stringToTerraform(this._environment),
            metadata_host: cdktf.stringToTerraform(this._metadataHost),
            msi_endpoint: cdktf.stringToTerraform(this._msiEndpoint),
            oidc_request_token: cdktf.stringToTerraform(this._oidcRequestToken),
            oidc_request_url: cdktf.stringToTerraform(this._oidcRequestUrl),
            partner_id: cdktf.stringToTerraform(this._partnerId),
            skip_provider_registration: cdktf.booleanToTerraform(this._skipProviderRegistration),
            storage_use_azuread: cdktf.booleanToTerraform(this._storageUseAzuread),
            subscription_id: cdktf.stringToTerraform(this._subscriptionId),
            tenant_id: cdktf.stringToTerraform(this._tenantId),
            use_msi: cdktf.booleanToTerraform(this._useMsi),
            use_oidc: cdktf.booleanToTerraform(this._useOidc),
            alias: cdktf.stringToTerraform(this._alias),
            features: azurermProviderFeaturesToTerraform(this._features),
        };
    }
}
exports.AzurermProvider = AzurermProvider;
_a = JSII_RTTI_SYMBOL_1;
AzurermProvider[_a] = { fqn: "@cdktf/provider-azurerm.AzurermProvider", version: "2.0.6" };
// =================
// STATIC PROPERTIES
// =================
AzurermProvider.tfResourceType = "azurerm";
//# sourceMappingURL=data:application/json;base64,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