import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ImageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#hyper_v_generation Image#hyper_v_generation}
    */
    readonly hyperVGeneration?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#id Image#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#location Image#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#name Image#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#resource_group_name Image#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#source_virtual_machine_id Image#source_virtual_machine_id}
    */
    readonly sourceVirtualMachineId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#tags Image#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#zone_resilient Image#zone_resilient}
    */
    readonly zoneResilient?: boolean | cdktf.IResolvable;
    /**
    * data_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#data_disk Image#data_disk}
    */
    readonly dataDisk?: ImageDataDisk[] | cdktf.IResolvable;
    /**
    * os_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#os_disk Image#os_disk}
    */
    readonly osDisk?: ImageOsDisk;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#timeouts Image#timeouts}
    */
    readonly timeouts?: ImageTimeouts;
}
export interface ImageDataDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#blob_uri Image#blob_uri}
    */
    readonly blobUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#caching Image#caching}
    */
    readonly caching?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#lun Image#lun}
    */
    readonly lun?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#managed_disk_id Image#managed_disk_id}
    */
    readonly managedDiskId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#size_gb Image#size_gb}
    */
    readonly sizeGb?: number;
}
export declare function imageDataDiskToTerraform(struct?: ImageDataDisk | cdktf.IResolvable): any;
export declare class ImageDataDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ImageDataDisk | cdktf.IResolvable | undefined;
    set internalValue(value: ImageDataDisk | cdktf.IResolvable | undefined);
    private _blobUri?;
    get blobUri(): string;
    set blobUri(value: string);
    resetBlobUri(): void;
    get blobUriInput(): string | undefined;
    private _caching?;
    get caching(): string;
    set caching(value: string);
    resetCaching(): void;
    get cachingInput(): string | undefined;
    private _lun?;
    get lun(): number;
    set lun(value: number);
    resetLun(): void;
    get lunInput(): number | undefined;
    private _managedDiskId?;
    get managedDiskId(): string;
    set managedDiskId(value: string);
    resetManagedDiskId(): void;
    get managedDiskIdInput(): string | undefined;
    private _sizeGb?;
    get sizeGb(): number;
    set sizeGb(value: number);
    resetSizeGb(): void;
    get sizeGbInput(): number | undefined;
}
export declare class ImageDataDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ImageDataDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ImageDataDiskOutputReference;
}
export interface ImageOsDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#blob_uri Image#blob_uri}
    */
    readonly blobUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#caching Image#caching}
    */
    readonly caching?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#managed_disk_id Image#managed_disk_id}
    */
    readonly managedDiskId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#os_state Image#os_state}
    */
    readonly osState?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#os_type Image#os_type}
    */
    readonly osType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#size_gb Image#size_gb}
    */
    readonly sizeGb?: number;
}
export declare function imageOsDiskToTerraform(struct?: ImageOsDiskOutputReference | ImageOsDisk): any;
export declare class ImageOsDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ImageOsDisk | undefined;
    set internalValue(value: ImageOsDisk | undefined);
    private _blobUri?;
    get blobUri(): string;
    set blobUri(value: string);
    resetBlobUri(): void;
    get blobUriInput(): string | undefined;
    private _caching?;
    get caching(): string;
    set caching(value: string);
    resetCaching(): void;
    get cachingInput(): string | undefined;
    private _managedDiskId?;
    get managedDiskId(): string;
    set managedDiskId(value: string);
    resetManagedDiskId(): void;
    get managedDiskIdInput(): string | undefined;
    private _osState?;
    get osState(): string;
    set osState(value: string);
    resetOsState(): void;
    get osStateInput(): string | undefined;
    private _osType?;
    get osType(): string;
    set osType(value: string);
    resetOsType(): void;
    get osTypeInput(): string | undefined;
    private _sizeGb?;
    get sizeGb(): number;
    set sizeGb(value: number);
    resetSizeGb(): void;
    get sizeGbInput(): number | undefined;
}
export interface ImageTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#create Image#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#delete Image#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#read Image#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image#update Image#update}
    */
    readonly update?: string;
}
export declare function imageTimeoutsToTerraform(struct?: ImageTimeoutsOutputReference | ImageTimeouts | cdktf.IResolvable): any;
export declare class ImageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ImageTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ImageTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/image azurerm_image}
*/
export declare class Image extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_image";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/image azurerm_image} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ImageConfig
    */
    constructor(scope: Construct, id: string, config: ImageConfig);
    private _hyperVGeneration?;
    get hyperVGeneration(): string;
    set hyperVGeneration(value: string);
    resetHyperVGeneration(): void;
    get hyperVGenerationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sourceVirtualMachineId?;
    get sourceVirtualMachineId(): string;
    set sourceVirtualMachineId(value: string);
    resetSourceVirtualMachineId(): void;
    get sourceVirtualMachineIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _zoneResilient?;
    get zoneResilient(): boolean | cdktf.IResolvable;
    set zoneResilient(value: boolean | cdktf.IResolvable);
    resetZoneResilient(): void;
    get zoneResilientInput(): boolean | cdktf.IResolvable | undefined;
    private _dataDisk;
    get dataDisk(): ImageDataDiskList;
    putDataDisk(value: ImageDataDisk[] | cdktf.IResolvable): void;
    resetDataDisk(): void;
    get dataDiskInput(): cdktf.IResolvable | ImageDataDisk[] | undefined;
    private _osDisk;
    get osDisk(): ImageOsDiskOutputReference;
    putOsDisk(value: ImageOsDisk): void;
    resetOsDisk(): void;
    get osDiskInput(): ImageOsDisk | undefined;
    private _timeouts;
    get timeouts(): ImageTimeoutsOutputReference;
    putTimeouts(value: ImageTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ImageTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
