import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorDiagnosticSettingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#eventhub_authorization_rule_id MonitorDiagnosticSetting#eventhub_authorization_rule_id}
    */
    readonly eventhubAuthorizationRuleId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#eventhub_name MonitorDiagnosticSetting#eventhub_name}
    */
    readonly eventhubName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#id MonitorDiagnosticSetting#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#log_analytics_destination_type MonitorDiagnosticSetting#log_analytics_destination_type}
    */
    readonly logAnalyticsDestinationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#log_analytics_workspace_id MonitorDiagnosticSetting#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#name MonitorDiagnosticSetting#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#storage_account_id MonitorDiagnosticSetting#storage_account_id}
    */
    readonly storageAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#target_resource_id MonitorDiagnosticSetting#target_resource_id}
    */
    readonly targetResourceId: string;
    /**
    * log block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#log MonitorDiagnosticSetting#log}
    */
    readonly log?: MonitorDiagnosticSettingLog[] | cdktf.IResolvable;
    /**
    * metric block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#metric MonitorDiagnosticSetting#metric}
    */
    readonly metric?: MonitorDiagnosticSettingMetric[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#timeouts MonitorDiagnosticSetting#timeouts}
    */
    readonly timeouts?: MonitorDiagnosticSettingTimeouts;
}
export interface MonitorDiagnosticSettingLogRetentionPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#days MonitorDiagnosticSetting#days}
    */
    readonly days?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#enabled MonitorDiagnosticSetting#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function monitorDiagnosticSettingLogRetentionPolicyToTerraform(struct?: MonitorDiagnosticSettingLogRetentionPolicyOutputReference | MonitorDiagnosticSettingLogRetentionPolicy): any;
export declare class MonitorDiagnosticSettingLogRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorDiagnosticSettingLogRetentionPolicy | undefined;
    set internalValue(value: MonitorDiagnosticSettingLogRetentionPolicy | undefined);
    private _days?;
    get days(): number;
    set days(value: number);
    resetDays(): void;
    get daysInput(): number | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface MonitorDiagnosticSettingLog {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#category MonitorDiagnosticSetting#category}
    */
    readonly category: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#enabled MonitorDiagnosticSetting#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * retention_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#retention_policy MonitorDiagnosticSetting#retention_policy}
    */
    readonly retentionPolicy?: MonitorDiagnosticSettingLogRetentionPolicy;
}
export declare function monitorDiagnosticSettingLogToTerraform(struct?: MonitorDiagnosticSettingLog | cdktf.IResolvable): any;
export declare class MonitorDiagnosticSettingLogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDiagnosticSettingLog | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDiagnosticSettingLog | cdktf.IResolvable | undefined);
    private _category?;
    get category(): string;
    set category(value: string);
    get categoryInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionPolicy;
    get retentionPolicy(): MonitorDiagnosticSettingLogRetentionPolicyOutputReference;
    putRetentionPolicy(value: MonitorDiagnosticSettingLogRetentionPolicy): void;
    resetRetentionPolicy(): void;
    get retentionPolicyInput(): MonitorDiagnosticSettingLogRetentionPolicy | undefined;
}
export declare class MonitorDiagnosticSettingLogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDiagnosticSettingLog[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDiagnosticSettingLogOutputReference;
}
export interface MonitorDiagnosticSettingMetricRetentionPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#days MonitorDiagnosticSetting#days}
    */
    readonly days?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#enabled MonitorDiagnosticSetting#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function monitorDiagnosticSettingMetricRetentionPolicyToTerraform(struct?: MonitorDiagnosticSettingMetricRetentionPolicyOutputReference | MonitorDiagnosticSettingMetricRetentionPolicy): any;
export declare class MonitorDiagnosticSettingMetricRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorDiagnosticSettingMetricRetentionPolicy | undefined;
    set internalValue(value: MonitorDiagnosticSettingMetricRetentionPolicy | undefined);
    private _days?;
    get days(): number;
    set days(value: number);
    resetDays(): void;
    get daysInput(): number | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface MonitorDiagnosticSettingMetric {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#category MonitorDiagnosticSetting#category}
    */
    readonly category: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#enabled MonitorDiagnosticSetting#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * retention_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#retention_policy MonitorDiagnosticSetting#retention_policy}
    */
    readonly retentionPolicy?: MonitorDiagnosticSettingMetricRetentionPolicy;
}
export declare function monitorDiagnosticSettingMetricToTerraform(struct?: MonitorDiagnosticSettingMetric | cdktf.IResolvable): any;
export declare class MonitorDiagnosticSettingMetricOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDiagnosticSettingMetric | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDiagnosticSettingMetric | cdktf.IResolvable | undefined);
    private _category?;
    get category(): string;
    set category(value: string);
    get categoryInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionPolicy;
    get retentionPolicy(): MonitorDiagnosticSettingMetricRetentionPolicyOutputReference;
    putRetentionPolicy(value: MonitorDiagnosticSettingMetricRetentionPolicy): void;
    resetRetentionPolicy(): void;
    get retentionPolicyInput(): MonitorDiagnosticSettingMetricRetentionPolicy | undefined;
}
export declare class MonitorDiagnosticSettingMetricList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDiagnosticSettingMetric[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDiagnosticSettingMetricOutputReference;
}
export interface MonitorDiagnosticSettingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#create MonitorDiagnosticSetting#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#delete MonitorDiagnosticSetting#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#read MonitorDiagnosticSetting#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#update MonitorDiagnosticSetting#update}
    */
    readonly update?: string;
}
export declare function monitorDiagnosticSettingTimeoutsToTerraform(struct?: MonitorDiagnosticSettingTimeoutsOutputReference | MonitorDiagnosticSettingTimeouts | cdktf.IResolvable): any;
export declare class MonitorDiagnosticSettingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorDiagnosticSettingTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDiagnosticSettingTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting azurerm_monitor_diagnostic_setting}
*/
export declare class MonitorDiagnosticSetting extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_monitor_diagnostic_setting";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting azurerm_monitor_diagnostic_setting} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorDiagnosticSettingConfig
    */
    constructor(scope: Construct, id: string, config: MonitorDiagnosticSettingConfig);
    private _eventhubAuthorizationRuleId?;
    get eventhubAuthorizationRuleId(): string;
    set eventhubAuthorizationRuleId(value: string);
    resetEventhubAuthorizationRuleId(): void;
    get eventhubAuthorizationRuleIdInput(): string | undefined;
    private _eventhubName?;
    get eventhubName(): string;
    set eventhubName(value: string);
    resetEventhubName(): void;
    get eventhubNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logAnalyticsDestinationType?;
    get logAnalyticsDestinationType(): string;
    set logAnalyticsDestinationType(value: string);
    resetLogAnalyticsDestinationType(): void;
    get logAnalyticsDestinationTypeInput(): string | undefined;
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    resetLogAnalyticsWorkspaceId(): void;
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    resetStorageAccountId(): void;
    get storageAccountIdInput(): string | undefined;
    private _targetResourceId?;
    get targetResourceId(): string;
    set targetResourceId(value: string);
    get targetResourceIdInput(): string | undefined;
    private _log;
    get log(): MonitorDiagnosticSettingLogList;
    putLog(value: MonitorDiagnosticSettingLog[] | cdktf.IResolvable): void;
    resetLog(): void;
    get logInput(): cdktf.IResolvable | MonitorDiagnosticSettingLog[] | undefined;
    private _metric;
    get metric(): MonitorDiagnosticSettingMetricList;
    putMetric(value: MonitorDiagnosticSettingMetric[] | cdktf.IResolvable): void;
    resetMetric(): void;
    get metricInput(): cdktf.IResolvable | MonitorDiagnosticSettingMetric[] | undefined;
    private _timeouts;
    get timeouts(): MonitorDiagnosticSettingTimeoutsOutputReference;
    putTimeouts(value: MonitorDiagnosticSettingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MonitorDiagnosticSettingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
