"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageManagementPolicy = exports.StorageManagementPolicyTimeoutsOutputReference = exports.storageManagementPolicyTimeoutsToTerraform = exports.StorageManagementPolicyRuleList = exports.StorageManagementPolicyRuleOutputReference = exports.storageManagementPolicyRuleToTerraform = exports.StorageManagementPolicyRuleFiltersOutputReference = exports.storageManagementPolicyRuleFiltersToTerraform = exports.StorageManagementPolicyRuleFiltersMatchBlobIndexTagList = exports.StorageManagementPolicyRuleFiltersMatchBlobIndexTagOutputReference = exports.storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform = exports.StorageManagementPolicyRuleActionsOutputReference = exports.storageManagementPolicyRuleActionsToTerraform = exports.StorageManagementPolicyRuleActionsVersionOutputReference = exports.storageManagementPolicyRuleActionsVersionToTerraform = exports.StorageManagementPolicyRuleActionsSnapshotOutputReference = exports.storageManagementPolicyRuleActionsSnapshotToTerraform = exports.StorageManagementPolicyRuleActionsBaseBlobOutputReference = exports.storageManagementPolicyRuleActionsBaseBlobToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function storageManagementPolicyRuleActionsBaseBlobToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        delete_after_days_since_last_access_time_greater_than: cdktf.numberToTerraform(struct.deleteAfterDaysSinceLastAccessTimeGreaterThan),
        delete_after_days_since_modification_greater_than: cdktf.numberToTerraform(struct.deleteAfterDaysSinceModificationGreaterThan),
        tier_to_archive_after_days_since_last_access_time_greater_than: cdktf.numberToTerraform(struct.tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan),
        tier_to_archive_after_days_since_modification_greater_than: cdktf.numberToTerraform(struct.tierToArchiveAfterDaysSinceModificationGreaterThan),
        tier_to_cool_after_days_since_last_access_time_greater_than: cdktf.numberToTerraform(struct.tierToCoolAfterDaysSinceLastAccessTimeGreaterThan),
        tier_to_cool_after_days_since_modification_greater_than: cdktf.numberToTerraform(struct.tierToCoolAfterDaysSinceModificationGreaterThan),
    };
}
exports.storageManagementPolicyRuleActionsBaseBlobToTerraform = storageManagementPolicyRuleActionsBaseBlobToTerraform;
class StorageManagementPolicyRuleActionsBaseBlobOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._deleteAfterDaysSinceLastAccessTimeGreaterThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.deleteAfterDaysSinceLastAccessTimeGreaterThan = this._deleteAfterDaysSinceLastAccessTimeGreaterThan;
        }
        if (this._deleteAfterDaysSinceModificationGreaterThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.deleteAfterDaysSinceModificationGreaterThan = this._deleteAfterDaysSinceModificationGreaterThan;
        }
        if (this._tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan = this._tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan;
        }
        if (this._tierToArchiveAfterDaysSinceModificationGreaterThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.tierToArchiveAfterDaysSinceModificationGreaterThan = this._tierToArchiveAfterDaysSinceModificationGreaterThan;
        }
        if (this._tierToCoolAfterDaysSinceLastAccessTimeGreaterThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.tierToCoolAfterDaysSinceLastAccessTimeGreaterThan = this._tierToCoolAfterDaysSinceLastAccessTimeGreaterThan;
        }
        if (this._tierToCoolAfterDaysSinceModificationGreaterThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.tierToCoolAfterDaysSinceModificationGreaterThan = this._tierToCoolAfterDaysSinceModificationGreaterThan;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._deleteAfterDaysSinceLastAccessTimeGreaterThan = undefined;
            this._deleteAfterDaysSinceModificationGreaterThan = undefined;
            this._tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan = undefined;
            this._tierToArchiveAfterDaysSinceModificationGreaterThan = undefined;
            this._tierToCoolAfterDaysSinceLastAccessTimeGreaterThan = undefined;
            this._tierToCoolAfterDaysSinceModificationGreaterThan = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._deleteAfterDaysSinceLastAccessTimeGreaterThan = value.deleteAfterDaysSinceLastAccessTimeGreaterThan;
            this._deleteAfterDaysSinceModificationGreaterThan = value.deleteAfterDaysSinceModificationGreaterThan;
            this._tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan = value.tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan;
            this._tierToArchiveAfterDaysSinceModificationGreaterThan = value.tierToArchiveAfterDaysSinceModificationGreaterThan;
            this._tierToCoolAfterDaysSinceLastAccessTimeGreaterThan = value.tierToCoolAfterDaysSinceLastAccessTimeGreaterThan;
            this._tierToCoolAfterDaysSinceModificationGreaterThan = value.tierToCoolAfterDaysSinceModificationGreaterThan;
        }
    }
    get deleteAfterDaysSinceLastAccessTimeGreaterThan() {
        return this.getNumberAttribute('delete_after_days_since_last_access_time_greater_than');
    }
    set deleteAfterDaysSinceLastAccessTimeGreaterThan(value) {
        this._deleteAfterDaysSinceLastAccessTimeGreaterThan = value;
    }
    resetDeleteAfterDaysSinceLastAccessTimeGreaterThan() {
        this._deleteAfterDaysSinceLastAccessTimeGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteAfterDaysSinceLastAccessTimeGreaterThanInput() {
        return this._deleteAfterDaysSinceLastAccessTimeGreaterThan;
    }
    get deleteAfterDaysSinceModificationGreaterThan() {
        return this.getNumberAttribute('delete_after_days_since_modification_greater_than');
    }
    set deleteAfterDaysSinceModificationGreaterThan(value) {
        this._deleteAfterDaysSinceModificationGreaterThan = value;
    }
    resetDeleteAfterDaysSinceModificationGreaterThan() {
        this._deleteAfterDaysSinceModificationGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteAfterDaysSinceModificationGreaterThanInput() {
        return this._deleteAfterDaysSinceModificationGreaterThan;
    }
    get tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan() {
        return this.getNumberAttribute('tier_to_archive_after_days_since_last_access_time_greater_than');
    }
    set tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan(value) {
        this._tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan = value;
    }
    resetTierToArchiveAfterDaysSinceLastAccessTimeGreaterThan() {
        this._tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tierToArchiveAfterDaysSinceLastAccessTimeGreaterThanInput() {
        return this._tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan;
    }
    get tierToArchiveAfterDaysSinceModificationGreaterThan() {
        return this.getNumberAttribute('tier_to_archive_after_days_since_modification_greater_than');
    }
    set tierToArchiveAfterDaysSinceModificationGreaterThan(value) {
        this._tierToArchiveAfterDaysSinceModificationGreaterThan = value;
    }
    resetTierToArchiveAfterDaysSinceModificationGreaterThan() {
        this._tierToArchiveAfterDaysSinceModificationGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tierToArchiveAfterDaysSinceModificationGreaterThanInput() {
        return this._tierToArchiveAfterDaysSinceModificationGreaterThan;
    }
    get tierToCoolAfterDaysSinceLastAccessTimeGreaterThan() {
        return this.getNumberAttribute('tier_to_cool_after_days_since_last_access_time_greater_than');
    }
    set tierToCoolAfterDaysSinceLastAccessTimeGreaterThan(value) {
        this._tierToCoolAfterDaysSinceLastAccessTimeGreaterThan = value;
    }
    resetTierToCoolAfterDaysSinceLastAccessTimeGreaterThan() {
        this._tierToCoolAfterDaysSinceLastAccessTimeGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tierToCoolAfterDaysSinceLastAccessTimeGreaterThanInput() {
        return this._tierToCoolAfterDaysSinceLastAccessTimeGreaterThan;
    }
    get tierToCoolAfterDaysSinceModificationGreaterThan() {
        return this.getNumberAttribute('tier_to_cool_after_days_since_modification_greater_than');
    }
    set tierToCoolAfterDaysSinceModificationGreaterThan(value) {
        this._tierToCoolAfterDaysSinceModificationGreaterThan = value;
    }
    resetTierToCoolAfterDaysSinceModificationGreaterThan() {
        this._tierToCoolAfterDaysSinceModificationGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tierToCoolAfterDaysSinceModificationGreaterThanInput() {
        return this._tierToCoolAfterDaysSinceModificationGreaterThan;
    }
}
exports.StorageManagementPolicyRuleActionsBaseBlobOutputReference = StorageManagementPolicyRuleActionsBaseBlobOutputReference;
_a = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleActionsBaseBlobOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleActionsBaseBlobOutputReference", version: "2.0.6" };
function storageManagementPolicyRuleActionsSnapshotToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        change_tier_to_archive_after_days_since_creation: cdktf.numberToTerraform(struct.changeTierToArchiveAfterDaysSinceCreation),
        change_tier_to_cool_after_days_since_creation: cdktf.numberToTerraform(struct.changeTierToCoolAfterDaysSinceCreation),
        delete_after_days_since_creation_greater_than: cdktf.numberToTerraform(struct.deleteAfterDaysSinceCreationGreaterThan),
    };
}
exports.storageManagementPolicyRuleActionsSnapshotToTerraform = storageManagementPolicyRuleActionsSnapshotToTerraform;
class StorageManagementPolicyRuleActionsSnapshotOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._changeTierToArchiveAfterDaysSinceCreation !== undefined) {
            hasAnyValues = true;
            internalValueResult.changeTierToArchiveAfterDaysSinceCreation = this._changeTierToArchiveAfterDaysSinceCreation;
        }
        if (this._changeTierToCoolAfterDaysSinceCreation !== undefined) {
            hasAnyValues = true;
            internalValueResult.changeTierToCoolAfterDaysSinceCreation = this._changeTierToCoolAfterDaysSinceCreation;
        }
        if (this._deleteAfterDaysSinceCreationGreaterThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.deleteAfterDaysSinceCreationGreaterThan = this._deleteAfterDaysSinceCreationGreaterThan;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._changeTierToArchiveAfterDaysSinceCreation = undefined;
            this._changeTierToCoolAfterDaysSinceCreation = undefined;
            this._deleteAfterDaysSinceCreationGreaterThan = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._changeTierToArchiveAfterDaysSinceCreation = value.changeTierToArchiveAfterDaysSinceCreation;
            this._changeTierToCoolAfterDaysSinceCreation = value.changeTierToCoolAfterDaysSinceCreation;
            this._deleteAfterDaysSinceCreationGreaterThan = value.deleteAfterDaysSinceCreationGreaterThan;
        }
    }
    get changeTierToArchiveAfterDaysSinceCreation() {
        return this.getNumberAttribute('change_tier_to_archive_after_days_since_creation');
    }
    set changeTierToArchiveAfterDaysSinceCreation(value) {
        this._changeTierToArchiveAfterDaysSinceCreation = value;
    }
    resetChangeTierToArchiveAfterDaysSinceCreation() {
        this._changeTierToArchiveAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get changeTierToArchiveAfterDaysSinceCreationInput() {
        return this._changeTierToArchiveAfterDaysSinceCreation;
    }
    get changeTierToCoolAfterDaysSinceCreation() {
        return this.getNumberAttribute('change_tier_to_cool_after_days_since_creation');
    }
    set changeTierToCoolAfterDaysSinceCreation(value) {
        this._changeTierToCoolAfterDaysSinceCreation = value;
    }
    resetChangeTierToCoolAfterDaysSinceCreation() {
        this._changeTierToCoolAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get changeTierToCoolAfterDaysSinceCreationInput() {
        return this._changeTierToCoolAfterDaysSinceCreation;
    }
    get deleteAfterDaysSinceCreationGreaterThan() {
        return this.getNumberAttribute('delete_after_days_since_creation_greater_than');
    }
    set deleteAfterDaysSinceCreationGreaterThan(value) {
        this._deleteAfterDaysSinceCreationGreaterThan = value;
    }
    resetDeleteAfterDaysSinceCreationGreaterThan() {
        this._deleteAfterDaysSinceCreationGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteAfterDaysSinceCreationGreaterThanInput() {
        return this._deleteAfterDaysSinceCreationGreaterThan;
    }
}
exports.StorageManagementPolicyRuleActionsSnapshotOutputReference = StorageManagementPolicyRuleActionsSnapshotOutputReference;
_b = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleActionsSnapshotOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleActionsSnapshotOutputReference", version: "2.0.6" };
function storageManagementPolicyRuleActionsVersionToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        change_tier_to_archive_after_days_since_creation: cdktf.numberToTerraform(struct.changeTierToArchiveAfterDaysSinceCreation),
        change_tier_to_cool_after_days_since_creation: cdktf.numberToTerraform(struct.changeTierToCoolAfterDaysSinceCreation),
        delete_after_days_since_creation: cdktf.numberToTerraform(struct.deleteAfterDaysSinceCreation),
    };
}
exports.storageManagementPolicyRuleActionsVersionToTerraform = storageManagementPolicyRuleActionsVersionToTerraform;
class StorageManagementPolicyRuleActionsVersionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._changeTierToArchiveAfterDaysSinceCreation !== undefined) {
            hasAnyValues = true;
            internalValueResult.changeTierToArchiveAfterDaysSinceCreation = this._changeTierToArchiveAfterDaysSinceCreation;
        }
        if (this._changeTierToCoolAfterDaysSinceCreation !== undefined) {
            hasAnyValues = true;
            internalValueResult.changeTierToCoolAfterDaysSinceCreation = this._changeTierToCoolAfterDaysSinceCreation;
        }
        if (this._deleteAfterDaysSinceCreation !== undefined) {
            hasAnyValues = true;
            internalValueResult.deleteAfterDaysSinceCreation = this._deleteAfterDaysSinceCreation;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._changeTierToArchiveAfterDaysSinceCreation = undefined;
            this._changeTierToCoolAfterDaysSinceCreation = undefined;
            this._deleteAfterDaysSinceCreation = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._changeTierToArchiveAfterDaysSinceCreation = value.changeTierToArchiveAfterDaysSinceCreation;
            this._changeTierToCoolAfterDaysSinceCreation = value.changeTierToCoolAfterDaysSinceCreation;
            this._deleteAfterDaysSinceCreation = value.deleteAfterDaysSinceCreation;
        }
    }
    get changeTierToArchiveAfterDaysSinceCreation() {
        return this.getNumberAttribute('change_tier_to_archive_after_days_since_creation');
    }
    set changeTierToArchiveAfterDaysSinceCreation(value) {
        this._changeTierToArchiveAfterDaysSinceCreation = value;
    }
    resetChangeTierToArchiveAfterDaysSinceCreation() {
        this._changeTierToArchiveAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get changeTierToArchiveAfterDaysSinceCreationInput() {
        return this._changeTierToArchiveAfterDaysSinceCreation;
    }
    get changeTierToCoolAfterDaysSinceCreation() {
        return this.getNumberAttribute('change_tier_to_cool_after_days_since_creation');
    }
    set changeTierToCoolAfterDaysSinceCreation(value) {
        this._changeTierToCoolAfterDaysSinceCreation = value;
    }
    resetChangeTierToCoolAfterDaysSinceCreation() {
        this._changeTierToCoolAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get changeTierToCoolAfterDaysSinceCreationInput() {
        return this._changeTierToCoolAfterDaysSinceCreation;
    }
    get deleteAfterDaysSinceCreation() {
        return this.getNumberAttribute('delete_after_days_since_creation');
    }
    set deleteAfterDaysSinceCreation(value) {
        this._deleteAfterDaysSinceCreation = value;
    }
    resetDeleteAfterDaysSinceCreation() {
        this._deleteAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteAfterDaysSinceCreationInput() {
        return this._deleteAfterDaysSinceCreation;
    }
}
exports.StorageManagementPolicyRuleActionsVersionOutputReference = StorageManagementPolicyRuleActionsVersionOutputReference;
_c = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleActionsVersionOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleActionsVersionOutputReference", version: "2.0.6" };
function storageManagementPolicyRuleActionsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        base_blob: storageManagementPolicyRuleActionsBaseBlobToTerraform(struct.baseBlob),
        snapshot: storageManagementPolicyRuleActionsSnapshotToTerraform(struct.snapshot),
        version: storageManagementPolicyRuleActionsVersionToTerraform(struct.version),
    };
}
exports.storageManagementPolicyRuleActionsToTerraform = storageManagementPolicyRuleActionsToTerraform;
class StorageManagementPolicyRuleActionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // base_blob - computed: false, optional: true, required: false
        this._baseBlob = new StorageManagementPolicyRuleActionsBaseBlobOutputReference(this, "base_blob");
        // snapshot - computed: false, optional: true, required: false
        this._snapshot = new StorageManagementPolicyRuleActionsSnapshotOutputReference(this, "snapshot");
        // version - computed: false, optional: true, required: false
        this._version = new StorageManagementPolicyRuleActionsVersionOutputReference(this, "version");
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._baseBlob?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.baseBlob = this._baseBlob?.internalValue;
        }
        if (this._snapshot?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.snapshot = this._snapshot?.internalValue;
        }
        if (this._version?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.version = this._version?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._baseBlob.internalValue = undefined;
            this._snapshot.internalValue = undefined;
            this._version.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._baseBlob.internalValue = value.baseBlob;
            this._snapshot.internalValue = value.snapshot;
            this._version.internalValue = value.version;
        }
    }
    get baseBlob() {
        return this._baseBlob;
    }
    putBaseBlob(value) {
        this._baseBlob.internalValue = value;
    }
    resetBaseBlob() {
        this._baseBlob.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get baseBlobInput() {
        return this._baseBlob.internalValue;
    }
    get snapshot() {
        return this._snapshot;
    }
    putSnapshot(value) {
        this._snapshot.internalValue = value;
    }
    resetSnapshot() {
        this._snapshot.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snapshotInput() {
        return this._snapshot.internalValue;
    }
    get version() {
        return this._version;
    }
    putVersion(value) {
        this._version.internalValue = value;
    }
    resetVersion() {
        this._version.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get versionInput() {
        return this._version.internalValue;
    }
}
exports.StorageManagementPolicyRuleActionsOutputReference = StorageManagementPolicyRuleActionsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleActionsOutputReference[_d] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleActionsOutputReference", version: "2.0.6" };
function storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        name: cdktf.stringToTerraform(struct.name),
        operation: cdktf.stringToTerraform(struct.operation),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform = storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform;
class StorageManagementPolicyRuleFiltersMatchBlobIndexTagOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._name !== undefined) {
            hasAnyValues = true;
            internalValueResult.name = this._name;
        }
        if (this._operation !== undefined) {
            hasAnyValues = true;
            internalValueResult.operation = this._operation;
        }
        if (this._value !== undefined) {
            hasAnyValues = true;
            internalValueResult.value = this._value;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._name = undefined;
            this._operation = undefined;
            this._value = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._name = value.name;
            this._operation = value.operation;
            this._value = value.value;
        }
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get operation() {
        return this.getStringAttribute('operation');
    }
    set operation(value) {
        this._operation = value;
    }
    resetOperation() {
        this._operation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationInput() {
        return this._operation;
    }
    get value() {
        return this.getStringAttribute('value');
    }
    set value(value) {
        this._value = value;
    }
    // Temporarily expose input value. Use with caution.
    get valueInput() {
        return this._value;
    }
}
exports.StorageManagementPolicyRuleFiltersMatchBlobIndexTagOutputReference = StorageManagementPolicyRuleFiltersMatchBlobIndexTagOutputReference;
_e = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleFiltersMatchBlobIndexTagOutputReference[_e] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleFiltersMatchBlobIndexTagOutputReference", version: "2.0.6" };
class StorageManagementPolicyRuleFiltersMatchBlobIndexTagList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new StorageManagementPolicyRuleFiltersMatchBlobIndexTagOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.StorageManagementPolicyRuleFiltersMatchBlobIndexTagList = StorageManagementPolicyRuleFiltersMatchBlobIndexTagList;
_f = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleFiltersMatchBlobIndexTagList[_f] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleFiltersMatchBlobIndexTagList", version: "2.0.6" };
function storageManagementPolicyRuleFiltersToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        blob_types: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.blobTypes),
        prefix_match: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.prefixMatch),
        match_blob_index_tag: cdktf.listMapper(storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform, true)(struct.matchBlobIndexTag),
    };
}
exports.storageManagementPolicyRuleFiltersToTerraform = storageManagementPolicyRuleFiltersToTerraform;
class StorageManagementPolicyRuleFiltersOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // match_blob_index_tag - computed: false, optional: true, required: false
        this._matchBlobIndexTag = new StorageManagementPolicyRuleFiltersMatchBlobIndexTagList(this, "match_blob_index_tag", true);
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._blobTypes !== undefined) {
            hasAnyValues = true;
            internalValueResult.blobTypes = this._blobTypes;
        }
        if (this._prefixMatch !== undefined) {
            hasAnyValues = true;
            internalValueResult.prefixMatch = this._prefixMatch;
        }
        if (this._matchBlobIndexTag?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.matchBlobIndexTag = this._matchBlobIndexTag?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._blobTypes = undefined;
            this._prefixMatch = undefined;
            this._matchBlobIndexTag.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._blobTypes = value.blobTypes;
            this._prefixMatch = value.prefixMatch;
            this._matchBlobIndexTag.internalValue = value.matchBlobIndexTag;
        }
    }
    get blobTypes() {
        return cdktf.Fn.tolist(this.getListAttribute('blob_types'));
    }
    set blobTypes(value) {
        this._blobTypes = value;
    }
    // Temporarily expose input value. Use with caution.
    get blobTypesInput() {
        return this._blobTypes;
    }
    get prefixMatch() {
        return cdktf.Fn.tolist(this.getListAttribute('prefix_match'));
    }
    set prefixMatch(value) {
        this._prefixMatch = value;
    }
    resetPrefixMatch() {
        this._prefixMatch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get prefixMatchInput() {
        return this._prefixMatch;
    }
    get matchBlobIndexTag() {
        return this._matchBlobIndexTag;
    }
    putMatchBlobIndexTag(value) {
        this._matchBlobIndexTag.internalValue = value;
    }
    resetMatchBlobIndexTag() {
        this._matchBlobIndexTag.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get matchBlobIndexTagInput() {
        return this._matchBlobIndexTag.internalValue;
    }
}
exports.StorageManagementPolicyRuleFiltersOutputReference = StorageManagementPolicyRuleFiltersOutputReference;
_g = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleFiltersOutputReference[_g] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleFiltersOutputReference", version: "2.0.6" };
function storageManagementPolicyRuleToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        enabled: cdktf.booleanToTerraform(struct.enabled),
        name: cdktf.stringToTerraform(struct.name),
        actions: storageManagementPolicyRuleActionsToTerraform(struct.actions),
        filters: storageManagementPolicyRuleFiltersToTerraform(struct.filters),
    };
}
exports.storageManagementPolicyRuleToTerraform = storageManagementPolicyRuleToTerraform;
class StorageManagementPolicyRuleOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
        // actions - computed: false, optional: false, required: true
        this._actions = new StorageManagementPolicyRuleActionsOutputReference(this, "actions");
        // filters - computed: false, optional: true, required: false
        this._filters = new StorageManagementPolicyRuleFiltersOutputReference(this, "filters");
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._enabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.enabled = this._enabled;
        }
        if (this._name !== undefined) {
            hasAnyValues = true;
            internalValueResult.name = this._name;
        }
        if (this._actions?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.actions = this._actions?.internalValue;
        }
        if (this._filters?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.filters = this._filters?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._enabled = undefined;
            this._name = undefined;
            this._actions.internalValue = undefined;
            this._filters.internalValue = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._enabled = value.enabled;
            this._name = value.name;
            this._actions.internalValue = value.actions;
            this._filters.internalValue = value.filters;
        }
    }
    get enabled() {
        return this.getBooleanAttribute('enabled');
    }
    set enabled(value) {
        this._enabled = value;
    }
    // Temporarily expose input value. Use with caution.
    get enabledInput() {
        return this._enabled;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get actions() {
        return this._actions;
    }
    putActions(value) {
        this._actions.internalValue = value;
    }
    // Temporarily expose input value. Use with caution.
    get actionsInput() {
        return this._actions.internalValue;
    }
    get filters() {
        return this._filters;
    }
    putFilters(value) {
        this._filters.internalValue = value;
    }
    resetFilters() {
        this._filters.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get filtersInput() {
        return this._filters.internalValue;
    }
}
exports.StorageManagementPolicyRuleOutputReference = StorageManagementPolicyRuleOutputReference;
_h = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleOutputReference[_h] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleOutputReference", version: "2.0.6" };
class StorageManagementPolicyRuleList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new StorageManagementPolicyRuleOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.StorageManagementPolicyRuleList = StorageManagementPolicyRuleList;
_j = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleList[_j] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleList", version: "2.0.6" };
function storageManagementPolicyTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.storageManagementPolicyTimeoutsToTerraform = storageManagementPolicyTimeoutsToTerraform;
class StorageManagementPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.StorageManagementPolicyTimeoutsOutputReference = StorageManagementPolicyTimeoutsOutputReference;
_k = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyTimeoutsOutputReference[_k] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyTimeoutsOutputReference", version: "2.0.6" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy azurerm_storage_management_policy}
*/
class StorageManagementPolicy extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy azurerm_storage_management_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageManagementPolicyConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_storage_management_policy',
            terraformGeneratorMetadata: {
                providerName: 'azurerm',
                providerVersion: '3.16.0',
                providerVersionConstraint: '~> 3.10'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // rule - computed: false, optional: true, required: false
        this._rule = new StorageManagementPolicyRuleList(this, "rule", false);
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new StorageManagementPolicyTimeoutsOutputReference(this, "timeouts");
        this._id = config.id;
        this._storageAccountId = config.storageAccountId;
        this._rule.internalValue = config.rule;
        this._timeouts.internalValue = config.timeouts;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get storageAccountId() {
        return this.getStringAttribute('storage_account_id');
    }
    set storageAccountId(value) {
        this._storageAccountId = value;
    }
    // Temporarily expose input value. Use with caution.
    get storageAccountIdInput() {
        return this._storageAccountId;
    }
    get rule() {
        return this._rule;
    }
    putRule(value) {
        this._rule.internalValue = value;
    }
    resetRule() {
        this._rule.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ruleInput() {
        return this._rule.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            id: cdktf.stringToTerraform(this._id),
            storage_account_id: cdktf.stringToTerraform(this._storageAccountId),
            rule: cdktf.listMapper(storageManagementPolicyRuleToTerraform, true)(this._rule.internalValue),
            timeouts: storageManagementPolicyTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.StorageManagementPolicy = StorageManagementPolicy;
_l = JSII_RTTI_SYMBOL_1;
StorageManagementPolicy[_l] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicy", version: "2.0.6" };
// =================
// STATIC PROPERTIES
// =================
StorageManagementPolicy.tfResourceType = "azurerm_storage_management_policy";
//# sourceMappingURL=data:application/json;base64,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