import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StreamAnalyticsOutputCosmosdbConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_cosmosdb#container_name StreamAnalyticsOutputCosmosdb#container_name}
    */
    readonly containerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_cosmosdb#cosmosdb_account_key StreamAnalyticsOutputCosmosdb#cosmosdb_account_key}
    */
    readonly cosmosdbAccountKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_cosmosdb#cosmosdb_sql_database_id StreamAnalyticsOutputCosmosdb#cosmosdb_sql_database_id}
    */
    readonly cosmosdbSqlDatabaseId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_cosmosdb#document_id StreamAnalyticsOutputCosmosdb#document_id}
    */
    readonly documentId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_cosmosdb#id StreamAnalyticsOutputCosmosdb#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_cosmosdb#name StreamAnalyticsOutputCosmosdb#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_cosmosdb#stream_analytics_job_id StreamAnalyticsOutputCosmosdb#stream_analytics_job_id}
    */
    readonly streamAnalyticsJobId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_cosmosdb#timeouts StreamAnalyticsOutputCosmosdb#timeouts}
    */
    readonly timeouts?: StreamAnalyticsOutputCosmosdbTimeouts;
}
export interface StreamAnalyticsOutputCosmosdbTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_cosmosdb#create StreamAnalyticsOutputCosmosdb#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_cosmosdb#delete StreamAnalyticsOutputCosmosdb#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_cosmosdb#read StreamAnalyticsOutputCosmosdb#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_cosmosdb#update StreamAnalyticsOutputCosmosdb#update}
    */
    readonly update?: string;
}
export declare function streamAnalyticsOutputCosmosdbTimeoutsToTerraform(struct?: StreamAnalyticsOutputCosmosdbTimeoutsOutputReference | StreamAnalyticsOutputCosmosdbTimeouts | cdktf.IResolvable): any;
export declare class StreamAnalyticsOutputCosmosdbTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StreamAnalyticsOutputCosmosdbTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StreamAnalyticsOutputCosmosdbTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_cosmosdb azurerm_stream_analytics_output_cosmosdb}
*/
export declare class StreamAnalyticsOutputCosmosdb extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_stream_analytics_output_cosmosdb";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_cosmosdb azurerm_stream_analytics_output_cosmosdb} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StreamAnalyticsOutputCosmosdbConfig
    */
    constructor(scope: Construct, id: string, config: StreamAnalyticsOutputCosmosdbConfig);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    get containerNameInput(): string | undefined;
    private _cosmosdbAccountKey?;
    get cosmosdbAccountKey(): string;
    set cosmosdbAccountKey(value: string);
    get cosmosdbAccountKeyInput(): string | undefined;
    private _cosmosdbSqlDatabaseId?;
    get cosmosdbSqlDatabaseId(): string;
    set cosmosdbSqlDatabaseId(value: string);
    get cosmosdbSqlDatabaseIdInput(): string | undefined;
    private _documentId?;
    get documentId(): string;
    set documentId(value: string);
    resetDocumentId(): void;
    get documentIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _streamAnalyticsJobId?;
    get streamAnalyticsJobId(): string;
    set streamAnalyticsJobId(value: string);
    get streamAnalyticsJobIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): StreamAnalyticsOutputCosmosdbTimeoutsOutputReference;
    putTimeouts(value: StreamAnalyticsOutputCosmosdbTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StreamAnalyticsOutputCosmosdbTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
