import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataKubectlFileDocumentsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/file_documents#content DataKubectlFileDocuments#content}
    */
    readonly content: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/file_documents#id DataKubectlFileDocuments#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/file_documents kubectl_file_documents}
*/
export declare class DataKubectlFileDocuments extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "kubectl_file_documents";
    /**
    * Generates CDKTF code for importing a DataKubectlFileDocuments resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataKubectlFileDocuments to import
    * @param importFromId The id of the existing DataKubectlFileDocuments that should be imported. Refer to the {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/file_documents#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataKubectlFileDocuments to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/file_documents kubectl_file_documents} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataKubectlFileDocumentsConfig
    */
    constructor(scope: Construct, id: string, config: DataKubectlFileDocumentsConfig);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    get documents(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _manifests;
    get manifests(): cdktf.StringMap;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
