import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataKubectlFilenameListConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/filename_list#id DataKubectlFilenameList#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/filename_list#pattern DataKubectlFilenameList#pattern}
    */
    readonly pattern: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/filename_list kubectl_filename_list}
*/
export declare class DataKubectlFilenameList extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "kubectl_filename_list";
    /**
    * Generates CDKTF code for importing a DataKubectlFilenameList resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataKubectlFilenameList to import
    * @param importFromId The id of the existing DataKubectlFilenameList that should be imported. Refer to the {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/filename_list#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataKubectlFilenameList to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/filename_list kubectl_filename_list} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataKubectlFilenameListConfig
    */
    constructor(scope: Construct, id: string, config: DataKubectlFilenameListConfig);
    get basenames(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get matches(): string[];
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    get patternInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
