import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataKubectlPathDocumentsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Flag to disable template parsing of the loaded documents
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/path_documents#disable_template DataKubectlPathDocuments#disable_template}
    */
    readonly disableTemplate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/path_documents#id DataKubectlPathDocuments#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Glob pattern to search for
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/path_documents#pattern DataKubectlPathDocuments#pattern}
    */
    readonly pattern: string;
    /**
    * Sensitive variables to substitute, allowing for hiding sensitive variables in terraform output
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/path_documents#sensitive_vars DataKubectlPathDocuments#sensitive_vars}
    */
    readonly sensitiveVars?: {
        [key: string]: string;
    };
    /**
    * Variables to substitute
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/path_documents#vars DataKubectlPathDocuments#vars}
    */
    readonly vars?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/path_documents kubectl_path_documents}
*/
export declare class DataKubectlPathDocuments extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "kubectl_path_documents";
    /**
    * Generates CDKTF code for importing a DataKubectlPathDocuments resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataKubectlPathDocuments to import
    * @param importFromId The id of the existing DataKubectlPathDocuments that should be imported. Refer to the {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/path_documents#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataKubectlPathDocuments to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/path_documents kubectl_path_documents} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataKubectlPathDocumentsConfig
    */
    constructor(scope: Construct, id: string, config: DataKubectlPathDocumentsConfig);
    private _disableTemplate?;
    get disableTemplate(): boolean | cdktf.IResolvable;
    set disableTemplate(value: boolean | cdktf.IResolvable);
    resetDisableTemplate(): void;
    get disableTemplateInput(): boolean | cdktf.IResolvable | undefined;
    get documents(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _manifests;
    get manifests(): cdktf.StringMap;
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    get patternInput(): string | undefined;
    private _sensitiveVars?;
    get sensitiveVars(): {
        [key: string]: string;
    };
    set sensitiveVars(value: {
        [key: string]: string;
    });
    resetSensitiveVars(): void;
    get sensitiveVarsInput(): {
        [key: string]: string;
    } | undefined;
    private _vars?;
    get vars(): {
        [key: string]: string;
    };
    set vars(value: {
        [key: string]: string;
    });
    resetVars(): void;
    get varsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
