import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataKubectlServerVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/server_version#id DataKubectlServerVersion#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/server_version kubectl_server_version}
*/
export declare class DataKubectlServerVersion extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "kubectl_server_version";
    /**
    * Generates CDKTF code for importing a DataKubectlServerVersion resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataKubectlServerVersion to import
    * @param importFromId The id of the existing DataKubectlServerVersion that should be imported. Refer to the {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/server_version#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataKubectlServerVersion to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/data-sources/server_version kubectl_server_version} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataKubectlServerVersionConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataKubectlServerVersionConfig);
    get buildDate(): string;
    get gitCommit(): string;
    get gitVersion(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get major(): string;
    get minor(): string;
    get patch(): string;
    get platform(): string;
    get version(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
