import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ManifestConfig extends cdktf.TerraformMetaArguments {
    /**
    * Apply only. In other words, it does not delete resource in any case.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest#apply_only Manifest#apply_only}
    */
    readonly applyOnly?: boolean | cdktf.IResolvable;
    /**
    * Override the default field manager name. This is only relevent when using server-side apply.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest#field_manager Manifest#field_manager}
    */
    readonly fieldManager?: string;
    /**
    * Default false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest#force_conflicts Manifest#force_conflicts}
    */
    readonly forceConflicts?: boolean | cdktf.IResolvable;
    /**
    * Default to update in-place. Setting to true will delete and create the kubernetes instead.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest#force_new Manifest#force_new}
    */
    readonly forceNew?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest#id Manifest#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * List of yaml keys to ignore changes to. Set these for fields set by Operators or other processes in kubernetes and as such you don't want to update.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest#ignore_fields Manifest#ignore_fields}
    */
    readonly ignoreFields?: string[];
    /**
    * Override the namespace to apply the kubernetes resource to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest#override_namespace Manifest#override_namespace}
    */
    readonly overrideNamespace?: string;
    /**
    * List of yaml keys with sensitive values. Set these for fields which you want obfuscated in the yaml_body output
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest#sensitive_fields Manifest#sensitive_fields}
    */
    readonly sensitiveFields?: string[];
    /**
    * Default to client-side-apply. Setting to true will use server-side apply.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest#server_side_apply Manifest#server_side_apply}
    */
    readonly serverSideApply?: boolean | cdktf.IResolvable;
    /**
    * Default to true (validate). Set this flag to not validate the yaml schema before applying.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest#validate_schema Manifest#validate_schema}
    */
    readonly validateSchema?: boolean | cdktf.IResolvable;
    /**
    * Default to false (not waiting). Set this flag to wait or not for any deleted resources to be gone. This waits for finalizers.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest#wait Manifest#wait}
    */
    readonly wait?: boolean | cdktf.IResolvable;
    /**
    * Default to true (waiting). Set this flag to wait or not for Deployments and APIService to complete rollout
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest#wait_for_rollout Manifest#wait_for_rollout}
    */
    readonly waitForRollout?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest#yaml_body Manifest#yaml_body}
    */
    readonly yamlBody: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest#timeouts Manifest#timeouts}
    */
    readonly timeouts?: ManifestTimeouts;
    /**
    * wait_for block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest#wait_for Manifest#wait_for}
    */
    readonly waitFor?: ManifestWaitFor;
}
export interface ManifestTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest#create Manifest#create}
    */
    readonly create?: string;
}
export declare function manifestTimeoutsToTerraform(struct?: ManifestTimeouts | cdktf.IResolvable): any;
export declare function manifestTimeoutsToHclTerraform(struct?: ManifestTimeouts | cdktf.IResolvable): any;
export declare class ManifestTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManifestTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ManifestTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
}
export interface ManifestWaitForField {
    /**
    * Key which should be matched from resulting object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest#key Manifest#key}
    */
    readonly key: string;
    /**
    * Value to wait for
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest#value Manifest#value}
    */
    readonly value: string;
    /**
    * Value type. Can be either a `eq` (equivalent) or `regex`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest#value_type Manifest#value_type}
    */
    readonly valueType?: string;
}
export declare function manifestWaitForFieldToTerraform(struct?: ManifestWaitForField | cdktf.IResolvable): any;
export declare function manifestWaitForFieldToHclTerraform(struct?: ManifestWaitForField | cdktf.IResolvable): any;
export declare class ManifestWaitForFieldOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ManifestWaitForField | cdktf.IResolvable | undefined;
    set internalValue(value: ManifestWaitForField | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    private _valueType?;
    get valueType(): string;
    set valueType(value: string);
    resetValueType(): void;
    get valueTypeInput(): string | undefined;
}
export declare class ManifestWaitForFieldList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ManifestWaitForField[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ManifestWaitForFieldOutputReference;
}
export interface ManifestWaitFor {
    /**
    * field block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest#field Manifest#field}
    */
    readonly field: ManifestWaitForField[] | cdktf.IResolvable;
}
export declare function manifestWaitForToTerraform(struct?: ManifestWaitForOutputReference | ManifestWaitFor): any;
export declare function manifestWaitForToHclTerraform(struct?: ManifestWaitForOutputReference | ManifestWaitFor): any;
export declare class ManifestWaitForOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManifestWaitFor | undefined;
    set internalValue(value: ManifestWaitFor | undefined);
    private _field;
    get field(): ManifestWaitForFieldList;
    putField(value: ManifestWaitForField[] | cdktf.IResolvable): void;
    get fieldInput(): cdktf.IResolvable | ManifestWaitForField[] | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest kubectl_manifest}
*/
export declare class Manifest extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubectl_manifest";
    /**
    * Generates CDKTF code for importing a Manifest resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Manifest to import
    * @param importFromId The id of the existing Manifest that should be imported. Refer to the {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Manifest to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/manifest kubectl_manifest} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManifestConfig
    */
    constructor(scope: Construct, id: string, config: ManifestConfig);
    get apiVersion(): string;
    private _applyOnly?;
    get applyOnly(): boolean | cdktf.IResolvable;
    set applyOnly(value: boolean | cdktf.IResolvable);
    resetApplyOnly(): void;
    get applyOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _fieldManager?;
    get fieldManager(): string;
    set fieldManager(value: string);
    resetFieldManager(): void;
    get fieldManagerInput(): string | undefined;
    private _forceConflicts?;
    get forceConflicts(): boolean | cdktf.IResolvable;
    set forceConflicts(value: boolean | cdktf.IResolvable);
    resetForceConflicts(): void;
    get forceConflictsInput(): boolean | cdktf.IResolvable | undefined;
    private _forceNew?;
    get forceNew(): boolean | cdktf.IResolvable;
    set forceNew(value: boolean | cdktf.IResolvable);
    resetForceNew(): void;
    get forceNewInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ignoreFields?;
    get ignoreFields(): string[];
    set ignoreFields(value: string[]);
    resetIgnoreFields(): void;
    get ignoreFieldsInput(): string[] | undefined;
    get kind(): string;
    get liveManifestIncluster(): string;
    get liveUid(): string;
    get name(): string;
    get namespace(): string;
    private _overrideNamespace?;
    get overrideNamespace(): string;
    set overrideNamespace(value: string);
    resetOverrideNamespace(): void;
    get overrideNamespaceInput(): string | undefined;
    private _sensitiveFields?;
    get sensitiveFields(): string[];
    set sensitiveFields(value: string[]);
    resetSensitiveFields(): void;
    get sensitiveFieldsInput(): string[] | undefined;
    private _serverSideApply?;
    get serverSideApply(): boolean | cdktf.IResolvable;
    set serverSideApply(value: boolean | cdktf.IResolvable);
    resetServerSideApply(): void;
    get serverSideApplyInput(): boolean | cdktf.IResolvable | undefined;
    get uid(): string;
    private _validateSchema?;
    get validateSchema(): boolean | cdktf.IResolvable;
    set validateSchema(value: boolean | cdktf.IResolvable);
    resetValidateSchema(): void;
    get validateSchemaInput(): boolean | cdktf.IResolvable | undefined;
    private _wait?;
    get wait(): boolean | cdktf.IResolvable;
    set wait(value: boolean | cdktf.IResolvable);
    resetWait(): void;
    get waitInput(): boolean | cdktf.IResolvable | undefined;
    private _waitForRollout?;
    get waitForRollout(): boolean | cdktf.IResolvable;
    set waitForRollout(value: boolean | cdktf.IResolvable);
    resetWaitForRollout(): void;
    get waitForRolloutInput(): boolean | cdktf.IResolvable | undefined;
    private _yamlBody?;
    get yamlBody(): string;
    set yamlBody(value: string);
    get yamlBodyInput(): string | undefined;
    get yamlBodyParsed(): string;
    get yamlIncluster(): string;
    private _timeouts;
    get timeouts(): ManifestTimeoutsOutputReference;
    putTimeouts(value: ManifestTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ManifestTimeouts | undefined;
    private _waitFor;
    get waitFor(): ManifestWaitForOutputReference;
    putWaitFor(value: ManifestWaitFor): void;
    resetWaitFor(): void;
    get waitForInput(): ManifestWaitFor | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
