import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KubectlProviderConfig {
    /**
    * Defines the number of attempts any create/update action will take
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#apply_retry_count KubectlProvider#apply_retry_count}
    */
    readonly applyRetryCount?: number;
    /**
    * PEM-encoded client certificate for TLS authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#client_certificate KubectlProvider#client_certificate}
    */
    readonly clientCertificate?: string;
    /**
    * PEM-encoded client certificate key for TLS authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#client_key KubectlProvider#client_key}
    */
    readonly clientKey?: string;
    /**
    * PEM-encoded root certificates bundle for TLS authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#cluster_ca_certificate KubectlProvider#cluster_ca_certificate}
    */
    readonly clusterCaCertificate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#config_context KubectlProvider#config_context}
    */
    readonly configContext?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#config_context_auth_info KubectlProvider#config_context_auth_info}
    */
    readonly configContextAuthInfo?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#config_context_cluster KubectlProvider#config_context_cluster}
    */
    readonly configContextCluster?: string;
    /**
    * Path to the kube config file, defaults to ~/.kube/config
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#config_path KubectlProvider#config_path}
    */
    readonly configPath?: string;
    /**
    * A list of paths to kube config files. Can be set with KUBE_CONFIG_PATHS environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#config_paths KubectlProvider#config_paths}
    */
    readonly configPaths?: string[];
    /**
    * The hostname (in form of URI) of Kubernetes master.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#host KubectlProvider#host}
    */
    readonly host?: string;
    /**
    * Whether server should be accessed without verifying the TLS certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#insecure KubectlProvider#insecure}
    */
    readonly insecure?: boolean | cdktf.IResolvable;
    /**
    * Load local kubeconfig.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#load_config_file KubectlProvider#load_config_file}
    */
    readonly loadConfigFile?: boolean | cdktf.IResolvable;
    /**
    * The password to use for HTTP basic authentication when accessing the Kubernetes master endpoint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#password KubectlProvider#password}
    */
    readonly password?: string;
    /**
    * URL to the proxy to be used for all API requests
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#proxy_url KubectlProvider#proxy_url}
    */
    readonly proxyUrl?: string;
    /**
    * Server name passed to the server for SNI and is used in the client to check server certificates against.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#tls_server_name KubectlProvider#tls_server_name}
    */
    readonly tlsServerName?: string;
    /**
    * Token to authentifcate an service account
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#token KubectlProvider#token}
    */
    readonly token?: string;
    /**
    * The username to use for HTTP basic authentication when accessing the Kubernetes master endpoint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#username KubectlProvider#username}
    */
    readonly username?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#alias KubectlProvider#alias}
    */
    readonly alias?: string;
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#exec KubectlProvider#exec}
    */
    readonly exec?: KubectlProviderExec;
}
export interface KubectlProviderExec {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#api_version KubectlProvider#api_version}
    */
    readonly apiVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#args KubectlProvider#args}
    */
    readonly args?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#command KubectlProvider#command}
    */
    readonly command: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#env KubectlProvider#env}
    */
    readonly env?: {
        [key: string]: string;
    };
}
export declare function kubectlProviderExecToTerraform(struct?: KubectlProviderExec): any;
export declare function kubectlProviderExecToHclTerraform(struct?: KubectlProviderExec): any;
/**
* Represents a {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs kubectl}
*/
export declare class KubectlProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "kubectl";
    /**
    * Generates CDKTF code for importing a KubectlProvider resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the KubectlProvider to import
    * @param importFromId The id of the existing KubectlProvider that should be imported. Refer to the {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the KubectlProvider to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs kubectl} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubectlProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: KubectlProviderConfig);
    private _applyRetryCount?;
    get applyRetryCount(): number | undefined;
    set applyRetryCount(value: number | undefined);
    resetApplyRetryCount(): void;
    get applyRetryCountInput(): number | undefined;
    private _clientCertificate?;
    get clientCertificate(): string | undefined;
    set clientCertificate(value: string | undefined);
    resetClientCertificate(): void;
    get clientCertificateInput(): string | undefined;
    private _clientKey?;
    get clientKey(): string | undefined;
    set clientKey(value: string | undefined);
    resetClientKey(): void;
    get clientKeyInput(): string | undefined;
    private _clusterCaCertificate?;
    get clusterCaCertificate(): string | undefined;
    set clusterCaCertificate(value: string | undefined);
    resetClusterCaCertificate(): void;
    get clusterCaCertificateInput(): string | undefined;
    private _configContext?;
    get configContext(): string | undefined;
    set configContext(value: string | undefined);
    resetConfigContext(): void;
    get configContextInput(): string | undefined;
    private _configContextAuthInfo?;
    get configContextAuthInfo(): string | undefined;
    set configContextAuthInfo(value: string | undefined);
    resetConfigContextAuthInfo(): void;
    get configContextAuthInfoInput(): string | undefined;
    private _configContextCluster?;
    get configContextCluster(): string | undefined;
    set configContextCluster(value: string | undefined);
    resetConfigContextCluster(): void;
    get configContextClusterInput(): string | undefined;
    private _configPath?;
    get configPath(): string | undefined;
    set configPath(value: string | undefined);
    resetConfigPath(): void;
    get configPathInput(): string | undefined;
    private _configPaths?;
    get configPaths(): string[] | undefined;
    set configPaths(value: string[] | undefined);
    resetConfigPaths(): void;
    get configPathsInput(): string[] | undefined;
    private _host?;
    get host(): string | undefined;
    set host(value: string | undefined);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _insecure?;
    get insecure(): boolean | cdktf.IResolvable | undefined;
    set insecure(value: boolean | cdktf.IResolvable | undefined);
    resetInsecure(): void;
    get insecureInput(): boolean | cdktf.IResolvable | undefined;
    private _loadConfigFile?;
    get loadConfigFile(): boolean | cdktf.IResolvable | undefined;
    set loadConfigFile(value: boolean | cdktf.IResolvable | undefined);
    resetLoadConfigFile(): void;
    get loadConfigFileInput(): boolean | cdktf.IResolvable | undefined;
    private _password?;
    get password(): string | undefined;
    set password(value: string | undefined);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _proxyUrl?;
    get proxyUrl(): string | undefined;
    set proxyUrl(value: string | undefined);
    resetProxyUrl(): void;
    get proxyUrlInput(): string | undefined;
    private _tlsServerName?;
    get tlsServerName(): string | undefined;
    set tlsServerName(value: string | undefined);
    resetTlsServerName(): void;
    get tlsServerNameInput(): string | undefined;
    private _token?;
    get token(): string | undefined;
    set token(value: string | undefined);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _username?;
    get username(): string | undefined;
    set username(value: string | undefined);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _exec?;
    get exec(): KubectlProviderExec | undefined;
    set exec(value: KubectlProviderExec | undefined);
    resetExec(): void;
    get execInput(): KubectlProviderExec | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
