import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServerVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/server_version#id ServerVersion#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/server_version#triggers ServerVersion#triggers}
    */
    readonly triggers?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/server_version kubectl_server_version}
*/
export declare class ServerVersion extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubectl_server_version";
    /**
    * Generates CDKTF code for importing a ServerVersion resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ServerVersion to import
    * @param importFromId The id of the existing ServerVersion that should be imported. Refer to the {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/server_version#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ServerVersion to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/alekc/kubectl/2.0.4/docs/resources/server_version kubectl_server_version} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServerVersionConfig = {}
    */
    constructor(scope: Construct, id: string, config?: ServerVersionConfig);
    get buildDate(): string;
    get gitCommit(): string;
    get gitVersion(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get major(): string;
    get minor(): string;
    get patch(): string;
    get platform(): string;
    private _triggers?;
    get triggers(): {
        [key: string]: string;
    };
    set triggers(value: {
        [key: string]: string;
    });
    resetTriggers(): void;
    get triggersInput(): {
        [key: string]: string;
    } | undefined;
    get version(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
